#include "SimpleDB/SimpleDB.h"

int main() {
  SimpleDB::LongColumn id = SimpleDB::LongColumn();
  SimpleDB::StringColumn name = SimpleDB::StringColumn(1000);
  SimpleDB::Column * columns[2] = {&id,&name};
  
  try {
    SimpleDB::Database db = SimpleDB::Database("eminence");    
    SimpleDB::Query query = db.newQuery();
    query.bind(columns, sizeof(columns)/sizeof(columns[0]));
    query.execute("SELECT contact_number, first_name FROM contacts LIMIT 10");
    
    while(query.fetchRow())
      std::cout << "ID: " << *columns[0] << " NAME: " << *columns[1] << std::endl;
    
    query.execute("SELECT contact_number, last_name FROM contacts LIMIT 5");
    while(query.fetchRow()) {
      std::cout << "ID: " << *columns[0] << " NAME: " << *columns[1] << std::endl;
      std::cout << "Some math " << id.value()*5 << " " << name.value().append(" adfad") <<
	std::endl;
    }
  } catch(SimpleDB::Database::Exception &s) {
    std::cerr << s << std::endl;
  } catch(SimpleDB::Column::UnboundException) {
    std::cerr << "A column was not bound!" << std::endl;
  }
  return 0;
}
    
