/* $Id: sing.h,v 1.17 2001/04/17 11:08:19 slay Exp $ */

#ifndef __SING_H__
#define __SING_H__

#include "ipcompat.h"
#include "misc.h"
#include "packet.h"

#ifdef STRANGE_BSD_BYTE
#define   FIX_IT(x) (x)
#define UNFIX_IT(x) (x)
#else                  
#define   FIX_IT(x) htons(x)
#define UNFIX_IT(x) ntohs(x)
#endif 


char *osfingers[]={
/* 0 */ "is not recognizable, try another ICMP type...sorry :(",
/* 1 */   "is a Window$ 98/NT/2K, Cisco or\n\
<*> similar network device... Let me see at least\n\
<*> 6 replies and i'll provide you a more accurated response ;)",
/* 2 */   "is a Window$ 98/NT/2K",
/* 3 */   "is a Cisco or similar network device",
/* 4 */   "is a UNIX (Linux, Solaris, *BSD, HP-UX, etc.)", 
/* 5 */   "is a UNIX (Linux, Solaris, *BSD, HP-UX, etc.),\n\
<*> Cisco or similar network device", 
/* 6 */   "is a Solaris 2.x or HP-UX 11.0x",
/* 7 */   "is not totally recognizable. It could\n\
<*> be Window$ or UNIX... Let me see at least 2 replies and\n\
<*> i'll provide you a more accurated response ;)",
/* 8 */   "is not totally recognizable. It could be\n\
<*> Window$, Cisco or similar network device... Let me see at\n\
<*> least 2 replies and i'll provide you a more accurated response ;)",
/* 9 */   "is any UNIX but Solaris 2.x/HP-UX 11.0x",
/* 10 */  "is a Window$ 95/98/NT",
/* 11 */  "is a Solaris 2.x",
/* 12 */  "is a HP-UX 10.x, AIX, ULTRIX, OpenVMS,\n\
Compaq Tru64 or Cisco device",
/* 13 */  "is a Linux 2.0.x or Compaq Tru64",
/* 14 */  "is a ULTRIX",
/* 15 */  "is a Window$ 2k"
                 };


/* Way of testing duplicates fetched from BSD ping. */
/* Credits are not mine but the respective author  */
#define	A(bit)		rcvd_tbl[(bit)>>3]	/* identify byte in array */
#define	B(bit)		(1 << ((bit) & 0x07))	/* identify bit in byte */
#define	SET(bit)	(A(bit) |= B(bit))
#define	CLR(bit)	(A(bit) &= (~B(bit)))
#define	TST(bit)	(A(bit) & B(bit))
/*
 * MAX_DUP_CHK is the number of bits in received table, i.e. the maximum
 * number of received sequence numbers we can keep track of.  Change 128
 * to 8192 for complete accuracy...
 */
#define	MAX_DUP_CHK	(8 * 128)


/************************/
/* Global variables ... */
/************************/
char rcvd_tbl[MAX_DUP_CHK / 8];
char buf[SIZE_BIG]; /* ICMP payload */
char buf_ip[SIZE_BIG+60+LIBNET_ETH_H]; /* Monster packet including MAC */ 
char *ip_opt_rcv;  /* Received IP Options Header */
char opt_len_rcv;  /* Length of received IP Options */
char quiet=0;
char Quiet=0;
char done=0;
char err_buf[LIBNET_ERRBUF_SIZE];

int uid;
int mx_dup_ck = MAX_DUP_CHK;
int sock;
int tam_icmp=0;
u_short df=0;
u_short rf=0;
u_short verbose = 0;
u_short is_pattern = 0;
u_short resolve = 1;
u_short reply_ok = 0;
u_short do_fingerprint = 0;
u_short bad_cksum = 0;
u_short mimic = 0;
u_short set_df = 0;
u_short set_rf = 0;
u_short os_finger=0;

struct libnet_link_int *network;
struct my_pack packet;
pcap_t *phandler = NULL;
struct timeval trecv; /* When rx */
struct timeval *tsend; /* When tx */

/* To improve speed on subsequents packets */
struct speedup { int s;
                 u_int len_pack;
                 u_int mtu;
                 u_int len_ipopt;
                 struct ip2 ip_p;
                 n_short *seq;
                 u_long *time;
                 u_short *cksum;
               } speed;

/* To maintain stats */
struct st { long nsent; /* Packets tx */
            long nrecv; /* Packets rx */
            long nrep;  /* Packets dup */
            float rtt_min;
            float rtt_max;
            float rtt_tot;
          } stats;

extern char *vers_date;
extern char max_gbg;
extern char **l_cod_t, **cod_r, **cod_u;
extern u_short max_cod_r,
               max_cod_u,
               max_l_cod_t;

/****************************/
/* ... end global variables */
/****************************/

#ifdef SOLARIS
extern char *sys_errlist[];
#endif

/***************************/
/* Functions prototypes... */
/***************************/
void adjust_sock( int );
int  build_icmp_err( struct my_pack * );
int build_icmp_info( struct my_pack * );
int add_garbage( u_long, int );
void fill_garbage( char *, u_long );
void  put_routers( struct my_pack *, struct id_rdiscovery * );
void     build_ip( int, u_long, int, int, int, int);
void build_pack( void );
void build_pack_libnet( void );
void    send2sock( int, char *, int, struct sockaddr * );

void            dont_print( struct ip2 *, struct icmp2 * );
void      print_info_reply( struct ip2 *, struct icmp2 * );
void print_timestamp_reply( struct ip2 *, struct icmp2 * );
void   print_address_reply( struct ip2 *, struct icmp2 * );
void    print_router_reply( struct ip2 *, struct icmp2 * );
void      print_echo_reply( struct ip2 *, struct icmp2 * );

void     print_dst_unreach( struct ip2 *, struct icmp2 * );
void      print_src_quench( struct ip2 *, struct icmp2 * );
void        print_redirect( struct ip2 *, struct icmp2 * );
void        print_time_xcd( struct ip2 *, struct icmp2 * );
void      print_param_prob( struct ip2 *, struct icmp2 * );

void   proto_tcp64( union data_hdr *, u_short, u_short );
void   proto_udp64( union data_hdr *, u_short, u_short );
void  proto_icmp64( union data_hdr *, u_short, u_short );
void proto_unknown( union data_hdr * );

void prepare_libpcap( void );
void  read_icmp( char * );
char *read_pcap( pcap_t *, u_int * );
void print_pack( char *, char *, int, u_char, u_char, u_short);
int    in_cksum( u_short *, int );
char *pasa( struct sockaddr_in * );
u_long day2milisecs( void );
void      go_out( short int, char *, ... );
void go_out_error( short int, char * );
void       help( void );
void handle_signals( void );
void timeout_func( int );
void term( int );
int posix_signal( int, void (*)() );
void init_log ( int, char**);
void write_log( u_short, char *, ... );
void finish_log(void);

void init_packet_struct( struct my_pack * );

void send_arp(u_long, u_char *);

extern void parse_args( int, char **, struct my_pack * );

#ifdef SOLARIS
extern long random();
extern void srandom( unsigned );
#endif

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)) || !defined(SOLARIS)  || !defined(OPENBSD)
extern u_char vrfy_sr(void);
#endif

extern void print_ip_opt( void );
extern int look4dev( struct mi_ifaz * );
/*******************************/
/* ...end functions prototypes */
/*******************************/


/*************************/
/* ICMP types handler... */
/*************************/
struct icmp_class {
                    char *name;
                    int  class;
                    int  reply;
                    void (*print_packet)( struct ip2 *, struct icmp2 *);
                  } icmp_info_or_err[]=
                  {
      { "Echo Reply", ICMP_INFO, NO_REPLY, print_echo_reply },
      { "Not implemented", 0, NO_REPLY, dont_print },
      { "Not implemented", 0, NO_REPLY, dont_print },
      { "Destination Unreach", ICMP_ERROR, NO_REPLY, print_dst_unreach },
      { "Source Quench", ICMP_ERROR, NO_REPLY, print_src_quench },
      { "Redirect", ICMP_ERROR, NO_REPLY, print_redirect },
      { "Not implemented", 0, NO_REPLY, dont_print },
      { "Not implemented", 0, NO_REPLY, dont_print },
      { "Echo Request", ICMP_INFO, ICMP_ECHO_REPLY, dont_print },
      { "Router Advertisement", ICMP_INFO, NO_REPLY, print_router_reply },
      { "Router Solicitation", ICMP_INFO, ICMP_ROUTER_ADVERT, dont_print },
      { "Time Exceeded", ICMP_ERROR, NO_REPLY, print_time_xcd },
      { "Parameter Problem", ICMP_ERROR, NO_REPLY, print_param_prob },
      { "Timestamp Request", ICMP_INFO, ICMP_TIMESTAMP_REPLY, dont_print },
      { "Timestamp Reply", ICMP_INFO, NO_REPLY, print_timestamp_reply },
      { "Info Request", ICMP_INFO, ICMP_INFO_REPLY, dont_print },
      { "Info Reply", ICMP_INFO, NO_REPLY, print_info_reply },
      { "Address Mask Request", ICMP_INFO, ICMP_ADDRESS_REPLY, dont_print },
      { "Address Mask Reply", ICMP_INFO, NO_REPLY, print_address_reply }
                  };



/***********************************/
/* Access to 64 bits protocol data */
/* to build an ICMP error packet.  */
/***********************************/
struct protocols {
                    int proto;
                    void (*func_proto)( union data_hdr *, u_short, u_short );
                 } data_protocols[] = {
                                        { IPPROTO_TCP,  proto_tcp64  },
                                        { IPPROTO_UDP,  proto_udp64  },
                                        { IPPROTO_ICMP, proto_icmp64 }
                                      }; 

#endif