=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: html generation, processing

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_HTML
  require 'pstore'
  require SiSU_lib + '/defaults'
  require SiSU_lib + '/html_table'
  require SiSU_lib + '/html_format_css'
  require SiSU_lib + '/html_segments'
  require SiSU_lib + '/html_scroll'
  include SiSU_HTML_seg
  include SiSU_HTML_Format_type
  require SiSU_lib + '/param'
  include SiSU_Param
  include SiSU_Viz
  require SiSU_lib + '/html_tune'
  include SiSU_Tune
  require SiSU_lib + '/metaverse'
  require SiSU_lib + '/conf_env'
  require SiSU_lib + '/shared_xml'
  class Source
    def initialize(opt)
      @opt=opt
    end
    def read
      songsheet
    end
    def songsheet
      begin
        @md=SiSU_Param::Parameters.new(@opt).get
        @fnb=@md.fnb
        @env=SiSU_Env::Info_env.new(@opt.fns)
        loc=@env.url.output_tell
        tool=if @opt.cmd =~/z/;   "#{@env.program.web_browser} #{loc}/#@fnb/#{@md.fn[:index]}"
        elsif @opt.cmd =~/[MVv]/; "#{@env.program.web_browser} #{loc}/#@fnb/#{@md.fn[:index]}"
        else                 ''
        end
        SiSU_Screen::Ansi.new(@opt.cmd,'HTML',tool).green_hi_blue unless @opt.cmd =~/q/
        SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.path.output_tell}/#@fnb/#{@md.fn[:index]}").flow if @opt.cmd =~/[MV]/
        SiSU_Env::Info_skin.new(@md).select
        SiSU_Viz::Url.new
        data=nil
        unless @md.markup =~/url_png/
          my_make=SiSU_Env::Create_file.new(@opt.cmd,@opt.fns,@md) #Beware #FIX opt and md, both not necessary
          my_make.mkdir_dirs #Beware
          @tuned_file_array=SiSU_HTML::Source::Html_environment.new(@md).tuned_file_instructions
          data=@tuned_file_array
        else
          data=IO.readlines(@opt.fns,'') #wasteful, not really necessary?
          SiSU_HTML_nav_tune::Tune.new(data,@md).songsheet
          @tuned_file_array=data #watch may not be what you want
        end
        scr_endnotes=SiSU_HTML::Source::Endnotes.new(data,@md).scroll unless @md.markup =~/url_png/
        toc=SiSU_HTML::Source::Toc.new(data,@md).songsheet
        doc_ver=SiSU_HTML::Source::Links_guide.new(data,@md).doc_versions
        links_guide=SiSU_HTML::Source::Links_guide.new(data,@md).toc
        data=@tuned_file_array
        scr_toc=SiSU_HTML::Source::Scroll_head_and_segtoc.new(data,@md,toc,links_guide,doc_ver).in_common
        SiSU_HTML::Source::Seg.new(data,@md).songsheet #if not_scroll_only
        data=@tuned_file_array
        scr=SiSU_HTML::Source::Scroll.new(data,@md).songsheet
        scroll=SiSU_HTML::Source::Scroll_output.new(scr_toc,scr[:body],scr_endnotes,scr[:metadata],scr[:owner_details],scr[:tails],@md).publish
        SiSU_HTML::Source::Output.new(scroll,@md).scroll
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
        unless @opt.cmd =~/[MV]/ #check maintenance flag
          texfiles = Dir["#{@env.path.tune}/#{@opt.fns}*"]
          texfiles.each do |f| 
            if FileTest.file?(f)
              File.unlink(f)
            end
          end
        end
        SiSU_Env::Create_file.new(@opt.cmd,@opt.fns).param_instantiate
        @@flag,@@scr,@@seg,@@seg_endnotes,@@seg_subtoc,@@seg_ad={},{},{},{},{},{}
        @@seg_total,@@tracker,@@loop_count,@@tablehead,@@number_of_cols=0,0,0,0,0
        @@seg_name,@@seg_name_html,@@seg_name_php,@@seg_subtoc_array,@@seg_endnotes_array,@@segtocband,@@tablefoot=Array.new(7){[]}
        @@filename_seg,@@seg_url,@@filename_segphp,@@fn,@@to_lev4,@@get_hash_to,@@get_hash_fn='','','','','','',''
        @@is4=@@is3=@@is2=@@is1=@@header1=@@header2=@@header3=@@header4=0
      end
    end
    private
    class Html_environment
      def initialize(md)
        @md=md
        @env,@css,@home,@symlnk=SiSU_Env::Info_env.new(@md.fns),SiSU_Style::CSS.new,SiSU_Viz::Home.new,SiSU_Env::Create_system_link.new
      end
      def suffix_linkname #not used at present
        sfx=if @md.cmd =~/h/; '.html'
        else                  ''
        end
      end
      def link_images
        @symlnk.images 
      end
      def directories
        my_make=SiSU_Env::Create_file.new(@md.cmd,@md.fns)
        @path={}
        @path[:root]=my_make.html_root
        title=File.basename(@md.fns,'.rb')
        my_make.mkdir_html
      end  
      def tuned_file_instructions 
        @env=SiSU_Env::Info_env.new(@md.fns)
        @tell=SiSU_Screen::Ansi.new(@md.cmd)
        if @md
          @md.sfx=''
          @md.file_type='php' if @md.cmd =~/z/
          @md.sfx='' if @md.cmd =~/z/
          if @md.cmd =~/h/ or @md.fns =~/\~[a-z]{2,3}\.s?/ #multilingual document protection is a bit arbitrary, (needed by existing server configuration), add configuration overide...
            if @md.cmd =~/H/ and @md.fns =~/\~[a-z]{2,3}\.s?/
              SiSU_Screen::Ansi.new(@md.cmd,
                'multilingual document, creating internal url links with filetype suffix',
                "\n\t\t(overriding -H request, using -h mode instead)"
              ).warn unless @md.cmd =~/q/
            end
            @md.sfx='.html'
            @md.pdf='.pdf'
          end
        end
        @md.cmd=@md.cmd.gsub(/H/,'h')
        @md.file_type='html' if @md.cmd =~/[hon]/
        directories
        newfilename=%{#{@env.path.output}/#{@md.fnb}/#{@md.fn[:index]}} if @md.file_type =~/html/
        my_make_source_file=SiSU_Env::Create_file.new(@md.cmd,@md.fns)
        @fnm=my_make_source_file.marshal_meta
        @tune_verse_marshal=my_make_source_file.marshal_tune
        if @md.markup !~/url_png/ and @md.cmd =~/[hozn]/
          metaverse_array=SiSU_Metaverse::Source.new(@md).get # metaverse file drawn here
          @tuned_file_array=SiSU_Tune::Tune.new(metaverse_array,@md).songsheet
        else
          SiSU_HTML_nav_tune::Tune.new(@file_array,@md).songsheet #no doc passed originally... 2004w35, revist changes in conditional 2006
        end
        require SiSU_lib + '/param'
        @tuned_file_array
      end
    end
    class Split_text_object
      include SiSU_Viz
      include SiSU_HTML_Format_type
      @@dp=nil
      attr_reader :format,:text,:ocn,:scroll_lev_para_ocn,:seg_lev_para_ocn
      def initialize(md,para)
        @md,@para=md,para
        @format,@ocn='null','null'
        #@format,@ocn=nil,nil
        @@dp ||=SiSU_Env::Info_env.new.digest.pattern
      end
      def lev_segname_para_ocn                                                   #needs work 2003w29
        if @para =~/^\d~.+?<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>.*/
          if @para[/([1-6])~(\S+)\s+(\S.+?)<~(\d+);(?:[ohmu]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/m]
            @format,segname,@text,@ocn=$1,$2,$3,$4
            @format="#@format~#{segname}" # 
          elsif @para[/([1-6]~)\s+(\S.+?)<~(\d+);(?:[ohmu]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/m]
            @format,@text,@ocn=$1,$2,$3 #,$4
          end
        else
          if @para[/^(?:_1\*|<:i[12]>\s*_\*)\s+(.+?)<~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/m]
            @format,@text,@ocn='_1*',$1,$2,$3
          elsif @para[/^(_\*)\s+(.+?)<~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/m]
            @format,@text,@ocn=$1,$2,$3
          elsif  @para[/<:(i[12])>\s*(.+?)<~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/m]
            @format,@text,@ocn=$1,$2,$3
          elsif @para[/<:(code|alt|verse|group)>(.+?)<~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/m]
            @format,@text,@ocn=$1,$2,$3
          elsif @para[/(.+?)<~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/m]
            @text,@ocn=$1,$2 #,$3
          end
          if @para !~/<~(\d+);(?:[ohu]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>|^$/ #added 2002w06
            @text=@para[/(.+?)/m,1]
          end
          if @para[/^(\d)~\S*\s+(.+)/m]
            @format,@text=$1,$2
          end
        end
        @seg_lev_para_ocn=if @para[/.+<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/]
          SiSU_HTML_Format_type::Format_seg.new(@md,@format,@text,@ocn)
        end
        @scroll_lev_para_ocn=if @para[/.+<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/]
          SiSU_HTML_Format_type::Format_scroll.new(@md,@format,@text,@ocn)
        end
        self
      end
    end
    class Links_guide
      @links_guide_toc=[]
      def initialize(data,md)
        @data,@md=data,md
      end
      def doc_versions
        format_head_toc=SiSU_HTML_Format_type::Head_toc.new(@md)
        @doc_versions_toc=format_head_toc.document_versions_toc
      end
      def toc
        @links_guide_toc=[]
        format_head_toc=SiSU_HTML_Format_type::Head_toc.new(@md)
        guide_type='horzontal' #values: horizontal or vertical
        @links_guide_toc << format_head_toc.links_guide_open(guide_type)
        if defined? @md.lnk and @md.lnk
          @md.lnk.each do |l|
            if defined? l[:say]
              target=if l[:url] !~/^\.(\.)?\//; 'external'
              else                              '_top'
              end
              s_lnk_url,s_lnk_lnk=l[:url],l[:say]
              lev_para_ocn=SiSU_HTML_Format_type::Format_toc.new(@md,s_lnk_url,s_lnk_lnk,target)
              @links_guide_toc << lev_para_ocn.links_guide if s_lnk_lnk
            end
          end
        end
        format_head_toc=SiSU_HTML_Format_type::Head_toc.new(@md)
        @links_guide_toc << format_head_toc.links_guide_close #(guide_type)
        @links_guide_toc
      end
    end
    class Endnotes
      include SiSU_Param
      include SiSU_HTML_Format_type
      def initialize(data,md)
        @data,@md=data,md
      end
      def scroll
        @scr_endnotes=[]
        format_head_scroll=SiSU_HTML_Format_type::Head_scroll.new(@md)
        @scr_endnotes << format_head_scroll.title_endnote
        @data.each do |para|
          pg=para.dup
          if pg =~/~[{\[][\d*+]+ <a name="_[\d*+]+"/
            endnote_array=[]
            if pg=~/~\{[\d*+].+?\}\~/m
              endnote_array << pg.scan(/~\{[\d*+]+(.+?)\}\~/m)
            end
            if pg=~/~\[[\d*]+\s.+?\]\~/m
              endnote_array << pg.scan(/~\[[\d*]+(.+?)\]\~/m)
            end
            if pg=~/~\[[\d+]+\s.+?\]\~/m
              endnote_array << pg.scan(/~\[[\d+]+(.+?)\]\~/m)
            end
            endnote_array.flatten.each do |note| 
              format_scroll=SiSU_HTML_Format_type::Format_scroll.new(@md,note) 
              @scr_endnotes << format_scroll.endnote_body
            end
          end
        end
        @scr_endnotes
      end
    end
    class Toc <Links_guide
      @@toc={ :seg=>[],:scr=>[] }
      @@seg_url=''
      @@dp,@@firstseg=nil,nil
      def initialize(data='',md=nil)
        @data,@md=data,md
        @url=SiSU_Viz::Url.new
        @png=SiSU_Viz::Png.new
        @table=SiSU_Viz::Table.new
        @font=SiSU_Viz::Font.new
        @@dp ||=SiSU_Env::Info_env.new.digest.pattern
        @pat_heading=/(?:[1-6]~\S*)?(.*)<~(\d+);(?:[hm]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>.*/
        @pat_strip_heading_name=/<a name="h?\d.*?">(.+?)<\/a>/
        @tell=SiSU_Screen::Ansi.new(@md.cmd)
      end
      def songsheet #extracts toc for scroll & seg
        SiSU_Screen::Ansi.new(@md.cmd,'Toc').txt_grey unless @md.cmd =~/q/
        toc=nil
        @@firstseg=nil
        @data.each do |para|
          if para =~/^\s*([1-6]~|4~!)/
            para_toc=para.dup
            para_toc.gsub!(/&nbsp;<a name="-[\d*+]+" href="#_[\d*+]+">&nbsp;<sup>[\d*+]+<\/sup>&nbsp;<\/a>\s+~[{\[].+?[}\]]~/m,'') #remove endnotes from toc
            toc=case para_toc
            when /^\s*1~(\S+)?/; Toc.new(para_toc,@md).level_1
            when /^\s*2~(\S+)?/; Toc.new(para_toc,@md).level_2
            when /^\s*3~(\S+)?/; Toc.new(para_toc,@md).level_3
            when /^\s*4~(\S+)?/; Toc.new(para_toc,@md).level_4 
            when /^\s*5~(\S+)?/; Toc.new(para_toc,@md).level_5
            when /^\s*6~(\S+)?/; Toc.new(para_toc,@md).level_6
            when /^\s*4~!/;      Toc.new(para_toc).level_crosslink
            else
            end
            if @@firstseg.nil? and para=~/4~\S+?/
              @@firstseg=/4~(\S+)?/.match(para)[1]
            end
            if toc
              begin
                @@toc[:seg] << toc[:seg] if toc[:seg]
                @@toc[:scr] << toc[:scr] if toc[:scr]
              rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
              end
            end
          end
        end
        @md.firstseg=@@firstseg
        @@toc
      end
    protected
      def rss #sort all wrong, disabled but kept
        @@toc[:seg] <<<<WOK
<center>
<table><tr><td>
<p><font color="#222222" #{@font.face} size="2">
(relatively static) RSS feeds for DOCUMENTS:<br />
<a href="../rssfeed/documents.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/documents.xml<br />
<a href="../rssfeed/tradelaw.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/tradelaw.xml<br />
<a href="../rssfeed/environmental.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/environmental.xml<br />
<center><a href="mailto:info@address.com" target="_top">info@address.com</a></center>
</font></p>
</td></tr></table>
WOK
      end
      def level_doc_owner_details
        if @md.stmp =~/\w\w/
          format_head_scroll=SiSU_HTML_Format_type::Head_scroll.new(@md)
          @@toc[:scr] << format_head_scroll.toc_owner_details
        end
      end
      def level_endnotes
        if @md.flag_endnotes
          format_head_scroll=SiSU_HTML_Format_type::Head_scroll.new(@md)
          @@toc[:scr] << format_head_scroll.toc_endnote
        end
      end
      def level_metadata
        format_head_toc=SiSU_HTML_Format_type::Head_toc.new(@md)
        @@toc[:scr] << format_head_toc.metadata
        @@toc[:seg] << format_head_toc.seg_metadata
      end
      def level_word_index
        format_head_toc=SiSU_HTML_Format_type::Head_toc.new(@d0c)
        @@toc[:scr] << format_head_toc.concordance
        @@toc[:seg] << format_head_toc.concordance
      end
      def level_1
        para=@data
        unless para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
          para.gsub!(@pat_strip_heading_name,'\1')
        end
        para[@pat_heading]
        linkname,link=$1,$2 if $&
        p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link and link !~/#/ #% keep eye on link
        title=unless para =~/Document Information/; linkname
        else
          link='metadata'
          %{<b><a href="#{@md.fnl[:pre]}#{link}#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}">#{linkname}</a></b>}
        end
        toc={}
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
        toc[:seg]=format_toc.lev1
        title=if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
          para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/,'')
          linkname
        else #if para =~/Document Information/
          @@toc[:scr] <<  '<br />'
          link='docinfo'
          %{<b><a href="##{link}">#{linkname}</a></b>}
        end
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
        toc[:scr]=format_toc.lev1
        toc
      end
      def level_2
        para=@data
        unless para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
          para.gsub!(@pat_strip_heading_name,'\1')
        end
        para[@pat_heading]
        linkname,link=$1,$2 if $&
        p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link and link !~/#/
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,linkname)
        toc={}
        toc[:seg]=format_toc.lev2
        if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
          para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/,'')
          title=linkname
        else title=%{#{p_num.goto}#{linkname}</a>}
        end
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
        toc[:scr]=format_toc.lev2
        toc
      end
      def level_3
        para=@data
        para.gsub!(@pat_strip_heading_name,'\1')
        para.gsub(/(.*?)<a name="(\d+)"><\/a>(.*)/,'\1') #2002w42 altered gsub! - problematic? - suspect
        para[@pat_heading]
        linkname,link=$1,$2 if $&
        p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link and link !~/#/
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,linkname)
        toc={}
        toc[:seg]=format_toc.lev3
        if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
          para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/,'')
          title=linkname
        else title=%{#{p_num.goto}#{linkname}</a>}
        end
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
        toc[:scr]=format_toc.lev3
        toc
      end
      def level_4
        para=@data
        unless para =~/~metadata/
          unless para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
            para.gsub!(@pat_strip_heading_name,'\1')
            para[@pat_heading]
            linkname,link=$1,$2 if $&
            p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link
          end
          para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/,'')
          if para =~/^4~/
            seg_link=para.gsub(/^\s*4~(\S+)\s+(.+?)$/,
              %{  <a href="#{@md.fnl[:pre]}\\1#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}" target="_top">
    \\2
  </a> })
            @@seg_url=para[/^\s*4~(\S+).+?$/,1]
          elsif para =~/\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+/
            seg_link=para.gsub(/^\s*(#{@md.lv4}\s+)\s*(\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+)(.*)/,
              %{<a href="#{@md.fnl[:pre]}\\2#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}" } +
              %{target="_top">\\1 \\2 \\3</a> })
          end
          p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link
          format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,seg_link)
          toc={}
          toc[:seg]=format_toc.lev4
          if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
            para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/,'')
            title=linkname
          else title=%{#{p_num.goto}#{linkname}</a>} if p_num
          end
          format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
          toc[:scr]=format_toc.lev4
          toc
        end
      end
      def level_5
        para=@data
        if para !~/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
          para.gsub!(@pat_strip_heading_name,'\1')
        end
        para[@pat_heading]
        linkname,link=$1,$2 if $&
        p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link and link !~/#/
        toc={}
        if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
          para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/,'')
          title=linkname
        else
          lnk_n_txt=%{  <a href="#{@md.fnl[:pre]}#{@@seg_url}#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}##{link}">
    #{linkname}
  </a>}
          format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,lnk_n_txt)
          toc[:seg]=format_toc.lev5
          title=%{#{p_num.goto}#{linkname}</a>}
        end
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
        toc[:scr]=format_toc.lev5
        toc
      end
      def level_6
        para=@data
        if para !~/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
          para.gsub!(@pat_strip_heading_name,'\1')
        end
        para[@pat_heading]
        linkname,link=$1,$2 if $&
        p_num=SiSU_HTML_Format_type::Paragraph_number.new(@md,link) if link and link !~/#/
        toc={}
        if para =~/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
          para.gsub!(/<~0;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/,'')
          title=linkname
        else
          lnk_n_txt=%{  <a href="#{@md.fnl[:pre]}#{@@seg_url}#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}##{link}">
    #{linkname}
  </a>}
          format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,lnk_n_txt)
          toc[:seg]=format_toc.lev6
          title=%{#{p_num.goto}#{linkname}</a>}
        end
        format_toc=SiSU_HTML_Format_type::Format_toc.new(@md,title)
        toc[:scr]=format_toc.lev6
        toc
      end
      def level_crosslink
        para=@data
        if para !~/4~!/
          para.gsub!(/4~!\s+(\S+)\s+(.+)/,
            %{<table><tr><td width =\"80\"></td>
  <td><a href="http://\\1" target="external">
    #{@png.crosslink_ext}
      &nbsp;&nbsp;\\2
    <\/a>
  </td></tr></table>
})
        else
          para.gsub!(/4~!\s+(\S+)\s+(.+)/,
            %{<table><tr><td width ="80">
  </td><td>
    <a href="\\1" target="_top">
      #{@png.crosslink}
        &nbsp;&nbsp;\\2
    <\/a>
  </td></tr></table>
})
        end
      end
    end
    class Scroll_head_and_segtoc < Toc
      def initialize(data,md='',toc='',links_guide_toc='',doc_versions_toc='')
        @data,@md,@toc,@links_guide_toc,@doc_versions_toc=data,md,toc,links_guide_toc,doc_versions_toc
        @txt=SiSU_Viz::Txt.new
        @url=SiSU_Viz::Url.new
        @table=SiSU_Viz::Table.new
      end
      def in_common
        toc_shared=[]
        @segtoc=[]
        SiSU_Screen::Ansi.new(@md.cmd,'Scroll & Segtoc').txt_grey unless @md.cmd =~/q/
        format_head_toc=SiSU_HTML_Format_type::Head_toc.new(@md)
        dochead=format_head_toc.head
        dochead.gsub!(/toc\.(html|php)/,'doc.\1') #kludge
        toc_shared << dochead
        @segtoc << format_head_toc.head
        toc_shared << format_head_toc.toc_head_escript if SiSU_HTML_Format_type::Head_toc.method_defined? :toc_head_escript
        @segtoc << format_head_toc.toc_head_escript if SiSU_HTML_Format_type::Head_toc.method_defined? :toc_head_escript
        toc_shared << format_head_toc.scroll_head_navigation_band
        if @md.dc_rights
          rights=format_head_toc.rights 
          rights=SiSU_Tune::Clean_html.new(rights).clean
        end
        if @md.prefix_b
          prefix_b=format_head_toc.prefix_b
          prefix_b=SiSU_Tune::Clean_html.new(prefix_b).clean
        end
        @seg_toc_band=format_head_toc.seg_head_navigation_band('pdf') #bug, vary depending on type of doc !! examine
        @segtoc << @seg_toc_band
        toc_shared << format_head_toc.scroll_head_title_banner_open
        @segtoc << format_head_toc.seg_head_title_banner_open
        tmp_head=nil
        doc_title_endnote=@md.title.gsub(/(\*+)/,'<sup><a href="#endnotes">\1</a></sup>')
        tmp_head="#{doc_title_endnote}\n"
          format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,tmp_head)
        toc_shared << format_txt_obj.center_bold
        @segtoc << format_txt_obj.center_bold
        if not @md.subtitle.nil? and not @md.subtitle.empty?
          tmp_head="#{@md.subtitle}\n"
          format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,tmp_head)
          toc_shared << format_txt_obj.center_bold
          @segtoc << format_txt_obj.center_bold
        end
        if @md.dc_creator
          creator_endnote=@md.dc_creator.gsub(/(\*+)/,%{&nbsp;<sup><a href="#notes">\\1</a></sup>})
          creator_endnote=%{<sup>&copy;</sup> #{creator_endnote}} if creator_endnote =~/\S/
          tmp_head="#{creator_endnote}"
          format_txt_obj=SiSU_HTML_Format_type::Format_text_object.new(@md,tmp_head)
          toc_shared << format_txt_obj.center_bold
          @segtoc << format_txt_obj.center_bold
        end
        toc_shared << format_head_toc.copyat
        @segtoc << format_head_toc.copyat
        toc_shared << "#{@table.close*1}\n"
        @segtoc << "#{@table.close*1}\n"
        tmp_head=nil
        if @md.prefix_a
          tmp_head ||= %{<p />#{@md.prefix_a}\n}
          toc_shared << tmp_head.dup
          @segtoc << tmp_head.dup
        end
        tmp_head=nil
        toc_shared << @doc_versions_toc
        toc_shared << @links_guide_toc
        toc_shared << rights if @md.dc_rights
        toc_shared << prefix_b if @md.prefix_b
        #Table of Contents added/appended here
        toc_shared << @toc[:scr]
        @segtoc << @doc_versions_toc
        @segtoc << @links_guide_toc
        @segtoc << @toc[:seg]
        @segtoc << rights if @md.dc_rights
        @segtoc << prefix_b if @md.prefix_b
        #Segtoc tail added here
        @segtoc << "</p>\n" #bugfix sort later DEBUGNOW
        @segtoc << @seg_toc_band
        @segtoc << format_head_toc.seg_navigation_tail
        Output.new(@segtoc.to_s,@md).segtoc
        @segtoc=[]
        @toc[:scr],@toc[:seg]=[],[]
        toc_shared
      end
    end
    class Table < SiSU_HTML_table::Table
    end
    class Scroll < SiSU_HTML_scroll::Scroll
    end
    class Scroll_output
      def initialize(scr_toc,scr_body,scr_endnotes,scr_metadata,scr_owner_details,scr_tails,doc)
        @scr_toc,@scr_body,@scr_endnotes,@scr_metadata,@scr_owner_details,@scr_tails,@md=scr_toc,scr_body,scr_endnotes,scr_metadata,scr_owner_details,scr_tails,doc
      end
      def publish
        scroll=[]
        scroll << @scr_toc << @scr_body << @scr_endnotes << @scr_metadata << @scr_owner_details << @scr_tails
        scroll.to_s
      end
    end
    class Seg < SiSU_HTML_seg::Seg
    end
    class Output
      include SiSU_Param
      @@dp=nil
      def initialize(data='',md='')
        @data,@md=data,md
        @my_make=SiSU_Env::Create_file.new(@md.cmd,@md.fns,@md)
        @@dp ||=SiSU_Env::Info_env.new.digest.pattern
      end
      def scroll
        begin
          @sisu=[]
          @data.each do |para|
            para.strip!
            para.gsub!(/<:.+?>/,'')
            unless para =~/^\s*$/
              para="#{para}\n" 
              @sisu << para
            end
          end
          @filename_html_scroll=@my_make.file_html_scroll(@md)
          new_file_data=@sisu.to_s
          @sisu=new_file_data.split(/\n\n/)
          @sisu.each {|para| @filename_html_scroll.puts para,"\n"}
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        end
      end
      def segtoc
        begin
          @sisu=[]
          @data.each do |para|
            para.strip!
            para.gsub!(/<(!.+?!|~\d+;(?:[ohm]|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp})>/,'')
            unless para =~/^\s*$/
              para="#{para}\n"
              @sisu << para
            end
          end
          new_file_data=@sisu.to_s
          @filename_html_segtoc=@my_make.file_html_segtoc(@md)
          @filename_html_index=@my_make.file_html_index(@md)
          @sisu=new_file_data.split(/\n\n/)
          @sisu.each {|para| @filename_html_segtoc.puts para,"\n"}
          @sisu.each {|para| @filename_html_index.puts para,"\n"}
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        end
      end
      def seg
        begin
          @sisu=[]
          @data.each do |para|
            para.strip!
            unless para =~/^\s*$/; @sisu << para
            end
          end
          new_file_data=@sisu.to_s
          @sisu=new_file_data.split(/\n\n/)
          @sisu.each {|para| @newfile.puts para,"\n"}
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        end
      end
    end
  end
end
__END__
