=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: html formating, css template

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_HTML_Format_type
  require SiSU_lib + '/html_format'
  require SiSU_lib + '/param'
  include SiSU_Param
  include SiSU_Viz
  include SiSU_HTML_Format
  class Head_toc < SiSU_HTML_Format::Head_toc
    def initialize(md='')
      super(md)
    end
    def head
      %{#{doc_type}
<head>
  <title>
    #{@md.html_title}
  </title>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
#{@rdf.rdftoc}
#{@rdf.metatag_html}
#{@css.html}
</head>
#{@color.body}
<a name="top" id="top"></a>
<a name="up" id="up"></a>
<a name="start" id="start"></a>
#{@js.top}} 
    end
    def concordance
      if @md.concord_make
      %{#{@margin.css}
  <h4 class="toc">
    <a href="./#{@md.fn[:concordance]}" #{@js.concordance}>
      <i>Concordance</i>
    </a>
  </h4>
#{@table.close}}
      else
      %{#{@margin.css}
#{@table.close}}
      end
    end
    def metadata
      %{#{@margin.css}
  <h4 class="toc">
    <a href="#@metalink" #{@js.metalink}>
      <i>MetaData</i>
    </a>
  </h4>
#{@table.close}}
    end
  end
  class Head_seg < SiSU_HTML_Format::Head_seg
    def initialize(md='')
      super(md)
    end
    def head
      %{#{doc_type}
<head>
  <title>
    #{@seg_name_html[@seg_name_html_tracker]} - 
    #{@md.html_title}
  </title>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
#{@rdf.rdfseg}
#{@rdf.metatag_html}
#{@css.html}
</head>
#{@color.body}
<a name="top" id="top"></a>
<a name="up" id="up"></a>
<a name="start" id="start"></a>
#{@js.top}} 
    end
    def toc_metadata
      @metalink=%{./#{@md.fn[:meatadata]}}
      toc_metadata
    end
    def title_banner(title,subtitle,creator)
      %{<p class="tiny">
    #{title}
  </p>
  <p class="tiny">
    #{subtitle}
  </p>
  <p class="tiny">
    #{creator}
  </p>
  <p class="tiny">
    copy @ 
    <a href="#{@url.home}">
      #{@txt.home}
    </a>
  </p>} 
    end
  end
  class Head_scroll < SiSU_HTML_Format::Head_scroll
    def initialize(md='')
      super(md)
    end
    def toc_endnote
      %{#{@margin.css}
  <h4 class="toc">
    <a href="#endnotes">
      Endnotes
    </a>
  </h4>
#{@table.close}}
    end
  end
  class Format_scroll < SiSU_HTML_Format::Format_text_object
    def initialize(md='',*txt)
      super(md,*txt)
    end
    def indent_one_no_paranum
      %{#{@margin.txt_1}
#{@paragraph.txt}
  #@one
#{@margin.num}
#{@table.close}}
    end
    def indent_two_no_paranum
      %{#{@margin.txt_1}
#{@paragraph.txt}
  #@one
#{@margin.num}
#{@table.close}}
    end
    def endnote_body
      %{#{@margin.css}
  <p class="endnote">
    #@one
  </p>
#{@margin.num_css}
  &nbsp;
#{@table.close}}
    end
    def header_normal
      %{#{@margin.css}
  <#@tag class="#@class" #{@p_num.id}>#{@p_num.name}
    #@headname
    #@parablock
  </#@tag>
#{@margin.num_css}
  #{@p_num.ocn_display}
#{@table.close}}
    end
    def heading_body
      @tag,@class='p','norm'
      header_normal
    end
    def heading_body1
      @tag,@class='h1','norm'
      header_normal
    end
    def heading_body2
      @tag,@class='h2','norm'
      header_normal
    end
    def heading_body3
      @tag,@class='h3','norm'
      header_normal
    end
    def heading_body4
      @tag,@class='h4','norm'
      header_normal
    end
    def heading_body5
      @tag,@class='h5','norm'
      header_normal
    end
    def heading_body6
      @tag,@class='h6','norm'
      header_normal
    end
  end
  class Format_seg < SiSU_HTML_Format::Format_text_object
    def initialize(md='',*txt)
      super(md,*txt)
    end
    def navigation_para
      %{#{@margin.css}
#{@paragraph.txt}
  #@one
</p>
#{@table.close}}
    end
    def navigation_toc_lev1_advert
      %{#{@banner.home_button}\n
<center>
#@one
#@two
</a></center><p />}
    end
    def navigation_toc_lev1
      %{#{@banner.nav_toc}}
    end
    def navigation_toc_lev2                                                      #change bold use css
      %{<p />
<table summary="navigation segment level 2">
<tr><td width ="20">
</td>
<td>
  <font size="3" #{@font.face}>
    <b>#@one</b>
  </font>
  </p>
#{@table.close}}
    end
    def navigation_toc_lev3                                                      #change bold use css
      %{<p />
<table summary="navigation segment level 3">
<tr><td width ="20">
</td>
<td>
  <font size="3" #{@font.face}>
    <b>#@one</b>
  </font>
  </p>
#{@table.close}}
    end
    def navigation_toc_lev4
      %{<table summary="navigation segment level 4">
<tr><td width ="80">
</td>
<td>
<p>
  #@one
</p>
#{@table.close}}
    end
    def navigation_toc_lev5
    end
    def navigation_toc_lev6
    end
    def endnote_body_seg_tail
      %{#{@margin.css}
  <p class="endnote">
    #@one
  </p>
#{@margin.num_css}&nbsp;
#{@table.close}}
    end
    def endnote_body_seg_tail_indent
      %{#{@margin.css}
  <p class="endnote_indent">
    #@one
  </p>
#{@margin.num_css}&nbsp;
#{@table.close}}
    end
    def endnote_seg_body(fn='')                                                  #url construction keep within single line... BUG WATCH 200408
      fn='doc' if fn.empty? #you may wish to reconsider, sends to 'doc' where no segment info
      %{#{@margin.css}
  <p class="endnote">
    #@one#{@md.fnl[:pre]}#{fn}#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}#@two#@three
  </p>
#{@margin.num_css}&nbsp;
#{@table.close}}
    end
    def title_header
      %{#{@margin.css}
  <#@tag class="#@class">
    #@one
  </#@tag>
#{@margin.num_css}&nbsp;
#@two
#{@table.close}}
    end
    def title_header1
      @tag,@class='h1','banner'
      title_header
    end
    def title_header2
      @tag,@class='h2','banner'
      title_header
    end
    def title_header3
      @tag,@class='h3','banner'
      title_header
    end
    def title_header4
      %{#{@margin.css}
  <h4 class="banner">
    #@one
  </h4>
#{@margin.num_css}&nbsp;
#{@table.close}}
    end
    def subtoc_lev
      one=if @one and @one =~/<\/?i>|<a\s+name="\S+?">/mi
        @one.gsub(/<\/?i>|<a\s+name="\S+?">/mi,'') #removes name markers from subtoc, go directly to substantive text
      else @one
      end
      note=''
      if one =~/(~[{\[].+?[}\]]~\s*)/m #this is a clumsy fix, revisit and address upstream
        note=$1
        note.gsub!(/[\n\s]+/m,' ')
        one.gsub!(/~[{\[].+?[}\]]~\s*/m,' ')
        one.gsub!(/<a[\n\s]+name="-\d+"[\n\s]+href="#_\d+">&nbsp;<sup>\d+<\/sup>&nbsp;/m,'')
      end
      %{<#@tag class="#@class">
    <a href="##@two">
      <i>#{one}</i>
    </a> #{note}
  </#@tag>}
    end
    def subtoc_lev5
      @tag,@class='h5','subtoc'
      subtoc_lev if @one
    end
    def subtoc_lev6
      @tag,@class='h6','subtoc'
      subtoc_lev if @one
    end
    #% para sisu
    def header4
      %{#@format
#{@margin.css}
  <h1 class="norm" #{@p_num.id}>#{@p_num.name}
    #@format
    #@parablock
  </h1>
#{@margin.num_css}
#{@p_num.ocn_display}
#{@table.close}}
    end
    def header_sub
      @parablock.gsub!(/~[{\[].+?[}\]]~\s*/m,' ')
      %{#{@margin.css}
#{@headname}
  <#@tag class="#@class" #{@p_num.id}>#{@p_num.name}
    #{@parablock}
  </#@tag>
#{@margin.num_css}
#{@p_num.ocn_display}
#{@table.close}}
    end
    def header5
      @tag,@class='p','bold'
      header_sub
    end
    def header6
      @tag,@class='p','bold'
      header_sub
    end
    def navigation_header4
      %{<table summary="navigation segment header 4" width=100% bgcolor="#08163f" border="0">
<tr><td align="center">
<p class="bold">
  #@parablock
</p>
#{@table.close}}
    end
    def navigation_header5
      %{<p class="bold">
  #@parablock
</p>}
    end
    def navigation_header6
      %{<p class="bold">
  #@parablock
</p>}
    end
    def navigation_indent1
      %{#{@margin.txt_00_1}
#{@paragraph.txt_00}
    #@parablock
  </font>
  </p>
#{@margin.num_css}&nbsp;
#{@table.close}}
    end
    def navigation_indent2
    end
    def navigation_center
      "<center>#@parablock</center>"
    end
  end
  class Format_toc < SiSU_HTML_Format::Format_text_object
    def initialize(md='',*txt)
      super(md,*txt)
    end
    def links_guide
      dir=SiSU_Env::Info_env.new(@md.fns)
      %{  <li class="doc">
    <a href="#@link" Target="#@three">
      #@linkname
    </a> 
  </li>
}
    end    
    def lev
  %{<#@tag class="#@class">
    #@one
  </#@tag>
}
    end
    def lev1
      @tag,@class='h1','toc'
      lev
    end
    def lev2
      @tag,@class='h2','toc'
      lev
    end
    def lev3
      @tag,@class='h3','toc'
      lev
    end
    def lev4
      @tag,@class='h4','toc'
      lev
    end
    def lev5
      @tag,@class='h5','toc'
      lev
    end
    def lev6
      @tag,@class='h6','toc'
      lev
    end
  end
end
__END__
