/* Public domain. */

#ifndef FMTSCAN_INTERNAL_H
#define FMTSCAN_INTERNAL_H

#include "uint64.h"

#define SCANU(abbr, type, n) \
unsigned int abbr##_scan_base (char const *s, type *u, unsigned char base) \
{ \
  uint64 result ; \
  register unsigned int pos = uint64_scan_upto_base(s, &result, n, base) ; \
  if (pos) *u = (type)result ; \
  return pos ; \
} \

#define SCANU0(abbr, type, n) \
unsigned int abbr##0_scan_base (register char const *s, register type *u, unsigned char base) \
{ \
  uint64 result ; \
  register unsigned int pos = uint640_scan_upto_base(s, &result, n, base) ; \
  if (pos) *u = (type)result ; \
  return pos ; \
} \

#endif
