#include "skyeye_arch.h"
#include "skyeye_config.h"
#include <stdlib.h>

#define ARM_ARCH
#define BFIN_ARCH
#define COLDFIRE_ARCH
arch_config_t *skyeye_archs[MAX_SUPP_ARCH];

#ifdef ARM_ARCH
extern void init_arm_arch ();
#endif

#ifdef BFIN_ARCH
extern void init_bfin_arch ();
#endif

#ifdef COLDFIRE_ARCH
extern void init_coldfire_arch ();
#endif

void
initialize_all_arch ()
{
	int i;
	for (i = 0; i < MAX_SUPP_ARCH; i++) {
		skyeye_archs[i] = NULL;
	}
#ifdef ARM_ARCH
	/*register arm_arch */
	init_arm_arch ();
#endif

#ifdef BFIN_ARCH
	/*register bfin_arch */
	init_bfin_arch ();
#endif

//koodailar add this for mingw 2005.12.18---------------------------------------
//there is something wrong with Makefile  for Dev-cpp
//so i remove it.
#ifndef __MINGW32__
#ifdef COLDFIRE_ARCH
	/* register coldfire_arch */
	init_coldfire_arch ();
#endif
#endif
//end koodailar ----------------------------------------------------------------
}

/*register a supported arch to skyeye_archs*/
void
register_arch (arch_config_t * arch)
{
	int i;
	for (i = 0; i < MAX_SUPP_ARCH; i++) {
		if (skyeye_archs[i] == NULL) {
			skyeye_archs[i] = arch;
			return;
		}
	}

}
