static variable gray_idle = 0;
static variable window = NULL;

define gray_idle_func (preview)
{
  static variable count = 1;
  variable buf = Unsigned_Char_Type[256];
  variable i, j;

  for (i = 0; i < 256; i++)
    {
      for (j = 0; j < 256; j++)
	buf[j] = i + j + count;

      gtk_preview_draw_row (preview, buf, 0, i, 256);
    }

  count += 1;

  gtk_widget_draw (preview, NULL);

  return TRUE;
}

define gray_preview_destroy (widget, window_ref)
{
  gtk_idle_remove (gray_idle);
  gray_idle = 0;
  @window = NULL;
}

define create_gray_preview (button_ignored)
{
  variable preview;
  variable buf = Unsigned_Char_Type[256];
  int i, j;

  if (window == NULL) {

      window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

      () = gtk_signal_connect (window, "destroy",
			  &gray_preview_destroy, &window);

      gtk_window_set_title (window, "test");
      gtk_container_set_border_width ( window, 10);

      preview = gtk_preview_new (GTK_PREVIEW_GRAYSCALE);
      gtk_preview_size (preview, 256, 256);
      gtk_container_add ( window, preview);

      for (i = 0; i < 256; i++)
	{
	  for (j = 0; j < 256; j++)
	    buf[j] = i + j;

	  gtk_preview_draw_row (preview, buf, 0, i, 256);
	}

	BOMB
      gray_idle = gtk_idle_add ((GtkFunction) gray_idle_func, preview);
    }

  if (gtk_widget_visible (window))
    gtk_widget_destroy (window);
  else
    gtk_widget_show_all (window);
}
