
static define create_option_menu(list)
{
   variable item, menu = gtk_menu_new();
   foreach (list) {
	item = ();
	item = gtk_image_menu_item_new_with_label(item);
	% Render each item, so menu can "know" size of its largest element
	gtk_widget_show(item);
	gtk_menu_shell_append(menu,item);
   }
  
   variable omenu = gtk_option_menu_new();
   gtk_option_menu_set_menu(omenu,menu);
   return omenu;
}

static define toggle_orientation (widget, pbar)
{
   !if (gtk_widget_mapped (widget))
	return;

   gtk_progress_bar_set_orientation(pbar, gtk_option_menu_get_history(widget) );
}

static define toggle_show_text (widget, pdata)
{
   pdata.showtext = not pdata.showtext;
   if (pdata.showtext)
       gtk_progress_bar_set_text(pdata.pbar,
	     			sprintf ("%.0f%%", pdata.fraction*20) );
   else
       gtk_progress_bar_set_text(pdata.pbar,"");
}

static define toggle_style (widget, pbar)
{
   !if (gtk_widget_mapped (widget))
	return;

   gtk_progress_bar_set_bar_style (pbar, gtk_option_menu_get_history(widget) );
}

static define pbar_cycle(pdata)
{
   pdata.fraction = (pdata.fraction + 1) mod 11;
   gtk_progress_bar_set_fraction(pdata.pbar, pdata.fraction * 0.1);
   if (pdata.showtext)
	gtk_progress_bar_set_text (pdata.pbar,
	      			sprintf ("%.0f%%",pdata.fraction*10) );

   return TRUE;
}

static define pbar_destroy(win,pdata)
{
   gtk_timeout_remove(pdata.timer);
   pdata.win = NULL;
   pdata.timer = 0;
}

public define create_progbar (test)
{
   variable items1 = [ "Left-Right", "Right-Left", "Bottom-Top", "Top-Bottom" ];
   variable items2 = [ "Continuous", "Discrete" ];

   if (test.data == NULL) {

	test.data = struct { win, pbar, timer, showtext, fraction };
	test.data.timer    = 0;
	test.data.showtext = 0;
	test.data.fraction = 0;
   }
   variable pdata = test.data;

   if (pdata.win == NULL) {

	pdata.win = gtk_dialog_new ();
	gtk_window_set_resizable(pdata.win, FALSE);

	gtk_window_set_title (pdata.win, "GtkProgressBar");
	gtk_container_set_border_width (pdata.win, 0);

	variable vbox = gtk_vbox_new (FALSE, 5);
	gtk_container_set_border_width ( vbox, 10);
	gtk_box_pack_start ( gtk_dialog_get_vbox(pdata.win), vbox,FALSE,TRUE,0);

	variable frame = gtk_frame_new ("Progress");
	gtk_box_pack_start (vbox, frame, FALSE, TRUE, 0);
	variable align = gtk_alignment_new (0.5, 0.5, 0, 0);
	gtk_container_add(frame, align);

	pdata.pbar = gtk_progress_bar_new();
	gtk_container_add(align,pdata.pbar);

	variable vbox2 = gtk_vbox_new (FALSE, 5);
	gtk_box_pack_start (vbox, vbox2, FALSE, TRUE, 0);

	frame = gtk_frame_new ("Options");
	gtk_box_pack_start (vbox, frame, FALSE, TRUE, 0);

	vbox2 = gtk_vbox_new (FALSE, 5);
	gtk_container_add ( frame, vbox2);

	variable tab = gtk_table_new (7, 2, FALSE);
	gtk_box_pack_start ((vbox2), tab, FALSE, TRUE, 0);

	variable label = gtk_label_new ("Orientation :");
	gtk_table_attach ( tab, label, 0, 1, 0, 1,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			5, 5);
	gtk_misc_set_alignment (label, 0, 0.5);

	variable omenu1 = create_option_menu (items1);
	variable hbox = gtk_hbox_new (FALSE, 0);
	gtk_table_attach ( tab, hbox, 1, 2, 0, 1,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			5, 5);
	gtk_box_pack_start (hbox, omenu1, TRUE, TRUE, 0);
	() = g_signal_connect(omenu1,"changed",&toggle_orientation,pdata.pbar);
     
	variable check = gtk_check_button_new_with_label ("Show text");
	() = g_signal_connect (check, "clicked",
				&toggle_show_text, pdata);
	gtk_table_attach ( tab, check, 0, 1, 1, 2,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			5, 5);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_table_attach ( tab, hbox, 1, 2, 1, 2,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			5, 5);

	label = gtk_label_new ("Bar Style :");
	gtk_table_attach ( tab, label, 0, 1, 3, 4,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			5, 5);
	gtk_misc_set_alignment (label, 0, 0.5);

	variable omenu2 = create_option_menu (items2);
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_table_attach ( tab, hbox, 1, 2, 3, 4,
			GTK_EXPAND | GTK_FILL, GTK_EXPAND | GTK_FILL,
			5, 5);
	gtk_box_pack_start (hbox, omenu2, TRUE, TRUE, 0);
	() = g_signal_connect(omenu2,"changed",&toggle_style,pdata.pbar);

	pdata.timer = gtk_timeout_add(100, &pbar_cycle, pdata);

	test.lower = gtk_button_new_with_label ("Close");

	() = g_signal_connect_swapped (test.lower,"clicked",
					&gtk_widget_destroy, pdata.win);

	gtk_box_pack_start (gtk_dialog_get_action_area(pdata.win), 
			  		test.lower, TRUE, TRUE, 0);

	() = g_signal_connect(pdata.win,"destroy", &pbar_destroy,pdata);
   }

   if (gtk_widget_visible (pdata.win))
	gtk_widget_destroy (pdata.win);
   else 
	gtk_widget_show_all (pdata.win);
}
