static variable window = NULL;

define create_tooltips (test)
{
   if (window == NULL) {

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(window,0);
	gtk_window_set_title(window, "Tooltips");
	gtk_widget_set_usize(window,200,240);

	variable tooltips = gtk_tooltips_new();
	() = g_signal_connect (window,"destroy",&gtk_widget_destroyed,&window);

	% Ensure tooltips persist as long as the window does
	g_object_set_data(window,"ttips",tooltips);
      
	variable vbox = gtk_vbox_new (FALSE, 10);
	gtk_container_add ( window, vbox);
	gtk_container_set_border_width (vbox, 5);

	variable button = gtk_toggle_button_new_with_label ("button1");
	gtk_box_pack_start (vbox, button, TRUE, TRUE, 0);

	gtk_tooltips_set_tip (tooltips,button,"This is button 1",
			"ContextHelp/buttons/1");

	button = gtk_toggle_button_new_with_label ("button2");
	gtk_box_pack_start (vbox, button, TRUE, TRUE, 0);

	gtk_tooltips_set_tip (tooltips,
			button,
			"This is button 2, showing a long tooltip which "+
			"likely won't fit on a single line, in which case "+
			"it will be wrapped onto a second line.",
			"ContextHelp/buttons/2_long");

	variable toggle = gtk_toggle_button_new_with_label ("GtkTipsQuery???");
	gtk_box_pack_start (vbox, toggle, TRUE, TRUE, 0);

	gtk_tooltips_set_tip (tooltips, toggle, "Remember, GtkTipsQuery was "+
		"deprecated in Gtk2.0, so it's not in SLgtk!","yada, yada");

	test.lower = generic_close_button(vbox,window);
	gtk_tooltips_set_tip (tooltips, test.lower,
				"Push this button to close window",
				"ContextHelp/buttons/Close");
    }

   if (gtk_widget_visible (window))
	gtk_widget_destroy (window);
   else
	gtk_widget_show_all (window);
}
