% -*- slang -*-
%
% This file is part of SLgtk: S-Lang language bindings for GTK+.
% Copyright (C) 2002 Michael S. Noble <mnoble@cfa.harvard.edu>
% 
% This library is free software; you can redistribute it and/or
% modify it under the terms of the GNU Library General Public
% License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
% 
% This library is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
% Library General Public License for more details.
% 
% You should have received a copy of the GNU Library General Public
% License along with this library; if not, write to the
% Free Software Foundation, Inc., 59 Temple Place - Suite 330,
% Boston, MA 02111-1307, USA.

variable s1, s2, pasted;
define paste_struct()
{
   switch(_NARGS)
	{ case 2 : (s1,s2) = (); }
	{ usage(sprintf("%s (struct1,struct2)",_function_name));}

   % Convenience: allow structures to be referenced by name, not
   % just instance (which is useful for generic object creation)
   if (typeof(s1) == String_Type)
	eval(sprintf("s1 = @%s;",s1));
   if (typeof(s2) == String_Type)
	eval(sprintf("s2 = @%s;",s2));

   variable s1names = get_struct_field_names(s1);
   variable s2names = get_struct_field_names(s2);
   variable name,names = strjoin(s1names,",");
   foreach(s2names) {
      name = ();
      if (not(is_list_element(names,name,',')))
	 names = strcat(names,",",name);
   }
   eval(sprintf("pasted = struct{%s};",names));
   foreach(s1names) {
	name = ();
	set_struct_field(pasted,name,get_struct_field(s1,name));
   }
   foreach(s2names) {
	name = ();
	set_struct_field(pasted,name,get_struct_field(s2,name));
   }
   return pasted;
}
