-- This file is part of SmartEiffel The GNU Eiffel Compiler Tools and Libraries
--
-- SmartEiffel is  free software;  you can redistribute it and/or  modify it
-- under  the terms of the  GNU General Public License, as published by  the
-- Free Software Foundation; either version 2, or (at your option) any later
-- version.
-- SmartEiffel is distributed in the hope that it will be useful but WITHOUT 
-- ANY WARRANTY;  without  even the implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
-- more details.  You should have received a copy of  the GNU General Public
-- License along with SmartEiffel;  see the file COPYING.  If not,  write to
-- the Free Software Foundation,  Inc., 59 Temple Place - Suite 330,  Boston, 
-- MA 02111-1307, USA.
--
-- Copyright(C) 1994-2002: INRIA - LORIA (INRIA Lorraine) - ESIAL U.H.P.
--			   - University of Nancy 1 - FRANCE
-- Copyright(C) 2003:      INRIA - LORIA (INRIA Lorraine) - I.U.T. Charlemagne
--			   - University of Nancy 2 - FRANCE
--
--		 Dominique COLNET, Suzanne COLLIN, Olivier ZENDRA,
--			   Philippe RIBET, Cyril ADRIAN
--
-- http://SmartEiffel.loria.fr - SmartEiffel@loria.fr
--
deferred class FROZEN_STRING_LIST
   --
   -- Shared Frozen String list.
   --

feature {NONE} -- The keywords section:

   fz_adapt:              STRING is "adapt"
   fz_alias:              STRING is "alias"
   fz_all:                STRING is "all"
   fz_as:                 STRING is "as"
   fz_assertion:          STRING is "assertion"
   fz_boost:              STRING is "boost"
   fz_check:              STRING is "check"
   fz_class:              STRING is "class"
   fz_cluster:            STRING is "cluster"
   fz_create:             STRING is "create"
   fz_creation:           STRING is "creation"
   fz_debug:              STRING is "debug"
   fz_default:            STRING is "default"
   fz_deferred:           STRING is "deferred"
   fz_do:                 STRING is "do"
   fz_else:               STRING is "else"
   fz_elseif:             STRING is "elseif"
   fz_end:                STRING is "end"
   fz_ensure:             STRING is "ensure"
   fz_exclude:            STRING is "exclude"
   fz_expanded:           STRING is "expanded"
   fz_export:             STRING is "export"
   fz_external:           STRING is "external"
   fz_false:              STRING is "False"
   fz_feature:            STRING is "feature"
   fz_from:               STRING is "from"
   fz_frozen:             STRING is "frozen"
   fz_generate:           STRING is "generate"
   fz_if:                 STRING is "if"
   fz_include:            STRING is "include"
   fz_indexing:           STRING is "indexing"
   fz_infix:              STRING is "infix"
   fz_inherit:            STRING is "inherit"
   fz_inline:             STRING is "inline"
   fz_inspect:            STRING is "inspect"
   fz_invariant:          STRING is "invariant"
   fz_is:                 STRING is "is"
   fz_like:               STRING is "like"
   fz_local:              STRING is "local"
   fz_loop:               STRING is "loop"
   fz_macro:              STRING is "macro"
   fz_no:                 STRING is "no"
   fz_obsolete:           STRING is "obsolete"
   fz_old:                STRING is "old"
   fz_once:               STRING is "once"
   fz_option:             STRING is "option"
   fz_prefix:             STRING is "prefix"
   fz_redefine:           STRING is "redefine"
   fz_rename:             STRING is "rename"
   fz_require:            STRING is "require"
   fz_rescue:             STRING is "rescue"
   fz_retry:              STRING is "retry"
   fz_runtime:            STRING is "runtime"
   fz_select:             STRING is "select"
   fz_separate:           STRING is "separate"
   fz_basic_:             STRING is "basic_"
   fz_reference:          STRING is "reference"
   fz_signature:          STRING is "signature"
   fz_strip:              STRING is "strip"
   fz_then:               STRING is "then"
   fz_trace:              STRING is "trace"
   fz_true:               STRING is "True"
   fz_undefine:           STRING is "undefine"
   fz_unique:             STRING is "unique"
   fz_until:              STRING is "until"
   fz_use:                STRING is "use"
   fz_variant:            STRING is "variant"
   fz_when:               STRING is "when"
   fz_yes:                STRING is "yes"

feature {NONE} -- Most of them are command flag names:

   fz_case_insensitive:      STRING is "case_insensitive"
   fz_cc:                    STRING is "cc"
   fz_cecil:                 STRING is "cecil"
   fz_clean:                 STRING is "clean"
   fz_c_mode:                STRING is "c_mode"
   fz_gc_info:               STRING is "gc_info"
   fz_help:                  STRING is "help"
   fz_high_memory_compiler:  STRING is "high_memory_compiler"
   fz_loadpath:              STRING is "loadpath"
   fz_manifest_string_trace: STRING is "manifest_string_trace"
   fz_no_main:               STRING is "no_main"
   fz_no_split:              STRING is "no_split"
   fz_no_strip:              STRING is "no_strip"
   fz_no_style_warning:      STRING is "no_style_warning"
   fz_no_warning:            STRING is "no_warning"
   fz_o:                     STRING is "-o"
   fz_safety_check:          STRING is "safety_check"
   fz_sedb:                  STRING is "sedb"
   fz_verbose:               STRING is "verbose"
   fz_version:               STRING is "version"
   fz_wedit:                 STRING is "wedit"

feature {NONE} -- Most of them are message parts:

   fz_arrow_id:          STRING is "->id"
   fz_bad_anchor:        STRING is "Bad anchor."
   fz_bad_argument:      STRING is "Bad argument."
   fz_bad_arguments:     STRING is "Bad arguments."
   fz_bad_assertion:     STRING is "Bad Assertion."
   fz_bcv:               STRING is "Bad CHARACTER value."
   fz_bga:               STRING is "Bad generic argument."
   fz_biv:               STRING is "Bad INTEGER value."
   fz_bnga:              STRING is "Bad number of generic arguments."
   fz_blhsoa:            STRING is "Bad left hand side of assignment."
   fz_brhsoa:            STRING is "Bad right hand side of assignment."
   fz_cad:               STRING is "Cyclic anchored definition."
   fz_cbe:               STRING is " cannot be expanded. "
   fz_cnf:               STRING is "Class not found."
   fz_dot_blank:         STRING is ". "
   fz_dot_new_line:      STRING is ".%N"
   fz_dtideena: STRING is " has no compiler-defined `deep_twin' or `is_deep_equal' %
		%because the corresponding allocated size is not part of the %
		%NATIVE_ARRAY object. The client class of this NATIVE_ARRAY %
		%type is supposed to use a `capacity' attribute which contains %
		%the corresponding number of allocated items (see STRING or %
                %ARRAY for example)."
   fz_error_stars:       STRING is "****** "
   fz_feature_not_found: STRING is "Feature not found"
   fz_iinaiv:            STRING is "It is not an INTEGER value."
   fz_ich:               STRING is "Incompatible headings."
   fz_is_invalid:        STRING is " is invalid."
   fz_is_not_boolean:    STRING is " is not BOOLEAN."
   fz_jvm_error:         STRING is "Incompatible with Java bytecode."
   fz_not_found:         STRING is "%" not found."
   fz_vuar4:             STRING is "The $ operator must be followed by the %
			           %final name of a feature which is not a %
				   %constant attribute (VUAR.4)."
   fz_ffinap: STRING is "Feature found is not a procedure."

feature {NONE} -- SCOOP-related strings:

   -- SCR means Separateness Consistency Rule
   -- SCR.1 is just a conformance rule (so that message won't be displayed...)

   fz_sc1: STRING is "If the source of an attachment (assignment instruction or assignment passing) is separate, its target entity must be separate too (SCR.1)."
   fz_sc2: STRING is "If an actual argument of a separate call is of a reference type, the corresponding formal argument must be declared as separate (SCR.2)."

   fz_sc4: STRING is "If an actual argument of a separate call is of an expanded type, its base class may not include, directly or indirectly, any non-separate attribute of a reference type (SCR.4)."

   fz_st0_star:                 STRING is "sT0*"

feature {NONE} -- Some other names:

   fz_access:                  STRING is "access"
   fz_b:                       STRING is "B"
   fz_bin:                     STRING is "bin"
   fz_caller:                  STRING is "caller"
   fz_char:                    STRING is "char"
   fz_close_c_comment:         STRING is "*/"
   fz_cast_gcfsh_star:         STRING is "(gcfsh*)"
   fz_cast_gcnah_star:         STRING is "(gcnah*)"
   fz_cast_t0_star:            STRING is "(T0*)"
   fz_cast_void_star:          STRING is "(void*)"
   fz_compact:                 STRING is "compact"
   fz_c_eq:                    STRING is "=="
   fz_c_if_neq_null:           STRING is "if(NULL!="
   fz_c_if_eq_null:            STRING is "if(NULL=="
   fz_c_neq:                   STRING is "!="
   fz_c_no_args_procedure:     STRING is "();%N"
   fz_c_no_args_function:      STRING is "()"
   fz_c_shift_left:            STRING is "<<"
   fz_c_shift_right:           STRING is ">>"
   fz_c_void_args:             STRING is "(void)"
   fz_define:                  STRING is "define"
   fz_eq_h:                    STRING is "=H"
   fz_exit:                    STRING is "exit"
   fz_extern:                  STRING is "extern "
   fz_eiffel_root_object:      STRING is "eiffel_root_object"
   fz_equals:                  STRING is "equals"
   fz_gc:                      STRING is "gc"
   fz_gc_lib:                  STRING is "gc_lib"
   fz_gc_mark:                 STRING is "gc_mark"
   fz_gc_sweep:                STRING is "gc_sweep"
   fz_gc_sweep_chunk:          STRING is "gc_sweep_chunk"
   fz_get:                     STRING is "get"
   fz_i:                       STRING is "I"
   fz_install:                 STRING is "install"
   fz_int:                     STRING is "int"
   fz_iostream:                STRING is "iostream"
   fz_j:                       STRING is "J"
   fz_java_io_inputstream:     STRING is "java/io/InputStream"
   fz_java_io_outputstream:    STRING is "java/io/OutputStream"
   fz_java_lang_class:         STRING is "java/lang/Class"
   fz_java_lang_boolean:       STRING is "java/lang/Boolean"
   fz_java_lang_byte:          STRING is "java/lang/Byte"
   fz_java_lang_character:     STRING is "java/lang/Character"
   fz_java_lang_double:        STRING is "java/lang/Double"
   fz_java_lang_float:         STRING is "java/lang/Float"
   fz_java_lang_integer:       STRING is "java/lang/Integer"
   fz_java_lang_long:          STRING is "java/lang/Long"
   fz_java_lang_math:          STRING is "java/lang/Math"
   fz_java_lang_object:        STRING is "java/lang/Object"
   fz_java_lang_reflect_method:   STRING is "java/lang/reflect/Method"
   fz_java_lang_short:         STRING is "java/lang/Short"
   fz_java_lang_string:        STRING is "java/lang/String"
   fz_java_lang_system:        STRING is "java/lang/System"
   fz_java_util_bitset:        STRING is "java/util/BitSet"
   fz_jvm_root:                STRING is "_any"
   fz_link:                    STRING is "link"
   fz_main:                    STRING is "main"
   fz_max_value:               STRING is "MAX_VALUE"
   fz_min_value:               STRING is "MIN_VALUE"
   fz_new:                     STRING is "new"
   fz_new_chunk:               STRING is "new_chunk"
   fz_no_check:                STRING is "no_check"
   fz_none:                    STRING is "none"
   fz_null:                    STRING is "NULL"
   fz_open_c_comment:          STRING is "/*"
   fz_printf:                  STRING is "printf"
   fz_return:                  STRING is "return"
   fz_s:                       STRING is "S"
   fz_smarteiffel:             STRING is "SmartEiffel"
   fz_seconf:                  STRING is "SmartEiffel" -- the environment name pointing on the config file
   fz_se_cmpt:                 STRING is "se_cmpT"
   fz_se_i:                    STRING is "se_i"
   fz_set:                     STRING is "set"
   fz_size:                    STRING is "size"
   fz_sizeof:                  STRING is "sizeof"
   fz_se_runtime:              STRING is "SmartEiffelRuntime"
   fz_static:                  STRING is "static "
   fz_struct:                  STRING is "struct"
   fz_sys:                     STRING is "sys"
   fz_system_se:               STRING is "system.se"
   fz_t0_star:                 STRING is "T0*"
   fz_t7_star:                 STRING is "T7*"
   fz_to_t:                    STRING is "toT"
   fz_type:                    STRING is "type"
   fz_typedef:                 STRING is "typedef "
   fz_unsigned:                STRING is "unsigned"
   fz_unlink:                  STRING is "unlink"
   fz_void:                    STRING is "void"
   fz_0x:                      STRING is "0x"

feature {INSTALL} -- The known keys of the INI file:

   fz_conf_general:              STRING is "General"
   fz_conf_loadpath:             STRING is "Loadpath"
   fz_conf_bin:                  STRING is "bin"
   fz_conf_lib:                  STRING is "lib"
   fz_conf_sys:                  STRING is "sys"
   fz_conf_short:                STRING is "short"
   fz_conf_tools:                STRING is "tools"
   fz_conf_os:                   STRING is "os"
   fz_conf_boost:                STRING is "boost"
   fz_conf_no_check:             STRING is "no_check"
   fz_conf_require_check:        STRING is "require_check"
   fz_conf_ensure_check:         STRING is "ensure_check"
   fz_conf_invariant_check:      STRING is "invariant_check"
   fz_conf_loop_check:           STRING is "loop_check"
   fz_conf_all_check:            STRING is "all_check"
   fz_conf_debug_check:          STRING is "debug_check"
   fz_conf_smarteiffel_options:  STRING is "smarteiffel_options"
   fz_conf_undefined:            STRING is "undefined"
   fz_conf_tag:                  STRING is "tag"
   fz_conf_compiler_type:        STRING is "c_compiler_type"
   fz_conf_compiler_path:        STRING is "c_compiler_path"
   fz_conf_linker_path:          STRING is "c_linker_path"
   fz_conf_compiler_options:     STRING is "c_compiler_options"
   fz_conf_linker_options:       STRING is "c_linker_options"
   fz_conf_cpp_compiler_type:    STRING is "cpp_compiler_type"
   fz_conf_cpp_compiler_path:    STRING is "cpp_compiler_path"
   fz_conf_cpp_compiler_options: STRING is "cpp_compiler_options"
   fz_conf_cpp_linker_path:      STRING is "cpp_linker_path"
   fz_conf_cpp_linker_options:   STRING is "cpp_linker_options"

feature {NONE} -- The numbered (stupid?) section:

   fz_00: STRING is ";%N"
   fz_01: STRING is "File %""
   fz_02: STRING is "Done.%N"
   fz_03: STRING is "%"."
   fz_04: STRING is "Pre-Computed Once Function"
   fz_05: STRING is "(s):%N"
   fz_06: STRING is " is concerned."
   fz_07: STRING is " is ever created."
   fz_09: STRING is "Feature %""
   fz_10: STRING is " : %%d\n%","
   fz_11: STRING is "{%N"
   fz_12: STRING is "}%N"
   fz_13: STRING is "))"
   fz_14: STRING is ");%N"
   fz_15: STRING is "return R;%N}%N"
   fz_16: STRING is "));%N"
   fz_17: STRING is "(("
   fz_18: STRING is "%"%N"
   fz_19: STRING is ")V"
   fz_20: STRING is "),("
   fz_21: STRING is "Ljava/lang/Object;"
   fz_22: STRING is ")("
   fz_23: STRING is "([Ljava/lang/String;)V"
   fz_24: STRING is "string"
   fz_25: STRING is "java/io/PrintStream"
   fz_26: STRING is "R=("
   fz_27: STRING is "(I)V"
   fz_28: STRING is "_initialize_eiffel_runtime"
   fz_29: STRING is "()V"
   fz_30: STRING is "=NULL;%N"
   fz_31: STRING is "[B"
   fz_32: STRING is "(((unsigned int)("
   fz_33: STRING is "getBytes"
   fz_34: STRING is "()[B"
   fz_35: STRING is "<init>"
   fz_36: STRING is ")>>("
   fz_37: STRING is "-("
   fz_38: STRING is "Ljava/io/InputStream;"
   fz_39: STRING is ")&&("
   fz_40: STRING is "Ljava/io/PrintStream;"
   fz_41: STRING is "B"
   fz_42: STRING is "close"
   fz_43: STRING is "((T5)("
   fz_44: STRING is "(Ljava/lang/Object;)Ljava/lang/Object;"
   fz_45: STRING is "((T4)("
   fz_46: STRING is ")["
   fz_47: STRING is "=("
   fz_48: STRING is "gc_is_off=0;%N"
   fz_49: STRING is "err"
   fz_50: STRING is "Assertion failed."
   fz_51: STRING is "println"
   fz_52: STRING is "traceInstructions"
   fz_53: STRING is "if("
   fz_54: STRING is "(Z)V"
   fz_55: STRING is "getRuntime"
   fz_56: STRING is "()Ljava/lang/Runtime;"
   fz_57: STRING is "(Ljava/lang/String;)V"
   fz_58: STRING is "check_flag"
   fz_59: STRING is "0."
   fz_60: STRING is "valueOf0"
   fz_61: STRING is "(Ljava/lang/String;)D"
   fz_62: STRING is "){%N"
   fz_63: STRING is "toString"
   fz_64: STRING is "(D)Ljava/lang/String;"
   fz_65: STRING is "([BII)V"
   fz_66: STRING is "String"
   fz_67: STRING is "}else{%N"
   fz_68: STRING is "(Ljava/lang/String;)V"
   fz_69: STRING is "*((T"
   fz_70: STRING is "*)("
   fz_71: STRING is "()I"
   fz_72: STRING is ")->"
   fz_73: STRING is "Z"
   fz_74: STRING is "args"
   fz_75: STRING is "[Ljava/lang/String;"
   fz_76: STRING is "<clinit>"
   fz_77: STRING is "D"
   fz_78: STRING is "F"
   fz_79: STRING is "((("
   fz_80: STRING is "(Ljava/lang/String;)Ljava/lang/String;"
   fz_81: STRING is " of "
   fz_82: STRING is "parseInt"
   fz_83: STRING is "(Ljava/lang/String;)I"
   fz_84: STRING is "),sizeof(T"
   fz_85: STRING is "&ds,"
   fz_86: STRING is "exists"
   fz_87: STRING is "()Z"
   fz_88: STRING is "(Ljava/io/File;)V"
   fz_89: STRING is "exec"
   fz_90: STRING is "(Ljava/lang/String;)Ljava/lang/Process;"
   fz_91: STRING is "waitFor"
   fz_92: STRING is "R=1;%N"
   fz_93: STRING is "if(R)R=r"
   fz_94: STRING is "(D)D"
   fz_95: STRING is "C->_"
   fz_96: STRING is "()D"
   fz_97: STRING is "()F"
   fz_98: STRING is "ds.p,"
   fz_99: STRING is "(DD)D"
   fz_a1: STRING is "};%N"
   fz_a2: STRING is "get"
   fz_a3: STRING is "(I)Z"
   fz_a4: STRING is "set"
   fz_a5: STRING is "clear"
   fz_a6: STRING is "clone"
   fz_a7: STRING is "()Ljava/lang/Object;"
   fz_a8: STRING is "(Ljava/lang/Object;)Z"
   fz_a9: STRING is "Ljava/util/BitSet;"
   fz_b0: STRING is "%".%N"
   fz_b1: STRING is "(Ljava/util/BitSet;)V"
   fz_b2: STRING is "delete"
   fz_b3: STRING is "renameTo"
   fz_b4: STRING is "(Ljava/io/File;)Z"
   fz_b7: STRING is "((T"

   fz_c0: STRING is "parseDouble"
   fz_c1: STRING is "parseLong"
   fz_c2: STRING is "[Ljava/lang/Object;"
   fz_c3: STRING is "getClass"
   fz_c4: STRING is "()Ljava/lang/Class;"
   fz_c5: STRING is "[Ljava/lang/Class;"
   fz_c6: STRING is "getMethod"
   fz_c7: STRING is "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;"
   fz_c8: STRING is "invoke"
   fz_c9: STRING is "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;"
   fz_ca: STRING is "Ljava/lang/Class;"
   fz_cb: STRING is "(Z)V"
   fz_cc1: STRING is "(B)V"
   fz_cc2: STRING is "(S)V"
   fz_cd: STRING is "(J)V"
   fz_ce: STRING is "(F)V"
   fz_cf: STRING is "(D)V"
   fz_d0: STRING is "(Ljava/lang/Object;)V;"
   fz_d1: STRING is "forName"
   fz_d2: STRING is "(Ljava/lang/String;)Ljava/lang/Class;"
   fz_d3: STRING is "[I"
   fz_d4: STRING is "booleanValue"
   fz_d5: STRING is "()B"
   fz_d6: STRING is "byteValue"
   fz_d7: STRING is "intValue"
   fz_d8: STRING is "()J"
   fz_d9: STRING is "longValue"
   fz_da: STRING is "floatValue"
   fz_db: STRING is "doubleValue"
   fz_dc: STRING is "xor"
   fz_dd: STRING is "or"
   fz_de: STRING is "(Ljava/lang/String;)J"
   fz_df: STRING is "hashCode"

end -- FROZEN_STRING_LIST

