/***************************************************************************
    smb4kauthoptions  -  description
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KAUTHOPTIONS_H
#define SMB4KAUTHOPTIONS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qwidget.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qvgroupbox.h>

// KDE includes
#include <klistview.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kpopupmenu.h>


class Smb4KAuthOptions : public QWidget
{
  friend class Smb4KOptionsDlg;

  Q_OBJECT
  public:
    /**
     * The constructor.
     */
    Smb4KAuthOptions( QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KAuthOptions();

  protected slots:
    /**
     * This slot manages the toggling of the KWallet support button in the
     * Authentication tab.
     *
     * @param state         The toggle state
     */
    void slotKWalletButtonState( int state );
    /**
     * This slot manages the toggling of the default authentication button.
     *
     * @param state        The toggle state
     */
    void slotDefaultAuthButtonState( int state );

  private:
    /**
     * Default authentication
     */
    QCheckBox *m_defaultAuth;
    /**
     * Default login
     */
    KLineEdit *m_defaultLogin;
    /**
     * Default password
     */
    KLineEdit *m_defaultPasswd;
    /**
     * The container for m_defaultLogin and m_defaultPasswd.
     */
    QWidget *m_authWidget;
    /**
     * This determines whether the KWallet system is used.
     */
    QCheckBox *m_use_wallet;
    /**
     * The group box that holds the default login data.
     */
    QVGroupBox *m_login_box;
    /**
     * Determines if the passwords should be stored temporarily
     * if KWallet support is switched off or if they shouldn't.
     */
    QCheckBox *m_remember_passwords;
};

#endif
