/***************************************************************************
                          smb4kbookmarkeditor  -  description
                             -------------------
    begin                : Di Okt 5 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qvaluelist.h>

// KDE includes
#include <klocale.h>
#include <kaction.h>
#include <kactionclasses.h>
#include <kaccel.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <kmessagebox.h>
#include <kapplication.h>

// application specific includes
#include "smb4kbookmarkeditor.h"
#include "../core/smb4kbookmark.h"
#include "../core/smb4kcore.h"
#include "../core/smb4kglobal.h"

using namespace Smb4KGlobal;


Smb4KBookmarkEditor::Smb4KBookmarkEditor( QWidget *parent, const char *name )
: KDialogBase( Plain, i18n( "Bookmark Editor" ), Ok|Cancel, Ok, parent, name, true, true )
{
  setWFlags( Qt::WDestructiveClose );

  QFrame *frame = plainPage();
  QGridLayout *layout = new QGridLayout( frame );
  layout->setSpacing( 5 );

  m_view = new KListView( frame );
  m_view->addColumn( i18n( "Bookmark" ), -1 );
  m_view->addColumn( i18n( "Workgroup" ), -1 );
  m_view->addColumn( i18n( "IP Address" ), -1 );
  m_view->setResizeMode( QListView::LastColumn );
  m_view->setAllColumnsShowFocus( true );
  m_view->setItemsRenameable( true );
  m_view->setRenameable( 0, false );
  m_view->setRenameable( 1, true );
  m_view->setRenameable( 2, true );

  m_collection = new KActionCollection( this, "BookmarkEditor_ActionCollection", KGlobal::instance() );

  KAction *a = new KAction( i18n( "Remove" ), "remove", Key_Delete, this, SLOT( slotRemoveClicked() ), m_collection, "remove_bookmark" );
  KAction *b = new KAction( i18n( "Remove All" ), "editdelete", CTRL+Key_X, this, SLOT( slotDeleteAllClicked() ), m_collection, "remove_all_bookmarks" );
  a->setGroup( "BookmarkEditor" );
  b->setGroup( "BookmarkEditor" );

  slotLoadBookmarks();

  layout->addWidget( m_view, 0, 0, 0 );

  config()->setGroup( "Dialogs" );
  setInitialSize( config()->readSizeEntry( "Bookmark Editor Geometry", 0L ) );

  connect( m_view, SIGNAL( rightButtonPressed( QListViewItem *, const QPoint &, int ) ),
           this,   SLOT( slotRightButtonPressed( QListViewItem *, const QPoint &, int ) ) );

  connect( this,   SIGNAL( okClicked() ),
           this,   SLOT( slotOkClicked() ) );
  connect( this,   SIGNAL( cancelClicked() ),
           this,   SLOT( slotCancelClicked() ) );

  connect( smb4k_core->bookmarkHandler(), SIGNAL( bookmarksUpdated() ),
           this,                          SLOT( slotLoadBookmarks() ) );

  connect( kapp, SIGNAL( iconChanged( int ) ),
           this, SLOT( slotIconChanged( int ) ) );
}


Smb4KBookmarkEditor::~Smb4KBookmarkEditor()
{
  uint index = 0;

  while ( index < m_collection->count() )
  {
    delete m_collection->action( index++ );
  }

  m_collection->clear();
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KBookmarkEditor::slotRightButtonPressed( QListViewItem *item, const QPoint &pos, int )
{
  KActionMenu *menu = new KActionMenu( this, "BookmarkEditorPopupMenu" );

  if ( !item )
  {
    m_collection->action( "remove_bookmark" )->setEnabled( false );
  }
  else
  {
    m_collection->action( "remove_bookmark" )->setEnabled( true );
  }

  if ( m_view->childCount() == 0 )
  {
    m_collection->action( "remove_all_bookmarks" )->setEnabled( false );
  }
  else
  {
    m_collection->action( "remove_all_bookmarks" )->setEnabled( true );
  }

  menu->insert( m_collection->action( "remove_bookmark" ) );
  menu->insert( m_collection->action( "remove_all_bookmarks" ) );

  menu->popup( pos );
}


void Smb4KBookmarkEditor::slotRemoveClicked()
{
  if ( m_view->currentItem() )
  {
    delete m_view->currentItem();
  }
}


void Smb4KBookmarkEditor::slotDeleteAllClicked()
{
  m_view->clear();
}


void Smb4KBookmarkEditor::slotOkClicked()
{
  KActionPtrList list = m_collection->actions( "BookmarkEditor" );

  for ( KActionPtrList::Iterator it = list.begin(); it != list.end(); ++it )
  {
    delete *it;
  }

  QValueList<Smb4KBookmark *> bookmarks;

  if ( m_view->childCount() != 0 )
  {
    QListViewItemIterator it( m_view );

    while( it.current() )
    {
      bookmarks.append( new Smb4KBookmark(
                         it.current()->text( 0 ).section( "/", 2, 2 ).stripWhiteSpace(),
                         it.current()->text( 0 ).section( "/", 3, 3 ).stripWhiteSpace(),
                         it.current()->text( 1 ).stripWhiteSpace(),
                         it.current()->text( 2 ).stripWhiteSpace(),
                         "Disk" ) );
      ++it;
    }
  }

  smb4k_core->bookmarkHandler()->writeBookmarkList( bookmarks );

  config()->setGroup( "Dialogs" );
  config()->writeEntry( "Bookmark Editor Geometry", size() );
  config()->sync();
}


void Smb4KBookmarkEditor::slotCancelClicked()
{
  KActionPtrList list = m_collection->actions( "BookmarkEditor" );

  for ( KActionPtrList::Iterator it = list.begin(); it != list.end(); ++it )
  {
    m_collection->kaccel()->remove( (*it)->name() );
    m_collection->remove( *it );
  }

  config()->setGroup( "Dialogs" );
  config()->writeEntry( "Bookmark Editor Geometry", size() );
  config()->sync();
}


void Smb4KBookmarkEditor::slotLoadBookmarks()
{
  m_view->clear();

  QValueList<Smb4KBookmark *> bookmarks = smb4k_core->bookmarkHandler()->getBookmarks();

  for ( QValueList<Smb4KBookmark *>::ConstIterator it = bookmarks.begin(); it != bookmarks.end(); ++it )
  {
    KListViewItem *item = new KListViewItem( m_view, (*it)->bookmark(), (*it)->workgroup(), (*it)->ip() );
    item->setPixmap( 0, SmallIcon( "folder" ) );
  }
}


void Smb4KBookmarkEditor::slotIconChanged( int )
{
  QListViewItemIterator it( m_view );
  QListViewItem *item;

  // Reload the icon of each item:
  while ((item = it.current()) != 0 )
  {
    ++it;
    item->setPixmap( 0, SmallIcon( "folder" ) );
  }
}

#include "smb4kbookmarkeditor.moc"
