/***************************************************************************
                          smb4kbrowseractionmenu  -  description
                             -------------------
    begin                : So Feb 19 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// KDE includes
#include <klocale.h>
#include <kpopupmenu.h>
#include <kiconloader.h>

// application specific includes
#include "smb4kbrowseractionmenu.h"


Smb4KBrowserActionMenu::Smb4KBrowserActionMenu( int design, KActionCollection *collection, const QString &text, const QIconSet &icon, QWidget *parent, const char *name )
: KActionMenu( text, icon, parent, name ), m_collection( collection )
{
  setupMenu( design );
}


Smb4KBrowserActionMenu::~Smb4KBrowserActionMenu()
{
  // We will not delete the actions here. You *MUST*
  // delete them in the widget where you implemented
  // the menu!
}


void Smb4KBrowserActionMenu::setupMenu( int design )
{
  switch ( design )
  {
    case Full:
    {
      m_preview_action = new KAction( i18n( "Pre&view" ), "view_icon", CTRL+Key_V, 0, 0, m_collection, "preview_action" );
      m_askpass_action = new KAction( i18n( "Au&thentication" ), "identity", CTRL+Key_T, 0, 0, m_collection, "askpass_action" );
      m_print_action = new KAction( i18n( "&Print File" ), "printer1", CTRL+Key_P, 0, 0, m_collection, "print_action" );
      m_mount_action = new KAction( i18n( "&Mount" ), "hdd_mount", CTRL+Key_M, 0, 0, m_collection, "mount_action" );
      m_bookmark_action = new KAction( i18n( "&Add Bookmark" ), "bookmark_add", CTRL+Key_B, 0, 0, m_collection, "add_bookmark_action" );
      m_rescan_action = new KAction( i18n( "Scan Netwo&rk" ), "reload", CTRL+Key_R, 0, 0, m_collection, "rescan_action" );
      m_abort_action = new KAction( i18n( "&Abort" ) , "stop", CTRL+Key_A, 0, 0, m_collection, "abort_action" );
      m_search_action = new KAction( i18n( "&Search" ), "find", CTRL+Key_S, 0, 0, m_collection, "search_action" );
      m_manual_action = new KAction( i18n( "M&ount Manually" ), "connect_creating", CTRL+Key_O, 0, 0, m_collection, "manual_mount_action" );
      m_custom_action = new KAction( i18n( "&Custom Options" ), "samba", CTRL+Key_C, 0, 0, m_collection, "custom_options_action" );

      popupMenu()->insertTitle( SmallIcon( "network" ), i18n( "Network" ), 0, 0 );
      insert( m_rescan_action );
      insert( m_abort_action );
      popupMenu()->insertSeparator( -1 );
      insert( m_search_action );
      insert( m_manual_action );
      popupMenu()->insertSeparator( -1 );
      insert( m_askpass_action );
      insert( m_custom_action );
      insert( m_bookmark_action );
      insert( m_preview_action );
      insert( m_print_action );
      insert( m_mount_action );

      break;
    }
    case KonqPlugin:
    {
      m_preview_action = NULL;
      m_askpass_action = new KAction( i18n( "Au&thentication" ), "identity", CTRL+Key_T, 0, 0, m_collection, "askpass_action" );
      m_print_action = NULL;
      m_mount_action = new KAction( i18n( "&Mount" ), "hdd_mount", CTRL+Key_M, 0, 0, m_collection, "mount_action" );
      m_bookmark_action = NULL;
      m_rescan_action = new KAction( i18n( "Scan Netwo&rk" ), "reload", CTRL+Key_R, 0, 0, m_collection, "rescan_action" );
      m_abort_action = NULL;
      m_search_action = NULL;
      m_manual_action = NULL;
      m_custom_action = new KAction( i18n( "&Custom Options" ), "samba", CTRL+Key_C, 0, 0, m_collection, "custom_options_action" );

      popupMenu()->insertTitle( SmallIcon( "network" ), i18n( "Network" ), 0, 0 );
      insert( m_rescan_action );
      popupMenu()->insertSeparator( -1 );
      insert( m_askpass_action );
      insert( m_custom_action );
      insert( m_mount_action );

      break;
    }
    default:
      break;
  }
}

#include "smb4kbrowseractionmenu.moc"


