/***************************************************************************
    smb4ksambaoptions.cpp  -  description
                             -------------------
    begin                : Mo Jan 26 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qtabwidget.h>

// KDE includes
#include <klocale.h>

// application specific includes
#include "smb4ksambaoptions.h"


bool first_time = true;

int default_port = -1;
QString default_protocol = QString::null;
QString default_kerberos = QString::null;
#ifndef __FreeBSD__
QString default_filesystem = QString::null;
QString default_readwrite = QString::null;
#endif
QString default_uid = QString::null;
QString default_gid = QString::null;

bool port_on = false;
bool protocol_on = false;
bool kerberos_on = false;
#ifndef __FreeBSD__
bool filesystem_on = false;
bool readwrite_on = false;
#endif
bool uid_on = false;
bool gid_on = false;

Smb4KSambaOptions::Smb4KSambaOptions( QWidget *parent, const char *name ) : QTabWidget( parent, name )
{
  setMargin( 10 );

  //
  // The tab for general options.
  //
  QWidget *general_tab = new QWidget( this, "SambaGeneralTab" );
  QGridLayout *grid1 = new QGridLayout( general_tab );
  grid1->setSpacing( 10 );

  QGroupBox *general_options = new QGroupBox( 2, QGroupBox::Horizontal, i18n( "General Options" ), general_tab );
  general_options->setInsideSpacing( 5 );

  (void) new QLabel( i18n( "NetBIOS name:" ), general_options );
  m_netbios = new KLineEdit( QString::null, general_options );

  (void) new QLabel( i18n( "Domain (workgroup):" ), general_options );
  m_domain = new KLineEdit( QString::null, general_options );

  (void) new QLabel( i18n( "Socket options:" ), general_options );
  m_sockopt = new KLineEdit( QString::null, general_options );

  (void) new QLabel( i18n( "Scope (Read manual page):" ), general_options );
  m_scope = new KLineEdit( QString::null, general_options );

  (void) new QLabel( i18n( "Remote SMB port:" ), general_options );
  m_port = new KIntNumInput( 139, general_options );
  // Set the port range:
  m_port->setMinValue( 0 );
  m_port->setMaxValue( 65535 );

  QButtonGroup *active_directory = new QButtonGroup( 1, QGroupBox::Horizontal, i18n( "Active Directory" ), general_tab );
  active_directory->setInsideSpacing( 5 );
  m_krb = new QCheckBox( i18n( "Try to authenticate with Kerberos" ), active_directory );

  QSpacerItem *spacer1 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid1->addWidget( general_options, 0, 0, 0 );
  grid1->addWidget( active_directory, 1, 0, 0 );
  grid1->addItem( spacer1, 2, 0 );

  addTab( general_tab, i18n( "General" ) );


  //
  // Tab for mount options.
  //
  QWidget *mount_tab = new QWidget( this, "SambaMountTab" );
  QGridLayout *grid2 = new QGridLayout( mount_tab );
  grid2->setSpacing( 10 );

  QGroupBox *user_group = new QGroupBox( 2, Qt::Horizontal, i18n( "User and Group" ), mount_tab );
  user_group->setInsideSpacing( 5 );
  (void) new QLabel( i18n( "User ID:" ), user_group );
  m_uid = new KComboBox( user_group );
  m_uid->insertItem( i18n( "default" ) );
  (void) new QLabel( i18n( "Group ID:" ), user_group );
  m_gid = new KComboBox( user_group );
  m_gid->insertItem( i18n( "default" ) );

  // Attention: If you change something here, you need to
  // adjust the code in Smb4KOptionsDlg::readOptions() as
  // well, since the class name and the object name are used
  // to find this widget.
  QGroupBox *charset_codepage = new QGroupBox( 2, Qt::Horizontal, i18n( "Charset and Codepage" ), mount_tab, "SambaCharsetCodepage" );
  charset_codepage->setInsideSpacing( 5 );
  
  // FIXME: Rename to "Client charset:"
  (void) new QLabel( i18n( "Linux charset:" ), charset_codepage );
  m_charset = new KComboBox( charset_codepage );
  QStringList charsets;
  charsets << "iso8859-1" << "iso8859-2" << "iso8859-3" << "iso8859-4" << "iso8859-5" << "iso8859-6" << "iso8859-7" << "iso8859-8" << "iso8859-9" << "iso8859-13" << "iso8859-14" << "iso8859-15" << "koi8-r" << "koi8-u" << "koi8-ru" << "cp1251" << "utf8" << "gb2312" << "big5" << "euc-jp" << "euc-kr" << "tis-620";
  charsets.sort();
  m_charset->insertItem( i18n( "default" ) );
  m_charset->insertStringList( charsets );
  
  (void) new QLabel( i18n( "Server codepage:" ), charset_codepage, "MountCodepage" );
  m_codepage = new KComboBox( charset_codepage );
  QStringList codepages;
  codepages << "cp437" << "cp737" << "cp775" << "cp850" << "cp852" << "cp855" << "cp857" << "cp860" << "cp861" << "cp862" << "cp863" << "cp864" << "cp865" << "cp866" << "cp869" << "cp936" << "cp950" << "cp932" << "cp874" << "cp1255" << "cp1250" << "cp1251" << "cp1252" << "cp1253" << "cp1254" << "cp1256" << "cp1257" << "cp1258" << "cp949" << "cp932" << "cp720" << "cp858";
  codepages.sort();
  m_codepage->insertItem( i18n( "default" ) );
  m_codepage->insertStringList( codepages );

  QGroupBox *permissions = new QGroupBox( 2, Qt::Horizontal, i18n( "Permissions" ), mount_tab, "SambaPermissions" );
  permissions->setInsideSpacing( 5 );
  (void) new QLabel( i18n( "File mask:" ), permissions );
  m_fmask = new KLineEdit( QString::null, permissions );
  m_fmask->setAlignment( Qt::AlignRight );
  (void) new QLabel( i18n( "Directory mask:" ), permissions );
  m_dmask = new KLineEdit( QString::null, permissions );
  m_dmask->setAlignment( Qt::AlignRight );
  (void) new QLabel( i18n( "Write access:" ), permissions );
  m_read_mode = new KComboBox( permissions );
  m_read_mode->insertItem( i18n( "read-write" ) );
  m_read_mode->insertItem( i18n( "read-only" ) );

#ifndef __FreeBSD__
  QGroupBox *mount_misc = new QGroupBox( 1, Qt::Horizontal, i18n( "Miscellaneous" ), mount_tab );
  mount_misc->setInsideSpacing( 5 );
  QWidget *buffer = new QWidget( mount_misc );
  QGridLayout *buffer_grid = new QGridLayout( buffer );
  buffer_grid->setSpacing( 10 );
  QLabel *ttlLabel = new QLabel( i18n( "Caching time of directory listings:" ), buffer, "SambaCachingTime" );
  m_ttl = new KIntNumInput( 1000, buffer );
  m_ttl->setSuffix( " ms" );
  m_ttl->setMinValue( 0 );
  buffer_grid->addWidget( ttlLabel, 0, 0, 0 );
  buffer_grid->addWidget( m_ttl, 0, 1, 0 );
  m_unicode = new QCheckBox( i18n( "Use unicode when communicating with the server" ), mount_misc );
  m_lfs = new QCheckBox( i18n( "Use large filesystem support" ), mount_misc );
  m_rsize = new QCheckBox( i18n( "Use default network read size" ), mount_misc );
  m_wsize = new QCheckBox( i18n( "Use default network write size" ), mount_misc );
#endif

  QButtonGroup *filesystem = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "File System" ), mount_tab );
  m_filesystem = new KComboBox( filesystem );
  m_filesystem->insertItem( "SMBFS", 0 );
  m_filesystem->insertItem( "CIFS", 1 );
//   m_filesystem->setCurrentText( "SMBFS" );
  QLabel *note = new QLabel( i18n( "NOTE: You might need to enable support for either <i>super</i> or <i>sudo</i> in the Super User tab." ), filesystem );
  note->setTextFormat( QLabel::RichText );

  QSpacerItem *spacer2 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid2->addMultiCellWidget( filesystem, 0, 0, 0, 1, 0 );
  grid2->addMultiCellWidget( permissions, 0, 0, 2, 3, 0 );
  grid2->addMultiCellWidget( user_group, 1, 1, 0, 1, 0 );
  grid2->addMultiCellWidget( charset_codepage, 1, 1, 2, 3, 0 );
#ifndef __FreeBSD__
  grid2->addMultiCellWidget( mount_misc, 2, 2, 0, 3, 0 );
  grid2->addMultiCell( spacer2, 3, 3, 0, 3 );
#else
  grid2->addMultiCell( spacer2, 2, 2, 0, 3 );
#endif

  addTab( mount_tab, "mount" );

  //
  // Tab for net command options.
  //
  QWidget *net_tab = new QWidget( this, "SambaNetTab" );
  QGridLayout *grid3 = new QGridLayout( net_tab );
  grid3->setSpacing( 10 );

  QButtonGroup *net_protocol = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Protocol Hint" ), net_tab );
  net_protocol->setInsideSpacing( 5 );

  m_net_auto = new QRadioButton( i18n( "Auto" ), net_protocol );
  m_net_auto->setChecked( true );
  m_net_ads = new QRadioButton( i18n( "Active Directory (LDAP/Kerberos)" ), net_protocol );
  m_net_rpc = new QRadioButton( i18n( "DCE-RPC" ), net_protocol );
  m_net_rap = new QRadioButton( i18n( "RAP (older systems)" ), net_protocol );

  QGroupBox *net_misc = new QGroupBox( 1, QGroupBox::Horizontal, i18n( "Miscellaneous" ), net_tab );
  net_misc->setInsideSpacing( 5 );

  m_net_machine_account = new QCheckBox( i18n( "Authenticate as machine account" ), net_misc );

  QSpacerItem *spacer3 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid3->addWidget( net_protocol, 0, 0, 0 );
  grid3->addWidget( net_misc, 1, 0, 0 );
  grid3->addItem( spacer3, 2, 0 );

  addTab( net_tab, "net" );

  //
  // Tab for smbclient options.
  //
  QWidget *smbclient_tab = new QWidget( this, "SambaSmbclientTab" );
  QGridLayout *grid4 = new QGridLayout( smbclient_tab );
  grid4->setSpacing( 10 );

  QGroupBox *smbclient_misc = new QGroupBox( 2, Qt::Horizontal, i18n( "Miscellaneous" ), smbclient_tab );
  smbclient_misc->setInsideSpacing( 5 );

  (void) new QLabel( i18n( "Resolve order:" ), smbclient_misc );
  m_resolve = new KLineEdit( QString::null, smbclient_misc );

  (void) new QLabel( i18n( "Buffer size:" ), smbclient_misc );
  m_buffer = new KIntNumInput( smbclient_misc );
  m_buffer->setMinValue( 0 );
  m_buffer->setValue( 65520 );
  m_buffer->setSuffix( " Bytes" );

  QSpacerItem *spacer4 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid4->addWidget( smbclient_misc, 0, 0, 0 );
  grid4->addItem( spacer4, 1, 0 );

  addTab( smbclient_tab, "smbclient" );

  //
  // Tab for nmblookup options.
  //
  QWidget *w4 = new QWidget( this, "SambaNmblookupTab" );
  QGridLayout *w4grid = new QGridLayout( w4 );
  w4grid->setSpacing( 10 );

  QGroupBox *w4box1 = new QGroupBox( 1, Qt::Horizontal, i18n( "Miscellaneous" ), w4 );
  w4box1->setInsideSpacing( 5 );

  QWidget *w4w1 = new QWidget( w4box1 );
  QGridLayout *w4w1g = new QGridLayout( w4w1 );
  w4w1g->setSpacing( 10 );

  QLabel *broadcastLabel = new QLabel( w4w1 );
  broadcastLabel->setText( i18n( "Broadcast address:" ) );
  m_broadcast = new KLineEdit( QString::null, w4w1 );

  w4w1g->addWidget( broadcastLabel, 0, 0, 0 );
  w4w1g->addWidget( m_broadcast, 0, 1, 0 );

  m_udp = new QCheckBox( i18n( "Try and bind to UDP port 137 to send and receive UDP datagrams" ), w4box1 );

  QSpacerItem *spacer5 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  w4grid->addWidget( w4box1, 0, 0, 0 );
  w4grid->addItem( spacer5, 1, 0 );

  addTab( w4, "nmblookup" );

  //
  // Tab for custom options
  //
  QWidget *w5 = new QWidget( this, "SambaCustomOptions" );
  QGridLayout *w5grid = new QGridLayout( w5 );
  w5grid->setSpacing( 10 );

  m_custom_options = new KListView( w5 );
  m_custom_options->setAllColumnsShowFocus( true );
  m_custom_options->setSelectionMode( QListView::Single );
  m_custom_options->setVScrollBarMode( KListView::Auto );

  m_custom_options->addColumn( i18n( "Item" ), -1 );
  m_custom_options->addColumn( i18n( "Port" ), -1 );
   m_custom_options->addColumn( i18n( "Kerberos" ), -1 );
  m_custom_options->addColumn( i18n( "Protocol" ), -1 );
#ifndef __FreeBSD__
  m_custom_options->addColumn( i18n( "File System" ), -1 );
  m_custom_options->addColumn( i18n( "Write Access" ), -1 );
#endif
  m_custom_options->addColumn( i18n( "UID" ), -1 );
  m_custom_options->addColumn( i18n( "GID" ), -1 );

  QGroupBox *custom_input = new QGroupBox( 4, Qt::Horizontal, w5 );
  QLabel *custom_port_label = new QLabel( i18n( "Port:" ), custom_input, "CustomPortLabel" );
  custom_port_label->setEnabled( false );
  m_custom_port = new KIntNumInput( -1, custom_input );
  m_custom_port->setMinValue( 0 );
  m_custom_port->setMaxValue( 65535 );
  m_custom_port->setEnabled( false );
  QLabel *custom_kerberos_label = new QLabel( i18n( "Kerberos:" ), custom_input, "CustomKerberosLabel" );
  custom_kerberos_label->setEnabled( false );
  m_custom_kerberos = new KComboBox( custom_input );
  m_custom_kerberos->insertItem( "-", -1 );
  m_custom_kerberos->insertItem( i18n( "no" ), -1 );
  m_custom_kerberos->insertItem( i18n( "yes" ), -1 );
  m_custom_kerberos->setEnabled( false );
  QLabel *custom_protocol_label = new QLabel( i18n( "Protocol:" ), custom_input, "CustomProtocolLabel" );
  custom_protocol_label->setEnabled( false );
  m_custom_protocol = new KComboBox( custom_input );
  m_custom_protocol->insertItem( "-", -1 );
  m_custom_protocol->insertItem( i18n( "auto" ), -1 );
  m_custom_protocol->insertItem( "ADS", -1 );
  m_custom_protocol->insertItem( "RPC", -1 );
  m_custom_protocol->insertItem( "RAP", -1 );
  m_custom_protocol->setEnabled( false );
#ifndef __FreeBSD__
  QLabel *custom_filesystem_label = new QLabel( i18n( "File system:" ), custom_input, "CustomFilesystemLabel" );
  custom_filesystem_label->setEnabled( false );
  m_custom_filesystem = new KComboBox( custom_input );
  m_custom_filesystem->insertItem( "-", -1 );
  m_custom_filesystem->insertItem( "SMBFS", -1 );
  m_custom_filesystem->insertItem( "CIFS", -1 );
  m_custom_filesystem->setEnabled( false );
  QLabel *custom_rw_label = new QLabel( i18n( "Write access:" ), custom_input, "CustomWriteAccessLabel" );
  custom_rw_label->setEnabled( false );
  m_custom_rw = new KComboBox( custom_input );
  m_custom_rw->insertItem( "-", -1 );
  m_custom_rw->insertItem( i18n( "read-write" ), -1 );
  m_custom_rw->insertItem( i18n( "read-only" ), -1 );
  m_custom_rw->setEnabled( false );
#endif
  QLabel *custom_uid_label = new QLabel( i18n( "User ID:" ), custom_input, "CustomUIDLabel" );
  custom_uid_label->setEnabled( false );
  m_custom_uid = new KComboBox( custom_input );
  m_custom_uid->insertItem( "-", -1 );
  m_custom_uid->insertItem( i18n( "default" ), -1 );
  m_custom_uid->setEnabled( false );
  QLabel *custom_gid_label = new QLabel( i18n( "Group ID:" ), custom_input, "CustomGIDLabel" );
  custom_gid_label->setEnabled( false );
  m_custom_gid = new KComboBox( custom_input );
  m_custom_gid->insertItem( "-", -1 );
  m_custom_gid->insertItem( i18n( "default" ), -1 );
  m_custom_gid->setEnabled( false );

  custom_input->addSpace( 0 );
//   custom_input->addSpace( 0 );
//   custom_input->addSpace( 0 );
//   custom_input->addSpace( 0 );
//   custom_input->addSpace( 0 );

  m_remove_custom = new KPushButton( KGuiItem( i18n( "Remove" ), "remove" ), custom_input );
  m_remove_custom->setEnabled( false );

  w5grid->addWidget( m_custom_options, 0, 0, 0 );
  w5grid->addWidget( custom_input, 1, 0, 0 );

  addTab( w5, i18n( "Custom" ) );

  connect( m_filesystem,        SIGNAL( activated( const QString & ) ),
           this,                SLOT( slotSambaFileSystem( const QString & ) ) );
  connect( m_remove_custom,     SIGNAL( clicked() ),
           this,                SLOT( slotRemoveCustomOptions() ) );
  connect( m_custom_options,    SIGNAL( clicked( QListViewItem * ) ),
           this,                SLOT( slotClicked( QListViewItem * ) ) );
  connect( m_custom_port,       SIGNAL( valueChanged( int ) ),
           this,                SLOT( slotCustomPortChanged( int ) ) );
  connect( m_custom_protocol,   SIGNAL( activated( int ) ),
           this,                SLOT( slotCustomProtocolChanged( int ) ) );
  connect( m_custom_kerberos,   SIGNAL( activated( int ) ),
           this,                SLOT( slotCustomKerberosChanged( int ) ) );
#ifndef __FreeBSD__
  connect( m_custom_filesystem, SIGNAL( activated( int ) ),
           this,                SLOT( slotCustomFilesystemChanged( int ) ) );
  connect( m_custom_rw,         SIGNAL( activated( int ) ),
           this,                SLOT( slotCustomWriteAccessChanged( int ) ) );
#endif
  connect( m_custom_uid,        SIGNAL( activated( int ) ),
           this,                SLOT( slotCustomUIDChanged( int ) ) );
  connect( m_custom_gid,        SIGNAL( activated( int ) ),
           this,                SLOT( slotCustomGIDChanged( int ) ) );
}


Smb4KSambaOptions::~ Smb4KSambaOptions()
{
}



/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KSambaOptions::slotSambaFileSystem( const QString &fs )
{
  if ( QString::compare( fs, "SMBFS" ) == 0 )
  {
    ((QLabel *)child( "MountCodepage", "QLabel" ))->setEnabled( true );
    m_codepage->setEnabled( true );
#ifndef __FreeBSD__
    ((QLabel *)child( "SambaCachingTime", "QLabel" ))->setEnabled( true );
    m_ttl->setEnabled( true );
    m_unicode->setEnabled( true );
    m_lfs->setEnabled( true );
    m_rsize->setEnabled( false );
    m_wsize->setEnabled( false );
#endif
  }
  else
  {
    ((QLabel *)child( "MountCodepage", "QLabel" ))->setEnabled( false );
    m_codepage->setEnabled( false );
#ifndef __FreeBSD__
    ((QLabel *)child( "SambaCachingTime", "QLabel" ))->setEnabled( false );
    m_ttl->setEnabled( false );
    m_unicode->setEnabled( false );
    m_lfs->setEnabled( false );
    m_rsize->setEnabled( true );
    m_wsize->setEnabled( true );
#endif
  }
}


void Smb4KSambaOptions::slotRemoveCustomOptions()
{
  if ( m_custom_options->selectedItem() )
  {
    delete m_custom_options->currentItem();

    // Disable the widgets:
    slotClicked( NULL );
  }
}


void Smb4KSambaOptions::slotClicked( QListViewItem *item )
{
  // Enable the remove button if the item is not NULL:
  m_remove_custom->setEnabled( item != NULL );

  // We want to be able to reset the widgets in the group
  // box, so we check their state and their start value (we
  // do not want to hardcode something here).
  if ( item )
  {
    // Remember the start values, so we can reset them
    // later:
    if ( first_time )
    {
      default_port = m_custom_port->value();
      default_protocol = m_custom_protocol->currentText();
      default_kerberos = m_custom_kerberos->currentText();
#ifndef __FreeBSD__
      default_filesystem = m_custom_filesystem->currentText();
      default_readwrite = m_custom_rw->currentText();
#endif
      default_uid = m_custom_uid->currentText();
      default_gid = m_custom_gid->currentText();

      port_on = m_custom_port->isEnabled();
      protocol_on = m_custom_protocol->isEnabled();
      kerberos_on = m_custom_kerberos->isEnabled();
#ifndef __FreeBSD__
      filesystem_on = m_custom_filesystem->isEnabled();
      readwrite_on = m_custom_rw->isEnabled();
#endif
      uid_on = m_custom_uid->isEnabled();
      gid_on = m_custom_gid->isEnabled();

      first_time = false;
    }

    // Now we need to decide which widgets have to be enabled:
    ((QWidget *)child( "CustomPortLabel", "QLabel", true ))->setEnabled( true );
    m_custom_port->setEnabled( true );

    bool enable_kerberos = (QString::compare( item->text( Kerberos ), "-" ) != 0);
    ((QWidget *)child( "CustomKerberosLabel", "QLabel", true ))->setEnabled( enable_kerberos );
    m_custom_kerberos->setEnabled( enable_kerberos );

    bool enable_protocol = (QString::compare( item->text( Protocol ), "-" ) != 0);
    ((QWidget *)child( "CustomProtocolLabel", "QLabel", true ))->setEnabled( enable_protocol );
    m_custom_protocol->setEnabled( enable_protocol );

#ifndef __FreeBSD__
    bool enable_filesystem = (QString::compare( item->text( Filesystem ), "-" ) != 0);
    ((QWidget *)child( "CustomFilesystemLabel", "QLabel", true ))->setEnabled( enable_filesystem );
    m_custom_filesystem->setEnabled( enable_filesystem );

    bool enable_access = (QString::compare( item->text( WriteAccess ), "-" ) != 0);
    ((QWidget *)child( "CustomWriteAccessLabel", "QLabel", true ))->setEnabled( enable_access );
    m_custom_rw->setEnabled( enable_access );
#endif

    bool enable_uid = (QString::compare( item->text( UID ), "-" ) != 0);
    ((QWidget *)child( "CustomUIDLabel", "QLabel", true ))->setEnabled( enable_uid );
    m_custom_uid->setEnabled( enable_uid );

    bool enable_gid = (QString::compare( item->text( GID ), "-" ) != 0);
    ((QWidget *)child( "CustomGIDLabel", "QLabel", true ))->setEnabled( enable_gid );
    m_custom_gid->setEnabled( enable_gid );

    // Put the item's values into the widgets:

    // FIXME: Should we remove the unnecessary '-' from the combo boxes?
    // Warning: You'll have to put them back in when the widget is disabled
    // or needs those '-'!

    m_custom_port->setValue( item->text( Port ).toInt() );
    m_custom_kerberos->setCurrentText( item->text( Kerberos ) );
    m_custom_protocol->setCurrentText( item->text( Protocol ) );
#ifndef __FreeBSD__
    m_custom_filesystem->setCurrentText( item->text( Filesystem ) );
    m_custom_rw->setCurrentText( item->text( WriteAccess ) );
#endif
    m_custom_uid->setCurrentText( item->text( UID ) );
    m_custom_gid->setCurrentText( item->text( GID ) );
  }
  else
  {
    // Reset and disable all widgets in the group box.
    if ( !first_time )
    {
      // Disable the widgets. We do not check if they were enabled before.
      // Maybe this should be implemented?
      ((QWidget *)child( "CustomPortLabel", "QLabel", true ))->setEnabled( false );
      m_custom_port->setEnabled( false );

      ((QWidget *)child( "CustomKerberosLabel", "QLabel", true ))->setEnabled( false );
      m_custom_kerberos->setEnabled( false );

      ((QWidget *)child( "CustomProtocolLabel", "QLabel", true ))->setEnabled( false );
      m_custom_protocol->setEnabled( false );

#ifndef __FreeBSD__
      ((QWidget *)child( "CustomFilesystemLabel", "QLabel", true ))->setEnabled( false );
      m_custom_filesystem->setEnabled( false );

      ((QWidget *)child( "CustomWriteAccessLabel", "QLabel", true ))->setEnabled( false );
      m_custom_rw->setEnabled( false );
#endif

      ((QWidget *)child( "CustomUIDLabel", "QLabel", true ))->setEnabled( false );
      m_custom_uid->setEnabled( false );

      ((QWidget *)child( "CustomGIDLabel", "QLabel", true ))->setEnabled( false );
      m_custom_gid->setEnabled( false );

      // Now reset the widgets:
      m_custom_port->setValue( default_port );
      m_custom_protocol->setCurrentText( default_protocol );
      m_custom_kerberos->setCurrentText( default_kerberos );
#ifndef __FreeBSD__
      m_custom_filesystem->setCurrentText( default_filesystem );
      m_custom_rw->setCurrentText( default_readwrite );
#endif
      m_custom_uid->setCurrentText( default_uid );
      m_custom_gid->setCurrentText( default_gid );
    }
    else
    {
      // Nothing to do.
    }
  }
}


void Smb4KSambaOptions::slotCustomPortChanged( int number )
{
  if ( m_custom_options->selectedItem() )
  {
    m_custom_options->selectedItem()->setText( Port, QString( "%1" ).arg( number ) );
  }
}


void Smb4KSambaOptions::slotCustomFilesystemChanged( int index )
{
#ifndef __FreeBSD__
  if ( m_custom_options->selectedItem() )
  {
    if ( QString::compare( "-", m_custom_filesystem->text( index ) ) != 0 )
    {
      // Set the new value:
      m_custom_options->selectedItem()->setText( Filesystem, m_custom_filesystem->text( index ) );
    }
    else
    {
      // Reset the combo box:
      m_custom_filesystem->setCurrentText( m_custom_options->selectedItem()->text( Filesystem ) );
    }
  }
  else
  {
    // Nothing to do.
  }
#endif
}


void Smb4KSambaOptions::slotCustomProtocolChanged( int index )
{
  if ( m_custom_options->selectedItem() )
  {
    if ( QString::compare( "-", m_custom_protocol->text( index ) ) != 0 )
    {
      // Set the new value:
      m_custom_options->selectedItem()->setText( Protocol, m_custom_protocol->text( index ) );
    }
    else
    {
      // Reset the combo box:
      m_custom_protocol->setCurrentText( m_custom_options->selectedItem()->text( Protocol ) );
    }
  }
  else
  {
    // Nothing to do.
  }
}


void Smb4KSambaOptions::slotCustomKerberosChanged( int index )
{
  if ( m_custom_options->selectedItem() )
  {
    if ( QString::compare( "-", m_custom_kerberos->text( index ) ) != 0 )
    {
      // Set the new value:
      m_custom_options->selectedItem()->setText( Kerberos, m_custom_kerberos->text( index ) );
    }
    else
    {
      // Reset the combo box:
      m_custom_kerberos->setCurrentText( m_custom_options->selectedItem()->text( Kerberos ) );
    }
  }
  else
  {
    // Nothing to do.
  }
}


void Smb4KSambaOptions::slotCustomWriteAccessChanged( int index )
{
#ifndef __FreeBSD__
  if ( m_custom_options->selectedItem() )
  {
    if ( QString::compare( "-", m_custom_rw->text( index ) ) != 0 )
    {
      // Set the new value:
      m_custom_options->selectedItem()->setText( WriteAccess, m_custom_rw->text( index ) );
    }
    else
    {
      // Reset the combo box:
      m_custom_rw->setCurrentText( m_custom_options->selectedItem()->text( WriteAccess ) );
    }
  }
  else
  {
    // Nothing to do.
  }
#endif
}


void Smb4KSambaOptions::slotCustomUIDChanged( int index )
{
  if ( m_custom_options->selectedItem() )
  {
    if ( QString::compare( "-", m_custom_uid->text( index ) ) != 0 )
    {
      // Set the new value:
      m_custom_options->selectedItem()->setText( UID, m_custom_uid->text( index ) );
    }
    else
    {
      // Reset the combo box:
      m_custom_uid->setCurrentText( m_custom_options->selectedItem()->text( UID ) );
    }
  }
  else
  {
    // Nothing to do.
  }
}


void Smb4KSambaOptions::slotCustomGIDChanged( int index )
{
  if ( m_custom_options->selectedItem() )
  {
    if ( QString::compare( "-", m_custom_gid->text( index ) ) != 0 )
    {
      // Set the new value:
      m_custom_options->selectedItem()->setText( GID, m_custom_gid->text( index ) );
    }
    else
    {
      // Reset the combo box:
      m_custom_gid->setCurrentText( m_custom_options->selectedItem()->text( GID ) );
    }
  }
  else
  {
    // Nothing to do.
  }
}

#include "smb4ksambaoptions.moc"
