/***************************************************************************
    smb4kshareoptions  -  description
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHAREOPTIONS_H
#define SMB4KSHAREOPTIONS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qtabwidget.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qlabel.h>

// KDE includes
#include <kurlrequester.h>
#include <knuminput.h>
#include <klistview.h>

class Smb4KShareOptions : public QWidget
{
  friend class Smb4KOptionsDlg;

  Q_OBJECT
  public:
    /**
     * The constructor.
     *
     * @param parent          The parent of this widget
     *
     * @param name            The name of this widget
     */
    Smb4KShareOptions( QWidget *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KShareOptions();

  private:
    /**
     * This KURLRequester holds the mount prefix.
     */
    KURLRequester *m_mount_prefix;

    /**
     * Determines whether the created paths should be forced lowercase.
     */
    QCheckBox *m_lowercase;

    /**
     * Determines whether all shares should be unmounted on exit.
     */
    QCheckBox *m_unmountAll;

    /**
     * Determines whether recently used shares should be remounted.
     */
    QCheckBox *m_mountRecent;

    /**
     * Determines if the unmounting of foreign shares should be permitted.
     */
    QCheckBox *m_allowUnmountForeign;

    /**
     * Removes the super user entries from chosen system file if pressed.
     */
    KPushButton *m_removeSUEntries;

    /**
     * This integer input is to determine the time interval
     * between checks (broken shares, external (un)mounts).
     */
    KIntNumInput *m_check_interval;
};
#endif
