/***************************************************************************
    smb4k_cat  -  This utility behaves essentially like 'cat'. It is
    used to "read" system configuration files and is part of Smb4K.
                             -------------------
    begin                : Mi Nov 2 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <fstream>
#include <stdio.h>
#include <cerrno>
using namespace std;

#define SMB4K_CAT_VERSION 0.3

//
// Usage
//

void info()
{
  cout << "This is smb4k_cat (version " << SMB4K_CAT_VERSION << "), the cat utility of Smb4K" << endl;
  cout << "Copyright (C) 2005-2006, Alexander Reinholdt" << endl << endl;
  cout << "Usage:" << endl;
  cout << " smb4k_cat {filename}" << endl;
  cout << " smb4k_cat --help" << endl << endl;
  cout << "Arguments:" << endl;
  cout << "  {filename}\tThe name or the path of the file that is to be opened." << endl;
  cout << endl;
  cout << "  --help\tDisplays this help screen and exits." << endl;
  cout << endl;
}

//
// The main program
//

int main( int argc, char *argv[] )
{
  if ( argc != 2 )
  {
    info();
    exit( EXIT_FAILURE );
  }
  else
  {
    if ( !strcmp( argv[1], "--help" ) )
    {
      info();
      exit( EXIT_SUCCESS );
    }
    else
    {
      char config[255];

      (void) strncpy( config, argv[1], 254 );
      config[254] = '\0';

      if ( strlen( config ) != 0 )
      {
        FILE *fd;

        if ( (fd = fopen( config, "r" )) == NULL )
        {
          int error = errno;

          cerr << "smb4k_cat: " << strerror( error ) << endl;
          exit( EXIT_FAILURE );
        }

        char line[255];

        while( !feof( fd ) )
        {
          fgets( line, 255, fd );
          cout << line;
          line[0] = '\0';
        }

        fclose( fd );
      }
    }
  }

  return EXIT_SUCCESS;
}
