#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <netdb.h>
#include "vsprintf.h"
#include "sms.h"

// jesli zdefiniowana jest zmienna srodowiska SMS_MAILADDR to ona bedzie
// uzyta jako adres mailowy, w przeciwnym wypadku program wykorzysta
// adres zdefiniowany w pliku konfiguracyjnym. Jezeli brak jest takiej
// definicji, wowczas na podstawie nazwy usera i nazwy hosta sms sprobuje
// skonstruowac adres email. Jesli i to sie nie powiedzie to uzyty bedzie
// 'domyslny' adres
void pobierz_adres_email(char *buf, int size, const char *def)
{
	struct hostent *host;
        struct passwd *pw;
        char hostname[64], *env;

	// domyslna wartosc
	strncpy(buf, def, size-1);
	buf[size - 1] = '\0';

	if (strlen(def) >= size )
		debug_stream->Log(LOG_WARN, "Adres nadawcy jest dluzszy niz dopuszczalne %d znakow; zostanie skrocony.", size-1);

	if (env = getenv("SMS_MAILADDR")) {
		strncpy(buf, env, size-1);
	 	buf[size - 1] = '\0';
		
		if (strlen(env) >= size)
          		debug_stream->Log(LOG_WARN, "Adres nadawcy jest dluzszy niz dopuszczalne %d znakow; zostanie skrocony.", size-1);
	}
	else {
#ifdef OLD_SOLARIS
		gethostent(); /* najpierw jest zawsze localhost */
		host=gethostent();
		if (host==NULL) {
		    snprintf(buf, size, "%s@unknown", pw->pw_name);
		} else  {
		    snprintf(buf, size, "%s@%s", host->h_name); /*n_name zawiera w sobie nazwe domeny (jezeli taka oczywiscie jest)*/
		}
#else
	     if ((strlen(def) == 0) && (pw=getpwuid(getuid())) && !gethostname(hostname, sizeof(hostname))) {
		host = gethostbyname(hostname);
		if (host)
			snprintf(buf,size,"%s@%s",pw->pw_name,host->h_name);
	     }
#endif
	     
	}
}

void pobierz_adres_notify(char *buf, int sizebuf, char *flag, char *def)
{
 char *env;

 if (env = getenv("SMS_NOTIFYADDR")) {
 	strncpy(buf, env, sizebuf-1);
   	buf[sizebuf - 1] = '\0';

	if (strlen(env) >= sizebuf)
   		debug_stream->Log(LOG_WARN, "Adres potwierdzenia jest dluzszy niz dopuszczalne %d znakow; zostanie skrocony.", sizebuf-1);
  	strcpy(flag,"true");
 }
 else if (strlen(def) != 0) {
   strncpy(buf, def, sizebuf-1);
   buf[sizebuf - 1] = '\0';

   if (strlen(def) >= sizebuf)
   	debug_stream->Log(LOG_WARN, "Adres potwierdzenia jest dluzszy niz dopuszczalne %d znakow; zostanie skrocony.", sizebuf-1);
  strcpy(flag,"true");
 } else {
  strcpy(buf, "");
  strcpy(flag,"false");
 }
}

