%{

#include "eval.h"
#include "parse.h"

%}

%s STRING

%%

\n[ \t]+		/* merge two lines */

#.*\n			{ return '\n'; }
[\t ]+			/* ignore white spaces */

[\n:,=\(\)\>\<]		{ return yytext[0]; }


\"			{ BEGIN STRING; }
<STRING>[^"]*\"		{ BEGIN 0; yytext[strlen(yytext)-1] = '\0'; return SPAM_LEX_STRING; }

0|[1-9][0-9]*		{ return SPAM_LEX_NUMBER; }
[A-Z]+			{ return SPAM_LEX_VARIABLE; }
[a-z0-9A-Z@\.\-_]+		{ return SPAM_LEX_STRING; }
==			{ return SPAM_LEX_EQ; }
!=			{ return SPAM_LEX_NEQ; }
\<=			{ return SPAM_LEX_LE; }
\>=			{ return SPAM_LEX_GE; }
\+\+			{ return SPAM_LEX_INC; }
~=			{ return SPAM_LEX_APPROX_EQ; }
!~=			{ return SPAM_LEX_APPROX_NEQ; }


%%



