/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* $Id: sg_io.c,v 1.1.1.1 2005/11/04 07:19:35 tkitame Exp $ 
 *
 * Copyright (c) 2005 VA Linux Systems Japan, K.K. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <unistd.h>
#include <errno.h>

#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <stdarg.h>
#include <limits.h>

#include "sg_log.h"

int sg_read(int fd, char *txt, int len, int log)
{
  int ret, failcount = 0;
  char *s;

  s = txt;
  while (1) {
    ret = read(fd, s, len);
    if (ret == -1) {
      if (errno != EINTR) {
	if (log)
          sg_err(errno, "sg_read: read error");
        return -1;
      }
      failcount++;
      if (failcount == 5) {
	if (log)
          sg_err(errno, "sg_read: failure count exceeded");
	return -1;
      }
    }
    else
      return ret;
  }
}

int sg_write(int fd, char *txt, int len, int log)
{
  int ret, failcount = 0;
  char *s;

  s = txt;
  while (1) {
    ret = write(fd, s, len);
    if (ret == -1) {
      if (errno != EINTR) {
	if (log)
          sg_err(errno, "sg_write: write error");
        return -1;
      }
      failcount++;
      if (failcount == 5) {
	if (log)
          sg_err(errno, "sg_write: failure count exceeded");
	return -1;
      }
    }
    else if (ret < len) {
      s += ret;
      len -= ret;
    }
    else
      return ret;
  }
}
