/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* $Id: sg_time.c,v 1.1.1.1 2005/11/04 07:19:35 tkitame Exp $ 
 *
 * Copyright (c) 2005 VA Linux Systems Japan, K.K. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <unistd.h>
#include <time.h>

static int sg_time_init_called;
static unsigned long sg_time_base;
static int sg_time_rate;

void sg_time_init(int rate)
{
  sg_time_init_called = 1;
  sg_time_base = time(NULL);
  sg_time_rate = rate;
}

unsigned long sg_time(unsigned long *t)
{
  time_t now;
  if (!sg_time_init_called) {
	  return time((time_t *)t);
  }
  now = sg_time_base + ((time(NULL) - sg_time_base) * sg_time_rate);
  if (t) {
    *t = now;
  }
  return now;
}

unsigned int sg_sleep(unsigned int s)
{
  struct timespec n;
  if (!sg_time_init_called) {
    return sleep(s);
  }
  n.tv_sec = s / sg_time_rate;
  n.tv_nsec = (s % sg_time_rate) * 1000000000 / sg_time_rate;
  //  printf("sleeping %lu.%lu\n", n.tv_sec, n.tv_nsec);
  nanosleep(&n, NULL);
  return 0;
}
