/* SNAC
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Matias Mutchinick          
 *         
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <gnome.h>
#include "stockbutton.h"


/******************************************************************************/
/* ag_button_with_stock_n_label                                               */
/* Creates a button, with a gnome stock pixmap and a label.                   */
/*                                                                            */
/******************************************************************************/

GtkWidget *
ag_button_with_stock_n_label(gchar      *stock,
			     gchar      *title)
{
	
	GtkWidget     *button;
	GtkWidget     *hbox;
	GtkWidget     *stockPixmap;
	GtkWidget     *label;
	
	
	
	/* Create a new button */
	button = gtk_button_new();
	
	
	/* Create a new vertical box and put it into the button */
	hbox = gtk_hbox_new(FALSE,2);
	gtk_container_add(GTK_CONTAINER(button),hbox);
	
	
	/* Create a widget from the gnome stock pixmap and
	 * packit into the box */
	stockPixmap = gnome_stock_new_with_icon(stock);
	gtk_box_pack_start_defaults(GTK_BOX(hbox),stockPixmap);
	
	
	/* Create a label and packit into the box */ 
	label = gtk_label_new(title);
	gtk_box_pack_start_defaults(GTK_BOX(hbox),label);
	
	
	/* Show all the widgets contained in the box */ 
	gtk_widget_show_all(hbox);
	
	
	return button;
	
}





/******************************************************************************/
/* ag_button_with_label_n_stock                                               */
/* Creates a button, with a label and a gnome stock pixmap.                   */
/*                                                                            */
/******************************************************************************/

GtkWidget *
ag_button_with_label_n_stock(gchar      *stock,
			     gchar      *title)
{
	
	GtkWidget     *button;
	GtkWidget     *hbox;
	GtkWidget     *stockPixmap;
	GtkWidget     *label;
	
	
	
	/* Create a new button */
	button = gtk_button_new();
	
	
	/* Create a new vertical box and put it into the button */   
	hbox = gtk_hbox_new(FALSE,2);
	gtk_container_add(GTK_CONTAINER(button),hbox);
	
	
	/* Create a label and packit into the box */ 
	label = gtk_label_new(title);
	gtk_box_pack_start_defaults(GTK_BOX(hbox),label);
	
	
	/* Create a widget from the gnome stock pixmap and
	 * packit into the box */
	stockPixmap = gnome_stock_new_with_icon(stock);
	gtk_box_pack_start_defaults(GTK_BOX(hbox),stockPixmap);
	
	
	/* Show all the widgets contained in the box */ 
	gtk_widget_show_all(hbox);
	
	
	return button;
}


