\ spectr.fs -- spectr.cl --> spectr.fs -*- forth -*-

\ Copyright (C) 2004 Michael Scholz

\ Author: Michael Scholz <scholz-micha@gmx.de>
\ Created: Thu Nov 18 15:26:46 CET 2004
\ Last: Thu Nov 18 18:33:19 CET 2004
\ Ident: $Id: spectr.fs,v 1.1 2004/11/18 17:33:26 mike Exp $

\ This file is part of GFM Gforth Music.

\ This program is free software; you can redistribute it and/or
\ modify it under the terms of the GNU General Public License as
\ published by the Free Software Foundation; either version 2 of
\ the License, or (at your option) any later version.

\ This program is distributed in the hope that it will be
\ useful, but WITHOUT ANY WARRANTY; without even the implied
\ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
\ PURPOSE.  See the GNU General Public License for more details.

\ You should have received a copy of the GNU General Public
\ License along with this program; if not, write to the Free
\ Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
\ MA 02111-1307 USA

\ Commentary:

\ Original comment in spectr.cl:
\ 
\ "Spectra courtesy J.A. Moorer
\
\ "I removed phase information, since the psychoacousticians tell us
\ that these normally don't matter.  Also, I omitted any partials with
\ amplitude below 0.0001, although this may have thrown away good
\ data, because the original data was not normalized in any way."

\ contents:
\ 
\ bass clarinet (bc)
\ bassoon       (bsn)
\ cello         (c)
\ clarinet      (cl)
\ french horn   (fh)
\               (fhf)
\ flute         (fl)
\ oboe          (ob)
\ piano         (p)
\ saxophone     (sax)
\ soprano sax   (ssax)
\               (tbf)
\               (tbp)
\ trumpet       (trp)
\               (trpf)
\ violin        (vl)
\               (almf)

\ Code:

require gfm-defs.fs

\ **********************************************************
\ bass clarinet?
\ **********************************************************

vct[ 1.00e 0.0370e 1.98e 0.0037e 2.99e 0.0862e 3.98e 0.0011e 4.97e 0.0270e 5.98e 0.0030e 6.97e 0.0586e 7.95e 0.0031e 8.96e 0.0363e 9.95e 0.0076e 10.93e 0.0310e 11.95e 0.0097e 12.93e 0.0206e 13.92e 0.0045e 14.93e 0.0044e 15.91e 0.0021e 16.90e 0.0220e 17.91e 0.0082e 18.90e 0.0227e 19.88e 0.0049e 20.90e 0.0090e 21.87e 0.0004e 22.87e 0.0051e 23.88e 0.0010e 24.86e 0.0072e 25.85e 0.0026e 26.86e 0.0044e 27.84e 0.0035e 28.85e 0.0031e 29.84e 0.0025e 30.83e 0.0042e 31.84e 0.0024e 32.83e 0.0022e 33.81e 0.0021e 34.82e 0.0011e 35.81e 0.0008e 36.79e 0.0013e 37.80e 0.0024e 38.78e 0.0028e 39.78e 0.0016e 40.79e 0.0024e 41.77e 0.0005e 42.76e 0.0005e 43.77e 0.0003e 44.76e 0.0002e 45.74e 0.0005e 46.75e 0.0003e 47.74e 0.0006e 48.73e 0.0003e 49.74e 0.0009e 50.72e 0.0002e 51.71e 0.0007e 52.72e 0.0004e 53.70e 0.0005e 54.70e 0.0004e 55.71e 0.0005e 56.69e 0.0002e 57.68e 0.0003e 58.69e 0.0002e 59.68e 0.0002e 60.68e 0.0003e 61.68e 0.0002e 62.66e 0.0002e 63.66e 0.0002e 65.65e 0.0001e 67.64e 0.0002e 69.63e 0.0002e 70.63e 0.0002e 71.60e 0.0002e 72.62e 0.0002e 73.60e 0.0002e 75.59e 0.0002e 76.59e 0.0002e 77.58e 0.0001e 78.59e 0.0001e 79.57e 0.0002e 80.57e 0.0002e 81.57e 0.0002e 82.54e 0.0001e 83.56e 0.0002e 84.54e 0.0001e 85.53e 0.0001e 87.53e 0.0002e 89.53e 0.0002e ] constant bc-c2

vct[ 1.02e 0.0306e 2.00e 0.0016e 2.99e 0.0926e 4.00e 0.0027e 5.01e 0.0305e 5.99e 0.0006e 6.99e 0.0158e 8.00e 0.0025e 9.01e 0.0072e 10.01e 0.0057e 10.99e 0.0203e 12.00e 0.0078e 13.01e 0.0147e 14.02e 0.0036e 15.00e 0.0103e 16.07e 0.0007e 17.01e 0.0070e 18.01e 0.0053e 19.00e 0.0049e 20.02e 0.0027e 21.01e 0.0024e 22.01e 0.0014e 23.00e 0.0011e 24.02e 0.0023e 25.00e 0.0031e 26.01e 0.0021e 27.00e 0.0029e 28.02e 0.0010e 29.02e 0.0026e 30.04e 0.0011e 31.00e 0.0019e 32.01e 0.0010e 33.03e 0.0004e 34.02e 0.0002e 36.02e 0.0004e 37.05e 0.0002e 38.04e 0.0004e 39.00e 0.0003e 40.02e 0.0002e 41.01e 0.0002e 42.01e 0.0002e 43.00e 0.0001e 44.02e 0.0001e 45.01e 0.0002e 47.01e 0.0002e 48.03e 0.0001e 49.00e 0.0002e 50.03e 0.0001e 51.02e 0.0001e 55.00e 0.0001e 56.99e 0.0002e 73.98e 0.0001e 75.02e 0.0001e 75.98e 0.0001e ] constant bc-cs2

vct[ 1.01e 0.1419e 1.97e 0.0009e 3.00e 0.0865e 4.01e 0.0008e 5.00e 0.0059e 6.00e 0.0009e 7.00e 0.0110e 8.00e 0.0014e 9.00e 0.0050e 10.00e 0.0057e 11.01e 0.0267e 12.01e 0.0091e 13.00e 0.0238e 14.02e 0.0023e 15.01e 0.0069e 16.01e 0.0033e 17.00e 0.0064e 18.01e 0.0036e 18.99e 0.0067e 20.01e 0.0026e 21.01e 0.0047e 22.01e 0.0037e 22.99e 0.0040e 24.00e 0.0038e 25.01e 0.0036e 26.01e 0.0032e 27.00e 0.0036e 27.99e 0.0019e 29.00e 0.0034e 30.00e 0.0014e 31.00e 0.0007e 31.98e 0.0003e 33.04e 0.0002e 34.05e 0.0003e 35.04e 0.0003e 35.95e 0.0002e 37.05e 0.0003e 37.98e 0.0002e 39.07e 0.0002e 40.02e 0.0002e 40.95e 0.0001e 42.01e 0.0003e 42.98e 0.0002e 44.02e 0.0004e 44.99e 0.0002e 46.03e 0.0002e 46.98e 0.0002e 48.04e 0.0001e 49.01e 0.0001e 51.02e 0.0002e 52.03e 0.0002e 53.01e 0.0002e 54.01e 0.0001e 55.01e 0.0002e 56.02e 0.0001e 65.00e 0.0002e 66.99e 0.0001e 69.01e 0.0001e 71.00e 0.0002e 73.00e 0.0001e 74.99e 0.0001e ] constant bc-d2

vct[ 1.01e 0.2718e 2.01e 0.0016e 3.01e 0.0476e 4.01e 0.0022e 5.01e 0.0228e 6.00e 0.0005e 7.01e 0.0466e 8.01e 0.0014e 9.00e 0.0179e 10.01e 0.0059e 11.00e 0.0254e 12.01e 0.0099e 13.00e 0.0176e 14.01e 0.0031e 15.02e 0.0109e 16.00e 0.0007e 17.02e 0.0090e 18.03e 0.0038e 19.02e 0.0036e 20.02e 0.0029e 21.02e 0.0045e 22.02e 0.0026e 23.02e 0.0060e 24.02e 0.0031e 25.02e 0.0023e 26.02e 0.0033e 27.02e 0.0041e 28.02e 0.0033e 29.02e 0.0034e 30.03e 0.0007e 31.04e 0.0005e 32.03e 0.0005e 33.05e 0.0005e 34.03e 0.0006e 35.05e 0.0002e 36.04e 0.0004e 37.03e 0.0002e 38.03e 0.0003e 39.03e 0.0004e 40.03e 0.0002e 41.03e 0.0004e 42.03e 0.0003e 43.03e 0.0006e 44.04e 0.0002e 45.05e 0.0005e 46.04e 0.0001e 47.05e 0.0003e 48.04e 0.0002e 49.05e 0.0003e 50.04e 0.0001e 51.04e 0.0003e 52.04e 0.0002e 53.04e 0.0001e 55.04e 0.0002e 57.05e 0.0002e 59.06e 0.0002e 61.07e 0.0002e 62.06e 0.0001e 63.06e 0.0002e 64.05e 0.0001e 65.06e 0.0001e 66.06e 0.0002e 67.06e 0.0002e 68.06e 0.0002e 70.06e 0.0002e 72.06e 0.0001e 74.08e 0.0001e ] constant bc-ds2

vct[ 1.01e 0.1365e 2.01e 0.0009e 3.03e 0.0219e 3.99e 0.0004e 5.04e 0.0239e 6.03e 0.0013e 7.02e 0.0284e 8.04e 0.0029e 9.03e 0.0167e 10.06e 0.0042e 11.05e 0.0059e 12.03e 0.0012e 13.07e 0.0095e 14.07e 0.0013e 15.08e 0.0109e 16.06e 0.0038e 17.06e 0.0042e 18.09e 0.0006e 19.07e 0.0034e 20.10e 0.0036e 21.09e 0.0018e 22.08e 0.0025e 23.11e 0.0054e 24.08e 0.0008e 25.12e 0.0035e 26.09e 0.0013e 27.13e 0.0022e 28.13e 0.0009e 29.12e 0.0006e 30.14e 0.0004e 31.13e 0.0005e 32.15e 0.0003e 33.15e 0.0003e 35.15e 0.0002e 36.13e 0.0001e 37.17e 0.0003e 38.19e 0.0002e 39.16e 0.0006e 40.21e 0.0001e 41.17e 0.0005e 42.18e 0.0002e 43.19e 0.0003e 44.18e 0.0001e 45.21e 0.0002e 46.19e 0.0002e 47.22e 0.0004e 48.22e 0.0002e 49.20e 0.0002e 50.23e 0.0001e 55.24e 0.0001e 56.23e 0.0001e 57.26e 0.0002e 59.26e 0.0001e 61.25e 0.0002e 62.29e 0.0002e 64.27e 0.0001e ] constant bc-e2

vct[ 0.99e 0.1014e 2.00e 0.0021e 3.02e 0.0301e 4.02e 0.0012e 5.00e 0.0893e 6.02e 0.0028e 7.03e 0.0333e 8.04e 0.0046e 9.05e 0.0109e 10.03e 0.0033e 11.03e 0.0174e 12.05e 0.0075e 13.06e 0.0085e 14.06e 0.0037e 15.04e 0.0133e 16.08e 0.0021e 17.07e 0.0017e 18.07e 0.0009e 19.05e 0.0015e 20.07e 0.0002e 21.08e 0.0068e 22.09e 0.0033e 23.10e 0.0060e 24.07e 0.0031e 25.08e 0.0036e 26.10e 0.0009e 27.11e 0.0001e 28.11e 0.0010e 29.10e 0.0007e 30.10e 0.0004e 31.12e 0.0005e 32.13e 0.0002e 33.11e 0.0005e 34.11e 0.0003e 35.12e 0.0004e 36.13e 0.0002e 37.14e 0.0005e 38.12e 0.0001e 39.14e 0.0005e 40.14e 0.0002e 41.16e 0.0002e 43.14e 0.0003e 45.17e 0.0004e 46.18e 0.0002e 47.16e 0.0002e 49.18e 0.0002e 51.18e 0.0001e 53.19e 0.0002e 55.22e 0.0001e 56.19e 0.0002e 57.21e 0.0001e 58.22e 0.0002e 60.23e 0.0002e 62.22e 0.0001e ] constant bc-f2

vct[ 1.01e 0.0724e 2.02e 0.0045e 3.01e 0.0626e 4.01e 0.0014e 5.00e 0.1104e 6.00e 0.0041e 7.00e 0.0216e 8.03e 0.0017e 9.03e 0.0255e 10.02e 0.0011e 11.02e 0.0152e 12.02e 0.0019e 13.01e 0.0061e 14.02e 0.0018e 15.04e 0.0077e 16.05e 0.0009e 17.04e 0.0031e 18.04e 0.0014e 19.02e 0.0058e 20.04e 0.0005e 21.03e 0.0030e 22.03e 0.0030e 23.05e 0.0048e 24.06e 0.0013e 25.04e 0.0009e 26.04e 0.0002e 27.03e 0.0008e 28.05e 0.0005e 29.05e 0.0003e 30.06e 0.0002e 31.06e 0.0004e 32.05e 0.0005e 33.05e 0.0003e 34.04e 0.0002e 35.05e 0.0004e 37.08e 0.0006e 38.06e 0.0002e 39.07e 0.0003e 41.06e 0.0003e 42.07e 0.0001e 43.07e 0.0003e 44.09e 0.0002e 45.10e 0.0001e 47.07e 0.0001e 51.10e 0.0002e 53.10e 0.0002e 54.10e 0.0001e 56.09e 0.0002e 57.09e 0.0001e 58.12e 0.0001e 62.11e 0.0001e 64.11e 0.0001e ] constant bc-fs2

vct[ 1.00e 0.0567e 1.99e 0.0037e 3.00e 0.1114e 3.98e 0.0030e 4.99e 0.1112e 5.98e 0.0041e 6.99e 0.0195e 7.99e 0.0061e 8.98e 0.0081e 9.97e 0.0084e 10.98e 0.0139e 11.98e 0.0038e 12.98e 0.0092e 13.97e 0.0038e 14.97e 0.0042e 15.97e 0.0003e 16.97e 0.0012e 17.96e 0.0019e 18.97e 0.0040e 19.95e 0.0032e 20.97e 0.0088e 21.95e 0.0022e 22.96e 0.0025e 23.94e 0.0004e 24.94e 0.0003e 25.92e 0.0005e 26.95e 0.0005e 27.91e 0.0003e 28.95e 0.0003e 29.90e 0.0002e 30.94e 0.0006e 31.89e 0.0001e 32.93e 0.0007e 34.92e 0.0005e 35.89e 0.0002e 36.92e 0.0003e 37.89e 0.0001e 38.91e 0.0002e 39.88e 0.0002e 40.90e 0.0004e 41.88e 0.0002e 43.88e 0.0002e 50.90e 0.0001e 51.89e 0.0002e 52.93e 0.0001e 53.89e 0.0003e 55.87e 0.0002e ] constant bc-g2

vct[ 0.99e 0.0794e 2.00e 0.0021e 3.00e 0.1294e 3.98e 0.0015e 4.98e 0.0849e 5.98e 0.0058e 6.99e 0.0389e 7.97e 0.0113e 8.97e 0.0154e 9.98e 0.0026e 10.98e 0.0172e 11.95e 0.0048e 12.95e 0.0099e 13.98e 0.0011e 14.97e 0.0029e 15.95e 0.0013e 16.95e 0.0055e 17.97e 0.0014e 18.96e 0.0052e 19.94e 0.0040e 20.94e 0.0038e 21.96e 0.0006e 22.94e 0.0003e 23.92e 0.0005e 24.93e 0.0005e 25.93e 0.0002e 26.94e 0.0006e 27.92e 0.0003e 28.91e 0.0007e 29.91e 0.0004e 30.93e 0.0006e 31.90e 0.0003e 32.90e 0.0006e 33.90e 0.0003e 34.91e 0.0004e 35.89e 0.0001e 36.89e 0.0003e 37.90e 0.0003e 38.90e 0.0003e 40.88e 0.0002e 42.89e 0.0001e 45.89e 0.0002e 47.87e 0.0001e 49.87e 0.0003e 50.86e 0.0002e 51.85e 0.0002e 53.86e 0.0001e ] constant bc-gs2

vct[ 0.99e 0.1177e 1.99e 0.0047e 2.99e 0.2346e 3.99e 0.0023e 4.98e 0.0538e 5.99e 0.0060e 6.98e 0.0493e 7.99e 0.0062e 8.99e 0.0103e 9.99e 0.0030e 10.99e 0.0146e 11.99e 0.0126e 12.99e 0.0042e 13.99e 0.0016e 14.99e 0.0060e 15.98e 0.0034e 16.96e 0.0039e 17.96e 0.0036e 18.96e 0.0076e 19.96e 0.0018e 20.96e 0.0025e 22.95e 0.0018e 23.95e 0.0005e 24.94e 0.0003e 25.95e 0.0005e 26.95e 0.0006e 27.95e 0.0008e 28.96e 0.0005e 29.96e 0.0005e 30.96e 0.0007e 31.95e 0.0005e 32.95e 0.0005e 33.95e 0.0001e 34.95e 0.0003e 35.93e 0.0002e 36.94e 0.0003e 38.92e 0.0002e 42.93e 0.0001e 44.93e 0.0001e 46.93e 0.0002e 47.92e 0.0001e ] constant bc-a2

vct[ 1.00e 0.1279e 1.99e 0.0028e 2.99e 0.1611e 3.98e 0.0034e 4.97e 0.0322e 5.97e 0.0085e 6.98e 0.0274e 7.97e 0.0068e 8.96e 0.0245e 9.97e 0.0022e 10.94e 0.0254e 11.93e 0.0010e 12.93e 0.0078e 13.95e 0.0022e 14.94e 0.0035e 15.92e 0.0022e 16.92e 0.0033e 17.91e 0.0039e 18.90e 0.0037e 19.92e 0.0012e 20.92e 0.0003e 21.91e 0.0008e 22.89e 0.0005e 23.88e 0.0007e 24.87e 0.0007e 25.87e 0.0005e 26.88e 0.0007e 27.86e 0.0001e 28.86e 0.0014e 29.84e 0.0004e 30.85e 0.0005e 31.85e 0.0001e 32.85e 0.0004e 33.84e 0.0004e 34.84e 0.0003e 36.82e 0.0003e 40.81e 0.0003e 42.80e 0.0001e 43.79e 0.0002e 44.79e 0.0002e 45.79e 0.0003e 46.79e 0.0001e 47.79e 0.0002e 49.77e 0.0001e ] constant bc-as2

vct[ 1.00e 0.1161e 1.98e 0.0036e 2.97e 0.1813e 3.98e 0.0038e 4.96e 0.0298e 5.95e 0.0073e 6.95e 0.0125e 7.95e 0.0064e 8.92e 0.0175e 9.94e 0.0087e 10.91e 0.0117e 11.91e 0.0025e 12.91e 0.0055e 13.92e 0.0027e 14.88e 0.0069e 15.88e 0.0034e 16.88e 0.0052e 17.85e 0.0038e 18.88e 0.0003e 19.83e 0.0005e 20.83e 0.0005e 21.78e 0.0002e 22.82e 0.0004e 23.74e 0.0002e 24.81e 0.0008e 25.76e 0.0003e 26.78e 0.0005e 27.78e 0.0006e 28.78e 0.0005e 29.74e 0.0002e 30.75e 0.0001e 31.75e 0.0004e 32.72e 0.0002e 33.73e 0.0002e 34.73e 0.0002e 41.69e 0.0002e 42.68e 0.0002e 43.67e 0.0002e 44.68e 0.0002e 45.67e 0.0001e ] constant bc-b2

vct[ 1.00e 0.1579e 1.99e 0.0068e 2.99e 0.1885e 3.99e 0.0022e 4.97e 0.0384e 5.96e 0.0054e 6.97e 0.0247e 7.97e 0.0023e 8.96e 0.0114e 9.95e 0.0096e 10.93e 0.0054e 11.95e 0.0030e 12.94e 0.0036e 13.92e 0.0075e 14.93e 0.0033e 15.92e 0.0052e 16.91e 0.0010e 17.91e 0.0011e 18.90e 0.0004e 19.89e 0.0006e 20.90e 0.0005e 21.89e 0.0003e 22.87e 0.0004e 23.88e 0.0004e 24.87e 0.0005e 25.86e 0.0008e 26.87e 0.0005e 27.85e 0.0002e 28.84e 0.0002e 29.85e 0.0003e 30.83e 0.0002e 31.84e 0.0002e 32.83e 0.0002e 35.83e 0.0001e 36.80e 0.0002e 38.81e 0.0002e 39.78e 0.0002e 40.78e 0.0003e 41.79e 0.0001e ] constant bc-c3

vct[ 1.00e 0.2106e 1.98e 0.0073e 2.99e 0.1027e 3.98e 0.0038e 4.97e 0.0191e 5.98e 0.0036e 6.97e 0.0256e 7.95e 0.0035e 8.97e 0.0347e 9.95e 0.0039e 10.94e 0.0048e 11.95e 0.0026e 12.94e 0.0089e 13.93e 0.0011e 14.93e 0.0052e 15.93e 0.0033e 16.96e 0.0002e 17.93e 0.0003e 18.94e 0.0001e 19.92e 0.0002e 20.91e 0.0007e 21.91e 0.0006e 22.89e 0.0005e 23.90e 0.0005e 24.90e 0.0005e 25.87e 0.0005e 26.89e 0.0003e 27.88e 0.0005e 28.87e 0.0003e 29.87e 0.0003e 31.85e 0.0002e 33.84e 0.0001e 34.84e 0.0001e 36.82e 0.0003e 37.83e 0.0001e 38.83e 0.0003e ] constant bc-cs3

vct[ 1.01e 0.2039e 2.00e 0.0041e 3.00e 0.0640e 3.99e 0.0062e 5.00e 0.0192e 6.00e 0.0013e 7.01e 0.0225e 8.00e 0.0034e 9.01e 0.0245e 10.00e 0.0038e 11.02e 0.0028e 12.01e 0.0030e 13.02e 0.0042e 14.00e 0.0021e 15.01e 0.0049e 16.02e 0.0006e 17.02e 0.0003e 18.02e 0.0007e 19.00e 0.0001e 20.03e 0.0005e 21.02e 0.0010e 22.05e 0.0002e 23.04e 0.0012e 24.05e 0.0003e 25.02e 0.0002e 26.03e 0.0003e 27.02e 0.0004e 28.03e 0.0001e 29.05e 0.0002e 30.05e 0.0001e 33.03e 0.0001e 34.04e 0.0001e 35.04e 0.0001e 36.04e 0.0003e 38.05e 0.0001e 40.04e 0.0001e ] constant bc-d3

vct[ 1.01e 0.1501e 2.00e 0.0036e 3.00e 0.0682e 4.00e 0.0069e 4.99e 0.0142e 5.98e 0.0017e 6.99e 0.0322e 7.99e 0.0063e 8.98e 0.0019e 10.00e 0.0010e 11.00e 0.0046e 11.99e 0.0023e 12.99e 0.0035e 13.98e 0.0041e 14.98e 0.0020e 15.97e 0.0001e 16.98e 0.0003e 17.98e 0.0008e 18.98e 0.0009e 20.03e 0.0002e 21.00e 0.0007e 21.99e 0.0006e 22.99e 0.0006e 23.99e 0.0003e 24.98e 0.0004e 25.98e 0.0003e 26.97e 0.0001e 27.98e 0.0001e 29.97e 0.0001e 30.98e 0.0002e 32.96e 0.0003e 33.97e 0.0003e 34.95e 0.0002e 35.96e 0.0002e 36.97e 0.0001e ] constant bc-ds3

vct[ 0.99e 0.1413e 1.99e 0.0047e 3.00e 0.0710e 4.01e 0.0016e 5.01e 0.0154e 6.01e 0.0063e 7.01e 0.0122e 8.02e 0.0179e 9.00e 0.0044e 10.00e 0.0082e 11.01e 0.0058e 12.01e 0.0031e 13.02e 0.0045e 14.02e 0.0027e 15.02e 0.0004e 16.03e 0.0010e 17.01e 0.0008e 18.04e 0.0002e 19.04e 0.0004e 20.03e 0.0006e 21.04e 0.0004e 22.03e 0.0003e 23.04e 0.0004e 24.04e 0.0002e 25.04e 0.0003e 26.06e 0.0001e 27.04e 0.0003e 28.03e 0.0002e 29.02e 0.0003e 30.99e 0.0002e 32.04e 0.0006e 33.03e 0.0002e 34.04e 0.0003e 36.04e 0.0001e ] constant bc-e3

vct[ 0.99e 0.2534e 1.99e 0.0057e 3.00e 0.0476e 3.98e 0.0101e 4.98e 0.0334e 5.97e 0.0066e 6.98e 0.0489e 7.96e 0.0038e 8.96e 0.0096e 9.95e 0.0008e 10.96e 0.0056e 11.95e 0.0049e 12.95e 0.0029e 13.95e 0.0002e 14.95e 0.0006e 15.96e 0.0002e 16.96e 0.0008e 17.94e 0.0004e 18.93e 0.0002e 19.94e 0.0009e 20.94e 0.0002e 21.93e 0.0004e 22.94e 0.0004e 23.93e 0.0004e 25.90e 0.0004e 26.90e 0.0003e 27.89e 0.0001e 28.91e 0.0004e 29.87e 0.0001e 30.89e 0.0005e 32.89e 0.0002e 33.87e 0.0001e ] constant bc-f3

vct[ 1.00e 0.3131e 1.99e 0.0095e 3.00e 0.0885e 3.99e 0.0194e 4.98e 0.0653e 5.99e 0.0049e 6.98e 0.0528e 7.99e 0.0038e 8.98e 0.0129e 9.97e 0.0042e 10.98e 0.0063e 11.97e 0.0023e 12.97e 0.0016e 13.98e 0.0002e 14.97e 0.0004e 15.97e 0.0005e 16.97e 0.0006e 17.96e 0.0001e 18.96e 0.0008e 20.95e 0.0007e 21.96e 0.0001e 22.95e 0.0001e 23.94e 0.0003e 25.94e 0.0004e 26.95e 0.0004e 27.94e 0.0005e 28.93e 0.0003e 29.94e 0.0003e 31.93e 0.0002e 33.92e 0.0002e ] constant bc-fs3

vct[ 1.00e 0.2177e 2.01e 0.0024e 3.01e 0.0126e 4.02e 0.0067e 5.02e 0.0577e 6.02e 0.0083e 7.02e 0.0215e 8.03e 0.0034e 9.03e 0.0047e 10.04e 0.0046e 11.05e 0.0143e 12.04e 0.0037e 13.04e 0.0010e 14.05e 0.0005e 15.06e 0.0005e 16.06e 0.0003e 17.06e 0.0002e 18.06e 0.0004e 19.09e 0.0001e 20.08e 0.0003e 21.08e 0.0002e 23.08e 0.0003e 24.08e 0.0003e 25.08e 0.0001e 26.10e 0.0010e 27.11e 0.0002e 28.10e 0.0004e 30.12e 0.0003e 32.13e 0.0003e ] constant bc-g3

vct[ 1.01e 0.1420e 2.01e 0.0026e 3.01e 0.0289e 4.03e 0.0162e 5.03e 0.0373e 6.02e 0.0015e 7.03e 0.0112e 8.05e 0.0068e 9.05e 0.0063e 10.04e 0.0027e 11.06e 0.0022e 12.07e 0.0004e 13.06e 0.0008e 14.07e 0.0011e 15.08e 0.0003e 16.08e 0.0002e 17.09e 0.0005e 19.11e 0.0003e 23.12e 0.0004e 24.12e 0.0003e 25.14e 0.0002e 26.14e 0.0003e 27.14e 0.0002e 28.14e 0.0002e 29.16e 0.0002e 30.16e 0.0001e 34.18e 0.0002e ] constant bc-gs3

vct[ 1.01e 0.2365e 2.02e 0.0034e 3.03e 0.0242e 4.04e 0.0251e 5.04e 0.0203e 6.06e 0.0078e 7.06e 0.0213e 8.08e 0.0162e 9.09e 0.0121e 10.10e 0.0053e 11.11e 0.0024e 12.12e 0.0028e 13.14e 0.0010e 14.13e 0.0006e 15.15e 0.0009e 16.16e 0.0008e 17.17e 0.0009e 18.18e 0.0006e 19.19e 0.0003e 20.20e 0.0003e 21.20e 0.0003e 22.22e 0.0004e 23.22e 0.0002e 24.24e 0.0007e 26.26e 0.0003e 27.26e 0.0001e 29.29e 0.0003e ] constant bc-a3

vct[ 1.00e 0.1078e 2.01e 0.0072e 3.02e 0.0487e 4.04e 0.0332e 5.05e 0.0329e 6.06e 0.0069e 7.07e 0.0153e 8.08e 0.0061e 9.08e 0.0082e 10.09e 0.0023e 11.10e 0.0003e 12.11e 0.0009e 13.12e 0.0008e 14.13e 0.0007e 15.15e 0.0003e 16.16e 0.0006e 17.16e 0.0007e 18.16e 0.0003e 19.17e 0.0003e 20.18e 0.0005e 21.19e 0.0005e 22.20e 0.0005e 23.22e 0.0004e 24.23e 0.0001e 26.25e 0.0001e 27.25e 0.0001e 28.26e 0.0001e ] constant bc-as3

vct[ 1.01e 0.0572e 2.02e 0.0086e 3.03e 0.0724e 4.04e 0.0057e 5.04e 0.0365e 6.05e 0.0058e 7.06e 0.0083e 8.07e 0.0113e 9.08e 0.0102e 10.09e 0.0022e 11.10e 0.0012e 12.11e 0.0005e 13.11e 0.0014e 14.12e 0.0003e 15.13e 0.0008e 16.14e 0.0009e 17.15e 0.0003e 18.16e 0.0002e 19.17e 0.0006e 20.18e 0.0009e 21.19e 0.0002e 22.19e 0.0006e 23.20e 0.0004e 24.21e 0.0004e 25.22e 0.0001e ] constant bc-b3

vct[ 1.01e 0.0509e 2.02e 0.0146e 3.02e 0.0344e 4.03e 0.0126e 5.04e 0.0254e 6.05e 0.0004e 7.05e 0.0134e 8.06e 0.0069e 9.08e 0.0007e 10.09e 0.0005e 11.09e 0.0006e 12.09e 0.0004e 13.11e 0.0010e 14.12e 0.0001e 15.12e 0.0008e 16.13e 0.0001e 17.14e 0.0003e 18.15e 0.0002e 19.17e 0.0001e 20.16e 0.0004e 21.17e 0.0002e ] constant bc-c4

vct[ 1.00e 0.1853e 2.00e 0.0169e 3.01e 0.0922e 4.01e 0.0035e 5.01e 0.0204e 6.01e 0.0046e 7.02e 0.0077e 8.02e 0.0085e 9.02e 0.0028e 10.05e 0.0002e 11.02e 0.0003e 12.03e 0.0006e 13.05e 0.0002e 14.03e 0.0006e 15.04e 0.0006e 16.04e 0.0004e 17.02e 0.0003e 18.04e 0.0006e 19.04e 0.0004e 20.04e 0.0003e 21.06e 0.0001e 22.04e 0.0001e 23.06e 0.0002e ] constant bc-cs4

vct[ 1.00e 0.3391e 2.00e 0.0134e 2.99e 0.0186e 3.99e 0.0424e 4.98e 0.0122e 5.98e 0.0055e 6.97e 0.0197e 7.98e 0.0034e 8.97e 0.0017e 9.98e 0.0004e 10.96e 0.0008e 11.96e 0.0009e 12.96e 0.0003e 13.96e 0.0007e 14.95e 0.0004e 15.94e 0.0002e 16.95e 0.0003e 17.94e 0.0008e 18.93e 0.0002e 19.93e 0.0001e ] constant bc-d4

vct[ 0.99e 0.3684e 1.98e 0.0187e 2.98e 0.0647e 3.97e 0.0186e 4.97e 0.0070e 5.96e 0.0127e 6.95e 0.0173e 7.94e 0.0011e 8.94e 0.0011e 9.93e 0.0014e 10.92e 0.0013e 11.90e 0.0001e 12.90e 0.0006e 13.91e 0.0003e 14.89e 0.0003e 15.89e 0.0001e 16.88e 0.0010e 17.88e 0.0004e 18.86e 0.0001e 19.86e 0.0002e 20.85e 0.0001e ] constant bc-ds4

vct[ 1.00e 0.5390e 3.01e 0.0188e 4.00e 0.0247e 5.00e 0.0129e 6.01e 0.0050e 7.01e 0.0014e 8.01e 0.0012e 9.01e 0.0012e 10.01e 0.0010e 11.02e 0.0005e 12.02e 0.0002e 13.03e 0.0004e ] constant bc-e4

vct[ 1.01e 0.5398e 2.01e 0.0309e 3.01e 0.0727e 4.01e 0.0062e 5.01e 0.0041e 6.02e 0.0280e 7.02e 0.0005e 8.02e 0.0014e 9.02e 0.0013e 10.02e 0.0030e 11.03e 0.0006e 12.03e 0.0004e 14.03e 0.0003e 15.04e 0.0003e 16.04e 0.0007e ] constant bc-f4

vct[ 1.00e 0.6398e 2.01e 0.0314e 3.01e 0.0423e 4.01e 0.0292e 5.01e 0.0093e 6.02e 0.0088e 7.02e 0.0010e 8.03e 0.0043e 9.02e 0.0004e 10.03e 0.0013e 11.03e 0.0003e 12.04e 0.0003e 13.02e 0.0002e 14.04e 0.0010e 15.04e 0.0006e 16.05e 0.0001e 17.04e 0.0003e ] constant bc-fs4

vct[ 1.00e 0.5985e 1.99e 0.0192e 2.99e 0.0346e 3.99e 0.0257e 4.98e 0.0082e 5.98e 0.0037e 6.98e 0.0008e 7.99e 0.0013e 8.97e 0.0014e 9.98e 0.0016e 10.98e 0.0010e 11.98e 0.0005e 12.97e 0.0005e 13.97e 0.0008e 14.95e 0.0002e 15.96e 0.0003e ] constant bc-g4

vct[ 1.00e 0.2635e 1.99e 0.0230e 2.99e 0.0936e 3.99e 0.0214e 4.99e 0.0320e 5.99e 0.0013e 6.99e 0.0020e 7.99e 0.0004e 8.99e 0.0014e 9.99e 0.0003e 10.99e 0.0003e 11.98e 0.0005e 12.98e 0.0015e 13.98e 0.0005e 14.98e 0.0003e 15.98e 0.0003e 18.98e 0.0001e ] constant bc-gs4

vct[ 1.00e 0.1539e 2.00e 0.0355e 3.00e 0.0834e 4.01e 0.0210e 5.01e 0.0103e 6.00e 0.0035e 7.02e 0.0004e 8.01e 0.0008e 9.00e 0.0002e 10.01e 0.0001e 11.01e 0.0005e 12.01e 0.0007e 13.02e 0.0011e 14.01e 0.0003e 15.02e 0.0003e 18.02e 0.0002e ] constant bc-a4

vct[ 1.00e 0.1843e 2.01e 0.0229e 3.00e 0.0348e 4.01e 0.0157e 5.01e 0.0170e 6.01e 0.0037e 7.02e 0.0012e 8.02e 0.0027e 9.02e 0.0003e 10.02e 0.0011e 11.03e 0.0010e 12.03e 0.0007e 13.03e 0.0004e 14.03e 0.0002e 15.03e 0.0002e 17.04e 0.0002e ] constant bc-as4

vct[ 1.00e 0.5063e 2.01e 0.0563e 3.01e 0.0376e 4.01e 0.0383e 5.01e 0.0135e 6.02e 0.0081e 7.02e 0.0011e 8.02e 0.0049e 9.03e 0.0007e 10.03e 0.0006e 11.04e 0.0013e 12.04e 0.0007e 13.04e 0.0004e 14.05e 0.0002e 15.05e 0.0002e 17.05e 0.0002e 19.06e 0.0001e ] constant bc-b4

vct[ 1.00e 0.5459e 2.00e 0.0278e 3.01e 0.0456e 4.01e 0.0648e 5.02e 0.0035e 6.02e 0.0050e 7.02e 0.0025e 8.02e 0.0021e 9.02e 0.0005e 10.03e 0.0007e 11.03e 0.0016e 12.03e 0.0007e 13.04e 0.0001e 14.03e 0.0002e 15.04e 0.0002e 18.05e 0.0002e 19.05e 0.0001e 20.05e 0.0002e ] constant bc-c5

vct[ 1.00e 0.2584e 2.01e 0.0583e 3.02e 0.1090e 4.02e 0.0290e 5.02e 0.0020e 6.03e 0.0018e 7.03e 0.0016e 8.03e 0.0001e 9.04e 0.0005e 10.05e 0.0017e 11.05e 0.0010e 12.05e 0.0002e 13.06e 0.0001e 14.06e 0.0001e 17.08e 0.0002e 18.08e 0.0001e 19.08e 0.0001e ] constant bc-cs5

vct[ 1.00e 0.1626e 2.00e 0.0485e 3.01e 0.0856e 4.00e 0.0023e 5.01e 0.0096e 6.01e 0.0042e 7.01e 0.0015e 8.01e 0.0004e 9.02e 0.0019e 10.02e 0.0016e 11.02e 0.0003e 12.02e 0.0002e 13.02e 0.0002e 16.03e 0.0001e 17.03e 0.0001e 18.03e 0.0002e 19.03e 0.0001e ] constant bc-d5

vct[ 1.00e 0.1756e 1.99e 0.1645e 2.99e 0.0381e 3.98e 0.0028e 4.98e 0.0042e 5.98e 0.0004e 6.97e 0.0025e 7.97e 0.0006e 8.96e 0.0022e 9.96e 0.0011e 10.96e 0.0002e 13.94e 0.0002e 14.94e 0.0002e 15.94e 0.0001e 16.93e 0.0001e 17.93e 0.0001e ] constant bc-ds5

vct[ 0.99e 0.2661e 1.99e 0.1398e 2.99e 0.0589e 3.99e 0.0048e 4.98e 0.0022e 5.98e 0.0015e 6.97e 0.0021e 7.97e 0.0008e 8.96e 0.0011e 9.96e 0.0009e 10.95e 0.0004e 11.94e 0.0001e 13.94e 0.0001e 14.94e 0.0001e 15.94e 0.0001e ] constant bc-e5

vct[ 1.00e 0.1378e 2.00e 0.0654e 3.00e 0.1301e 4.00e 0.0049e 5.00e 0.0030e 6.01e 0.0018e 7.01e 0.0030e 8.01e 0.0015e 9.01e 0.0008e 10.01e 0.0001e 11.01e 0.0003e 12.01e 0.0002e 13.01e 0.0001e 14.01e 0.0002e 15.01e 0.0002e 16.02e 0.0001e ] constant bc-f5

vct[ 1.00e 0.3952e 2.01e 0.1124e 3.01e 0.0326e 4.02e 0.0104e 5.03e 0.0013e 6.03e 0.0010e 7.03e 0.0009e 8.04e 0.0009e 9.05e 0.0002e 10.05e 0.0003e 11.05e 0.0001e 13.06e 0.0002e 14.07e 0.0003e 15.08e 0.0002e ] constant bc-fs5

vct[ 1.01e 0.3434e 2.01e 0.0390e 3.02e 0.0051e 4.03e 0.0057e 5.04e 0.0042e 6.05e 0.0017e 7.06e 0.0022e 8.06e 0.0012e 9.07e 0.0002e 10.07e 0.0001e 11.08e 0.0002e 12.09e 0.0002e 13.10e 0.0002e 14.11e 0.0002e 15.12e 0.0001e ] constant bc-g5

vct[ 1.00e 0.1109e 1.99e 0.0911e 2.98e 0.0061e 3.98e 0.0062e 4.98e 0.0020e 5.97e 0.0006e 6.96e 0.0008e 7.96e 0.0013e 8.95e 0.0002e 10.94e 0.0002e 11.94e 0.0002e 12.93e 0.0002e 13.93e 0.0001e ] constant bc-gs5

vct[ 1.00e 0.1585e 2.00e 0.0562e 3.00e 0.0039e 4.00e 0.0064e 5.00e 0.0016e 6.00e 0.0022e 7.00e 0.0009e 8.00e 0.0004e 9.00e 0.0002e 11.00e 0.0003e 12.00e 0.0003e 13.00e 0.0002e 14.00e 0.0002e ] constant bc-a5

vct[ 0.99e 0.1211e 1.98e 0.0394e 2.97e 0.0093e 3.96e 0.0024e 4.95e 0.0030e 5.94e 0.0027e 6.93e 0.0006e 8.92e 0.0002e 10.90e 0.0001e 12.88e 0.0001e ] constant bc-as5

\ **********************************************************
\ bassoon?
\ **********************************************************

vct[ 1.00e 0.0038e 2.02e 0.0235e 3.04e 0.0511e 4.06e 0.0348e 5.07e 0.0491e 6.09e 0.0518e 7.11e 0.0184e 8.12e 0.0381e 9.11e 0.1027e 10.13e 0.0412e 11.15e 0.0112e 12.17e 0.0144e 13.18e 0.0097e 14.20e 0.0074e 15.21e 0.0081e 16.23e 0.0067e 17.22e 0.0108e 18.24e 0.0113e 19.25e 0.0114e 20.28e 0.0066e 21.30e 0.0065e 22.32e 0.0035e 23.33e 0.0041e 24.33e 0.0036e 25.34e 0.0025e 26.35e 0.0010e 27.37e 0.0021e 28.39e 0.0007e 29.42e 0.0006e 30.42e 0.0009e 31.43e 0.0005e 32.43e 0.0003e 33.46e 0.0005e 34.46e 0.0002e 35.48e 0.0002e 36.48e 0.0004e 37.52e 0.0003e 38.53e 0.0003e 39.55e 0.0002e 40.56e 0.0002e 51.69e 0.0001e 54.72e 0.0002e ] constant bsn-as1

vct[ 1.01e 0.0039e 2.02e 0.0230e 3.02e 0.0517e 4.03e 0.0473e 5.03e 0.0443e 6.03e 0.0691e 7.03e 0.0664e 8.04e 0.0408e 9.04e 0.1283e 10.06e 0.0429e 11.07e 0.0339e 12.08e 0.0223e 13.08e 0.0207e 14.08e 0.0256e 15.08e 0.0171e 16.09e 0.0106e 17.09e 0.0136e 18.09e 0.0082e 19.12e 0.0052e 20.12e 0.0041e 21.13e 0.0015e 22.13e 0.0023e 23.12e 0.0021e 24.12e 0.0009e 25.13e 0.0029e 26.14e 0.0014e 27.15e 0.0003e 28.15e 0.0010e 29.17e 0.0013e 30.18e 0.0003e 31.19e 0.0005e 32.19e 0.0007e 33.19e 0.0004e 34.20e 0.0005e 35.19e 0.0005e 36.19e 0.0003e 37.21e 0.0003e 38.23e 0.0002e 39.23e 0.0001e 40.23e 0.0001e 43.23e 0.0001e 46.26e 0.0002e 49.27e 0.0002e 51.27e 0.0003e 52.27e 0.0002e 53.28e 0.0002e ] constant bsn-b1

vct[ 1.01e 0.0047e 2.03e 0.0390e 3.04e 0.0460e 4.04e 0.0217e 5.05e 0.0464e 6.05e 0.0631e 7.06e 0.0874e 8.07e 0.1167e 9.08e 0.0339e 10.09e 0.0209e 11.11e 0.0133e 12.12e 0.0088e 13.11e 0.0092e 14.14e 0.0032e 15.15e 0.0026e 16.16e 0.0061e 17.17e 0.0019e 18.17e 0.0051e 19.18e 0.0161e 20.18e 0.0048e 21.20e 0.0044e 22.21e 0.0035e 23.23e 0.0010e 24.24e 0.0028e 25.25e 0.0006e 26.26e 0.0013e 27.27e 0.0016e 28.26e 0.0002e 29.28e 0.0006e 30.28e 0.0006e 31.30e 0.0004e 32.32e 0.0012e 33.33e 0.0003e 34.34e 0.0003e 35.35e 0.0002e 36.34e 0.0001e 43.41e 0.0001e 46.43e 0.0001e 48.44e 0.0001e 51.48e 0.0001e ] constant bsn-c2

vct[ 1.01e 0.0090e 2.02e 0.0531e 3.01e 0.0318e 4.01e 0.0199e 5.02e 0.0211e 6.04e 0.0629e 7.04e 0.1340e 8.05e 0.0925e 9.04e 0.0206e 10.04e 0.0584e 11.05e 0.0140e 12.07e 0.0066e 13.08e 0.0068e 14.08e 0.0011e 15.07e 0.0028e 16.07e 0.0015e 17.08e 0.0041e 18.10e 0.0106e 19.10e 0.0034e 20.10e 0.0033e 21.10e 0.0020e 22.10e 0.0021e 23.11e 0.0040e 24.13e 0.0001e 25.12e 0.0004e 26.13e 0.0003e 28.13e 0.0004e 29.14e 0.0002e 30.16e 0.0001e 31.17e 0.0001e 43.20e 0.0001e 46.22e 0.0002e ] constant bsn-cs2

vct[ 1.01e 0.0616e 2.00e 0.0436e 3.00e 0.0430e 3.99e 0.0491e 5.01e 0.0358e 6.01e 0.1695e 7.00e 0.1562e 7.99e 0.0174e 8.99e 0.0062e 10.01e 0.0054e 11.00e 0.0104e 12.00e 0.0055e 12.99e 0.0052e 13.99e 0.0018e 15.00e 0.0021e 16.00e 0.0019e 16.99e 0.0087e 17.98e 0.0025e 18.99e 0.0027e 20.00e 0.0015e 21.00e 0.0024e 21.98e 0.0015e 22.99e 0.0002e 24.00e 0.0006e 25.99e 0.0001e 26.95e 0.0001e 28.00e 0.0001e 28.94e 0.0001e 30.01e 0.0002e ] constant bsn-d2

vct[ 1.01e 0.0769e 2.01e 0.0341e 3.00e 0.0240e 4.00e 0.0633e 5.00e 0.0124e 5.99e 0.0850e 6.99e 0.1044e 7.99e 0.0115e 8.99e 0.0046e 10.00e 0.0048e 11.00e 0.0054e 12.00e 0.0082e 13.00e 0.0033e 14.00e 0.0080e 15.00e 0.0022e 15.99e 0.0081e 16.99e 0.0028e 17.98e 0.0038e 18.98e 0.0028e 19.99e 0.0032e 20.99e 0.0007e 22.00e 0.0003e 22.98e 0.0004e 23.99e 0.0001e 24.98e 0.0005e 25.98e 0.0002e 26.97e 0.0003e 28.98e 0.0001e 38.97e 0.0001e 40.97e 0.0001e ] constant bsn-ds2

vct[ 1.00e 0.0369e 1.98e 0.0190e 3.00e 0.0291e 3.98e 0.0844e 5.00e 0.0730e 5.98e 0.0856e 7.00e 0.0563e 7.98e 0.0792e 9.00e 0.0139e 9.97e 0.0127e 10.99e 0.0046e 11.96e 0.0052e 12.99e 0.0043e 13.97e 0.0030e 14.99e 0.0102e 15.98e 0.0020e 16.97e 0.0029e 17.98e 0.0010e 18.96e 0.0040e 19.98e 0.0008e 20.97e 0.0004e 21.99e 0.0001e 23.98e 0.0004e 25.96e 0.0002e 26.93e 0.0001e 36.94e 0.0001e ] constant bsn-e2

vct[ 0.99e 0.0208e 2.00e 0.0164e 3.01e 0.0576e 4.02e 0.0547e 5.02e 0.0965e 5.99e 0.1701e 7.00e 0.0206e 8.01e 0.0040e 9.02e 0.0075e 10.02e 0.0033e 11.00e 0.0067e 12.00e 0.0021e 13.01e 0.0010e 14.02e 0.0072e 15.03e 0.0014e 16.01e 0.0028e 17.01e 0.0034e 18.02e 0.0026e 19.03e 0.0007e 20.05e 0.0004e 20.43e 0.0001e 22.02e 0.0001e 24.01e 0.0003e 26.03e 0.0001e ] constant bsn-f2

vct[ 1.00e 0.0112e 1.99e 0.0211e 2.98e 0.0379e 3.97e 0.0630e 4.98e 0.0727e 5.97e 0.1555e 6.95e 0.0348e 7.94e 0.0362e 8.96e 0.0083e 9.94e 0.0145e 10.92e 0.0070e 11.91e 0.0031e 12.93e 0.0059e 13.92e 0.0054e 14.91e 0.0024e 15.89e 0.0024e 16.88e 0.0045e 17.90e 0.0013e 18.91e 0.0007e 19.87e 0.0005e 20.87e 0.0004e 21.88e 0.0002e 22.85e 0.0007e 23.84e 0.0003e 24.83e 0.0002e 26.84e 0.0001e 28.80e 0.0002e 29.80e 0.0001e 30.81e 0.0003e 31.81e 0.0001e 32.78e 0.0003e 33.77e 0.0001e 34.79e 0.0002e ] constant bsn-fs2

vct[ 0.98e 0.0330e 1.99e 0.0314e 2.95e 0.0487e 3.95e 0.0272e 4.95e 0.2864e 5.91e 0.0849e 6.92e 0.0047e 7.89e 0.0049e 8.88e 0.0015e 9.88e 0.0060e 10.85e 0.0051e 11.85e 0.0013e 12.83e 0.0083e 13.82e 0.0018e 14.82e 0.0010e 15.78e 0.0032e 16.79e 0.0007e 17.77e 0.0004e 18.76e 0.0005e 19.76e 0.0008e 20.72e 0.0004e 21.72e 0.0009e 22.72e 0.0003e 23.69e 0.0002e ] constant bsn-g2

vct[ 0.98e 0.0321e 1.98e 0.0281e 2.99e 0.0196e 3.99e 0.0683e 4.96e 0.2698e 5.95e 0.0125e 6.95e 0.0153e 7.96e 0.0034e 8.96e 0.0050e 9.93e 0.0056e 10.92e 0.0049e 11.92e 0.0160e 12.92e 0.0072e 13.91e 0.0013e 14.89e 0.0028e 15.91e 0.0005e 16.86e 0.0004e 17.89e 0.0006e 18.89e 0.0009e 19.87e 0.0005e 20.85e 0.0001e 21.87e 0.0003e 27.83e 0.0001e 28.82e 0.0002e ] constant bsn-gs2

vct[ 0.99e 0.0170e 2.00e 0.0296e 3.00e 0.0324e 4.01e 0.1542e 5.02e 0.1393e 6.02e 0.0249e 7.03e 0.0041e 8.03e 0.0022e 9.01e 0.0043e 10.02e 0.0077e 11.03e 0.0092e 12.04e 0.0021e 13.04e 0.0027e 14.05e 0.0026e 15.06e 0.0007e 16.05e 0.0001e 17.05e 0.0003e 18.04e 0.0006e 19.04e 0.0004e 20.05e 0.0002e 26.06e 0.0003e 27.06e 0.0002e 29.07e 0.0001e ] constant bsn-a2

vct[ 1.01e 0.0153e 2.00e 0.0261e 3.00e 0.0305e 3.99e 0.1573e 4.97e 0.0908e 5.98e 0.0053e 6.97e 0.0054e 7.98e 0.0159e 8.99e 0.0031e 9.99e 0.0015e 10.96e 0.0124e 11.96e 0.0020e 12.95e 0.0026e 13.94e 0.0034e 14.94e 0.0005e 16.95e 0.0007e 17.93e 0.0002e 18.94e 0.0003e 24.92e 0.0002e 25.91e 0.0002e 27.89e 0.0002e 28.89e 0.0001e ] constant bsn-as2

vct[ 1.01e 0.0061e 2.00e 0.0199e 2.99e 0.0393e 3.98e 0.2060e 5.00e 0.0178e 5.99e 0.0340e 6.98e 0.0029e 7.98e 0.0065e 8.99e 0.0102e 9.99e 0.0271e 10.98e 0.0068e 11.97e 0.0032e 12.97e 0.0060e 13.99e 0.0002e 14.98e 0.0005e 15.96e 0.0008e 16.96e 0.0008e 17.98e 0.0006e 18.98e 0.0001e 21.96e 0.0001e 22.96e 0.0002e 23.95e 0.0002e 24.94e 0.0002e 25.94e 0.0001e 26.95e 0.0001e 28.95e 0.0001e ] constant bsn-b2

vct[ 1.00e 0.0082e 1.98e 0.0489e 2.99e 0.1248e 3.98e 0.1892e 4.97e 0.0149e 5.98e 0.0017e 6.96e 0.0172e 7.95e 0.0072e 8.96e 0.0028e 9.95e 0.0114e 10.93e 0.0055e 11.94e 0.0029e 12.96e 0.0005e 13.92e 0.0017e 14.93e 0.0008e 15.91e 0.0012e 16.90e 0.0005e 17.91e 0.0001e 20.90e 0.0001e 21.88e 0.0003e 22.87e 0.0001e 24.85e 0.0002e 28.85e 0.0001e ] constant bsn-c3

vct[ 1.01e 0.0191e 2.00e 0.0451e 2.99e 0.2847e 4.00e 0.0925e 5.00e 0.0143e 5.99e 0.0024e 7.00e 0.0055e 8.00e 0.0131e 8.99e 0.0286e 9.98e 0.0021e 10.99e 0.0020e 11.99e 0.0010e 12.96e 0.0003e 13.97e 0.0005e 14.98e 0.0009e 15.97e 0.0005e 20.97e 0.0003e 21.97e 0.0003e ] constant bsn-cs3

vct[ 1.01e 0.0218e 2.01e 0.0560e 3.01e 0.1696e 4.01e 0.0504e 5.00e 0.0268e 6.02e 0.0018e 7.03e 0.0081e 8.03e 0.0035e 9.04e 0.0026e 10.04e 0.0023e 11.02e 0.0045e 12.04e 0.0002e 13.04e 0.0004e 14.04e 0.0007e 15.05e 0.0004e 16.06e 0.0001e 21.06e 0.0001e 22.07e 0.0003e ] constant bsn-d3

vct[ 1.00e 0.0185e 1.99e 0.0627e 2.98e 0.2037e 3.97e 0.0211e 4.98e 0.0204e 5.97e 0.0434e 6.95e 0.0056e 7.94e 0.0171e 8.95e 0.0014e 9.94e 0.0062e 10.93e 0.0007e 11.91e 0.0006e 12.91e 0.0004e 13.90e 0.0004e 14.90e 0.0003e 16.88e 0.0001e 17.89e 0.0002e 18.88e 0.0002e 20.86e 0.0004e 21.84e 0.0002e 22.85e 0.0001e ] constant bsn-ds3

vct[ 1.00e 0.0167e 2.00e 0.0801e 3.01e 0.2223e 4.02e 0.0252e 5.02e 0.0098e 6.01e 0.0058e 7.02e 0.0073e 8.03e 0.0032e 9.03e 0.0066e 10.04e 0.0011e 10.66e 0.0001e 12.04e 0.0013e 13.04e 0.0013e 14.05e 0.0010e 15.05e 0.0004e 18.07e 0.0002e 20.06e 0.0003e 23.07e 0.0001e ] constant bsn-e3

vct[ 1.00e 0.0152e 2.01e 0.0471e 3.00e 0.1985e 4.00e 0.0345e 5.01e 0.0136e 6.00e 0.0064e 7.01e 0.0153e 8.00e 0.0011e 9.00e 0.0093e 10.02e 0.0006e 11.01e 0.0006e 12.00e 0.0001e 13.01e 0.0008e 14.01e 0.0006e 16.02e 0.0001e 17.01e 0.0003e 19.01e 0.0002e 22.01e 0.0001e 23.02e 0.0002e ] constant bsn-f3

vct[ 1.01e 0.0363e 2.01e 0.1019e 3.01e 0.3226e 4.01e 0.1274e 5.03e 0.0397e 6.03e 0.0061e 7.02e 0.0117e 8.03e 0.0099e 9.04e 0.0006e 10.04e 0.0026e 11.04e 0.0020e 12.04e 0.0008e 13.05e 0.0001e 14.06e 0.0002e 15.05e 0.0002e 19.07e 0.0002e ] constant bsn-fs3

vct[ 0.99e 0.0358e 1.99e 0.0535e 2.99e 0.1072e 3.99e 0.0270e 4.99e 0.0106e 5.98e 0.0010e 6.97e 0.0007e 7.97e 0.0041e 8.95e 0.0002e 9.94e 0.0002e 10.97e 0.0002e 12.96e 0.0001e ] constant bsn-g3

vct[ 1.00e 0.0382e 1.99e 0.0923e 2.99e 0.0199e 3.99e 0.0156e 4.96e 0.0044e 5.98e 0.0130e 6.97e 0.0020e 7.97e 0.0033e 8.97e 0.0007e 9.95e 0.0002e 10.95e 0.0001e 12.95e 0.0001e ] constant bsn-gs3

vct[ 1.00e 0.0469e 2.00e 0.2187e 3.00e 0.0287e 4.01e 0.0121e 5.01e 0.0114e 6.01e 0.0022e 7.01e 0.0044e 8.02e 0.0008e 9.02e 0.0004e 10.01e 0.0003e 13.02e 0.0001e ] constant bsn-a3

vct[ 1.01e 0.0298e 2.01e 0.2016e 3.02e 0.0058e 4.00e 0.0258e 5.00e 0.0008e 6.00e 0.0029e 7.00e 0.0031e 8.01e 0.0010e 9.01e 0.0004e 10.00e 0.0001e 13.01e 0.0001e ] constant bsn-as3

vct[ 1.01e 0.0341e 2.01e 0.2100e 3.01e 0.0390e 4.02e 0.0044e 5.02e 0.0213e 6.02e 0.0044e 7.02e 0.0006e 8.03e 0.0012e 9.04e 0.0002e 12.05e 0.0002e 13.05e 0.0002e ] constant bsn-b3

vct[ 1.00e 0.0684e 2.00e 0.2934e 3.00e 0.0096e 4.00e 0.0084e 5.00e 0.0039e 6.00e 0.0059e 7.00e 0.0010e 8.00e 0.0006e ] constant bsn-c4

vct[ 1.01e 0.0848e 2.01e 0.3334e 3.02e 0.0152e 4.03e 0.0032e 5.03e 0.0059e 6.03e 0.0032e 7.05e 0.0013e 8.05e 0.0007e 9.05e 0.0001e 10.06e 0.0001e 11.06e 0.0002e ] constant bsn-cs4

vct[ 1.00e 0.1020e 2.00e 0.1065e 3.00e 0.0086e 3.99e 0.0013e 5.00e 0.0038e 6.00e 0.0011e 7.00e 0.0003e 8.00e 0.0002e 11.01e 0.0003e ] constant bsn-d4

vct[ 1.00e 0.0469e 1.99e 0.0248e 2.96e 0.0045e 3.99e 0.0163e 4.99e 0.0042e 6.00e 0.0004e 6.98e 0.0003e ] constant bsn-ds4

vct[ 1.00e 0.0389e 2.01e 0.0439e 3.01e 0.0110e 4.01e 0.0072e 5.02e 0.0041e 6.02e 0.0005e 7.02e 0.0006e 9.03e 0.0003e ] constant bsn-e4

vct[ 1.00e 0.0229e 2.00e 0.0331e 2.99e 0.0138e 4.00e 0.0008e 4.99e 0.0010e 5.99e 0.0004e ] constant bsn-f4

vct[ 1.00e 0.1522e 1.99e 0.0563e 3.00e 0.0126e 3.99e 0.0035e 4.28e 0.0002e 4.35e 0.0002e 4.43e 0.0001e 4.98e 0.0001e 5.99e 0.0001e 6.98e 0.0002e ] constant bsn-fs4

vct[ 1.00e 0.0415e 2.00e 0.0486e 3.00e 0.0068e 4.00e 0.0148e 5.00e 0.0016e 6.00e 0.0001e ] constant bsn-g4

vct[ 1.01e 0.0811e 2.01e 0.0402e 3.03e 0.0114e 4.04e 0.0044e 5.03e 0.0004e ] constant bsn-gs4

vct[ 1.00e 0.0399e 2.01e 0.0195e 3.00e 0.0069e 4.01e 0.0005e 5.01e 0.0009e 6.01e 0.0002e 7.01e 0.0003e ] constant bsn-a4

vct[ 1.01e 0.1259e 2.01e 0.0811e 3.01e 0.0051e 4.01e 0.0027e 5.01e 0.0008e 6.02e 0.0002e 7.02e 0.0003e ] constant bsn-as4

vct[ 1.01e 0.1159e 2.02e 0.0380e 3.03e 0.0089e 4.04e 0.0038e 5.05e 0.0006e 6.05e 0.0002e ] constant bsn-b4

vct[ 1.02e 0.0871e 2.03e 0.0356e 3.04e 0.0192e 4.06e 0.0063e 6.09e 0.0003e 7.11e 0.0002e ] constant bsn-c5

vct[ 1.01e 0.2418e 2.02e 0.0674e 3.02e 0.0067e 4.03e 0.0021e 5.03e 0.0004e 6.05e 0.0003e 7.05e 0.0005e 8.06e 0.0001e ] constant bsn-cs5

vct[ 1.01e 0.1931e 2.01e 0.0462e 3.02e 0.0118e 4.02e 0.0014e 5.03e 0.0006e 6.03e 0.0008e 8.04e 0.0001e ] constant bsn-d5

\ **********************************************************
\ cello
\ **********************************************************

vct[ 1.00e 0.0047e 1.99e 0.0251e 2.99e 0.0546e 4.01e 0.1041e 4.99e 0.0279e 5.97e 0.0219e 6.93e 0.0137e 7.94e 0.0349e 8.91e 0.0151e 10.04e 0.0565e 11.00e 0.0458e 12.00e 0.0216e 12.97e 0.0151e 14.52e 0.0025e 14.95e 0.0088e 16.03e 0.0103e 17.02e 0.0027e 17.98e 0.0089e 19.00e 0.0052e 20.03e 0.0048e 20.93e 0.0051e 22.04e 0.0023e 23.01e 0.0072e 24.01e 0.0022e 24.99e 0.0027e 26.03e 0.0036e 27.47e 0.0011e 27.99e 0.0011e 29.02e 0.0012e 29.86e 0.0005e 30.97e 0.0020e 31.88e 0.0006e 33.02e 0.0021e 33.98e 0.0011e 35.02e 0.0010e 36.01e 0.0028e 37.00e 0.0022e 37.99e 0.0014e 39.00e 0.0014e 40.01e 0.0022e 41.04e 0.0021e 42.02e 0.0008e 43.01e 0.0024e 44.02e 0.0007e 45.01e 0.0003e 46.00e 0.0002e 48.03e 0.0002e 48.85e 0.0002e 51.01e 0.0001e 51.98e 0.0001e 54.89e 0.0002e 55.39e 0.0002e 56.38e 0.0001e 58.02e 0.0002e 58.98e 0.0002e 62.00e 0.0001e 64.09e 0.0001e 65.02e 0.0002e ] constant c-c2

vct[ 1.01e 0.0160e 2.02e 0.0737e 3.02e 0.0287e 4.02e 0.0183e 5.02e 0.0669e 6.04e 0.0520e 7.05e 0.0043e 8.06e 0.0066e 9.06e 0.0194e 10.05e 0.0193e 11.05e 0.0254e 12.06e 0.0153e 13.08e 0.0041e 14.11e 0.0037e 15.09e 0.0098e 16.09e 0.0022e 17.09e 0.0053e 18.10e 0.0135e 19.12e 0.0118e 20.13e 0.0057e 21.15e 0.0039e 22.14e 0.0023e 23.14e 0.0027e 24.15e 0.0026e 25.16e 0.0012e 26.16e 0.0011e 27.17e 0.0020e 28.17e 0.0015e 29.14e 0.0020e 30.19e 0.0013e 31.19e 0.0019e 32.20e 0.0007e 33.21e 0.0005e 34.22e 0.0004e 35.19e 0.0012e 36.20e 0.0005e 37.25e 0.0015e 38.25e 0.0018e 39.26e 0.0014e 40.40e 0.0007e 41.25e 0.0010e 42.24e 0.0009e 43.28e 0.0003e 44.31e 0.0002e 45.28e 0.0002e 46.30e 0.0001e 48.29e 0.0002e 49.31e 0.0004e 50.34e 0.0001e 51.35e 0.0002e 52.32e 0.0003e 53.50e 0.0001e 54.28e 0.0001e 57.34e 0.0001e 58.35e 0.0002e ] constant c-cs2

vct[ 1.00e 0.0368e 2.02e 0.1070e 3.03e 0.0107e 4.04e 0.0445e 5.04e 0.0477e 6.04e 0.0281e 7.07e 0.0191e 8.06e 0.0205e 9.06e 0.0456e 10.07e 0.0283e 11.07e 0.0320e 12.08e 0.0094e 13.35e 0.0009e 14.11e 0.0042e 15.11e 0.0066e 16.12e 0.0075e 17.13e 0.0117e 18.14e 0.0043e 19.16e 0.0067e 20.14e 0.0020e 21.16e 0.0046e 22.16e 0.0011e 23.17e 0.0029e 24.17e 0.0010e 25.18e 0.0011e 26.19e 0.0013e 27.18e 0.0029e 28.20e 0.0039e 29.21e 0.0048e 30.23e 0.0020e 31.23e 0.0006e 32.25e 0.0018e 33.23e 0.0009e 34.24e 0.0012e 35.28e 0.0016e 36.27e 0.0018e 37.28e 0.0019e 38.28e 0.0031e 39.28e 0.0008e 40.25e 0.0001e 41.30e 0.0002e 42.31e 0.0002e 43.32e 0.0001e 44.32e 0.0002e 45.33e 0.0002e 46.34e 0.0004e 48.37e 0.0002e 49.37e 0.0006e 50.37e 0.0004e 51.35e 0.0001e 52.35e 0.0001e 53.40e 0.0001e 54.39e 0.0002e 55.41e 0.0003e 56.43e 0.0002e 57.41e 0.0001e 64.49e 0.0001e 65.50e 0.0001e ] constant c-d2

vct[ 1.01e 0.0485e 2.01e 0.1800e 3.01e 0.0143e 4.02e 0.1265e 5.03e 0.1372e 6.03e 0.0102e 7.02e 0.0261e 8.03e 0.0216e 9.02e 0.0145e 10.04e 0.0292e 11.05e 0.0133e 12.06e 0.0038e 13.06e 0.0026e 14.04e 0.0041e 15.06e 0.0053e 16.06e 0.0014e 17.08e 0.0051e 18.06e 0.0048e 19.07e 0.0026e 20.07e 0.0025e 21.09e 0.0039e 22.08e 0.0018e 23.08e 0.0031e 24.11e 0.0023e 25.10e 0.0035e 26.10e 0.0037e 27.10e 0.0019e 28.10e 0.0030e 29.11e 0.0020e 30.10e 0.0036e 31.13e 0.0020e 32.10e 0.0011e 33.13e 0.0013e 34.12e 0.0027e 35.11e 0.0022e 36.13e 0.0018e 37.15e 0.0005e 38.13e 0.0002e 39.17e 0.0002e 40.16e 0.0006e 41.13e 0.0002e 43.16e 0.0002e 44.16e 0.0002e 45.15e 0.0002e 46.18e 0.0003e 47.17e 0.0001e 48.18e 0.0001e 49.16e 0.0002e 50.19e 0.0001e 58.35e 0.0001e ] constant c-ds2

vct[ 1.02e 0.0293e 2.00e 0.1425e 3.04e 0.0549e 4.03e 0.0364e 5.03e 0.1171e 6.07e 0.0100e 7.04e 0.0253e 8.06e 0.0448e 9.08e 0.0115e 10.06e 0.0116e 11.08e 0.0048e 12.09e 0.0174e 13.09e 0.0037e 14.11e 0.0029e 15.11e 0.0104e 16.12e 0.0036e 17.14e 0.0046e 18.13e 0.0016e 19.16e 0.0027e 20.13e 0.0036e 21.14e 0.0012e 22.18e 0.0027e 23.17e 0.0011e 24.18e 0.0033e 25.20e 0.0019e 26.20e 0.0016e 26.99e 0.0005e 28.22e 0.0009e 29.19e 0.0052e 30.23e 0.0021e 31.21e 0.0015e 32.24e 0.0014e 33.23e 0.0019e 34.22e 0.0033e 35.27e 0.0009e 36.27e 0.0002e 38.30e 0.0004e 39.27e 0.0005e 40.26e 0.0004e 41.25e 0.0003e 42.31e 0.0002e 43.34e 0.0007e 44.32e 0.0006e 45.32e 0.0003e 46.36e 0.0002e 47.36e 0.0001e 48.34e 0.0002e 49.37e 0.0002e 54.40e 0.0002e 55.40e 0.0001e ] constant c-e2

vct[ 0.99e 0.0765e 2.00e 0.0311e 3.02e 0.0635e 4.02e 0.0223e 5.15e 0.0022e 6.01e 0.0457e 7.03e 0.0278e 8.04e 0.0188e 9.04e 0.0344e 10.02e 0.0093e 11.00e 0.0034e 12.05e 0.0172e 13.06e 0.0106e 14.07e 0.0020e 15.02e 0.0011e 16.06e 0.0022e 17.08e 0.0027e 18.08e 0.0007e 19.05e 0.0016e 20.07e 0.0015e 21.07e 0.0057e 22.10e 0.0010e 23.07e 0.0030e 24.07e 0.0013e 25.07e 0.0019e 26.09e 0.0018e 27.10e 0.0042e 28.10e 0.0020e 29.09e 0.0015e 30.12e 0.0027e 31.11e 0.0021e 32.13e 0.0035e 33.08e 0.0003e 34.12e 0.0005e 35.12e 0.0004e 36.15e 0.0008e 37.15e 0.0003e 39.14e 0.0005e 40.17e 0.0003e 41.15e 0.0003e 42.14e 0.0002e 43.14e 0.0001e 44.17e 0.0002e 51.84e 0.0001e 53.18e 0.0001e 54.22e 0.0001e ] constant c-f2

vct[ 1.02e 0.0680e 2.02e 0.0790e 3.03e 0.0722e 4.03e 0.0851e 5.03e 0.0169e 6.03e 0.0073e 7.02e 0.0859e 8.02e 0.0250e 9.04e 0.0073e 10.07e 0.0037e 11.04e 0.0035e 12.01e 0.0009e 13.09e 0.0056e 14.05e 0.0059e 15.05e 0.0031e 16.07e 0.0050e 17.07e 0.0034e 18.07e 0.0010e 19.47e 0.0004e 20.10e 0.0045e 21.10e 0.0028e 22.09e 0.0039e 23.10e 0.0032e 24.11e 0.0007e 25.09e 0.0017e 26.10e 0.0041e 27.16e 0.0006e 28.12e 0.0021e 29.13e 0.0021e 30.39e 0.0004e 31.11e 0.0013e 32.17e 0.0004e 33.13e 0.0005e 34.14e 0.0014e 35.07e 0.0002e 36.06e 0.0001e 37.16e 0.0002e 39.18e 0.0007e 40.18e 0.0002e 41.22e 0.0001e 42.21e 0.0002e 43.24e 0.0003e 49.15e 0.0001e 51.22e 0.0001e 52.23e 0.0002e ] constant c-fs2

vct[ 1.00e 0.0434e 2.00e 0.0983e 2.99e 0.0548e 3.98e 0.0364e 4.98e 0.0228e 5.97e 0.0390e 6.97e 0.0091e 7.96e 0.0154e 9.03e 0.0078e 9.96e 0.0174e 10.98e 0.0110e 11.96e 0.0125e 12.97e 0.0039e 13.94e 0.0028e 14.95e 0.0057e 15.94e 0.0020e 16.95e 0.0046e 17.94e 0.0011e 18.97e 0.0017e 19.94e 0.0010e 20.98e 0.0025e 21.94e 0.0040e 22.94e 0.0030e 23.91e 0.0064e 24.95e 0.0013e 25.96e 0.0009e 26.94e 0.0015e 27.92e 0.0014e 28.93e 0.0017e 29.91e 0.0015e 30.92e 0.0010e 31.49e 0.0002e 32.83e 0.0002e 33.89e 0.0003e 34.92e 0.0002e 36.91e 0.0003e 37.91e 0.0002e 40.84e 0.0002e 41.87e 0.0002e 42.89e 0.0002e ] constant c-g2

vct[ 0.98e 0.0579e 1.97e 0.0445e 2.97e 0.1178e 3.97e 0.0806e 4.96e 0.1095e 5.94e 0.0245e 6.92e 0.0203e 7.91e 0.0153e 8.92e 0.0186e 9.93e 0.0129e 10.92e 0.0154e 11.89e 0.0040e 12.87e 0.0036e 13.88e 0.0033e 14.74e 0.0006e 15.85e 0.0011e 16.86e 0.0020e 17.85e 0.0026e 18.84e 0.0040e 19.84e 0.0022e 20.83e 0.0022e 21.82e 0.0020e 22.80e 0.0060e 23.79e 0.0073e 24.81e 0.0023e 25.80e 0.0030e 26.79e 0.0008e 27.77e 0.0005e 28.75e 0.0012e 29.73e 0.0017e 30.75e 0.0003e 31.74e 0.0005e 32.74e 0.0003e 33.71e 0.0003e 34.70e 0.0005e 35.72e 0.0002e 36.67e 0.0003e 38.69e 0.0002e 39.71e 0.0002e 40.65e 0.0001e ] constant c-gs2

vct[ 0.99e 0.0612e 1.98e 0.0094e 2.98e 0.0435e 3.98e 0.0098e 4.97e 0.0550e 5.97e 0.0775e 6.96e 0.0337e 7.96e 0.0330e 8.97e 0.0137e 9.95e 0.0122e 10.95e 0.0080e 11.94e 0.0082e 13.00e 0.0009e 13.95e 0.0034e 14.96e 0.0029e 15.94e 0.0011e 16.94e 0.0041e 17.95e 0.0060e 18.92e 0.0008e 19.97e 0.0026e 20.94e 0.0009e 21.94e 0.0041e 22.92e 0.0050e 23.92e 0.0056e 24.93e 0.0030e 25.92e 0.0015e 26.22e 0.0002e 27.90e 0.0011e 28.90e 0.0004e 29.89e 0.0007e 30.89e 0.0009e 31.90e 0.0004e 32.91e 0.0002e 33.88e 0.0005e 34.86e 0.0001e 35.89e 0.0003e 36.87e 0.0006e 37.89e 0.0003e 38.93e 0.0002e 46.84e 0.0001e 54.82e 0.0001e ] constant c-a2

vct[ 1.00e 0.0401e 1.99e 0.0101e 2.98e 0.0769e 3.96e 0.0345e 4.96e 0.0696e 5.97e 0.0342e 6.95e 0.0413e 7.95e 0.0130e 8.92e 0.0147e 9.93e 0.0034e 10.94e 0.0135e 11.94e 0.0007e 12.92e 0.0013e 13.91e 0.0017e 14.89e 0.0026e 15.88e 0.0019e 16.89e 0.0039e 17.88e 0.0034e 18.86e 0.0037e 19.84e 0.0009e 20.85e 0.0021e 21.86e 0.0021e 22.85e 0.0049e 23.82e 0.0042e 24.82e 0.0007e 25.80e 0.0007e 26.82e 0.0003e 27.81e 0.0004e 28.79e 0.0009e 29.79e 0.0007e 30.77e 0.0005e 31.18e 0.0001e 31.66e 0.0001e 32.76e 0.0002e 33.78e 0.0002e 34.76e 0.0004e 35.75e 0.0002e 36.74e 0.0002e ] constant c-as2

vct[ 1.00e 0.0486e 1.99e 0.0621e 2.98e 0.0627e 3.98e 0.0145e 4.98e 0.0494e 5.97e 0.0353e 6.96e 0.0287e 7.96e 0.0169e 8.95e 0.0167e 9.95e 0.0039e 10.94e 0.0075e 11.94e 0.0043e 12.95e 0.0018e 13.92e 0.0040e 14.94e 0.0054e 15.93e 0.0046e 16.93e 0.0035e 17.92e 0.0037e 18.93e 0.0036e 19.91e 0.0055e 20.89e 0.0055e 21.89e 0.0058e 22.89e 0.0039e 23.88e 0.0005e 24.87e 0.0009e 25.87e 0.0003e 26.87e 0.0007e 27.78e 0.0002e 28.86e 0.0004e 29.86e 0.0004e 30.85e 0.0004e 31.86e 0.0001e 32.83e 0.0009e 33.83e 0.0003e 34.82e 0.0001e 37.81e 0.0002e 43.79e 0.0001e 48.71e 0.0001e ] constant c-b2

vct[ 0.99e 0.0486e 1.98e 0.1268e 2.99e 0.0920e 3.98e 0.0752e 4.96e 0.1515e 5.95e 0.0086e 6.97e 0.0102e 7.95e 0.0108e 8.95e 0.0120e 9.94e 0.0034e 10.95e 0.0029e 11.94e 0.0007e 12.91e 0.0029e 13.92e 0.0077e 14.90e 0.0028e 15.89e 0.0027e 16.90e 0.0038e 17.92e 0.0034e 18.87e 0.0115e 19.89e 0.0039e 20.89e 0.0023e 21.86e 0.0023e 22.88e 0.0008e 23.88e 0.0006e 24.86e 0.0004e 26.05e 0.0002e 26.84e 0.0003e 27.84e 0.0005e 28.84e 0.0003e 29.80e 0.0004e 30.82e 0.0007e 31.58e 0.0001e 31.79e 0.0001e 32.52e 0.0001e 33.80e 0.0001e 34.80e 0.0001e 39.78e 0.0002e ] constant c-c3

vct[ 1.01e 0.0839e 1.99e 0.0414e 2.99e 0.1265e 4.00e 0.0196e 5.00e 0.0377e 6.00e 0.0117e 6.99e 0.0111e 8.00e 0.0151e 9.00e 0.0207e 9.98e 0.0033e 10.99e 0.0090e 11.99e 0.0039e 13.00e 0.0039e 14.01e 0.0031e 14.99e 0.0038e 16.02e 0.0023e 17.00e 0.0026e 17.98e 0.0069e 19.00e 0.0020e 20.01e 0.0017e 21.02e 0.0007e 22.02e 0.0006e 22.22e 0.0002e 22.93e 0.0001e 24.05e 0.0003e 25.04e 0.0002e 25.99e 0.0003e 27.00e 0.0003e 29.03e 0.0003e ] constant c-cs3

vct[ 1.01e 0.1033e 2.00e 0.0588e 3.00e 0.0184e 4.00e 0.0725e 5.00e 0.0720e 6.01e 0.0251e 7.01e 0.0292e 8.02e 0.0069e 9.00e 0.0094e 10.00e 0.0159e 11.02e 0.0134e 12.00e 0.0008e 13.01e 0.0053e 14.01e 0.0204e 15.01e 0.0122e 16.02e 0.0024e 17.03e 0.0044e 18.02e 0.0069e 19.03e 0.0043e 20.01e 0.0024e 21.02e 0.0020e 22.03e 0.0006e 23.03e 0.0005e 24.02e 0.0006e 25.01e 0.0011e 26.01e 0.0006e 27.03e 0.0007e 28.04e 0.0005e 29.04e 0.0003e 30.02e 0.0001e 31.03e 0.0002e 32.04e 0.0003e 36.02e 0.0002e 38.03e 0.0001e 39.06e 0.0002e 40.01e 0.0002e 42.09e 0.0001e 43.08e 0.0001e 44.05e 0.0002e ] constant c-d3

vct[ 1.01e 0.1622e 2.01e 0.1721e 3.02e 0.0068e 4.02e 0.0256e 5.03e 0.0568e 6.02e 0.0438e 7.03e 0.0061e 8.04e 0.0086e 9.04e 0.0050e 10.06e 0.0045e 11.07e 0.0012e 12.10e 0.0025e 13.08e 0.0028e 14.11e 0.0014e 15.07e 0.0060e 16.07e 0.0014e 17.13e 0.0026e 18.08e 0.0015e 19.13e 0.0007e 20.13e 0.0003e 21.15e 0.0003e 22.06e 0.0004e 23.10e 0.0002e 24.15e 0.0001e 25.12e 0.0001e 26.16e 0.0002e 27.20e 0.0001e ] constant c-ds3

vct[ 1.00e 0.1620e 2.01e 0.0201e 3.01e 0.0224e 4.02e 0.0903e 5.03e 0.0425e 6.01e 0.0323e 7.02e 0.0089e 8.11e 0.0023e 9.02e 0.0050e 10.03e 0.0055e 11.05e 0.0038e 12.04e 0.0099e 13.04e 0.0062e 14.03e 0.0027e 15.06e 0.0040e 16.07e 0.0035e 17.07e 0.0089e 18.06e 0.0013e 19.05e 0.0012e 20.08e 0.0004e 21.06e 0.0008e 22.09e 0.0002e 23.08e 0.0008e 24.09e 0.0005e 25.08e 0.0006e 26.65e 0.0001e 27.13e 0.0001e 29.10e 0.0002e 30.10e 0.0001e 31.10e 0.0002e 32.11e 0.0001e 35.12e 0.0003e 36.10e 0.0002e 37.15e 0.0003e 38.17e 0.0001e ] constant c-e3

vct[ 0.99e 0.0412e 1.99e 0.0398e 2.99e 0.1009e 3.99e 0.0605e 4.97e 0.0481e 5.96e 0.0358e 6.96e 0.0065e 7.83e 0.0052e 7.97e 0.0050e 8.95e 0.0042e 9.94e 0.0038e 10.95e 0.0044e 11.94e 0.0120e 12.93e 0.0044e 13.92e 0.0074e 14.92e 0.0037e 15.92e 0.0030e 16.92e 0.0017e 17.90e 0.0021e 18.90e 0.0016e 19.89e 0.0016e 20.89e 0.0002e 22.86e 0.0013e 23.87e 0.0014e 24.87e 0.0006e 25.86e 0.0003e 26.88e 0.0001e 29.84e 0.0004e 30.83e 0.0002e 31.82e 0.0001e 32.83e 0.0001e 33.81e 0.0001e 34.81e 0.0002e 35.82e 0.0003e 37.80e 0.0002e ] constant c-f3

vct[ 1.00e 0.0386e 2.00e 0.0915e 3.00e 0.0406e 4.01e 0.0601e 5.00e 0.0460e 5.99e 0.0213e 7.01e 0.0148e 8.00e 0.0085e 9.00e 0.0073e 10.00e 0.0017e 11.01e 0.0191e 12.00e 0.0069e 13.00e 0.0057e 14.02e 0.0023e 15.01e 0.0059e 16.00e 0.0010e 17.02e 0.0006e 18.01e 0.0019e 19.00e 0.0012e 20.02e 0.0002e 20.99e 0.0004e 22.01e 0.0013e 23.02e 0.0007e 24.02e 0.0002e 24.94e 0.0001e 27.03e 0.0001e 28.02e 0.0002e 29.00e 0.0001e 31.01e 0.0001e 32.01e 0.0001e 33.02e 0.0003e 34.03e 0.0002e ] constant c-fs3

vct[ 1.01e 0.0124e 1.99e 0.0359e 2.98e 0.0602e 3.98e 0.0390e 4.98e 0.0496e 5.98e 0.0070e 6.98e 0.0121e 7.97e 0.0089e 8.97e 0.0044e 9.97e 0.0068e 10.97e 0.0085e 11.96e 0.0110e 12.95e 0.0034e 13.95e 0.0099e 14.95e 0.0059e 15.95e 0.0003e 16.94e 0.0014e 17.94e 0.0005e 18.94e 0.0008e 19.95e 0.0004e 20.94e 0.0007e 21.39e 0.0001e 22.95e 0.0002e 24.93e 0.0001e 25.92e 0.0002e 27.91e 0.0001e 29.91e 0.0005e 30.94e 0.0001e 31.93e 0.0002e 33.90e 0.0001e ] constant c-g3

vct[ 1.00e 0.0509e 1.99e 0.1477e 3.00e 0.0407e 4.00e 0.0514e 5.00e 0.0367e 6.00e 0.0032e 7.02e 0.0097e 8.00e 0.0090e 9.07e 0.0009e 10.03e 0.0069e 10.99e 0.0020e 12.03e 0.0010e 13.02e 0.0019e 14.06e 0.0010e 15.02e 0.0010e 16.03e 0.0008e 17.03e 0.0003e 18.05e 0.0002e 18.98e 0.0004e 20.09e 0.0002e 21.03e 0.0001e 28.01e 0.0001e ] constant c-gs3

vct[ 1.00e 0.0110e 2.01e 0.0315e 3.02e 0.1476e 4.03e 0.0358e 5.01e 0.0391e 6.02e 0.0638e 7.03e 0.0692e 8.02e 0.0039e 9.04e 0.0218e 10.04e 0.0342e 11.05e 0.0335e 12.04e 0.0187e 13.05e 0.0167e 14.06e 0.0168e 15.06e 0.0035e 16.07e 0.0019e 17.07e 0.0014e 18.08e 0.0040e 19.07e 0.0070e 20.08e 0.0014e 21.09e 0.0015e 22.08e 0.0003e 23.10e 0.0003e 24.08e 0.0011e 25.10e 0.0003e 26.12e 0.0013e 27.13e 0.0009e 28.13e 0.0006e 29.12e 0.0003e 30.11e 0.0002e 31.13e 0.0002e 33.15e 0.0002e 34.13e 0.0001e 36.15e 0.0001e 41.16e 0.0002e 44.18e 0.0001e 47.17e 0.0001e ] constant c-a3

vct[ 1.00e 0.0140e 2.00e 0.0411e 3.00e 0.0723e 4.00e 0.1057e 5.00e 0.0044e 6.00e 0.0248e 6.98e 0.0048e 8.00e 0.0014e 9.00e 0.0304e 9.99e 0.0184e 10.99e 0.0130e 12.00e 0.0159e 13.00e 0.0107e 13.99e 0.0021e 15.00e 0.0015e 15.99e 0.0020e 17.00e 0.0028e 18.00e 0.0067e 19.00e 0.0005e 20.04e 0.0003e 21.00e 0.0003e 22.02e 0.0001e 23.98e 0.0003e 25.01e 0.0007e 26.01e 0.0009e 27.00e 0.0003e 28.02e 0.0002e 28.98e 0.0002e 30.00e 0.0002e 31.01e 0.0002e 32.01e 0.0002e 32.99e 0.0003e 33.99e 0.0001e 35.02e 0.0002e 37.00e 0.0002e 38.98e 0.0003e 43.98e 0.0001e 44.99e 0.0001e ] constant c-as3

vct[ 1.00e 0.0648e 2.00e 0.0397e 3.00e 0.0872e 4.01e 0.0429e 5.00e 0.0213e 6.01e 0.0524e 7.00e 0.0064e 8.03e 0.0162e 9.02e 0.0212e 10.01e 0.0175e 11.02e 0.0256e 12.03e 0.0038e 13.03e 0.0039e 14.04e 0.0056e 15.03e 0.0008e 16.08e 0.0005e 17.03e 0.0032e 18.04e 0.0010e 19.04e 0.0011e 20.04e 0.0002e 21.06e 0.0010e 22.05e 0.0002e 23.08e 0.0011e 24.09e 0.0005e 25.12e 0.0003e 26.07e 0.0002e 27.03e 0.0001e 39.10e 0.0002e ] constant c-b3

vct[ 1.00e 0.0472e 2.00e 0.1961e 3.00e 0.1030e 4.00e 0.0974e 5.00e 0.0183e 6.00e 0.0397e 7.00e 0.0158e 8.00e 0.0170e 8.99e 0.0253e 10.00e 0.0129e 10.99e 0.0121e 11.99e 0.0103e 12.98e 0.0055e 14.03e 0.0004e 14.99e 0.0012e 15.99e 0.0051e 16.99e 0.0009e 17.99e 0.0012e 19.00e 0.0004e 19.98e 0.0015e 21.02e 0.0002e 22.00e 0.0009e 22.99e 0.0007e 24.01e 0.0004e 25.00e 0.0002e 26.00e 0.0003e 28.00e 0.0002e 28.97e 0.0002e 31.00e 0.0002e 32.98e 0.0003e 33.98e 0.0001e 34.97e 0.0001e 35.98e 0.0002e 37.97e 0.0002e 38.97e 0.0001e ] constant c-c4

vct[ 1.00e 0.1199e 2.00e 0.0345e 3.01e 0.0978e 4.00e 0.0466e 5.02e 0.0070e 6.01e 0.0258e 7.02e 0.0241e 8.01e 0.0070e 9.02e 0.0161e 10.02e 0.0124e 11.02e 0.0145e 12.02e 0.0101e 13.02e 0.0026e 14.03e 0.0011e 15.02e 0.0028e 16.03e 0.0011e 17.04e 0.0005e 18.02e 0.0003e 19.05e 0.0012e 20.07e 0.0004e 21.06e 0.0011e 22.06e 0.0007e 23.04e 0.0007e 24.05e 0.0005e 26.07e 0.0003e 27.04e 0.0002e 28.05e 0.0002e 29.06e 0.0001e 32.05e 0.0001e 33.06e 0.0002e 35.07e 0.0002e 36.07e 0.0001e 37.07e 0.0002e ] constant c-cs4

vct[ 1.00e 0.0657e 2.00e 0.0681e 3.00e 0.1031e 3.99e 0.0157e 4.99e 0.0570e 5.98e 0.0160e 6.99e 0.0236e 7.98e 0.0259e 8.99e 0.0144e 9.98e 0.0154e 10.98e 0.0046e 11.97e 0.0104e 12.98e 0.0024e 13.97e 0.0020e 14.97e 0.0012e 15.97e 0.0010e 16.97e 0.0004e 17.95e 0.0008e 18.97e 0.0005e 19.98e 0.0007e 20.98e 0.0009e 21.93e 0.0004e 22.00e 0.0003e 22.94e 0.0002e 23.95e 0.0002e 24.98e 0.0001e 25.97e 0.0002e 26.96e 0.0001e 28.94e 0.0002e 29.94e 0.0002e 30.94e 0.0002e 32.97e 0.0001e 33.97e 0.0001e 34.95e 0.0001e 36.93e 0.0001e ] constant c-d4

vct[ 1.00e 0.3562e 1.99e 0.0664e 2.99e 0.1446e 3.98e 0.0393e 4.97e 0.0363e 5.97e 0.0237e 6.96e 0.0366e 7.95e 0.0079e 8.96e 0.0127e 9.95e 0.0148e 10.95e 0.0143e 11.94e 0.0031e 12.96e 0.0022e 13.94e 0.0032e 14.92e 0.0004e 15.92e 0.0007e 16.90e 0.0007e 17.92e 0.0007e 18.92e 0.0012e 19.94e 0.0005e 20.89e 0.0003e 21.88e 0.0001e 22.89e 0.0005e 23.87e 0.0004e 24.87e 0.0001e 25.89e 0.0007e 26.87e 0.0001e 29.85e 0.0001e 30.83e 0.0001e 31.82e 0.0001e 32.82e 0.0002e 33.82e 0.0001e ] constant c-ds4

vct[ 1.00e 0.0390e 2.01e 0.1863e 3.02e 0.0265e 4.02e 0.0184e 5.02e 0.0319e 6.03e 0.0456e 7.04e 0.0122e 8.04e 0.0149e 9.05e 0.0159e 10.05e 0.0067e 11.06e 0.0044e 12.06e 0.0053e 13.08e 0.0012e 14.08e 0.0008e 15.08e 0.0007e 16.09e 0.0021e 17.09e 0.0005e 18.09e 0.0021e 19.13e 0.0016e 20.12e 0.0004e 21.12e 0.0003e 22.14e 0.0003e 23.12e 0.0003e 24.13e 0.0003e 25.14e 0.0005e 26.14e 0.0002e 27.15e 0.0002e 28.16e 0.0002e 29.18e 0.0002e 30.17e 0.0002e 31.16e 0.0002e 36.21e 0.0001e ] constant c-e4

vct[ 1.00e 0.1183e 1.99e 0.1142e 2.99e 0.1085e 3.98e 0.0306e 4.99e 0.0252e 5.97e 0.0272e 6.97e 0.0290e 7.97e 0.0142e 8.97e 0.0112e 9.96e 0.0079e 10.96e 0.0038e 11.97e 0.0026e 12.96e 0.0014e 13.95e 0.0007e 14.94e 0.0011e 15.95e 0.0008e 16.94e 0.0011e 17.03e 0.0001e 17.94e 0.0001e 18.95e 0.0004e 19.94e 0.0003e 20.94e 0.0007e 21.92e 0.0002e 23.92e 0.0002e 24.92e 0.0002e 25.90e 0.0002e 26.90e 0.0002e 27.89e 0.0001e 28.89e 0.0002e 30.89e 0.0001e ] constant c-f4

vct[ 1.00e 0.1140e 2.00e 0.0935e 3.00e 0.0504e 3.99e 0.0715e 4.99e 0.0063e 6.00e 0.0808e 6.99e 0.0099e 8.00e 0.0093e 9.00e 0.0093e 9.99e 0.0019e 10.99e 0.0050e 11.99e 0.0017e 12.99e 0.0021e 14.00e 0.0003e 14.99e 0.0010e 16.00e 0.0015e 17.00e 0.0019e 17.95e 0.0002e 18.00e 0.0002e 18.99e 0.0002e 19.99e 0.0003e 21.00e 0.0002e 21.99e 0.0003e 23.99e 0.0001e 24.98e 0.0001e 26.02e 0.0001e 27.01e 0.0001e 28.00e 0.0002e ] constant c-fs4

vct[ 1.00e 0.0809e 1.99e 0.1377e 2.99e 0.0348e 3.99e 0.0337e 4.98e 0.0177e 5.98e 0.0295e 6.98e 0.0266e 7.98e 0.0063e 8.98e 0.0105e 9.97e 0.0016e 10.97e 0.0022e 11.98e 0.0029e 12.97e 0.0018e 13.96e 0.0008e 14.99e 0.0023e 15.97e 0.0012e 16.96e 0.0009e 17.97e 0.0002e 18.95e 0.0006e 20.94e 0.0002e 20.99e 0.0002e 22.95e 0.0002e 23.94e 0.0002e 24.94e 0.0003e 25.97e 0.0003e 26.95e 0.0002e ] constant c-g4

vct[ 1.00e 0.2601e 1.99e 0.1726e 2.99e 0.0722e 3.99e 0.0276e 4.99e 0.0535e 5.99e 0.0103e 6.99e 0.0244e 7.99e 0.0046e 8.98e 0.0035e 9.99e 0.0088e 10.98e 0.0038e 11.98e 0.0008e 12.96e 0.0006e 13.98e 0.0020e 14.98e 0.0016e 15.98e 0.0008e 16.97e 0.0003e 17.97e 0.0005e 18.98e 0.0006e 19.96e 0.0005e 20.96e 0.0001e 21.96e 0.0003e 23.96e 0.0002e 24.96e 0.0003e 25.96e 0.0002e ] constant c-gs4

vct[ 0.99e 0.0363e 1.98e 0.2481e 2.98e 0.0514e 3.97e 0.0365e 4.97e 0.0468e 5.95e 0.0182e 6.95e 0.0333e 7.94e 0.0106e 8.93e 0.0048e 9.92e 0.0048e 10.92e 0.0016e 11.90e 0.0010e 12.89e 0.0011e 13.92e 0.0023e 14.90e 0.0014e 15.88e 0.0007e 16.87e 0.0002e 17.89e 0.0001e 18.85e 0.0004e 19.84e 0.0002e 20.84e 0.0003e 21.84e 0.0004e 22.83e 0.0003e 23.86e 0.0002e 24.84e 0.0002e 26.82e 0.0001e ] constant c-a4

vct[ 0.99e 0.0564e 1.99e 0.1983e 2.98e 0.0520e 3.97e 0.0442e 4.97e 0.0260e 5.96e 0.0139e 6.96e 0.0099e 7.94e 0.0046e 8.94e 0.0178e 9.94e 0.0032e 10.93e 0.0021e 11.00e 0.0002e 11.93e 0.0001e 12.92e 0.0038e 13.91e 0.0011e 14.90e 0.0006e 15.92e 0.0004e 16.89e 0.0004e 17.89e 0.0002e 18.87e 0.0005e 19.87e 0.0003e 20.86e 0.0003e 21.85e 0.0003e 22.85e 0.0001e 23.85e 0.0001e 24.85e 0.0001e 25.85e 0.0002e 26.84e 0.0002e ] constant c-as4

vct[ 0.99e 0.0774e 1.98e 0.1289e 2.96e 0.1071e 3.95e 0.0216e 4.94e 0.0346e 5.93e 0.0108e 6.91e 0.0239e 7.90e 0.0056e 8.88e 0.0045e 9.88e 0.0014e 10.87e 0.0057e 11.85e 0.0018e 12.85e 0.0035e 13.83e 0.0007e 14.84e 0.0003e 15.80e 0.0003e 16.79e 0.0008e 17.78e 0.0003e 18.78e 0.0002e 19.76e 0.0004e 20.75e 0.0005e 21.73e 0.0002e 23.71e 0.0001e 24.68e 0.0001e ] constant c-b4

vct[ 0.99e 0.4933e 1.97e 0.1293e 2.95e 0.0971e 4.92e 0.0189e 5.91e 0.0031e 6.88e 0.0093e 7.87e 0.0143e 8.85e 0.0063e 9.84e 0.0010e 10.82e 0.0023e 11.81e 0.0015e 12.79e 0.0006e 13.78e 0.0009e 14.76e 0.0007e 15.75e 0.0004e 16.72e 0.0007e 17.71e 0.0002e 18.68e 0.0008e 19.67e 0.0004e 20.66e 0.0003e ] constant c-c5

vct[ 0.99e 0.1576e 1.99e 0.0760e 2.98e 0.0560e 3.97e 0.1172e 4.96e 0.0433e 5.96e 0.0029e 6.95e 0.0079e 7.95e 0.0058e 8.93e 0.0025e 9.93e 0.0014e 10.93e 0.0054e 11.92e 0.0005e 12.92e 0.0004e 13.90e 0.0009e 14.90e 0.0015e 15.89e 0.0003e 16.87e 0.0002e 17.87e 0.0004e 18.87e 0.0002e 19.86e 0.0002e 20.86e 0.0002e 21.86e 0.0003e 22.85e 0.0002e ] constant c-cs5

vct[ 1.01e 0.1243e 2.02e 0.0648e 3.03e 0.0586e 4.04e 0.0543e 5.05e 0.0183e 6.07e 0.0046e 7.08e 0.0080e 8.09e 0.0027e 9.10e 0.0053e 10.12e 0.0036e 11.14e 0.0014e 12.14e 0.0004e 13.16e 0.0004e 14.15e 0.0007e 15.17e 0.0005e 17.20e 0.0006e 18.22e 0.0002e 19.22e 0.0002e 21.24e 0.0001e ] constant c-d5

vct[ 1.01e 0.1367e 2.02e 0.0170e 3.02e 0.0192e 4.03e 0.0425e 5.04e 0.0143e 6.05e 0.0064e 7.06e 0.0057e 8.06e 0.0028e 9.08e 0.0027e 10.09e 0.0051e 11.09e 0.0009e 12.09e 0.0001e 13.10e 0.0014e 14.11e 0.0005e 15.13e 0.0003e 16.13e 0.0003e 17.14e 0.0002e 19.15e 0.0003e 20.17e 0.0004e 21.17e 0.0001e ] constant c-ds5

vct[ 1.02e 0.2402e 2.03e 0.0419e 3.05e 0.1068e 5.08e 0.0164e 6.10e 0.0019e 7.11e 0.0044e 8.13e 0.0018e 9.15e 0.0044e 10.17e 0.0021e 11.18e 0.0003e 12.20e 0.0007e 13.21e 0.0011e 14.24e 0.0003e 15.24e 0.0008e 16.27e 0.0001e 17.28e 0.0001e 18.31e 0.0001e ] constant c-e5

vct[ 1.01e 0.1166e 2.03e 0.0750e 3.04e 0.0532e 4.05e 0.0620e 5.06e 0.0054e 6.07e 0.0141e 7.08e 0.0027e 8.10e 0.0015e 9.09e 0.0021e 10.13e 0.0006e 11.13e 0.0009e 12.14e 0.0004e 13.15e 0.0008e 14.17e 0.0003e 15.18e 0.0002e 17.19e 0.0003e 18.20e 0.0002e ] constant c-f5

vct[ 1.00e 0.1595e 2.00e 0.0985e 3.01e 0.1045e 4.01e 0.0147e 5.01e 0.0078e 6.01e 0.0016e 7.01e 0.0020e 8.02e 0.0007e 9.02e 0.0015e 10.03e 0.0008e 11.03e 0.0006e 12.02e 0.0004e 13.02e 0.0009e 14.03e 0.0006e 15.02e 0.0005e 16.03e 0.0002e 17.04e 0.0001e ] constant c-fs5

vct[ 1.00e 0.1740e 1.99e 0.0431e 2.99e 0.1899e 3.99e 0.0201e 4.98e 0.0009e 5.98e 0.0031e 6.98e 0.0055e 7.97e 0.0051e 8.97e 0.0007e 9.96e 0.0007e 10.95e 0.0006e 11.95e 0.0009e 12.95e 0.0008e 13.96e 0.0002e 14.94e 0.0001e 15.95e 0.0002e ] constant c-g5

vct[ 1.00e 0.1902e 1.99e 0.0327e 2.98e 0.0551e 3.98e 0.0157e 4.97e 0.0078e 5.97e 0.0030e 6.96e 0.0035e 7.96e 0.0020e 8.95e 0.0017e 9.94e 0.0011e 10.94e 0.0005e 11.93e 0.0007e 12.93e 0.0004e 13.92e 0.0002e 14.93e 0.0003e ] constant c-gs5

vct[ 0.99e 0.4175e 1.99e 0.0209e 2.98e 0.0274e 3.97e 0.0220e 4.96e 0.0061e 5.96e 0.0020e 6.96e 0.0038e 7.95e 0.0009e 8.95e 0.0014e 9.93e 0.0005e 10.93e 0.0005e 11.91e 0.0007e 12.91e 0.0002e 13.91e 0.0001e 14.91e 0.0001e ] constant c-a5

vct[ 1.00e 0.4648e 2.00e 0.0475e 3.01e 0.1268e 4.01e 0.0164e 5.02e 0.0035e 6.02e 0.0018e 7.02e 0.0033e 8.03e 0.0028e 9.03e 0.0008e 10.03e 0.0006e 11.03e 0.0005e 12.04e 0.0006e 13.05e 0.0003e 14.04e 0.0001e ] constant c-as5

vct[ 1.01e 0.2812e 2.02e 0.1380e 3.02e 0.0722e 4.03e 0.0215e 5.04e 0.0036e 6.06e 0.0018e 7.05e 0.0005e 8.07e 0.0015e 9.08e 0.0013e 10.08e 0.0003e 11.10e 0.0002e 12.11e 0.0003e 13.11e 0.0002e ] constant c-b5

vct[ 1.01e 0.2553e 2.01e 0.1160e 3.02e 0.0171e 4.02e 0.0272e 5.02e 0.0020e 6.03e 0.0062e 7.03e 0.0012e 8.04e 0.0011e 9.05e 0.0007e 10.05e 0.0007e 11.06e 0.0002e 12.06e 0.0001e 12.08e 0.0001e ] constant c-c6

vct[ 1.01e 0.1045e 2.02e 0.1220e 3.04e 0.0220e 4.05e 0.0094e 5.06e 0.0021e 6.07e 0.0031e 7.09e 0.0018e 8.10e 0.0020e 9.11e 0.0014e 10.12e 0.0003e 11.13e 0.0006e ] constant c-cs6

vct[ 1.00e 0.0653e 1.99e 0.2499e 2.99e 0.0334e 3.98e 0.0098e 4.98e 0.0091e 5.98e 0.0007e 6.97e 0.0011e 7.97e 0.0008e 8.96e 0.0042e 9.96e 0.0003e 10.95e 0.0004e ] constant c-d6

vct[ 0.99e 0.0485e 1.99e 0.1325e 2.98e 0.0152e 3.98e 0.0064e 4.97e 0.0043e 5.97e 0.0007e 6.96e 0.0007e 7.97e 0.0006e 8.96e 0.0003e 9.95e 0.0004e ] constant c-ds6

vct[ 1.01e 0.1797e 2.01e 0.0750e 4.03e 0.0065e 5.04e 0.0018e 6.04e 0.0012e 7.04e 0.0004e 8.06e 0.0003e 9.06e 0.0003e ] constant c-e6

\ **********************************************************
\ clarinet?
\ **********************************************************

vct[ 1.01e 0.1722e 2.00e 0.0056e 2.99e 0.1609e 3.99e 0.0333e 5.00e 0.1157e 5.99e 0.1149e 6.98e 0.0079e 7.98e 0.0620e 8.99e 0.0601e 9.99e 0.0104e 10.98e 0.0134e 11.97e 0.0122e 12.99e 0.0058e 13.98e 0.0110e 14.98e 0.0029e 15.97e 0.0045e 16.98e 0.0023e 17.98e 0.0010e 18.97e 0.0016e 19.96e 0.0021e 20.96e 0.0008e 21.97e 0.0021e 22.96e 0.0001e 23.96e 0.0012e 24.95e 0.0003e 25.97e 0.0002e 26.96e 0.0003e 27.95e 0.0002e 30.96e 0.0002e 32.94e 0.0002e 34.96e 0.0001e 35.95e 0.0002e 37.93e 0.0001e ] constant cl-d3

vct[ 0.99e 0.1038e 1.98e 0.0043e 2.96e 0.0953e 3.97e 0.0013e 4.94e 0.1057e 5.93e 0.0145e 6.93e 0.0787e 7.91e 0.0328e 8.89e 0.0086e 9.90e 0.0088e 10.88e 0.0128e 11.86e 0.0005e 12.86e 0.0085e 13.84e 0.0026e 14.83e 0.0051e 15.81e 0.0030e 16.82e 0.0008e 17.79e 0.0026e 18.78e 0.0013e 19.78e 0.0015e 20.76e 0.0011e 22.74e 0.0012e 23.72e 0.0002e 24.71e 0.0006e 25.70e 0.0003e 26.70e 0.0002e 28.67e 0.0002e 30.64e 0.0002e 31.64e 0.0001e 32.63e 0.0001e 33.61e 0.0003e 35.59e 0.0002e ] constant cl-ds3

vct[ 1.00e 0.0825e 1.99e 0.0024e 2.97e 0.0406e 3.96e 0.0042e 4.94e 0.0683e 6.40e 0.0010e 6.92e 0.0709e 7.92e 0.0099e 8.91e 0.0059e 9.89e 0.0055e 10.88e 0.0111e 11.90e 0.0009e 12.86e 0.0126e 13.87e 0.0021e 14.84e 0.0110e 15.83e 0.0010e 16.83e 0.0057e 17.81e 0.0007e 18.80e 0.0037e 19.78e 0.0008e 20.78e 0.0016e 21.75e 0.0006e 22.75e 0.0008e 23.73e 0.0005e 24.74e 0.0007e 26.72e 0.0004e 27.68e 0.0002e 29.67e 0.0003e 31.66e 0.0003e 33.64e 0.0002e ] constant cl-e3

vct[ 0.99e 0.0685e 1.98e 0.0012e 2.98e 0.0854e 3.98e 0.0029e 4.96e 0.0507e 5.97e 0.0017e 6.96e 0.0507e 7.94e 0.0027e 8.94e 0.0092e 9.94e 0.0084e 10.92e 0.0116e 11.91e 0.0018e 12.92e 0.0039e 13.92e 0.0003e 14.89e 0.0013e 15.88e 0.0019e 16.87e 0.0012e 17.86e 0.0010e 18.87e 0.0011e 19.86e 0.0008e 20.85e 0.0008e 21.83e 0.0002e 23.81e 0.0004e 24.83e 0.0002e 25.80e 0.0003e 27.78e 0.0002e 29.78e 0.0001e ] constant cl-f3

vct[ 1.00e 0.1546e 1.99e 0.0015e 2.99e 0.0594e 4.00e 0.0014e 5.00e 0.0268e 6.00e 0.0019e 7.00e 0.0170e 7.97e 0.0005e 9.00e 0.0110e 9.99e 0.0006e 10.99e 0.0077e 11.99e 0.0013e 12.99e 0.0025e 14.01e 0.0004e 14.99e 0.0018e 15.98e 0.0001e 16.98e 0.0013e 17.97e 0.0003e 18.98e 0.0013e 20.97e 0.0001e 21.97e 0.0004e 22.96e 0.0002e 23.98e 0.0002e 25.99e 0.0001e ] constant cl-fs3

vct[ 0.99e 0.1660e 2.00e 0.0016e 2.99e 0.0889e 3.99e 0.0017e 4.99e 0.0430e 6.00e 0.0009e 6.98e 0.0128e 8.00e 0.0040e 8.98e 0.0077e 9.99e 0.0017e 10.98e 0.0052e 11.98e 0.0011e 12.98e 0.0012e 13.97e 0.0008e 14.98e 0.0010e 15.97e 0.0005e 16.98e 0.0005e 17.96e 0.0007e 18.97e 0.0002e 19.96e 0.0004e 20.96e 0.0003e 22.94e 0.0003e 23.95e 0.0002e 24.96e 0.0002e 25.93e 0.0001e 26.94e 0.0002e 27.95e 0.0001e ] constant cl-g3

vct[ 1.00e 0.1107e 2.00e 0.0016e 2.99e 0.0872e 3.99e 0.0028e 4.98e 0.0293e 5.97e 0.0020e 6.96e 0.0202e 7.99e 0.0019e 8.95e 0.0118e 9.94e 0.0028e 10.95e 0.0040e 11.92e 0.0006e 12.95e 0.0030e 13.92e 0.0002e 14.92e 0.0010e 15.91e 0.0005e 16.91e 0.0015e 18.90e 0.0004e 19.89e 0.0004e 20.89e 0.0002e 21.88e 0.0004e 22.87e 0.0002e 23.88e 0.0001e 24.87e 0.0001e ] constant cl-gs3

vct[ 1.00e 0.0842e 2.01e 0.0017e 3.00e 0.0420e 4.01e 0.0029e 5.00e 0.0251e 6.02e 0.0041e 6.99e 0.0115e 7.96e 0.0006e 8.99e 0.0032e 9.98e 0.0003e 11.00e 0.0018e 11.96e 0.0003e 12.96e 0.0006e 14.00e 0.0001e 14.97e 0.0001e 15.97e 0.0005e 17.95e 0.0002e 18.96e 0.0001e 19.07e 0.0001e 22.06e 0.0001e ] constant cl-a3

vct[ 1.00e 0.1118e 1.99e 0.0006e 2.98e 0.0383e 3.98e 0.0019e 4.98e 0.0335e 5.98e 0.0034e 6.97e 0.0131e 7.94e 0.0005e 8.95e 0.0024e 9.96e 0.0028e 10.96e 0.0019e 11.94e 0.0012e 12.94e 0.0012e 13.93e 0.0003e 14.94e 0.0007e 16.92e 0.0004e 17.90e 0.0003e 18.93e 0.0002e 20.89e 0.0002e 21.90e 0.0001e ] constant cl-as3

vct[ 1.00e 0.1324e 1.99e 0.0011e 3.00e 0.0693e 4.01e 0.0012e 4.99e 0.0279e 5.98e 0.0044e 6.98e 0.0149e 7.97e 0.0009e 8.97e 0.0028e 9.97e 0.0009e 10.98e 0.0026e 11.96e 0.0003e 12.96e 0.0006e 13.95e 0.0003e 15.95e 0.0001e 16.94e 0.0001e ] constant cl-b3

vct[ 1.00e 0.2335e 1.99e 0.0017e 2.99e 0.1253e 4.01e 0.0023e 4.99e 0.0343e 6.01e 0.0028e 6.98e 0.0023e 7.98e 0.0014e 8.98e 0.0041e 10.01e 0.0003e 10.96e 0.0004e 11.94e 0.0008e 12.94e 0.0002e 14.94e 0.0003e 15.94e 0.0004e 16.93e 0.0002e 17.91e 0.0002e 18.91e 0.0002e 19.91e 0.0001e 20.90e 0.0001e ] constant cl-c4

vct[ 0.99e 0.2609e 2.00e 0.0016e 2.99e 0.1469e 3.99e 0.0040e 4.99e 0.0143e 5.97e 0.0091e 6.97e 0.0055e 7.97e 0.0024e 8.96e 0.0041e 9.96e 0.0015e 10.96e 0.0021e 11.95e 0.0005e 12.94e 0.0011e 13.93e 0.0004e 14.94e 0.0006e 15.94e 0.0004e 16.92e 0.0004e 17.93e 0.0002e 18.93e 0.0001e 19.91e 0.0001e 20.91e 0.0001e 21.90e 0.0002e 22.91e 0.0001e ] constant cl-cs4

vct[ 1.00e 0.2056e 1.99e 0.0006e 2.99e 0.1715e 3.99e 0.0010e 4.98e 0.0194e 5.99e 0.0028e 6.98e 0.0106e 7.98e 0.0007e 8.97e 0.0022e 9.97e 0.0005e 10.96e 0.0011e 11.97e 0.0006e 12.96e 0.0006e 13.96e 0.0003e 14.95e 0.0005e 15.95e 0.0003e 17.95e 0.0002e 18.94e 0.0002e 20.94e 0.0001e ] constant cl-d4

vct[ 1.00e 0.2590e 1.98e 0.0019e 2.99e 0.1336e 3.97e 0.0034e 4.97e 0.0442e 5.97e 0.0017e 6.96e 0.0108e 7.96e 0.0006e 8.95e 0.0031e 9.94e 0.0003e 11.93e 0.0003e 12.93e 0.0004e 13.93e 0.0005e 14.92e 0.0001e 15.91e 0.0003e 16.90e 0.0004e 17.90e 0.0002e 18.89e 0.0001e ] constant cl-ds4

vct[ 1.00e 0.2560e 2.00e 0.0013e 3.00e 0.0878e 4.00e 0.0053e 5.00e 0.0304e 6.00e 0.0009e 7.00e 0.0060e 7.99e 0.0007e 9.00e 0.0011e 9.99e 0.0006e 10.99e 0.0006e 11.98e 0.0001e 13.99e 0.0001e ] constant cl-e4

vct[ 0.99e 0.1966e 1.99e 0.0021e 2.98e 0.0812e 3.96e 0.0018e 4.97e 0.0248e 5.96e 0.0032e 6.96e 0.0060e 7.95e 0.0024e 8.95e 0.0019e 9.94e 0.0008e 10.94e 0.0007e 11.92e 0.0005e 12.91e 0.0002e 13.94e 0.0001e 14.90e 0.0002e 15.91e 0.0002e ] constant cl-f4

vct[ 1.00e 0.1555e 2.01e 0.0022e 3.01e 0.1755e 4.01e 0.0005e 5.01e 0.0127e 6.02e 0.0004e 7.02e 0.0031e 8.02e 0.0007e 9.02e 0.0005e 10.02e 0.0002e 11.03e 0.0003e 12.02e 0.0002e 14.02e 0.0001e 15.03e 0.0001e 16.04e 0.0001e ] constant cl-fs4

vct[ 1.00e 0.0470e 2.00e 0.0016e 3.00e 0.0787e 4.00e 0.0041e 5.00e 0.0046e 6.00e 0.0010e 7.00e 0.0036e 8.00e 0.0011e 9.00e 0.0012e 10.00e 0.0002e 11.00e 0.0003e 13.00e 0.0001e ] constant cl-g4

vct[ 1.00e 0.1205e 1.99e 0.0014e 2.99e 0.0145e 3.99e 0.0015e 4.99e 0.0030e 5.99e 0.0005e 6.98e 0.0006e 9.00e 0.0001e 9.98e 0.0001e ] constant cl-gs4

vct[ 1.00e 0.2677e 2.00e 0.0592e 3.01e 0.0961e 4.01e 0.0083e 5.02e 0.0075e 6.02e 0.0027e 7.03e 0.0048e 8.03e 0.0031e 9.02e 0.0007e 10.03e 0.0003e 11.03e 0.0001e ] constant cl-a4

vct[ 1.00e 0.1363e 2.01e 0.0056e 3.00e 0.0168e 4.01e 0.0026e 5.01e 0.0112e 6.00e 0.0011e 7.01e 0.0011e 8.01e 0.0003e 10.00e 0.0002e 12.02e 0.0001e ] constant cl-as4

vct[ 1.01e 0.0312e 2.01e 0.0042e 3.02e 0.0061e 4.02e 0.0127e 5.03e 0.0090e 6.04e 0.0002e 7.04e 0.0021e 8.05e 0.0008e 11.06e 0.0001e ] constant cl-b4

vct[ 1.00e 0.2597e 2.00e 0.0052e 3.00e 0.0337e 4.00e 0.0012e 5.00e 0.0025e 6.00e 0.0014e 7.00e 0.0007e 7.99e 0.0004e 8.99e 0.0003e 10.00e 0.0004e ] constant cl-c5

vct[ 1.00e 0.1894e 2.00e 0.0060e 3.00e 0.0250e 4.01e 0.0022e 5.01e 0.0048e 6.00e 0.0004e 8.01e 0.0001e 10.01e 0.0001e ] constant cl-cs5

vct[ 1.00e 0.1727e 2.01e 0.0013e 3.00e 0.0066e 4.01e 0.0011e 5.00e 0.0013e 5.99e 0.0008e 8.02e 0.0001e ] constant cl-d5

vct[ 1.00e 0.3538e 2.00e 0.0053e 3.01e 0.0757e 4.01e 0.0009e 5.01e 0.0045e 6.02e 0.0008e 7.02e 0.0011e 8.01e 0.0003e 9.02e 0.0005e 10.01e 0.0002e 11.02e 0.0001e 12.02e 0.0002e ] constant cl-ds5

vct[ 1.00e 0.1647e 2.00e 0.0048e 3.00e 0.0524e 3.99e 0.0055e 4.99e 0.0030e 5.98e 0.0011e 6.99e 0.0004e 7.99e 0.0003e ] constant cl-e5

vct[ 0.99e 0.1880e 1.99e 0.0126e 2.99e 0.0222e 3.98e 0.0070e 4.98e 0.0135e 5.97e 0.0020e 6.97e 0.0012e 7.96e 0.0001e 8.96e 0.0007e 9.95e 0.0003e ] constant cl-f5

vct[ 1.00e 0.3103e 2.00e 0.0104e 3.00e 0.0335e 4.00e 0.0078e 5.00e 0.0026e 6.01e 0.0005e 7.01e 0.0006e 8.00e 0.0003e ] constant cl-fs5

vct[ 1.01e 0.4163e 2.01e 0.0446e 3.02e 0.0290e 4.03e 0.0031e 5.02e 0.0004e 6.03e 0.0002e 7.05e 0.0001e 8.05e 0.0001e ] constant cl-g5

vct[ 1.01e 0.2150e 2.00e 0.0334e 3.00e 0.0012e 4.02e 0.0003e 5.02e 0.0002e ] constant cl-gs5

vct[ 1.01e 0.5463e 2.01e 0.0429e 3.02e 0.0317e 4.02e 0.0159e 5.03e 0.0012e 6.04e 0.0005e 7.04e 0.0005e 8.05e 0.0002e ] constant cl-a5

vct[ 1.00e 0.3802e 2.00e 0.0397e 3.01e 0.0186e 4.01e 0.0102e 5.01e 0.0020e 6.01e 0.0001e 7.01e 0.0002e 8.02e 0.0003e 9.02e 0.0002e 10.02e 0.0001e 11.02e 0.0001e 12.02e 0.0002e ] constant cl-as5

vct[ 1.00e 0.0896e 2.00e 0.0851e 3.00e 0.0081e 4.00e 0.0024e 5.00e 0.0010e 6.00e 0.0001e 7.00e 0.0002e ] constant cl-b5

vct[ 1.00e 0.1740e 2.00e 0.0081e 3.01e 0.0111e 4.01e 0.0087e 5.01e 0.0005e 6.01e 0.0007e 7.01e 0.0001e 9.01e 0.0002e 10.02e 0.0002e ] constant cl-c6

vct[ 1.00e 0.1295e 1.99e 0.0270e 2.99e 0.0012e 3.99e 0.0004e ] constant cl-cs6

vct[ 1.00e 0.1700e 2.01e 0.0603e 3.01e 0.0169e 4.01e 0.0031e 5.01e 0.0007e 6.01e 0.0002e ] constant cl-d6

vct[ 1.01e 0.2624e 2.02e 0.0042e 3.03e 0.0049e 4.03e 0.0015e 5.04e 0.0001e ] constant cl-ds6

vct[ 1.02e 0.0632e 2.03e 0.0115e 3.04e 0.0011e 4.06e 0.0006e ] constant cl-e6

vct[ 1.02e 0.0748e 2.03e 0.0535e 3.05e 0.0044e 4.07e 0.0009e 5.08e 0.0001e 7.12e 0.0001e 8.13e 0.0001e ] constant cl-f6

vct[ 1.02e 0.0305e 2.03e 0.0175e 3.04e 0.0005e 4.05e 0.0002e ] constant cl-fs6

vct[ 1.03e 0.0026e 2.04e 0.0008e ] constant cl-g6

vct[ 1.03e 0.0015e 2.00e 0.0002e ] constant cl-gs6

vct[ 1.03e 0.0043e 2.05e 0.0010e ] constant cl-a6

vct[ 1.05e 0.0008e 2.00e 0.0001e ] constant cl-as6

\ **********************************************************
\ french horn?
\ **********************************************************

vct[ 1.01e 0.0041e 2.00e 0.0015e 3.01e 0.0121e 4.02e 0.0111e 5.02e 0.0343e 6.03e 0.0165e 7.04e 0.0066e 8.03e 0.0064e 9.05e 0.0049e 10.06e 0.0012e 11.05e 0.0093e 12.07e 0.0029e 13.07e 0.0042e 14.08e 0.0040e 15.08e 0.0019e 16.09e 0.0013e 17.10e 0.0009e 18.04e 0.0002e 19.03e 0.0002e 20.12e 0.0003e 21.13e 0.0003e 22.13e 0.0002e 23.13e 0.0002e ] constant fh-as1

vct[ 1.01e 0.0035e 2.03e 0.0064e 3.04e 0.0087e 4.08e 0.0087e 5.12e 0.0049e 6.08e 0.0189e 7.10e 0.0304e 8.12e 0.0205e 9.16e 0.0026e 10.18e 0.0039e 11.20e 0.0006e 12.11e 0.0029e 13.15e 0.0037e 14.24e 0.0014e 15.26e 0.0010e 16.29e 0.0005e 17.19e 0.0003e 18.21e 0.0007e 19.23e 0.0005e 20.25e 0.0004e 21.33e 0.0003e 22.36e 0.0001e 23.32e 0.0002e 24.33e 0.0002e 25.33e 0.0001e 26.39e 0.0002e 27.42e 0.0002e ] constant fh-b1

vct[ 1.02e 0.0034e 2.02e 0.0059e 3.01e 0.0083e 4.02e 0.0274e 5.03e 0.0206e 6.03e 0.0155e 7.04e 0.0131e 8.03e 0.0073e 9.05e 0.0014e 10.03e 0.0064e 11.05e 0.0055e 12.06e 0.0109e 13.08e 0.0037e 14.10e 0.0012e 15.10e 0.0010e 16.01e 0.0004e 17.05e 0.0009e 18.06e 0.0008e 19.06e 0.0006e 20.09e 0.0004e 21.11e 0.0002e 22.14e 0.0002e 23.09e 0.0002e 24.08e 0.0001e 25.08e 0.0002e 26.07e 0.0002e 27.12e 0.0002e 28.16e 0.0001e 32.11e 0.0001e ] constant fh-c2

vct[ 1.01e 0.0038e 1.99e 0.0124e 2.98e 0.0065e 4.00e 0.0260e 5.00e 0.0138e 5.99e 0.0093e 6.97e 0.0077e 7.95e 0.0055e 8.97e 0.0061e 9.97e 0.0016e 10.95e 0.0034e 11.96e 0.0036e 12.14e 0.0010e 12.94e 0.0009e 13.97e 0.0008e 14.86e 0.0004e 15.89e 0.0006e 16.91e 0.0007e 17.93e 0.0004e 18.94e 0.0002e 19.95e 0.0001e 20.77e 0.0001e 21.78e 0.0002e 22.86e 0.0001e 23.89e 0.0002e ] constant fh-cs2

vct[ 1.01e 0.0153e 2.01e 0.0192e 3.01e 0.0216e 4.01e 0.0371e 5.01e 0.0259e 6.02e 0.0188e 7.02e 0.0076e 8.04e 0.0009e 9.03e 0.0038e 10.03e 0.0065e 11.03e 0.0075e 12.03e 0.0026e 13.03e 0.0005e 14.04e 0.0009e 15.06e 0.0008e 16.04e 0.0006e 17.03e 0.0004e 18.03e 0.0003e 19.04e 0.0002e 23.03e 0.0002e ] constant fh-d2

vct[ 1.00e 0.0234e 1.98e 0.0227e 2.96e 0.0129e 3.97e 0.0333e 4.96e 0.0315e 5.95e 0.0252e 6.93e 0.0076e 7.94e 0.0061e 8.91e 0.0028e 9.89e 0.0096e 10.90e 0.0089e 11.89e 0.0024e 12.88e 0.0022e 13.88e 0.0019e 14.87e 0.0010e 15.79e 0.0006e 16.79e 0.0003e 17.79e 0.0002e 18.69e 0.0002e 19.68e 0.0003e 20.70e 0.0002e 21.70e 0.0002e ] constant fh-ds2

vct[ 1.00e 0.0150e 1.99e 0.0230e 3.01e 0.0204e 4.00e 0.0298e 5.02e 0.0112e 6.03e 0.0135e 7.02e 0.0019e 8.03e 0.0061e 9.01e 0.0099e 10.04e 0.0053e 11.03e 0.0006e 12.04e 0.0028e 13.04e 0.0016e 14.04e 0.0015e 15.03e 0.0009e 16.02e 0.0005e 17.05e 0.0002e 20.02e 0.0002e 21.02e 0.0001e 24.00e 0.0002e 25.03e 0.0001e ] constant fh-e2

vct[ 0.97e 0.0088e 1.96e 0.0127e 2.97e 0.0179e 3.96e 0.0163e 4.94e 0.0421e 5.91e 0.0165e 6.96e 0.0019e 7.93e 0.0020e 8.91e 0.0112e 9.85e 0.0035e 10.91e 0.0017e 12.02e 0.0004e 12.83e 0.0014e 13.79e 0.0010e 14.79e 0.0007e 15.75e 0.0002e 16.73e 0.0003e 17.74e 0.0007e 18.74e 0.0005e 19.73e 0.0001e 20.68e 0.0002e 21.66e 0.0002e 22.65e 0.0002e 23.63e 0.0001e 24.65e 0.0001e ] constant fh-f2

vct[ 1.00e 0.0035e 1.99e 0.0136e 2.97e 0.0394e 3.96e 0.0379e 4.98e 0.0330e 5.97e 0.0111e 6.94e 0.0156e 7.94e 0.0108e 8.96e 0.0076e 9.95e 0.0025e 10.95e 0.0021e 11.93e 0.0026e 12.93e 0.0014e 13.89e 0.0008e 14.87e 0.0006e 15.78e 0.0001e 16.94e 0.0001e 17.93e 0.0001e 18.93e 0.0001e 19.89e 0.0001e ] constant fh-fs2

vct[ 1.01e 0.0150e 2.01e 0.0182e 3.04e 0.1047e 4.04e 0.0662e 5.03e 0.0448e 6.06e 0.0018e 7.06e 0.0034e 8.06e 0.0202e 9.09e 0.0051e 10.09e 0.0070e 11.08e 0.0060e 12.11e 0.0022e 13.12e 0.0011e 14.13e 0.0005e 15.20e 0.0001e 16.09e 0.0002e 17.14e 0.0002e 18.14e 0.0002e 19.14e 0.0002e 20.16e 0.0002e 21.15e 0.0001e 22.15e 0.0001e ] constant fh-g2

vct[ 0.99e 0.0092e 2.00e 0.0177e 3.00e 0.0664e 3.98e 0.0447e 4.99e 0.0223e 5.99e 0.0144e 7.00e 0.0124e 7.97e 0.0096e 8.97e 0.0046e 9.96e 0.0011e 10.99e 0.0021e 12.00e 0.0010e 12.99e 0.0007e 13.93e 0.0007e 14.92e 0.0007e 15.94e 0.0005e 16.94e 0.0003e 17.90e 0.0002e 18.88e 0.0001e 19.87e 0.0002e 20.86e 0.0002e 21.86e 0.0001e ] constant fh-gs2

vct[ 1.00e 0.0063e 2.01e 0.0609e 3.03e 0.0699e 4.05e 0.1365e 5.04e 0.0249e 6.05e 0.0103e 7.07e 0.0200e 8.08e 0.0059e 9.10e 0.0063e 10.09e 0.0046e 11.10e 0.0015e 12.13e 0.0008e 13.14e 0.0006e 14.07e 0.0004e 15.05e 0.0004e 16.08e 0.0004e 17.10e 0.0002e 18.12e 0.0002e 19.10e 0.0001e ] constant fh-a2

vct[ 1.00e 0.0026e 2.02e 0.0329e 3.03e 0.0926e 4.04e 0.0530e 5.07e 0.0041e 6.07e 0.0072e 7.09e 0.0076e 8.10e 0.0053e 9.11e 0.0057e 10.13e 0.0017e 11.16e 0.0005e 12.21e 0.0001e 13.09e 0.0003e 14.11e 0.0003e 15.18e 0.0003e 16.17e 0.0001e ] constant fh-as2

vct[ 1.01e 0.0154e 2.02e 0.0506e 3.05e 0.1042e 4.05e 0.0643e 5.06e 0.0151e 6.08e 0.0102e 7.09e 0.0045e 8.11e 0.0040e 9.12e 0.0033e 10.12e 0.0015e 11.13e 0.0006e 12.16e 0.0004e 13.18e 0.0003e 14.95e 0.0001e 15.98e 0.0001e 16.99e 0.0001e 18.02e 0.0001e ] constant fh-b2

vct[ 1.01e 0.0147e 2.02e 0.0897e 3.01e 0.1180e 4.01e 0.0323e 5.02e 0.0133e 6.04e 0.0226e 7.04e 0.0033e 8.06e 0.0023e 9.02e 0.0019e 10.03e 0.0010e 11.04e 0.0009e 12.06e 0.0003e 13.04e 0.0002e 14.05e 0.0002e 15.05e 0.0002e 16.01e 0.0002e 16.94e 0.0001e ] constant fh-c3

vct[ 1.01e 0.0345e 2.00e 0.1083e 2.99e 0.0911e 4.01e 0.0280e 5.01e 0.0071e 6.00e 0.0123e 7.00e 0.0043e 8.01e 0.0034e 9.01e 0.0014e 10.02e 0.0004e 10.94e 0.0003e 11.96e 0.0003e 12.96e 0.0002e 14.89e 0.0001e 15.92e 0.0001e ] constant fh-cs3

vct[ 1.01e 0.0488e 2.02e 0.1313e 3.03e 0.1606e 4.03e 0.0029e 5.04e 0.0187e 6.05e 0.0059e 7.05e 0.0018e 8.05e 0.0023e 9.05e 0.0007e 10.06e 0.0003e 11.07e 0.0001e 12.08e 0.0002e ] constant fh-d3

vct[ 1.00e 0.0619e 2.00e 0.1230e 3.01e 0.0981e 4.02e 0.0299e 5.02e 0.0210e 6.03e 0.0054e 7.03e 0.0023e 8.04e 0.0010e 9.04e 0.0005e 10.06e 0.0002e ] constant fh-ds3

vct[ 1.00e 0.0500e 2.01e 0.1076e 3.03e 0.1077e 4.04e 0.0167e 5.03e 0.0138e 6.06e 0.0058e 7.07e 0.0036e 8.06e 0.0007e 9.09e 0.0004e 10.07e 0.0002e 11.03e 0.0001e 12.05e 0.0002e ] constant fh-e3

vct[ 1.01e 0.0368e 2.02e 0.1311e 3.02e 0.0405e 4.03e 0.0139e 5.03e 0.0080e 6.04e 0.0052e 7.05e 0.0015e 8.04e 0.0004e 9.06e 0.0002e 10.06e 0.0002e 12.08e 0.0001e ] constant fh-f3

vct[ 1.01e 0.0430e 2.02e 0.1877e 3.05e 0.0299e 4.05e 0.0218e 5.07e 0.0067e 6.08e 0.0054e 7.10e 0.0012e 8.11e 0.0010e 9.12e 0.0004e 10.13e 0.0002e 11.15e 0.0001e ] constant fh-fs3

vct[ 1.01e 0.0339e 2.04e 0.1965e 4.07e 0.0541e 5.08e 0.0113e 6.10e 0.0049e 7.10e 0.0022e 8.13e 0.0014e 9.14e 0.0008e 10.16e 0.0005e ] constant fh-g3

vct[ 1.02e 0.0596e 2.02e 0.1865e 3.03e 0.0629e 4.04e 0.0304e 5.05e 0.0087e 6.05e 0.0035e 7.07e 0.0008e 8.09e 0.0004e 9.09e 0.0005e 10.10e 0.0005e 11.11e 0.0002e 12.12e 0.0001e ] constant fh-gs3

vct[ 1.00e 0.1160e 2.02e 0.2642e 3.02e 0.0259e 4.02e 0.0127e 5.04e 0.0095e 6.04e 0.0022e 7.04e 0.0013e 8.06e 0.0008e 9.04e 0.0003e 10.01e 0.0001e ] constant fh-a3

vct[ 1.01e 0.0585e 2.01e 0.1648e 3.02e 0.0229e 4.02e 0.0150e 5.03e 0.0084e 6.03e 0.0016e 7.06e 0.0003e 9.01e 0.0002e ] constant fh-as3

vct[ 1.01e 0.0741e 2.00e 0.1581e 3.00e 0.0490e 4.01e 0.0133e 5.01e 0.0045e 6.02e 0.0013e 7.03e 0.0002e 8.00e 0.0001e ] constant fh-b3

vct[ 0.99e 0.1378e 2.00e 0.0872e 2.99e 0.0736e 3.99e 0.0065e 4.99e 0.0025e 5.97e 0.0009e 6.98e 0.0002e 7.98e 0.0005e 8.98e 0.0002e ] constant fh-c4

vct[ 1.01e 0.2826e 2.02e 0.0676e 3.02e 0.0523e 4.03e 0.0208e 5.04e 0.0069e 6.04e 0.0009e 7.05e 0.0009e 8.06e 0.0011e 9.07e 0.0004e 10.07e 0.0001e 11.08e 0.0002e 12.09e 0.0001e ] constant fh-cs4

vct[ 1.01e 0.2849e 2.02e 0.0068e 3.03e 0.0144e 4.04e 0.0066e 5.05e 0.0032e 6.07e 0.0007e 7.07e 0.0003e 8.09e 0.0003e ] constant fh-d4

vct[ 1.00e 0.2321e 2.01e 0.0612e 3.02e 0.0150e 4.03e 0.0042e 5.03e 0.0007e 6.04e 0.0005e 7.05e 0.0002e 8.06e 0.0001e ] constant fh-ds4

vct[ 1.01e 0.1701e 2.01e 0.0303e 3.02e 0.0156e 4.03e 0.0021e 5.04e 0.0009e 6.04e 0.0003e 7.04e 0.0001e ] constant fh-e4

vct[ 1.01e 0.1957e 2.01e 0.0196e 3.01e 0.0087e 4.01e 0.0022e 5.01e 0.0006e 6.02e 0.0002e ] constant fh-f4

vct[ 1.01e 0.3622e 2.02e 0.0601e 3.03e 0.0187e 4.04e 0.0043e 5.05e 0.0011e 6.06e 0.0005e ] constant fh-fs4

vct[ 1.00e 0.2782e 2.01e 0.0918e 3.01e 0.0080e 4.03e 0.0013e 5.03e 0.0010e 6.03e 0.0003e ] constant fh-g4

vct[ 1.01e 0.2703e 2.02e 0.0548e 3.02e 0.0083e 4.03e 0.0011e 5.03e 0.0009e 6.04e 0.0003e ] constant fh-gs4

vct[ 1.01e 0.4575e 2.02e 0.0245e 3.03e 0.0049e 4.04e 0.0019e 5.05e 0.0008e 6.06e 0.0002e ] constant fh-a4

vct[ 1.00e 0.2524e 2.01e 0.0291e 3.02e 0.0022e 4.03e 0.0011e 5.03e 0.0003e ] constant fh-as4

vct[ 1.00e 0.3254e 2.00e 0.0428e 3.00e 0.0026e 4.00e 0.0006e ] constant fh-b4

vct[ 1.00e 0.1672e 2.00e 0.0223e 3.00e 0.0010e 4.00e 0.0005e ] constant fh-c5

vct[ 1.00e 0.1209e 2.00e 0.0340e 3.00e 0.0014e 4.01e 0.0004e ] constant fh-cs5

vct[ 1.01e 0.0150e 2.01e 0.0313e 3.02e 0.0023e 4.03e 0.0007e ] constant fh-d5

vct[ 1.00e 0.1633e 2.00e 0.0260e 3.00e 0.0012e 4.00e 0.0002e ] constant fh-ds5

vct[ 1.00e 0.1001e 2.00e 0.0146e 3.00e 0.0019e 4.00e 0.0001e ] constant fh-e5

vct[ 1.01e 0.0944e 2.01e 0.0114e 3.02e 0.0016e 4.02e 0.0002e ] constant fh-f5

vct[ 1.01e 0.1904e 2.02e 0.0076e 3.02e 0.0025e 4.03e 0.0003e ] constant fh-fs5

vct[ 1.00e 0.2511e 2.00e 0.0017e 3.01e 0.0010e 4.01e 0.0004e ] constant fh-g5

vct[ 1.00e 0.1029e 1.99e 0.0050e 2.99e 0.0007e 3.99e 0.0002e ] constant fh-gs5

\ **********************************************************
\ 
\ **********************************************************

vct[ 1.01e 0.0025e 1.99e 0.0008e 3.01e 0.0057e 4.02e 0.0063e 5.03e 0.0268e 6.04e 0.0198e 7.04e 0.0157e 8.03e 0.0160e 9.05e 0.0056e 10.05e 0.0016e 11.06e 0.0059e 12.09e 0.0009e 13.10e 0.0023e 14.08e 0.0022e 15.09e 0.0011e 16.10e 0.0011e 17.11e 0.0012e 18.16e 0.0009e 19.16e 0.0008e 20.15e 0.0005e 21.16e 0.0002e 22.15e 0.0001e 23.15e 0.0001e ] constant fhf-as1

vct[ 1.03e 0.0025e 2.07e 0.0054e 5.15e 0.0276e 6.18e 0.0379e 7.21e 0.0389e 8.23e 0.0176e 9.26e 0.0020e 10.29e 0.0039e 11.24e 0.0002e 12.26e 0.0010e 13.28e 0.0015e 14.34e 0.0010e 15.37e 0.0009e 16.42e 0.0010e 17.47e 0.0027e 18.49e 0.0015e 19.52e 0.0010e 20.56e 0.0005e 21.57e 0.0004e 22.59e 0.0004e 23.60e 0.0003e 24.61e 0.0003e 25.65e 0.0002e 26.67e 0.0002e 27.66e 0.0001e 28.71e 0.0002e 29.75e 0.0001e ] constant fhf-b1

vct[ 1.02e 0.0023e 2.03e 0.0041e 3.03e 0.0059e 4.05e 0.0291e 5.05e 0.0280e 6.06e 0.0396e 7.06e 0.0428e 8.07e 0.0111e 9.08e 0.0018e 10.10e 0.0049e 11.12e 0.0052e 12.12e 0.0075e 13.12e 0.0021e 14.15e 0.0009e 15.18e 0.0008e 16.21e 0.0009e 17.22e 0.0012e 18.23e 0.0008e 19.23e 0.0003e 20.24e 0.0003e 21.23e 0.0002e 22.22e 0.0002e 23.22e 0.0002e 24.25e 0.0001e 25.27e 0.0002e 26.27e 0.0001e 28.25e 0.0001e 30.29e 0.0001e 32.31e 0.0001e ] constant fhf-c2

vct[ 1.03e 0.0031e 2.02e 0.0111e 3.02e 0.0074e 4.01e 0.0370e 5.01e 0.0307e 6.03e 0.0330e 7.03e 0.0281e 8.02e 0.0089e 9.02e 0.0097e 9.21e 0.0016e 10.03e 0.0014e 11.04e 0.0044e 12.03e 0.0039e 12.96e 0.0004e 14.09e 0.0011e 15.10e 0.0006e 16.10e 0.0014e 17.09e 0.0011e 18.09e 0.0006e 19.10e 0.0005e 20.10e 0.0004e 21.08e 0.0002e 22.10e 0.0003e 22.28e 0.0002e 23.07e 0.0001e 24.04e 0.0002e 25.09e 0.0001e 26.10e 0.0001e 27.10e 0.0001e 32.10e 0.0001e ] constant fhf-cs2

vct[ 1.00e 0.0154e 2.01e 0.0193e 3.01e 0.0257e 4.00e 0.0566e 5.00e 0.0570e 6.01e 0.0680e 7.01e 0.0222e 8.03e 0.0023e 9.02e 0.0036e 10.05e 0.0043e 11.07e 0.0037e 12.07e 0.0010e 12.97e 0.0005e 13.99e 0.0014e 14.99e 0.0022e 15.98e 0.0023e 16.97e 0.0011e 17.96e 0.0007e 18.95e 0.0004e 19.12e 0.0003e 19.89e 0.0002e 20.92e 0.0003e 21.11e 0.0002e 21.92e 0.0002e 22.91e 0.0002e 23.88e 0.0002e 24.92e 0.0002e 25.89e 0.0003e 26.88e 0.0003e 27.84e 0.0001e ] constant fhf-d2

vct[ 1.00e 0.0204e 2.02e 0.0234e 3.03e 0.0132e 4.04e 0.0416e 5.05e 0.0425e 6.04e 0.0258e 7.06e 0.0086e 8.07e 0.0067e 9.14e 0.0009e 10.17e 0.0030e 11.20e 0.0008e 12.09e 0.0016e 13.11e 0.0015e 14.12e 0.0029e 15.11e 0.0028e 16.11e 0.0011e 17.11e 0.0006e 18.09e 0.0003e 19.13e 0.0004e 19.29e 0.0002e 20.10e 0.0002e 21.13e 0.0002e 21.29e 0.0002e 22.26e 0.0001e 23.11e 0.0003e 24.11e 0.0003e 25.08e 0.0002e 26.10e 0.0002e 27.08e 0.0002e 28.10e 0.0001e 28.28e 0.0001e ] constant fhf-ds2

vct[ 1.00e 0.0097e 1.99e 0.0146e 3.00e 0.0159e 4.00e 0.0246e 5.02e 0.0137e 6.06e 0.0177e 7.02e 0.0017e 8.05e 0.0029e 9.04e 0.0058e 10.06e 0.0041e 10.96e 0.0009e 12.03e 0.0029e 13.08e 0.0021e 14.12e 0.0008e 15.14e 0.0002e 16.11e 0.0002e 26.90e 0.0001e ] constant fhf-e2

vct[ 1.00e 0.0039e 2.02e 0.0070e 3.04e 0.0156e 4.06e 0.0113e 5.08e 0.0222e 6.07e 0.0065e 7.07e 0.0046e 8.12e 0.0018e 9.13e 0.0081e 10.13e 0.0014e 11.17e 0.0012e 12.17e 0.0014e 13.21e 0.0007e 13.98e 0.0005e 14.24e 0.0003e 14.98e 0.0003e 15.96e 0.0002e 17.21e 0.0001e 18.97e 0.0002e 20.02e 0.0001e 21.05e 0.0001e ] constant fhf-f2

vct[ 1.02e 0.0030e 2.03e 0.0096e 3.04e 0.0372e 4.06e 0.0225e 5.09e 0.0048e 6.17e 0.0019e 7.19e 0.0014e 8.20e 0.0014e 9.19e 0.0023e 10.22e 0.0008e 11.09e 0.0003e 12.23e 0.0006e 13.25e 0.0004e 14.25e 0.0002e 15.14e 0.0001e 16.19e 0.0002e 17.20e 0.0002e 18.24e 0.0002e 19.23e 0.0001e 20.27e 0.0001e 21.29e 0.0001e 23.26e 0.0001e ] constant fhf-fs2

vct[ 1.03e 0.0067e 2.02e 0.0055e 3.06e 0.0282e 5.01e 0.0043e 5.20e 0.0033e 6.05e 0.0006e 7.09e 0.0009e 8.13e 0.0070e 9.17e 0.0006e 10.20e 0.0010e 11.23e 0.0007e 12.28e 0.0002e 13.16e 0.0001e 14.23e 0.0001e ] constant fhf-g2

vct[ 0.99e 0.0029e 2.02e 0.0054e 3.01e 0.0149e 4.03e 0.0101e 5.03e 0.0047e 6.02e 0.0035e 7.02e 0.0028e 8.04e 0.0026e 9.03e 0.0010e 10.03e 0.0003e 11.07e 0.0004e 11.89e 0.0001e 12.98e 0.0001e 13.99e 0.0002e ] constant fhf-gs2

vct[ 0.99e 0.0020e 2.00e 0.0131e 3.00e 0.0085e 4.01e 0.0199e 4.99e 0.0044e 5.98e 0.0020e 7.00e 0.0029e 8.01e 0.0009e 9.02e 0.0010e 9.99e 0.0007e 10.94e 0.0003e ] constant fhf-a2

vct[ 1.00e 0.0013e 2.01e 0.0042e 3.01e 0.0101e 3.99e 0.0132e 4.98e 0.0011e 5.97e 0.0007e 6.96e 0.0031e 7.99e 0.0009e 9.10e 0.0003e 9.99e 0.0003e 10.92e 0.0002e 11.88e 0.0002e 12.85e 0.0001e ] constant fhf-as2

vct[ 1.01e 0.0038e 2.00e 0.0081e 2.98e 0.0138e 3.96e 0.0105e 4.96e 0.0021e 5.95e 0.0034e 6.89e 0.0013e 7.91e 0.0006e 8.86e 0.0005e 9.87e 0.0001e ] constant fhf-b2

vct[ 1.00e 0.0033e 2.01e 0.0162e 3.00e 0.0168e 4.00e 0.0069e 5.00e 0.0033e 6.01e 0.0061e 7.01e 0.0006e 8.01e 0.0003e 8.98e 0.0003e 9.97e 0.0002e 10.98e 0.0001e ] constant fhf-c3

vct[ 1.01e 0.0161e 2.01e 0.0404e 3.01e 0.0208e 4.02e 0.0039e 5.02e 0.0013e 6.02e 0.0041e 7.02e 0.0019e 8.01e 0.0011e 9.01e 0.0003e ] constant fhf-cs3

vct[ 1.01e 0.0238e 2.01e 0.0582e 3.02e 0.0679e 4.02e 0.0022e 5.03e 0.0081e 6.03e 0.0024e 7.03e 0.0012e 8.05e 0.0010e 9.05e 0.0001e 10.08e 0.0001e ] constant fhf-d3

vct[ 1.00e 0.0295e 2.01e 0.0519e 3.02e 0.0343e 4.04e 0.0119e 5.05e 0.0067e 6.07e 0.0011e 7.08e 0.0013e 8.09e 0.0004e ] constant fhf-ds3 

vct[ 1.01e 0.0251e 2.04e 0.0479e 3.03e 0.0741e 4.04e 0.0054e 5.05e 0.0049e 6.04e 0.0029e 7.06e 0.0021e 8.10e 0.0006e 9.11e 0.0004e 10.10e 0.0002e 11.13e 0.0002e ] constant fhf-e3

vct[ 1.02e 0.0143e 2.02e 0.0453e 3.04e 0.0115e 4.05e 0.0021e 5.08e 0.0007e 6.10e 0.0007e 7.07e 0.0006e 8.04e 0.0001e ] constant fhf-f3

vct[ 1.01e 0.0220e 2.03e 0.0843e 3.04e 0.0119e 4.06e 0.0062e 5.09e 0.0022e 6.12e 0.0016e 7.14e 0.0003e 9.13e 0.0001e ] constant fhf-fs3

vct[ 1.02e 0.0145e 2.03e 0.0700e 3.03e 0.0010e 5.13e 0.0013e 6.14e 0.0007e 7.14e 0.0002e ] constant fhf-g3

vct[ 1.02e 0.0273e 2.03e 0.0703e 3.04e 0.0176e 4.07e 0.0073e 5.08e 0.0021e 6.09e 0.0004e 7.09e 0.0002e 8.09e 0.0001e ] constant fhf-gs3

vct[ 1.00e 0.0529e 2.02e 0.0982e 3.02e 0.0066e 4.04e 0.0034e 5.05e 0.0029e 6.04e 0.0003e 7.03e 0.0002e ] constant fhf-a3a

vct[ 1.01e 0.0274e 2.01e 0.0613e 3.02e 0.0056e 4.03e 0.0056e 5.03e 0.0024e 6.03e 0.0003e ] constant fhf-as3

vct[ 1.01e 0.0468e 2.01e 0.0884e 3.01e 0.0246e 4.02e 0.0058e 5.03e 0.0016e 6.03e 0.0005e 7.02e 0.0002e 8.01e 0.0001e ] constant fhf-b3

vct[ 1.01e 0.0972e 2.01e 0.0455e 3.02e 0.0442e 4.03e 0.0073e 5.03e 0.0017e 6.03e 0.0005e 7.04e 0.0008e 8.05e 0.0003e 9.05e 0.0001e ] constant fhf-c4

vct[ 1.01e 0.1452e 2.01e 0.0382e 3.02e 0.0285e 4.02e 0.0080e 5.02e 0.0019e 6.01e 0.0002e 7.03e 0.0003e 8.04e 0.0002e ] constant fhf-cs4

vct[ 1.01e 0.1930e 2.02e 0.0066e 3.03e 0.0070e 4.05e 0.0041e 5.05e 0.0016e 6.07e 0.0003e ] constant fhf-d4

vct[ 1.00e 0.1433e 2.01e 0.0414e 3.02e 0.0101e 4.03e 0.0020e 5.02e 0.0002e 6.03e 0.0003e 7.06e 0.0001e ] constant fhf-ds4

vct[ 1.00e 0.1373e 2.01e 0.0256e 3.01e 0.0164e 4.02e 0.0026e 5.02e 0.0014e 6.02e 0.0004e 7.03e 0.0002e ] constant fhf-e4

vct[ 1.01e 0.1930e 2.01e 0.0192e 3.02e 0.0124e 4.02e 0.0030e 5.03e 0.0013e 6.03e 0.0006e 7.03e 0.0002e ] constant fhf-f4

vct[ 1.01e 0.2352e 2.01e 0.0485e 3.02e 0.0135e 4.03e 0.0035e 5.03e 0.0010e 6.04e 0.0004e ] constant fhf-fs4

vct[ 1.01e 0.1991e 2.03e 0.0655e 3.04e 0.0065e 4.04e 0.0015e 5.06e 0.0006e 6.07e 0.0002e ] constant fhf-g4

vct[ 1.01e 0.2177e 2.02e 0.0422e 3.03e 0.0038e 4.05e 0.0014e 5.06e 0.0006e ] constant fhf-gs4

vct[ 1.01e 0.3779e 2.02e 0.0161e 3.03e 0.0026e 4.04e 0.0009e 5.05e 0.0005e ] constant fhf-a4

vct[ 1.00e 0.1879e 2.01e 0.0205e 3.02e 0.0006e 4.03e 0.0006e ] constant fhf-as4

vct[ 0.99e 0.2910e 1.99e 0.0363e 2.99e 0.0019e 3.99e 0.0001e 4.98e 0.0001e ] constant fhf-b4

vct[ 1.00e 0.0690e 2.01e 0.0086e 3.01e 0.0002e 4.00e 0.0002e ] constant fhf-c5

vct[ 1.01e 0.0872e 2.02e 0.0247e 3.03e 0.0008e 4.05e 0.0002e ] constant fhf-cs5

vct[ 1.01e 0.0213e 2.02e 0.0275e 3.03e 0.0031e 4.04e 0.0008e 5.05e 0.0002e 6.07e 0.0001e ] constant fhf-d5

vct[ 1.01e 0.1852e 2.01e 0.0224e 3.01e 0.0043e 4.02e 0.0006e 5.03e 0.0001e ] constant fhf-ds5

vct[ 1.01e 0.1063e 2.02e 0.0144e 3.03e 0.0018e 4.04e 0.0006e 5.05e 0.0001e ] constant fhf-e5

vct[ 1.02e 0.1058e 2.04e 0.0062e 3.06e 0.0023e 4.08e 0.0005e ] constant fhf-f5

vct[ 1.01e 0.1683e 2.03e 0.0099e 3.04e 0.0026e 4.05e 0.0004e 5.07e 0.0003e ] constant fhf-fs5

vct[ 1.01e 0.3271e 2.02e 0.0090e 3.03e 0.0022e 4.04e 0.0007e ] constant fhf-g5

\ **********************************************************
\ flute?
\ **********************************************************

vct[ 1.01e 0.0602e 2.02e 0.0954e 3.03e 0.0270e 4.03e 0.0199e 5.05e 0.0177e 6.06e 0.0104e 7.07e 0.0040e 8.08e 0.0040e 9.08e 0.0035e 10.10e 0.0017e 11.10e 0.0009e 12.12e 0.0004e 13.11e 0.0002e 14.13e 0.0006e 15.14e 0.0003e 17.15e 0.0002e 18.16e 0.0001e ] constant fl-c4

vct[ 1.01e 0.0672e 2.01e 0.0689e 3.02e 0.0604e 4.02e 0.0410e 5.02e 0.0130e 6.03e 0.0040e 7.03e 0.0210e 8.03e 0.0078e 9.04e 0.0010e 10.07e 0.0002e 11.05e 0.0005e 12.05e 0.0008e 13.05e 0.0004e 14.06e 0.0002e 15.07e 0.0001e 19.08e 0.0001e ] constant fl-cs4

vct[ 1.01e 0.0747e 2.01e 0.2106e 3.01e 0.0522e 4.02e 0.0208e 5.01e 0.0138e 6.02e 0.0024e 7.03e 0.0071e 8.03e 0.0038e 8.17e 0.0002e 8.74e 0.0001e 10.03e 0.0004e 11.04e 0.0014e 12.03e 0.0001e 13.06e 0.0002e 14.05e 0.0003e 15.06e 0.0001e 16.07e 0.0001e 17.06e 0.0002e 18.06e 0.0002e ] constant fl-d4

vct[ 1.00e 0.0256e 2.00e 0.1167e 3.00e 0.0241e 4.01e 0.0159e 5.01e 0.0200e 6.00e 0.0167e 7.01e 0.0069e 8.04e 0.0004e 9.00e 0.0009e 10.01e 0.0010e 11.00e 0.0004e 12.00e 0.0003e 13.00e 0.0002e 14.01e 0.0002e 16.00e 0.0002e 17.01e 0.0002e ] constant fl-ds4

vct[ 1.00e 0.0572e 2.01e 0.1769e 3.01e 0.0622e 4.00e 0.0323e 5.01e 0.0210e 6.01e 0.0163e 7.02e 0.0068e 8.01e 0.0007e 8.13e 0.0002e 8.39e 0.0001e 10.02e 0.0011e 11.02e 0.0004e 12.02e 0.0003e 15.03e 0.0002e 16.03e 0.0001e 17.04e 0.0001e 18.04e 0.0001e ] constant fl-e4

vct[ 1.01e 0.0438e 2.01e 0.0964e 3.01e 0.0569e 4.01e 0.0096e 5.01e 0.0164e 6.01e 0.0194e 7.02e 0.0024e 8.01e 0.0005e 9.03e 0.0007e 10.04e 0.0005e 12.05e 0.0002e 13.04e 0.0001e 14.05e 0.0002e ] constant fl-f4

vct[ 1.00e 0.0952e 2.00e 0.1432e 3.01e 0.0299e 4.01e 0.0371e 5.02e 0.0189e 6.02e 0.0092e 7.03e 0.0060e 8.03e 0.0003e 9.04e 0.0025e 10.04e 0.0006e 11.04e 0.0003e 13.05e 0.0002e 14.06e 0.0002e ] constant fl-fs4

vct[ 1.00e 0.2831e 2.01e 0.1781e 3.01e 0.0370e 4.02e 0.0191e 5.02e 0.0313e 6.02e 0.0048e 7.04e 0.0007e 8.03e 0.0022e 9.04e 0.0015e 9.13e 0.0001e 10.04e 0.0001e 11.05e 0.0002e 12.05e 0.0002e 14.07e 0.0001e 15.06e 0.0001e ] constant fl-g4

vct[ 1.00e 0.2598e 2.00e 0.2241e 3.01e 0.0407e 4.01e 0.0354e 5.01e 0.0398e 6.01e 0.0111e 7.03e 0.0007e 8.01e 0.0030e 9.01e 0.0018e 10.02e 0.0002e 12.02e 0.0004e 13.02e 0.0001e 14.03e 0.0002e 15.03e 0.0001e ] constant fl-gs4

vct[ 1.00e 0.2580e 2.01e 0.1605e 3.00e 0.0236e 4.01e 0.0281e 5.02e 0.0047e 6.02e 0.0024e 7.02e 0.0010e 8.02e 0.0027e 9.02e 0.0004e 10.03e 0.0002e 11.03e 0.0003e 12.04e 0.0001e 13.04e 0.0002e 14.04e 0.0002e ] constant fl-a4

vct[ 1.01e 0.1855e 2.01e 0.1041e 3.01e 0.0480e 4.02e 0.0416e 5.02e 0.0059e 6.02e 0.0016e 7.03e 0.0004e 8.03e 0.0016e 9.03e 0.0003e 10.04e 0.0004e 11.05e 0.0003e 16.07e 0.0002e ] constant fl-as4

vct[ 1.01e 0.0564e 2.01e 0.1996e 3.02e 0.0219e 4.02e 0.0108e 5.03e 0.0183e 6.04e 0.0005e 7.04e 0.0009e 8.05e 0.0014e 10.06e 0.0006e 11.07e 0.0003e ] constant fl-b4

vct[ 1.01e 0.0245e 2.02e 0.1674e 3.04e 0.0228e 4.05e 0.0229e 5.06e 0.0087e 6.09e 0.0004e 7.09e 0.0004e 8.10e 0.0003e 9.11e 0.0002e 10.14e 0.0002e 11.15e 0.0001e ] constant fl-c5

vct[ 1.00e 0.0885e 2.01e 0.0661e 3.01e 0.0281e 4.02e 0.0068e 5.02e 0.0038e 6.02e 0.0010e 7.02e 0.0008e 8.03e 0.0007e 9.03e 0.0005e 10.04e 0.0002e 11.04e 0.0003e ] constant fl-cs5

vct[ 1.01e 0.3830e 2.01e 0.1043e 3.01e 0.0372e 4.02e 0.0175e 5.03e 0.0035e 6.03e 0.0011e 7.04e 0.0010e 8.04e 0.0004e 9.04e 0.0002e 10.05e 0.0001e ] constant fl-d5

vct[ 1.00e 0.2294e 2.01e 0.0606e 3.01e 0.0238e 4.01e 0.0050e 5.01e 0.0041e 6.02e 0.0007e 7.02e 0.0007e 8.02e 0.0006e 10.03e 0.0002e 12.03e 0.0001e ] constant fl-ds5

vct[ 1.01e 0.3759e 2.03e 0.0529e 3.03e 0.0595e 4.05e 0.0010e 5.06e 0.0077e 6.07e 0.0008e 7.09e 0.0007e 8.09e 0.0005e 9.11e 0.0001e 10.12e 0.0002e 12.14e 0.0001e ] constant fl-e5

vct[ 1.01e 0.1982e 2.02e 0.0204e 3.02e 0.0554e 4.03e 0.0064e 5.04e 0.0040e 6.05e 0.0016e 7.06e 0.0007e 8.07e 0.0006e 9.07e 0.0001e 10.08e 0.0001e 12.10e 0.0001e ] constant fl-f5

vct[ 1.01e 0.3241e 2.02e 0.0548e 3.03e 0.0082e 4.04e 0.0022e 5.05e 0.0038e 6.06e 0.0004e 7.07e 0.0009e 8.09e 0.0001e 9.09e 0.0003e 10.10e 0.0001e ] constant fl-fs5

vct[ 1.01e 0.4049e 2.01e 0.0301e 3.02e 0.0229e 4.03e 0.0047e 5.04e 0.0029e 6.05e 0.0014e 7.05e 0.0009e 8.06e 0.0003e 9.07e 0.0002e 10.07e 0.0002e 11.09e 0.0001e 12.09e 0.0001e ] constant fl-g5

vct[ 1.00e 0.5433e 2.01e 0.0536e 3.01e 0.0411e 4.02e 0.0074e 5.02e 0.0014e 6.02e 0.0011e 7.03e 0.0004e 8.03e 0.0003e 9.04e 0.0001e ] constant fl-gs5

vct[ 1.01e 0.3063e 2.01e 0.0346e 3.02e 0.0102e 4.03e 0.0031e 5.03e 0.0007e 6.04e 0.0010e 7.03e 0.0003e 8.06e 0.0001e 9.05e 0.0002e 11.06e 0.0002e ] constant fl-a5

vct[ 1.01e 0.1962e 2.03e 0.0355e 3.04e 0.0128e 4.06e 0.0020e 5.07e 0.0021e 6.08e 0.0003e 7.10e 0.0003e 8.11e 0.0002e ] constant fl-as5

vct[ 1.01e 0.3829e 2.02e 0.0120e 3.03e 0.0037e 4.04e 0.0030e 5.05e 0.0016e 6.06e 0.0006e 7.07e 0.0002e 8.08e 0.0004e 9.09e 0.0001e ] constant fl-b5

vct[ 1.01e 0.3072e 2.02e 0.0248e 3.04e 0.0012e 4.05e 0.0006e 5.06e 0.0011e 6.07e 0.0009e 7.08e 0.0003e 8.10e 0.0001e 10.12e 0.0001e ] constant fl-c6

vct[ 1.01e 0.1262e 2.02e 0.0030e 3.03e 0.0012e 4.04e 0.0005e 5.06e 0.0010e 6.07e 0.0002e 7.08e 0.0004e 8.09e 0.0002e ] constant fl-cs6

vct[ 1.01e 0.3050e 2.03e 0.0071e 3.04e 0.0107e 4.06e 0.0005e 5.07e 0.0015e 6.08e 0.0002e 7.10e 0.0003e 8.11e 0.0002e 9.13e 0.0001e ] constant fl-d6

vct[ 1.02e 0.0954e 2.05e 0.0025e 3.06e 0.0047e 4.09e 0.0007e 5.11e 0.0017e 6.13e 0.0001e 7.15e 0.0002e ] constant fl-ds6

vct[ 1.02e 0.2864e 2.05e 0.0057e 3.08e 0.0023e 5.13e 0.0007e 6.16e 0.0001e 8.21e 0.0001e ] constant fl-e6

vct[ 1.03e 0.0675e 2.05e 0.0049e 3.08e 0.0024e 5.13e 0.0008e 6.16e 0.0002e 7.18e 0.0002e 8.21e 0.0001e ] constant fl-f6

vct[ 1.02e 0.2553e 2.05e 0.0044e 3.07e 0.0032e 5.12e 0.0007e 6.14e 0.0002e 8.19e 0.0001e ] constant fl-fs6

vct[ 1.02e 0.1190e 2.05e 0.0069e 3.07e 0.0046e 5.12e 0.0010e 6.14e 0.0001e 7.17e 0.0007e 7.26e 0.0001e ] constant fl-g6

vct[ 1.02e 0.3872e 2.05e 0.0093e 3.07e 0.0051e 5.12e 0.0008e 6.15e 0.0001e 7.17e 0.0002e 7.18e 0.0001e ] constant fl-gs6

vct[ 1.02e 0.2920e 2.04e 0.0122e 3.06e 0.0052e 4.08e 0.0007e 5.10e 0.0003e 6.31e 0.0002e 7.15e 0.0003e ] constant fl-a6

vct[ 1.02e 0.5687e 2.04e 0.0090e 3.06e 0.0075e 4.08e 0.0007e 5.10e 0.0010e 6.15e 0.0002e 6.21e 0.0002e 6.40e 0.0001e 6.47e 0.0001e ] constant fl-as6

vct[ 1.03e 0.2752e 2.06e 0.0061e 3.09e 0.0039e 5.14e 0.0002e 5.86e 0.0002e 6.18e 0.0001e 6.24e 0.0001e 6.45e 0.0001e ] constant fl-b6

vct[ 1.04e 0.2720e 2.07e 0.0046e 5.18e 0.0003e 5.40e 0.0002e 6.02e 0.0002e ] constant fl-c7

vct[ 1.03e 0.3752e 2.06e 0.0156e 5.16e 0.0007e 5.20e 0.0003e 5.40e 0.0001e 5.41e 0.0001e 5.57e 0.0001e ] constant fl-cs7

vct[ 1.04e 0.2861e 2.07e 0.0147e 5.18e 0.0012e 5.27e 0.0002e 5.30e 0.0001e ] constant fl-d7

\ **********************************************************
\ oboe?
\ **********************************************************

vct[ 1.00e 0.0504e 2.00e 0.0724e 2.99e 0.1036e 3.99e 0.1215e 4.99e 0.1360e 5.99e 0.0852e 6.98e 0.0593e 7.97e 0.0230e 8.98e 0.0077e 9.97e 0.0063e 10.97e 0.0016e 11.96e 0.0008e 12.97e 0.0017e 13.97e 0.0017e 14.96e 0.0020e 15.96e 0.0007e 16.96e 0.0006e 17.96e 0.0002e 21.95e 0.0001e 22.95e 0.0001e 23.94e 0.0002e 24.94e 0.0002e 25.94e 0.0001e ] constant ob-as3

vct[ 0.99e 0.0587e 1.99e 0.0820e 2.98e 0.0673e 3.98e 0.1069e 4.97e 0.1336e 5.97e 0.0948e 6.96e 0.0455e 7.96e 0.0070e 8.95e 0.0017e 9.95e 0.0023e 10.95e 0.0063e 11.93e 0.0031e 12.93e 0.0021e 13.92e 0.0009e 14.92e 0.0005e 15.92e 0.0003e 16.89e 0.0001e 21.88e 0.0001e 23.88e 0.0001e ] constant ob-b3

vct[ 1.00e 0.0784e 2.00e 0.0494e 2.99e 0.0668e 3.99e 0.0785e 4.99e 0.1406e 5.99e 0.0747e 6.99e 0.0460e 7.98e 0.0147e 8.98e 0.0115e 9.97e 0.0083e 10.98e 0.0058e 11.98e 0.0059e 12.97e 0.0027e 13.98e 0.0010e 14.96e 0.0006e 15.97e 0.0002e 16.96e 0.0001e 17.96e 0.0002e 19.95e 0.0001e 20.96e 0.0002e 21.95e 0.0001e ] constant ob-c4

vct[ 1.00e 0.0801e 2.00e 0.0526e 2.99e 0.0568e 3.99e 0.0713e 4.99e 0.1811e 5.99e 0.0721e 6.99e 0.0491e 7.98e 0.0201e 8.98e 0.0128e 9.98e 0.0132e 10.98e 0.0104e 11.98e 0.0081e 12.97e 0.0055e 13.97e 0.0026e 14.97e 0.0010e 15.97e 0.0003e 16.97e 0.0004e 17.96e 0.0003e 18.97e 0.0004e 19.95e 0.0006e 20.96e 0.0003e 21.96e 0.0002e ] constant ob-cs4

vct[ 1.00e 0.0775e 2.00e 0.0853e 3.01e 0.0538e 4.01e 0.0600e 5.00e 0.1853e 6.01e 0.0714e 7.01e 0.0247e 8.01e 0.0265e 9.01e 0.0028e 10.01e 0.0116e 11.02e 0.0078e 12.02e 0.0060e 13.01e 0.0036e 14.02e 0.0010e 15.03e 0.0005e 16.01e 0.0002e 17.02e 0.0002e 18.01e 0.0004e 19.02e 0.0004e 20.02e 0.0002e 21.02e 0.0001e ] constant ob-d4

vct[ 1.00e 0.0922e 1.99e 0.0922e 2.99e 0.0912e 3.99e 0.0337e 4.98e 0.1696e 5.97e 0.0481e 6.98e 0.0184e 7.97e 0.0104e 8.96e 0.0185e 9.96e 0.0147e 10.96e 0.0057e 11.95e 0.0039e 12.95e 0.0012e 13.94e 0.0006e 14.94e 0.0009e 15.94e 0.0005e 16.93e 0.0005e 17.93e 0.0003e 18.93e 0.0001e 19.92e 0.0001e ] constant ob-ds4

vct[ 1.00e 0.0970e 2.01e 0.0554e 3.01e 0.0624e 4.02e 0.1806e 5.02e 0.1392e 6.02e 0.0367e 7.03e 0.0165e 8.04e 0.0102e 9.04e 0.0159e 10.04e 0.0077e 11.04e 0.0092e 12.05e 0.0027e 13.06e 0.0004e 14.06e 0.0007e 15.06e 0.0003e 16.07e 0.0006e 17.07e 0.0003e 18.08e 0.0003e 19.08e 0.0001e 20.09e 0.0002e ] constant ob-e4

vct[ 1.00e 0.0988e 2.01e 0.0364e 3.00e 0.0573e 4.01e 0.2291e 5.01e 0.0802e 6.02e 0.0188e 7.02e 0.0160e 8.02e 0.0143e 9.02e 0.0152e 10.02e 0.0140e 11.03e 0.0054e 12.01e 0.0003e 13.03e 0.0012e 14.03e 0.0008e 15.04e 0.0008e 16.04e 0.0006e 17.04e 0.0006e 18.04e 0.0003e 19.05e 0.0001e ] constant ob-f4

vct[ 1.01e 0.0340e 2.01e 0.0618e 3.02e 0.0923e 4.03e 0.1479e 5.03e 0.1058e 6.04e 0.0281e 7.05e 0.0071e 8.05e 0.0157e 9.06e 0.0018e 10.07e 0.0014e 11.07e 0.0005e 12.08e 0.0013e 13.09e 0.0012e 14.10e 0.0005e 15.10e 0.0003e 16.11e 0.0005e 17.12e 0.0002e ] constant ob-fs4

vct[ 1.01e 0.0606e 2.01e 0.0774e 3.02e 0.0552e 4.03e 0.0700e 5.04e 0.0194e 6.04e 0.0066e 7.05e 0.0147e 8.06e 0.0134e 9.07e 0.0055e 10.08e 0.0035e 11.08e 0.0004e 12.10e 0.0004e 13.10e 0.0008e 14.11e 0.0011e 15.10e 0.0004e ] constant ob-g4

vct[ 1.01e 0.0573e 2.01e 0.0346e 3.03e 0.0608e 4.03e 0.0675e 5.04e 0.0643e 6.05e 0.0193e 7.06e 0.0125e 8.07e 0.0109e 9.07e 0.0010e 10.09e 0.0003e 11.09e 0.0016e 12.10e 0.0015e 13.11e 0.0006e 14.11e 0.0003e 15.13e 0.0002e 16.13e 0.0002e ] constant ob-gs4

vct[ 1.00e 0.0923e 2.00e 0.0358e 3.00e 0.0726e 4.00e 0.2111e 5.00e 0.0316e 5.99e 0.0016e 7.00e 0.0080e 8.00e 0.0075e 9.00e 0.0031e 10.01e 0.0007e 11.01e 0.0008e 12.00e 0.0005e 13.00e 0.0003e 14.01e 0.0005e 15.01e 0.0001e ] constant ob-a4

vct[ 1.00e 0.0753e 2.00e 0.0693e 3.00e 0.3731e 4.01e 0.0810e 5.01e 0.0245e 6.00e 0.0142e 7.00e 0.0061e 8.01e 0.0025e 9.01e 0.0004e 10.01e 0.0005e 11.01e 0.0005e 12.02e 0.0005e 13.02e 0.0003e ] constant ob-as4

vct[ 1.00e 0.0618e 2.01e 0.0377e 3.02e 0.0642e 4.02e 0.0401e 5.02e 0.0165e 6.03e 0.0176e 7.03e 0.0079e 8.04e 0.0016e 9.04e 0.0003e 10.06e 0.0003e 11.05e 0.0006e 12.06e 0.0003e 13.06e 0.0001e ] constant ob-b4

vct[ 1.01e 0.0484e 2.02e 0.0490e 3.02e 0.0364e 4.03e 0.0166e 5.03e 0.0172e 6.04e 0.0261e 7.05e 0.0120e 8.06e 0.0021e 9.06e 0.0035e 10.07e 0.0021e 11.08e 0.0008e 12.08e 0.0003e ] constant ob-c5

vct[ 1.01e 0.1071e 2.02e 0.0487e 3.03e 0.1175e 4.04e 0.0329e 5.05e 0.0231e 6.06e 0.0136e 7.07e 0.0047e 8.07e 0.0009e 9.09e 0.0011e 10.10e 0.0016e 11.10e 0.0010e 12.12e 0.0002e ] constant ob-cs5

vct[ 1.01e 0.1893e 2.01e 0.0986e 3.02e 0.1665e 4.02e 0.0326e 5.03e 0.0275e 6.04e 0.0155e 7.04e 0.0029e 8.05e 0.0013e 9.06e 0.0016e 10.07e 0.0010e 11.07e 0.0004e 12.08e 0.0001e ] constant ob-d5

vct[ 1.00e 0.2003e 2.00e 0.0265e 3.00e 0.1047e 4.00e 0.0138e 5.00e 0.0391e 6.00e 0.0094e 6.99e 0.0023e 8.00e 0.0018e 8.99e 0.0011e 9.99e 0.0006e 10.99e 0.0002e 11.99e 0.0001e ] constant ob-ds5

vct[ 1.00e 0.0906e 2.00e 0.4215e 3.00e 0.1046e 3.99e 0.0081e 4.99e 0.0118e 5.99e 0.0054e 6.99e 0.0005e 7.99e 0.0014e 8.99e 0.0005e 9.99e 0.0002e ] constant ob-e5

vct[ 1.00e 0.0657e 2.00e 0.4134e 2.99e 0.0463e 3.99e 0.0144e 4.99e 0.0277e 5.99e 0.0047e 6.98e 0.0005e 7.98e 0.0004e 8.98e 0.0003e ] constant ob-f5

vct[ 1.01e 0.0957e 2.03e 0.2943e 3.04e 0.0855e 4.06e 0.0568e 5.07e 0.0247e 6.08e 0.0013e 7.10e 0.0024e 8.12e 0.0011e 9.13e 0.0006e 10.15e 0.0002e 11.16e 0.0001e 12.17e 0.0001e ] constant ob-fs5

vct[ 1.01e 0.0975e 2.02e 0.1012e 3.04e 0.0543e 4.05e 0.0298e 5.06e 0.0083e 6.07e 0.0026e 7.08e 0.0017e 8.09e 0.0003e 9.11e 0.0001e ] constant ob-g5

vct[ 1.01e 0.0400e 2.01e 0.0481e 3.02e 0.0403e 4.02e 0.0169e 5.03e 0.0002e 6.04e 0.0030e 7.04e 0.0008e ] constant ob-gs5

vct[ 1.01e 0.0725e 2.02e 0.1474e 3.03e 0.0327e 4.04e 0.0281e 5.05e 0.0013e 6.06e 0.0028e 7.07e 0.0004e ] constant ob-a5

vct[ 1.00e 0.0837e 2.00e 0.1039e 3.00e 0.0366e 4.01e 0.0118e 5.01e 0.0021e 6.01e 0.0012e ] constant ob-as5

vct[ 1.02e 0.0812e 2.04e 0.0709e 3.06e 0.0658e 4.08e 0.0099e 5.10e 0.0069e 6.12e 0.0007e 7.14e 0.0001e 8.16e 0.0001e ] constant ob-b5

vct[ 1.01e 0.0799e 2.02e 0.0161e 3.02e 0.0476e 4.03e 0.0084e 5.04e 0.0029e 6.05e 0.0002e ] constant ob-c6

vct[ 1.01e 0.2331e 2.02e 0.1151e 3.03e 0.0163e 4.04e 0.0013e 5.05e 0.0004e 6.07e 0.0003e ] constant ob-cs6

vct[ 1.02e 0.2469e 2.03e 0.0288e 3.05e 0.0144e 4.06e 0.0012e 5.08e 0.0008e ] constant ob-d6

vct[ 1.00e 0.2770e 2.00e 0.0028e 3.00e 0.0095e 4.00e 0.0042e 5.00e 0.0006e 5.99e 0.0002e ] constant ob-ds6

vct[ 1.00e 0.3019e 2.01e 0.0125e 3.01e 0.0049e 4.02e 0.0008e 5.02e 0.0001e 6.02e 0.0001e ] constant ob-e6

vct[ 1.01e 0.0898e 2.01e 0.0089e 3.02e 0.0067e 4.02e 0.0010e 5.03e 0.0002e 6.03e 0.0001e ] constant ob-f6

vct[ 1.01e 0.1330e 2.03e 0.0090e 3.05e 0.0031e 4.06e 0.0001e ] constant ob-fs6

vct[ 1.00e 0.1046e 1.99e 0.0228e 2.99e 0.0004e 3.98e 0.0001e ] constant ob-g6

\ **********************************************************
\ piano
\ **********************************************************

vct[ 1.97e 0.0326e 2.99e 0.0086e 3.95e 0.0163e 4.97e 0.0178e 5.98e 0.0177e 6.95e 0.0315e 8.02e 0.0001e 8.94e 0.0076e 9.96e 0.0134e 10.99e 0.0284e 11.98e 0.0229e 13.02e 0.0229e 13.89e 0.0010e 15.06e 0.0090e 16.00e 0.0003e 17.08e 0.0078e 18.16e 0.0064e 19.18e 0.0129e 20.21e 0.0085e 21.27e 0.0225e 22.32e 0.0061e 23.41e 0.0102e 24.48e 0.0005e 25.56e 0.0016e 26.64e 0.0018e 27.70e 0.0113e 28.80e 0.0111e 29.91e 0.0158e 31.06e 0.0093e 32.17e 0.0017e 33.32e 0.0002e 34.42e 0.0018e 35.59e 0.0027e 36.74e 0.0055e 37.90e 0.0037e 39.06e 0.0064e 40.25e 0.0033e 41.47e 0.0014e 42.53e 0.0004e 43.89e 0.0010e 45.12e 0.0039e 46.33e 0.0039e 47.64e 0.0009e 48.88e 0.0016e 50.13e 0.0006e 51.37e 0.0010e 52.70e 0.0002e 54.00e 0.0004e 55.30e 0.0008e 56.60e 0.0025e 57.96e 0.0010e 59.30e 0.0012e 60.67e 0.0011e 61.99e 0.0003e 62.86e 0.0001e 64.36e 0.0005e 64.86e 0.0001e 66.26e 0.0004e 67.70e 0.0006e 68.94e 0.0002e 70.10e 0.0001e 70.58e 0.0002e 72.01e 0.0007e 73.53e 0.0006e 75.00e 0.0002e 77.03e 0.0005e 78.00e 0.0002e 79.57e 0.0006e 81.16e 0.0005e 82.70e 0.0005e 84.22e 0.0003e 85.41e 0.0002e 87.46e 0.0001e 90.30e 0.0001e 94.02e 0.0001e 95.26e 0.0002e 109.39e 0.0003e ] constant p-c1

vct[ 1.98e 0.0194e 2.99e 0.0210e 3.97e 0.0276e 4.96e 0.0297e 5.96e 0.0158e 6.99e 0.0207e 8.01e 0.0009e 9.00e 0.0101e 10.00e 0.0297e 11.01e 0.0289e 12.02e 0.0211e 13.04e 0.0127e 14.07e 0.0061e 15.08e 0.0174e 16.13e 0.0009e 17.12e 0.0093e 18.16e 0.0117e 19.21e 0.0122e 20.29e 0.0108e 21.30e 0.0077e 22.38e 0.0132e 23.46e 0.0073e 24.14e 0.0002e 25.58e 0.0026e 26.69e 0.0035e 27.77e 0.0053e 28.88e 0.0024e 30.08e 0.0027e 31.13e 0.0075e 32.24e 0.0027e 33.36e 0.0004e 34.42e 0.0004e 35.64e 0.0019e 36.78e 0.0037e 38.10e 0.0009e 39.11e 0.0027e 40.32e 0.0010e 41.51e 0.0013e 42.66e 0.0019e 43.87e 0.0007e 45.13e 0.0017e 46.35e 0.0019e 47.65e 0.0021e 48.89e 0.0014e 50.18e 0.0023e 51.42e 0.0015e 52.73e 0.0002e 54.00e 0.0005e 55.34e 0.0006e 56.60e 0.0010e 57.96e 0.0016e 58.86e 0.0005e 59.30e 0.0004e 60.75e 0.0005e 62.22e 0.0003e 63.55e 0.0005e 64.82e 0.0003e 66.24e 0.0003e 67.63e 0.0011e 69.09e 0.0007e 70.52e 0.0004e 72.00e 0.0005e 73.50e 0.0008e 74.95e 0.0003e 77.13e 0.0013e 78.02e 0.0002e 79.48e 0.0004e 82.59e 0.0004e 84.10e 0.0003e ] constant p-cs1

vct[ 2.00e 0.0313e 2.99e 0.0109e 4.00e 0.0215e 5.00e 0.0242e 5.98e 0.0355e 7.01e 0.0132e 8.01e 0.0009e 9.01e 0.0071e 10.00e 0.0258e 11.03e 0.0221e 12.02e 0.0056e 13.06e 0.0196e 14.05e 0.0160e 15.11e 0.0107e 16.11e 0.0003e 17.14e 0.0111e 18.21e 0.0085e 19.23e 0.0010e 20.28e 0.0048e 21.31e 0.0128e 22.36e 0.0051e 23.41e 0.0041e 24.05e 0.0006e 25.54e 0.0019e 26.62e 0.0028e 27.72e 0.0034e 28.82e 0.0062e 29.89e 0.0039e 30.98e 0.0058e 32.08e 0.0011e 33.21e 0.0002e 34.37e 0.0008e 35.46e 0.0018e 36.62e 0.0036e 37.77e 0.0018e 38.92e 0.0042e 40.07e 0.0037e 41.23e 0.0011e 42.67e 0.0003e 43.65e 0.0018e 44.68e 0.0025e 45.99e 0.0044e 47.21e 0.0051e 48.40e 0.0044e 49.67e 0.0005e 50.88e 0.0019e 52.15e 0.0003e 53.42e 0.0008e 54.69e 0.0010e 55.98e 0.0005e 57.26e 0.0013e 58.53e 0.0027e 59.83e 0.0011e 61.21e 0.0027e 62.54e 0.0003e 63.78e 0.0003e 65.20e 0.0001e 66.60e 0.0006e 67.98e 0.0008e 69.37e 0.0019e 70.73e 0.0007e 72.14e 0.0004e 73.62e 0.0002e 74.40e 0.0003e 76.52e 0.0006e 77.97e 0.0002e 79.49e 0.0004e 80.77e 0.0003e 81.00e 0.0001e 82.47e 0.0005e 83.97e 0.0001e 87.27e 0.0002e ] constant p-d1

vct[ 2.00e 0.0257e 2.99e 0.0142e 3.97e 0.0202e 4.95e 0.0148e 5.95e 0.0420e 6.95e 0.0037e 7.94e 0.0004e 8.94e 0.0172e 9.95e 0.0191e 10.96e 0.0115e 11.97e 0.0059e 12.98e 0.0140e 14.00e 0.0178e 15.03e 0.0121e 16.09e 0.0002e 17.07e 0.0066e 18.08e 0.0033e 19.15e 0.0022e 20.18e 0.0057e 21.22e 0.0077e 22.29e 0.0037e 23.33e 0.0066e 24.97e 0.0002e 25.49e 0.0019e 26.55e 0.0042e 27.61e 0.0043e 28.73e 0.0038e 29.81e 0.0084e 30.91e 0.0040e 32.03e 0.0025e 33.14e 0.0005e 34.26e 0.0003e 35.38e 0.0019e 36.56e 0.0037e 37.68e 0.0049e 38.86e 0.0036e 40.11e 0.0011e 41.28e 0.0008e 42.50e 0.0004e 43.60e 0.0002e 44.74e 0.0022e 45.99e 0.0050e 47.20e 0.0009e 48.40e 0.0036e 49.68e 0.0004e 50.92e 0.0009e 52.17e 0.0005e 53.46e 0.0007e 54.76e 0.0006e 56.06e 0.0005e 57.34e 0.0011e 58.67e 0.0005e 59.95e 0.0015e 61.37e 0.0008e 62.72e 0.0004e 65.42e 0.0009e 66.96e 0.0003e 68.18e 0.0003e 69.78e 0.0003e 71.21e 0.0004e 72.45e 0.0002e 74.22e 0.0003e 75.44e 0.0001e 76.53e 0.0003e 78.31e 0.0004e 79.83e 0.0003e 80.16e 0.0001e 81.33e 0.0003e 82.44e 0.0001e 83.17e 0.0002e 84.81e 0.0003e 85.97e 0.0003e 89.08e 0.0001e 90.70e 0.0002e 92.30e 0.0002e 95.59e 0.0002e 97.22e 0.0003e 98.86e 0.0001e 108.37e 0.0001e 125.54e 0.0001e ] constant p-ds1

vct[ 1.99e 0.0650e 3.03e 0.0040e 4.03e 0.0059e 5.02e 0.0090e 5.97e 0.0227e 6.98e 0.0050e 8.04e 0.0020e 9.00e 0.0082e 9.96e 0.0078e 11.01e 0.0056e 12.01e 0.0095e 13.02e 0.0050e 14.04e 0.0093e 15.08e 0.0064e 16.14e 0.0017e 17.06e 0.0020e 18.10e 0.0025e 19.14e 0.0023e 20.18e 0.0015e 21.24e 0.0032e 22.29e 0.0029e 23.32e 0.0014e 24.37e 0.0005e 25.43e 0.0030e 26.50e 0.0022e 27.60e 0.0027e 28.64e 0.0024e 29.76e 0.0035e 30.81e 0.0136e 31.96e 0.0025e 33.02e 0.0003e 34.13e 0.0005e 35.25e 0.0007e 36.40e 0.0014e 37.51e 0.0020e 38.64e 0.0012e 39.80e 0.0019e 40.97e 0.0004e 42.09e 0.0003e 43.24e 0.0003e 44.48e 0.0002e 45.65e 0.0024e 46.86e 0.0005e 48.07e 0.0013e 49.27e 0.0008e 50.49e 0.0006e 52.95e 0.0001e 54.23e 0.0005e 55.45e 0.0004e 56.73e 0.0001e 58.03e 0.0003e 59.29e 0.0002e 60.59e 0.0003e 62.04e 0.0002e 65.89e 0.0002e 67.23e 0.0002e 68.61e 0.0002e 69.97e 0.0004e 71.36e 0.0005e 85.42e 0.0001e ] constant p-e1

vct[ 1.98e 0.0256e 2.96e 0.0158e 3.95e 0.0310e 4.94e 0.0411e 5.95e 0.0238e 6.94e 0.0152e 7.93e 0.0011e 8.95e 0.0185e 9.92e 0.0166e 10.93e 0.0306e 11.94e 0.0258e 12.96e 0.0202e 13.97e 0.0403e 14.95e 0.0228e 15.93e 0.0005e 17.01e 0.0072e 18.02e 0.0034e 19.06e 0.0028e 20.08e 0.0124e 21.13e 0.0137e 22.16e 0.0102e 23.19e 0.0058e 23.90e 0.0013e 25.30e 0.0039e 26.36e 0.0039e 27.41e 0.0025e 28.47e 0.0071e 29.64e 0.0031e 30.60e 0.0027e 31.71e 0.0021e 32.84e 0.0003e 33.82e 0.0002e 35.07e 0.0019e 36.09e 0.0054e 37.20e 0.0038e 38.33e 0.0024e 39.47e 0.0055e 40.55e 0.0016e 41.77e 0.0006e 42.95e 0.0002e 43.27e 0.0018e 44.03e 0.0006e 45.25e 0.0019e 46.36e 0.0033e 47.50e 0.0024e 48.87e 0.0012e 50.03e 0.0016e 51.09e 0.0004e 53.52e 0.0017e 54.74e 0.0012e 56.17e 0.0003e 57.40e 0.0011e 58.42e 0.0020e 59.70e 0.0007e 61.29e 0.0008e 62.56e 0.0003e 63.48e 0.0002e 64.83e 0.0002e 66.12e 0.0012e 67.46e 0.0017e 68.81e 0.0003e 69.13e 0.0003e 70.53e 0.0002e 71.84e 0.0001e 73.28e 0.0002e 75.52e 0.0010e 76.96e 0.0005e 77.93e 0.0003e 78.32e 0.0003e 79.73e 0.0003e 81.69e 0.0002e 82.52e 0.0001e 84.01e 0.0001e 84.61e 0.0002e 86.88e 0.0001e 88.36e 0.0002e 89.85e 0.0002e 91.35e 0.0003e 92.86e 0.0002e 93.40e 0.0001e 105.28e 0.0002e 106.22e 0.0002e 107.45e 0.0001e 108.70e 0.0003e 122.08e 0.0002e ] constant p-f1

vct[ 1.97e 0.0264e 2.97e 0.0211e 3.98e 0.0234e 4.98e 0.0307e 5.96e 0.0085e 6.94e 0.0140e 7.93e 0.0005e 8.96e 0.0112e 9.96e 0.0209e 10.98e 0.0194e 11.98e 0.0154e 12.99e 0.0274e 13.99e 0.0127e 15.01e 0.0101e 15.99e 0.0002e 17.04e 0.0011e 18.08e 0.0032e 19.14e 0.0028e 20.12e 0.0054e 21.20e 0.0053e 22.13e 0.0028e 23.22e 0.0030e 24.32e 0.0006e 25.24e 0.0004e 26.43e 0.0028e 27.53e 0.0048e 28.52e 0.0039e 29.54e 0.0047e 30.73e 0.0044e 31.82e 0.0007e 32.94e 0.0008e 34.04e 0.0012e 35.13e 0.0018e 36.29e 0.0007e 37.35e 0.0075e 38.51e 0.0045e 39.66e 0.0014e 40.90e 0.0004e 41.90e 0.0002e 43.08e 0.0002e 44.24e 0.0017e 45.36e 0.0013e 46.68e 0.0020e 47.79e 0.0015e 48.98e 0.0010e 50.21e 0.0012e 51.34e 0.0001e 53.82e 0.0003e 55.09e 0.0004e 56.23e 0.0005e 57.53e 0.0004e 58.79e 0.0005e 59.30e 0.0002e 60.03e 0.0002e 61.40e 0.0003e 62.84e 0.0001e 66.64e 0.0001e 67.97e 0.0001e 69.33e 0.0001e 70.68e 0.0001e 73.57e 0.0002e 75.76e 0.0002e 76.45e 0.0001e 79.27e 0.0001e 80.44e 0.0002e 81.87e 0.0002e ] constant p-fs1

vct[ 2.00e 0.0311e 2.99e 0.0086e 3.99e 0.0266e 4.97e 0.0123e 5.98e 0.0235e 6.97e 0.0161e 7.97e 0.0008e 8.96e 0.0088e 9.96e 0.0621e 10.99e 0.0080e 11.99e 0.0034e 12.99e 0.0300e 14.03e 0.0228e 15.04e 0.0105e 16.03e 0.0004e 17.06e 0.0036e 18.09e 0.0094e 18.95e 0.0009e 20.17e 0.0071e 21.21e 0.0161e 22.25e 0.0106e 23.28e 0.0104e 24.33e 0.0008e 25.38e 0.0030e 26.46e 0.0035e 27.50e 0.0026e 28.59e 0.0028e 29.66e 0.0128e 30.75e 0.0139e 31.81e 0.0038e 32.93e 0.0006e 34.04e 0.0004e 35.16e 0.0005e 36.25e 0.0023e 37.35e 0.0012e 38.46e 0.0021e 39.59e 0.0035e 40.71e 0.0006e 41.86e 0.0007e 42.42e 0.0001e 43.46e 0.0003e 44.17e 0.0032e 45.29e 0.0013e 46.57e 0.0004e 47.72e 0.0011e 48.79e 0.0005e 50.11e 0.0005e 51.29e 0.0003e 52.47e 0.0002e 53.68e 0.0004e 55.02e 0.0005e 56.18e 0.0003e 57.41e 0.0003e 58.75e 0.0007e 59.33e 0.0009e 60.00e 0.0004e 61.34e 0.0001e 64.97e 0.0003e 65.20e 0.0002e 66.48e 0.0002e 67.83e 0.0002e 68.90e 0.0003e 70.25e 0.0003e 71.59e 0.0002e 73.68e 0.0001e 75.92e 0.0001e 77.08e 0.0002e 78.45e 0.0002e 81.56e 0.0002e 82.99e 0.0001e 88.39e 0.0001e ] constant p-g1

vct[ 0.97e 0.0059e 1.98e 0.0212e 2.99e 0.0153e 3.99e 0.0227e 4.96e 0.0215e 5.97e 0.0153e 6.98e 0.0085e 7.98e 0.0007e 8.97e 0.0179e 9.98e 0.0512e 10.98e 0.0322e 12.00e 0.0098e 13.02e 0.0186e 14.00e 0.0099e 15.05e 0.0109e 15.88e 0.0011e 17.07e 0.0076e 18.11e 0.0071e 19.12e 0.0045e 20.16e 0.0038e 21.23e 0.0213e 22.27e 0.0332e 23.34e 0.0082e 24.34e 0.0014e 25.42e 0.0024e 26.47e 0.0012e 27.54e 0.0014e 28.60e 0.0024e 29.72e 0.0026e 30.10e 0.0008e 31.91e 0.0021e 32.13e 0.0011e 33.02e 0.0007e 34.09e 0.0014e 35.17e 0.0007e 36.27e 0.0024e 37.39e 0.0029e 38.58e 0.0014e 39.65e 0.0017e 40.95e 0.0012e 41.97e 0.0004e 42.43e 0.0002e 43.49e 0.0001e 44.31e 0.0012e 45.42e 0.0031e 46.62e 0.0017e 47.82e 0.0013e 49.14e 0.0013e 50.18e 0.0010e 51.54e 0.0003e 53.90e 0.0006e 55.06e 0.0010e 56.31e 0.0003e 57.63e 0.0001e 59.02e 0.0003e 60.09e 0.0004e 60.35e 0.0004e 61.62e 0.0009e 63.97e 0.0001e 65.19e 0.0001e 65.54e 0.0002e 66.92e 0.0002e 67.94e 0.0002e 69.17e 0.0003e 69.60e 0.0004e 70.88e 0.0002e 72.24e 0.0002e 76.12e 0.0001e 78.94e 0.0001e 81.75e 0.0001e 82.06e 0.0001e 83.53e 0.0001e 90.29e 0.0002e 91.75e 0.0001e 92.09e 0.0002e 93.28e 0.0001e 97.07e 0.0001e ] constant p-gs1

vct[ 1.98e 0.0159e 2.98e 0.1008e 3.98e 0.0365e 4.98e 0.0133e 5.97e 0.0101e 6.97e 0.0115e 7.97e 0.0007e 8.99e 0.0349e 10.01e 0.0342e 11.01e 0.0236e 12.00e 0.0041e 13.02e 0.0114e 14.05e 0.0137e 15.06e 0.0100e 16.05e 0.0007e 17.04e 0.0009e 18.12e 0.0077e 19.15e 0.0023e 20.12e 0.0017e 21.24e 0.0113e 22.26e 0.0126e 23.30e 0.0093e 24.36e 0.0007e 25.43e 0.0007e 26.47e 0.0009e 27.55e 0.0013e 28.59e 0.0025e 29.61e 0.0010e 30.77e 0.0021e 31.86e 0.0023e 32.96e 0.0003e 34.03e 0.0007e 35.06e 0.0005e 36.20e 0.0006e 37.34e 0.0006e 38.36e 0.0009e 39.60e 0.0016e 40.69e 0.0005e 41.77e 0.0002e 42.92e 0.0002e 44.02e 0.0003e 45.24e 0.0006e 46.33e 0.0004e 47.50e 0.0007e 48.71e 0.0007e 49.87e 0.0002e 51.27e 0.0002e 53.42e 0.0003e 55.88e 0.0003e 57.10e 0.0004e 58.34e 0.0002e 59.86e 0.0003e 61.13e 0.0003e 67.18e 0.0001e 68.50e 0.0001e 71.17e 0.0001e 83.91e 0.0001e 90.55e 0.0001e ] constant p-a1

vct[ 0.98e 0.0099e 2.00e 0.0181e 2.99e 0.0353e 3.98e 0.0285e 4.97e 0.0514e 5.96e 0.0402e 6.96e 0.0015e 7.98e 0.0012e 8.98e 0.0175e 9.98e 0.0264e 10.98e 0.0392e 11.98e 0.0236e 13.00e 0.0153e 14.04e 0.0049e 15.00e 0.0089e 16.01e 0.0001e 17.03e 0.0106e 18.03e 0.0028e 19.05e 0.0024e 20.08e 0.0040e 21.11e 0.0103e 22.12e 0.0104e 23.20e 0.0017e 24.19e 0.0008e 25.20e 0.0007e 26.24e 0.0011e 27.36e 0.0009e 27.97e 0.0030e 29.40e 0.0044e 30.37e 0.0019e 31.59e 0.0017e 32.65e 0.0008e 33.59e 0.0005e 34.79e 0.0009e 35.75e 0.0027e 36.88e 0.0035e 37.93e 0.0039e 39.00e 0.0031e 40.08e 0.0025e 41.16e 0.0010e 43.25e 0.0004e 44.52e 0.0012e 45.62e 0.0023e 45.85e 0.0012e 47.00e 0.0006e 47.87e 0.0008e 48.99e 0.0003e 50.48e 0.0003e 51.62e 0.0001e 52.43e 0.0001e 53.56e 0.0002e 54.76e 0.0002e 56.04e 0.0002e 56.68e 0.0006e 57.10e 0.0003e 58.28e 0.0005e 59.47e 0.0003e 59.96e 0.0002e 60.67e 0.0001e 63.08e 0.0002e 64.29e 0.0002e 66.72e 0.0001e 67.97e 0.0001e 68.65e 0.0001e 70.43e 0.0001e 79.38e 0.0001e 80.39e 0.0001e 82.39e 0.0001e ] constant p-as1

vct[ 1.00e 0.0765e 1.99e 0.0151e 2.99e 0.0500e 3.99e 0.0197e 5.00e 0.0260e 6.00e 0.0145e 6.98e 0.0128e 7.97e 0.0004e 8.98e 0.0158e 9.99e 0.0265e 11.02e 0.0290e 12.02e 0.0053e 13.03e 0.0242e 14.03e 0.0103e 15.06e 0.0054e 16.04e 0.0006e 17.08e 0.0008e 18.10e 0.0058e 19.16e 0.0011e 20.16e 0.0055e 21.18e 0.0040e 22.20e 0.0019e 23.22e 0.0014e 24.05e 0.0005e 25.31e 0.0019e 26.38e 0.0018e 27.44e 0.0022e 28.45e 0.0024e 29.57e 0.0073e 30.58e 0.0032e 31.66e 0.0071e 32.73e 0.0015e 33.85e 0.0005e 34.96e 0.0003e 36.00e 0.0020e 37.11e 0.0018e 38.18e 0.0055e 39.23e 0.0006e 40.33e 0.0004e 41.52e 0.0003e 43.41e 0.0028e 45.05e 0.0003e 45.99e 0.0002e 47.07e 0.0003e 48.52e 0.0002e 49.48e 0.0003e 50.63e 0.0003e 51.81e 0.0002e 54.05e 0.0002e 55.24e 0.0001e 56.62e 0.0001e 57.81e 0.0004e 59.16e 0.0013e 60.23e 0.0003e 66.44e 0.0001e 68.99e 0.0004e 75.49e 0.0001e 87.56e 0.0004e ] constant p-b1

vct[ 0.98e 0.0629e 1.99e 0.0232e 2.98e 0.0217e 4.00e 0.0396e 4.98e 0.0171e 5.97e 0.0098e 6.99e 0.0167e 7.99e 0.0003e 8.98e 0.0192e 9.98e 0.0266e 10.99e 0.0256e 12.01e 0.0061e 13.02e 0.0135e 14.02e 0.0062e 15.05e 0.0158e 16.06e 0.0018e 17.08e 0.0101e 18.09e 0.0053e 19.11e 0.0074e 20.13e 0.0020e 21.17e 0.0052e 22.22e 0.0077e 23.24e 0.0035e 24.00e 0.0009e 25.32e 0.0016e 26.40e 0.0022e 27.43e 0.0005e 28.55e 0.0026e 29.60e 0.0026e 30.65e 0.0010e 31.67e 0.0019e 32.77e 0.0008e 33.81e 0.0003e 34.91e 0.0003e 36.01e 0.0005e 37.11e 0.0010e 38.20e 0.0014e 39.29e 0.0039e 40.43e 0.0012e 41.50e 0.0006e 43.38e 0.0017e 43.75e 0.0002e 44.94e 0.0005e 46.13e 0.0002e 47.11e 0.0003e 48.28e 0.0005e 48.42e 0.0005e 49.44e 0.0003e 50.76e 0.0004e 51.93e 0.0002e 54.15e 0.0003e 55.31e 0.0005e 55.50e 0.0003e 56.98e 0.0003e 57.90e 0.0004e 60.33e 0.0002e 61.39e 0.0001e 61.59e 0.0001e 65.09e 0.0002e 66.34e 0.0001e 68.85e 0.0001e 70.42e 0.0002e 71.72e 0.0001e 73.05e 0.0003e 79.65e 0.0001e 85.28e 0.0002e 93.52e 0.0001e ] constant p-c2

vct[ 1.02e 0.0185e 1.99e 0.0525e 2.98e 0.0613e 3.99e 0.0415e 4.98e 0.0109e 5.97e 0.0248e 6.99e 0.0102e 7.98e 0.0005e 8.98e 0.0124e 9.99e 0.0103e 10.99e 0.0124e 12.00e 0.0016e 13.01e 0.0029e 14.03e 0.0211e 15.04e 0.0128e 16.07e 0.0021e 17.09e 0.0009e 18.09e 0.0043e 19.14e 0.0022e 20.13e 0.0016e 21.20e 0.0045e 22.21e 0.0088e 23.26e 0.0046e 24.29e 0.0013e 25.35e 0.0009e 26.39e 0.0028e 27.49e 0.0009e 28.51e 0.0006e 29.58e 0.0012e 30.70e 0.0010e 31.74e 0.0019e 32.75e 0.0002e 33.85e 0.0001e 34.95e 0.0005e 36.02e 0.0003e 37.16e 0.0009e 38.25e 0.0018e 39.35e 0.0008e 40.54e 0.0004e 41.61e 0.0002e 43.40e 0.0004e 43.74e 0.0003e 45.05e 0.0001e 46.11e 0.0003e 47.40e 0.0002e 48.36e 0.0004e 49.55e 0.0004e 50.72e 0.0002e 52.00e 0.0001e 55.58e 0.0002e 57.02e 0.0001e 57.98e 0.0002e 59.13e 0.0003e 61.56e 0.0001e 66.56e 0.0001e 87.65e 0.0002e ] constant p-cs2

vct[ 1.00e 0.0473e 1.99e 0.0506e 2.99e 0.0982e 3.99e 0.0654e 5.00e 0.0196e 5.99e 0.0094e 6.99e 0.0118e 7.93e 0.0001e 8.99e 0.0057e 10.01e 0.0285e 11.01e 0.0142e 12.03e 0.0032e 13.03e 0.0056e 14.06e 0.0064e 15.06e 0.0059e 16.11e 0.0005e 17.09e 0.0033e 18.14e 0.0027e 19.15e 0.0014e 20.17e 0.0010e 21.21e 0.0059e 22.26e 0.0043e 23.31e 0.0031e 24.31e 0.0018e 25.33e 0.0009e 26.41e 0.0005e 27.47e 0.0015e 28.53e 0.0015e 29.58e 0.0041e 30.65e 0.0025e 31.73e 0.0011e 32.83e 0.0010e 34.98e 0.0003e 36.07e 0.0009e 37.23e 0.0001e 38.26e 0.0020e 39.41e 0.0014e 40.53e 0.0005e 41.40e 0.0003e 42.80e 0.0002e 43.48e 0.0028e 43.93e 0.0001e 45.03e 0.0003e 46.18e 0.0007e 47.41e 0.0001e 48.57e 0.0002e 49.67e 0.0001e 50.83e 0.0002e 54.39e 0.0001e 55.58e 0.0002e 57.97e 0.0005e 58.11e 0.0002e 59.21e 0.0001e 60.42e 0.0002e 61.66e 0.0001e ] constant p-d2

vct[ 1.00e 0.0503e 2.00e 0.0963e 2.99e 0.1304e 3.99e 0.0218e 4.98e 0.0041e 5.98e 0.0292e 6.98e 0.0482e 7.99e 0.0005e 8.99e 0.0280e 10.00e 0.0237e 11.00e 0.0152e 12.02e 0.0036e 12.95e 0.0022e 14.06e 0.0111e 15.07e 0.0196e 16.08e 0.0016e 17.11e 0.0044e 18.13e 0.0073e 19.17e 0.0055e 20.19e 0.0028e 21.20e 0.0012e 22.27e 0.0068e 23.30e 0.0036e 24.35e 0.0012e 25.35e 0.0002e 26.46e 0.0005e 27.47e 0.0005e 28.59e 0.0009e 29.65e 0.0021e 30.70e 0.0020e 31.78e 0.0012e 32.89e 0.0010e 35.06e 0.0005e 36.16e 0.0008e 37.27e 0.0010e 38.36e 0.0010e 39.47e 0.0014e 40.58e 0.0004e 41.43e 0.0007e 41.82e 0.0003e 43.48e 0.0008e 44.53e 0.0001e 45.25e 0.0003e 46.43e 0.0002e 47.46e 0.0002e 48.76e 0.0005e 49.95e 0.0004e 50.96e 0.0002e 51.12e 0.0002e 52.33e 0.0001e 54.75e 0.0001e 55.75e 0.0002e 56.90e 0.0002e 58.17e 0.0002e 59.40e 0.0004e 60.62e 0.0002e 65.65e 0.0001e 66.91e 0.0002e 69.91e 0.0001e 71.25e 0.0002e ] constant p-ds2

vct[ 1.00e 0.1243e 1.98e 0.1611e 3.00e 0.0698e 3.98e 0.0390e 5.00e 0.0138e 5.99e 0.0154e 7.01e 0.0287e 8.01e 0.0014e 9.01e 0.0049e 10.00e 0.0144e 11.01e 0.0055e 12.05e 0.0052e 13.01e 0.0011e 14.05e 0.0118e 15.07e 0.0154e 16.12e 0.0028e 17.14e 0.0061e 18.25e 0.0007e 19.22e 0.0020e 20.24e 0.0011e 21.27e 0.0029e 22.30e 0.0046e 23.34e 0.0049e 24.35e 0.0004e 25.45e 0.0003e 26.47e 0.0007e 27.59e 0.0008e 28.16e 0.0009e 29.12e 0.0002e 29.81e 0.0006e 30.81e 0.0009e 31.95e 0.0004e 33.00e 0.0011e 34.12e 0.0005e 35.18e 0.0003e 36.30e 0.0008e 37.38e 0.0003e 38.55e 0.0003e 39.64e 0.0006e 40.77e 0.0007e 41.52e 0.0006e 41.89e 0.0006e 43.04e 0.0011e 43.60e 0.0009e 44.31e 0.0002e 45.68e 0.0002e 46.56e 0.0003e 47.60e 0.0001e 48.83e 0.0006e 50.01e 0.0003e 51.27e 0.0003e 56.04e 0.0005e 57.21e 0.0003e 58.56e 0.0004e 59.83e 0.0003e 61.05e 0.0001e 62.20e 0.0001e 67.37e 0.0002e 76.53e 0.0001e ] constant p-e2

vct[ 0.99e 0.0222e 1.99e 0.0678e 2.99e 0.0683e 4.00e 0.0191e 5.00e 0.0119e 6.01e 0.0232e 6.98e 0.0336e 7.99e 0.0082e 9.01e 0.0201e 10.01e 0.0189e 11.01e 0.0041e 12.01e 0.0053e 13.05e 0.0154e 14.04e 0.0159e 15.06e 0.0092e 16.11e 0.0038e 17.12e 0.0014e 18.15e 0.0091e 19.16e 0.0006e 20.30e 0.0012e 21.25e 0.0061e 22.28e 0.0099e 23.34e 0.0028e 24.38e 0.0012e 25.43e 0.0016e 26.49e 0.0048e 27.55e 0.0025e 28.62e 0.0015e 29.71e 0.0032e 30.78e 0.0077e 31.88e 0.0011e 32.97e 0.0007e 34.08e 0.0006e 35.16e 0.0008e 36.28e 0.0004e 37.41e 0.0006e 38.54e 0.0005e 39.62e 0.0002e 40.80e 0.0003e 41.93e 0.0001e 43.06e 0.0002e 44.21e 0.0003e 45.38e 0.0002e 46.54e 0.0007e 47.78e 0.0003e 48.95e 0.0004e 50.10e 0.0003e 51.37e 0.0002e 53.79e 0.0003e 56.20e 0.0001e 58.71e 0.0002e 66.47e 0.0003e ] constant p-f2

vct[ 1.01e 0.0241e 1.99e 0.1011e 2.98e 0.0938e 3.98e 0.0081e 4.99e 0.0062e 5.99e 0.0291e 6.99e 0.0676e 7.59e 0.0004e 8.98e 0.0127e 9.99e 0.0112e 10.99e 0.0142e 12.00e 0.0029e 13.02e 0.0071e 14.02e 0.0184e 15.03e 0.0064e 16.07e 0.0010e 17.09e 0.0011e 18.11e 0.0010e 19.15e 0.0060e 20.19e 0.0019e 21.24e 0.0025e 22.29e 0.0013e 23.31e 0.0050e 25.41e 0.0030e 26.50e 0.0018e 27.53e 0.0006e 28.63e 0.0012e 29.66e 0.0013e 30.77e 0.0020e 31.84e 0.0006e 34.04e 0.0001e 35.14e 0.0001e 36.32e 0.0004e 37.41e 0.0007e 38.53e 0.0007e 39.67e 0.0009e 40.85e 0.0003e 45.49e 0.0002e 46.65e 0.0001e 47.81e 0.0004e 49.01e 0.0002e 53.91e 0.0002e 55.14e 0.0002e 57.69e 0.0002e ] constant p-fs2

vct[ 1.00e 0.0326e 2.00e 0.1066e 2.99e 0.1015e 4.00e 0.0210e 4.97e 0.0170e 5.99e 0.0813e 6.98e 0.0820e 7.96e 0.0011e 8.99e 0.0248e 10.03e 0.0107e 11.01e 0.0126e 12.01e 0.0027e 13.01e 0.0233e 14.04e 0.0151e 15.05e 0.0071e 16.04e 0.0002e 17.10e 0.0061e 18.12e 0.0059e 19.15e 0.0087e 20.23e 0.0005e 21.25e 0.0040e 22.30e 0.0032e 23.35e 0.0004e 24.40e 0.0001e 25.45e 0.0030e 26.54e 0.0022e 27.60e 0.0003e 28.70e 0.0009e 29.80e 0.0029e 30.85e 0.0006e 31.97e 0.0006e 34.19e 0.0004e 35.30e 0.0003e 36.43e 0.0007e 37.56e 0.0005e 38.68e 0.0019e 39.88e 0.0013e 41.00e 0.0003e 43.35e 0.0003e 44.51e 0.0002e 45.68e 0.0006e 46.93e 0.0010e 48.11e 0.0006e 49.29e 0.0003e 55.58e 0.0002e ] constant p-g2

vct[ 0.98e 0.0113e 1.99e 0.0967e 3.00e 0.0719e 3.98e 0.0345e 4.98e 0.0121e 6.00e 0.0621e 7.00e 0.0137e 7.98e 0.0006e 9.01e 0.0314e 10.01e 0.0171e 11.02e 0.0060e 12.03e 0.0024e 13.05e 0.0077e 14.07e 0.0040e 15.12e 0.0032e 16.13e 0.0004e 17.15e 0.0011e 18.20e 0.0028e 19.18e 0.0003e 20.26e 0.0003e 21.31e 0.0025e 22.35e 0.0021e 23.39e 0.0005e 25.55e 0.0002e 26.62e 0.0014e 27.70e 0.0003e 28.78e 0.0005e 29.90e 0.0030e 31.01e 0.0011e 32.12e 0.0005e 34.31e 0.0001e 35.50e 0.0002e 36.62e 0.0002e 37.76e 0.0005e 38.85e 0.0002e 40.09e 0.0004e 43.60e 0.0001e 44.73e 0.0002e 46.02e 0.0002e 47.25e 0.0004e 48.44e 0.0004e ] constant p-gs2

vct[ 0.99e 0.0156e 1.98e 0.0846e 2.98e 0.0178e 3.98e 0.0367e 4.98e 0.0448e 5.98e 0.0113e 6.99e 0.0189e 8.00e 0.0011e 9.01e 0.0247e 10.02e 0.0089e 11.01e 0.0184e 12.03e 0.0105e 13.00e 0.0039e 14.07e 0.0116e 15.09e 0.0078e 16.13e 0.0008e 17.14e 0.0064e 18.19e 0.0029e 19.22e 0.0028e 20.25e 0.0017e 21.32e 0.0043e 22.37e 0.0055e 23.42e 0.0034e 24.48e 0.0004e 25.54e 0.0002e 26.61e 0.0017e 27.70e 0.0011e 28.80e 0.0002e 29.89e 0.0019e 30.97e 0.0028e 32.09e 0.0007e 34.30e 0.0002e 35.44e 0.0003e 36.55e 0.0001e 37.69e 0.0004e 38.93e 0.0002e 40.05e 0.0005e 41.20e 0.0005e 42.37e 0.0002e 43.54e 0.0003e 44.73e 0.0001e 45.95e 0.0002e 47.16e 0.0001e 48.43e 0.0005e 49.65e 0.0004e 55.90e 0.0002e 59.81e 0.0004e ] constant p-a2

vct[ 1.01e 0.0280e 2.00e 0.0708e 2.99e 0.0182e 3.99e 0.0248e 4.98e 0.0245e 5.98e 0.0279e 6.98e 0.0437e 7.99e 0.0065e 8.99e 0.0299e 10.00e 0.0073e 10.99e 0.0011e 12.03e 0.0122e 13.03e 0.0028e 14.08e 0.0044e 15.11e 0.0097e 16.15e 0.0010e 17.17e 0.0025e 18.19e 0.0017e 19.24e 0.0008e 20.28e 0.0040e 21.32e 0.0024e 22.38e 0.0008e 23.46e 0.0032e 24.52e 0.0010e 25.59e 0.0008e 26.68e 0.0009e 27.76e 0.0012e 28.88e 0.0003e 29.95e 0.0005e 31.05e 0.0017e 32.14e 0.0002e 33.29e 0.0003e 37.88e 0.0002e 39.03e 0.0002e 40.19e 0.0004e 41.37e 0.0003e 43.74e 0.0002e 46.20e 0.0001e 48.68e 0.0001e 49.93e 0.0001e 51.19e 0.0002e ] constant p-as2

vct[ 1.00e 0.0225e 1.99e 0.0921e 2.98e 0.0933e 3.99e 0.0365e 4.99e 0.0100e 5.98e 0.0213e 6.98e 0.0049e 7.98e 0.0041e 8.98e 0.0090e 9.99e 0.0068e 11.01e 0.0040e 12.03e 0.0086e 13.02e 0.0015e 14.04e 0.0071e 15.09e 0.0082e 16.14e 0.0011e 17.15e 0.0014e 18.18e 0.0010e 19.26e 0.0013e 20.26e 0.0005e 21.33e 0.0006e 22.36e 0.0011e 23.46e 0.0016e 24.52e 0.0004e 25.59e 0.0002e 26.70e 0.0006e 27.78e 0.0007e 28.87e 0.0002e 30.03e 0.0008e 31.14e 0.0010e 32.24e 0.0006e 33.37e 0.0002e 35.67e 0.0003e 37.99e 0.0004e 39.17e 0.0004e 40.35e 0.0005e 41.53e 0.0001e 46.42e 0.0001e ] constant p-b2

vct[ 1.00e 0.0465e 1.99e 0.0976e 2.98e 0.0678e 4.00e 0.0727e 4.99e 0.0305e 5.98e 0.0210e 6.98e 0.0227e 8.00e 0.0085e 9.01e 0.0183e 10.02e 0.0258e 11.05e 0.0003e 12.06e 0.0061e 13.05e 0.0021e 14.10e 0.0089e 15.12e 0.0077e 16.16e 0.0016e 17.21e 0.0061e 18.23e 0.0011e 19.29e 0.0031e 20.36e 0.0031e 21.41e 0.0007e 22.48e 0.0013e 23.55e 0.0020e 24.64e 0.0004e 25.74e 0.0005e 26.81e 0.0006e 27.95e 0.0006e 29.03e 0.0001e 30.22e 0.0010e 31.30e 0.0004e 32.48e 0.0001e 33.60e 0.0002e 38.30e 0.0003e ] constant p-c3

vct[ 1.00e 0.0674e 1.99e 0.0841e 2.98e 0.0920e 3.99e 0.0328e 4.99e 0.0368e 5.98e 0.0206e 6.99e 0.0246e 8.01e 0.0048e 9.01e 0.0218e 10.03e 0.0155e 11.05e 0.0048e 12.06e 0.0077e 13.00e 0.0020e 14.10e 0.0083e 15.15e 0.0084e 16.18e 0.0015e 17.22e 0.0039e 18.27e 0.0032e 19.34e 0.0026e 20.40e 0.0012e 21.47e 0.0009e 22.54e 0.0008e 23.62e 0.0016e 24.71e 0.0005e 25.82e 0.0004e 26.91e 0.0002e 28.03e 0.0008e 29.17e 0.0002e 30.32e 0.0028e 31.45e 0.0004e 32.61e 0.0005e 33.77e 0.0001e 36.14e 0.0003e 37.32e 0.0002e 38.54e 0.0005e 39.75e 0.0002e 42.23e 0.0002e 48.65e 0.0001e ] constant p-cs3

vct[ 1.01e 0.0423e 1.99e 0.0240e 2.98e 0.0517e 4.00e 0.0493e 5.00e 0.0324e 6.00e 0.0094e 6.99e 0.0449e 7.99e 0.0050e 9.00e 0.0197e 10.03e 0.0132e 11.03e 0.0009e 12.07e 0.0017e 13.08e 0.0023e 14.12e 0.0094e 15.16e 0.0071e 16.21e 0.0020e 17.25e 0.0005e 18.30e 0.0027e 19.04e 0.0004e 20.43e 0.0022e 21.51e 0.0002e 22.59e 0.0006e 23.72e 0.0018e 24.80e 0.0002e 25.88e 0.0002e 27.03e 0.0002e 28.09e 0.0006e 29.31e 0.0002e 30.46e 0.0004e 31.61e 0.0007e 32.78e 0.0005e 33.95e 0.0001e 36.34e 0.0002e 37.56e 0.0001e 38.80e 0.0001e 40.02e 0.0001e 44.14e 0.0001e ] constant p-d3

vct[ 1.00e 0.0669e 1.99e 0.0909e 2.99e 0.0410e 3.98e 0.0292e 4.98e 0.0259e 5.98e 0.0148e 6.98e 0.0319e 7.99e 0.0076e 9.01e 0.0056e 10.02e 0.0206e 11.04e 0.0032e 12.05e 0.0085e 13.08e 0.0040e 14.12e 0.0037e 15.16e 0.0030e 16.20e 0.0013e 17.24e 0.0021e 18.30e 0.0010e 19.36e 0.0015e 20.44e 0.0013e 21.50e 0.0009e 22.60e 0.0015e 23.69e 0.0014e 24.80e 0.0006e 25.87e 0.0002e 27.02e 0.0006e 28.12e 0.0002e 29.28e 0.0003e 30.43e 0.0002e 31.59e 0.0007e 32.79e 0.0001e 35.14e 0.0001e 37.57e 0.0001e 40.03e 0.0002e 41.28e 0.0004e 44.10e 0.0001e ] constant p-ds3

vct[ 0.99e 0.0421e 1.99e 0.1541e 2.98e 0.0596e 3.98e 0.0309e 4.98e 0.0301e 5.99e 0.0103e 7.00e 0.0240e 8.01e 0.0073e 9.01e 0.0222e 10.04e 0.0140e 11.05e 0.0033e 12.08e 0.0045e 13.13e 0.0009e 14.13e 0.0015e 15.21e 0.0026e 16.24e 0.0003e 17.30e 0.0004e 18.35e 0.0010e 19.39e 0.0003e 20.50e 0.0015e 21.57e 0.0003e 22.68e 0.0011e 23.80e 0.0005e 24.90e 0.0008e 26.02e 0.0002e 27.16e 0.0001e 28.30e 0.0006e 29.48e 0.0002e 31.81e 0.0005e 33.00e 0.0003e 34.21e 0.0001e 37.89e 0.0001e ] constant p-e3

vct[ 0.99e 0.0389e 2.00e 0.2095e 3.00e 0.0835e 3.99e 0.0289e 5.00e 0.0578e 5.99e 0.0363e 7.01e 0.0387e 8.01e 0.0056e 9.04e 0.0173e 10.05e 0.0175e 11.08e 0.0053e 12.10e 0.0056e 13.15e 0.0064e 14.19e 0.0036e 15.22e 0.0019e 16.29e 0.0010e 17.36e 0.0017e 18.43e 0.0018e 19.51e 0.0004e 20.60e 0.0011e 21.70e 0.0003e 22.82e 0.0003e 23.95e 0.0001e 25.05e 0.0004e 26.17e 0.0001e 28.50e 0.0003e 29.68e 0.0001e 32.07e 0.0003e 33.28e 0.0004e 34.52e 0.0001e ] constant p-f3

vct[ 1.00e 0.1238e 1.99e 0.2270e 3.00e 0.0102e 3.99e 0.0181e 4.98e 0.0415e 6.00e 0.0165e 7.01e 0.0314e 8.02e 0.0148e 9.04e 0.0203e 10.05e 0.0088e 11.07e 0.0062e 12.11e 0.0070e 13.14e 0.0054e 14.19e 0.0028e 15.24e 0.0044e 16.30e 0.0029e 17.38e 0.0009e 18.45e 0.0026e 19.56e 0.0003e 20.65e 0.0025e 21.74e 0.0014e 22.87e 0.0013e 23.99e 0.0007e 25.15e 0.0002e 27.46e 0.0004e 28.39e 0.0006e 28.65e 0.0004e 29.85e 0.0001e 31.05e 0.0002e 32.27e 0.0003e 33.52e 0.0002e 34.76e 0.0003e ] constant p-fs3

vct[ 1.00e 0.1054e 2.00e 0.2598e 2.99e 0.0369e 3.98e 0.0523e 4.99e 0.0020e 5.99e 0.0051e 7.00e 0.0268e 8.01e 0.0027e 9.04e 0.0029e 10.05e 0.0081e 11.08e 0.0047e 12.12e 0.0051e 13.16e 0.0091e 14.19e 0.0015e 15.27e 0.0030e 16.34e 0.0017e 17.42e 0.0006e 18.51e 0.0003e 19.61e 0.0007e 20.72e 0.0003e 21.84e 0.0001e 22.99e 0.0010e 24.13e 0.0001e 28.44e 0.0001e 30.09e 0.0001e ] constant p-g3

vct[ 0.99e 0.0919e 2.00e 0.0418e 2.99e 0.0498e 3.99e 0.0135e 4.99e 0.0026e 6.00e 0.0155e 7.01e 0.0340e 8.02e 0.0033e 9.04e 0.0218e 10.08e 0.0084e 11.11e 0.0057e 12.15e 0.0051e 13.21e 0.0043e 14.25e 0.0015e 15.31e 0.0023e 16.40e 0.0008e 17.48e 0.0004e 18.59e 0.0016e 19.71e 0.0010e 20.84e 0.0018e 21.98e 0.0002e 23.11e 0.0013e 24.26e 0.0003e 26.67e 0.0002e 29.12e 0.0002e 30.37e 0.0002e 31.62e 0.0003e 32.92e 0.0001e ] constant p-gs3

vct[ 0.99e 0.1174e 1.99e 0.1126e 2.99e 0.0370e 3.99e 0.0159e 5.01e 0.0472e 6.01e 0.0091e 7.03e 0.0211e 8.05e 0.0015e 9.07e 0.0098e 10.11e 0.0038e 11.15e 0.0042e 12.20e 0.0018e 13.24e 0.0041e 14.32e 0.0033e 15.41e 0.0052e 16.49e 0.0001e 17.61e 0.0004e 18.71e 0.0004e 19.84e 0.0004e 20.99e 0.0002e 22.14e 0.0006e 23.31e 0.0006e 24.50e 0.0004e 25.70e 0.0002e 28.09e 0.0002e 28.66e 0.0002e 32.00e 0.0001e ] constant p-a3

vct[ 1.00e 0.1085e 2.00e 0.1400e 2.99e 0.0173e 3.99e 0.0229e 5.00e 0.0272e 6.02e 0.0077e 7.03e 0.0069e 8.04e 0.0017e 9.08e 0.0045e 10.10e 0.0030e 11.15e 0.0040e 12.20e 0.0007e 13.25e 0.0019e 14.32e 0.0008e 15.42e 0.0024e 16.50e 0.0002e 17.59e 0.0005e 18.71e 0.0003e 19.83e 0.0002e 20.98e 0.0005e 23.29e 0.0008e ] constant p-as3

vct[ 1.00e 0.0985e 2.00e 0.1440e 2.99e 0.0364e 3.99e 0.0425e 5.00e 0.0190e 6.01e 0.0089e 7.03e 0.0278e 8.04e 0.0006e 9.07e 0.0083e 10.10e 0.0021e 11.14e 0.0050e 12.18e 0.0005e 13.26e 0.0036e 14.33e 0.0005e 15.41e 0.0026e 17.62e 0.0004e 18.75e 0.0004e 19.89e 0.0003e 21.04e 0.0012e 22.21e 0.0002e 23.38e 0.0004e 27.04e 0.0001e ] constant p-b3

vct[ 0.99e 0.1273e 2.00e 0.1311e 2.99e 0.0120e 4.00e 0.0099e 5.00e 0.0235e 6.02e 0.0068e 7.03e 0.0162e 8.06e 0.0009e 9.08e 0.0083e 10.12e 0.0014e 11.17e 0.0050e 12.24e 0.0010e 13.29e 0.0013e 14.39e 0.0022e 15.48e 0.0011e 16.59e 0.0002e 17.70e 0.0003e 18.84e 0.0010e 20.00e 0.0003e 21.17e 0.0003e 23.56e 0.0004e 28.79e 0.0003e ] constant p-c4

vct[ 1.00e 0.1018e 2.00e 0.1486e 3.00e 0.0165e 4.00e 0.0186e 5.01e 0.0194e 6.02e 0.0045e 7.04e 0.0083e 8.06e 0.0012e 9.10e 0.0066e 10.15e 0.0009e 11.19e 0.0008e 12.26e 0.0011e 13.34e 0.0028e 14.45e 0.0006e 15.53e 0.0009e 16.66e 0.0002e 17.79e 0.0006e 18.94e 0.0005e 20.11e 0.0003e 21.29e 0.0005e 22.49e 0.0003e 23.73e 0.0005e 26.22e 0.0001e 27.52e 0.0001e 28.88e 0.0002e ] constant p-cs4

vct[ 1.00e 0.1889e 1.99e 0.1822e 3.00e 0.0363e 4.00e 0.0047e 5.01e 0.0202e 6.03e 0.0053e 7.05e 0.0114e 8.01e 0.0002e 9.13e 0.0048e 10.17e 0.0010e 11.23e 0.0033e 12.30e 0.0010e 13.38e 0.0006e 14.50e 0.0002e 15.62e 0.0010e 20.27e 0.0001e 21.47e 0.0001e ] constant p-d4

vct[ 1.00e 0.0522e 1.99e 0.0763e 2.99e 0.0404e 4.00e 0.0139e 5.01e 0.0185e 6.01e 0.0021e 7.06e 0.0045e 8.09e 0.0002e 9.11e 0.0003e 10.17e 0.0006e 11.25e 0.0004e 12.32e 0.0005e 13.40e 0.0003e 14.53e 0.0003e 15.65e 0.0007e 16.80e 0.0001e 17.95e 0.0002e 19.14e 0.0006e 20.34e 0.0002e 21.56e 0.0003e ] constant p-ds4

vct[ 0.99e 0.1821e 1.99e 0.0773e 3.00e 0.0125e 4.01e 0.0065e 5.01e 0.0202e 6.03e 0.0071e 7.05e 0.0090e 8.08e 0.0006e 9.13e 0.0008e 10.18e 0.0013e 11.25e 0.0010e 12.33e 0.0012e 13.42e 0.0006e 14.54e 0.0005e 15.65e 0.0004e 17.97e 0.0002e 19.15e 0.0001e ] constant p-e4

vct[ 1.00e 0.1868e 2.00e 0.0951e 3.00e 0.0147e 4.01e 0.0134e 5.02e 0.0184e 6.04e 0.0132e 7.06e 0.0011e 8.11e 0.0008e 9.15e 0.0010e 10.22e 0.0012e 11.30e 0.0011e 12.40e 0.0003e 13.11e 0.0004e 13.49e 0.0002e 14.62e 0.0003e 15.77e 0.0001e ] constant p-f4

vct[ 1.00e 0.1933e 2.00e 0.0714e 3.00e 0.0373e 4.00e 0.0108e 5.02e 0.0094e 6.02e 0.0010e 7.07e 0.0022e 8.11e 0.0002e 9.16e 0.0065e 10.23e 0.0015e 11.31e 0.0023e 12.40e 0.0003e 13.53e 0.0014e 14.66e 0.0002e 15.81e 0.0011e 18.20e 0.0002e 19.41e 0.0001e ] constant p-fs4

vct[ 0.99e 0.2113e 1.99e 0.0877e 3.00e 0.0492e 4.01e 0.0094e 5.02e 0.0144e 6.04e 0.0103e 7.07e 0.0117e 8.12e 0.0006e 9.19e 0.0019e 10.25e 0.0007e 11.35e 0.0017e 12.45e 0.0010e 13.58e 0.0003e 14.74e 0.0003e 15.91e 0.0003e 19.57e 0.0002e ] constant p-g4

vct[ 0.99e 0.2455e 1.99e 0.0161e 3.00e 0.0215e 4.01e 0.0036e 5.03e 0.0049e 6.04e 0.0012e 7.09e 0.0036e 8.14e 0.0011e 9.21e 0.0009e 10.30e 0.0001e 11.40e 0.0012e 12.50e 0.0001e 13.66e 0.0005e 14.84e 0.0001e ] constant p-gs4

vct[ 1.00e 0.1132e 2.00e 0.0252e 3.00e 0.0292e 4.01e 0.0136e 5.03e 0.0045e 6.06e 0.0022e 7.11e 0.0101e 8.17e 0.0004e 9.23e 0.0010e 10.33e 0.0012e 11.44e 0.0013e 12.58e 0.0011e 13.75e 0.0002e 14.93e 0.0005e 16.14e 0.0002e ] constant p-a4

vct[ 1.00e 0.1655e 2.00e 0.0445e 3.00e 0.0120e 4.00e 0.0038e 5.02e 0.0015e 6.07e 0.0038e 7.11e 0.0003e 8.19e 0.0002e 9.25e 0.0010e 10.36e 0.0011e 11.48e 0.0005e 12.63e 0.0002e 13.79e 0.0003e 16.24e 0.0002e ] constant p-as4

vct[ 0.99e 0.3637e 1.99e 0.0259e 3.01e 0.0038e 4.01e 0.0057e 5.03e 0.0040e 6.07e 0.0067e 7.12e 0.0014e 8.19e 0.0004e 9.27e 0.0003e 10.38e 0.0002e 12.67e 0.0001e ] constant p-b4

vct[ 1.00e 0.1193e 2.00e 0.0230e 3.00e 0.0104e 4.01e 0.0084e 5.04e 0.0047e 6.08e 0.0035e 7.13e 0.0041e 8.20e 0.0002e 9.29e 0.0005e 10.40e 0.0005e 11.53e 0.0003e 12.70e 0.0002e 13.91e 0.0002e ] constant p-c5

vct[ 1.00e 0.0752e 2.00e 0.0497e 3.00e 0.0074e 4.02e 0.0076e 5.05e 0.0053e 6.09e 0.0043e 7.15e 0.0024e 8.22e 0.0001e 9.32e 0.0006e 10.45e 0.0002e 11.58e 0.0001e 12.78e 0.0001e 15.22e 0.0001e ] constant p-cs5

vct[ 1.00e 0.2388e 2.00e 0.0629e 3.01e 0.0159e 4.04e 0.0063e 5.07e 0.0051e 6.12e 0.0045e 7.19e 0.0026e 8.29e 0.0015e 9.43e 0.0001e 11.75e 0.0002e ] constant p-d5

vct[ 1.00e 0.1919e 2.01e 0.0116e 3.01e 0.0031e 4.03e 0.0090e 5.07e 0.0061e 6.13e 0.0036e 7.19e 0.0013e 8.30e 0.0016e 9.13e 0.0001e 10.59e 0.0002e 11.78e 0.0002e ] constant p-ds5

vct[ 1.00e 0.1296e 2.00e 0.0135e 3.01e 0.0041e 4.04e 0.0045e 5.09e 0.0028e 6.14e 0.0046e 7.23e 0.0007e 8.32e 0.0007e 9.50e 0.0001e ] constant p-e5

vct[ 1.00e 0.0692e 2.00e 0.0209e 3.02e 0.0025e 4.05e 0.0030e 5.09e 0.0047e 6.17e 0.0022e 7.25e 0.0015e 8.36e 0.0015e 9.53e 0.0010e 10.69e 0.0001e 13.40e 0.0001e ] constant p-f5

vct[ 1.00e 0.1715e 2.00e 0.0142e 3.01e 0.0024e 4.03e 0.0015e 5.07e 0.0017e 6.13e 0.0018e 7.22e 0.0009e 8.33e 0.0014e 9.51e 0.0007e 10.69e 0.0002e ] constant p-fs5

vct[ 1.00e 0.1555e 2.01e 0.0148e 3.02e 0.0007e 4.06e 0.0006e 5.10e 0.0005e 6.16e 0.0008e 7.26e 0.0009e 8.39e 0.0008e 9.58e 0.0002e ] constant p-g5

vct[ 1.00e 0.1357e 2.00e 0.0116e 3.02e 0.0026e 4.04e 0.0009e 5.09e 0.0004e 6.17e 0.0005e 7.27e 0.0002e 8.40e 0.0001e ] constant p-gs5

vct[ 1.00e 0.2185e 2.01e 0.0087e 3.03e 0.0018e 4.06e 0.0025e 5.11e 0.0020e 6.20e 0.0012e 7.32e 0.0005e 8.46e 0.0001e 9.66e 0.0003e ] constant p-a5

vct[ 1.00e 0.2735e 2.00e 0.0038e 3.02e 0.0008e 4.06e 0.0012e 5.12e 0.0008e 6.22e 0.0011e 7.35e 0.0003e 8.50e 0.0002e ] constant p-as5

vct[ 1.00e 0.1441e 1.99e 0.0062e 3.01e 0.0023e 4.05e 0.0011e 5.11e 0.0012e 6.20e 0.0003e 7.33e 0.0004e 8.50e 0.0001e ] constant p-b5

vct[ 1.00e 0.0726e 2.01e 0.0293e 3.03e 0.0022e 5.14e 0.0005e 6.26e 0.0011e 7.41e 0.0002e 8.63e 0.0002e ] constant p-c6

vct[ 1.00e 0.0516e 2.00e 0.0104e 3.02e 0.0029e 5.15e 0.0002e 6.27e 0.0001e ] constant p-cs6

vct[ 1.00e 0.0329e 2.00e 0.0033e 3.03e 0.0013e 4.10e 0.0005e 5.19e 0.0004e 6.32e 0.0002e ] constant p-d6

vct[ 1.00e 0.0179e 1.99e 0.0012e 3.04e 0.0005e 4.10e 0.0017e 5.20e 0.0005e 6.35e 0.0001e ] constant p-ds6

vct[ 1.00e 0.0334e 2.01e 0.0033e 3.04e 0.0011e 4.13e 0.0003e 5.22e 0.0003e ] constant p-e6

vct[ 0.99e 0.0161e 2.01e 0.0100e 3.04e 0.0020e 4.13e 0.0003e ] constant p-f6

vct[ 1.00e 0.0475e 1.99e 0.0045e 3.03e 0.0035e 4.12e 0.0011e ] constant p-fs6

vct[ 1.00e 0.0593e 2.00e 0.0014e 4.17e 0.0002e ] constant p-g6

vct[ 1.00e 0.0249e 2.01e 0.0016e ] constant p-gs6

vct[ 1.00e 0.0242e 2.00e 0.0038e 4.19e 0.0002e ] constant p-a6

vct[ 1.00e 0.0170e 2.02e 0.0030e ] constant p-as6

vct[ 1.00e 0.0381e 2.00e 0.0017e 3.09e 0.0002e ] constant p-b6

vct[ 1.00e 0.0141e 2.03e 0.0005e 3.11e 0.0003e 4.26e 0.0001e ] constant p-c7

vct[ 1.00e 0.0122e 2.03e 0.0024e ] constant p-cs7

vct[ 1.00e 0.0107e 2.07e 0.0007e 3.12e 0.0004e ] constant p-d7

vct[ 1.00e 0.0250e 2.02e 0.0026e 3.15e 0.0002e ] constant p-ds7

vct[ 1.01e 0.0092e ] constant p-e7

vct[ 1.01e 0.0102e 2.09e 0.0005e ] constant p-f7

vct[ 1.00e 0.0080e 2.00e 0.0005e 3.19e 0.0001e ] constant p-fs7

vct[ 1.01e 0.0298e 2.01e 0.0005e ] constant p-g7

\ **********************************************************
\ sax
\ **********************************************************

vct[ 1.01e 0.0565e 2.01e 0.0374e 3.00e 0.0377e 4.00e 0.0498e 5.02e 0.0907e 6.02e 0.0361e 7.02e 0.0250e 8.01e 0.0036e 9.02e 0.0181e 10.03e 0.0319e 11.03e 0.0075e 12.03e 0.0068e 13.03e 0.0037e 14.03e 0.0015e 15.05e 0.0021e 16.04e 0.0034e 17.04e 0.0076e 18.04e 0.0101e 19.06e 0.0056e 20.06e 0.0051e 21.05e 0.0046e 22.05e 0.0029e 23.05e 0.0015e 24.07e 0.0026e 25.07e 0.0023e 26.06e 0.0025e 27.06e 0.0010e 28.08e 0.0011e 29.08e 0.0005e 30.07e 0.0017e 31.07e 0.0025e 32.07e 0.0032e 33.09e 0.0026e 34.09e 0.0023e 35.09e 0.0038e 36.09e 0.0023e 37.09e 0.0018e 38.11e 0.0023e 39.11e 0.0017e 40.10e 0.0015e 41.10e 0.0010e 42.10e 0.0008e 43.13e 0.0004e 45.13e 0.0001e 46.11e 0.0005e 47.12e 0.0004e 48.12e 0.0006e 49.11e 0.0004e 50.12e 0.0008e 51.13e 0.0006e 52.14e 0.0009e 53.13e 0.0006e 54.13e 0.0008e 55.13e 0.0007e 56.15e 0.0005e 57.16e 0.0002e 58.13e 0.0001e 59.17e 0.0001e 61.15e 0.0001e 62.15e 0.0002e 63.16e 0.0002e 65.17e 0.0004e 66.18e 0.0005e 67.18e 0.0003e 68.17e 0.0002e 69.17e 0.0005e 70.18e 0.0003e 71.18e 0.0002e 72.18e 0.0005e 73.18e 0.0003e 74.18e 0.0003e 75.20e 0.0003e 76.19e 0.0003e 77.19e 0.0002e 78.19e 0.0004e 80.20e 0.0002e 81.19e 0.0001e 82.21e 0.0001e 89.23e 0.0002e 90.23e 0.0002e 91.23e 0.0003e 92.22e 0.0001e ] constant sax-cs3

vct[ 1.00e 0.0423e 1.99e 0.0487e 2.98e 0.0259e 3.99e 0.0630e 4.99e 0.1026e 5.97e 0.0532e 6.97e 0.0259e 7.98e 0.0110e 8.97e 0.0076e 9.96e 0.0123e 10.97e 0.0162e 11.96e 0.0128e 12.95e 0.0178e 13.94e 0.0114e 14.96e 0.0134e 15.95e 0.0186e 16.94e 0.0180e 17.93e 0.0087e 18.94e 0.0084e 19.93e 0.0064e 20.92e 0.0033e 21.93e 0.0025e 22.93e 0.0041e 23.91e 0.0041e 24.90e 0.0034e 25.91e 0.0012e 26.90e 0.0013e 27.90e 0.0020e 28.89e 0.0036e 29.90e 0.0054e 30.89e 0.0054e 31.88e 0.0038e 32.89e 0.0059e 33.89e 0.0037e 34.88e 0.0024e 35.86e 0.0024e 36.87e 0.0023e 37.87e 0.0017e 38.86e 0.0020e 39.85e 0.0019e 40.86e 0.0021e 41.86e 0.0007e 42.84e 0.0012e 43.84e 0.0007e 44.84e 0.0010e 45.85e 0.0005e 46.82e 0.0006e 47.84e 0.0009e 48.82e 0.0009e 49.82e 0.0006e 50.81e 0.0008e 51.82e 0.0012e 52.80e 0.0012e 54.81e 0.0005e 55.78e 0.0003e 56.79e 0.0003e 57.78e 0.0003e 58.79e 0.0003e 59.80e 0.0004e 60.77e 0.0003e 61.78e 0.0004e 62.77e 0.0005e 63.77e 0.0001e 64.75e 0.0004e 65.76e 0.0003e 66.77e 0.0003e 67.76e 0.0006e 68.75e 0.0006e 69.75e 0.0007e 70.74e 0.0004e 71.74e 0.0010e 72.73e 0.0008e 73.74e 0.0007e 75.74e 0.0002e 76.72e 0.0004e 77.72e 0.0002e 78.71e 0.0004e 79.70e 0.0001e 80.71e 0.0001e 81.70e 0.0002e 82.70e 0.0001e 83.70e 0.0004e 84.69e 0.0003e 85.68e 0.0008e 86.68e 0.0003e 87.69e 0.0001e 88.69e 0.0002e 90.66e 0.0001e ] constant sax-d3

vct[ 1.00e 0.0338e 1.99e 0.0765e 2.97e 0.0602e 3.96e 0.0870e 4.97e 0.1666e 5.96e 0.0394e 6.95e 0.0067e 7.94e 0.0199e 8.94e 0.0418e 9.93e 0.0110e 10.92e 0.0101e 11.91e 0.0077e 12.90e 0.0052e 13.91e 0.0148e 14.90e 0.0172e 15.88e 0.0218e 16.87e 0.0110e 17.88e 0.0086e 18.87e 0.0045e 19.86e 0.0009e 20.85e 0.0014e 21.85e 0.0045e 22.84e 0.0037e 23.83e 0.0010e 24.82e 0.0028e 25.81e 0.0013e 26.82e 0.0032e 27.81e 0.0040e 28.79e 0.0067e 29.78e 0.0035e 30.79e 0.0041e 31.78e 0.0028e 32.76e 0.0017e 33.75e 0.0011e 34.76e 0.0015e 35.75e 0.0018e 36.73e 0.0021e 37.72e 0.0017e 38.71e 0.0019e 39.72e 0.0014e 40.71e 0.0015e 41.70e 0.0016e 42.69e 0.0006e 43.69e 0.0021e 44.69e 0.0024e 45.67e 0.0003e 46.66e 0.0014e 47.66e 0.0002e 48.66e 0.0011e 49.65e 0.0010e 50.63e 0.0002e 51.62e 0.0008e 52.63e 0.0007e 53.62e 0.0008e 54.60e 0.0004e 56.59e 0.0005e 57.59e 0.0003e 58.58e 0.0007e 60.56e 0.0004e 61.56e 0.0002e 62.55e 0.0004e 63.54e 0.0004e 64.53e 0.0008e 65.54e 0.0011e 66.53e 0.0003e 67.52e 0.0009e 68.51e 0.0008e 69.51e 0.0013e 70.50e 0.0002e 71.49e 0.0004e 72.47e 0.0004e 73.47e 0.0002e 74.48e 0.0002e 75.46e 0.0002e 76.45e 0.0005e 77.45e 0.0003e 78.45e 0.0008e 79.44e 0.0003e 80.42e 0.0008e 81.41e 0.0005e 82.41e 0.0001e 83.42e 0.0001e ] constant sax-ds3

vct[ 1.00e 0.0225e 1.99e 0.0627e 2.99e 0.0834e 3.98e 0.0804e 4.98e 0.0984e 5.97e 0.0393e 6.96e 0.0345e 7.96e 0.0102e 8.95e 0.0084e 9.94e 0.0129e 10.93e 0.0214e 11.93e 0.0154e 12.92e 0.0184e 13.91e 0.0167e 14.91e 0.0213e 15.90e 0.0116e 16.89e 0.0090e 17.88e 0.0045e 18.88e 0.0008e 19.87e 0.0024e 20.86e 0.0045e 21.86e 0.0058e 22.85e 0.0012e 23.84e 0.0012e 24.84e 0.0030e 25.83e 0.0035e 26.82e 0.0067e 27.83e 0.0048e 28.82e 0.0016e 29.82e 0.0012e 30.81e 0.0015e 31.81e 0.0032e 32.80e 0.0033e 33.80e 0.0038e 34.79e 0.0032e 35.78e 0.0025e 36.78e 0.0008e 37.77e 0.0007e 38.76e 0.0020e 39.75e 0.0009e 40.75e 0.0007e 41.74e 0.0018e 42.73e 0.0024e 43.72e 0.0012e 44.72e 0.0016e 45.71e 0.0015e 46.70e 0.0019e 47.69e 0.0005e 48.69e 0.0007e 49.68e 0.0006e 50.67e 0.0003e 51.68e 0.0006e 52.67e 0.0002e 53.66e 0.0004e 54.65e 0.0004e 55.65e 0.0005e 56.64e 0.0004e 57.64e 0.0006e 58.64e 0.0004e 59.64e 0.0004e 60.63e 0.0011e 61.62e 0.0004e 62.62e 0.0003e 63.61e 0.0005e 64.60e 0.0011e 65.60e 0.0010e 65.74e 0.0001e 66.59e 0.0001e 67.58e 0.0006e 68.57e 0.0007e 69.56e 0.0003e 70.56e 0.0002e 71.56e 0.0002e 72.55e 0.0007e 73.54e 0.0009e 74.53e 0.0008e 75.52e 0.0007e 76.52e 0.0006e 77.51e 0.0002e 79.50e 0.0002e ] constant sax-e3

vct[ 0.98e 0.0394e 1.98e 0.0562e 2.97e 0.0897e 3.96e 0.0683e 4.96e 0.0231e 5.95e 0.0309e 6.94e 0.0308e 7.91e 0.0176e 8.91e 0.0089e 9.90e 0.0084e 10.89e 0.0141e 11.89e 0.0045e 12.88e 0.0070e 13.87e 0.0083e 14.85e 0.0142e 15.84e 0.0089e 16.83e 0.0048e 17.82e 0.0015e 18.82e 0.0028e 19.82e 0.0027e 20.81e 0.0015e 21.79e 0.0012e 22.77e 0.0015e 23.76e 0.0050e 24.76e 0.0041e 25.75e 0.0048e 26.75e 0.0015e 27.74e 0.0007e 28.73e 0.0011e 29.71e 0.0016e 30.70e 0.0020e 31.69e 0.0019e 32.68e 0.0032e 33.68e 0.0026e 34.67e 0.0014e 35.66e 0.0013e 36.64e 0.0009e 37.63e 0.0014e 38.62e 0.0009e 39.61e 0.0018e 40.61e 0.0008e 41.60e 0.0013e 42.59e 0.0007e 43.57e 0.0010e 44.56e 0.0006e 45.57e 0.0002e 46.54e 0.0009e 47.53e 0.0005e 48.51e 0.0002e 49.53e 0.0001e 50.52e 0.0005e 51.49e 0.0002e 52.49e 0.0006e 53.47e 0.0001e 54.48e 0.0002e 55.46e 0.0003e 56.47e 0.0002e 57.45e 0.0006e 58.43e 0.0004e 59.42e 0.0003e 60.41e 0.0006e 61.41e 0.0005e 62.40e 0.0005e 63.40e 0.0002e 64.38e 0.0003e 65.37e 0.0001e 66.35e 0.0002e 68.34e 0.0005e 69.33e 0.0003e 70.33e 0.0005e 71.32e 0.0001e 72.30e 0.0002e 75.27e 0.0001e ] constant sax-f3

vct[ 0.99e 0.0784e 1.99e 0.0550e 2.97e 0.0439e 3.97e 0.0998e 4.95e 0.0679e 5.95e 0.0244e 6.93e 0.0178e 7.94e 0.0130e 8.92e 0.0186e 9.92e 0.0204e 10.90e 0.0091e 11.90e 0.0102e 12.88e 0.0166e 13.88e 0.0130e 14.86e 0.0079e 15.86e 0.0039e 16.86e 0.0023e 17.84e 0.0052e 18.84e 0.0049e 19.82e 0.0042e 20.82e 0.0027e 21.81e 0.0027e 22.80e 0.0057e 23.78e 0.0042e 24.79e 0.0042e 25.77e 0.0015e 26.77e 0.0008e 27.75e 0.0020e 28.75e 0.0021e 29.73e 0.0032e 30.73e 0.0036e 31.71e 0.0022e 32.71e 0.0011e 33.71e 0.0015e 34.69e 0.0011e 35.69e 0.0012e 36.67e 0.0013e 37.67e 0.0014e 38.65e 0.0006e 39.65e 0.0013e 40.64e 0.0004e 41.63e 0.0010e 42.62e 0.0002e 43.62e 0.0010e 44.60e 0.0003e 45.59e 0.0003e 46.58e 0.0004e 47.59e 0.0005e 48.57e 0.0002e 49.55e 0.0005e 50.55e 0.0002e 51.54e 0.0002e 52.53e 0.0005e 53.53e 0.0006e 54.52e 0.0006e 55.51e 0.0002e 56.50e 0.0008e 57.47e 0.0003e 58.48e 0.0007e 59.47e 0.0003e 60.46e 0.0002e 61.44e 0.0002e 62.45e 0.0002e 63.43e 0.0001e 64.43e 0.0004e 65.42e 0.0005e 66.41e 0.0007e 67.40e 0.0002e 68.39e 0.0002e 69.39e 0.0002e 70.37e 0.0001e ] constant sax-fs3

vct[ 1.00e 0.1076e 1.99e 0.0463e 2.98e 0.1092e 3.97e 0.0816e 4.95e 0.0831e 5.94e 0.0118e 6.93e 0.0095e 7.94e 0.0104e 8.93e 0.0148e 9.92e 0.0144e 10.91e 0.0117e 11.90e 0.0196e 12.89e 0.0153e 13.88e 0.0107e 14.87e 0.0052e 15.86e 0.0033e 16.86e 0.0058e 17.85e 0.0042e 18.83e 0.0013e 19.83e 0.0029e 20.82e 0.0067e 21.81e 0.0040e 22.80e 0.0057e 23.79e 0.0022e 24.79e 0.0019e 25.78e 0.0009e 26.78e 0.0017e 27.76e 0.0025e 28.76e 0.0024e 29.74e 0.0020e 30.73e 0.0011e 31.72e 0.0010e 32.73e 0.0007e 33.72e 0.0013e 34.70e 0.0019e 35.69e 0.0017e 36.69e 0.0011e 37.67e 0.0006e 38.67e 0.0008e 39.67e 0.0005e 40.66e 0.0005e 41.65e 0.0011e 42.64e 0.0003e 43.63e 0.0004e 44.62e 0.0007e 45.60e 0.0007e 46.60e 0.0006e 47.59e 0.0006e 48.59e 0.0003e 49.59e 0.0007e 50.57e 0.0006e 51.57e 0.0007e 52.55e 0.0003e 53.54e 0.0008e 54.53e 0.0005e 55.53e 0.0005e 56.51e 0.0003e 57.52e 0.0005e 59.50e 0.0001e 60.48e 0.0002e 61.47e 0.0006e 62.46e 0.0005e 63.46e 0.0003e 64.46e 0.0002e 65.45e 0.0002e ] constant sax-g3

vct[ 0.98e 0.0781e 1.97e 0.0393e 2.96e 0.0842e 3.94e 0.0434e 4.93e 0.0378e 5.91e 0.0141e 6.89e 0.0201e 7.87e 0.0294e 8.86e 0.0169e 9.85e 0.0124e 10.84e 0.0137e 11.81e 0.0238e 12.80e 0.0172e 13.78e 0.0094e 14.77e 0.0040e 15.76e 0.0036e 16.74e 0.0061e 17.72e 0.0032e 18.70e 0.0035e 19.69e 0.0086e 20.68e 0.0065e 21.66e 0.0097e 22.65e 0.0036e 23.63e 0.0010e 24.62e 0.0006e 25.61e 0.0018e 26.59e 0.0026e 27.58e 0.0023e 28.56e 0.0017e 29.54e 0.0010e 30.52e 0.0012e 31.50e 0.0018e 32.50e 0.0021e 33.48e 0.0025e 34.46e 0.0010e 35.45e 0.0028e 36.42e 0.0018e 37.41e 0.0009e 38.41e 0.0007e 39.38e 0.0006e 40.37e 0.0004e 41.36e 0.0005e 42.34e 0.0007e 43.31e 0.0001e 44.29e 0.0002e 45.29e 0.0006e 46.28e 0.0005e 47.26e 0.0005e 48.25e 0.0006e 49.22e 0.0006e 50.21e 0.0003e 51.20e 0.0007e 52.18e 0.0004e 53.16e 0.0003e 54.15e 0.0004e 55.14e 0.0001e 56.10e 0.0001e 57.11e 0.0005e 58.09e 0.0007e 59.07e 0.0005e 59.22e 0.0001e 61.04e 0.0004e 63.02e 0.0002e ] constant sax-gs3

vct[ 0.99e 0.0950e 1.97e 0.0374e 2.95e 0.0738e 3.94e 0.0772e 4.93e 0.0103e 5.92e 0.0135e 6.90e 0.0099e 7.88e 0.0088e 8.88e 0.0151e 9.86e 0.0150e 10.84e 0.0177e 11.83e 0.0121e 12.82e 0.0071e 13.81e 0.0049e 14.79e 0.0025e 15.77e 0.0046e 16.77e 0.0023e 17.75e 0.0020e 18.73e 0.0079e 19.71e 0.0057e 20.70e 0.0068e 21.69e 0.0036e 22.67e 0.0007e 23.65e 0.0003e 24.65e 0.0006e 25.64e 0.0016e 26.62e 0.0013e 27.60e 0.0006e 28.59e 0.0005e 29.59e 0.0005e 30.56e 0.0013e 31.55e 0.0015e 32.53e 0.0013e 33.52e 0.0009e 34.51e 0.0016e 35.48e 0.0002e 36.47e 0.0007e 37.46e 0.0002e 38.46e 0.0003e 39.43e 0.0002e 40.42e 0.0003e 41.40e 0.0006e 42.40e 0.0006e 43.39e 0.0002e 44.36e 0.0009e 45.35e 0.0008e 46.34e 0.0010e 47.32e 0.0003e 48.30e 0.0009e 49.29e 0.0006e 50.28e 0.0002e 51.27e 0.0004e 52.25e 0.0002e 54.23e 0.0003e 55.21e 0.0001e 56.19e 0.0002e 58.17e 0.0002e ] constant sax-a3

vct[ 0.99e 0.0856e 1.98e 0.0365e 2.97e 0.0409e 3.96e 0.0666e 4.94e 0.0192e 5.94e 0.0263e 6.92e 0.0311e 7.91e 0.0175e 8.90e 0.0203e 9.89e 0.0358e 10.87e 0.0214e 11.87e 0.0177e 12.85e 0.0068e 13.84e 0.0071e 14.83e 0.0068e 15.82e 0.0040e 16.80e 0.0040e 17.80e 0.0126e 18.78e 0.0101e 19.77e 0.0086e 20.75e 0.0053e 21.75e 0.0012e 22.73e 0.0026e 23.73e 0.0019e 24.71e 0.0018e 25.71e 0.0026e 26.68e 0.0023e 27.68e 0.0022e 28.66e 0.0015e 29.66e 0.0031e 30.64e 0.0008e 31.63e 0.0023e 32.61e 0.0029e 33.61e 0.0007e 34.59e 0.0016e 35.59e 0.0009e 36.57e 0.0006e 37.56e 0.0012e 38.54e 0.0004e 39.53e 0.0005e 40.52e 0.0007e 41.52e 0.0006e 42.50e 0.0009e 43.50e 0.0015e 44.48e 0.0005e 45.47e 0.0012e 46.46e 0.0007e 47.45e 0.0003e 48.44e 0.0007e 49.41e 0.0003e 50.41e 0.0003e 51.40e 0.0011e 52.39e 0.0007e 53.37e 0.0005e 54.36e 0.0005e 55.34e 0.0002e 56.34e 0.0002e ] constant sax-as3

vct[ 0.99e 0.1015e 1.99e 0.0817e 2.98e 0.0315e 3.98e 0.0386e 4.97e 0.0424e 5.96e 0.0104e 6.96e 0.0144e 7.94e 0.0361e 8.94e 0.0182e 9.93e 0.0238e 10.93e 0.0139e 11.93e 0.0063e 12.91e 0.0058e 13.91e 0.0071e 14.91e 0.0051e 15.89e 0.0035e 16.90e 0.0114e 17.88e 0.0097e 18.88e 0.0081e 19.87e 0.0043e 20.86e 0.0014e 21.86e 0.0009e 22.85e 0.0012e 23.86e 0.0006e 24.84e 0.0013e 25.83e 0.0006e 26.83e 0.0010e 27.82e 0.0015e 28.80e 0.0008e 29.80e 0.0012e 30.80e 0.0017e 31.77e 0.0002e 32.78e 0.0016e 33.78e 0.0006e 34.77e 0.0003e 35.77e 0.0009e 36.76e 0.0006e 37.75e 0.0011e 38.75e 0.0006e 39.74e 0.0011e 40.74e 0.0011e 41.73e 0.0006e 42.72e 0.0015e 43.72e 0.0008e 44.70e 0.0002e 45.71e 0.0005e 46.70e 0.0004e 47.69e 0.0003e 48.69e 0.0005e 49.67e 0.0005e 50.64e 0.0001e 51.66e 0.0003e ] constant sax-b3

vct[ 0.99e 0.1462e 1.98e 0.0760e 2.98e 0.0464e 3.97e 0.0292e 4.95e 0.0393e 5.95e 0.0117e 6.94e 0.0150e 7.93e 0.0251e 8.93e 0.0238e 9.92e 0.0182e 10.90e 0.0142e 11.89e 0.0100e 12.89e 0.0108e 13.88e 0.0029e 14.87e 0.0060e 15.86e 0.0116e 16.85e 0.0066e 17.84e 0.0072e 18.84e 0.0034e 19.83e 0.0010e 20.82e 0.0013e 21.81e 0.0015e 22.80e 0.0012e 23.80e 0.0011e 24.79e 0.0004e 25.77e 0.0027e 26.76e 0.0021e 27.75e 0.0018e 28.75e 0.0013e 29.74e 0.0015e 30.73e 0.0008e 31.72e 0.0004e 32.71e 0.0007e 33.71e 0.0011e 34.70e 0.0002e 35.68e 0.0010e 36.67e 0.0002e 37.66e 0.0003e 38.67e 0.0010e 39.66e 0.0008e 40.64e 0.0019e 41.64e 0.0005e 42.62e 0.0010e 43.62e 0.0003e 45.60e 0.0005e 46.59e 0.0002e 47.59e 0.0002e 48.58e 0.0002e 49.57e 0.0002e 50.55e 0.0001e ] constant sax-c4

vct[ 0.99e 0.0832e 1.97e 0.0162e 2.96e 0.0337e 3.95e 0.0272e 4.94e 0.0264e 5.93e 0.0256e 6.93e 0.0180e 7.92e 0.0206e 8.90e 0.0167e 9.89e 0.0172e 10.88e 0.0075e 11.86e 0.0087e 12.85e 0.0048e 13.85e 0.0051e 14.83e 0.0134e 15.83e 0.0091e 16.82e 0.0065e 17.80e 0.0008e 18.80e 0.0018e 19.78e 0.0023e 20.77e 0.0025e 21.76e 0.0021e 22.74e 0.0013e 23.74e 0.0011e 24.72e 0.0032e 25.72e 0.0006e 26.72e 0.0005e 27.69e 0.0026e 28.69e 0.0009e 29.68e 0.0006e 30.66e 0.0003e 31.65e 0.0007e 32.64e 0.0003e 33.62e 0.0014e 34.61e 0.0007e 35.60e 0.0007e 36.59e 0.0005e 37.60e 0.0004e 38.56e 0.0006e 39.54e 0.0004e 40.55e 0.0004e 41.55e 0.0003e 42.50e 0.0002e 43.51e 0.0005e 44.50e 0.0003e 45.50e 0.0002e 46.48e 0.0002e 47.48e 0.0002e ] constant sax-cs4

vct[ 0.98e 0.0860e 1.97e 0.0143e 2.95e 0.0061e 3.94e 0.0407e 4.93e 0.0204e 5.91e 0.0066e 6.90e 0.0372e 7.89e 0.0217e 8.87e 0.0220e 9.86e 0.0147e 10.85e 0.0042e 11.83e 0.0072e 12.82e 0.0023e 13.81e 0.0074e 14.79e 0.0104e 15.78e 0.0050e 16.76e 0.0005e 17.74e 0.0036e 18.73e 0.0056e 19.71e 0.0022e 20.70e 0.0040e 21.69e 0.0021e 22.68e 0.0018e 23.66e 0.0026e 24.65e 0.0035e 25.64e 0.0021e 26.62e 0.0011e 27.61e 0.0013e 28.59e 0.0006e 29.58e 0.0002e 30.57e 0.0010e 31.69e 0.0001e 32.54e 0.0004e 33.52e 0.0009e 34.50e 0.0005e 35.49e 0.0004e 36.47e 0.0013e 37.46e 0.0015e 38.45e 0.0009e 39.43e 0.0003e 40.42e 0.0004e 41.41e 0.0008e 42.40e 0.0005e 43.38e 0.0004e 44.37e 0.0006e ] constant sax-d4

vct[ 0.98e 0.0870e 1.97e 0.0204e 2.96e 0.0184e 3.94e 0.0494e 4.92e 0.0500e 5.91e 0.0163e 6.90e 0.0267e 7.88e 0.0158e 8.86e 0.0159e 9.85e 0.0095e 10.84e 0.0095e 11.82e 0.0039e 12.81e 0.0053e 13.79e 0.0074e 14.78e 0.0054e 15.77e 0.0004e 16.75e 0.0027e 17.73e 0.0034e 18.71e 0.0035e 19.70e 0.0019e 20.69e 0.0028e 21.67e 0.0032e 22.65e 0.0016e 23.64e 0.0018e 24.63e 0.0033e 25.61e 0.0006e 26.59e 0.0015e 27.58e 0.0005e 28.57e 0.0010e 29.56e 0.0006e 30.54e 0.0010e 31.52e 0.0009e 32.51e 0.0004e 33.50e 0.0012e 34.47e 0.0006e 35.46e 0.0009e 36.45e 0.0007e 37.44e 0.0002e 38.42e 0.0006e 39.41e 0.0003e 40.38e 0.0003e 41.38e 0.0005e 42.36e 0.0003e ] constant sax-ds4

vct[ 0.99e 0.0111e 1.97e 0.0520e 2.96e 0.0287e 3.94e 0.0704e 4.93e 0.0240e 5.91e 0.0286e 6.89e 0.0516e 7.89e 0.0184e 8.87e 0.0076e 9.86e 0.0113e 10.84e 0.0049e 11.83e 0.0044e 12.81e 0.0111e 13.79e 0.0080e 14.78e 0.0008e 15.76e 0.0031e 16.76e 0.0042e 17.74e 0.0016e 18.73e 0.0021e 19.71e 0.0010e 20.69e 0.0048e 21.68e 0.0014e 22.66e 0.0020e 23.66e 0.0016e 24.64e 0.0011e 25.62e 0.0011e 26.61e 0.0001e 27.59e 0.0011e 28.58e 0.0013e 29.56e 0.0011e 30.55e 0.0004e 31.54e 0.0015e 32.52e 0.0023e 33.51e 0.0015e 34.49e 0.0004e 35.48e 0.0003e 36.46e 0.0007e 37.45e 0.0003e 38.43e 0.0003e 39.42e 0.0009e ] constant sax-e4

vct[ 1.00e 0.0896e 2.00e 0.1802e 3.00e 0.0636e 4.00e 0.0344e 5.01e 0.0214e 6.01e 0.0196e 7.01e 0.0241e 8.01e 0.0118e 9.01e 0.0057e 10.01e 0.0060e 11.01e 0.0059e 12.01e 0.0032e 13.02e 0.0055e 14.02e 0.0023e 15.01e 0.0020e 16.02e 0.0027e 17.02e 0.0022e 18.02e 0.0017e 19.02e 0.0015e 20.02e 0.0020e 21.03e 0.0014e 22.03e 0.0010e 23.02e 0.0006e 24.03e 0.0007e 25.03e 0.0005e 27.03e 0.0006e 28.03e 0.0005e 29.04e 0.0003e 30.04e 0.0009e 31.03e 0.0006e 32.04e 0.0003e 33.04e 0.0002e 34.04e 0.0003e 35.04e 0.0001e 36.04e 0.0002e 37.05e 0.0003e ] constant sax-f4

vct[ 0.99e 0.0786e 1.99e 0.1613e 2.99e 0.0550e 3.98e 0.0380e 4.98e 0.0201e 5.98e 0.0245e 6.97e 0.0212e 7.96e 0.0069e 8.96e 0.0130e 9.96e 0.0029e 10.95e 0.0084e 11.95e 0.0093e 12.94e 0.0026e 13.94e 0.0015e 14.93e 0.0022e 15.93e 0.0025e 16.93e 0.0022e 17.92e 0.0015e 18.91e 0.0011e 19.91e 0.0011e 20.91e 0.0006e 21.90e 0.0010e 22.89e 0.0003e 23.89e 0.0003e 24.89e 0.0004e 25.89e 0.0003e 26.88e 0.0011e 26.95e 0.0003e 27.87e 0.0003e 28.87e 0.0012e 29.87e 0.0002e 30.86e 0.0004e 31.85e 0.0003e 32.85e 0.0005e 33.84e 0.0006e 34.84e 0.0002e 34.90e 0.0001e ] constant sax-fs4

vct[ 1.00e 0.0747e 2.00e 0.1351e 3.00e 0.0384e 4.00e 0.0519e 5.00e 0.0376e 6.00e 0.0323e 7.00e 0.0212e 8.00e 0.0091e 9.00e 0.0086e 10.00e 0.0060e 11.00e 0.0132e 12.00e 0.0038e 13.00e 0.0016e 14.00e 0.0044e 15.00e 0.0023e 16.00e 0.0029e 17.00e 0.0031e 18.00e 0.0011e 19.00e 0.0008e 20.00e 0.0006e 21.01e 0.0005e 22.00e 0.0006e 23.00e 0.0007e 24.00e 0.0008e 25.01e 0.0003e 26.01e 0.0017e 27.00e 0.0012e 28.00e 0.0005e 29.03e 0.0001e 30.00e 0.0004e 31.00e 0.0005e 32.00e 0.0001e 33.00e 0.0003e 34.00e 0.0001e ] constant sax-g4

vct[ 1.00e 0.0671e 1.99e 0.0676e 2.98e 0.0664e 3.97e 0.0207e 4.97e 0.0170e 5.96e 0.0406e 6.96e 0.0157e 7.95e 0.0093e 8.94e 0.0032e 9.93e 0.0117e 10.93e 0.0059e 11.93e 0.0034e 12.92e 0.0052e 13.91e 0.0036e 14.90e 0.0010e 15.89e 0.0023e 16.89e 0.0019e 17.89e 0.0011e 18.88e 0.0013e 19.87e 0.0009e 20.86e 0.0005e 21.86e 0.0006e 22.86e 0.0011e 23.85e 0.0006e 24.85e 0.0008e 25.83e 0.0010e 26.83e 0.0010e 27.82e 0.0007e 28.80e 0.0002e 29.82e 0.0006e 31.80e 0.0001e ] constant sax-gs4

vct[ 0.99e 0.0707e 1.99e 0.1376e 2.99e 0.0767e 3.98e 0.0191e 4.98e 0.0316e 5.97e 0.0241e 6.97e 0.0070e 7.97e 0.0095e 8.96e 0.0085e 9.96e 0.0109e 10.96e 0.0012e 11.95e 0.0047e 12.94e 0.0051e 13.94e 0.0022e 14.93e 0.0020e 15.93e 0.0007e 16.93e 0.0016e 17.92e 0.0014e 18.92e 0.0008e 19.92e 0.0005e 20.91e 0.0008e 21.91e 0.0005e 22.91e 0.0002e 23.90e 0.0008e 24.89e 0.0015e 25.89e 0.0004e 26.89e 0.0003e 27.88e 0.0002e 28.88e 0.0002e 29.88e 0.0002e ] constant sax-a4

vct[ 0.99e 0.0652e 1.98e 0.0768e 2.97e 0.0399e 3.96e 0.0314e 4.95e 0.0539e 5.94e 0.0282e 6.93e 0.0048e 7.93e 0.0059e 8.91e 0.0163e 9.90e 0.0039e 10.89e 0.0052e 11.88e 0.0086e 12.87e 0.0025e 13.86e 0.0011e 14.85e 0.0069e 15.84e 0.0006e 16.84e 0.0018e 17.82e 0.0008e 18.80e 0.0004e 19.81e 0.0004e 20.78e 0.0002e 21.79e 0.0010e 22.78e 0.0038e 23.76e 0.0018e 24.75e 0.0010e 25.74e 0.0002e 26.73e 0.0005e 27.72e 0.0006e 28.71e 0.0003e ] constant sax-as4

vct[ 1.00e 0.1365e 1.99e 0.0773e 2.98e 0.0370e 3.97e 0.0399e 4.97e 0.0441e 5.96e 0.0193e 6.95e 0.0055e 7.95e 0.0036e 8.94e 0.0106e 9.93e 0.0050e 10.93e 0.0075e 11.92e 0.0047e 12.91e 0.0013e 13.90e 0.0034e 14.90e 0.0024e 15.89e 0.0018e 16.89e 0.0005e 17.87e 0.0006e 18.87e 0.0014e 19.87e 0.0011e 20.86e 0.0017e 21.84e 0.0018e 22.84e 0.0007e 23.83e 0.0003e 24.82e 0.0006e 25.83e 0.0002e 26.81e 0.0002e ] constant sax-b4

vct[ 0.99e 0.1197e 1.98e 0.0661e 2.97e 0.0448e 3.96e 0.0398e 4.96e 0.0311e 5.95e 0.0167e 6.93e 0.0068e 7.93e 0.0249e 8.92e 0.0065e 9.91e 0.0104e 10.90e 0.0081e 11.89e 0.0032e 12.88e 0.0060e 13.87e 0.0037e 14.86e 0.0020e 15.86e 0.0008e 16.84e 0.0005e 17.84e 0.0025e 18.83e 0.0010e 19.81e 0.0020e 20.81e 0.0017e 21.80e 0.0013e 22.79e 0.0016e 23.78e 0.0009e 24.77e 0.0006e 25.76e 0.0002e ] constant sax-c5

vct[ 0.98e 0.0251e 1.97e 0.0316e 2.95e 0.0599e 3.93e 0.0403e 4.92e 0.0418e 5.90e 0.0065e 6.89e 0.0047e 7.86e 0.0085e 8.85e 0.0061e 9.84e 0.0097e 10.82e 0.0033e 10.87e 0.0006e 12.26e 0.0004e 12.78e 0.0040e 13.77e 0.0023e 14.75e 0.0020e 15.73e 0.0003e 16.72e 0.0011e 17.71e 0.0012e 18.69e 0.0013e 19.67e 0.0008e 20.66e 0.0013e 21.64e 0.0005e 22.62e 0.0004e 23.60e 0.0005e ] constant sax-cs5

vct[ 0.99e 0.0055e 1.97e 0.0823e 2.95e 0.0106e 3.94e 0.0646e 4.93e 0.0345e 5.91e 0.0069e 6.90e 0.0201e 7.89e 0.0165e 8.87e 0.0171e 9.86e 0.0114e 10.85e 0.0050e 11.82e 0.0053e 12.82e 0.0107e 13.81e 0.0033e 14.78e 0.0026e 15.78e 0.0016e 16.76e 0.0019e 17.74e 0.0011e 18.72e 0.0030e 19.73e 0.0009e 20.70e 0.0021e 21.67e 0.0003e 22.67e 0.0003e 23.65e 0.0001e ] constant sax-d5

vct[ 0.98e 0.0699e 1.97e 0.0761e 2.95e 0.0777e 3.93e 0.0573e 4.92e 0.0236e 5.90e 0.0082e 6.88e 0.0195e 7.87e 0.0108e 8.85e 0.0205e 9.83e 0.0042e 10.82e 0.0112e 11.80e 0.0039e 12.78e 0.0018e 13.77e 0.0027e 14.75e 0.0017e 15.73e 0.0015e 16.72e 0.0019e 17.70e 0.0047e 18.68e 0.0011e 19.67e 0.0020e 20.65e 0.0027e 21.63e 0.0002e ] constant sax-ds5

vct[ 0.99e 0.1082e 1.99e 0.1222e 2.99e 0.0874e 3.98e 0.0436e 4.98e 0.0208e 5.98e 0.0141e 6.97e 0.0193e 7.97e 0.0172e 8.97e 0.0118e 9.96e 0.0082e 10.96e 0.0133e 11.96e 0.0062e 12.95e 0.0058e 13.95e 0.0013e 14.94e 0.0017e 15.94e 0.0029e 16.94e 0.0032e 17.93e 0.0006e 18.93e 0.0028e 19.92e 0.0004e ] constant sax-e5

vct[ 1.00e 0.1462e 2.00e 0.0665e 3.01e 0.0741e 4.01e 0.0382e 5.01e 0.0262e 6.02e 0.0172e 7.02e 0.0168e 8.02e 0.0172e 9.02e 0.0087e 10.02e 0.0145e 11.03e 0.0046e 12.03e 0.0033e 13.03e 0.0032e 14.03e 0.0030e 15.03e 0.0040e 16.04e 0.0059e 17.04e 0.0026e 18.04e 0.0005e 19.05e 0.0009e ] constant sax-f5

vct[ 1.00e 0.0652e 2.00e 0.0563e 3.00e 0.0939e 3.99e 0.0334e 5.00e 0.0109e 5.99e 0.0258e 6.99e 0.0213e 7.99e 0.0135e 8.99e 0.0018e 9.99e 0.0205e 10.99e 0.0043e 11.99e 0.0004e 12.99e 0.0037e 13.98e 0.0017e 14.98e 0.0071e 15.98e 0.0035e 16.98e 0.0029e 17.98e 0.0005e ] constant sax-fs5

vct[ 1.00e 0.0918e 1.99e 0.0493e 2.99e 0.0565e 3.98e 0.0225e 4.98e 0.0118e 5.98e 0.0184e 6.97e 0.0138e 7.99e 0.0042e 8.98e 0.0077e 9.95e 0.0104e 10.96e 0.0018e 11.94e 0.0022e 12.98e 0.0061e 13.96e 0.0032e 14.96e 0.0023e 15.96e 0.0016e 16.90e 0.0008e ] constant sax-g5

vct[ 0.99e 0.1447e 1.98e 0.0908e 2.97e 0.0522e 3.96e 0.0607e 4.96e 0.0316e 5.95e 0.0115e 6.94e 0.0147e 7.93e 0.0148e 8.92e 0.0221e 9.91e 0.0097e 10.90e 0.0087e 11.90e 0.0078e 12.89e 0.0127e 13.88e 0.0042e 14.87e 0.0007e 15.86e 0.0012e ] constant sax-gs5

vct[ 0.97e 0.1089e 1.94e 0.0491e 4.85e 0.0162e 5.82e 0.0156e 6.78e 0.0130e 7.75e 0.0174e 8.72e 0.0104e 8.75e 0.0087e 8.77e 0.0024e 8.80e 0.0019e 8.82e 0.0014e 9.72e 0.0010e 10.66e 0.0033e 11.63e 0.0092e 11.66e 0.0045e 12.59e 0.0028e 12.65e 0.0015e 12.67e 0.0011e 13.64e 0.0007e 14.56e 0.0017e 14.59e 0.0017e 14.61e 0.0010e 14.62e 0.0008e 14.64e 0.0005e 15.50e 0.0003e 15.53e 0.0002e 15.56e 0.0002e 15.58e 0.0001e ] constant sax-a5

\ **********************************************************
\ soprano sax?
\ **********************************************************

vct[ 1.01e 0.0846e 2.02e 0.0851e 3.03e 0.0782e 4.03e 0.0250e 5.04e 0.0513e 6.05e 0.0121e 7.07e 0.0065e 8.08e 0.0409e 9.09e 0.0134e 10.09e 0.0032e 11.10e 0.0168e 12.12e 0.0076e 13.13e 0.0054e 14.13e 0.0091e 15.14e 0.0078e 16.15e 0.0029e 17.16e 0.0103e 18.18e 0.0103e 19.18e 0.0071e 20.19e 0.0105e 21.20e 0.0063e 22.20e 0.0054e 23.21e 0.0011e 24.22e 0.0008e 25.24e 0.0003e 26.23e 0.0001e 27.26e 0.0002e 28.25e 0.0006e 29.27e 0.0004e 30.29e 0.0008e 31.29e 0.0004e 32.31e 0.0002e 33.32e 0.0003e 34.32e 0.0003e 35.33e 0.0001e 36.34e 0.0002e 37.35e 0.0005e 38.36e 0.0003e 39.37e 0.0003e 40.37e 0.0002e 41.39e 0.0002e 42.40e 0.0002e 43.41e 0.0002e 44.43e 0.0001e 45.43e 0.0007e 46.43e 0.0004e 47.44e 0.0002e 48.46e 0.0001e 49.48e 0.0001e 50.48e 0.0002e 51.49e 0.0002e 52.49e 0.0002e 53.50e 0.0002e 54.51e 0.0002e 55.53e 0.0003e 56.54e 0.0003e 57.54e 0.0002e 58.55e 0.0002e 59.55e 0.0001e ] constant ssax-gs3

vct[ 0.99e 0.1143e 1.99e 0.0599e 2.99e 0.0780e 3.99e 0.0629e 4.99e 0.0063e 5.99e 0.0066e 6.99e 0.0283e 7.99e 0.0134e 8.98e 0.0083e 9.97e 0.0114e 10.97e 0.0087e 11.97e 0.0171e 12.97e 0.0109e 13.97e 0.0149e 14.97e 0.0075e 15.97e 0.0164e 16.97e 0.0174e 17.94e 0.0021e 18.97e 0.0139e 19.96e 0.0073e 20.95e 0.0122e 21.95e 0.0018e 22.95e 0.0022e 23.94e 0.0002e 24.95e 0.0014e 25.94e 0.0006e 26.95e 0.0007e 27.94e 0.0012e 28.94e 0.0013e 29.93e 0.0009e 30.94e 0.0014e 31.92e 0.0012e 32.93e 0.0008e 33.93e 0.0015e 34.93e 0.0021e 35.92e 0.0009e 36.93e 0.0011e 37.93e 0.0011e 38.94e 0.0005e 39.92e 0.0008e 41.93e 0.0004e 42.91e 0.0012e 43.87e 0.0002e 44.93e 0.0006e 45.92e 0.0006e 46.91e 0.0002e 47.92e 0.0002e 48.91e 0.0004e 49.89e 0.0004e 50.89e 0.0003e 51.89e 0.0003e 52.90e 0.0003e 53.90e 0.0003e 54.91e 0.0003e 55.90e 0.0003e 56.89e 0.0002e ] constant ssax-a3

vct[ 1.00e 0.0772e 1.99e 0.0797e 2.98e 0.0350e 3.99e 0.1086e 4.98e 0.0418e 5.97e 0.0170e 6.98e 0.0247e 7.97e 0.0288e 8.96e 0.0041e 9.95e 0.0047e 10.95e 0.0120e 11.95e 0.0176e 12.93e 0.0128e 13.95e 0.0151e 14.94e 0.0162e 15.92e 0.0152e 16.93e 0.0077e 17.93e 0.0111e 18.92e 0.0092e 19.91e 0.0079e 20.91e 0.0053e 21.89e 0.0009e 22.90e 0.0008e 24.88e 0.0004e 25.88e 0.0009e 26.88e 0.0009e 27.87e 0.0014e 28.87e 0.0008e 29.87e 0.0023e 30.87e 0.0013e 31.85e 0.0012e 32.87e 0.0015e 33.85e 0.0011e 34.85e 0.0024e 35.84e 0.0021e 36.86e 0.0024e 37.87e 0.0008e 38.82e 0.0007e 39.85e 0.0009e 40.79e 0.0007e 41.83e 0.0009e 42.84e 0.0007e 43.84e 0.0006e 44.82e 0.0001e 46.83e 0.0004e 47.83e 0.0003e 48.81e 0.0003e 49.82e 0.0002e 50.82e 0.0001e 51.82e 0.0002e 52.81e 0.0002e 54.81e 0.0004e 55.80e 0.0002e ] constant ssax-as3

vct[ 0.99e 0.0413e 1.98e 0.0949e 2.98e 0.0746e 3.96e 0.0636e 4.96e 0.0383e 5.95e 0.0300e 6.93e 0.0190e 7.93e 0.0159e 8.92e 0.0172e 9.90e 0.0159e 10.90e 0.0047e 11.89e 0.0087e 12.88e 0.0153e 13.87e 0.0129e 14.87e 0.0112e 15.85e 0.0054e 16.84e 0.0076e 17.84e 0.0060e 18.82e 0.0064e 19.81e 0.0050e 20.81e 0.0009e 21.80e 0.0013e 22.78e 0.0003e 23.79e 0.0005e 24.78e 0.0005e 25.76e 0.0020e 26.75e 0.0020e 27.75e 0.0016e 28.73e 0.0012e 29.72e 0.0009e 30.72e 0.0017e 31.70e 0.0018e 32.69e 0.0012e 33.69e 0.0022e 34.67e 0.0014e 35.67e 0.0015e 36.66e 0.0009e 37.65e 0.0013e 38.64e 0.0019e 39.63e 0.0010e 40.62e 0.0012e 41.61e 0.0003e 42.61e 0.0003e 43.60e 0.0003e 44.58e 0.0004e 45.58e 0.0003e 47.55e 0.0004e 48.54e 0.0002e 49.54e 0.0003e 50.53e 0.0002e 51.52e 0.0002e ] constant ssax-b3

vct[ 0.99e 0.1251e 1.98e 0.0932e 2.97e 0.1614e 3.97e 0.0801e 4.96e 0.0100e 5.94e 0.0183e 6.94e 0.0221e 7.93e 0.0060e 8.92e 0.0055e 9.91e 0.0162e 10.90e 0.0171e 11.89e 0.0181e 12.88e 0.0135e 13.88e 0.0102e 14.87e 0.0071e 15.86e 0.0066e 16.84e 0.0071e 17.83e 0.0057e 18.83e 0.0027e 19.82e 0.0006e 20.82e 0.0008e 21.80e 0.0003e 22.78e 0.0007e 23.78e 0.0011e 24.77e 0.0019e 25.77e 0.0010e 26.76e 0.0016e 27.74e 0.0008e 28.74e 0.0013e 29.73e 0.0025e 30.72e 0.0019e 31.71e 0.0029e 32.70e 0.0022e 33.69e 0.0011e 34.68e 0.0014e 35.68e 0.0010e 36.67e 0.0014e 37.65e 0.0007e 38.64e 0.0005e 39.62e 0.0001e 40.63e 0.0004e 41.62e 0.0006e 42.61e 0.0005e 43.60e 0.0003e 44.58e 0.0003e 45.58e 0.0003e 46.58e 0.0006e 47.57e 0.0003e 48.56e 0.0002e ] constant ssax-c4

vct[ 0.98e 0.0809e 1.97e 0.0745e 2.96e 0.1141e 3.95e 0.0537e 4.95e 0.0028e 5.92e 0.0112e 6.93e 0.0029e 7.90e 0.0117e 8.89e 0.0101e 9.89e 0.0091e 10.87e 0.0113e 11.86e 0.0048e 12.85e 0.0076e 13.84e 0.0054e 14.82e 0.0089e 15.81e 0.0068e 16.80e 0.0065e 17.79e 0.0031e 18.77e 0.0009e 19.76e 0.0007e 20.75e 0.0005e 21.73e 0.0010e 22.72e 0.0016e 23.71e 0.0009e 24.70e 0.0016e 25.68e 0.0010e 26.68e 0.0018e 27.66e 0.0018e 28.65e 0.0009e 29.64e 0.0012e 30.63e 0.0017e 31.61e 0.0016e 32.60e 0.0008e 33.59e 0.0012e 34.58e 0.0014e 35.57e 0.0005e 36.56e 0.0006e 37.54e 0.0008e 38.53e 0.0005e 39.52e 0.0004e 40.50e 0.0004e 41.49e 0.0001e 42.47e 0.0004e 43.46e 0.0002e ] constant ssax-cs4

vct[ 0.99e 0.0919e 1.98e 0.0711e 2.98e 0.0924e 3.97e 0.0396e 4.95e 0.0407e 5.94e 0.0357e 6.93e 0.0035e 7.93e 0.0079e 8.91e 0.0110e 9.90e 0.0191e 10.89e 0.0103e 11.89e 0.0134e 12.88e 0.0025e 13.86e 0.0014e 14.86e 0.0082e 15.85e 0.0084e 16.84e 0.0024e 17.82e 0.0011e 18.82e 0.0011e 19.81e 0.0010e 20.80e 0.0002e 21.79e 0.0015e 22.78e 0.0011e 23.76e 0.0025e 24.77e 0.0018e 25.75e 0.0027e 26.74e 0.0036e 27.73e 0.0023e 28.73e 0.0034e 29.72e 0.0032e 30.70e 0.0011e 31.70e 0.0017e 32.69e 0.0014e 33.68e 0.0013e 34.66e 0.0004e 35.65e 0.0003e 36.64e 0.0002e 37.63e 0.0002e 38.62e 0.0004e 39.62e 0.0008e 40.61e 0.0004e 41.60e 0.0005e 42.59e 0.0005e 43.59e 0.0003e 44.56e 0.0002e ] constant ssax-d4

vct[ 0.99e 0.0684e 1.98e 0.0744e 2.97e 0.1315e 3.96e 0.0137e 4.94e 0.0352e 5.94e 0.0195e 6.93e 0.0148e 7.91e 0.0275e 8.91e 0.0191e 9.90e 0.0268e 10.88e 0.0194e 11.86e 0.0044e 12.86e 0.0046e 13.85e 0.0090e 14.84e 0.0072e 15.83e 0.0049e 16.82e 0.0015e 17.80e 0.0017e 18.80e 0.0006e 19.79e 0.0008e 20.77e 0.0020e 21.76e 0.0010e 22.75e 0.0025e 23.74e 0.0033e 24.73e 0.0023e 25.72e 0.0041e 26.71e 0.0051e 27.70e 0.0043e 28.69e 0.0033e 29.68e 0.0010e 30.66e 0.0013e 31.65e 0.0013e 32.64e 0.0013e 33.63e 0.0008e 34.64e 0.0001e 35.61e 0.0002e 36.60e 0.0003e 37.62e 0.0002e 38.58e 0.0006e 39.57e 0.0005e 40.58e 0.0001e 41.55e 0.0002e ] constant ssax-ds4

vct[ 1.00e 0.0363e 1.98e 0.1101e 2.98e 0.1009e 3.96e 0.0168e 4.95e 0.0610e 5.95e 0.0099e 6.94e 0.0066e 7.93e 0.0157e 8.92e 0.0162e 9.91e 0.0154e 10.90e 0.0131e 11.89e 0.0061e 12.88e 0.0029e 13.87e 0.0058e 14.86e 0.0040e 15.85e 0.0015e 16.84e 0.0012e 17.84e 0.0005e 18.82e 0.0005e 19.81e 0.0008e 20.85e 0.0007e 21.80e 0.0005e 22.78e 0.0016e 23.77e 0.0017e 24.76e 0.0022e 25.76e 0.0010e 26.80e 0.0006e 27.74e 0.0012e 28.72e 0.0007e 29.71e 0.0004e 30.70e 0.0004e 31.69e 0.0001e 32.68e 0.0001e 33.67e 0.0003e 34.65e 0.0004e 35.65e 0.0003e 36.64e 0.0003e 37.63e 0.0002e 38.61e 0.0002e ] constant ssax-e4

vct[ 1.00e 0.0607e 1.99e 0.1291e 3.00e 0.0576e 3.99e 0.0530e 4.99e 0.0330e 5.98e 0.0364e 6.98e 0.0116e 7.98e 0.0252e 8.97e 0.0175e 9.97e 0.0166e 10.97e 0.0147e 11.97e 0.0096e 12.96e 0.0060e 13.96e 0.0022e 14.95e 0.0018e 15.95e 0.0018e 16.96e 0.0003e 17.94e 0.0012e 18.94e 0.0021e 19.94e 0.0051e 20.94e 0.0018e 21.93e 0.0034e 22.93e 0.0038e 23.93e 0.0035e 24.92e 0.0041e 25.92e 0.0015e 26.91e 0.0024e 27.92e 0.0019e 28.92e 0.0008e 29.91e 0.0005e 30.92e 0.0003e 31.91e 0.0005e 32.91e 0.0006e 33.90e 0.0003e 34.89e 0.0002e 35.89e 0.0005e 36.89e 0.0002e ] constant ssax-f4

vct[ 0.99e 0.0502e 1.98e 0.0678e 2.96e 0.0319e 3.95e 0.0589e 4.93e 0.0093e 5.93e 0.0072e 6.91e 0.0063e 7.89e 0.0224e 8.88e 0.0185e 9.87e 0.0096e 10.86e 0.0046e 11.84e 0.0060e 12.83e 0.0052e 13.82e 0.0008e 14.80e 0.0022e 15.79e 0.0009e 16.79e 0.0008e 17.76e 0.0011e 18.75e 0.0024e 19.74e 0.0013e 20.71e 0.0009e 21.71e 0.0038e 22.70e 0.0037e 23.68e 0.0023e 24.66e 0.0010e 25.66e 0.0007e 26.64e 0.0009e 27.64e 0.0007e 28.61e 0.0002e 29.61e 0.0006e 30.60e 0.0004e 31.58e 0.0008e 32.56e 0.0004e 33.55e 0.0005e 35.53e 0.0002e ] constant ssax-fs4

vct[ 1.00e 0.0253e 1.99e 0.0803e 2.98e 0.0107e 3.97e 0.0688e 4.96e 0.0361e 5.96e 0.0208e 6.96e 0.0172e 7.95e 0.0172e 8.94e 0.0189e 9.93e 0.0080e 10.92e 0.0114e 11.92e 0.0059e 12.91e 0.0058e 13.90e 0.0007e 14.89e 0.0011e 15.89e 0.0011e 16.88e 0.0023e 17.87e 0.0046e 18.87e 0.0024e 19.85e 0.0043e 20.86e 0.0087e 21.83e 0.0023e 22.84e 0.0043e 23.84e 0.0039e 24.83e 0.0020e 25.81e 0.0017e 26.81e 0.0009e 27.82e 0.0006e 28.80e 0.0004e 29.79e 0.0007e 30.80e 0.0005e 31.78e 0.0011e 32.78e 0.0004e 33.76e 0.0001e ] constant ssax-g4

vct[ 1.00e 0.0453e 2.00e 0.1198e 2.99e 0.0370e 3.99e 0.1319e 4.98e 0.0327e 5.97e 0.0018e 6.98e 0.0199e 7.97e 0.0362e 8.97e 0.0196e 9.96e 0.0065e 10.96e 0.0061e 11.96e 0.0025e 12.95e 0.0026e 13.95e 0.0010e 14.94e 0.0005e 15.94e 0.0027e 16.94e 0.0031e 17.93e 0.0037e 18.92e 0.0019e 19.92e 0.0034e 20.92e 0.0087e 21.92e 0.0034e 22.91e 0.0029e 23.91e 0.0024e 24.90e 0.0006e 25.90e 0.0002e 26.90e 0.0009e 27.90e 0.0003e 28.90e 0.0015e 29.89e 0.0011e 30.89e 0.0004e 31.88e 0.0001e ] constant ssax-gs4

vct[ 1.00e 0.0568e 1.99e 0.1275e 2.98e 0.0496e 3.98e 0.0504e 4.97e 0.0277e 5.96e 0.0064e 6.95e 0.0205e 7.95e 0.0244e 8.94e 0.0067e 9.93e 0.0133e 10.92e 0.0045e 11.92e 0.0035e 12.91e 0.0028e 13.90e 0.0010e 14.90e 0.0011e 15.89e 0.0035e 16.89e 0.0034e 17.88e 0.0037e 18.87e 0.0052e 19.86e 0.0027e 20.86e 0.0028e 21.86e 0.0003e 22.84e 0.0011e 23.84e 0.0005e 24.83e 0.0010e 25.82e 0.0005e 26.81e 0.0003e 27.81e 0.0007e 28.80e 0.0005e 29.79e 0.0004e ] constant ssax-a4

vct[ 0.99e 0.0497e 1.98e 0.0814e 2.97e 0.0351e 3.96e 0.0207e 4.95e 0.0068e 5.93e 0.0241e 6.92e 0.0219e 7.91e 0.0187e 8.90e 0.0053e 9.88e 0.0026e 10.88e 0.0026e 11.87e 0.0027e 12.85e 0.0011e 13.85e 0.0018e 14.84e 0.0029e 15.84e 0.0013e 16.83e 0.0014e 17.81e 0.0036e 18.80e 0.0042e 19.79e 0.0015e 20.78e 0.0021e 21.77e 0.0018e 22.76e 0.0011e 23.75e 0.0004e 24.66e 0.0003e 25.73e 0.0006e 26.72e 0.0005e 27.71e 0.0002e ] constant ssax-as4

vct[ 0.99e 0.0161e 1.98e 0.0825e 2.96e 0.0846e 3.95e 0.0304e 4.94e 0.0112e 5.93e 0.0158e 6.91e 0.0362e 7.90e 0.0085e 8.89e 0.0147e 9.87e 0.0047e 10.85e 0.0016e 11.85e 0.0044e 12.84e 0.0024e 13.83e 0.0044e 14.82e 0.0015e 15.80e 0.0066e 16.79e 0.0061e 17.78e 0.0135e 18.77e 0.0107e 19.75e 0.0020e 20.75e 0.0008e 21.73e 0.0010e 22.71e 0.0014e 23.70e 0.0007e 24.69e 0.0009e 25.68e 0.0008e 26.67e 0.0002e ] constant ssax-b4

vct[ 1.00e 0.1378e 1.99e 0.1932e 2.99e 0.0181e 3.98e 0.0213e 4.97e 0.0472e 5.97e 0.0302e 6.97e 0.0099e 7.96e 0.0039e 8.96e 0.0052e 9.95e 0.0031e 10.95e 0.0007e 11.94e 0.0010e 12.93e 0.0015e 13.93e 0.0009e 14.93e 0.0013e 15.92e 0.0018e 16.92e 0.0015e 17.91e 0.0030e 18.91e 0.0013e 19.90e 0.0008e 20.90e 0.0008e 21.89e 0.0006e 22.89e 0.0006e 23.89e 0.0003e ] constant ssax-c5

vct[ 0.99e 0.1332e 1.97e 0.2232e 2.96e 0.1240e 3.95e 0.0080e 4.94e 0.0398e 5.93e 0.0194e 6.92e 0.0059e 7.90e 0.0022e 8.91e 0.0008e 9.88e 0.0017e 10.87e 0.0005e 11.85e 0.0004e 12.84e 0.0008e 13.83e 0.0009e 14.82e 0.0032e 15.81e 0.0009e 16.81e 0.0017e 17.78e 0.0009e 18.77e 0.0003e 19.76e 0.0002e 20.75e 0.0006e 21.74e 0.0004e 22.73e 0.0002e ] constant ssax-cs5

vct[ 0.99e 0.1242e 1.98e 0.0414e 2.97e 0.0487e 3.96e 0.0182e 4.95e 0.0225e 5.94e 0.0112e 6.93e 0.0012e 7.92e 0.0035e 8.87e 0.0004e 9.90e 0.0011e 10.89e 0.0006e 11.88e 0.0004e 12.81e 0.0008e 13.87e 0.0011e 14.86e 0.0015e 15.84e 0.0005e 16.83e 0.0002e 17.82e 0.0005e 18.46e 0.0002e 19.82e 0.0002e 20.81e 0.0002e 21.66e 0.0001e ] constant ssax-d5

vct[ 0.99e 0.1419e 1.98e 0.0180e 2.98e 0.0683e 3.96e 0.0172e 4.95e 0.0329e 5.94e 0.0093e 6.93e 0.0017e 7.91e 0.0014e 8.91e 0.0022e 9.90e 0.0018e 10.88e 0.0004e 11.89e 0.0011e 12.88e 0.0009e 13.87e 0.0010e 14.83e 0.0007e 15.85e 0.0004e 16.85e 0.0002e 17.85e 0.0003e 18.85e 0.0003e 20.81e 0.0001e ] constant ssax-ds5

vct[ 1.00e 0.2435e 1.99e 0.0422e 2.99e 0.0422e 3.98e 0.0137e 4.97e 0.0155e 5.97e 0.0127e 6.96e 0.0024e 7.96e 0.0014e 8.95e 0.0017e 9.95e 0.0011e 10.94e 0.0006e 11.94e 0.0009e 12.93e 0.0022e 13.92e 0.0048e 14.92e 0.0004e 15.91e 0.0006e 16.91e 0.0003e 17.90e 0.0002e 18.89e 0.0002e 19.89e 0.0002e ] constant ssax-e5

vct[ 1.00e 0.2095e 2.00e 0.0502e 3.01e 0.0783e 4.01e 0.0216e 5.01e 0.0293e 6.01e 0.0080e 7.01e 0.0043e 8.02e 0.0036e 9.02e 0.0019e 10.02e 0.0002e 11.02e 0.0013e 12.02e 0.0010e 13.02e 0.0007e 14.03e 0.0010e 15.03e 0.0003e 16.03e 0.0013e 17.04e 0.0009e 18.04e 0.0005e ] constant ssax-f5

vct[ 0.99e 0.1379e 1.98e 0.0339e 2.98e 0.0480e 3.97e 0.0340e 4.96e 0.0264e 5.95e 0.0126e 6.94e 0.0046e 7.93e 0.0030e 8.92e 0.0013e 9.91e 0.0010e 10.90e 0.0009e 11.89e 0.0007e 12.88e 0.0007e 13.88e 0.0018e 14.87e 0.0012e 15.86e 0.0006e 16.85e 0.0004e 17.84e 0.0007e ] constant ssax-fs5

vct[ 0.99e 0.0699e 1.98e 0.0273e 2.96e 0.0227e 3.95e 0.0133e 4.94e 0.0151e 5.92e 0.0023e 6.92e 0.0024e 7.91e 0.0011e 8.90e 0.0009e 9.89e 0.0018e 10.87e 0.0009e 11.88e 0.0016e 12.86e 0.0007e 13.84e 0.0008e 14.83e 0.0007e 15.82e 0.0005e 16.81e 0.0003e ] constant ssax-g5

vct[ 1.00e 0.1830e 1.99e 0.0897e 2.99e 0.0456e 3.99e 0.0296e 4.99e 0.0125e 5.98e 0.0059e 6.98e 0.0105e 7.98e 0.0027e 8.97e 0.0044e 9.97e 0.0096e 10.97e 0.0011e 11.97e 0.0027e 12.97e 0.0006e 13.97e 0.0024e 14.96e 0.0014e 15.95e 0.0002e ] constant ssax-gs5

vct[ 0.99e 0.2010e 1.98e 0.0677e 2.97e 0.0195e 3.97e 0.0363e 4.96e 0.0191e 5.95e 0.0092e 6.94e 0.0047e 7.93e 0.0021e 7.96e 0.0004e 8.91e 0.0004e 9.92e 0.0039e 10.90e 0.0023e 11.91e 0.0005e 12.88e 0.0008e 12.91e 0.0002e 13.86e 0.0002e 14.87e 0.0007e ] constant ssax-a5

vct[ 1.00e 0.1011e 1.99e 0.0696e 2.99e 0.0359e 3.98e 0.0008e 4.99e 0.0111e 5.98e 0.0027e 6.98e 0.0005e 7.98e 0.0038e 8.98e 0.0032e 9.98e 0.0037e 10.97e 0.0024e 11.97e 0.0012e 12.97e 0.0009e 13.97e 0.0004e ] constant ssax-as5

vct[ 0.98e 0.0933e 1.95e 0.0632e 2.93e 0.0226e 4.89e 0.0036e 5.86e 0.0133e 6.84e 0.0018e 7.82e 0.0036e 8.79e 0.0037e 9.77e 0.0111e 10.75e 0.0011e 11.72e 0.0009e 12.70e 0.0013e ] constant ssax-b5

vct[ 1.01e 0.0218e 1.98e 0.0033e 3.00e 0.0037e 3.99e 0.0010e 4.03e 0.0009e 4.77e 0.0002e 4.95e 0.0002e 6.01e 0.0001e 7.00e 0.0002e 8.02e 0.0004e 9.03e 0.0004e 10.03e 0.0003e 12.03e 0.0001e ] constant ssax-c6

vct[ 0.99e 0.1143e 1.99e 0.0478e 2.99e 0.0259e 3.97e 0.0101e 4.97e 0.0058e 5.96e 0.0010e 6.95e 0.0012e 7.98e 0.0017e 8.95e 0.0024e 8.98e 0.0016e 9.96e 0.0007e 10.93e 0.0019e 10.96e 0.0010e 11.90e 0.0003e 11.95e 0.0002e ] constant ssax-cs6

vct[ 1.01e 0.0247e 2.02e 0.0062e 3.02e 0.0036e 4.03e 0.0052e 5.05e 0.0006e 6.07e 0.0004e 7.06e 0.0013e 8.07e 0.0027e 11.11e 0.0001e ] constant ssax-d6

\ **********************************************************
\
\ **********************************************************

vct[ 1.01e 0.0028e 2.00e 0.0192e 3.04e 0.0188e 4.02e 0.0134e 5.02e 0.0319e 6.05e 0.0335e 7.04e 0.0136e 8.06e 0.0074e 9.07e 0.0527e 10.06e 0.0217e 11.05e 0.0025e 12.09e 0.0068e 13.08e 0.0278e 14.10e 0.0125e 15.09e 0.0152e 16.13e 0.0101e 17.13e 0.0088e 18.11e 0.0094e 19.14e 0.0084e 20.20e 0.0008e 21.13e 0.0031e 22.16e 0.0097e 23.14e 0.0053e 24.17e 0.0030e 25.20e 0.0013e 26.17e 0.0055e 27.20e 0.0049e 28.19e 0.0040e 29.21e 0.0010e 30.21e 0.0030e 31.20e 0.0032e 32.24e 0.0031e 33.21e 0.0006e 34.23e 0.0015e 35.25e 0.0020e 36.23e 0.0012e 37.25e 0.0010e 38.29e 0.0007e 39.26e 0.0017e 40.29e 0.0014e 41.27e 0.0015e 42.29e 0.0005e 43.32e 0.0012e 44.30e 0.0014e 45.32e 0.0010e 46.32e 0.0005e 47.31e 0.0003e 48.34e 0.0009e 49.32e 0.0005e 50.34e 0.0005e 51.35e 0.0001e 52.35e 0.0005e 53.37e 0.0006e 54.37e 0.0006e 55.38e 0.0001e 56.38e 0.0002e 57.39e 0.0006e 58.41e 0.0005e 59.42e 0.0004e 60.42e 0.0001e 61.43e 0.0004e 62.41e 0.0004e 63.42e 0.0003e 64.45e 0.0002e 65.46e 0.0001e 66.45e 0.0003e 67.48e 0.0003e 68.46e 0.0001e 69.50e 0.0001e 70.49e 0.0004e 71.48e 0.0002e 72.47e 0.0001e 74.52e 0.0002e 75.51e 0.0002e 76.51e 0.0002e 79.55e 0.0002e 80.56e 0.0002e 81.55e 0.0001e 83.58e 0.0002e 84.57e 0.0001e 85.59e 0.0002e 87.60e 0.0002e 88.59e 0.0001e 89.61e 0.0002e 92.62e 0.0001e 93.64e 0.0001e 96.67e 0.0001e 98.69e 0.0001e ] constant tbf-e2

vct[ 0.99e 0.0062e 2.00e 0.0189e 3.01e 0.0059e 4.03e 0.0167e 5.01e 0.0454e 6.01e 0.0190e 7.03e 0.0261e 8.04e 0.0495e 9.04e 0.0195e 10.01e 0.0059e 11.02e 0.0030e 12.05e 0.0247e 13.04e 0.0097e 14.05e 0.0122e 15.04e 0.0076e 16.03e 0.0044e 17.05e 0.0063e 18.06e 0.0045e 19.06e 0.0011e 20.05e 0.0028e 21.07e 0.0056e 22.07e 0.0019e 22.55e 0.0004e 23.17e 0.0001e 24.07e 0.0026e 25.08e 0.0016e 26.10e 0.0017e 27.11e 0.0006e 28.09e 0.0011e 29.10e 0.0014e 30.10e 0.0011e 31.13e 0.0007e 32.12e 0.0006e 33.11e 0.0009e 34.10e 0.0004e 35.15e 0.0002e 36.15e 0.0004e 37.13e 0.0006e 38.11e 0.0004e 39.11e 0.0002e 40.15e 0.0003e 41.13e 0.0004e 42.13e 0.0003e 43.17e 0.0002e 44.20e 0.0002e 45.16e 0.0002e 46.18e 0.0003e 48.16e 0.0001e 49.20e 0.0002e 50.20e 0.0002e 51.21e 0.0001e 54.20e 0.0001e ] constant tbf-f2

vct[ 1.02e 0.0056e 2.01e 0.0355e 3.01e 0.0221e 3.99e 0.0130e 4.99e 0.0606e 6.00e 0.0189e 7.01e 0.0127e 8.02e 0.0612e 9.01e 0.0211e 10.01e 0.0079e 10.99e 0.0134e 11.99e 0.0205e 13.00e 0.0282e 14.03e 0.0114e 15.02e 0.0079e 16.01e 0.0116e 17.00e 0.0082e 18.02e 0.0015e 19.00e 0.0052e 20.03e 0.0082e 21.03e 0.0057e 22.05e 0.0011e 23.02e 0.0048e 24.01e 0.0035e 25.01e 0.0032e 26.02e 0.0012e 27.04e 0.0033e 28.01e 0.0015e 29.03e 0.0013e 30.05e 0.0008e 31.03e 0.0024e 32.02e 0.0010e 33.02e 0.0007e 34.05e 0.0007e 35.05e 0.0013e 36.04e 0.0008e 37.03e 0.0004e 38.02e 0.0004e 39.03e 0.0008e 40.03e 0.0005e 42.07e 0.0005e 43.05e 0.0006e 44.05e 0.0003e 45.10e 0.0002e 46.05e 0.0003e 47.05e 0.0003e 48.05e 0.0002e 50.08e 0.0003e 51.07e 0.0003e 52.06e 0.0002e 53.09e 0.0001e 54.00e 0.0001e 55.06e 0.0002e 56.09e 0.0002e 57.10e 0.0001e 58.08e 0.0001e 59.05e 0.0001e 60.09e 0.0001e 62.09e 0.0001e 63.06e 0.0001e 66.13e 0.0001e ] constant tbf-fs2

vct[ 0.99e 0.0059e 1.98e 0.0515e 2.98e 0.0305e 3.98e 0.0081e 4.97e 0.0448e 5.98e 0.0160e 6.97e 0.0397e 7.97e 0.0418e 8.93e 0.0079e 9.96e 0.0086e 10.95e 0.0358e 11.96e 0.0207e 12.94e 0.0116e 13.94e 0.0070e 14.93e 0.0156e 15.94e 0.0120e 16.98e 0.0013e 17.94e 0.0060e 18.91e 0.0074e 19.94e 0.0070e 20.94e 0.0013e 21.92e 0.0060e 22.91e 0.0043e 23.89e 0.0014e 24.95e 0.0017e 25.91e 0.0031e 26.90e 0.0022e 27.90e 0.0009e 28.91e 0.0017e 29.89e 0.0016e 30.88e 0.0012e 31.86e 0.0004e 32.88e 0.0013e 33.89e 0.0008e 34.85e 0.0005e 35.83e 0.0005e 36.85e 0.0008e 37.87e 0.0006e 38.87e 0.0001e 39.86e 0.0004e 40.90e 0.0008e 41.86e 0.0005e 42.88e 0.0003e 43.86e 0.0005e 44.84e 0.0005e 45.89e 0.0003e 46.92e 0.0002e 47.86e 0.0003e 48.77e 0.0002e 49.85e 0.0002e 50.86e 0.0002e 51.81e 0.0003e 52.88e 0.0001e 53.87e 0.0001e 54.80e 0.0002e 55.77e 0.0001e 56.88e 0.0002e 58.76e 0.0001e 59.82e 0.0001e 62.83e 0.0001e 63.88e 0.0001e 73.81e 0.0001e ] constant tbf-g2

vct[ 0.99e 0.0058e 1.98e 0.0327e 2.99e 0.0282e 3.99e 0.0353e 4.98e 0.0348e 5.96e 0.0451e 6.97e 0.0549e 7.97e 0.0183e 8.96e 0.0096e 9.94e 0.0221e 10.94e 0.0110e 11.93e 0.0102e 12.92e 0.0074e 13.92e 0.0109e 14.91e 0.0080e 15.15e 0.0013e 15.91e 0.0003e 16.90e 0.0034e 17.88e 0.0030e 18.88e 0.0036e 19.14e 0.0004e 20.05e 0.0003e 20.86e 0.0029e 21.87e 0.0014e 22.84e 0.0008e 23.85e 0.0021e 24.83e 0.0011e 25.81e 0.0007e 26.80e 0.0003e 27.81e 0.0010e 28.82e 0.0003e 29.84e 0.0003e 30.77e 0.0006e 31.75e 0.0002e 32.78e 0.0005e 33.79e 0.0003e 34.77e 0.0003e 35.78e 0.0003e 37.75e 0.0002e 38.72e 0.0002e 41.75e 0.0001e 42.73e 0.0001e 45.69e 0.0001e ] constant tbf-gs2

vct[ 1.00e 0.0085e 1.99e 0.0291e 2.99e 0.0151e 4.00e 0.0554e 5.00e 0.0164e 6.02e 0.0087e 7.00e 0.0365e 8.06e 0.0023e 9.02e 0.0098e 9.98e 0.0165e 10.97e 0.0176e 11.97e 0.0107e 12.98e 0.0081e 13.97e 0.0077e 14.97e 0.0012e 15.99e 0.0038e 16.98e 0.0028e 17.97e 0.0017e 18.97e 0.0024e 19.98e 0.0014e 20.95e 0.0017e 21.92e 0.0009e 23.01e 0.0009e 23.98e 0.0006e 24.94e 0.0004e 25.95e 0.0013e 26.95e 0.0003e 27.99e 0.0002e 28.97e 0.0006e 29.96e 0.0002e 30.90e 0.0003e 31.89e 0.0003e 32.83e 0.0002e 33.02e 0.0001e 33.78e 0.0001e 34.94e 0.0001e 35.94e 0.0002e 38.91e 0.0002e 39.88e 0.0001e ] constant tbf-a2

vct[ 1.00e 0.0251e 2.05e 0.0009e 3.02e 0.0385e 4.03e 0.0997e 5.03e 0.0337e 6.04e 0.1061e 7.04e 0.0539e 8.05e 0.0357e 9.06e 0.0635e 10.06e 0.0233e 11.05e 0.0153e 12.07e 0.0218e 13.07e 0.0235e 14.08e 0.0092e 15.08e 0.0135e 16.09e 0.0104e 17.09e 0.0055e 18.10e 0.0130e 19.11e 0.0059e 20.12e 0.0030e 21.12e 0.0060e 22.12e 0.0029e 23.12e 0.0032e 24.13e 0.0022e 25.14e 0.0016e 26.14e 0.0007e 27.15e 0.0032e 28.15e 0.0014e 29.16e 0.0012e 30.15e 0.0015e 31.18e 0.0011e 32.19e 0.0008e 33.18e 0.0014e 34.19e 0.0007e 35.19e 0.0003e 36.18e 0.0009e 37.16e 0.0004e 39.21e 0.0007e 40.22e 0.0006e 41.23e 0.0001e 42.20e 0.0004e 43.24e 0.0007e 45.25e 0.0007e 46.26e 0.0004e 47.32e 0.0001e 48.26e 0.0004e 49.26e 0.0003e 51.29e 0.0003e 52.28e 0.0002e 54.30e 0.0003e 55.32e 0.0002e 57.31e 0.0002e 58.32e 0.0001e 60.31e 0.0002e 61.30e 0.0001e 63.35e 0.0001e 64.34e 0.0001e 66.37e 0.0001e ] constant tbf-as2

vct[ 1.02e 0.0294e 2.03e 0.0276e 3.03e 0.0170e 4.05e 0.0409e 5.06e 0.0434e 6.06e 0.0552e 7.06e 0.0128e 8.08e 0.0076e 9.07e 0.0216e 10.08e 0.0169e 11.07e 0.0035e 12.09e 0.0094e 13.10e 0.0046e 14.12e 0.0021e 15.12e 0.0059e 16.13e 0.0023e 17.15e 0.0039e 18.16e 0.0035e 19.17e 0.0015e 20.18e 0.0020e 21.19e 0.0023e 22.19e 0.0005e 23.22e 0.0022e 24.24e 0.0010e 25.27e 0.0006e 26.26e 0.0008e 27.27e 0.0010e 28.28e 0.0003e 29.28e 0.0006e 30.27e 0.0005e 31.32e 0.0003e 32.30e 0.0004e 33.29e 0.0004e 35.37e 0.0004e 36.34e 0.0002e 37.38e 0.0002e 38.38e 0.0003e 39.48e 0.0002e 41.43e 0.0003e 42.40e 0.0001e 44.50e 0.0001e 45.47e 0.0001e 47.46e 0.0001e ] constant tbf-b2

vct[ 1.01e 0.0167e 2.00e 0.0116e 3.00e 0.0033e 3.99e 0.0432e 5.01e 0.0116e 6.00e 0.0573e 7.00e 0.0128e 8.00e 0.0582e 9.02e 0.0354e 10.01e 0.0203e 11.00e 0.0226e 12.00e 0.0167e 13.03e 0.0055e 14.02e 0.0174e 15.01e 0.0088e 16.01e 0.0083e 17.03e 0.0066e 18.03e 0.0022e 19.01e 0.0058e 20.01e 0.0049e 21.03e 0.0016e 22.03e 0.0053e 23.03e 0.0028e 24.01e 0.0013e 25.03e 0.0028e 26.03e 0.0015e 27.00e 0.0003e 28.02e 0.0026e 28.39e 0.0002e 29.70e 0.0002e 30.03e 0.0014e 31.03e 0.0010e 32.04e 0.0007e 33.03e 0.0010e 34.03e 0.0007e 35.04e 0.0004e 36.03e 0.0009e 37.03e 0.0004e 38.05e 0.0006e 39.04e 0.0008e 40.03e 0.0003e 41.04e 0.0004e 42.04e 0.0005e 43.06e 0.0003e 44.02e 0.0004e 45.03e 0.0002e 46.08e 0.0001e 47.05e 0.0004e 48.03e 0.0002e 49.06e 0.0001e 50.05e 0.0003e 51.06e 0.0002e 52.07e 0.0002e 53.04e 0.0002e 54.05e 0.0001e 55.05e 0.0002e 56.05e 0.0001e 58.05e 0.0002e 59.06e 0.0001e 61.05e 0.0002e ] constant tbf-c3

vct[ 1.00e 0.0192e 1.98e 0.0300e 2.99e 0.0565e 3.98e 0.0329e 4.97e 0.0791e 5.98e 0.0457e 6.96e 0.0053e 7.95e 0.0405e 8.96e 0.0260e 9.95e 0.0146e 10.93e 0.0283e 11.95e 0.0038e 12.93e 0.0205e 13.92e 0.0086e 14.93e 0.0028e 15.91e 0.0069e 16.91e 0.0030e 17.91e 0.0095e 18.89e 0.0058e 19.90e 0.0023e 20.89e 0.0048e 21.87e 0.0015e 22.89e 0.0033e 23.88e 0.0021e 24.87e 0.0003e 25.87e 0.0030e 26.86e 0.0014e 27.85e 0.0016e 28.86e 0.0021e 29.85e 0.0005e 30.83e 0.0019e 31.84e 0.0014e 32.83e 0.0005e 33.82e 0.0012e 34.82e 0.0006e 35.81e 0.0008e 36.82e 0.0011e 37.81e 0.0004e 38.78e 0.0004e 39.80e 0.0005e 40.79e 0.0004e 41.77e 0.0007e 42.77e 0.0002e 43.78e 0.0004e 44.76e 0.0005e 45.77e 0.0003e 46.76e 0.0003e 47.75e 0.0002e 48.75e 0.0002e 49.75e 0.0005e 50.74e 0.0002e 51.73e 0.0002e 52.73e 0.0002e 53.72e 0.0002e 54.73e 0.0003e 55.70e 0.0001e 56.70e 0.0001e 57.71e 0.0003e 58.71e 0.0001e 59.70e 0.0002e 60.70e 0.0001e 61.69e 0.0002e 62.69e 0.0003e 64.67e 0.0001e 65.67e 0.0001e 67.64e 0.0001e 69.65e 0.0001e 70.63e 0.0001e 75.62e 0.0001e ] constant tbf-cs3

vct[ 1.01e 0.0462e 2.01e 0.0592e 3.00e 0.1127e 3.99e 0.0398e 5.00e 0.1221e 6.02e 0.0099e 7.01e 0.0396e 8.01e 0.0429e 9.00e 0.0249e 10.00e 0.0223e 10.27e 0.0015e 11.03e 0.0010e 12.01e 0.0146e 13.01e 0.0097e 14.00e 0.0008e 15.00e 0.0064e 16.01e 0.0020e 17.02e 0.0066e 18.02e 0.0043e 19.02e 0.0021e 20.01e 0.0035e 21.02e 0.0009e 22.02e 0.0022e 23.03e 0.0022e 24.00e 0.0007e 25.02e 0.0025e 26.02e 0.0002e 27.03e 0.0017e 27.30e 0.0003e 28.73e 0.0002e 29.03e 0.0016e 30.02e 0.0012e 31.02e 0.0006e 32.04e 0.0013e 33.04e 0.0005e 34.02e 0.0006e 35.01e 0.0004e 36.03e 0.0007e 37.03e 0.0009e 38.05e 0.0003e 39.05e 0.0006e 40.04e 0.0003e 41.04e 0.0003e 42.04e 0.0005e 43.05e 0.0002e 44.06e 0.0003e 45.05e 0.0001e 46.05e 0.0002e 47.04e 0.0003e 48.06e 0.0002e 49.06e 0.0003e 50.06e 0.0001e 51.06e 0.0001e 52.04e 0.0001e 53.06e 0.0001e 54.06e 0.0002e 57.06e 0.0001e 58.07e 0.0001e 59.06e 0.0002e 66.09e 0.0001e ] constant tbf-d3

vct[ 1.00e 0.0462e 2.01e 0.0546e 3.03e 0.1220e 4.04e 0.0672e 5.06e 0.0575e 6.07e 0.0310e 7.08e 0.0402e 8.09e 0.0228e 9.09e 0.0345e 10.10e 0.0204e 11.11e 0.0134e 12.12e 0.0171e 13.13e 0.0056e 14.15e 0.0087e 15.16e 0.0035e 16.17e 0.0068e 17.18e 0.0027e 18.18e 0.0061e 19.20e 0.0018e 20.20e 0.0037e 21.22e 0.0030e 22.24e 0.0013e 23.24e 0.0028e 23.58e 0.0004e 24.91e 0.0002e 25.26e 0.0031e 26.26e 0.0008e 27.27e 0.0022e 28.28e 0.0021e 29.29e 0.0013e 30.31e 0.0017e 31.31e 0.0006e 32.34e 0.0015e 33.34e 0.0008e 34.35e 0.0012e 35.36e 0.0012e 36.36e 0.0008e 37.37e 0.0012e 38.38e 0.0006e 39.40e 0.0008e 40.39e 0.0002e 41.43e 0.0004e 42.44e 0.0003e 43.45e 0.0004e 44.45e 0.0004e 45.45e 0.0004e 46.46e 0.0006e 47.46e 0.0002e 48.48e 0.0004e 49.47e 0.0002e 50.52e 0.0003e 51.52e 0.0002e 52.53e 0.0003e 53.53e 0.0003e 54.54e 0.0002e 55.55e 0.0003e 57.58e 0.0002e 58.58e 0.0001e 59.60e 0.0002e 60.60e 0.0002e 61.62e 0.0002e 62.63e 0.0002e 63.62e 0.0001e 64.64e 0.0002e 66.67e 0.0001e 68.68e 0.0001e 69.70e 0.0001e 71.70e 0.0001e ] constant tbf-ds3

vct[ 1.00e 0.0427e 2.02e 0.0329e 3.03e 0.0739e 4.03e 0.0442e 5.05e 0.0547e 6.06e 0.0547e 7.06e 0.0357e 8.07e 0.0307e 9.09e 0.0344e 10.10e 0.0088e 11.10e 0.0255e 12.12e 0.0049e 13.13e 0.0161e 14.13e 0.0032e 15.14e 0.0087e 16.16e 0.0028e 17.15e 0.0054e 18.17e 0.0018e 19.18e 0.0048e 20.20e 0.0025e 21.19e 0.0033e 22.21e 0.0032e 23.22e 0.0009e 24.22e 0.0017e 25.25e 0.0004e 26.24e 0.0011e 26.54e 0.0002e 27.27e 0.0002e 28.26e 0.0012e 28.54e 0.0002e 29.26e 0.0001e 30.29e 0.0009e 31.29e 0.0003e 32.30e 0.0007e 33.32e 0.0005e 34.32e 0.0007e 35.32e 0.0005e 36.35e 0.0004e 37.36e 0.0004e 38.38e 0.0002e 39.37e 0.0004e 41.39e 0.0004e 42.42e 0.0001e 43.40e 0.0002e 45.43e 0.0002e 47.45e 0.0002e 48.45e 0.0001e 49.46e 0.0001e 50.48e 0.0002e 51.49e 0.0001e 52.49e 0.0001e 54.52e 0.0001e 56.54e 0.0001e ] constant tbf-e3

vct[ 1.01e 0.0430e 2.02e 0.0658e 3.02e 0.0533e 4.02e 0.1351e 5.04e 0.0653e 6.03e 0.0900e 7.05e 0.0410e 8.05e 0.0344e 9.07e 0.0169e 10.07e 0.0220e 11.08e 0.0159e 12.08e 0.0180e 13.08e 0.0045e 14.09e 0.0098e 15.08e 0.0023e 16.10e 0.0022e 17.12e 0.0040e 18.12e 0.0030e 19.13e 0.0031e 20.14e 0.0014e 21.14e 0.0019e 22.15e 0.0012e 23.16e 0.0015e 24.16e 0.0007e 25.16e 0.0010e 26.17e 0.0009e 27.19e 0.0009e 28.19e 0.0004e 29.20e 0.0009e 30.19e 0.0002e 31.21e 0.0007e 32.23e 0.0003e 33.23e 0.0005e 35.24e 0.0004e 36.33e 0.0001e 37.25e 0.0003e 38.26e 0.0002e 39.27e 0.0003e 41.29e 0.0002e 42.29e 0.0001e 43.30e 0.0002e 45.31e 0.0001e 46.33e 0.0001e ] constant tbf-f3

vct[ 1.00e 0.0676e 1.99e 0.0337e 3.00e 0.0651e 4.00e 0.0928e 4.99e 0.0773e 6.00e 0.0359e 6.99e 0.0266e 7.99e 0.0183e 9.00e 0.0246e 9.99e 0.0092e 10.98e 0.0144e 11.99e 0.0027e 12.98e 0.0112e 13.98e 0.0019e 14.99e 0.0058e 15.97e 0.0010e 16.97e 0.0024e 17.98e 0.0033e 18.97e 0.0025e 19.97e 0.0024e 20.98e 0.0018e 21.97e 0.0030e 22.98e 0.0013e 23.97e 0.0026e 24.19e 0.0004e 24.97e 0.0003e 25.97e 0.0026e 26.96e 0.0003e 27.96e 0.0018e 28.97e 0.0006e 29.96e 0.0012e 30.96e 0.0012e 31.97e 0.0011e 32.96e 0.0012e 33.95e 0.0006e 34.96e 0.0008e 35.95e 0.0003e 36.95e 0.0009e 37.95e 0.0002e 38.95e 0.0005e 39.95e 0.0002e 40.95e 0.0005e 41.95e 0.0003e 42.95e 0.0005e 43.95e 0.0002e 44.94e 0.0003e 45.95e 0.0003e 46.94e 0.0001e 47.94e 0.0002e 49.94e 0.0003e 50.94e 0.0001e 51.94e 0.0003e 53.93e 0.0002e 55.93e 0.0002e 56.93e 0.0001e 57.93e 0.0002e 58.93e 0.0001e 59.93e 0.0001e 60.93e 0.0001e 62.93e 0.0001e 64.91e 0.0001e ] constant tbf-fs3

vct[ 1.01e 0.1108e 2.02e 0.0159e 3.03e 0.0749e 4.03e 0.0774e 5.05e 0.0554e 6.06e 0.0287e 7.06e 0.0529e 8.08e 0.0167e 9.09e 0.0172e 10.09e 0.0181e 11.10e 0.0072e 12.12e 0.0148e 13.11e 0.0028e 14.13e 0.0060e 15.14e 0.0012e 16.14e 0.0047e 17.15e 0.0034e 18.17e 0.0009e 19.17e 0.0041e 20.18e 0.0007e 21.20e 0.0016e 22.20e 0.0011e 23.21e 0.0022e 24.23e 0.0010e 25.24e 0.0008e 26.24e 0.0015e 27.25e 0.0003e 28.26e 0.0011e 29.26e 0.0009e 30.28e 0.0009e 31.29e 0.0007e 32.29e 0.0002e 33.31e 0.0005e 34.32e 0.0001e 35.32e 0.0006e 36.33e 0.0002e 37.35e 0.0003e 38.34e 0.0004e 40.37e 0.0003e 42.39e 0.0002e 43.40e 0.0002e 44.40e 0.0001e 45.41e 0.0002e 47.44e 0.0002e 50.47e 0.0001e 52.48e 0.0001e 54.49e 0.0001e ] constant tbf-g3

vct[ 1.01e 0.0962e 2.01e 0.0925e 3.01e 0.0770e 4.03e 0.0479e 5.03e 0.1190e 6.03e 0.0237e 7.03e 0.0168e 8.05e 0.0283e 9.05e 0.0100e 10.05e 0.0292e 11.06e 0.0097e 12.07e 0.0103e 13.07e 0.0121e 14.07e 0.0042e 15.08e 0.0012e 16.09e 0.0051e 17.09e 0.0023e 18.09e 0.0058e 19.11e 0.0009e 20.11e 0.0029e 21.11e 0.0028e 22.12e 0.0011e 23.13e 0.0028e 24.12e 0.0013e 25.13e 0.0016e 26.14e 0.0014e 27.14e 0.0009e 28.15e 0.0016e 29.16e 0.0007e 30.16e 0.0007e 31.16e 0.0010e 32.17e 0.0004e 33.18e 0.0006e 34.18e 0.0005e 35.18e 0.0003e 36.19e 0.0006e 37.20e 0.0003e 38.20e 0.0003e 39.21e 0.0004e 40.22e 0.0002e 41.22e 0.0004e 42.23e 0.0001e 43.23e 0.0002e 44.24e 0.0002e 46.25e 0.0003e 47.25e 0.0001e 48.26e 0.0002e 49.26e 0.0001e 51.28e 0.0001e 54.29e 0.0001e ] constant tbf-gs3

vct[ 0.99e 0.0880e 1.99e 0.1784e 2.99e 0.0966e 3.99e 0.0789e 4.99e 0.0440e 5.99e 0.0574e 6.99e 0.0067e 7.99e 0.0384e 8.98e 0.0270e 9.98e 0.0089e 10.97e 0.0152e 11.97e 0.0039e 12.97e 0.0092e 13.97e 0.0081e 14.97e 0.0020e 15.97e 0.0030e 16.96e 0.0051e 17.96e 0.0014e 18.96e 0.0031e 19.96e 0.0026e 20.95e 0.0004e 21.95e 0.0028e 22.95e 0.0006e 23.94e 0.0012e 24.94e 0.0021e 25.94e 0.0009e 26.94e 0.0010e 27.94e 0.0010e 28.94e 0.0006e 29.94e 0.0008e 30.93e 0.0009e 31.93e 0.0001e 32.92e 0.0007e 33.92e 0.0005e 34.91e 0.0002e 35.92e 0.0005e 36.91e 0.0003e 37.92e 0.0002e 38.92e 0.0004e 40.91e 0.0002e 41.90e 0.0002e 43.89e 0.0002e 44.89e 0.0002e 46.89e 0.0001e 49.89e 0.0001e 52.88e 0.0001e ] constant tbf-a3

vct[ 1.00e 0.0084e 2.02e 0.2204e 3.02e 0.1914e 4.03e 0.0999e 5.03e 0.0302e 6.04e 0.0574e 7.04e 0.0432e 8.05e 0.0168e 9.05e 0.0414e 10.06e 0.0213e 11.06e 0.0024e 12.07e 0.0063e 13.08e 0.0058e 14.08e 0.0014e 15.09e 0.0031e 16.09e 0.0067e 17.10e 0.0026e 18.10e 0.0026e 19.11e 0.0039e 20.11e 0.0016e 21.12e 0.0015e 22.12e 0.0032e 23.13e 0.0017e 24.13e 0.0010e 25.14e 0.0020e 26.14e 0.0016e 27.15e 0.0002e 28.16e 0.0013e 29.16e 0.0009e 31.17e 0.0009e 32.18e 0.0008e 33.18e 0.0004e 34.19e 0.0005e 35.19e 0.0008e 36.20e 0.0002e 37.20e 0.0004e 38.21e 0.0005e 39.21e 0.0002e 40.22e 0.0002e 41.22e 0.0003e 42.23e 0.0002e 43.23e 0.0001e 44.24e 0.0002e 45.25e 0.0001e 47.26e 0.0002e 48.26e 0.0001e 50.28e 0.0001e 51.28e 0.0001e ] constant tbf-as3

vct[ 1.00e 0.0475e 2.00e 0.1146e 3.01e 0.1513e 4.01e 0.0759e 5.00e 0.0441e 6.01e 0.0348e 7.01e 0.0462e 8.01e 0.0291e 9.02e 0.0056e 10.02e 0.0281e 11.01e 0.0178e 12.02e 0.0016e 13.02e 0.0054e 14.02e 0.0082e 15.03e 0.0051e 16.02e 0.0014e 17.02e 0.0053e 18.03e 0.0050e 19.03e 0.0017e 20.03e 0.0024e 21.04e 0.0037e 22.03e 0.0025e 23.03e 0.0008e 24.04e 0.0028e 25.04e 0.0023e 26.04e 0.0007e 27.04e 0.0007e 28.04e 0.0018e 29.04e 0.0017e 30.05e 0.0003e 31.04e 0.0011e 32.04e 0.0013e 33.05e 0.0004e 34.05e 0.0005e 35.05e 0.0009e 36.06e 0.0007e 37.05e 0.0002e 38.06e 0.0004e 39.06e 0.0006e 40.06e 0.0004e 41.07e 0.0003e 42.06e 0.0005e 43.06e 0.0004e 44.07e 0.0001e 45.07e 0.0003e 46.07e 0.0003e 47.08e 0.0001e 48.07e 0.0001e 49.07e 0.0003e 50.08e 0.0002e 52.08e 0.0001e 53.08e 0.0001e ] constant tbf-b3

vct[ 1.01e 0.0092e 2.01e 0.0918e 3.01e 0.1218e 4.03e 0.1524e 5.03e 0.0561e 6.03e 0.0196e 7.05e 0.0312e 8.05e 0.0481e 9.05e 0.0292e 10.07e 0.0048e 11.07e 0.0035e 12.07e 0.0096e 13.08e 0.0079e 14.09e 0.0040e 15.09e 0.0017e 16.09e 0.0054e 17.11e 0.0080e 18.11e 0.0039e 19.11e 0.0010e 20.13e 0.0034e 21.13e 0.0028e 22.13e 0.0027e 23.14e 0.0004e 24.15e 0.0015e 25.15e 0.0024e 26.16e 0.0021e 27.17e 0.0006e 28.17e 0.0008e 29.17e 0.0013e 30.19e 0.0015e 31.19e 0.0005e 32.19e 0.0002e 33.21e 0.0009e 34.21e 0.0010e 35.21e 0.0006e 36.23e 0.0003e 37.23e 0.0005e 38.23e 0.0009e 39.24e 0.0007e 40.25e 0.0002e 41.25e 0.0004e 42.26e 0.0006e 43.27e 0.0004e 44.27e 0.0002e 45.27e 0.0003e 46.29e 0.0004e 47.29e 0.0003e 48.29e 0.0001e ] constant tbf-c4

vct[ 1.00e 0.0881e 2.00e 0.1170e 3.00e 0.0852e 4.00e 0.0643e 5.00e 0.0778e 6.00e 0.0489e 6.99e 0.0269e 8.00e 0.0107e 8.99e 0.0292e 10.00e 0.0159e 10.99e 0.0082e 12.00e 0.0066e 12.99e 0.0009e 14.00e 0.0050e 14.99e 0.0064e 15.99e 0.0059e 17.00e 0.0044e 17.99e 0.0024e 19.00e 0.0042e 19.99e 0.0040e 21.00e 0.0027e 21.99e 0.0023e 22.99e 0.0018e 23.99e 0.0024e 24.99e 0.0025e 25.99e 0.0019e 26.99e 0.0007e 27.99e 0.0004e 28.99e 0.0012e 29.99e 0.0014e 30.99e 0.0012e 31.99e 0.0004e 32.99e 0.0002e 33.99e 0.0007e 34.98e 0.0009e 35.99e 0.0008e 36.98e 0.0005e 37.99e 0.0002e 38.98e 0.0005e 39.99e 0.0007e 40.98e 0.0007e 41.98e 0.0004e 42.98e 0.0001e 43.98e 0.0003e 44.99e 0.0004e 45.98e 0.0003e ] constant tbf-cs4

vct[ 1.01e 0.1228e 2.02e 0.1247e 3.02e 0.1142e 4.03e 0.0474e 5.04e 0.0335e 6.04e 0.0332e 7.05e 0.0302e 8.06e 0.0222e 9.07e 0.0090e 10.08e 0.0030e 11.09e 0.0027e 12.09e 0.0054e 13.10e 0.0059e 14.10e 0.0040e 15.11e 0.0038e 16.12e 0.0029e 17.13e 0.0011e 18.14e 0.0020e 19.15e 0.0021e 20.15e 0.0023e 21.16e 0.0016e 22.17e 0.0012e 23.17e 0.0008e 24.18e 0.0003e 25.19e 0.0006e 26.20e 0.0008e 27.21e 0.0008e 28.22e 0.0008e 29.22e 0.0004e 30.23e 0.0002e 31.23e 0.0002e 32.24e 0.0003e 33.26e 0.0004e 34.26e 0.0004e 35.27e 0.0004e 36.28e 0.0002e 39.29e 0.0002e 40.30e 0.0002e 41.32e 0.0001e ] constant tbf-d4

vct[ 1.01e 0.1133e 2.01e 0.1562e 3.02e 0.1429e 4.02e 0.0366e 5.02e 0.0219e 6.03e 0.0212e 7.03e 0.0142e 8.04e 0.0216e 9.04e 0.0101e 10.04e 0.0063e 11.05e 0.0076e 12.05e 0.0081e 13.06e 0.0050e 14.06e 0.0030e 15.07e 0.0010e 16.07e 0.0011e 17.07e 0.0019e 18.08e 0.0022e 19.08e 0.0029e 20.09e 0.0028e 21.09e 0.0021e 22.09e 0.0016e 23.10e 0.0016e 24.10e 0.0010e 25.11e 0.0005e 26.11e 0.0003e 27.11e 0.0002e 28.12e 0.0006e 29.12e 0.0004e 30.13e 0.0005e 31.13e 0.0004e 32.13e 0.0006e 33.14e 0.0003e 34.14e 0.0003e 35.15e 0.0002e 37.15e 0.0002e 38.15e 0.0001e 39.16e 0.0002e 40.16e 0.0002e 41.17e 0.0002e ] constant tbf-ds4

vct[ 0.99e 0.0906e 1.99e 0.1338e 2.99e 0.1235e 3.98e 0.0833e 4.98e 0.0601e 5.98e 0.0264e 6.98e 0.0126e 7.97e 0.0051e 8.97e 0.0026e 9.97e 0.0014e 10.96e 0.0018e 11.96e 0.0025e 12.96e 0.0031e 13.96e 0.0021e 14.95e 0.0034e 15.95e 0.0035e 16.95e 0.0037e 17.94e 0.0031e 18.94e 0.0021e 19.93e 0.0021e 20.93e 0.0016e 21.92e 0.0010e 22.92e 0.0012e 23.92e 0.0011e 24.91e 0.0007e 25.91e 0.0004e 26.91e 0.0002e 28.91e 0.0001e 30.89e 0.0001e 31.90e 0.0002e 32.90e 0.0002e 33.89e 0.0002e 34.89e 0.0002e 35.88e 0.0002e 36.88e 0.0002e 37.88e 0.0002e 38.87e 0.0001e ] constant tbf-e4

vct[ 1.01e 0.1228e 2.01e 0.3008e 3.01e 0.1922e 4.01e 0.0927e 5.01e 0.0581e 6.02e 0.0447e 7.02e 0.0207e 8.03e 0.0106e 9.02e 0.0057e 10.02e 0.0018e 11.03e 0.0040e 12.03e 0.0041e 13.04e 0.0040e 14.04e 0.0039e 15.04e 0.0042e 16.04e 0.0034e 17.05e 0.0035e 18.05e 0.0038e 19.06e 0.0033e 20.06e 0.0029e 21.06e 0.0024e 22.06e 0.0020e 23.07e 0.0018e 24.07e 0.0015e 25.07e 0.0012e 26.07e 0.0009e 27.07e 0.0006e 28.08e 0.0005e 29.08e 0.0003e 30.09e 0.0003e 31.10e 0.0003e 32.10e 0.0004e 33.11e 0.0004e 34.11e 0.0004e 35.10e 0.0004e 36.10e 0.0004e 37.11e 0.0003e 38.11e 0.0002e ] constant tbf-f4

vct[ 1.01e 0.0765e 2.01e 0.2561e 3.02e 0.0803e 4.03e 0.0653e 5.03e 0.0230e 6.04e 0.0093e 7.05e 0.0035e 8.05e 0.0042e 9.06e 0.0040e 10.07e 0.0052e 11.07e 0.0056e 12.08e 0.0049e 13.09e 0.0039e 14.09e 0.0035e 15.10e 0.0031e 16.10e 0.0021e 17.11e 0.0012e 18.12e 0.0010e 19.12e 0.0005e 20.13e 0.0003e 21.14e 0.0001e 22.14e 0.0001e 23.15e 0.0003e 24.16e 0.0002e 25.16e 0.0003e 26.17e 0.0003e 27.18e 0.0003e 28.18e 0.0003e 29.19e 0.0003e 30.20e 0.0002e 31.20e 0.0001e ] constant tbf-fs4

vct[ 1.01e 0.0092e 2.02e 0.2167e 3.02e 0.0668e 4.02e 0.0254e 5.03e 0.0210e 6.04e 0.0282e 7.04e 0.0151e 8.05e 0.0130e 9.05e 0.0054e 10.06e 0.0031e 11.07e 0.0014e 12.08e 0.0020e 13.08e 0.0020e 14.09e 0.0020e 15.09e 0.0021e 16.10e 0.0015e 17.10e 0.0007e 18.11e 0.0003e 19.13e 0.0002e 20.13e 0.0004e 21.13e 0.0005e 22.14e 0.0004e 23.14e 0.0003e 24.15e 0.0003e 25.15e 0.0001e 29.18e 0.0001e 30.19e 0.0001e ] constant tbf-g4

vct[ 1.00e 0.1758e 2.01e 0.1249e 3.01e 0.0253e 4.02e 0.0471e 5.02e 0.0478e 6.03e 0.0217e 7.03e 0.0025e 8.04e 0.0044e 9.05e 0.0066e 10.05e 0.0060e 11.05e 0.0030e 12.06e 0.0021e 13.09e 0.0005e 14.07e 0.0008e 15.07e 0.0014e 16.08e 0.0010e 17.08e 0.0005e 18.10e 0.0002e 19.09e 0.0003e 20.10e 0.0003e 21.10e 0.0003e 22.10e 0.0001e 24.13e 0.0001e 25.13e 0.0001e 26.13e 0.0001e ] constant tbf-gs4

vct[ 1.00e 0.3944e 2.01e 0.1441e 3.00e 0.0979e 4.01e 0.0595e 5.01e 0.0218e 6.01e 0.0057e 7.01e 0.0131e 8.01e 0.0053e 9.01e 0.0018e 10.02e 0.0029e 11.01e 0.0042e 12.02e 0.0032e 13.01e 0.0001e 14.02e 0.0014e 15.02e 0.0017e 16.02e 0.0006e 17.03e 0.0003e 18.02e 0.0006e 19.03e 0.0009e 20.03e 0.0003e 21.04e 0.0002e 22.03e 0.0004e 23.03e 0.0004e 25.04e 0.0002e 26.04e 0.0003e 27.04e 0.0001e ] constant tbf-a4

vct[ 1.01e 0.3895e 2.03e 0.1550e 3.03e 0.0985e 4.05e 0.0153e 5.06e 0.0280e 6.07e 0.0103e 7.08e 0.0028e 8.10e 0.0069e 9.10e 0.0023e 10.12e 0.0025e 11.13e 0.0029e 12.14e 0.0011e 13.15e 0.0011e 14.16e 0.0009e 15.17e 0.0002e 16.19e 0.0007e 17.20e 0.0004e 18.22e 0.0002e 19.22e 0.0003e 20.23e 0.0001e 22.26e 0.0001e ] constant tbf-as4

vct[ 1.00e 0.2165e 2.01e 0.1597e 3.00e 0.0717e 4.01e 0.0353e 5.01e 0.0332e 6.01e 0.0024e 7.01e 0.0088e 8.02e 0.0009e 9.02e 0.0039e 10.02e 0.0016e 11.02e 0.0015e 12.02e 0.0014e 13.03e 0.0003e 14.03e 0.0007e 16.03e 0.0004e 17.04e 0.0002e 18.03e 0.0002e 19.04e 0.0001e ] constant tbf-b4

vct[ 1.01e 0.1699e 2.01e 0.2670e 3.03e 0.0349e 4.03e 0.0454e 5.05e 0.0024e 6.05e 0.0069e 7.06e 0.0021e 8.07e 0.0015e 9.08e 0.0011e 10.09e 0.0007e 11.09e 0.0007e 12.10e 0.0001e 13.11e 0.0004e 15.13e 0.0002e ] constant tbf-c5

vct[ 1.00e 0.2017e 2.00e 0.0920e 3.00e 0.0598e 3.99e 0.0086e 4.99e 0.0120e 5.99e 0.0063e 6.99e 0.0034e 7.99e 0.0029e 8.99e 0.0008e 9.99e 0.0014e 10.98e 0.0008e 11.97e 0.0007e 12.98e 0.0006e 13.96e 0.0001e 14.97e 0.0003e 15.97e 0.0001e ] constant tbf-cs5

\ **********************************************************
\
\ **********************************************************

vct[ 1.00e 0.0179e 2.00e 0.0770e 2.99e 0.0532e 3.99e 0.0183e 4.97e 0.0494e 5.98e 0.0137e 6.95e 0.0121e 7.97e 0.0153e 8.94e 0.0012e 9.96e 0.0040e 10.97e 0.0030e 11.93e 0.0021e 12.93e 0.0034e 13.94e 0.0007e 14.91e 0.0004e 16.01e 0.0002e 16.93e 0.0003e 17.92e 0.0008e 18.94e 0.0004e 19.96e 0.0002e 21.00e 0.0001e 22.95e 0.0001e 25.89e 0.0001e ] constant tbp-e2

vct[ 0.99e 0.0137e 2.01e 0.0473e 3.03e 0.0362e 4.01e 0.0117e 5.02e 0.0565e 6.04e 0.0247e 7.06e 0.0348e 8.04e 0.0251e 9.05e 0.0143e 10.07e 0.0146e 11.09e 0.0020e 12.07e 0.0048e 13.09e 0.0013e 14.12e 0.0012e 15.12e 0.0009e 16.12e 0.0004e 17.10e 0.0010e 18.11e 0.0003e 19.13e 0.0004e 20.13e 0.0001e 22.14e 0.0001e 24.17e 0.0001e ] constant tbp-f2

vct[ 1.02e 0.0110e 2.02e 0.0470e 3.02e 0.0038e 4.02e 0.0343e 5.01e 0.0442e 6.02e 0.0198e 7.01e 0.0600e 8.02e 0.0144e 9.05e 0.0468e 10.05e 0.0112e 11.05e 0.0137e 12.05e 0.0078e 13.05e 0.0041e 14.05e 0.0040e 15.05e 0.0012e 16.05e 0.0018e 17.05e 0.0007e 18.08e 0.0011e 19.08e 0.0003e 20.09e 0.0005e 21.08e 0.0004e 22.08e 0.0002e 23.07e 0.0003e 25.07e 0.0001e ] constant tbp-fs2

vct[ 1.01e 0.0148e 2.00e 0.0544e 3.02e 0.0144e 4.01e 0.0848e 5.03e 0.0334e 6.02e 0.0703e 7.01e 0.0546e 8.03e 0.0242e 9.02e 0.0235e 10.04e 0.0054e 11.02e 0.0079e 12.04e 0.0009e 13.03e 0.0032e 14.02e 0.0011e 15.04e 0.0013e 16.02e 0.0005e 17.06e 0.0005e 18.01e 0.0001e 19.01e 0.0002e 20.07e 0.0002e 21.08e 0.0001e ] constant tbp-g2

vct[ 0.99e 0.0357e 2.00e 0.0505e 3.00e 0.0158e 3.99e 0.0999e 4.99e 0.0473e 6.00e 0.0633e 7.00e 0.0187e 7.98e 0.0536e 8.99e 0.0153e 9.99e 0.0238e 10.98e 0.0049e 11.98e 0.0045e 12.99e 0.0018e 13.98e 0.0031e 14.97e 0.0011e 15.97e 0.0009e 16.98e 0.0005e 17.97e 0.0007e 18.97e 0.0006e 19.95e 0.0003e 20.96e 0.0001e ] constant tbp-gs2

vct[ 1.00e 0.0295e 1.99e 0.1044e 2.98e 0.0380e 3.96e 0.1223e 4.95e 0.0652e 5.93e 0.0906e 6.93e 0.0212e 7.91e 0.0492e 8.91e 0.0034e 9.88e 0.0180e 10.87e 0.0036e 11.86e 0.0050e 12.85e 0.0005e 13.85e 0.0016e 14.84e 0.0009e 15.81e 0.0014e 16.80e 0.0002e 17.77e 0.0003e 20.73e 0.0001e 21.73e 0.0002e 22.73e 0.0002e 24.70e 0.0001e ] constant tbp-a2

vct[ 1.00e 0.0228e 2.01e 0.0987e 3.02e 0.0160e 4.03e 0.0517e 5.03e 0.0818e 6.04e 0.0522e 7.06e 0.0447e 8.06e 0.0171e 9.07e 0.0228e 10.06e 0.0032e 11.08e 0.0065e 12.06e 0.0008e 13.09e 0.0023e 14.11e 0.0008e 15.09e 0.0004e 16.11e 0.0004e 17.10e 0.0003e 18.13e 0.0002e 20.07e 0.0001e ] constant tbp-as2

vct[ 1.01e 0.0076e 1.99e 0.0810e 2.98e 0.0345e 3.98e 0.0341e 4.99e 0.0653e 5.99e 0.0085e 6.96e 0.0538e 7.97e 0.0030e 8.97e 0.0204e 9.96e 0.0059e 10.95e 0.0026e 11.96e 0.0028e 12.96e 0.0006e 13.94e 0.0014e 14.92e 0.0002e 15.94e 0.0007e 16.95e 0.0002e ] constant tbp-b2

vct[ 1.02e 0.0300e 2.02e 0.0703e 3.03e 0.1222e 4.04e 0.0495e 5.04e 0.0810e 6.04e 0.0372e 7.05e 0.0371e 8.06e 0.0353e 9.08e 0.0026e 10.09e 0.0078e 11.10e 0.0065e 12.11e 0.0027e 13.11e 0.0030e 14.12e 0.0006e 15.12e 0.0013e 16.13e 0.0006e 17.14e 0.0002e 18.16e 0.0002e 19.18e 0.0001e 20.19e 0.0001e 21.19e 0.0001e ] constant tbp-c3

vct[ 0.99e 0.0466e 1.97e 0.0094e 2.97e 0.0953e 3.95e 0.0427e 4.96e 0.0520e 5.94e 0.0187e 6.94e 0.0127e 7.92e 0.0075e 8.90e 0.0015e 9.90e 0.0017e 10.88e 0.0009e 11.89e 0.0002e 12.85e 0.0002e ] constant tbp-cs3

vct[ 1.01e 0.0634e 2.02e 0.0187e 3.02e 0.0987e 4.02e 0.0742e 5.02e 0.0182e 6.03e 0.0331e 7.03e 0.0132e 8.03e 0.0025e 9.04e 0.0026e 10.06e 0.0016e 11.07e 0.0002e 12.08e 0.0001e ] constant tbp-d3

vct[ 1.01e 0.1106e 2.01e 0.0100e 3.00e 0.0866e 4.00e 0.0859e 5.00e 0.0217e 6.00e 0.0251e 6.99e 0.0134e 7.99e 0.0022e 8.99e 0.0026e 9.99e 0.0021e 11.00e 0.0005e 14.99e 0.0001e 16.99e 0.0001e ] constant tbp-ds3

vct[ 1.00e 0.1452e 1.99e 0.0464e 2.98e 0.0553e 3.97e 0.1114e 4.96e 0.0181e 5.95e 0.0077e 6.94e 0.0033e 7.93e 0.0043e 8.92e 0.0023e 9.92e 0.0003e 10.90e 0.0006e 11.89e 0.0003e 14.88e 0.0001e 15.87e 0.0002e 19.83e 0.0001e ] constant tbp-e3

vct[ 0.99e 0.0923e 2.00e 0.0191e 3.00e 0.0745e 3.99e 0.1014e 5.00e 0.0547e 6.00e 0.0129e 6.99e 0.0032e 8.00e 0.0023e 9.00e 0.0018e 9.98e 0.0007e 10.38e 0.0001e 12.98e 0.0001e ] constant tbp-f3

vct[ 1.01e 0.0781e 2.00e 0.0346e 2.99e 0.0441e 4.01e 0.0196e 5.00e 0.0310e 5.99e 0.0213e 7.00e 0.0062e 7.99e 0.0021e 9.00e 0.0003e 9.99e 0.0002e ] constant tbp-fs3

vct[ 1.01e 0.0733e 2.03e 0.0883e 3.03e 0.0772e 4.05e 0.0148e 5.06e 0.0055e 6.06e 0.0033e 7.09e 0.0026e 8.09e 0.0015e 9.11e 0.0003e 10.12e 0.0002e ] constant tbp-g3

vct[ 1.02e 0.0885e 2.03e 0.1115e 3.05e 0.0480e 4.06e 0.0466e 5.07e 0.0106e 6.09e 0.0018e 7.10e 0.0009e ] constant tbp-gs3

vct[ 1.01e 0.1416e 2.02e 0.1418e 3.02e 0.0683e 4.03e 0.0464e 5.04e 0.0178e 6.04e 0.0037e 7.06e 0.0018e 8.07e 0.0006e 9.05e 0.0004e ] constant tbp-a3

vct[ 1.01e 0.1361e 2.01e 0.0839e 3.00e 0.0761e 4.00e 0.0211e 5.00e 0.0045e 6.00e 0.0018e 7.00e 0.0004e ] constant tbp-as3

vct[ 1.01e 0.0960e 2.01e 0.0594e 3.01e 0.0315e 4.01e 0.0078e 5.01e 0.0021e 6.01e 0.0009e 7.02e 0.0005e 8.03e 0.0003e ] constant tbp-b3

vct[ 1.00e 0.0855e 2.00e 0.1172e 3.00e 0.0276e 4.00e 0.0135e 5.00e 0.0053e 6.00e 0.0021e 6.99e 0.0003e ] constant tbp-c4

vct[ 1.01e 0.0033e 2.00e 0.0982e 2.99e 0.0491e 3.99e 0.0185e 4.99e 0.0043e 5.98e 0.0004e 6.99e 0.0001e ] constant tbp-cs4

vct[ 1.01e 0.0485e 2.01e 0.1552e 3.01e 0.0547e 4.01e 0.0136e 5.03e 0.0026e 6.04e 0.0010e 7.05e 0.0001e ] constant tbp-d4

vct[ 1.01e 0.0030e 2.01e 0.1892e 3.01e 0.0563e 4.01e 0.0025e 5.02e 0.0034e 5.97e 0.0001e 7.03e 0.0003e ] constant tbp-ds4

vct[ 1.01e 0.0508e 2.02e 0.0934e 3.02e 0.0147e 4.03e 0.0111e 5.05e 0.0014e 6.06e 0.0014e 8.08e 0.0001e ] constant tbp-e4

vct[ 1.00e 0.0260e 2.02e 0.2047e 3.02e 0.0550e 4.03e 0.0165e 5.04e 0.0051e 6.04e 0.0005e 7.05e 0.0002e ] constant tbp-f4

vct[ 1.02e 0.0971e 2.03e 0.0635e 3.04e 0.0254e 4.05e 0.0023e 5.07e 0.0002e 6.08e 0.0003e 7.09e 0.0001e ] constant tbp-fs4

vct[ 1.02e 0.3176e 2.03e 0.0734e 3.04e 0.0332e 4.05e 0.0152e 5.06e 0.0048e 6.08e 0.0007e ] constant tbp-g4

vct[ 1.01e 0.3321e 2.01e 0.1320e 3.01e 0.0072e 4.02e 0.0028e 5.03e 0.0009e 6.04e 0.0002e 7.04e 0.0002e ] constant tbp-gs4

vct[ 1.00e 0.5149e 2.00e 0.2025e 3.00e 0.0392e 3.99e 0.0117e 4.99e 0.0035e 5.99e 0.0008e 6.99e 0.0002e 7.98e 0.0001e ] constant tbp-a4

vct[ 1.01e 0.3188e 2.01e 0.2130e 3.02e 0.0427e 4.03e 0.0024e 5.05e 0.0004e 6.05e 0.0007e 7.06e 0.0002e 8.06e 0.0002e ] constant tbp-as4

vct[ 1.00e 0.1685e 1.99e 0.0732e 2.99e 0.0056e 3.99e 0.0042e 4.99e 0.0009e 5.99e 0.0005e ] constant tbp-b4

vct[ 1.01e 0.3386e 2.02e 0.0634e 3.02e 0.0212e 4.03e 0.0019e 5.04e 0.0004e ] constant tbp-c5

vct[ 1.00e 0.2958e 2.00e 0.0843e 3.01e 0.0058e 4.01e 0.0027e 5.01e 0.0003e ] constant tbp-cs5

vct[ 1.00e 0.4237e 2.01e 0.0453e 3.01e 0.0045e 4.02e 0.0007e 5.02e 0.0004e ] constant tbp-d5

\ **********************************************************
\ trumpet
\ **********************************************************

vct[ 1.01e 0.0533e 2.03e 0.0559e 3.05e 0.0505e 4.06e 0.0542e 5.08e 0.0382e 6.10e 0.0570e 7.12e 0.0321e 8.14e 0.0393e 9.15e 0.0277e 10.17e 0.0157e 11.19e 0.0165e 12.20e 0.0152e 13.22e 0.0081e 14.23e 0.0089e 15.24e 0.0035e 16.26e 0.0045e 17.28e 0.0052e 18.29e 0.0020e 19.31e 0.0021e 20.33e 0.0017e 21.35e 0.0014e 22.37e 0.0010e 23.38e 0.0009e 24.40e 0.0004e 25.42e 0.0005e 26.44e 0.0004e 27.45e 0.0004e 28.46e 0.0004e 29.48e 0.0002e 30.49e 0.0002e 31.51e 0.0002e 32.53e 0.0001e 33.55e 0.0001e ] constant trp-fs3

vct[ 0.99e 0.0459e 1.99e 0.0931e 3.00e 0.0517e 4.00e 0.0496e 5.00e 0.0576e 6.00e 0.0452e 7.00e 0.0263e 8.00e 0.0125e 9.01e 0.0131e 10.01e 0.0136e 11.00e 0.0066e 12.00e 0.0081e 13.00e 0.0032e 14.00e 0.0039e 14.99e 0.0026e 16.00e 0.0017e 16.99e 0.0017e 17.99e 0.0009e 19.01e 0.0013e 20.01e 0.0008e 21.01e 0.0006e 22.00e 0.0006e 23.00e 0.0003e 24.01e 0.0004e 25.01e 0.0003e 26.01e 0.0002e 27.02e 0.0002e 28.02e 0.0001e 29.02e 0.0001e 31.04e 0.0001e ] constant trp-g3

vct[ 0.99e 0.0455e 1.99e 0.0969e 2.97e 0.0487e 3.97e 0.0296e 4.97e 0.0186e 5.95e 0.0219e 6.95e 0.0075e 7.94e 0.0176e 8.93e 0.0202e 9.93e 0.0175e 10.91e 0.0156e 11.91e 0.0097e 12.91e 0.0066e 13.89e 0.0065e 14.89e 0.0051e 15.88e 0.0037e 16.86e 0.0015e 17.87e 0.0016e 18.85e 0.0010e 19.85e 0.0006e 20.84e 0.0006e 21.84e 0.0006e 22.84e 0.0005e 23.82e 0.0003e 24.82e 0.0003e 25.80e 0.0002e 26.79e 0.0002e 27.79e 0.0001e 28.79e 0.0001e ] constant trp-gs3

vct[ 0.99e 0.0420e 1.99e 0.0954e 2.99e 0.0579e 3.99e 0.0722e 4.98e 0.0813e 5.98e 0.0399e 6.98e 0.0379e 7.98e 0.0181e 8.98e 0.0188e 9.98e 0.0147e 10.97e 0.0100e 11.97e 0.0091e 12.96e 0.0048e 13.96e 0.0091e 14.96e 0.0048e 15.96e 0.0016e 16.96e 0.0027e 17.97e 0.0020e 18.96e 0.0014e 19.96e 0.0007e 20.95e 0.0007e 21.95e 0.0006e 22.94e 0.0003e 23.95e 0.0005e 24.95e 0.0002e 25.95e 0.0002e 26.95e 0.0002e 27.96e 0.0002e 28.95e 0.0002e 29.94e 0.0001e ] constant trp-a3

vct[ 1.01e 0.0487e 2.01e 0.0236e 3.01e 0.0599e 4.01e 0.0397e 5.01e 0.0525e 6.01e 0.0426e 7.00e 0.0144e 8.01e 0.0134e 9.01e 0.0274e 10.01e 0.0087e 11.01e 0.0041e 12.00e 0.0052e 13.01e 0.0080e 14.01e 0.0028e 15.02e 0.0022e 16.01e 0.0014e 17.04e 0.0005e 18.04e 0.0003e 19.03e 0.0005e 20.02e 0.0003e 21.02e 0.0003e 22.02e 0.0003e 23.03e 0.0002e 24.03e 0.0002e 25.02e 0.0001e ] constant trp-as3

vct[ 1.00e 0.0534e 2.00e 0.0362e 3.00e 0.0698e 4.00e 0.0793e 4.99e 0.0301e 6.00e 0.0216e 7.00e 0.0130e 8.00e 0.0151e 9.00e 0.0172e 10.00e 0.0062e 11.00e 0.0041e 11.99e 0.0022e 13.00e 0.0017e 14.00e 0.0012e 14.99e 0.0013e 15.95e 0.0002e 16.99e 0.0001e 18.00e 0.0003e 19.00e 0.0003e 20.00e 0.0003e 21.01e 0.0001e ] constant trp-b3

vct[ 1.01e 0.0410e 2.03e 0.0543e 3.03e 0.0487e 4.04e 0.0354e 5.05e 0.0408e 6.06e 0.0221e 7.08e 0.0099e 8.09e 0.0248e 9.09e 0.0107e 10.11e 0.0037e 11.11e 0.0087e 12.13e 0.0035e 13.14e 0.0012e 14.16e 0.0013e 15.17e 0.0002e 16.18e 0.0002e 17.19e 0.0003e 18.20e 0.0002e 19.21e 0.0002e 20.22e 0.0002e 21.23e 0.0001e 22.24e 0.0001e ] constant trp-c4

vct[ 1.01e 0.0199e 2.03e 0.0437e 3.03e 0.0142e 4.04e 0.0534e 5.04e 0.0310e 6.06e 0.0194e 7.06e 0.0124e 8.06e 0.0071e 9.07e 0.0061e 10.06e 0.0037e 11.09e 0.0022e 12.12e 0.0007e 13.11e 0.0005e 14.12e 0.0003e 15.10e 0.0002e 16.12e 0.0002e 17.13e 0.0001e 18.13e 0.0001e ] constant trp-cs4

vct[ 1.01e 0.0320e 2.02e 0.0510e 3.04e 0.0747e 4.05e 0.0619e 5.06e 0.0404e 6.07e 0.0195e 7.08e 0.0221e 8.09e 0.0112e 9.11e 0.0073e 10.13e 0.0031e 11.13e 0.0026e 12.15e 0.0017e 13.16e 0.0013e 14.17e 0.0009e 15.18e 0.0007e 16.18e 0.0004e 17.19e 0.0003e 18.22e 0.0002e 19.23e 0.0002e 20.23e 0.0002e 21.25e 0.0001e ] constant trp-d4

vct[ 1.00e 0.0471e 2.01e 0.0466e 3.02e 0.0304e 4.02e 0.0166e 5.02e 0.0187e 6.02e 0.0086e 7.03e 0.0064e 8.03e 0.0067e 9.03e 0.0033e 10.02e 0.0016e 11.05e 0.0013e 12.06e 0.0008e 13.06e 0.0005e 14.05e 0.0002e 15.04e 0.0002e 16.05e 0.0002e 17.05e 0.0001e ] constant trp-ds4

vct[ 1.01e 0.0365e 2.01e 0.0352e 3.02e 0.0462e 4.02e 0.0230e 5.02e 0.0092e 6.02e 0.0078e 7.02e 0.0059e 8.04e 0.0034e 9.04e 0.0011e 10.05e 0.0010e 11.07e 0.0003e 12.07e 0.0003e 13.06e 0.0002e 14.06e 0.0001e 15.07e 0.0001e ] constant trp-e4

vct[ 1.00e 0.0412e 2.00e 0.0621e 3.00e 0.0180e 3.99e 0.0631e 4.99e 0.0245e 5.99e 0.0369e 6.99e 0.0093e 7.99e 0.0126e 8.99e 0.0027e 9.99e 0.0035e 10.99e 0.0021e 11.99e 0.0016e 12.99e 0.0010e 13.98e 0.0009e 14.98e 0.0006e 15.98e 0.0004e 16.98e 0.0002e ] constant trp-f4

vct[ 0.99e 0.0581e 1.98e 0.0494e 2.98e 0.0614e 3.97e 0.0316e 4.96e 0.0151e 5.96e 0.0095e 6.95e 0.0022e 7.93e 0.0022e 8.93e 0.0013e 9.94e 0.0008e 10.93e 0.0003e 11.92e 0.0002e 12.92e 0.0001e 13.93e 0.0001e ] constant trp-fs4

vct[ 1.00e 0.0979e 1.99e 0.0344e 2.99e 0.0374e 3.99e 0.0179e 4.98e 0.0148e 5.98e 0.0059e 6.98e 0.0029e 7.95e 0.0005e 8.97e 0.0004e 9.97e 0.0002e 10.96e 0.0002e ] constant trp-g4

vct[ 1.00e 0.0670e 2.00e 0.0138e 3.00e 0.0100e 4.01e 0.0076e 4.99e 0.0070e 5.99e 0.0037e 6.97e 0.0023e 7.97e 0.0007e 8.97e 0.0002e 9.98e 0.0001e 10.97e 0.0002e ] constant trp-gs4

vct[ 1.00e 0.0403e 2.01e 0.0211e 3.00e 0.0107e 4.00e 0.0052e 4.99e 0.0022e 6.00e 0.0013e 7.00e 0.0006e 8.01e 0.0002e 9.02e 0.0001e 10.03e 0.0001e ] constant trp-a4

vct[ 1.00e 0.0128e 2.01e 0.0154e 3.00e 0.0269e 3.99e 0.0098e 4.99e 0.0021e 5.98e 0.0016e 6.99e 0.0004e 8.00e 0.0003e 9.02e 0.0002e ] constant trp-as4

vct[ 1.01e 0.0287e 2.01e 0.0583e 3.01e 0.0386e 4.00e 0.0098e 5.01e 0.0068e 6.02e 0.0012e 7.02e 0.0012e 8.03e 0.0003e 9.02e 0.0003e 10.01e 0.0001e ] constant trp-b4

vct[ 1.01e 0.0190e 2.01e 0.0057e 3.01e 0.0039e 4.01e 0.0051e 5.03e 0.0005e 6.02e 0.0002e 7.03e 0.0001e ] constant trp-c5

vct[ 1.01e 0.0087e 2.01e 0.0050e 3.01e 0.0011e 4.01e 0.0002e ] constant trp-cs5

vct[ 1.01e 0.0145e 2.01e 0.0098e 3.01e 0.0013e 4.01e 0.0003e ] constant trp-d5

vct[ 1.00e 0.0231e 2.00e 0.0053e 2.98e 0.0077e 3.97e 0.0021e 4.96e 0.0003e 6.98e 0.0001e ] constant trp-ds5

vct[ 1.01e 0.0520e 2.02e 0.0187e 3.00e 0.0009e 4.04e 0.0011e 5.02e 0.0001e ] constant trp-e5

vct[ 1.02e 0.0332e 2.02e 0.0074e 3.03e 0.0031e ] constant trp-f5

vct[ 1.01e 0.1718e 2.02e 0.1098e 3.02e 0.0288e 4.02e 0.0047e 5.04e 0.0026e 6.04e 0.0008e 7.06e 0.0004e 8.06e 0.0002e ] constant trp-fs5

vct[ 1.02e 0.0825e 2.03e 0.0364e 3.04e 0.0160e 4.06e 0.0045e 5.07e 0.0011e 6.09e 0.0005e 7.10e 0.0002e ] constant trp-g5

vct[ 1.02e 0.0114e 2.02e 0.0346e 3.02e 0.0045e 4.04e 0.0013e 5.06e 0.0002e ] constant trp-gs5

vct[ 1.02e 0.0821e 2.03e 0.0089e 3.04e 0.0023e 4.06e 0.0003e 5.05e 0.0001e ] constant trp-a5

vct[ 1.01e 0.1554e 2.01e 0.0287e 3.02e 0.0084e 4.02e 0.0035e 5.03e 0.0007e 6.04e 0.0002e 7.04e 0.0001e ] constant trp-as5

vct[ 1.01e 0.0559e 2.01e 0.0017e 3.01e 0.0013e 4.02e 0.0001e ] constant trp-b5

vct[ 1.01e 0.0291e 2.00e 0.0150e 3.01e 0.0032e 4.02e 0.0004e 5.02e 0.0002e ] constant trp-c6

\ **********************************************************
\
\ **********************************************************

vct[ 1.00e 0.0292e 1.99e 0.0424e 3.00e 0.0242e 4.00e 0.0413e 4.99e 0.0315e 6.00e 0.0454e 7.00e 0.0143e 7.98e 0.0108e 8.99e 0.0077e 9.99e 0.0084e 10.99e 0.0071e 11.98e 0.0078e 12.97e 0.0085e 13.98e 0.0032e 14.97e 0.0035e 15.97e 0.0052e 16.96e 0.0021e 17.96e 0.0033e 18.96e 0.0024e 19.97e 0.0016e 20.95e 0.0015e 21.95e 0.0011e 22.95e 0.0006e 23.95e 0.0007e 24.94e 0.0006e 25.94e 0.0004e 26.94e 0.0003e 27.93e 0.0004e 28.93e 0.0003e 29.93e 0.0002e 30.92e 0.0003e 31.92e 0.0001e 32.93e 0.0001e 33.91e 0.0002e ] constant trpf-fs3

vct[ 0.99e 0.0286e 1.97e 0.0669e 2.95e 0.0456e 3.95e 0.0345e 4.94e 0.0617e 5.91e 0.0341e 6.90e 0.0225e 7.89e 0.0264e 8.88e 0.0155e 9.86e 0.0160e 10.84e 0.0150e 11.83e 0.0085e 12.82e 0.0112e 13.80e 0.0054e 14.78e 0.0042e 15.77e 0.0056e 16.76e 0.0023e 17.73e 0.0027e 18.71e 0.0010e 19.73e 0.0014e 20.69e 0.0014e 21.68e 0.0007e 22.67e 0.0007e 23.64e 0.0007e 24.63e 0.0004e 25.62e 0.0005e 26.59e 0.0003e 27.62e 0.0002e 28.56e 0.0003e 29.55e 0.0001e 30.53e 0.0002e 31.51e 0.0002e 32.50e 0.0001e 33.48e 0.0002e 35.47e 0.0001e ] constant trpf-g3

vct[ 0.99e 0.0306e 1.99e 0.0608e 2.97e 0.0495e 3.97e 0.0557e 4.97e 0.0228e 5.95e 0.0337e 6.95e 0.0177e 7.94e 0.0112e 8.92e 0.0146e 9.93e 0.0022e 10.91e 0.0069e 11.89e 0.0053e 12.89e 0.0047e 13.88e 0.0031e 14.87e 0.0063e 15.87e 0.0042e 16.86e 0.0033e 17.84e 0.0031e 18.84e 0.0028e 19.83e 0.0018e 20.83e 0.0015e 21.82e 0.0010e 22.80e 0.0010e 23.80e 0.0005e 24.79e 0.0007e 25.77e 0.0004e 26.77e 0.0005e 27.76e 0.0003e 28.75e 0.0003e 29.74e 0.0002e 30.74e 0.0002e 32.73e 0.0001e ] constant trpf-gs3

vct[ 0.99e 0.0331e 2.00e 0.0607e 3.00e 0.0463e 4.00e 0.0350e 5.00e 0.0480e 6.00e 0.0294e 7.00e 0.0318e 7.99e 0.0150e 8.98e 0.0166e 9.98e 0.0148e 10.98e 0.0109e 11.99e 0.0052e 13.02e 0.0012e 13.99e 0.0070e 14.98e 0.0054e 15.98e 0.0035e 16.97e 0.0035e 17.96e 0.0021e 18.96e 0.0019e 19.96e 0.0008e 20.96e 0.0010e 21.97e 0.0006e 22.96e 0.0005e 23.96e 0.0007e 24.96e 0.0004e 25.95e 0.0006e 26.95e 0.0004e 27.94e 0.0003e 28.94e 0.0002e 29.94e 0.0001e 30.94e 0.0002e 31.93e 0.0002e 32.93e 0.0001e ] constant trpf-a3

vct[ 1.00e 0.0250e 2.00e 0.0182e 2.99e 0.0170e 3.97e 0.0199e 4.97e 0.0223e 5.97e 0.0224e 6.95e 0.0094e 7.95e 0.0070e 8.94e 0.0069e 9.92e 0.0064e 10.91e 0.0030e 11.92e 0.0028e 12.90e 0.0024e 13.01e 0.0007e 14.00e 0.0003e 14.89e 0.0008e 15.89e 0.0007e 16.91e 0.0002e 17.88e 0.0002e 18.86e 0.0001e 20.83e 0.0001e ] constant trpf-as3

vct[ 1.00e 0.0379e 1.99e 0.0221e 2.99e 0.0480e 3.99e 0.0721e 4.97e 0.0322e 5.98e 0.0203e 6.97e 0.0220e 7.97e 0.0170e 8.96e 0.0150e 9.96e 0.0042e 10.95e 0.0040e 11.93e 0.0049e 12.94e 0.0038e 14.00e 0.0011e 14.95e 0.0021e 15.95e 0.0008e 16.93e 0.0004e 16.98e 0.0004e 17.90e 0.0004e 18.00e 0.0003e 18.99e 0.0003e 19.89e 0.0003e 20.88e 0.0003e 21.89e 0.0002e 22.97e 0.0002e 23.97e 0.0002e ] constant trpf-b3

vct[ 1.01e 0.0330e 2.02e 0.0365e 3.02e 0.0430e 4.03e 0.0164e 5.05e 0.0234e 6.04e 0.0138e 7.05e 0.0110e 8.06e 0.0202e 9.07e 0.0098e 10.08e 0.0030e 11.09e 0.0065e 12.11e 0.0027e 13.11e 0.0009e 14.13e 0.0014e 15.15e 0.0003e 16.12e 0.0002e 17.13e 0.0002e 18.12e 0.0002e 19.14e 0.0002e 20.13e 0.0002e 21.14e 0.0001e ] constant trpf-c4

vct[ 1.01e 0.0082e 2.02e 0.0191e 3.02e 0.0152e 4.01e 0.0324e 5.02e 0.0129e 6.03e 0.0050e 7.01e 0.0093e 8.01e 0.0031e 9.01e 0.0036e 10.00e 0.0017e 11.01e 0.0010e 12.00e 0.0004e 13.02e 0.0004e 14.03e 0.0003e 15.02e 0.0002e 16.03e 0.0001e ] constant trpf-cs4

vct[ 1.01e 0.0190e 2.03e 0.0431e 3.04e 0.0481e 4.05e 0.0399e 5.07e 0.0179e 6.08e 0.0198e 7.09e 0.0136e 8.10e 0.0081e 9.12e 0.0041e 10.10e 0.0011e 11.15e 0.0016e 12.16e 0.0014e 13.17e 0.0007e 14.18e 0.0005e 15.20e 0.0003e 16.20e 0.0002e 17.22e 0.0002e 19.24e 0.0001e ] constant trpf-d4

vct[ 1.00e 0.0239e 2.01e 0.0207e 3.02e 0.0113e 4.00e 0.0083e 5.00e 0.0145e 5.97e 0.0054e 6.99e 0.0031e 7.98e 0.0026e 8.97e 0.0027e 9.98e 0.0010e 11.01e 0.0004e 11.99e 0.0004e 13.00e 0.0003e 13.97e 0.0002e 14.98e 0.0002e 15.97e 0.0002e ] constant trpf-ds4

vct[ 1.02e 0.0134e 2.03e 0.0124e 3.04e 0.0117e 4.05e 0.0041e 5.08e 0.0007e 6.06e 0.0009e 7.08e 0.0006e 8.06e 0.0002e 9.11e 0.0002e ] constant trpf-e4

vct[ 1.03e 0.0045e 2.03e 0.0019e 3.03e 0.0006e 4.04e 0.0012e 5.02e 0.0004e 6.08e 0.0001e ] constant trpf-f4

vct[ 1.00e 0.0501e 2.00e 0.0385e 3.00e 0.0509e 3.99e 0.0156e 4.98e 0.0099e 5.98e 0.0063e 6.99e 0.0017e 7.97e 0.0020e 8.97e 0.0017e 9.96e 0.0012e 10.96e 0.0004e 11.95e 0.0004e 12.97e 0.0001e 13.94e 0.0002e ] constant trpf-fs4

vct[ 1.00e 0.0998e 2.00e 0.0632e 3.01e 0.0506e 4.01e 0.0395e 5.00e 0.0265e 6.01e 0.0137e 7.01e 0.0058e 8.01e 0.0017e 9.02e 0.0010e 10.02e 0.0007e 11.02e 0.0007e 12.03e 0.0004e 13.03e 0.0004e 14.03e 0.0002e 15.05e 0.0001e ] constant trpf-g4

vct[ 1.00e 0.0589e 2.00e 0.0237e 2.99e 0.0208e 3.98e 0.0103e 4.98e 0.0087e 5.98e 0.0053e 6.97e 0.0039e 7.98e 0.0017e 8.98e 0.0006e 10.00e 0.0003e 10.97e 0.0002e 12.00e 0.0001e ] constant trpf-gs4

vct[ 1.01e 0.0482e 2.01e 0.0264e 3.02e 0.0127e 4.01e 0.0108e 5.01e 0.0039e 6.01e 0.0012e 7.00e 0.0012e 8.01e 0.0004e 9.02e 0.0002e 10.02e 0.0002e 11.00e 0.0001e ] constant trpf-a4

vct[ 1.00e 0.0176e 2.01e 0.0156e 3.00e 0.0312e 3.99e 0.0057e 5.00e 0.0055e 5.99e 0.0036e 6.99e 0.0007e 7.99e 0.0005e 8.99e 0.0003e 9.99e 0.0001e 10.99e 0.0001e ] constant trpf-as4

vct[ 1.01e 0.0051e 1.99e 0.0340e 2.98e 0.0087e 3.97e 0.0121e 4.97e 0.0018e 5.94e 0.0018e 6.95e 0.0005e 7.93e 0.0002e 8.94e 0.0004e ] constant trpf-b4

vct[ 1.01e 0.0110e 1.99e 0.0059e 3.00e 0.0200e 3.99e 0.0059e 5.00e 0.0016e 5.99e 0.0005e 6.98e 0.0002e 7.96e 0.0002e 8.99e 0.0002e ] constant trpf-c5

vct[ 1.01e 0.0257e 2.01e 0.0215e 3.02e 0.0022e 4.00e 0.0027e 5.01e 0.0007e 6.00e 0.0007e 7.02e 0.0002e ] constant trpf-cs5

vct[ 1.01e 0.0616e 2.01e 0.0423e 3.01e 0.0140e 4.01e 0.0061e 4.99e 0.0034e 5.99e 0.0008e 6.98e 0.0006e 8.00e 0.0003e 8.97e 0.0002e ] constant trpf-d5

vct[ 0.99e 0.0763e 1.99e 0.0800e 2.98e 0.0329e 3.97e 0.0255e 4.96e 0.0110e 5.95e 0.0041e 6.95e 0.0018e 7.94e 0.0006e 8.93e 0.0005e 9.90e 0.0002e 9.93e 0.0002e 10.91e 0.0002e ] constant trpf-ds5

vct[ 1.01e 0.0196e 2.00e 0.0085e 2.98e 0.0039e 3.97e 0.0007e 4.98e 0.0003e ] constant trpf-e5

vct[ 1.02e 0.0735e 2.03e 0.0526e 3.04e 0.0168e 4.05e 0.0064e 5.07e 0.0009e 6.07e 0.0008e 7.09e 0.0002e 8.09e 0.0001e 9.12e 0.0001e ] constant trpf-f5

vct[ 1.01e 0.1101e 2.02e 0.0477e 3.03e 0.0090e 4.04e 0.0024e 5.05e 0.0012e 6.06e 0.0015e 7.07e 0.0004e 8.08e 0.0002e ] constant trpf-fs5

vct[ 1.02e 0.1148e 2.03e 0.0215e 3.04e 0.0185e 4.06e 0.0077e 5.07e 0.0023e 6.08e 0.0007e 7.09e 0.0004e 8.12e 0.0002e ] constant trpf-g5

vct[ 1.01e 0.0538e 2.02e 0.0584e 3.03e 0.0156e 4.04e 0.0028e 5.06e 0.0009e 6.07e 0.0006e 7.07e 0.0002e ] constant trpf-gs5

vct[ 1.01e 0.1885e 2.02e 0.0789e 3.04e 0.0214e 4.05e 0.0086e 5.06e 0.0049e 6.07e 0.0010e 7.08e 0.0007e 8.10e 0.0003e 9.11e 0.0003e 10.12e 0.0001e 11.13e 0.0001e ] constant trpf-a5

vct[ 1.01e 0.0233e 2.02e 0.0033e 3.01e 0.0008e 4.03e 0.0002e ] constant trpf-as5

vct[ 1.00e 0.1077e 2.01e 0.0158e 3.01e 0.0039e 4.01e 0.0011e 5.01e 0.0003e 6.02e 0.0002e 7.02e 0.0001e ] constant trpf-b5

vct[ 1.01e 0.0873e 2.02e 0.0519e 3.03e 0.0156e 4.04e 0.0042e 5.04e 0.0019e 6.05e 0.0006e 7.06e 0.0004e 8.07e 0.0002e ] constant trpf-c6

vct[ 1.01e 0.0852e 2.02e 0.0049e 3.03e 0.0007e 4.05e 0.0001e ] constant trpf-cs6

\ **********************************************************
\ violin? 
\ **********************************************************

vct[ 0.99e 0.0159e 1.99e 0.1898e 3.00e 0.0499e 3.99e 0.0352e 5.00e 0.0192e 6.00e 0.0100e 7.00e 0.0173e 8.00e 0.0142e 8.99e 0.0045e 10.01e 0.0178e 11.00e 0.0108e 12.00e 0.0081e 12.99e 0.0254e 13.99e 0.0074e 14.99e 0.0062e 16.00e 0.0122e 17.00e 0.0049e 17.99e 0.0022e 19.01e 0.0041e 20.01e 0.0048e 21.01e 0.0037e 22.01e 0.0016e 23.01e 0.0001e 24.00e 0.0002e 25.00e 0.0006e 26.00e 0.0010e 27.00e 0.0015e 28.03e 0.0004e 29.02e 0.0007e 30.01e 0.0006e 32.00e 0.0002e 33.01e 0.0001e 34.00e 0.0001e 35.01e 0.0004e 36.02e 0.0003e 37.02e 0.0001e 40.02e 0.0001e 40.99e 0.0002e 42.01e 0.0003e 48.01e 0.0001e 51.01e 0.0001e ] constant vl-g3

vct[ 0.99e 0.0185e 1.99e 0.1881e 2.97e 0.0463e 3.97e 0.0528e 4.97e 0.0309e 5.95e 0.0316e 6.95e 0.0104e 7.93e 0.0422e 8.94e 0.0114e 9.90e 0.0018e 10.92e 0.0088e 11.89e 0.0021e 12.90e 0.0077e 13.91e 0.0044e 14.86e 0.0029e 14.93e 0.0028e 15.91e 0.0011e 16.88e 0.0082e 17.89e 0.0022e 18.88e 0.0043e 19.86e 0.0024e 20.84e 0.0012e 21.84e 0.0007e 22.87e 0.0008e 23.85e 0.0006e 24.84e 0.0004e 25.82e 0.0010e 26.81e 0.0006e 27.81e 0.0012e 28.79e 0.0002e 29.78e 0.0002e 30.77e 0.0001e 31.78e 0.0003e 33.75e 0.0001e 34.76e 0.0002e 35.75e 0.0002e 36.75e 0.0002e 37.77e 0.0001e 40.74e 0.0001e ] constant vl-gs3

vct[ 0.99e 0.0215e 2.00e 0.1550e 2.99e 0.0293e 4.00e 0.0298e 5.00e 0.0211e 6.00e 0.0389e 7.00e 0.0057e 7.99e 0.0235e 8.99e 0.0172e 9.99e 0.0040e 11.00e 0.0026e 12.00e 0.0074e 12.99e 0.0065e 13.99e 0.0192e 14.99e 0.0026e 15.98e 0.0063e 16.99e 0.0045e 18.01e 0.0036e 18.99e 0.0050e 20.00e 0.0012e 20.98e 0.0011e 21.99e 0.0007e 22.99e 0.0014e 23.99e 0.0003e 25.00e 0.0011e 26.00e 0.0008e 26.99e 0.0007e 27.98e 0.0002e 28.99e 0.0001e 29.97e 0.0004e 31.00e 0.0002e 31.99e 0.0002e 32.99e 0.0002e 33.98e 0.0001e 35.03e 0.0001e 36.00e 0.0002e 36.98e 0.0003e 37.99e 0.0002e 38.99e 0.0001e 39.99e 0.0002e 41.01e 0.0001e 41.99e 0.0001e 43.04e 0.0001e 43.99e 0.0001e ] constant vl-a3

vct[ 1.00e 0.0210e 2.00e 0.1015e 3.00e 0.0450e 3.99e 0.0210e 4.99e 0.0266e 6.00e 0.0143e 7.00e 0.0661e 7.99e 0.0367e 8.99e 0.0149e 9.99e 0.0037e 10.99e 0.0344e 11.99e 0.0069e 12.99e 0.0110e 13.98e 0.0088e 14.98e 0.0052e 15.98e 0.0066e 16.99e 0.0038e 17.98e 0.0027e 18.98e 0.0007e 19.98e 0.0018e 20.98e 0.0009e 21.99e 0.0011e 22.99e 0.0013e 23.99e 0.0006e 24.97e 0.0004e 25.98e 0.0001e 26.98e 0.0003e 27.97e 0.0002e 28.99e 0.0002e 29.97e 0.0002e 31.00e 0.0002e 31.97e 0.0004e 32.97e 0.0001e 33.99e 0.0003e 34.97e 0.0002e 35.97e 0.0003e 36.94e 0.0001e 37.99e 0.0001e 38.96e 0.0001e 41.97e 0.0001e ] constant vl-as3

vct[ 1.00e 0.0532e 1.99e 0.0205e 3.00e 0.0342e 3.99e 0.0312e 5.00e 0.0493e 5.99e 0.0062e 6.99e 0.0103e 7.99e 0.0240e 8.99e 0.0134e 9.99e 0.0046e 10.98e 0.0154e 11.99e 0.0077e 12.98e 0.0084e 13.99e 0.0028e 14.99e 0.0026e 15.98e 0.0054e 16.98e 0.0031e 17.99e 0.0004e 18.98e 0.0009e 19.99e 0.0005e 20.52e 0.0001e 21.98e 0.0011e 22.97e 0.0010e 23.99e 0.0004e 24.96e 0.0003e 26.00e 0.0001e 27.99e 0.0006e 28.99e 0.0001e 30.97e 0.0003e 32.00e 0.0002e 32.99e 0.0001e 33.97e 0.0002e 36.99e 0.0001e ] constant vl-b3

vct[ 0.99e 0.1156e 2.00e 0.0827e 3.00e 0.0458e 4.00e 0.0163e 5.00e 0.0256e 6.01e 0.0103e 7.02e 0.0032e 8.00e 0.0025e 8.98e 0.0056e 10.00e 0.0072e 10.98e 0.0016e 11.98e 0.0036e 13.02e 0.0013e 14.00e 0.0021e 15.00e 0.0024e 15.99e 0.0013e 16.99e 0.0003e 18.01e 0.0001e 19.01e 0.0003e 19.99e 0.0001e 21.02e 0.0001e 22.03e 0.0002e 29.00e 0.0001e ] constant vl-c4

vct[ 1.00e 0.3269e 2.00e 0.0869e 2.99e 0.0386e 4.00e 0.0117e 4.99e 0.0062e 6.00e 0.0264e 7.00e 0.0099e 8.00e 0.0038e 9.01e 0.0040e 10.00e 0.0057e 11.03e 0.0040e 12.02e 0.0017e 13.00e 0.0009e 14.02e 0.0026e 15.02e 0.0009e 15.95e 0.0002e 16.99e 0.0002e 18.01e 0.0001e 19.01e 0.0005e 20.00e 0.0001e 21.03e 0.0002e 22.03e 0.0001e ] constant vl-cs4

vct[ 1.00e 0.2473e 2.00e 0.0621e 2.98e 0.0073e 3.99e 0.0178e 5.00e 0.0070e 5.98e 0.0041e 7.02e 0.0054e 8.01e 0.0114e 9.05e 0.0034e 10.05e 0.0024e 10.93e 0.0003e 11.99e 0.0011e 13.00e 0.0011e 14.03e 0.0010e 15.01e 0.0002e 15.96e 0.0001e 17.02e 0.0001e 18.01e 0.0005e 21.00e 0.0001e 22.00e 0.0002e ] constant vl-d4

vct[ 1.00e 0.0394e 2.00e 0.0358e 2.99e 0.0119e 3.99e 0.0208e 4.99e 0.0064e 5.98e 0.0126e 6.96e 0.0028e 7.03e 0.0017e 8.01e 0.0006e 8.92e 0.0005e 9.97e 0.0048e 10.97e 0.0004e 11.99e 0.0005e 12.97e 0.0005e 13.96e 0.0002e 14.92e 0.0001e 15.92e 0.0001e 19.93e 0.0001e 22.92e 0.0001e 23.96e 0.0001e ] constant vl-ds4

vct[ 1.00e 0.0649e 2.00e 0.0412e 3.01e 0.0315e 4.00e 0.0446e 5.01e 0.0414e 6.01e 0.0209e 7.02e 0.0189e 8.01e 0.0101e 9.03e 0.0012e 10.03e 0.0029e 11.02e 0.0041e 12.00e 0.0012e 13.04e 0.0004e 14.05e 0.0005e 15.03e 0.0009e 16.06e 0.0005e 17.09e 0.0004e 18.07e 0.0006e 19.08e 0.0004e 20.10e 0.0001e 21.09e 0.0001e 22.09e 0.0004e 23.11e 0.0002e 24.06e 0.0002e 25.07e 0.0002e 26.07e 0.0002e 27.08e 0.0002e 30.10e 0.0001e ] constant vl-e4

vct[ 1.00e 0.0700e 2.00e 0.0235e 3.00e 0.0294e 4.00e 0.0101e 4.99e 0.0173e 5.99e 0.0081e 6.99e 0.0023e 7.99e 0.0006e 8.97e 0.0101e 9.98e 0.0060e 11.00e 0.0063e 11.99e 0.0038e 13.00e 0.0011e 13.98e 0.0003e 15.01e 0.0009e 16.02e 0.0005e 17.01e 0.0004e 18.06e 0.0002e 19.01e 0.0004e 20.01e 0.0004e 21.03e 0.0005e 22.04e 0.0002e 23.00e 0.0003e 24.00e 0.0001e 25.99e 0.0001e 29.04e 0.0001e 31.04e 0.0001e ] constant vl-f4

vct[ 1.01e 0.1897e 2.02e 0.0152e 3.02e 0.0312e 4.03e 0.0224e 5.03e 0.0483e 6.04e 0.0217e 7.05e 0.0184e 8.07e 0.0051e 9.06e 0.0031e 10.08e 0.0047e 11.09e 0.0040e 12.10e 0.0021e 13.10e 0.0006e 14.11e 0.0010e 15.14e 0.0012e 16.14e 0.0009e 17.15e 0.0004e 18.16e 0.0010e 19.18e 0.0003e 20.19e 0.0005e 21.14e 0.0002e 22.17e 0.0002e 23.18e 0.0002e 24.18e 0.0002e 26.22e 0.0001e 29.25e 0.0002e 30.26e 0.0002e ] constant vl-fs4

vct[ 1.01e 0.0788e 2.01e 0.0144e 2.99e 0.0064e 3.99e 0.0078e 5.02e 0.0053e 6.00e 0.0045e 7.01e 0.0011e 7.98e 0.0025e 9.03e 0.0010e 10.02e 0.0014e 11.02e 0.0002e 12.02e 0.0001e 13.02e 0.0003e 14.05e 0.0002e 15.07e 0.0002e 17.05e 0.0001e 18.02e 0.0002e 19.07e 0.0001e ] constant vl-g4

vct[ 1.00e 0.2902e 2.01e 0.0644e 3.01e 0.0378e 4.02e 0.0473e 5.02e 0.0027e 6.03e 0.0278e 7.04e 0.0077e 8.04e 0.0105e 9.04e 0.0026e 10.04e 0.0106e 11.05e 0.0011e 12.05e 0.0014e 13.06e 0.0045e 14.09e 0.0015e 15.09e 0.0010e 16.09e 0.0008e 17.09e 0.0011e 18.10e 0.0010e 19.09e 0.0011e 20.09e 0.0004e 21.10e 0.0010e 22.10e 0.0006e 23.11e 0.0003e 24.10e 0.0002e 24.14e 0.0002e 25.15e 0.0002e 26.14e 0.0005e 27.14e 0.0003e 30.13e 0.0002e 31.14e 0.0001e ] constant vl-gs4

vct[ 1.00e 0.3420e 2.02e 0.0045e 3.00e 0.0160e 4.00e 0.0105e 5.01e 0.0370e 6.02e 0.0193e 7.01e 0.0342e 8.02e 0.0178e 9.02e 0.0146e 10.04e 0.0025e 11.03e 0.0011e 12.02e 0.0010e 13.03e 0.0009e 14.03e 0.0003e 15.05e 0.0031e 16.04e 0.0009e 17.04e 0.0004e 18.04e 0.0004e 19.03e 0.0004e 20.06e 0.0005e 21.05e 0.0001e 22.04e 0.0001e 24.06e 0.0001e 25.07e 0.0002e 26.08e 0.0001e ] constant vl-a4

vct[ 1.00e 0.1478e 2.00e 0.0159e 3.00e 0.0033e 3.99e 0.0600e 5.00e 0.0291e 5.99e 0.0028e 7.01e 0.0118e 8.00e 0.0115e 8.99e 0.0039e 9.99e 0.0020e 10.99e 0.0024e 11.99e 0.0012e 12.99e 0.0009e 14.01e 0.0011e 15.00e 0.0015e 16.01e 0.0004e 17.02e 0.0001e 18.01e 0.0001e 19.01e 0.0002e 20.00e 0.0002e 20.98e 0.0001e 22.00e 0.0001e 24.02e 0.0002e 25.00e 0.0002e ] constant vl-as4

vct[ 1.00e 0.0247e 2.01e 0.0570e 3.01e 0.0115e 4.02e 0.0167e 5.02e 0.0162e 6.02e 0.0154e 7.02e 0.0056e 8.04e 0.0021e 9.04e 0.0003e 10.04e 0.0023e 11.04e 0.0003e 12.07e 0.0005e 13.09e 0.0005e 14.06e 0.0003e 15.06e 0.0004e 16.09e 0.0003e 17.07e 0.0002e 18.10e 0.0003e 19.10e 0.0002e ] constant vl-b4

vct[ 1.00e 0.0690e 1.99e 0.0372e 2.99e 0.0326e 3.99e 0.0222e 4.99e 0.0107e 5.97e 0.0033e 6.99e 0.0029e 7.98e 0.0013e 8.97e 0.0005e 9.98e 0.0008e 10.97e 0.0004e 11.97e 0.0006e 12.99e 0.0003e 13.99e 0.0002e 14.97e 0.0001e 16.95e 0.0001e 16.98e 0.0001e 17.97e 0.0001e 19.96e 0.0001e ] constant vl-c5

vct[ 1.00e 0.1446e 2.01e 0.0499e 3.01e 0.0768e 4.02e 0.0436e 5.02e 0.0287e 6.03e 0.0204e 7.03e 0.0301e 7.11e 0.0011e 8.04e 0.0010e 9.04e 0.0036e 10.05e 0.0030e 11.05e 0.0023e 12.06e 0.0008e 13.06e 0.0005e 14.07e 0.0009e 15.08e 0.0005e 16.09e 0.0009e 17.08e 0.0003e 18.10e 0.0006e 19.09e 0.0008e 20.13e 0.0002e 21.11e 0.0001e 22.14e 0.0001e 23.11e 0.0002e ] constant vl-cs5

vct[ 1.00e 0.0614e 1.99e 0.0194e 2.99e 0.0196e 3.99e 0.0159e 5.00e 0.0057e 6.00e 0.0031e 7.01e 0.0024e 8.00e 0.0004e 9.00e 0.0003e 9.98e 0.0003e 11.01e 0.0005e 11.99e 0.0003e 12.99e 0.0002e 16.99e 0.0001e 17.98e 0.0001e ] constant vl-d5

vct[ 0.99e 0.1393e 1.99e 0.0875e 2.99e 0.1163e 3.98e 0.0152e 4.98e 0.0551e 5.97e 0.0214e 6.97e 0.0072e 7.96e 0.0017e 8.95e 0.0028e 9.96e 0.0034e 10.95e 0.0015e 11.94e 0.0010e 12.95e 0.0009e 13.91e 0.0008e 14.94e 0.0011e 15.93e 0.0005e 16.93e 0.0007e 17.92e 0.0004e 17.97e 0.0002e 18.94e 0.0002e 19.93e 0.0003e 20.92e 0.0004e 21.90e 0.0001e ] constant vl-ds5

vct[ 1.00e 0.1926e 2.00e 0.0731e 3.00e 0.0543e 4.00e 0.0258e 5.02e 0.0238e 6.02e 0.0177e 7.03e 0.0206e 8.03e 0.0081e 9.03e 0.0030e 10.05e 0.0043e 11.03e 0.0011e 12.06e 0.0007e 13.08e 0.0013e 14.10e 0.0007e 15.11e 0.0004e 16.14e 0.0002e ] constant vl-e5

vct[ 1.00e 0.0684e 2.00e 0.0409e 3.00e 0.0344e 4.00e 0.0439e 5.00e 0.0686e 6.00e 0.0504e 7.00e 0.0045e 8.00e 0.0056e 9.00e 0.0094e 10.00e 0.0028e 11.00e 0.0015e 11.99e 0.0010e 13.00e 0.0032e 14.00e 0.0017e 15.00e 0.0010e 16.01e 0.0011e 16.99e 0.0003e 18.01e 0.0006e 19.00e 0.0003e ] constant vl-f5

vct[ 1.00e 0.0291e 2.01e 0.0323e 3.01e 0.0110e 4.02e 0.0071e 5.04e 0.0028e 6.04e 0.0010e 7.08e 0.0007e 8.08e 0.0003e 9.09e 0.0004e 10.12e 0.0002e 11.06e 0.0003e ] constant vl-fs5

vct[ 1.00e 0.0980e 1.99e 0.0303e 3.00e 0.0044e 4.01e 0.0107e 5.03e 0.0027e 6.03e 0.0011e 7.00e 0.0010e 8.02e 0.0011e 8.06e 0.0004e 9.04e 0.0003e 10.04e 0.0001e ] constant vl-g5

vct[ 1.01e 0.1116e 2.01e 0.0200e 3.03e 0.0147e 4.03e 0.0034e 5.08e 0.0061e 6.10e 0.0012e 7.06e 0.0005e 8.14e 0.0005e 9.14e 0.0004e ] constant vl-gs5

vct[ 1.00e 0.0211e 2.01e 0.0180e 3.01e 0.0158e 4.02e 0.0057e 5.03e 0.0013e 6.03e 0.0006e 7.02e 0.0001e ] constant vl-a5

vct[ 1.00e 0.0442e 2.01e 0.0922e 3.01e 0.0102e 4.00e 0.0031e 5.03e 0.0053e 6.01e 0.0004e 7.04e 0.0018e 7.08e 0.0009e 8.06e 0.0004e 9.06e 0.0006e 10.06e 0.0003e 11.06e 0.0003e 12.09e 0.0002e 13.09e 0.0002e ] constant vl-as5

vct[ 1.01e 0.0061e 2.01e 0.0016e 3.01e 0.0014e 4.03e 0.0005e 5.04e 0.0005e 5.06e 0.0001e ] constant vl-b5

vct[ 1.01e 0.0039e 2.00e 0.0005e 3.02e 0.0006e 4.03e 0.0001e ] constant vl-c6

vct[ 1.00e 0.0754e 2.00e 0.1620e 3.00e 0.1551e 4.00e 0.0277e 5.00e 0.0466e 6.00e 0.0408e 7.00e 0.0025e 8.00e 0.0055e 9.00e 0.0048e 9.99e 0.0034e 10.99e 0.0039e 11.99e 0.0005e ] constant vl-cs6

vct[ 1.00e 0.0905e 2.00e 0.0808e 3.00e 0.0909e 4.00e 0.0616e 5.00e 0.0172e 5.99e 0.0043e 7.01e 0.0044e 8.00e 0.0036e 9.00e 0.0043e 10.01e 0.0015e 11.03e 0.0014e ] constant vl-d6

vct[ 1.00e 0.1772e 2.00e 0.1029e 3.00e 0.0398e 4.01e 0.0602e 5.00e 0.0222e 6.01e 0.0073e 7.01e 0.0037e 8.01e 0.0044e 9.01e 0.0019e 10.01e 0.0028e 11.01e 0.0006e 11.03e 0.0001e ] constant vl-ds6

vct[ 1.00e 0.1865e 2.00e 0.2083e 2.99e 0.0822e 3.99e 0.0298e 4.99e 0.0227e 6.00e 0.0023e 6.98e 0.0049e 7.99e 0.0021e 8.98e 0.0022e 9.98e 0.0003e 9.99e 0.0003e ] constant vl-e6

vct[ 1.01e 0.0841e 2.01e 0.0654e 3.02e 0.1346e 4.03e 0.0041e 5.04e 0.0077e 6.05e 0.0088e 7.05e 0.0016e 8.06e 0.0017e 9.06e 0.0012e 9.08e 0.0003e 9.10e 0.0002e 9.11e 0.0001e ] constant vl-f6

vct[ 1.00e 0.1693e 2.02e 0.0779e 3.03e 0.0411e 4.03e 0.0147e 5.04e 0.0085e 6.05e 0.0080e 7.06e 0.0088e 8.06e 0.0032e 9.06e 0.0010e 9.08e 0.0007e 9.10e 0.0004e ] constant vl-fs6

vct[ 1.01e 0.2123e 2.02e 0.2854e 3.03e 0.0552e 4.04e 0.0246e 5.05e 0.0058e 6.06e 0.0022e 7.07e 0.0017e 8.09e 0.0029e 9.10e 0.0001e ] constant vl-g6

vct[ 1.02e 0.1270e 2.03e 0.0961e 3.05e 0.0347e 4.06e 0.0032e 5.08e 0.0083e 6.09e 0.0050e 7.11e 0.0020e 8.12e 0.0013e 8.14e 0.0002e ] constant vl-gs6

vct[ 1.02e 0.3359e 2.03e 0.1252e 3.05e 0.0238e 4.07e 0.0155e 5.09e 0.0053e 6.10e 0.0051e 7.12e 0.0025e 7.18e 0.0001e ] constant vl-a6

vct[ 1.01e 0.2037e 2.03e 0.0456e 3.05e 0.0029e 4.06e 0.0053e 5.07e 0.0041e 6.09e 0.0043e 7.11e 0.0026e 7.13e 0.0006e 7.14e 0.0001e ] constant vl-as6

vct[ 1.02e 0.4213e 2.04e 0.1379e 3.06e 0.0067e 4.06e 0.0041e 4.08e 0.0039e 5.09e 0.0026e 6.11e 0.0027e 7.13e 0.0002e ] constant vl-b6

vct[ 1.01e 0.1299e 2.02e 0.1571e 3.03e 0.0461e 4.04e 0.0033e 5.05e 0.0057e 6.06e 0.0015e ] constant vl-c7

vct[ 1.01e 0.1471e 2.03e 0.0526e 3.05e 0.0161e 4.06e 0.0037e 5.08e 0.0017e 6.09e 0.0005e ] constant vl-cs7

vct[ 1.01e 0.0321e 2.02e 0.0529e 3.03e 0.0046e 4.03e 0.0054e 4.04e 0.0021e 5.04e 0.0010e ] constant vl-d7

vct[ 1.00e 0.1220e 2.00e 0.0667e 2.99e 0.0319e 4.00e 0.0020e 4.99e 0.0052e 5.03e 0.0002e ] constant vl-ds7

vct[ 1.01e 0.1110e 2.02e 0.0588e 3.03e 0.0143e 4.04e 0.0068e 5.05e 0.0011e ] constant vl-e7

vct[ 1.01e 0.0798e 2.02e 0.0111e 3.03e 0.0125e 4.03e 0.0036e 4.50e 0.0002e 5.04e 0.0001e ] constant vl-f7

vct[ 1.02e 0.1071e 2.04e 0.0117e 3.06e 0.0148e 4.08e 0.0092e 4.11e 0.0007e 4.13e 0.0005e 4.16e 0.0003e 4.23e 0.0002e 4.24e 0.0002e 4.28e 0.0002e 4.34e 0.0001e 4.39e 0.0001e ] constant vl-fs7

vct[ 1.02e 0.2741e 2.05e 0.0256e 3.07e 0.0122e 4.11e 0.0002e 4.14e 0.0001e ] constant vl-g7

vct[ 1.02e 0.1027e 2.05e 0.0192e 3.07e 0.0091e ] constant vl-gs7

vct[ 1.02e 0.0796e 2.04e 0.0112e 3.06e 0.0030e ] constant vl-a7

vct[ 1.06e 0.1256e ] constant vl-as7

vct[ 1.08e 0.1494e 3.24e 0.0003e ] constant vl-b7

vct[ 1.07e 0.0582e 3.25e 0.0004e ] constant vl-c8

vct[ 1.08e 0.0889e ] constant vl-cs8

vct[ 1.07e 0.0573e ] constant vl-d8

\ **********************************************************
\
\ **********************************************************

vct[ 1.01e 0.0037e 2.01e 0.0482e 3.01e 0.0275e 4.01e 0.0182e 5.03e 0.0047e 6.03e 0.0032e 7.03e 0.0005e 8.03e 0.0050e 9.05e 0.0044e 10.02e 0.0016e 11.06e 0.0011e 12.06e 0.0004e 13.06e 0.0006e 14.16e 0.0001e 15.12e 0.0001e 16.12e 0.0004e 17.12e 0.0004e 19.08e 0.0003e 20.11e 0.0004e 23.11e 0.0002e 24.14e 0.0003e 25.14e 0.0003e 27.12e 0.0002e 28.13e 0.0001e 30.17e 0.0001e ] constant almf-c3

vct[ 1.01e 0.0043e 2.01e 0.0357e 3.02e 0.0452e 4.01e 0.0156e 5.02e 0.0152e 6.04e 0.0022e 7.04e 0.0039e 8.06e 0.0078e 9.06e 0.0049e 10.09e 0.0046e 11.24e 0.0004e 12.08e 0.0016e 13.09e 0.0015e 14.10e 0.0021e 15.12e 0.0006e 16.12e 0.0012e 17.12e 0.0002e 18.16e 0.0004e 19.16e 0.0006e 20.15e 0.0006e 21.15e 0.0007e 22.16e 0.0005e 23.17e 0.0005e 24.13e 0.0004e 25.48e 0.0003e 26.19e 0.0002e 27.18e 0.0002e 28.20e 0.0002e 30.26e 0.0001e 31.25e 0.0002e 34.23e 0.0001e ] constant almf-cs3

vct[ 1.01e 0.0052e 2.03e 0.0062e 3.01e 0.0292e 4.05e 0.0043e 5.02e 0.0149e 5.97e 0.0018e 7.02e 0.0016e 8.05e 0.0029e 9.04e 0.0005e 10.06e 0.0012e 11.04e 0.0006e 12.12e 0.0002e 13.05e 0.0005e 14.10e 0.0004e 15.08e 0.0004e 15.99e 0.0001e 17.18e 0.0001e 18.07e 0.0004e 19.06e 0.0001e 20.08e 0.0003e 22.11e 0.0003e 24.13e 0.0002e 25.15e 0.0001e 26.12e 0.0001e ] constant almf-d3

vct[ 1.01e 0.0043e 2.01e 0.0532e 3.01e 0.0389e 4.00e 0.0094e 5.01e 0.0031e 6.00e 0.0038e 7.00e 0.0219e 8.00e 0.0122e 8.99e 0.0129e 10.00e 0.0014e 11.00e 0.0021e 12.01e 0.0037e 13.01e 0.0021e 14.01e 0.0017e 15.02e 0.0015e 16.01e 0.0023e 17.03e 0.0024e 18.00e 0.0008e 19.03e 0.0011e 20.04e 0.0003e 21.04e 0.0009e 22.04e 0.0003e 23.00e 0.0012e 24.00e 0.0011e 25.01e 0.0007e 27.02e 0.0002e 28.02e 0.0004e 29.03e 0.0003e 30.04e 0.0002e 31.04e 0.0001e 46.55e 0.0001e 48.01e 0.0001e ] constant almf-ds3

vct[ 1.00e 0.0123e 2.00e 0.0733e 2.99e 0.0330e 4.00e 0.0098e 5.00e 0.0171e 6.00e 0.0013e 7.01e 0.0117e 7.99e 0.0020e 9.00e 0.0044e 10.01e 0.0012e 11.01e 0.0014e 12.00e 0.0021e 13.02e 0.0002e 14.02e 0.0016e 15.03e 0.0012e 16.03e 0.0028e 17.02e 0.0007e 18.02e 0.0019e 19.03e 0.0008e 20.04e 0.0013e 21.03e 0.0005e 22.03e 0.0005e 23.03e 0.0003e 24.04e 0.0003e 26.03e 0.0005e 27.04e 0.0001e 28.06e 0.0001e 29.04e 0.0002e ] constant almf-e3

vct[ 1.00e 0.0185e 2.00e 0.0813e 3.00e 0.0142e 3.99e 0.0132e 5.00e 0.0066e 5.99e 0.0027e 6.93e 0.0009e 8.01e 0.0042e 8.99e 0.0018e 9.97e 0.0002e 10.97e 0.0010e 12.00e 0.0008e 13.00e 0.0012e 13.98e 0.0003e 14.96e 0.0006e 16.00e 0.0004e 17.01e 0.0005e 18.00e 0.0003e 18.98e 0.0005e 19.99e 0.0002e 20.99e 0.0002e 22.00e 0.0002e ] constant almf-f3

vct[ 1.01e 0.0480e 2.01e 0.0778e 3.01e 0.0124e 4.01e 0.0204e 5.05e 0.0008e 6.03e 0.0068e 7.05e 0.0052e 8.06e 0.0017e 9.07e 0.0017e 10.05e 0.0008e 11.07e 0.0010e 12.08e 0.0008e 13.11e 0.0002e 14.08e 0.0006e 15.10e 0.0002e 16.09e 0.0013e 17.12e 0.0003e 18.10e 0.0003e 19.11e 0.0004e 20.14e 0.0001e 23.17e 0.0001e ] constant almf-fs3

vct[ 1.00e 0.0526e 2.00e 0.0242e 2.99e 0.0351e 3.99e 0.0076e 4.98e 0.0062e 5.99e 0.0085e 6.99e 0.0061e 8.04e 0.0006e 8.98e 0.0005e 10.01e 0.0006e 10.97e 0.0003e 11.96e 0.0004e 13.07e 0.0004e 13.95e 0.0003e 14.99e 0.0003e 15.20e 0.0002e 17.93e 0.0002e 18.02e 0.0002e 24.96e 0.0001e ] constant almf-g3

vct[ 0.99e 0.0523e 1.99e 0.0560e 2.98e 0.0166e 3.98e 0.0183e 4.96e 0.0005e 5.98e 0.0066e 6.99e 0.0026e 7.96e 0.0011e 8.95e 0.0013e 9.95e 0.0026e 10.95e 0.0019e 11.96e 0.0017e 12.94e 0.0005e 13.92e 0.0002e 14.94e 0.0006e 15.95e 0.0007e 16.94e 0.0007e 17.96e 0.0002e 18.92e 0.0002e 19.93e 0.0002e 20.92e 0.0002e 21.94e 0.0001e ] constant almf-gs3

vct[ 1.00e 0.1590e 2.00e 0.0394e 3.02e 0.0076e 3.99e 0.0222e 5.00e 0.0063e 5.93e 0.0008e 6.97e 0.0016e 7.95e 0.0002e 8.94e 0.0002e 9.94e 0.0003e 10.05e 0.0002e 10.15e 0.0001e 12.00e 0.0005e 12.12e 0.0002e 12.95e 0.0001e 15.98e 0.0002e ] constant almf-a3

vct[ 1.00e 0.2533e 2.00e 0.0498e 3.00e 0.0178e 3.99e 0.0108e 5.00e 0.0245e 6.00e 0.0112e 6.99e 0.0066e 8.00e 0.0010e 8.98e 0.0074e 9.99e 0.0042e 10.99e 0.0025e 12.00e 0.0015e 13.01e 0.0006e 14.00e 0.0012e 15.00e 0.0004e 16.02e 0.0004e 17.00e 0.0010e 18.00e 0.0005e 18.99e 0.0002e 19.98e 0.0002e ] constant almf-as3

vct[ 1.00e 0.1639e 2.00e 0.0436e 3.01e 0.0584e 4.01e 0.0080e 5.01e 0.0117e 6.01e 0.0208e 7.02e 0.0062e 8.02e 0.0035e 9.03e 0.0037e 10.03e 0.0022e 11.04e 0.0023e 12.04e 0.0048e 13.04e 0.0022e 14.04e 0.0005e 15.04e 0.0007e 16.05e 0.0012e 17.05e 0.0010e 18.06e 0.0005e 19.05e 0.0001e 20.06e 0.0005e 21.07e 0.0002e 24.07e 0.0002e 25.08e 0.0002e 27.08e 0.0002e 28.10e 0.0001e 33.12e 0.0001e ] constant almf-b3

vct[ 1.00e 0.0931e 2.00e 0.0251e 3.00e 0.0077e 4.00e 0.0129e 5.00e 0.0115e 6.00e 0.0055e 7.00e 0.0041e 8.01e 0.0046e 9.00e 0.0013e 10.00e 0.0067e 11.02e 0.0011e 12.02e 0.0021e 12.99e 0.0002e 14.01e 0.0007e 15.02e 0.0008e 16.03e 0.0007e 17.02e 0.0004e 19.02e 0.0003e 20.05e 0.0001e 24.04e 0.0001e ] constant almf-c4

vct[ 1.01e 0.0587e 2.01e 0.0263e 3.02e 0.0299e 4.03e 0.0306e 5.04e 0.0172e 6.04e 0.0097e 7.05e 0.0024e 8.06e 0.0034e 9.06e 0.0053e 10.07e 0.0065e 11.08e 0.0025e 12.09e 0.0005e 13.10e 0.0016e 14.11e 0.0011e 15.11e 0.0009e 16.12e 0.0004e 17.13e 0.0002e 18.13e 0.0003e 21.15e 0.0002e 23.17e 0.0001e 24.18e 0.0001e 25.19e 0.0002e 30.23e 0.0001e 32.25e 0.0001e ] constant almf-cs4

vct[ 1.00e 0.0619e 2.00e 0.0432e 3.01e 0.0479e 4.01e 0.0136e 5.00e 0.0220e 6.01e 0.0064e 7.02e 0.0138e 8.02e 0.0033e 9.02e 0.0066e 10.06e 0.0006e 11.02e 0.0019e 12.01e 0.0013e 13.02e 0.0008e 14.01e 0.0004e 15.03e 0.0007e 16.04e 0.0003e 17.03e 0.0001e 18.02e 0.0001e 21.04e 0.0003e ] constant almf-d4

vct[ 1.00e 0.0762e 1.99e 0.0071e 2.99e 0.0085e 3.99e 0.0120e 4.98e 0.0064e 5.98e 0.0018e 6.98e 0.0039e 7.99e 0.0027e 8.96e 0.0017e 9.95e 0.0007e 10.98e 0.0006e 11.95e 0.0003e 12.98e 0.0006e 13.98e 0.0007e 15.97e 0.0002e 19.96e 0.0001e ] constant almf-ds4

vct[ 0.99e 0.0726e 1.99e 0.0195e 2.99e 0.0147e 3.98e 0.0106e 4.99e 0.0069e 6.00e 0.0026e 6.99e 0.0046e 7.99e 0.0105e 8.97e 0.0017e 10.01e 0.0007e 10.97e 0.0022e 11.99e 0.0009e 12.99e 0.0011e 13.98e 0.0001e 14.96e 0.0002e 15.96e 0.0001e 16.99e 0.0001e 17.95e 0.0002e 18.98e 0.0002e 20.98e 0.0001e 21.97e 0.0001e ] constant almf-e4

vct[ 1.00e 0.0772e 2.00e 0.0150e 3.00e 0.0166e 4.01e 0.0118e 4.99e 0.0024e 6.01e 0.0067e 7.03e 0.0017e 8.00e 0.0012e 9.02e 0.0017e 10.02e 0.0011e 11.03e 0.0008e 12.04e 0.0004e 13.04e 0.0007e 14.03e 0.0002e 15.04e 0.0002e 16.04e 0.0001e ] constant almf-f4

vct[ 0.99e 0.1309e 1.99e 0.0550e 2.98e 0.0321e 3.98e 0.0270e 4.97e 0.0070e 5.97e 0.0099e 6.96e 0.0041e 7.96e 0.0033e 8.95e 0.0023e 9.94e 0.0017e 10.94e 0.0023e 11.93e 0.0015e 12.93e 0.0006e 13.95e 0.0002e 14.93e 0.0002e 15.91e 0.0002e 16.91e 0.0003e 17.92e 0.0001e 18.90e 0.0003e 19.93e 0.0001e 22.87e 0.0001e 23.88e 0.0001e ] constant almf-fs4

vct[ 0.99e 0.0515e 2.00e 0.0153e 3.00e 0.0281e 4.00e 0.0071e 5.01e 0.0020e 6.00e 0.0045e 7.02e 0.0006e 8.00e 0.0054e 8.99e 0.0020e 10.00e 0.0031e 11.01e 0.0023e 12.02e 0.0003e 13.00e 0.0004e 14.01e 0.0002e 15.02e 0.0003e 15.98e 0.0002e 16.02e 0.0002e 18.03e 0.0002e 19.01e 0.0001e ] constant almf-g4

vct[ 1.00e 0.0592e 2.00e 0.0287e 3.00e 0.0196e 3.99e 0.0175e 4.99e 0.0168e 6.00e 0.0071e 6.07e 0.0008e 7.00e 0.0003e 7.99e 0.0019e 8.98e 0.0007e 9.98e 0.0012e 10.99e 0.0012e 11.98e 0.0004e 12.98e 0.0003e 13.99e 0.0002e 14.96e 0.0001e 15.98e 0.0001e 16.97e 0.0002e 17.96e 0.0002e ] constant almf-gs4

vct[ 1.01e 0.0784e 2.01e 0.0480e 3.02e 0.0131e 4.02e 0.0074e 5.03e 0.0141e 6.03e 0.0173e 7.04e 0.0070e 8.04e 0.0033e 9.06e 0.0154e 9.12e 0.0016e 10.07e 0.0011e 11.07e 0.0013e 12.07e 0.0009e 13.09e 0.0008e 14.07e 0.0006e 15.09e 0.0002e 16.10e 0.0005e 17.10e 0.0003e 19.12e 0.0001e 23.14e 0.0001e ] constant almf-a4

vct[ 1.00e 0.0507e 2.00e 0.0304e 3.00e 0.0303e 4.00e 0.0084e 5.00e 0.0072e 6.00e 0.0098e 6.99e 0.0058e 8.01e 0.0036e 9.01e 0.0023e 10.00e 0.0010e 11.00e 0.0008e 12.00e 0.0007e 12.97e 0.0005e 13.02e 0.0004e 14.00e 0.0003e 14.99e 0.0003e 16.01e 0.0001e 17.01e 0.0002e 18.00e 0.0001e 20.01e 0.0001e ] constant almf-as4

vct[ 1.00e 0.0340e 2.00e 0.0113e 3.01e 0.0098e 4.02e 0.0033e 5.03e 0.0013e 6.05e 0.0008e 7.02e 0.0007e 8.07e 0.0006e 9.01e 0.0001e ] constant almf-b4

vct[ 1.00e 0.0384e 2.00e 0.0426e 3.01e 0.0092e 4.02e 0.0239e 5.02e 0.0184e 6.02e 0.0031e 7.03e 0.0029e 8.04e 0.0016e 8.10e 0.0006e 9.04e 0.0005e 10.04e 0.0003e 11.05e 0.0006e 12.05e 0.0007e 13.06e 0.0002e 15.07e 0.0002e ] constant almf-c5

vct[ 1.00e 0.0159e 2.00e 0.0592e 3.00e 0.0390e 4.00e 0.0272e 5.00e 0.0121e 6.00e 0.0032e 7.01e 0.0124e 8.01e 0.0055e 9.00e 0.0009e 10.01e 0.0016e 11.01e 0.0007e 12.01e 0.0006e 13.02e 0.0020e 14.02e 0.0010e 15.02e 0.0007e 16.03e 0.0004e 17.03e 0.0002e 18.02e 0.0001e 19.03e 0.0001e 20.03e 0.0003e 21.03e 0.0002e 22.03e 0.0003e 23.03e 0.0002e ] constant almf-cs5

vct[ 1.01e 0.0376e 2.01e 0.0409e 3.02e 0.0136e 4.03e 0.0016e 5.05e 0.0080e 6.05e 0.0044e 7.06e 0.0036e 8.07e 0.0018e 9.07e 0.0007e 10.08e 0.0011e 11.09e 0.0002e 12.09e 0.0004e 13.12e 0.0003e 14.11e 0.0001e 16.15e 0.0002e 17.16e 0.0001e 20.18e 0.0001e ] constant almf-d5

vct[ 1.00e 0.0391e 2.01e 0.0445e 3.01e 0.0188e 4.02e 0.0329e 5.02e 0.0185e 6.02e 0.0311e 7.03e 0.0107e 8.03e 0.0032e 9.03e 0.0010e 10.03e 0.0009e 11.04e 0.0019e 12.04e 0.0019e 13.05e 0.0005e 14.06e 0.0004e 15.05e 0.0007e 16.06e 0.0002e 17.07e 0.0002e 18.08e 0.0002e 19.07e 0.0005e 20.07e 0.0003e 21.08e 0.0001e ] constant almf-ds5

vct[ 1.00e 0.0869e 2.00e 0.0181e 3.01e 0.0252e 4.01e 0.0520e 5.01e 0.0040e 6.02e 0.0336e 7.02e 0.0108e 8.03e 0.0070e 9.03e 0.0023e 10.03e 0.0009e 11.03e 0.0017e 12.02e 0.0004e 13.04e 0.0012e 14.04e 0.0006e 15.05e 0.0016e 16.06e 0.0007e 17.06e 0.0003e 18.06e 0.0012e 19.07e 0.0001e 20.06e 0.0001e ] constant almf-e5

vct[ 1.01e 0.0905e 2.02e 0.0649e 3.02e 0.0406e 4.03e 0.0295e 5.04e 0.0038e 6.05e 0.0088e 7.06e 0.0009e 8.07e 0.0021e 9.07e 0.0037e 10.09e 0.0022e 11.09e 0.0014e 12.09e 0.0018e 13.11e 0.0006e 14.12e 0.0009e 15.13e 0.0004e 16.12e 0.0003e 17.14e 0.0006e 18.15e 0.0002e ] constant almf-f5

vct[ 0.99e 0.0868e 1.98e 0.0447e 2.98e 0.0303e 3.97e 0.0092e 4.96e 0.0183e 5.95e 0.0121e 6.94e 0.0033e 7.95e 0.0010e 8.92e 0.0022e 9.92e 0.0007e 10.91e 0.0007e 11.90e 0.0007e 12.89e 0.0014e 13.87e 0.0004e 14.88e 0.0006e 14.91e 0.0003e 15.87e 0.0002e 16.85e 0.0003e ] constant almf-fs5

vct[ 1.00e 0.0467e 2.00e 0.0739e 3.00e 0.0255e 4.00e 0.0277e 5.00e 0.0349e 6.00e 0.0119e 7.00e 0.0024e 8.00e 0.0085e 9.00e 0.0016e 9.99e 0.0012e 11.00e 0.0004e 11.99e 0.0014e 12.99e 0.0024e 13.99e 0.0017e 14.99e 0.0007e 15.99e 0.0004e 16.98e 0.0001e ] constant almf-g5

vct[ 0.99e 0.0605e 1.99e 0.0384e 2.98e 0.0154e 3.98e 0.0036e 4.97e 0.0164e 5.96e 0.0039e 6.96e 0.0036e 7.95e 0.0040e 8.94e 0.0012e 9.94e 0.0006e 10.93e 0.0015e 11.93e 0.0012e 12.93e 0.0008e 13.91e 0.0010e 14.90e 0.0005e 15.91e 0.0001e ] constant almf-gs5

vct[ 1.00e 0.1051e 2.01e 0.0322e 3.02e 0.0393e 4.03e 0.0112e 5.03e 0.0099e 6.04e 0.0074e 7.05e 0.0054e 8.05e 0.0030e 9.06e 0.0019e 10.07e 0.0006e 11.07e 0.0023e 12.08e 0.0004e 13.08e 0.0005e 14.09e 0.0006e 14.11e 0.0001e 15.11e 0.0001e ] constant almf-a5

vct[ 1.00e 0.0284e 2.01e 0.0161e 3.02e 0.0248e 4.03e 0.0414e 5.03e 0.0135e 6.04e 0.0028e 7.05e 0.0021e 8.06e 0.0006e 9.07e 0.0009e 10.07e 0.0010e 11.08e 0.0012e 12.10e 0.0003e 13.09e 0.0010e 14.10e 0.0003e ] constant almf-as5

vct[ 0.99e 0.0354e 1.98e 0.0173e 2.97e 0.0086e 3.96e 0.0204e 3.99e 0.0077e 4.03e 0.0067e 4.06e 0.0037e 4.95e 0.0034e 5.93e 0.0030e 5.96e 0.0015e 5.98e 0.0009e 6.92e 0.0007e 7.92e 0.0008e 8.91e 0.0017e 9.90e 0.0008e 9.93e 0.0006e 10.88e 0.0003e 11.91e 0.0003e 12.86e 0.0004e 12.90e 0.0002e ] constant almf-b5

vct[ 1.01e 0.0675e 2.01e 0.0578e 3.02e 0.0346e 4.03e 0.0170e 5.03e 0.0082e 6.04e 0.0050e 7.06e 0.0032e 8.03e 0.0009e 9.06e 0.0009e 10.07e 0.0008e 11.09e 0.0010e 12.03e 0.0002e ] constant almf-c6

vct[ 1.00e 0.0896e 1.99e 0.0634e 3.01e 0.0037e 3.98e 0.0105e 4.98e 0.0030e 5.98e 0.0019e 6.97e 0.0020e 7.97e 0.0014e 8.00e 0.0007e 8.99e 0.0005e 9.96e 0.0005e 10.95e 0.0008e 10.98e 0.0005e 11.00e 0.0003e 11.02e 0.0003e 11.03e 0.0002e 11.06e 0.0002e 11.95e 0.0001e 11.98e 0.0001e ] constant almf-cs6

vct[ 1.00e 0.0593e 2.00e 0.0364e 3.01e 0.0142e 4.01e 0.0065e 5.02e 0.0063e 6.01e 0.0024e 7.02e 0.0010e 8.02e 0.0019e 9.02e 0.0015e 10.03e 0.0007e 11.02e 0.0002e ] constant almf-d6

vct[ 1.00e 0.0410e 1.99e 0.0353e 2.99e 0.0291e 3.99e 0.0089e 4.99e 0.0066e 5.98e 0.0023e 6.99e 0.0012e 7.96e 0.0011e 7.99e 0.0006e 8.94e 0.0004e 8.98e 0.0003e 9.95e 0.0001e ] constant almf-ds6

vct[ 1.01e 0.0254e 2.01e 0.0252e 3.02e 0.0365e 4.03e 0.0034e 5.02e 0.0013e 6.02e 0.0010e 7.08e 0.0006e 8.02e 0.0010e 9.03e 0.0007e 9.12e 0.0004e ] constant almf-e6

vct[ 1.00e 0.1896e 2.00e 0.0411e 3.00e 0.0216e 4.00e 0.0019e 5.00e 0.0032e 6.01e 0.0012e 7.02e 0.0007e 7.99e 0.0026e 9.00e 0.0003e 9.03e 0.0002e ] constant almf-f6

vct[ 1.01e 0.0285e 2.01e 0.0189e 3.02e 0.0213e 4.02e 0.0033e 5.03e 0.0024e 6.03e 0.0010e 7.04e 0.0016e 8.05e 0.0015e 9.05e 0.0003e 9.06e 0.0002e ] constant almf-fs6

vct[ 1.00e 0.1939e 2.00e 0.0339e 3.00e 0.0219e 4.01e 0.0079e 5.01e 0.0025e 6.01e 0.0017e 7.01e 0.0014e 7.95e 0.0009e 8.00e 0.0006e 8.02e 0.0003e ] constant almf-g6

vct[ 1.00e 0.1069e 2.00e 0.0146e 3.00e 0.0220e 4.00e 0.0046e 5.00e 0.0020e 6.00e 0.0027e 6.99e 0.0011e 8.00e 0.0003e ] constant almf-gs6

vct[ 1.00e 0.0952e 1.99e 0.0201e 3.00e 0.0015e 3.99e 0.0064e 4.98e 0.0021e 5.97e 0.0009e 6.98e 0.0010e ] constant almf-a6

vct[ 1.00e 0.0132e 1.99e 0.0635e 2.99e 0.0057e 3.98e 0.0054e 3.99e 0.0034e 4.99e 0.0011e 5.96e 0.0012e 5.98e 0.0008e 5.99e 0.0007e 6.96e 0.0004e 6.98e 0.0004e ] constant almf-as6

vct[ 1.00e 0.0241e 2.01e 0.0417e 3.02e 0.0098e 3.99e 0.0016e 4.02e 0.0016e 5.03e 0.0016e 6.04e 0.0012e ] constant almf-b6

\ spectr.fs ends here
