/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "../audio.h"
#include "graphic.h"

void
on_b_replay_clicked (GtkButton * button, gpointer user_data)
{
  pthread_mutex_lock (&gmutex);

  events.skip = 1;
  events.next = 1;

  if (events.pause)
    events.pause = 0;

  if (events.stop)
    events.stop = 0;

  pthread_cond_signal (&play->p_pop);

  pthread_mutex_unlock (&gmutex);
}

void
on_b_prev_clicked (GtkButton * button, gpointer user_data)
{
  pthread_mutex_lock (&gmutex);

  events.skip = 1;
  events.next = -1;

  if (events.pause)
    events.pause = 0;

  if (events.stop)
    events.stop = 0;

  pthread_cond_signal (&play->p_pop);

  pthread_mutex_unlock (&gmutex);
}

void
on_b_play_clicked (GtkButton * button, gpointer user_data)
{
  pthread_mutex_lock (&gmutex);

  if (events.pause)
    events.pause = 0;
  else
    events.pause = 1;

  if (events.stop)
    events.stop = 0;

  pthread_cond_signal (&play->p_pop);

  pthread_mutex_unlock (&gmutex);
}


void
on_b_stop_clicked (GtkButton * button, gpointer user_data)
{
  pthread_mutex_lock (&gmutex);

  events.next = 1;
  events.skip = 1;
  events.stop = 1;

  pthread_mutex_unlock (&gmutex);
}


void
on_b_next_clicked (GtkButton * button, gpointer user_data)
{
  pthread_mutex_lock (&gmutex);

  events.skip = 1;

  if (events.pause)
    events.pause = 0;

  if (events.stop)
    events.stop = 0;

  pthread_cond_signal (&play->p_pop);

  pthread_mutex_unlock (&gmutex);
}

void
on_s_volume_value_changed (GtkWidget * widget, gpointer user_data)
{
  GtkAdjustment *v;

  v = gtk_range_get_adjustment (GTK_RANGE (widget));

  play->volume = (int) v->value;
}

void
on_s_balance_value_changed (GtkWidget * widget, gpointer user_data)
{
  GtkAdjustment *v;

  v = gtk_range_get_adjustment (GTK_RANGE (widget));

  if (v->value > 45 && v->value < 55)
    {
      gtk_adjustment_set_value (GTK_ADJUSTMENT (v), 50);
      return;
    }

  play->balance = ((int) v->value * 2) - 100;
}

void
on_b_random_toggled (GtkWidget * widget, gpointer user_data)
{

  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    play->random = 1;
  else
    play->random = 0;
}

void
on_b_repeat_toggled (GtkWidget * widget, gpointer user_data)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget)))
    play->repeat = 1;
  else
    play->repeat = 0;
}

/* EOF */
