/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_AO

#include "../player.h"
#include "../audio.h"
#include "graphic.h"

void
on_ao_show_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *table;
  GtkWidget *stock;
  GtkWidget *label;

  GtkWidget *entry;

  audio *ao = (audio *) user_data;

  if (!ao)
    return;

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - Audio configuration"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_OK,
				 GTK_RESPONSE_OK, NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);

  stock =
    gtk_image_new_from_stock (GTK_STOCK_DIALOG_INFO, GTK_ICON_SIZE_DIALOG);
  gtk_box_pack_start (GTK_BOX (box), stock, FALSE, FALSE, 0);

  table = gtk_table_new (0, 0, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 4);
  gtk_box_pack_start (GTK_BOX (box), table, TRUE, TRUE, 0);

  label = gtk_label_new_with_mnemonic (_("Output Audio:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);

  entry = gtk_entry_new ();
  switch (ao->audio_type)
    {
    case USE_AUDIO:
      {
	ao_info *info;
	ao_device *tmp;

	tmp = (ao_device *) ao->data;

	info = ao_driver_info (tmp->driver_id);
	gtk_entry_set_text (GTK_ENTRY (entry), info->name);
      }
      break;
    case USE_OSS:
      gtk_entry_set_text (GTK_ENTRY (entry), _("Oss - Open Sound System"));
      break;
    case USE_ALSA:
      gtk_entry_set_text (GTK_ENTRY (entry),
			  _("Alsa - Advanced Linux Sound Architecture"));
      break;
    case USE_ALSA09:
      gtk_entry_set_text (GTK_ENTRY (entry),
			  _("Alsa - Advanced Linux Sound Architecture v0.9"));
      break;
    case USE_ESD:
      gtk_entry_set_text (GTK_ENTRY (entry),
			  _("Esd - Enlightened Sound Daemon"));
      break;
    case USE_ARTS:
      gtk_entry_set_text (GTK_ENTRY (entry), _("Arts - Arts Sound Server"));
      break;
    case USE_SUN:
      gtk_entry_set_text (GTK_ENTRY (entry), _("Sun - Sun Audio"));
      break;
    case USE_NULL:
      gtk_entry_set_text (GTK_ENTRY (entry), _("Null - Null Device"));
      break;
    }

  gtk_table_attach_defaults (GTK_TABLE (table), entry, 1, 2, 0, 1);
  gtk_entry_set_editable (GTK_ENTRY (entry), FALSE);

  label = gtk_label_new_with_mnemonic (_("Options:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);

  entry = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), entry, 1,2, 1, 2);
  gtk_entry_set_editable (GTK_ENTRY (entry), FALSE);
  if(ao->audio_dev)
    gtk_entry_set_text(GTK_ENTRY(entry), ao->audio_dev);

  gtk_widget_show_all (box);

  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

#endif

/* EOF */
