/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "player.h"
#include "volume.h"

/* Volume functions */

void
volume_add (void)
{
  if (play->volume < VOLUME_MAX)
    play->volume++;
}

void
volume_sub (void)
{
  if (play->volume > VOLUME_MIN)
    play->volume--;
}

void
volume_min (void)
{
  play->volume = VOLUME_MIN;
}

void
volume_max (void)
{
  play->volume = VOLUME_MAX;
}

double
volume_get (void)
{
  return (double) play->volume;
}

double
volume_l_get (void)
{
  if (play->balance > 0)
    {
      return (double) (play->volume * (100 - play->balance) / 100);
    }

  return (double) play->volume;
}

double
volume_r_get (void)
{
  if (play->balance < 0)
    {
      return (double) (play->volume * (100 + play->balance) / 100);
    }

  return (double) play->volume;
}

/* Balance functions */

void
balance_add_left (void)
{
  if (play->balance != VOLUME_MAX)
    play->balance++;
}

void
balance_add_right (void)
{
  if (play->balance != -VOLUME_MAX)
    play->balance--;
}

void
balance_left (void)
{
  play->balance = VOLUME_MAX - 1;
  play->balance++;
}

void
balance_right (void)
{
  play->balance = -VOLUME_MAX;
}

void
balance_center (void)
{
  play->balance = 0;
}

/* EOF */
