/* 
   EOFault.h
   
   Copyright (C) SKYRIX Software AG and Helge Hess

   Author: Helge Hess (helge.hess@opengroupware.org)
   Date:   1999-2004

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __EOFault_h__
#define __EOFault_h__

#import <Foundation/NSObject.h>

@class NSArray, NSDictionary, NSString, NSMethodSignature;

@class EOFaultHandler;

@interface EOFault
{
  Class          isa;
  EOFaultHandler *faultResolver;
}

+ (void)makeObjectIntoFault:(id)_object withHandler:(EOFaultHandler *)_handler;
+ (EOFaultHandler *)handlerForFault:(id)_fault;

/* Inquire about a fault */

+ (BOOL)isFault:(id)object;
+ (BOOL)isFault;
- (BOOL)isFault;
+ (void)clearFault:(id)fault;

+ (Class)targetClassForFault:fault;

/* Non-Faulting Instance methods */

- (Class)superclass;
- (Class)class;
+ (Class)class;
- (BOOL)isKindOfClass:(Class)aClass;
- (BOOL)isMemberOfClass:(Class)aClass;
- (BOOL)conformsToProtocol:(Protocol *)aProtocol;
- (BOOL)respondsToSelector:(SEL)aSelector;

+ (id)self;

- (void)dealloc;
- retain;
- (void)release;
- autorelease;
- (unsigned)retainCount;
- (NSZone*)zone;

- (BOOL)isProxy;
- (BOOL)isGarbageCollectable;
- (NSString *)description;

- (NSMethodSignature *)methodSignatureForSelector:(SEL)_selector;

@end /* EOFault */

#include <GDLAccess/EOFaultHandler.h>

#endif  /* __EOFault_h__ */
