
#include "configbackendspage.h"
#include "convertpluginloader.h"
#include "replaygainpluginloader.h"
#include "ripperpluginloader.h"
#include "config.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qtooltip.h>
#include <qvbox.h>
#include <qslider.h>
#include <qcheckbox.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kcombobox.h>
#include <kscrollview.h>
#include <kstandarddirs.h>


ConfigBackendsPage::ConfigBackendsPage( Config* _config, QMap<QString, QString>* _binaries, QWidget* parent, const char *name )
    : ConfigPageBase( parent, name )
{
    config = _config;
    binaries = _binaries;

    grid = new QGridLayout( parent );
    scrollView = new KScrollView( parent, "scrollView" );
    scrollView->setResizePolicy( QScrollView::AutoOneFit );
    grid->addWidget( scrollView, 0, 0 );
    box = new QVBox( scrollView->viewport() );
    box->setMargin( 11 );
    box->setSpacing( 6 );
    scrollView->addChild( box );

    QHBox* legendBox = new QHBox( box );
    legendBox->setMargin( 0 );
    legendBox->setSpacing( 6 );
    KStandardDirs* stdDirs = new KStandardDirs();
    QLabel* lLegendLabel = new QLabel( i18n("Legend")+":", legendBox, "lLegendLabel" );
    QLabel* lLegendGreen = new QLabel( "", legendBox, "lLegendGreen" );
    lLegendGreen->setPixmap( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledgreen_legend.png")) );
    QLabel* lLegendFull = new QLabel( i18n("Full support"), legendBox, "lLegendFull" );
    QLabel* lLegendYellow = new QLabel("",legendBox,"lLegendYellow");
    lLegendYellow->setPixmap( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledyellow_legend.png")) );
    QLabel* lLegendMost = new QLabel( i18n("Most supported"), legendBox, "lLegendMost" );
    QLabel* lLegendRed = new QLabel( "", legendBox, "lLegendRed" );
    lLegendRed->setPixmap( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledred_legend.png")) );
    QLabel* lLegendBasic = new QLabel( i18n("Basic support"), legendBox, "lLegendBasic" );
    legendBox->setStretchFactor( lLegendLabel, 1 );

    QGroupBox* ripperGroup = new QGroupBox( 1, Qt::Vertical, box, "ripperGroup" );
    ripperGroup->layout()->setSpacing( 6 );
    ripperGroup->layout()->setMargin( 6 );
    QLabel* lRipper = new QLabel( i18n("CD Ripper")+":", ripperGroup, "lRipper" );
    cRipper = new KComboBox( ripperGroup, "cRipper" );
    connect( cRipper, SIGNAL(activated(int)),
               this, SLOT(cfgChanged())
             );

    delete stdDirs;

    rebuild();
}

ConfigBackendsPage::~ConfigBackendsPage()
{}

void ConfigBackendsPage::resetDefaults()
{
    int i;
    int item;
    int rank;

    i = 1;
    rank = 60;
    item = 0;
    QValueList<RipperPlugin*> rippers = config->allRippers();
    for( QValueList<RipperPlugin*>::Iterator it = rippers.begin(); it != rippers.end(); ++it )
    {
        if( (*it)->rip.rank > rank ) {
            rank = (*it)->rip.rank;
            item = i;
        }
        i++;
    }
    cRipper->setCurrentItem( item );

    for( QValueList<FormatOptions>::Iterator a = formatOptions.begin(); a != formatOptions.end(); ++a )
    {
        FormatItem* formatItem = config->getFormatItem( (*a).format );
        if( formatItem == 0 ) continue;

        i = item = rank = 0;
        for( QValueList<ConvertPlugin*>::Iterator b = formatItem->encoders.begin(); b != formatItem->encoders.end(); ++b ) {
            if( (*b)->enc.rank > rank ) {
                rank = (*b)->enc.rank;
                item = i;
            }
            i++;
        }
        (*a).cEncoder->setCurrentItem( item );

        i = item = rank = 0;
        for( QValueList<ConvertPlugin*>::Iterator b = formatItem->decoders.begin(); b != formatItem->decoders.end(); ++b ) {
            if( (*b)->dec.rank > rank ) {
                rank = (*b)->dec.rank;
                item = i;
            }
            i++;
        }
        (*a).cDecoder->setCurrentItem( item );

        i = item = rank = 0;
        for( QValueList<ReplayGainPlugin*>::Iterator b = formatItem->replaygains.begin(); b != formatItem->replaygains.end(); ++b ) {
            if( (*b)->replaygain.rank > rank ) {
                rank = (*b)->replaygain.rank;
                item = i;
            }
            i++;
        }
        (*a).cReplayGain->setCurrentItem( item );
    }

    encoderChanged();

    for( QValueList<FormatOptions>::Iterator a = formatOptions.begin(); a != formatOptions.end(); ++a )
    {
        FormatItem* formatItem = config->getFormatItem( (*a).format );
        if( formatItem == 0 ) continue;

        QString encoder = (*a).cEncoder->currentText();

        (*a).cInternalReplayGain->setChecked( false );

        for( QValueList<ConvertPlugin*>::Iterator b = formatItem->encoders.begin(); b != formatItem->encoders.end(); ++b ) {
            if( (*b)->enc.bin == encoder && (*b)->enc.strength.enabled ) {
                if( (*b)->enc.strength.range_max >= (*b)->enc.strength.range_min )
                    (*a).sStrength->setValue( (*b)->enc.strength.default_value / (*b)->enc.strength.step );
                else
                    (*a).sStrength->setValue( ( (*b)->enc.strength.range_min - (*b)->enc.strength.default_value ) / (*b)->enc.strength.step );
            }
            if( (*b)->enc.bin == encoder && (*b)->enc.replaygain.enabled ) {
                if( formatItem->replaygain != 0 && formatItem->replaygain->replaygain.rank > (*b)->enc.replaygain.rank ) {
                    (*a).cInternalReplayGain->setChecked( false );
                }
                else {
                    (*a).cInternalReplayGain->setChecked( true );
                }
            }
        }
    }

    strengthChanged();
    cfgChanged();
}

void ConfigBackendsPage::saveSettings()
{
    config->setCurrentRipper( 0 );
    QValueList<RipperPlugin*> rippers = config->allRippers();
    for( QValueList<RipperPlugin*>::Iterator it = rippers.begin(); it != rippers.end(); ++it )
    {
        if( (*it)->rip.bin == cRipper->currentText() ) {
            config->setCurrentRipper( *it );
        }
    }

    for( QValueList<FormatOptions>::Iterator a = formatOptions.begin(); a != formatOptions.end(); ++a )
    {
        FormatItem* formatItem = config->getFormatItem( (*a).format );
        if( formatItem == 0 ) continue;

        for( QValueList<ConvertPlugin*>::Iterator b = formatItem->encoders.begin(); b != formatItem->encoders.end(); ++b ) {
            if( (*b)->enc.bin == (*a).cEncoder->currentText() ) {
                formatItem->encoder = (*b);
                if( (*b)->enc.strength.enabled ) {
                    formatItem->compressionLevel = (*a).sStrength->value();
                }
                if( (*b)->enc.replaygain.enabled ) {
                    formatItem->internalReplayGain = (*a).cInternalReplayGain->isChecked();
                }
            }
        }

        for( QValueList<ConvertPlugin*>::Iterator b = formatItem->decoders.begin(); b != formatItem->decoders.end(); ++b ) {
            if( (*b)->dec.bin == (*a).cDecoder->currentText() ) {
                formatItem->decoder = (*b);
            }
        }

        for( QValueList<ReplayGainPlugin*>::Iterator b = formatItem->replaygains.begin(); b != formatItem->replaygains.end(); ++b ) {
            if( (*b)->replaygain.bin == (*a).cReplayGain->currentText() ) {
                formatItem->replaygain = (*b);
            }
        }
    }
}

void ConfigBackendsPage::rebuild()
{
    for( QValueList<FormatOptions>::Iterator it = formatOptions.begin(); it != formatOptions.end(); ++it )
    {
        delete (*it).lEncoder;
        disconnect( (*it).cEncoder, SIGNAL(activated(int)), 0, 0 );
        delete (*it).cEncoder;
        delete (*it).lStrength;
        disconnect( (*it).sStrength,SIGNAL(valueChanged(int)), 0, 0 );
        delete (*it).sStrength;
        delete (*it).lStrengthDisplay;
        delete (*it).lDecoder;
        disconnect( (*it).cDecoder, SIGNAL(activated(int)), 0, 0 );
        delete (*it).cDecoder;
        delete (*it).lReplayGain;
        disconnect( (*it).cReplayGain, SIGNAL(activated(int)), 0, 0 );
        delete (*it).cReplayGain;
        disconnect( (*it).cInternalReplayGain, SIGNAL(toggled(bool)), 0, 0 );
        delete (*it).cInternalReplayGain;
        delete (*it).grid;
        delete (*it).group;
    }

    formatOptions.clear();

    // TODO show all extensions

    QStringList formats = config->allFormats();

    for( QStringList::Iterator it = formats.begin(); it != formats.end(); ++it )
    {
        FormatOptions options;
        options.format = *it;

        options.group = new QGroupBox( options.format, box, options.format );
        options.group->setColumnLayout( 0, Qt::Vertical );
        options.group->layout()->setSpacing( 6 );
        options.group->layout()->setMargin( 6 );
        options.group->show();
        options.grid = new QGridLayout( options.group->layout() );

        options.lEncoder = new QLabel( i18n("Encoder")+":", options.group, options.format );
        options.lEncoder->show();
        options.grid->addWidget( options.lEncoder, 0, 0 );
        options.cEncoder = new KComboBox( options.group, options.format );
        options.cEncoder->show();
        connect( options.cEncoder, SIGNAL(activated(int)),
                   this, SLOT(cfgChanged())
                 );
        connect( options.cEncoder, SIGNAL(activated(int)),
                   this, SLOT(encoderChanged())
                 );
        options.grid->addWidget( options.cEncoder, 0, 1 );

        options.lStrength = new QLabel( i18n("Strength")+":", options.group, options.format );
        options.lStrength->setAlignment( Qt::AlignRight | Qt::AlignVCenter );
        options.lStrength->show();
        options.grid->addWidget( options.lStrength, 0, 2 );
        options.sStrength = new QSlider( Qt::Horizontal, options.group, options.format );
        options.sStrength->setTickmarks( QSlider::Below );
        options.sStrength->show();
        QToolTip::add( options.sStrength, i18n("Set the compression strength:\n\nLeft = fast conversion\nRight = good resultant file") );
        options.grid->addWidget( options.sStrength, 0, 3 );
        connect( options.sStrength, SIGNAL(valueChanged(int)),
                   this, SLOT(cfgChanged())
                 );
        connect( options.sStrength, SIGNAL(valueChanged(int)),
                   this, SLOT(strengthChanged())
                 );

        options.lDecoder = new QLabel( i18n("Decoder")+":", options.group, options.format );
        options.lDecoder->show();
        options.grid->addWidget( options.lDecoder, 1, 0 );
        options.cDecoder = new KComboBox( options.group, options.format );
        options.cDecoder->show();
        options.grid->addWidget( options.cDecoder, 1, 1 );
        connect( options.cDecoder, SIGNAL(activated(int)),
                   this, SLOT(cfgChanged())
                 );
        options.lStrengthDisplay = new QLabel( "", options.group, options.format );
        options.lStrengthDisplay->setAlignment( Qt::AlignRight | Qt::AlignVCenter );
        options.lStrengthDisplay->setEnabled( false );
        options.grid->addWidget( options.lStrengthDisplay, 1, 3 );

        options.lReplayGain = new QLabel( i18n("Replay Gain")+":", options.group, options.format );
        options.lReplayGain->show();
        options.grid->addWidget( options.lReplayGain, 2, 0 );
        options.cReplayGain = new KComboBox( options.group, options.format );
        options.cReplayGain->show();
        options.grid->addWidget( options.cReplayGain, 2, 1 );
        connect( options.cReplayGain, SIGNAL(activated(int)),
                   this, SLOT(cfgChanged())
                 );
        options.cInternalReplayGain = new QCheckBox( i18n("Use internal Replay Gain"), options.group, options.format );
        QToolTip::add( options.cInternalReplayGain, i18n("Use the internal Replay Gain calculator of the encoder") );
        options.grid->addWidget( options.cInternalReplayGain, 2, 3 );
        connect( options.cInternalReplayGain, SIGNAL(toggled(bool)),
                   this, SLOT(cfgChanged())
                 );

        options.grid->setColStretch( 0, 0 );
        options.grid->setColStretch( 1, 1 );
        options.grid->setColStretch( 2, 1 );
        options.grid->setColStretch( 3, 1 );

        formatOptions.append( options );
    }

    refill();
}

void ConfigBackendsPage::refill()
{
    KStandardDirs* stdDirs = new KStandardDirs();
    int i;
    int item;

    cRipper->clear();
    cRipper->insertItem( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledyellow.png")), i18n("KDE audio CD protocol") );
    i = 1;
    item = 0;
    QValueList<RipperPlugin*> rippers = config->allRippers();
    for( QValueList<RipperPlugin*>::Iterator it = rippers.begin(); it != rippers.end(); ++it )
    {
        if( (*binaries)[(*it)->rip.bin] != "" && (*it)->rip.rank >= 70 ) cRipper->insertItem( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledgreen.png")), (*it)->rip.bin );
        else if( (*binaries)[(*it)->rip.bin] != "" && (*it)->rip.rank >= 40 ) cRipper->insertItem( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledyellow.png")), (*it)->rip.bin );
        else if( (*binaries)[(*it)->rip.bin] != "" ) cRipper->insertItem( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledred.png")), (*it)->rip.bin );
        if( (*binaries)[(*it)->rip.bin] != "" && (*it) == config->getCurrentRipper() ) item = i;
        i++;
    }
    cRipper->setCurrentItem( item );

    for( QValueList<FormatOptions>::Iterator a = formatOptions.begin(); a != formatOptions.end(); ++a )
    {
        FormatItem* formatItem = config->getFormatItem( (*a).format );
        (*a).cEncoder->clear();
        (*a).sEncoder.clear();
        (*a).cDecoder->clear();
        (*a).sDecoder.clear();
        (*a).cReplayGain->clear();
        (*a).sReplayGain.clear();
        if( formatItem == 0 ) continue;

        i = item = 0;
        for( QValueList<ConvertPlugin*>::Iterator b = formatItem->encoders.begin(); b != formatItem->encoders.end(); ++b ) {
            (*a).sEncoder += (*b)->enc.bin;
            if( (*binaries)[(*b)->enc.bin] != "" && (*b)->enc.rank >= 70 ) (*a).cEncoder->insertItem( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledgreen.png")), (*b)->enc.bin );
            else if( (*binaries)[(*b)->enc.bin] != "" && (*b)->enc.rank >= 40 ) (*a).cEncoder->insertItem( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledyellow.png")), (*b)->enc.bin );
            else if( (*binaries)[(*b)->enc.bin] != "" ) (*a).cEncoder->insertItem( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledred.png")), (*b)->enc.bin );
            if( (*binaries)[(*b)->enc.bin] != "" && (*b) == formatItem->encoder ) item = i;
            i++;
        }
        (*a).cEncoder->setCurrentItem( item );

        i = item = 0;
        for( QValueList<ConvertPlugin*>::Iterator b = formatItem->decoders.begin(); b != formatItem->decoders.end(); ++b ) {
            (*a).sDecoder += (*b)->dec.bin;
            if( (*binaries)[(*b)->dec.bin] != "" && (*b)->dec.rank >= 70 ) (*a).cDecoder->insertItem( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledgreen.png")), (*b)->dec.bin );
            else if( (*binaries)[(*b)->dec.bin] != "" && (*b)->dec.rank >= 40 ) (*a).cDecoder->insertItem( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledyellow.png")), (*b)->dec.bin );
            else if( (*binaries)[(*b)->dec.bin] != "" ) (*a).cDecoder->insertItem( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledred.png")), (*b)->dec.bin );
            if( (*binaries)[(*b)->dec.bin] != "" && (*b) == formatItem->decoder ) item = i;
            i++;
        }
        (*a).cDecoder->setCurrentItem( item );

        i = item = 0;
        for( QValueList<ReplayGainPlugin*>::Iterator b = formatItem->replaygains.begin(); b != formatItem->replaygains.end(); ++b ) {
            (*a).sReplayGain += (*b)->replaygain.bin;
            if( (*binaries)[(*b)->replaygain.bin] != "" && (*b)->replaygain.rank >= 70 ) (*a).cReplayGain->insertItem( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledgreen.png")), (*b)->replaygain.bin );
            else if( (*binaries)[(*b)->replaygain.bin] != "" && (*b)->replaygain.rank >= 40 ) (*a).cReplayGain->insertItem( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledyellow.png")), (*b)->replaygain.bin );
            else if( (*binaries)[(*b)->replaygain.bin] != "" ) (*a).cReplayGain->insertItem( QPixmap(stdDirs->findResource("data","soundkonverter/pics/ledred.png")), (*b)->replaygain.bin );
            if( (*binaries)[(*b)->replaygain.bin] != "" && (*b) == formatItem->replaygain ) item = i;
            i++;
        }
        (*a).cReplayGain->setCurrentItem( item );
    }

    delete stdDirs;

    encoderChanged();
}

void ConfigBackendsPage::encoderChanged()
{
    bool recalc;

    for( QValueList<FormatOptions>::Iterator a = formatOptions.begin(); a != formatOptions.end(); ++a )
    {
        FormatItem* formatItem = config->getFormatItem( (*a).format );
        (*a).lStrength->hide();
        (*a).sStrength->hide();
        (*a).lStrengthDisplay->hide();
        (*a).cInternalReplayGain->hide();
        if( formatItem == 0 ) continue;

        QString encoder = (*a).cEncoder->currentText();

        for( QValueList<ConvertPlugin*>::Iterator b = formatItem->encoders.begin(); b != formatItem->encoders.end(); ++b ) {
            if( QObject::sender() && (*a).format == QObject::sender()->name() ) recalc = true;
            else if( !QObject::sender() ) recalc = true;
            else recalc = false;
            if( (*b)->enc.bin == encoder && (*b)->enc.strength.enabled ) {
                (*a).lStrength->show();
                if( (*b)->enc.strength.range_max >= (*b)->enc.strength.range_min ) {
                    (*a).sStrength->setMinValue( (int)((*b)->enc.strength.range_min/(*b)->enc.strength.step) );
                    (*a).sStrength->setMaxValue( (int)((*b)->enc.strength.range_max/(*b)->enc.strength.step) );
                }
                else {
                    (*a).sStrength->setMinValue( (int)((*b)->enc.strength.range_max/(*b)->enc.strength.step) );
                    (*a).sStrength->setMaxValue( (int)((*b)->enc.strength.range_min/(*b)->enc.strength.step) );
                }
                (*a).sStrength->setPageStep( 1 );
                if( QObject::sender() && (*a).format == QObject::sender()->name() ) {
                    if( (*b)->enc.strength.range_max >= (*b)->enc.strength.range_min )
                        (*a).sStrength->setValue( (*b)->enc.strength.default_value / (*b)->enc.strength.step );
                    else
                        (*a).sStrength->setValue( ( (*b)->enc.strength.range_min - (*b)->enc.strength.default_value ) / (*b)->enc.strength.step );
                }
                else if( !QObject::sender() ) {
                    (*a).sStrength->setValue( formatItem->compressionLevel );
                }
                (*a).sStrength->show();
                (*a).lStrengthDisplay->show();
            }
            if( (*b)->enc.bin == encoder && (*b)->enc.replaygain.enabled ) {
                (*a).cInternalReplayGain->show();
                if( recalc ) (*a).cInternalReplayGain->setChecked( formatItem->internalReplayGain );
            }
        }
    }

    strengthChanged();
}

void ConfigBackendsPage::strengthChanged()
{
    for( QValueList<FormatOptions>::Iterator a = formatOptions.begin(); a != formatOptions.end(); ++a )
    {
        FormatItem* formatItem = config->getFormatItem( (*a).format );
        if( formatItem == 0 ) continue;

        QString encoder = (*a).cEncoder->currentText();

        for( QValueList<ConvertPlugin*>::Iterator b = formatItem->encoders.begin(); b != formatItem->encoders.end(); ++b ) {
            if( (*b)->enc.bin == encoder && (*b)->enc.strength.enabled ) {
                QString strength = (*b)->enc.strength.param;
                int compressionLevel = (*a).sStrength->value();
                if( (*b)->enc.strength.profiles.empty() ) {
                    if( (*b)->enc.strength.step < 1 ) {
                        if( (*b)->enc.strength.range_max >= (*b)->enc.strength.range_min )
                            strength.replace( "%c", QString::number( compressionLevel * (*b)->enc.strength.step ) );
                        else
                            strength.replace( "%c", QString::number( (*b)->enc.strength.range_min - compressionLevel * (*b)->enc.strength.step ) );
                    }
                    else {
                        if( (*b)->enc.strength.range_max >= (*b)->enc.strength.range_min )
                            strength.replace( "%c", QString::number( (int)(compressionLevel * (*b)->enc.strength.step) ) );
                        else
                            strength.replace( "%c", QString::number( (int)((*b)->enc.strength.range_min - compressionLevel * (*b)->enc.strength.step) ) );
                    }
                    if( (*b)->enc.strength.separator != '.' ) strength.replace( QChar('.'), (*b)->enc.strength.separator );
                }
                else {
                    QStringList::Iterator it = (*b)->enc.strength.profiles.at( (int)compressionLevel );
                    strength.replace( "%c", *it );
                }
                (*a).lStrengthDisplay->setText( "( \"" + strength + "\" )" );
            }
        }
    }
}



