

#ifndef CONFIGBACKENDSPAGE_H
#define CONFIGBACKENDSPAGE_H

#include <configpagebase.h>

#include <qstringlist.h>

class Config;
class KComboBox;
class KScrollView;
class QGroupBox;
class QGridLayout;
class QLabel;
class QSlider;
class QCheckBox;
class QVBox;

/**
* @short The page for configuring the environment
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConfigBackendsPage : public ConfigPageBase
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    ConfigBackendsPage( Config*, QMap<QString, QString>*, QWidget *parent=0, const char *name=0 );

    /**
     * Default Destructor
     */
    virtual ~ConfigBackendsPage();

private:
    struct FormatOptions
    {
        // TODO remove the string lists
        QString format;
        QGroupBox* group;
        QGridLayout* grid;
        QLabel* lEncoder;
        KComboBox* cEncoder;
        QStringList sEncoder;
        QLabel* lStrength;
        QSlider* sStrength;
        QLabel* lStrengthDisplay;
        QLabel* lDecoder;
        KComboBox* cDecoder;
        QStringList sDecoder;
        QLabel* lReplayGain;
        KComboBox* cReplayGain;
        QStringList sReplayGain;
        QCheckBox* cInternalReplayGain;
    };

    QValueList<FormatOptions> formatOptions;

    QGridLayout* grid;
    KScrollView* scrollView;
    QVBox* box;

    KComboBox* cRipper;

    Config* config;

    QMap<QString, QString>* binaries;

public slots:
    void resetDefaults();
    void saveSettings();
    void rebuild();
    void refill();
    void encoderChanged();
    void strengthChanged();

};

#endif // CONFIGBACKENDSPAGE_H

