

#ifndef PROGRESSINDICATOR_H
#define PROGRESSINDICATOR_H

#include <qwidget.h>
#include <qdatetime.h>

class QProgressBar;
class QLabel;
class KSystemTray;

/**
 * @short Displays the current progress
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ProgressIndicator : public QWidget
{
    Q_OBJECT
public:
    /**
     * Constructor
     */
    ProgressIndicator( KSystemTray* _systemTray, QWidget* parent = 0, const char* name = 0 );

    /**
     * Destructor
     */
    virtual ~ProgressIndicator();

public slots:
    void increaseTime( float );
    void decreaseTime( float );
    void countTime( float );
    void uncountTime( float );
    void setTime( float );
    void finished( float );

    void update( float );

//private slots:

private:
    QProgressBar* pBar;
    QLabel* lSpeed;
    QLabel* lTime;
    KSystemTray* systemTray;

    QTime elapsedTime;
    QTime speedTime;
    float speedProcessedTime;

    float time;
    float processedTime;

signals:
    void setTitle( const QString& );
};

#endif // PROGRESSINDICATOR_H
