// generated by Fast Light User Interface Designer (fluid) version 1.0010

#include "Fl_DragBar.H"
#include <string.h>

Fl_DragBar::Fl_DragBar(int x,int y,int w,int h,const char *l): Fl_Widget(x,y,w,h,l) {
  _type = Fl_DragBar::NICEFLDRAG;
}

Fl_DragBar::~Fl_DragBar() {
fl_cursor(FL_CURSOR_DEFAULT);
}

void Fl_DragBar::draw() {
  int ww,hh;
  uchar r,g,b;
  uchar rb,gb,bb;
  uchar rd,gd,bd;
  int	val;
  
	draw_box();
	int x1 = x()+5;
	int x2 = x()+w()-5;
	int y1 = y()+5;
	int y2 = y()+h()-5;
	Fl::get_color(color(),r,g,b);
	val = (int)r + 64; rb = val > 255 ? 255:val;
	val = (int)g + 64; gb = val > 255 ? 255:val;
	val = (int)b + 64; bb = val > 255 ? 255:val;
	val = (int)r - 64; rd = val < 0 ? 0:val;
	val = (int)g - 64; gd = val < 0 ? 0:val;
	val = (int)b - 64; bd = val < 0 ? 0:val;
	if (h()<w())
	{
		if ((_type==Fl_DragBar::NICEWINDRAG) || (_type==Fl_DragBar::NICEFLDRAG))
		{
			fl_line_style(FL_DASH);
			for (int i = y() + 4; i < y()+h()-5;i+=3)
			{
				fl_line_style(FL_DASH);
				fl_color(rb,gb,bb);
				fl_line(x1,i,x2,i);
				fl_color(rd,gd,bd);
				fl_line(x1,i+1,x2,i+1);
			}
			fl_line_style(FL_SOLID);
		}
		fl_color(color());
		const char *l = label();
		ww = labelsize()*strlen(l)/2;
		//ww = (int)fl_width(l);
		hh = h() - 4;
		if (align() & FL_ALIGN_RIGHT)
		{
			x1 = x() + w() - 5 - ww;
		}
		else
		if (align() & FL_ALIGN_CENTER)
		{
			x1 = x() + 5;
		}
		else
		{
			x1 = x() + (w() - ww) / 2;
		}
		//fl_rectf(x1,y()+(h() - hh) / 2, ww, hh);
		draw_label();
	}
	else
	if ((_type==Fl_DragBar::NICEWINDRAG) || (_type==Fl_DragBar::NICEFLDRAG))
	{
		fl_line_style(FL_DASH);	
		for (int i = x() + 4; i < x()+w()-5;i+=3)
		{
			fl_color(rb,gb,bb);
			fl_line(i,y1,i,y2);
			fl_color(rd,gd,bd);
			fl_line(i+1,y1,i+1,y2);
		}
		fl_line_style(FL_SOLID);
	}
}

int Fl_DragBar::handle(int event) {
  int rx,ry,xx,yy;
int mx,my;

	if (Fl::event_button()!=1) return 0;

	if (_type <  (int)Fl_DragBar::FLDRAG)
	{
		rx = Fl::event_x_root(); 
		ry = Fl::event_y_root();
	}
	else
	{ 
		rx = Fl::event_x();
		ry = Fl::event_y();
	}
	switch(event)
	{
		case FL_PUSH:
		{
			window()->show();
			fl_cursor(FL_CURSOR_MOVE);
			if (_type < (int)Fl_DragBar::FLDRAG)
			{
				old_rx = rx - window()->x();
				old_ry = ry - window()->y();
			}
			else
			{
				old_rx = rx - parent()->x();
				old_ry = ry - parent()->y();
			}
			return 1;
		}
		case FL_RELEASE:
		{
			fl_cursor(FL_CURSOR_DEFAULT);
			do_callback();
			return 1;
		}
		case FL_DRAG:
		{
			if ((rx != old_rx) || (ry != old_ry))
			{
				xx =  rx - old_rx;
				yy =  ry - old_ry;
				if (_type <  (int)Fl_DragBar::FLDRAG) 
				{
					window()->position(xx,yy);
				}
				else
				{
					parent()->position(xx,yy);
					if (parent()->parent()) 
						parent()->parent()->redraw();
					else
						window()->redraw();		
				}		
			}
			return 1;
		}
		case FL_MOVE:
		{
			return 0;
		}
		case FL_ENTER :
		{
			return 0;
		}
		
		case FL_LEAVE :
		{
			fl_cursor(FL_CURSOR_DEFAULT);
			return 1;
		}
		default :
			return 0;
	}
}

void Fl_DragBar::type(int t) {
  _type = t;
}
