#ifdef __GNUC__
#  pragma implementation "postscript.H"
#endif

#include "postscript.H"
#include <string.h>

TPostScript::TPostScript(ostream& o1, greal xmax, greal ymax1,
						 greal titlefontsize, greal labelfontsize, greal axisfontsize, greal annotfontsize,
						 bool landscape1, const char *papertype)
	: o(o1), landscape(landscape1), ymax(ymax1)
{
	o << "%!PS-Adobe-2.0";
	if (papertype && *papertype) o << "\n"; else o << " EPSF-2.0\n";
	o << "%%Creator: SPPC (Simple Panel Plot Composer (c) 2000 Pekka Janhunen, FMI/GEO)\n";
	o << "%%Title: SPPC output\n";
	o << "%%Pages: 1\n";
	o << "%%PageOrder: Ascend\n";
	o << "%%BoundingBox: 0 0 " << (landscape ? ymax : xmax) << " " << (landscape ? xmax : ymax) << "\n";
	o << "%%Orientation: " << (landscape ? "Landscape" : "Portrait") << "\n";
	if (papertype && *papertype)
		o << "%%DocumentPaperSizes: " << papertype << "\n";
	o << "%%EndComments\n";
	o << "%!\n";
	if (landscape) {
		o << "% Rotate and translate for landscape mode\n";
		o << "% ---------------------------------------\n";
		o << "90 rotate\n";
		o << "0 -" << ymax << " translate\n";
	}
	o << "/defFontSizeTopLbl " << titlefontsize << " def\n";
	o << "/defFontSizeSideLbl " << labelfontsize << " def\n";
	o << "/defFontSizeAxisLbl " << axisfontsize << " def\n";
	o << "/defFontSizeAnnotLbl " << annotfontsize << " def\n";
	o <<
#include "prolog.ps"
		;
	o << "%%EndProlog\n";
	if (papertype && *papertype) {
		o << "%%BeginSetup\n";
		o << "%%PaperSize: " << papertype << "\n";
		o << "%%EndSetup\n";
	}
	o << "%%Page: 1 1\n";
	Tgraph2D::setpalette(Tgraph2D::PALETTE_RAINBOW);
//	o << "setAxisLblFont\n";
}

void TPostScript::begin_line(greal x, greal y)
{
	o << x << " " << y << " M\n";
}

void TPostScript::vertex(greal x1, greal y1)
{
	o << x1 << " " << y1 << " L\n";
}

void TPostScript::end_line()
{
	o << "S\n";
}

void TPostScript::begin_fill(greal x, greal y)
{
	o << x << " " << y << " M\n";
}

void TPostScript::end_fill()
{
	o << "closepath fill\n";
}

void TPostScript::point(greal x, greal y)
{
	o << x << " " << y << " M\n";
	o << "1 0 R S\n";
}

void TPostScript::circle(greal x, greal y, greal r)
{
	o << "N " << x << " " << y << " " << r << " 0 360 arc S\n";
}

void TPostScript::fillcircle(greal x, greal y, greal r)
{
	o << "N " << x << " " << y << " " << r << " 0 360 arc fill\n";
}

void TPostScript::text(greal x, greal y, const char *s, int Xoffset, int Yoffset, bool rotate)
{
	if (rotate) {
		o << "90 rotate\n";
		o << y << " " << -x << " M\n";
	} else {
		o << x << " " << y << " M\n";
	}
	o << "(";
	int i;
	for (i=0; s[i]; i++) {
		if (s[i] == '(')
			o << "\\050";
		else if (s[i] == ')')
			o << "\\051";
		else
			o.put(s[i]);
	}
	o << ") ";
	if (Yoffset < 0)
		o << "BOT";
	else if (Yoffset == 0)
		o << "MID";
	else
		o << "UP";
	o << " ";
	if (Xoffset < 0)
		o << "LEF";
	else if (Xoffset == 0)
		o << "CEN";
	else
		o << "RIG";
	o << " show\n";
	if (rotate) o << "-90 rotate\n";
}

void TPostScript::text_exponent(greal x, greal y, const char *mant, const char *expo, int Xoffset, int Yoffset)
{
	o << x << " " << y << " M\n";
	o << "(10 ) ";
	if (Yoffset < 0)
		o << "BOT";
	else if (Yoffset == 0)
		o << "MID";
	else
		o << "UP";
	o << " ";
	if (Xoffset < 0)
		o << "LEF";
	else if (Xoffset == 0)
		o << "CEN";
	else
		o << "RIG";
	o << " pop (" << mant << ") (" << expo << ") Exponentshow\n";
}

void TPostScript::comment(greal x, greal y)
{
	o << "%" << x << " " << y << "\n";
}

void TPostScript::comment(const char *s)
{
	const int n = strlen(s);
	o << "% " << s << "\n% ";
	for (int i=0; i<n; i++) o << '-';
	o << "\n";
}

void TPostScript::setfont(TFontType font)
{
	switch (font) {
	case FONT_AXISLABEL:
		o << "setAxisLblFont\n";
		break;
	case FONT_ANNOTATION:
		o << "setAnnotLblFont\n";
		break;
	case FONT_TOPLABEL:
		o << "setTopLblFont\n";
		break;
	case FONT_SIDELABEL:
		o << "setSideLblFont\n";
		break;
	case FONT_COPYRIGHT:
		o << "setCopyrightFont\n";
		break;
	}
}

void TPostScript::setcolor(const greal rgb[3])
{
	if (rgb[0] == rgb[1] && rgb[1] == rgb[2])
		o << rgb[0] << " G\n";
	else
		o << rgb[0] << " " << rgb[1] << " " << rgb[2] << " C\n";
}

void TPostScript::setcolor(int i)
{
	if (i < 0) i = 0; else if (i > 255) i = 255;
	o << i << " IC\n";
}

void TPostScript::setlinewidth(greal lw)
{
	o << lw << " setlinewidth\n";
}

void TPostScript::setlinetype(TLineType lt)
{
	char *i = "1";
	switch (lt) {
	case LINE_NONE:
		i = "0";
		break;
	case LINE_SOLID:
		i = "1";
		break;
	case LINE_DOTTED:
		i = "3";
		break;
	case LINE_DASHED:
		i = "2";
		break;
	case LINE_DOTDASHED:
		i = "4";
		break;
	case LINE_GRIDDOTTED:
		i = "_GD";
		break;
	}
	o << "MLT" << i << "\n";
	linetype_set = lt;
}

void TPostScript::begin_clipped(greal x1, greal y1, greal x2, greal y2)
{
	o << "gsave\n";
	o << "N " << x1 << " " << y1 << " M\n";
	o << x2 << " " << y1 << " L\n";
	o << x2 << " " << y2 << " L\n";
	o << x1 << " " << y2 << " L\n";
	o << "closepath clip N\n";
}

void TPostScript::fillrrect(greal x1, greal y1, greal dx, greal dy)
{
	o << x1 << " " << y1 << " " << dx << " " << dy << " FQ\n";
#if 0
	o << "N " << x1 << " " << y1 << " M\n";
	o << dx << " 0 R\n";
	o << "0 " << dy << " R\n";
	o << -dx << " 0 R\n";
	o << "closepath fill\n";
#endif
}

void TPostScript::fillrrect_interp(greal x1, greal y1, greal dx, greal dy, int u1, int u2, int u3, int u4)
{
	o << x1 << " " << y1 << " " << dx << " " << dy << " "
	  << limit(u1,0,Ncolors-1) << " " << limit(u2,0,Ncolors-1) << " "
	  << limit(u3,0,Ncolors-1) << " " << limit(u4,0,Ncolors-1) << " Q\n";
}

void TPostScript::end_clipped()
{
	o << "grestore\n";
}

void TPostScript::setpalette(const int pal[3][Ncolors])
{
	int i;
	comment("Set color palette");
	o << "/RE [";
	for (i=0; i<Ncolors; i++) o << pal[0][i]/real(Ncolors) << ' ';
	o << "] def\n";
	o << "/GR [";
	for (i=0; i<Ncolors; i++) o << pal[1][i]/real(Ncolors) << ' ';
	o << "] def\n";
	o << "/BL [";
	for (i=0; i<Ncolors; i++) o << pal[2][i]/real(Ncolors) << ' ';
	o << "] def\n";
}

void TPostScript::gsave() {o << "gsave\n";}
void TPostScript::grestore() {o << "grestore\n";}

TPostScript::~TPostScript()
{
	o << "showpage\n";
	if (landscape) {
		o << "% Unrotate for landscape mode\n";
		o << "% ---------------------------\n";
		o << "0 " << ymax << " translate\n";
		o << "-90 rotate\n";
	}
	o << "%%Trailer\n";
	o << "%%EOF\n";
}
