<?php
/**
 * functions/decode/x_mac_chinsimp.php
 * $Id: x_mac_chinsimp.php,v 1.5 2005/06/08 12:36:53 tokul Exp $
 *
 * Copyright (c) 2003-2005 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * Original data taken from:
 *  ftp://ftp.unicode.org/Public/MAPPINGS/VENDORS/APPLE/CHINSIMP.TXT
 * 
 * Contents:
 * Map (external version) from Mac OS Chinese
 * Simplified encoding to Unicode 3.0 through Unicode 3.2
 * 
 * Copyright:  (c) 1995-2002 by Apple Computer, Inc., all rights reserved.
 *
 * Contact:    charsets@apple.com
 *
 * Standard header:
 * Apple, the Apple logo, and Macintosh are trademarks of Apple
 * Computer, Inc., registered in the United States and other countries.
 * Unicode is a trademark of Unicode Inc. For the sake of brevity,
 * throughout this document, ""Macintosh"" can be used to refer to
 * Macintosh computers and ""Unicode"" can be used to refer to the
 * Unicode standard.
 *
 * Apple makes no warranty or representation, either express or
 * implied, with respect to these tables, their quality, accuracy, or
 * fitness for a particular purpose. In no event will Apple be liable
 * for direct, indirect, special, incidental, or consequential damages 
 * resulting from any defect or inaccuracy in this document or the
 * accompanying tables.
 * 
 * These mapping tables and character lists are subject to change.
 * The latest tables should be available from the following:
 * 
 * <http://www.unicode.org/Public/MAPPINGS/VENDORS/APPLE/>
 *
 * @package decode
 * @subpackage x-mac
 */

/**
 * Decode x-mac-chinsimp string
 * @param string $string String to decode
 * @return string $string Html formated string
 */
function charset_decode_x_mac_chinsimp ($string) {
    // don't do decoding when there are no 8bit symbols
    if (! sq_is8bit($string,'x-mac-chinsimp'))
        return $string;

    $mac_chinsimp = array(
	"\x80" => '&#252;&#63615;',
	"\x81" => '&#63616;',
	"\x82" => '&#63617;',
	"\xA0" => '&#160;',
	"\xFD" => '&#169;',
	"\xFE" => '&#8482;',
	"\xFF" => '&#8230;',
	"\xA1A1" => '&#12288;',
	"\xA1A2" => '&#12289;',
	"\xA1A3" => '&#12290;',
	"\xA1A4" => '&#183;',
	"\xA1A5" => '&#713;',
	"\xA1A6" => '&#711;',
	"\xA1A7" => '&#168;',
	"\xA1A8" => '&#12291;',
	"\xA1A9" => '&#12293;',
	"\xA1AA" => '&#8212;',
	"\xA1AB" => '&#12316;',
	"\xA1AC" => '&#8214;',
	"\xA1AD" => '&#8943;',
	"\xA1AE" => '&#8216;',
	"\xA1AF" => '&#8217;',
	"\xA1B0" => '&#8220;',
	"\xA1B1" => '&#8221;',
	"\xA1B2" => '&#12308;',
	"\xA1B3" => '&#12309;',
	"\xA1B4" => '&#12296;',
	"\xA1B5" => '&#12297;',
	"\xA1B6" => '&#12298;',
	"\xA1B7" => '&#12299;',
	"\xA1B8" => '&#12300;',
	"\xA1B9" => '&#12301;',
	"\xA1BA" => '&#12302;',
	"\xA1BB" => '&#12303;',
	"\xA1BC" => '&#12310;',
	"\xA1BD" => '&#12311;',
	"\xA1BE" => '&#12304;',
	"\xA1BF" => '&#12305;',
	"\xA1C0" => '&#177;',
	"\xA1C1" => '&#215;',
	"\xA1C2" => '&#247;',
	"\xA1C3" => '&#8758;',
	"\xA1C4" => '&#8743;',
	"\xA1C5" => '&#8744;',
	"\xA1C6" => '&#8721;',
	"\xA1C7" => '&#8719;',
	"\xA1C8" => '&#8746;',
	"\xA1C9" => '&#8745;',
	"\xA1CA" => '&#8712;',
	"\xA1CB" => '&#8759;',
	"\xA1CC" => '&#8730;',
	"\xA1CD" => '&#8869;',
	"\xA1CE" => '&#8741;',
	"\xA1CF" => '&#8736;',
	"\xA1D0" => '&#8978;',
	"\xA1D1" => '&#8857;',
	"\xA1D2" => '&#8747;',
	"\xA1D3" => '&#8750;',
	"\xA1D4" => '&#8801;',
	"\xA1D5" => '&#8780;',
	"\xA1D6" => '&#8776;',
	"\xA1D7" => '&#8765;',
	"\xA1D8" => '&#8733;',
	"\xA1D9" => '&#8800;',
	"\xA1DA" => '&#8814;',
	"\xA1DB" => '&#8815;',
	"\xA1DC" => '&#8804;',
	"\xA1DD" => '&#8805;',
	"\xA1DE" => '&#8734;',
	"\xA1DF" => '&#8757;',
	"\xA1E0" => '&#8756;',
	"\xA1E1" => '&#9794;',
	"\xA1E2" => '&#9792;',
	"\xA1E3" => '&#176;',
	"\xA1E4" => '&#8242;',
	"\xA1E5" => '&#8243;',
	"\xA1E6" => '&#8451;',
	"\xA1E7" => '&#65284;',
	"\xA1E8" => '&#164;',
	"\xA1E9" => '&#162;',
	"\xA1EA" => '&#163;',
	"\xA1EB" => '&#8240;',
	"\xA1EC" => '&#167;',
	"\xA1ED" => '&#8470;',
	"\xA1EE" => '&#9734;',
	"\xA1EF" => '&#9733;',
	"\xA1F0" => '&#9675;',
	"\xA1F1" => '&#9679;',
	"\xA1F2" => '&#9678;',
	"\xA1F3" => '&#9671;',
	"\xA1F4" => '&#9670;',
	"\xA1F5" => '&#9633;',
	"\xA1F6" => '&#9632;',
	"\xA1F7" => '&#9651;',
	"\xA1F8" => '&#9650;',
	"\xA1F9" => '&#8251;',
	"\xA1FA" => '&#8594;',
	"\xA1FB" => '&#8592;',
	"\xA1FC" => '&#8593;',
	"\xA1FD" => '&#8595;',
	"\xA1FE" => '&#12307;',
	"\xA2B1" => '&#9352;',
	"\xA2B2" => '&#9353;',
	"\xA2B3" => '&#9354;',
	"\xA2B4" => '&#9355;',
	"\xA2B5" => '&#9356;',
	"\xA2B6" => '&#9357;',
	"\xA2B7" => '&#9358;',
	"\xA2B8" => '&#9359;',
	"\xA2B9" => '&#9360;',
	"\xA2BA" => '&#9361;',
	"\xA2BB" => '&#9362;',
	"\xA2BC" => '&#9363;',
	"\xA2BD" => '&#9364;',
	"\xA2BE" => '&#9365;',
	"\xA2BF" => '&#9366;',
	"\xA2C0" => '&#9367;',
	"\xA2C1" => '&#9368;',
	"\xA2C2" => '&#9369;',
	"\xA2C3" => '&#9370;',
	"\xA2C4" => '&#9371;',
	"\xA2C5" => '&#9332;',
	"\xA2C6" => '&#9333;',
	"\xA2C7" => '&#9334;',
	"\xA2C8" => '&#9335;',
	"\xA2C9" => '&#9336;',
	"\xA2CA" => '&#9337;',
	"\xA2CB" => '&#9338;',
	"\xA2CC" => '&#9339;',
	"\xA2CD" => '&#9340;',
	"\xA2CE" => '&#9341;',
	"\xA2CF" => '&#9342;',
	"\xA2D0" => '&#9343;',
	"\xA2D1" => '&#9344;',
	"\xA2D2" => '&#9345;',
	"\xA2D3" => '&#9346;',
	"\xA2D4" => '&#9347;',
	"\xA2D5" => '&#9348;',
	"\xA2D6" => '&#9349;',
	"\xA2D7" => '&#9350;',
	"\xA2D8" => '&#9351;',
	"\xA2D9" => '&#9312;',
	"\xA2DA" => '&#9313;',
	"\xA2DB" => '&#9314;',
	"\xA2DC" => '&#9315;',
	"\xA2DD" => '&#9316;',
	"\xA2DE" => '&#9317;',
	"\xA2DF" => '&#9318;',
	"\xA2E0" => '&#9319;',
	"\xA2E1" => '&#9320;',
	"\xA2E2" => '&#9321;',
	"\xA2E5" => '&#12832;',
	"\xA2E6" => '&#12833;',
	"\xA2E7" => '&#12834;',
	"\xA2E8" => '&#12835;',
	"\xA2E9" => '&#12836;',
	"\xA2EA" => '&#12837;',
	"\xA2EB" => '&#12838;',
	"\xA2EC" => '&#12839;',
	"\xA2ED" => '&#12840;',
	"\xA2EE" => '&#12841;',
	"\xA2F1" => '&#8544;',
	"\xA2F2" => '&#8545;',
	"\xA2F3" => '&#8546;',
	"\xA2F4" => '&#8547;',
	"\xA2F5" => '&#8548;',
	"\xA2F6" => '&#8549;',
	"\xA2F7" => '&#8550;',
	"\xA2F8" => '&#8551;',
	"\xA2F9" => '&#8552;',
	"\xA2FA" => '&#8553;',
	"\xA2FB" => '&#8554;',
	"\xA2FC" => '&#8555;',
	"\xA3A1" => '&#65281;',
	"\xA3A2" => '&#65282;',
	"\xA3A3" => '&#65283;',
	"\xA3A4" => '&#165;',
	"\xA3A5" => '&#65285;',
	"\xA3A6" => '&#65286;',
	"\xA3A7" => '&#65287;',
	"\xA3A8" => '&#65288;',
	"\xA3A9" => '&#65289;',
	"\xA3AA" => '&#65290;',
	"\xA3AB" => '&#65291;',
	"\xA3AC" => '&#65292;',
	"\xA3AD" => '&#65293;',
	"\xA3AE" => '&#65294;',
	"\xA3AF" => '&#65295;',
	"\xA3B0" => '&#65296;',
	"\xA3B1" => '&#65297;',
	"\xA3B2" => '&#65298;',
	"\xA3B3" => '&#65299;',
	"\xA3B4" => '&#65300;',
	"\xA3B5" => '&#65301;',
	"\xA3B6" => '&#65302;',
	"\xA3B7" => '&#65303;',
	"\xA3B8" => '&#65304;',
	"\xA3B9" => '&#65305;',
	"\xA3BA" => '&#65306;',
	"\xA3BB" => '&#65307;',
	"\xA3BC" => '&#65308;',
	"\xA3BD" => '&#65309;',
	"\xA3BE" => '&#65310;',
	"\xA3BF" => '&#65311;',
	"\xA3C0" => '&#65312;',
	"\xA3C1" => '&#65313;',
	"\xA3C2" => '&#65314;',
	"\xA3C3" => '&#65315;',
	"\xA3C4" => '&#65316;',
	"\xA3C5" => '&#65317;',
	"\xA3C6" => '&#65318;',
	"\xA3C7" => '&#65319;',
	"\xA3C8" => '&#65320;',
	"\xA3C9" => '&#65321;',
	"\xA3CA" => '&#65322;',
	"\xA3CB" => '&#65323;',
	"\xA3CC" => '&#65324;',
	"\xA3CD" => '&#65325;',
	"\xA3CE" => '&#65326;',
	"\xA3CF" => '&#65327;',
	"\xA3D0" => '&#65328;',
	"\xA3D1" => '&#65329;',
	"\xA3D2" => '&#65330;',
	"\xA3D3" => '&#65331;',
	"\xA3D4" => '&#65332;',
	"\xA3D5" => '&#65333;',
	"\xA3D6" => '&#65334;',
	"\xA3D7" => '&#65335;',
	"\xA3D8" => '&#65336;',
	"\xA3D9" => '&#65337;',
	"\xA3DA" => '&#65338;',
	"\xA3DB" => '&#65339;',
	"\xA3DC" => '&#65340;',
	"\xA3DD" => '&#65341;',
	"\xA3DE" => '&#65342;',
	"\xA3DF" => '&#65343;',
	"\xA3E0" => '&#65344;',
	"\xA3E1" => '&#65345;',
	"\xA3E2" => '&#65346;',
	"\xA3E3" => '&#65347;',
	"\xA3E4" => '&#65348;',
	"\xA3E5" => '&#65349;',
	"\xA3E6" => '&#65350;',
	"\xA3E7" => '&#65351;',
	"\xA3E8" => '&#65352;',
	"\xA3E9" => '&#65353;',
	"\xA3EA" => '&#65354;',
	"\xA3EB" => '&#65355;',
	"\xA3EC" => '&#65356;',
	"\xA3ED" => '&#65357;',
	"\xA3EE" => '&#65358;',
	"\xA3EF" => '&#65359;',
	"\xA3F0" => '&#65360;',
	"\xA3F1" => '&#65361;',
	"\xA3F2" => '&#65362;',
	"\xA3F3" => '&#65363;',
	"\xA3F4" => '&#65364;',
	"\xA3F5" => '&#65365;',
	"\xA3F6" => '&#65366;',
	"\xA3F7" => '&#65367;',
	"\xA3F8" => '&#65368;',
	"\xA3F9" => '&#65369;',
	"\xA3FA" => '&#65370;',
	"\xA3FB" => '&#65371;',
	"\xA3FC" => '&#65372;',
	"\xA3FD" => '&#65373;',
	"\xA3FE" => '&#8254;',
	"\xA4A1" => '&#12353;',
	"\xA4A2" => '&#12354;',
	"\xA4A3" => '&#12355;',
	"\xA4A4" => '&#12356;',
	"\xA4A5" => '&#12357;',
	"\xA4A6" => '&#12358;',
	"\xA4A7" => '&#12359;',
	"\xA4A8" => '&#12360;',
	"\xA4A9" => '&#12361;',
	"\xA4AA" => '&#12362;',
	"\xA4AB" => '&#12363;',
	"\xA4AC" => '&#12364;',
	"\xA4AD" => '&#12365;',
	"\xA4AE" => '&#12366;',
	"\xA4AF" => '&#12367;',
	"\xA4B0" => '&#12368;',
	"\xA4B1" => '&#12369;',
	"\xA4B2" => '&#12370;',
	"\xA4B3" => '&#12371;',
	"\xA4B4" => '&#12372;',
	"\xA4B5" => '&#12373;',
	"\xA4B6" => '&#12374;',
	"\xA4B7" => '&#12375;',
	"\xA4B8" => '&#12376;',
	"\xA4B9" => '&#12377;',
	"\xA4BA" => '&#12378;',
	"\xA4BB" => '&#12379;',
	"\xA4BC" => '&#12380;',
	"\xA4BD" => '&#12381;',
	"\xA4BE" => '&#12382;',
	"\xA4BF" => '&#12383;',
	"\xA4C0" => '&#12384;',
	"\xA4C1" => '&#12385;',
	"\xA4C2" => '&#12386;',
	"\xA4C3" => '&#12387;',
	"\xA4C4" => '&#12388;',
	"\xA4C5" => '&#12389;',
	"\xA4C6" => '&#12390;',
	"\xA4C7" => '&#12391;',
	"\xA4C8" => '&#12392;',
	"\xA4C9" => '&#12393;',
	"\xA4CA" => '&#12394;',
	"\xA4CB" => '&#12395;',
	"\xA4CC" => '&#12396;',
	"\xA4CD" => '&#12397;',
	"\xA4CE" => '&#12398;',
	"\xA4CF" => '&#12399;',
	"\xA4D0" => '&#12400;',
	"\xA4D1" => '&#12401;',
	"\xA4D2" => '&#12402;',
	"\xA4D3" => '&#12403;',
	"\xA4D4" => '&#12404;',
	"\xA4D5" => '&#12405;',
	"\xA4D6" => '&#12406;',
	"\xA4D7" => '&#12407;',
	"\xA4D8" => '&#12408;',
	"\xA4D9" => '&#12409;',
	"\xA4DA" => '&#12410;',
	"\xA4DB" => '&#12411;',
	"\xA4DC" => '&#12412;',
	"\xA4DD" => '&#12413;',
	"\xA4DE" => '&#12414;',
	"\xA4DF" => '&#12415;',
	"\xA4E0" => '&#12416;',
	"\xA4E1" => '&#12417;',
	"\xA4E2" => '&#12418;',
	"\xA4E3" => '&#12419;',
	"\xA4E4" => '&#12420;',
	"\xA4E5" => '&#12421;',
	"\xA4E6" => '&#12422;',
	"\xA4E7" => '&#12423;',
	"\xA4E8" => '&#12424;',
	"\xA4E9" => '&#12425;',
	"\xA4EA" => '&#12426;',
	"\xA4EB" => '&#12427;',
	"\xA4EC" => '&#12428;',
	"\xA4ED" => '&#12429;',
	"\xA4EE" => '&#12430;',
	"\xA4EF" => '&#12431;',
	"\xA4F0" => '&#12432;',
	"\xA4F1" => '&#12433;',
	"\xA4F2" => '&#12434;',
	"\xA4F3" => '&#12435;',
	"\xA5A1" => '&#12449;',
	"\xA5A2" => '&#12450;',
	"\xA5A3" => '&#12451;',
	"\xA5A4" => '&#12452;',
	"\xA5A5" => '&#12453;',
	"\xA5A6" => '&#12454;',
	"\xA5A7" => '&#12455;',
	"\xA5A8" => '&#12456;',
	"\xA5A9" => '&#12457;',
	"\xA5AA" => '&#12458;',
	"\xA5AB" => '&#12459;',
	"\xA5AC" => '&#12460;',
	"\xA5AD" => '&#12461;',
	"\xA5AE" => '&#12462;',
	"\xA5AF" => '&#12463;',
	"\xA5B0" => '&#12464;',
	"\xA5B1" => '&#12465;',
	"\xA5B2" => '&#12466;',
	"\xA5B3" => '&#12467;',
	"\xA5B4" => '&#12468;',
	"\xA5B5" => '&#12469;',
	"\xA5B6" => '&#12470;',
	"\xA5B7" => '&#12471;',
	"\xA5B8" => '&#12472;',
	"\xA5B9" => '&#12473;',
	"\xA5BA" => '&#12474;',
	"\xA5BB" => '&#12475;',
	"\xA5BC" => '&#12476;',
	"\xA5BD" => '&#12477;',
	"\xA5BE" => '&#12478;',
	"\xA5BF" => '&#12479;',
	"\xA5C0" => '&#12480;',
	"\xA5C1" => '&#12481;',
	"\xA5C2" => '&#12482;',
	"\xA5C3" => '&#12483;',
	"\xA5C4" => '&#12484;',
	"\xA5C5" => '&#12485;',
	"\xA5C6" => '&#12486;',
	"\xA5C7" => '&#12487;',
	"\xA5C8" => '&#12488;',
	"\xA5C9" => '&#12489;',
	"\xA5CA" => '&#12490;',
	"\xA5CB" => '&#12491;',
	"\xA5CC" => '&#12492;',
	"\xA5CD" => '&#12493;',
	"\xA5CE" => '&#12494;',
	"\xA5CF" => '&#12495;',
	"\xA5D0" => '&#12496;',
	"\xA5D1" => '&#12497;',
	"\xA5D2" => '&#12498;',
	"\xA5D3" => '&#12499;',
	"\xA5D4" => '&#12500;',
	"\xA5D5" => '&#12501;',
	"\xA5D6" => '&#12502;',
	"\xA5D7" => '&#12503;',
	"\xA5D8" => '&#12504;',
	"\xA5D9" => '&#12505;',
	"\xA5DA" => '&#12506;',
	"\xA5DB" => '&#12507;',
	"\xA5DC" => '&#12508;',
	"\xA5DD" => '&#12509;',
	"\xA5DE" => '&#12510;',
	"\xA5DF" => '&#12511;',
	"\xA5E0" => '&#12512;',
	"\xA5E1" => '&#12513;',
	"\xA5E2" => '&#12514;',
	"\xA5E3" => '&#12515;',
	"\xA5E4" => '&#12516;',
	"\xA5E5" => '&#12517;',
	"\xA5E6" => '&#12518;',
	"\xA5E7" => '&#12519;',
	"\xA5E8" => '&#12520;',
	"\xA5E9" => '&#12521;',
	"\xA5EA" => '&#12522;',
	"\xA5EB" => '&#12523;',
	"\xA5EC" => '&#12524;',
	"\xA5ED" => '&#12525;',
	"\xA5EE" => '&#12526;',
	"\xA5EF" => '&#12527;',
	"\xA5F0" => '&#12528;',
	"\xA5F1" => '&#12529;',
	"\xA5F2" => '&#12530;',
	"\xA5F3" => '&#12531;',
	"\xA5F4" => '&#12532;',
	"\xA5F5" => '&#12533;',
	"\xA5F6" => '&#12534;',
	"\xA6A1" => '&#913;',
	"\xA6A2" => '&#914;',
	"\xA6A3" => '&#915;',
	"\xA6A4" => '&#916;',
	"\xA6A5" => '&#917;',
	"\xA6A6" => '&#918;',
	"\xA6A7" => '&#919;',
	"\xA6A8" => '&#920;',
	"\xA6A9" => '&#921;',
	"\xA6AA" => '&#922;',
	"\xA6AB" => '&#923;',
	"\xA6AC" => '&#924;',
	"\xA6AD" => '&#925;',
	"\xA6AE" => '&#926;',
	"\xA6AF" => '&#927;',
	"\xA6B0" => '&#928;',
	"\xA6B1" => '&#929;',
	"\xA6B2" => '&#931;',
	"\xA6B3" => '&#932;',
	"\xA6B4" => '&#933;',
	"\xA6B5" => '&#934;',
	"\xA6B6" => '&#935;',
	"\xA6B7" => '&#936;',
	"\xA6B8" => '&#937;',
	"\xA6C1" => '&#945;',
	"\xA6C2" => '&#946;',
	"\xA6C3" => '&#947;',
	"\xA6C4" => '&#948;',
	"\xA6C5" => '&#949;',
	"\xA6C6" => '&#950;',
	"\xA6C7" => '&#951;',
	"\xA6C8" => '&#952;',
	"\xA6C9" => '&#953;',
	"\xA6CA" => '&#954;',
	"\xA6CB" => '&#955;',
	"\xA6CC" => '&#956;',
	"\xA6CD" => '&#957;',
	"\xA6CE" => '&#958;',
	"\xA6CF" => '&#959;',
	"\xA6D0" => '&#960;',
	"\xA6D1" => '&#961;',
	"\xA6D2" => '&#963;',
	"\xA6D3" => '&#964;',
	"\xA6D4" => '&#965;',
	"\xA6D5" => '&#966;',
	"\xA6D6" => '&#967;',
	"\xA6D7" => '&#968;',
	"\xA6D8" => '&#969;',
	"\xA6D9" => '&#65292;&#63614;',
	"\xA6DA" => '&#12290;&#63614;',
	"\xA6DB" => '&#12289;&#63614;',
	"\xA6DC" => '&#65306;&#63614;',
	"\xA6DD" => '&#65307;&#63614;',
	"\xA6DE" => '&#65281;&#63614;',
	"\xA6DF" => '&#65311;&#63614;',
	"\xA6E0" => '&#65077;',
	"\xA6E1" => '&#65078;',
	"\xA6E2" => '&#65081;',
	"\xA6E3" => '&#65082;',
	"\xA6E4" => '&#65087;',
	"\xA6E5" => '&#65088;',
	"\xA6E6" => '&#65085;',
	"\xA6E7" => '&#65086;',
	"\xA6E8" => '&#65089;',
	"\xA6E9" => '&#65090;',
	"\xA6EA" => '&#65091;',
	"\xA6EB" => '&#65092;',
	"\xA6EC" => '&#12310;&#63614;',
	"\xA6ED" => '&#12311;&#63614;',
	"\xA6EE" => '&#65083;',
	"\xA6EF" => '&#65084;',
	"\xA6F0" => '&#65079;',
	"\xA6F1" => '&#65080;',
	"\xA6F2" => '&#65073;',
	"\xA6F3" => '&#8943;&#63614;',
	"\xA6F4" => '&#65075;',
	"\xA6F5" => '&#65076;',
	"\xA7A1" => '&#1040;',
	"\xA7A2" => '&#1041;',
	"\xA7A3" => '&#1042;',
	"\xA7A4" => '&#1043;',
	"\xA7A5" => '&#1044;',
	"\xA7A6" => '&#1045;',
	"\xA7A7" => '&#1025;',
	"\xA7A8" => '&#1046;',
	"\xA7A9" => '&#1047;',
	"\xA7AA" => '&#1048;',
	"\xA7AB" => '&#1049;',
	"\xA7AC" => '&#1050;',
	"\xA7AD" => '&#1051;',
	"\xA7AE" => '&#1052;',
	"\xA7AF" => '&#1053;',
	"\xA7B0" => '&#1054;',
	"\xA7B1" => '&#1055;',
	"\xA7B2" => '&#1056;',
	"\xA7B3" => '&#1057;',
	"\xA7B4" => '&#1058;',
	"\xA7B5" => '&#1059;',
	"\xA7B6" => '&#1060;',
	"\xA7B7" => '&#1061;',
	"\xA7B8" => '&#1062;',
	"\xA7B9" => '&#1063;',
	"\xA7BA" => '&#1064;',
	"\xA7BB" => '&#1065;',
	"\xA7BC" => '&#1066;',
	"\xA7BD" => '&#1067;',
	"\xA7BE" => '&#1068;',
	"\xA7BF" => '&#1069;',
	"\xA7C0" => '&#1070;',
	"\xA7C1" => '&#1071;',
	"\xA7D1" => '&#1072;',
	"\xA7D2" => '&#1073;',
	"\xA7D3" => '&#1074;',
	"\xA7D4" => '&#1075;',
	"\xA7D5" => '&#1076;',
	"\xA7D6" => '&#1077;',
	"\xA7D7" => '&#1105;',
	"\xA7D8" => '&#1078;',
	"\xA7D9" => '&#1079;',
	"\xA7DA" => '&#1080;',
	"\xA7DB" => '&#1081;',
	"\xA7DC" => '&#1082;',
	"\xA7DD" => '&#1083;',
	"\xA7DE" => '&#1084;',
	"\xA7DF" => '&#1085;',
	"\xA7E0" => '&#1086;',
	"\xA7E1" => '&#1087;',
	"\xA7E2" => '&#1088;',
	"\xA7E3" => '&#1089;',
	"\xA7E4" => '&#1090;',
	"\xA7E5" => '&#1091;',
	"\xA7E6" => '&#1092;',
	"\xA7E7" => '&#1093;',
	"\xA7E8" => '&#1094;',
	"\xA7E9" => '&#1095;',
	"\xA7EA" => '&#1096;',
	"\xA7EB" => '&#1097;',
	"\xA7EC" => '&#1098;',
	"\xA7ED" => '&#1099;',
	"\xA7EE" => '&#1100;',
	"\xA7EF" => '&#1101;',
	"\xA7F0" => '&#1102;',
	"\xA7F1" => '&#1103;',
	"\xA8A1" => '&#257;',
	"\xA8A2" => '&#225;',
	"\xA8A3" => '&#462;',
	"\xA8A4" => '&#224;',
	"\xA8A5" => '&#275;',
	"\xA8A6" => '&#233;',
	"\xA8A7" => '&#283;',
	"\xA8A8" => '&#232;',
	"\xA8A9" => '&#299;',
	"\xA8AA" => '&#237;',
	"\xA8AB" => '&#464;',
	"\xA8AC" => '&#236;',
	"\xA8AD" => '&#333;',
	"\xA8AE" => '&#243;',
	"\xA8AF" => '&#466;',
	"\xA8B0" => '&#242;',
	"\xA8B1" => '&#363;',
	"\xA8B2" => '&#250;',
	"\xA8B3" => '&#468;',
	"\xA8B4" => '&#249;',
	"\xA8B5" => '&#470;',
	"\xA8B6" => '&#472;',
	"\xA8B7" => '&#474;',
	"\xA8B8" => '&#476;',
	"\xA8B9" => '&#252;',
	"\xA8BA" => '&#234;',
	"\xA8BB" => '&#593;',
	"\xA8BC" => '&#7743;',
	"\xA8BD" => '&#324;',
	"\xA8BE" => '&#328;',
	"\xA8BF" => '&#505;',
	"\xA8C0" => '&#609;',
	"\xA8C5" => '&#12549;',
	"\xA8C6" => '&#12550;',
	"\xA8C7" => '&#12551;',
	"\xA8C8" => '&#12552;',
	"\xA8C9" => '&#12553;',
	"\xA8CA" => '&#12554;',
	"\xA8CB" => '&#12555;',
	"\xA8CC" => '&#12556;',
	"\xA8CD" => '&#12557;',
	"\xA8CE" => '&#12558;',
	"\xA8CF" => '&#12559;',
	"\xA8D0" => '&#12560;',
	"\xA8D1" => '&#12561;',
	"\xA8D2" => '&#12562;',
	"\xA8D3" => '&#12563;',
	"\xA8D4" => '&#12564;',
	"\xA8D5" => '&#12565;',
	"\xA8D6" => '&#12566;',
	"\xA8D7" => '&#12567;',
	"\xA8D8" => '&#12568;',
	"\xA8D9" => '&#12569;',
	"\xA8DA" => '&#12570;',
	"\xA8DB" => '&#12571;',
	"\xA8DC" => '&#12572;',
	"\xA8DD" => '&#12573;',
	"\xA8DE" => '&#12574;',
	"\xA8DF" => '&#12575;',
	"\xA8E0" => '&#12576;',
	"\xA8E1" => '&#12577;',
	"\xA8E2" => '&#12578;',
	"\xA8E3" => '&#12579;',
	"\xA8E4" => '&#12580;',
	"\xA8E5" => '&#12581;',
	"\xA8E6" => '&#12582;',
	"\xA8E7" => '&#12583;',
	"\xA8E8" => '&#12584;',
	"\xA8E9" => '&#12585;',
	"\xA9A4" => '&#9472;',
	"\xA9A5" => '&#9473;',
	"\xA9A6" => '&#9474;',
	"\xA9A7" => '&#9475;',
	"\xA9A8" => '&#9476;',
	"\xA9A9" => '&#9477;',
	"\xA9AA" => '&#9478;',
	"\xA9AB" => '&#9479;',
	"\xA9AC" => '&#9480;',
	"\xA9AD" => '&#9481;',
	"\xA9AE" => '&#9482;',
	"\xA9AF" => '&#9483;',
	"\xA9B0" => '&#9484;',
	"\xA9B1" => '&#9485;',
	"\xA9B2" => '&#9486;',
	"\xA9B3" => '&#9487;',
	"\xA9B4" => '&#9488;',
	"\xA9B5" => '&#9489;',
	"\xA9B6" => '&#9490;',
	"\xA9B7" => '&#9491;',
	"\xA9B8" => '&#9492;',
	"\xA9B9" => '&#9493;',
	"\xA9BA" => '&#9494;',
	"\xA9BB" => '&#9495;',
	"\xA9BC" => '&#9496;',
	"\xA9BD" => '&#9497;',
	"\xA9BE" => '&#9498;',
	"\xA9BF" => '&#9499;',
	"\xA9C0" => '&#9500;',
	"\xA9C1" => '&#9501;',
	"\xA9C2" => '&#9502;',
	"\xA9C3" => '&#9503;',
	"\xA9C4" => '&#9504;',
	"\xA9C5" => '&#9505;',
	"\xA9C6" => '&#9506;',
	"\xA9C7" => '&#9507;',
	"\xA9C8" => '&#9508;',
	"\xA9C9" => '&#9509;',
	"\xA9CA" => '&#9510;',
	"\xA9CB" => '&#9511;',
	"\xA9CC" => '&#9512;',
	"\xA9CD" => '&#9513;',
	"\xA9CE" => '&#9514;',
	"\xA9CF" => '&#9515;',
	"\xA9D0" => '&#9516;',
	"\xA9D1" => '&#9517;',
	"\xA9D2" => '&#9518;',
	"\xA9D3" => '&#9519;',
	"\xA9D4" => '&#9520;',
	"\xA9D5" => '&#9521;',
	"\xA9D6" => '&#9522;',
	"\xA9D7" => '&#9523;',
	"\xA9D8" => '&#9524;',
	"\xA9D9" => '&#9525;',
	"\xA9DA" => '&#9526;',
	"\xA9DB" => '&#9527;',
	"\xA9DC" => '&#9528;',
	"\xA9DD" => '&#9529;',
	"\xA9DE" => '&#9530;',
	"\xA9DF" => '&#9531;',
	"\xA9E0" => '&#9532;',
	"\xA9E1" => '&#9533;',
	"\xA9E2" => '&#9534;',
	"\xA9E3" => '&#9535;',
	"\xA9E4" => '&#9536;',
	"\xA9E5" => '&#9537;',
	"\xA9E6" => '&#9538;',
	"\xA9E7" => '&#9539;',
	"\xA9E8" => '&#9540;',
	"\xA9E9" => '&#9541;',
	"\xA9EA" => '&#9542;',
	"\xA9EB" => '&#9543;',
	"\xA9EC" => '&#9544;',
	"\xA9ED" => '&#9545;',
	"\xA9EE" => '&#9546;',
	"\xA9EF" => '&#9547;',
	"\xB0A1" => '&#21834;',
	"\xB0A2" => '&#38463;',
	"\xB0A3" => '&#22467;',
	"\xB0A4" => '&#25384;',
	"\xB0A5" => '&#21710;',
	"\xB0A6" => '&#21769;',
	"\xB0A7" => '&#21696;',
	"\xB0A8" => '&#30353;',
	"\xB0A9" => '&#30284;',
	"\xB0AA" => '&#34108;',
	"\xB0AB" => '&#30702;',
	"\xB0AC" => '&#33406;',
	"\xB0AD" => '&#30861;',
	"\xB0AE" => '&#29233;',
	"\xB0AF" => '&#38552;',
	"\xB0B0" => '&#38797;',
	"\xB0B1" => '&#27688;',
	"\xB0B2" => '&#23433;',
	"\xB0B3" => '&#20474;',
	"\xB0B4" => '&#25353;',
	"\xB0B5" => '&#26263;',
	"\xB0B6" => '&#23736;',
	"\xB0B7" => '&#33018;',
	"\xB0B8" => '&#26696;',
	"\xB0B9" => '&#32942;',
	"\xB0BA" => '&#26114;',
	"\xB0BB" => '&#30414;',
	"\xB0BC" => '&#20985;',
	"\xB0BD" => '&#25942;',
	"\xB0BE" => '&#29100;',
	"\xB0BF" => '&#32753;',
	"\xB0C0" => '&#34948;',
	"\xB0C1" => '&#20658;',
	"\xB0C2" => '&#22885;',
	"\xB0C3" => '&#25034;',
	"\xB0C4" => '&#28595;',
	"\xB0C5" => '&#33453;',
	"\xB0C6" => '&#25420;',
	"\xB0C7" => '&#25170;',
	"\xB0C8" => '&#21485;',
	"\xB0C9" => '&#21543;',
	"\xB0CA" => '&#31494;',
	"\xB0CB" => '&#20843;',
	"\xB0CC" => '&#30116;',
	"\xB0CD" => '&#24052;',
	"\xB0CE" => '&#25300;',
	"\xB0CF" => '&#36299;',
	"\xB0D0" => '&#38774;',
	"\xB0D1" => '&#25226;',
	"\xB0D2" => '&#32793;',
	"\xB0D3" => '&#22365;',
	"\xB0D4" => '&#38712;',
	"\xB0D5" => '&#32610;',
	"\xB0D6" => '&#29240;',
	"\xB0D7" => '&#30333;',
	"\xB0D8" => '&#26575;',
	"\xB0D9" => '&#30334;',
	"\xB0DA" => '&#25670;',
	"\xB0DB" => '&#20336;',
	"\xB0DC" => '&#36133;',
	"\xB0DD" => '&#25308;',
	"\xB0DE" => '&#31255;',
	"\xB0DF" => '&#26001;',
	"\xB0E0" => '&#29677;',
	"\xB0E1" => '&#25644;',
	"\xB0E2" => '&#25203;',
	"\xB0E3" => '&#33324;',
	"\xB0E4" => '&#39041;',
	"\xB0E5" => '&#26495;',
	"\xB0E6" => '&#29256;',
	"\xB0E7" => '&#25198;',
	"\xB0E8" => '&#25292;',
	"\xB0E9" => '&#20276;',
	"\xB0EA" => '&#29923;',
	"\xB0EB" => '&#21322;',
	"\xB0EC" => '&#21150;',
	"\xB0ED" => '&#32458;',
	"\xB0EE" => '&#37030;',
	"\xB0EF" => '&#24110;',
	"\xB0F0" => '&#26758;',
	"\xB0F1" => '&#27036;',
	"\xB0F2" => '&#33152;',
	"\xB0F3" => '&#32465;',
	"\xB0F4" => '&#26834;',
	"\xB0F5" => '&#30917;',
	"\xB0F6" => '&#34444;',
	"\xB0F7" => '&#38225;',
	"\xB0F8" => '&#20621;',
	"\xB0F9" => '&#35876;',
	"\xB0FA" => '&#33502;',
	"\xB0FB" => '&#32990;',
	"\xB0FC" => '&#21253;',
	"\xB0FD" => '&#35090;',
	"\xB0FE" => '&#21093;',
	"\xB1A1" => '&#34180;',
	"\xB1A2" => '&#38649;',
	"\xB1A3" => '&#20445;',
	"\xB1A4" => '&#22561;',
	"\xB1A5" => '&#39281;',
	"\xB1A6" => '&#23453;',
	"\xB1A7" => '&#25265;',
	"\xB1A8" => '&#25253;',
	"\xB1A9" => '&#26292;',
	"\xB1AA" => '&#35961;',
	"\xB1AB" => '&#40077;',
	"\xB1AC" => '&#29190;',
	"\xB1AD" => '&#26479;',
	"\xB1AE" => '&#30865;',
	"\xB1AF" => '&#24754;',
	"\xB1B0" => '&#21329;',
	"\xB1B1" => '&#21271;',
	"\xB1B2" => '&#36744;',
	"\xB1B3" => '&#32972;',
	"\xB1B4" => '&#36125;',
	"\xB1B5" => '&#38049;',
	"\xB1B6" => '&#20493;',
	"\xB1B7" => '&#29384;',
	"\xB1B8" => '&#22791;',
	"\xB1B9" => '&#24811;',
	"\xB1BA" => '&#28953;',
	"\xB1BB" => '&#34987;',
	"\xB1BC" => '&#22868;',
	"\xB1BD" => '&#33519;',
	"\xB1BE" => '&#26412;',
	"\xB1BF" => '&#31528;',
	"\xB1C0" => '&#23849;',
	"\xB1C1" => '&#32503;',
	"\xB1C2" => '&#29997;',
	"\xB1C3" => '&#27893;',
	"\xB1C4" => '&#36454;',
	"\xB1C5" => '&#36856;',
	"\xB1C6" => '&#36924;',
	"\xB1C7" => '&#40763;',
	"\xB1C8" => '&#27604;',
	"\xB1C9" => '&#37145;',
	"\xB1CA" => '&#31508;',
	"\xB1CB" => '&#24444;',
	"\xB1CC" => '&#30887;',
	"\xB1CD" => '&#34006;',
	"\xB1CE" => '&#34109;',
	"\xB1CF" => '&#27605;',
	"\xB1D0" => '&#27609;',
	"\xB1D1" => '&#27606;',
	"\xB1D2" => '&#24065;',
	"\xB1D3" => '&#24199;',
	"\xB1D4" => '&#30201;',
	"\xB1D5" => '&#38381;',
	"\xB1D6" => '&#25949;',
	"\xB1D7" => '&#24330;',
	"\xB1D8" => '&#24517;',
	"\xB1D9" => '&#36767;',
	"\xB1DA" => '&#22721;',
	"\xB1DB" => '&#33218;',
	"\xB1DC" => '&#36991;',
	"\xB1DD" => '&#38491;',
	"\xB1DE" => '&#38829;',
	"\xB1DF" => '&#36793;',
	"\xB1E0" => '&#32534;',
	"\xB1E1" => '&#36140;',
	"\xB1E2" => '&#25153;',
	"\xB1E3" => '&#20415;',
	"\xB1E4" => '&#21464;',
	"\xB1E5" => '&#21342;',
	"\xB1E6" => '&#36776;',
	"\xB1E7" => '&#36777;',
	"\xB1E8" => '&#36779;',
	"\xB1E9" => '&#36941;',
	"\xB1EA" => '&#26631;',
	"\xB1EB" => '&#24426;',
	"\xB1EC" => '&#33176;',
	"\xB1ED" => '&#34920;',
	"\xB1EE" => '&#40150;',
	"\xB1EF" => '&#24971;',
	"\xB1F0" => '&#21035;',
	"\xB1F1" => '&#30250;',
	"\xB1F2" => '&#24428;',
	"\xB1F3" => '&#25996;',
	"\xB1F4" => '&#28626;',
	"\xB1F5" => '&#28392;',
	"\xB1F6" => '&#23486;',
	"\xB1F7" => '&#25672;',
	"\xB1F8" => '&#20853;',
	"\xB1F9" => '&#20912;',
	"\xB1FA" => '&#26564;',
	"\xB1FB" => '&#19993;',
	"\xB1FC" => '&#31177;',
	"\xB1FD" => '&#39292;',
	"\xB1FE" => '&#28851;',
	"\xB2A1" => '&#30149;',
	"\xB2A2" => '&#24182;',
	"\xB2A3" => '&#29627;',
	"\xB2A4" => '&#33760;',
	"\xB2A5" => '&#25773;',
	"\xB2A6" => '&#25320;',
	"\xB2A7" => '&#38069;',
	"\xB2A8" => '&#27874;',
	"\xB2A9" => '&#21338;',
	"\xB2AA" => '&#21187;',
	"\xB2AB" => '&#25615;',
	"\xB2AC" => '&#38082;',
	"\xB2AD" => '&#31636;',
	"\xB2AE" => '&#20271;',
	"\xB2AF" => '&#24091;',
	"\xB2B0" => '&#33334;',
	"\xB2B1" => '&#33046;',
	"\xB2B2" => '&#33162;',
	"\xB2B3" => '&#28196;',
	"\xB2B4" => '&#27850;',
	"\xB2B5" => '&#39539;',
	"\xB2B6" => '&#25429;',
	"\xB2B7" => '&#21340;',
	"\xB2B8" => '&#21754;',
	"\xB2B9" => '&#34917;',
	"\xB2BA" => '&#22496;',
	"\xB2BB" => '&#19981;',
	"\xB2BC" => '&#24067;',
	"\xB2BD" => '&#27493;',
	"\xB2BE" => '&#31807;',
	"\xB2BF" => '&#37096;',
	"\xB2C0" => '&#24598;',
	"\xB2C1" => '&#25830;',
	"\xB2C2" => '&#29468;',
	"\xB2C3" => '&#35009;',
	"\xB2C4" => '&#26448;',
	"\xB2C5" => '&#25165;',
	"\xB2C6" => '&#36130;',
	"\xB2C7" => '&#30572;',
	"\xB2C8" => '&#36393;',
	"\xB2C9" => '&#37319;',
	"\xB2CA" => '&#24425;',
	"\xB2CB" => '&#33756;',
	"\xB2CC" => '&#34081;',
	"\xB2CD" => '&#39184;',
	"\xB2CE" => '&#21442;',
	"\xB2CF" => '&#34453;',
	"\xB2D0" => '&#27531;',
	"\xB2D1" => '&#24813;',
	"\xB2D2" => '&#24808;',
	"\xB2D3" => '&#28799;',
	"\xB2D4" => '&#33485;',
	"\xB2D5" => '&#33329;',
	"\xB2D6" => '&#20179;',
	"\xB2D7" => '&#27815;',
	"\xB2D8" => '&#34255;',
	"\xB2D9" => '&#25805;',
	"\xB2DA" => '&#31961;',
	"\xB2DB" => '&#27133;',
	"\xB2DC" => '&#26361;',
	"\xB2DD" => '&#33609;',
	"\xB2DE" => '&#21397;',
	"\xB2DF" => '&#31574;',
	"\xB2E0" => '&#20391;',
	"\xB2E1" => '&#20876;',
	"\xB2E2" => '&#27979;',
	"\xB2E3" => '&#23618;',
	"\xB2E4" => '&#36461;',
	"\xB2E5" => '&#25554;',
	"\xB2E6" => '&#21449;',
	"\xB2E7" => '&#33580;',
	"\xB2E8" => '&#33590;',
	"\xB2E9" => '&#26597;',
	"\xB2EA" => '&#30900;',
	"\xB2EB" => '&#25661;',
	"\xB2EC" => '&#23519;',
	"\xB2ED" => '&#23700;',
	"\xB2EE" => '&#24046;',
	"\xB2EF" => '&#35815;',
	"\xB2F0" => '&#25286;',
	"\xB2F1" => '&#26612;',
	"\xB2F2" => '&#35962;',
	"\xB2F3" => '&#25600;',
	"\xB2F4" => '&#25530;',
	"\xB2F5" => '&#34633;',
	"\xB2F6" => '&#39307;',
	"\xB2F7" => '&#35863;',
	"\xB2F8" => '&#32544;',
	"\xB2F9" => '&#38130;',
	"\xB2FA" => '&#20135;',
	"\xB2FB" => '&#38416;',
	"\xB2FC" => '&#39076;',
	"\xB2FD" => '&#26124;',
	"\xB2FE" => '&#29462;',
	"\xB3A1" => '&#22330;',
	"\xB3A2" => '&#23581;',
	"\xB3A3" => '&#24120;',
	"\xB3A4" => '&#38271;',
	"\xB3A5" => '&#20607;',
	"\xB3A6" => '&#32928;',
	"\xB3A7" => '&#21378;',
	"\xB3A8" => '&#25950;',
	"\xB3A9" => '&#30021;',
	"\xB3AA" => '&#21809;',
	"\xB3AB" => '&#20513;',
	"\xB3AC" => '&#36229;',
	"\xB3AD" => '&#25220;',
	"\xB3AE" => '&#38046;',
	"\xB3AF" => '&#26397;',
	"\xB3B0" => '&#22066;',
	"\xB3B1" => '&#28526;',
	"\xB3B2" => '&#24034;',
	"\xB3B3" => '&#21557;',
	"\xB3B4" => '&#28818;',
	"\xB3B5" => '&#36710;',
	"\xB3B6" => '&#25199;',
	"\xB3B7" => '&#25764;',
	"\xB3B8" => '&#25507;',
	"\xB3B9" => '&#24443;',
	"\xB3BA" => '&#28552;',
	"\xB3BB" => '&#37108;',
	"\xB3BC" => '&#33251;',
	"\xB3BD" => '&#36784;',
	"\xB3BE" => '&#23576;',
	"\xB3BF" => '&#26216;',
	"\xB3C0" => '&#24561;',
	"\xB3C1" => '&#27785;',
	"\xB3C2" => '&#38472;',
	"\xB3C3" => '&#36225;',
	"\xB3C4" => '&#34924;',
	"\xB3C5" => '&#25745;',
	"\xB3C6" => '&#31216;',
	"\xB3C7" => '&#22478;',
	"\xB3C8" => '&#27225;',
	"\xB3C9" => '&#25104;',
	"\xB3CA" => '&#21576;',
	"\xB3CB" => '&#20056;',
	"\xB3CC" => '&#31243;',
	"\xB3CD" => '&#24809;',
	"\xB3CE" => '&#28548;',
	"\xB3CF" => '&#35802;',
	"\xB3D0" => '&#25215;',
	"\xB3D1" => '&#36894;',
	"\xB3D2" => '&#39563;',
	"\xB3D3" => '&#31204;',
	"\xB3D4" => '&#21507;',
	"\xB3D5" => '&#30196;',
	"\xB3D6" => '&#25345;',
	"\xB3D7" => '&#21273;',
	"\xB3D8" => '&#27744;',
	"\xB3D9" => '&#36831;',
	"\xB3DA" => '&#24347;',
	"\xB3DB" => '&#39536;',
	"\xB3DC" => '&#32827;',
	"\xB3DD" => '&#40831;',
	"\xB3DE" => '&#20360;',
	"\xB3DF" => '&#23610;',
	"\xB3E0" => '&#36196;',
	"\xB3E1" => '&#32709;',
	"\xB3E2" => '&#26021;',
	"\xB3E3" => '&#28861;',
	"\xB3E4" => '&#20805;',
	"\xB3E5" => '&#20914;',
	"\xB3E6" => '&#34411;',
	"\xB3E7" => '&#23815;',
	"\xB3E8" => '&#23456;',
	"\xB3E9" => '&#25277;',
	"\xB3EA" => '&#37228;',
	"\xB3EB" => '&#30068;',
	"\xB3EC" => '&#36364;',
	"\xB3ED" => '&#31264;',
	"\xB3EE" => '&#24833;',
	"\xB3EF" => '&#31609;',
	"\xB3F0" => '&#20167;',
	"\xB3F1" => '&#32504;',
	"\xB3F2" => '&#30597;',
	"\xB3F3" => '&#19985;',
	"\xB3F4" => '&#33261;',
	"\xB3F5" => '&#21021;',
	"\xB3F6" => '&#20986;',
	"\xB3F7" => '&#27249;',
	"\xB3F8" => '&#21416;',
	"\xB3F9" => '&#36487;',
	"\xB3FA" => '&#38148;',
	"\xB3FB" => '&#38607;',
	"\xB3FC" => '&#28353;',
	"\xB3FD" => '&#38500;',
	"\xB3FE" => '&#26970;',
	"\xB4A1" => '&#30784;',
	"\xB4A2" => '&#20648;',
	"\xB4A3" => '&#30679;',
	"\xB4A4" => '&#25616;',
	"\xB4A5" => '&#35302;',
	"\xB4A6" => '&#22788;',
	"\xB4A7" => '&#25571;',
	"\xB4A8" => '&#24029;',
	"\xB4A9" => '&#31359;',
	"\xB4AA" => '&#26941;',
	"\xB4AB" => '&#20256;',
	"\xB4AC" => '&#33337;',
	"\xB4AD" => '&#21912;',
	"\xB4AE" => '&#20018;',
	"\xB4AF" => '&#30126;',
	"\xB4B0" => '&#31383;',
	"\xB4B1" => '&#24162;',
	"\xB4B2" => '&#24202;',
	"\xB4B3" => '&#38383;',
	"\xB4B4" => '&#21019;',
	"\xB4B5" => '&#21561;',
	"\xB4B6" => '&#28810;',
	"\xB4B7" => '&#25462;',
	"\xB4B8" => '&#38180;',
	"\xB4B9" => '&#22402;',
	"\xB4BA" => '&#26149;',
	"\xB4BB" => '&#26943;',
	"\xB4BC" => '&#37255;',
	"\xB4BD" => '&#21767;',
	"\xB4BE" => '&#28147;',
	"\xB4BF" => '&#32431;',
	"\xB4C0" => '&#34850;',
	"\xB4C1" => '&#25139;',
	"\xB4C2" => '&#32496;',
	"\xB4C3" => '&#30133;',
	"\xB4C4" => '&#33576;',
	"\xB4C5" => '&#30913;',
	"\xB4C6" => '&#38604;',
	"\xB4C7" => '&#36766;',
	"\xB4C8" => '&#24904;',
	"\xB4C9" => '&#29943;',
	"\xB4CA" => '&#35789;',
	"\xB4CB" => '&#27492;',
	"\xB4CC" => '&#21050;',
	"\xB4CD" => '&#36176;',
	"\xB4CE" => '&#27425;',
	"\xB4CF" => '&#32874;',
	"\xB4D0" => '&#33905;',
	"\xB4D1" => '&#22257;',
	"\xB4D2" => '&#21254;',
	"\xB4D3" => '&#20174;',
	"\xB4D4" => '&#19995;',
	"\xB4D5" => '&#20945;',
	"\xB4D6" => '&#31895;',
	"\xB4D7" => '&#37259;',
	"\xB4D8" => '&#31751;',
	"\xB4D9" => '&#20419;',
	"\xB4DA" => '&#36479;',
	"\xB4DB" => '&#31713;',
	"\xB4DC" => '&#31388;',
	"\xB4DD" => '&#25703;',
	"\xB4DE" => '&#23828;',
	"\xB4DF" => '&#20652;',
	"\xB4E0" => '&#33030;',
	"\xB4E1" => '&#30209;',
	"\xB4E2" => '&#31929;',
	"\xB4E3" => '&#28140;',
	"\xB4E4" => '&#32736;',
	"\xB4E5" => '&#26449;',
	"\xB4E6" => '&#23384;',
	"\xB4E7" => '&#23544;',
	"\xB4E8" => '&#30923;',
	"\xB4E9" => '&#25774;',
	"\xB4EA" => '&#25619;',
	"\xB4EB" => '&#25514;',
	"\xB4EC" => '&#25387;',
	"\xB4ED" => '&#38169;',
	"\xB4EE" => '&#25645;',
	"\xB4EF" => '&#36798;',
	"\xB4F0" => '&#31572;',
	"\xB4F1" => '&#30249;',
	"\xB4F2" => '&#25171;',
	"\xB4F3" => '&#22823;',
	"\xB4F4" => '&#21574;',
	"\xB4F5" => '&#27513;',
	"\xB4F6" => '&#20643;',
	"\xB4F7" => '&#25140;',
	"\xB4F8" => '&#24102;',
	"\xB4F9" => '&#27526;',
	"\xB4FA" => '&#20195;',
	"\xB4FB" => '&#36151;',
	"\xB4FC" => '&#34955;',
	"\xB4FD" => '&#24453;',
	"\xB4FE" => '&#36910;',
	"\xB5A1" => '&#24608;',
	"\xB5A2" => '&#32829;',
	"\xB5A3" => '&#25285;',
	"\xB5A4" => '&#20025;',
	"\xB5A5" => '&#21333;',
	"\xB5A6" => '&#37112;',
	"\xB5A7" => '&#25528;',
	"\xB5A8" => '&#32966;',
	"\xB5A9" => '&#26086;',
	"\xB5AA" => '&#27694;',
	"\xB5AB" => '&#20294;',
	"\xB5AC" => '&#24814;',
	"\xB5AD" => '&#28129;',
	"\xB5AE" => '&#35806;',
	"\xB5AF" => '&#24377;',
	"\xB5B0" => '&#34507;',
	"\xB5B1" => '&#24403;',
	"\xB5B2" => '&#25377;',
	"\xB5B3" => '&#20826;',
	"\xB5B4" => '&#33633;',
	"\xB5B5" => '&#26723;',
	"\xB5B6" => '&#20992;',
	"\xB5B7" => '&#25443;',
	"\xB5B8" => '&#36424;',
	"\xB5B9" => '&#20498;',
	"\xB5BA" => '&#23707;',
	"\xB5BB" => '&#31095;',
	"\xB5BC" => '&#23548;',
	"\xB5BD" => '&#21040;',
	"\xB5BE" => '&#31291;',
	"\xB5BF" => '&#24764;',
	"\xB5C0" => '&#36947;',
	"\xB5C1" => '&#30423;',
	"\xB5C2" => '&#24503;',
	"\xB5C3" => '&#24471;',
	"\xB5C4" => '&#30340;',
	"\xB5C5" => '&#36460;',
	"\xB5C6" => '&#28783;',
	"\xB5C7" => '&#30331;',
	"\xB5C8" => '&#31561;',
	"\xB5C9" => '&#30634;',
	"\xB5CA" => '&#20979;',
	"\xB5CB" => '&#37011;',
	"\xB5CC" => '&#22564;',
	"\xB5CD" => '&#20302;',
	"\xB5CE" => '&#28404;',
	"\xB5CF" => '&#36842;',
	"\xB5D0" => '&#25932;',
	"\xB5D1" => '&#31515;',
	"\xB5D2" => '&#29380;',
	"\xB5D3" => '&#28068;',
	"\xB5D4" => '&#32735;',
	"\xB5D5" => '&#23265;',
	"\xB5D6" => '&#25269;',
	"\xB5D7" => '&#24213;',
	"\xB5D8" => '&#22320;',
	"\xB5D9" => '&#33922;',
	"\xB5DA" => '&#31532;',
	"\xB5DB" => '&#24093;',
	"\xB5DC" => '&#24351;',
	"\xB5DD" => '&#36882;',
	"\xB5DE" => '&#32532;',
	"\xB5DF" => '&#39072;',
	"\xB5E0" => '&#25474;',
	"\xB5E1" => '&#28359;',
	"\xB5E2" => '&#30872;',
	"\xB5E3" => '&#28857;',
	"\xB5E4" => '&#20856;',
	"\xB5E5" => '&#38747;',
	"\xB5E6" => '&#22443;',
	"\xB5E7" => '&#30005;',
	"\xB5E8" => '&#20291;',
	"\xB5E9" => '&#30008;',
	"\xB5EA" => '&#24215;',
	"\xB5EB" => '&#24806;',
	"\xB5EC" => '&#22880;',
	"\xB5ED" => '&#28096;',
	"\xB5EE" => '&#27583;',
	"\xB5EF" => '&#30857;',
	"\xB5F0" => '&#21500;',
	"\xB5F1" => '&#38613;',
	"\xB5F2" => '&#20939;',
	"\xB5F3" => '&#20993;',
	"\xB5F4" => '&#25481;',
	"\xB5F5" => '&#21514;',
	"\xB5F6" => '&#38035;',
	"\xB5F7" => '&#35843;',
	"\xB5F8" => '&#36300;',
	"\xB5F9" => '&#29241;',
	"\xB5FA" => '&#30879;',
	"\xB5FB" => '&#34678;',
	"\xB5FC" => '&#36845;',
	"\xB5FD" => '&#35853;',
	"\xB5FE" => '&#21472;',
	"\xB6A1" => '&#19969;',
	"\xB6A2" => '&#30447;',
	"\xB6A3" => '&#21486;',
	"\xB6A4" => '&#38025;',
	"\xB6A5" => '&#39030;',
	"\xB6A6" => '&#40718;',
	"\xB6A7" => '&#38189;',
	"\xB6A8" => '&#23450;',
	"\xB6A9" => '&#35746;',
	"\xB6AA" => '&#20002;',
	"\xB6AB" => '&#19996;',
	"\xB6AC" => '&#20908;',
	"\xB6AD" => '&#33891;',
	"\xB6AE" => '&#25026;',
	"\xB6AF" => '&#21160;',
	"\xB6B0" => '&#26635;',
	"\xB6B1" => '&#20375;',
	"\xB6B2" => '&#24683;',
	"\xB6B3" => '&#20923;',
	"\xB6B4" => '&#27934;',
	"\xB6B5" => '&#20828;',
	"\xB6B6" => '&#25238;',
	"\xB6B7" => '&#26007;',
	"\xB6B8" => '&#38497;',
	"\xB6B9" => '&#35910;',
	"\xB6BA" => '&#36887;',
	"\xB6BB" => '&#30168;',
	"\xB6BC" => '&#37117;',
	"\xB6BD" => '&#30563;',
	"\xB6BE" => '&#27602;',
	"\xB6BF" => '&#29322;',
	"\xB6C0" => '&#29420;',
	"\xB6C1" => '&#35835;',
	"\xB6C2" => '&#22581;',
	"\xB6C3" => '&#30585;',
	"\xB6C4" => '&#36172;',
	"\xB6C5" => '&#26460;',
	"\xB6C6" => '&#38208;',
	"\xB6C7" => '&#32922;',
	"\xB6C8" => '&#24230;',
	"\xB6C9" => '&#28193;',
	"\xB6CA" => '&#22930;',
	"\xB6CB" => '&#31471;',
	"\xB6CC" => '&#30701;',
	"\xB6CD" => '&#38203;',
	"\xB6CE" => '&#27573;',
	"\xB6CF" => '&#26029;',
	"\xB6D0" => '&#32526;',
	"\xB6D1" => '&#22534;',
	"\xB6D2" => '&#20817;',
	"\xB6D3" => '&#38431;',
	"\xB6D4" => '&#23545;',
	"\xB6D5" => '&#22697;',
	"\xB6D6" => '&#21544;',
	"\xB6D7" => '&#36466;',
	"\xB6D8" => '&#25958;',
	"\xB6D9" => '&#39039;',
	"\xB6DA" => '&#22244;',
	"\xB6DB" => '&#38045;',
	"\xB6DC" => '&#30462;',
	"\xB6DD" => '&#36929;',
	"\xB6DE" => '&#25479;',
	"\xB6DF" => '&#21702;',
	"\xB6E0" => '&#22810;',
	"\xB6E1" => '&#22842;',
	"\xB6E2" => '&#22427;',
	"\xB6E3" => '&#36530;',
	"\xB6E4" => '&#26421;',
	"\xB6E5" => '&#36346;',
	"\xB6E6" => '&#33333;',
	"\xB6E7" => '&#21057;',
	"\xB6E8" => '&#24816;',
	"\xB6E9" => '&#22549;',
	"\xB6EA" => '&#34558;',
	"\xB6EB" => '&#23784;',
	"\xB6EC" => '&#40517;',
	"\xB6ED" => '&#20420;',
	"\xB6EE" => '&#39069;',
	"\xB6EF" => '&#35769;',
	"\xB6F0" => '&#23077;',
	"\xB6F1" => '&#24694;',
	"\xB6F2" => '&#21380;',
	"\xB6F3" => '&#25212;',
	"\xB6F4" => '&#36943;',
	"\xB6F5" => '&#37122;',
	"\xB6F6" => '&#39295;',
	"\xB6F7" => '&#24681;',
	"\xB6F8" => '&#32780;',
	"\xB6F9" => '&#20799;',
	"\xB6FA" => '&#32819;',
	"\xB6FB" => '&#23572;',
	"\xB6FC" => '&#39285;',
	"\xB6FD" => '&#27953;',
	"\xB6FE" => '&#20108;',
	"\xB7A1" => '&#36144;',
	"\xB7A2" => '&#21457;',
	"\xB7A3" => '&#32602;',
	"\xB7A4" => '&#31567;',
	"\xB7A5" => '&#20240;',
	"\xB7A6" => '&#20047;',
	"\xB7A7" => '&#38400;',
	"\xB7A8" => '&#27861;',
	"\xB7A9" => '&#29648;',
	"\xB7AA" => '&#34281;',
	"\xB7AB" => '&#24070;',
	"\xB7AC" => '&#30058;',
	"\xB7AD" => '&#32763;',
	"\xB7AE" => '&#27146;',
	"\xB7AF" => '&#30718;',
	"\xB7B0" => '&#38034;',
	"\xB7B1" => '&#32321;',
	"\xB7B2" => '&#20961;',
	"\xB7B3" => '&#28902;',
	"\xB7B4" => '&#21453;',
	"\xB7B5" => '&#36820;',
	"\xB7B6" => '&#33539;',
	"\xB7B7" => '&#36137;',
	"\xB7B8" => '&#29359;',
	"\xB7B9" => '&#39277;',
	"\xB7BA" => '&#27867;',
	"\xB7BB" => '&#22346;',
	"\xB7BC" => '&#33459;',
	"\xB7BD" => '&#26041;',
	"\xB7BE" => '&#32938;',
	"\xB7BF" => '&#25151;',
	"\xB7C0" => '&#38450;',
	"\xB7C1" => '&#22952;',
	"\xB7C2" => '&#20223;',
	"\xB7C3" => '&#35775;',
	"\xB7C4" => '&#32442;',
	"\xB7C5" => '&#25918;',
	"\xB7C6" => '&#33778;',
	"\xB7C7" => '&#38750;',
	"\xB7C8" => '&#21857;',
	"\xB7C9" => '&#39134;',
	"\xB7CA" => '&#32933;',
	"\xB7CB" => '&#21290;',
	"\xB7CC" => '&#35837;',
	"\xB7CD" => '&#21536;',
	"\xB7CE" => '&#32954;',
	"\xB7CF" => '&#24223;',
	"\xB7D0" => '&#27832;',
	"\xB7D1" => '&#36153;',
	"\xB7D2" => '&#33452;',
	"\xB7D3" => '&#37210;',
	"\xB7D4" => '&#21545;',
	"\xB7D5" => '&#27675;',
	"\xB7D6" => '&#20998;',
	"\xB7D7" => '&#32439;',
	"\xB7D8" => '&#22367;',
	"\xB7D9" => '&#28954;',
	"\xB7DA" => '&#27774;',
	"\xB7DB" => '&#31881;',
	"\xB7DC" => '&#22859;',
	"\xB7DD" => '&#20221;',
	"\xB7DE" => '&#24575;',
	"\xB7DF" => '&#24868;',
	"\xB7E0" => '&#31914;',
	"\xB7E1" => '&#20016;',
	"\xB7E2" => '&#23553;',
	"\xB7E3" => '&#26539;',
	"\xB7E4" => '&#34562;',
	"\xB7E5" => '&#23792;',
	"\xB7E6" => '&#38155;',
	"\xB7E7" => '&#39118;',
	"\xB7E8" => '&#30127;',
	"\xB7E9" => '&#28925;',
	"\xB7EA" => '&#36898;',
	"\xB7EB" => '&#20911;',
	"\xB7EC" => '&#32541;',
	"\xB7ED" => '&#35773;',
	"\xB7EE" => '&#22857;',
	"\xB7EF" => '&#20964;',
	"\xB7F0" => '&#20315;',
	"\xB7F1" => '&#21542;',
	"\xB7F2" => '&#22827;',
	"\xB7F3" => '&#25975;',
	"\xB7F4" => '&#32932;',
	"\xB7F5" => '&#23413;',
	"\xB7F6" => '&#25206;',
	"\xB7F7" => '&#25282;',
	"\xB7F8" => '&#36752;',
	"\xB7F9" => '&#24133;',
	"\xB7FA" => '&#27679;',
	"\xB7FB" => '&#31526;',
	"\xB7FC" => '&#20239;',
	"\xB7FD" => '&#20440;',
	"\xB7FE" => '&#26381;',
	"\xB8A1" => '&#28014;',
	"\xB8A2" => '&#28074;',
	"\xB8A3" => '&#31119;',
	"\xB8A4" => '&#34993;',
	"\xB8A5" => '&#24343;',
	"\xB8A6" => '&#29995;',
	"\xB8A7" => '&#25242;',
	"\xB8A8" => '&#36741;',
	"\xB8A9" => '&#20463;',
	"\xB8AA" => '&#37340;',
	"\xB8AB" => '&#26023;',
	"\xB8AC" => '&#33071;',
	"\xB8AD" => '&#33105;',
	"\xB8AE" => '&#24220;',
	"\xB8AF" => '&#33104;',
	"\xB8B0" => '&#36212;',
	"\xB8B1" => '&#21103;',
	"\xB8B2" => '&#35206;',
	"\xB8B3" => '&#36171;',
	"\xB8B4" => '&#22797;',
	"\xB8B5" => '&#20613;',
	"\xB8B6" => '&#20184;',
	"\xB8B7" => '&#38428;',
	"\xB8B8" => '&#29238;',
	"\xB8B9" => '&#33145;',
	"\xB8BA" => '&#36127;',
	"\xB8BB" => '&#23500;',
	"\xB8BC" => '&#35747;',
	"\xB8BD" => '&#38468;',
	"\xB8BE" => '&#22919;',
	"\xB8BF" => '&#32538;',
	"\xB8C0" => '&#21648;',
	"\xB8C1" => '&#22134;',
	"\xB8C2" => '&#22030;',
	"\xB8C3" => '&#35813;',
	"\xB8C4" => '&#25913;',
	"\xB8C5" => '&#27010;',
	"\xB8C6" => '&#38041;',
	"\xB8C7" => '&#30422;',
	"\xB8C8" => '&#28297;',
	"\xB8C9" => '&#24178;',
	"\xB8CA" => '&#29976;',
	"\xB8CB" => '&#26438;',
	"\xB8CC" => '&#26577;',
	"\xB8CD" => '&#31487;',
	"\xB8CE" => '&#32925;',
	"\xB8CF" => '&#36214;',
	"\xB8D0" => '&#24863;',
	"\xB8D1" => '&#31174;',
	"\xB8D2" => '&#25954;',
	"\xB8D3" => '&#36195;',
	"\xB8D4" => '&#20872;',
	"\xB8D5" => '&#21018;',
	"\xB8D6" => '&#38050;',
	"\xB8D7" => '&#32568;',
	"\xB8D8" => '&#32923;',
	"\xB8D9" => '&#32434;',
	"\xB8DA" => '&#23703;',
	"\xB8DB" => '&#28207;',
	"\xB8DC" => '&#26464;',
	"\xB8DD" => '&#31705;',
	"\xB8DE" => '&#30347;',
	"\xB8DF" => '&#39640;',
	"\xB8E0" => '&#33167;',
	"\xB8E1" => '&#32660;',
	"\xB8E2" => '&#31957;',
	"\xB8E3" => '&#25630;',
	"\xB8E4" => '&#38224;',
	"\xB8E5" => '&#31295;',
	"\xB8E6" => '&#21578;',
	"\xB8E7" => '&#21733;',
	"\xB8E8" => '&#27468;',
	"\xB8E9" => '&#25601;',
	"\xB8EA" => '&#25096;',
	"\xB8EB" => '&#40509;',
	"\xB8EC" => '&#33011;',
	"\xB8ED" => '&#30105;',
	"\xB8EE" => '&#21106;',
	"\xB8EF" => '&#38761;',
	"\xB8F0" => '&#33883;',
	"\xB8F1" => '&#26684;',
	"\xB8F2" => '&#34532;',
	"\xB8F3" => '&#38401;',
	"\xB8F4" => '&#38548;',
	"\xB8F5" => '&#38124;',
	"\xB8F6" => '&#20010;',
	"\xB8F7" => '&#21508;',
	"\xB8F8" => '&#32473;',
	"\xB8F9" => '&#26681;',
	"\xB8FA" => '&#36319;',
	"\xB8FB" => '&#32789;',
	"\xB8FC" => '&#26356;',
	"\xB8FD" => '&#24218;',
	"\xB8FE" => '&#32697;',
	"\xB9A1" => '&#22466;',
	"\xB9A2" => '&#32831;',
	"\xB9A3" => '&#26775;',
	"\xB9A4" => '&#24037;',
	"\xB9A5" => '&#25915;',
	"\xB9A6" => '&#21151;',
	"\xB9A7" => '&#24685;',
	"\xB9A8" => '&#40858;',
	"\xB9A9" => '&#20379;',
	"\xB9AA" => '&#36524;',
	"\xB9AB" => '&#20844;',
	"\xB9AC" => '&#23467;',
	"\xB9AD" => '&#24339;',
	"\xB9AE" => '&#24041;',
	"\xB9AF" => '&#27742;',
	"\xB9B0" => '&#25329;',
	"\xB9B1" => '&#36129;',
	"\xB9B2" => '&#20849;',
	"\xB9B3" => '&#38057;',
	"\xB9B4" => '&#21246;',
	"\xB9B5" => '&#27807;',
	"\xB9B6" => '&#33503;',
	"\xB9B7" => '&#29399;',
	"\xB9B8" => '&#22434;',
	"\xB9B9" => '&#26500;',
	"\xB9BA" => '&#36141;',
	"\xB9BB" => '&#22815;',
	"\xB9BC" => '&#36764;',
	"\xB9BD" => '&#33735;',
	"\xB9BE" => '&#21653;',
	"\xB9BF" => '&#31629;',
	"\xB9C0" => '&#20272;',
	"\xB9C1" => '&#27837;',
	"\xB9C2" => '&#23396;',
	"\xB9C3" => '&#22993;',
	"\xB9C4" => '&#40723;',
	"\xB9C5" => '&#21476;',
	"\xB9C6" => '&#34506;',
	"\xB9C7" => '&#39592;',
	"\xB9C8" => '&#35895;',
	"\xB9C9" => '&#32929;',
	"\xB9CA" => '&#25925;',
	"\xB9CB" => '&#39038;',
	"\xB9CC" => '&#22266;',
	"\xB9CD" => '&#38599;',
	"\xB9CE" => '&#21038;',
	"\xB9CF" => '&#29916;',
	"\xB9D0" => '&#21072;',
	"\xB9D1" => '&#23521;',
	"\xB9D2" => '&#25346;',
	"\xB9D3" => '&#35074;',
	"\xB9D4" => '&#20054;',
	"\xB9D5" => '&#25296;',
	"\xB9D6" => '&#24618;',
	"\xB9D7" => '&#26874;',
	"\xB9D8" => '&#20851;',
	"\xB9D9" => '&#23448;',
	"\xB9DA" => '&#20896;',
	"\xB9DB" => '&#35266;',
	"\xB9DC" => '&#31649;',
	"\xB9DD" => '&#39302;',
	"\xB9DE" => '&#32592;',
	"\xB9DF" => '&#24815;',
	"\xB9E0" => '&#28748;',
	"\xB9E1" => '&#36143;',
	"\xB9E2" => '&#20809;',
	"\xB9E3" => '&#24191;',
	"\xB9E4" => '&#36891;',
	"\xB9E5" => '&#29808;',
	"\xB9E6" => '&#35268;',
	"\xB9E7" => '&#22317;',
	"\xB9E8" => '&#30789;',
	"\xB9E9" => '&#24402;',
	"\xB9EA" => '&#40863;',
	"\xB9EB" => '&#38394;',
	"\xB9EC" => '&#36712;',
	"\xB9ED" => '&#39740;',
	"\xB9EE" => '&#35809;',
	"\xB9EF" => '&#30328;',
	"\xB9F0" => '&#26690;',
	"\xB9F1" => '&#26588;',
	"\xB9F2" => '&#36330;',
	"\xB9F3" => '&#36149;',
	"\xB9F4" => '&#21053;',
	"\xB9F5" => '&#36746;',
	"\xB9F6" => '&#28378;',
	"\xB9F7" => '&#26829;',
	"\xB9F8" => '&#38149;',
	"\xB9F9" => '&#37101;',
	"\xB9FA" => '&#22269;',
	"\xB9FB" => '&#26524;',
	"\xB9FC" => '&#35065;',
	"\xB9FD" => '&#36807;',
	"\xB9FE" => '&#21704;',
	"\xBAA1" => '&#39608;',
	"\xBAA2" => '&#23401;',
	"\xBAA3" => '&#28023;',
	"\xBAA4" => '&#27686;',
	"\xBAA5" => '&#20133;',
	"\xBAA6" => '&#23475;',
	"\xBAA7" => '&#39559;',
	"\xBAA8" => '&#37219;',
	"\xBAA9" => '&#25000;',
	"\xBAAA" => '&#37039;',
	"\xBAAB" => '&#38889;',
	"\xBAAC" => '&#21547;',
	"\xBAAD" => '&#28085;',
	"\xBAAE" => '&#23506;',
	"\xBAAF" => '&#20989;',
	"\xBAB0" => '&#21898;',
	"\xBAB1" => '&#32597;',
	"\xBAB2" => '&#32752;',
	"\xBAB3" => '&#25788;',
	"\xBAB4" => '&#25421;',
	"\xBAB5" => '&#26097;',
	"\xBAB6" => '&#25022;',
	"\xBAB7" => '&#24717;',
	"\xBAB8" => '&#28938;',
	"\xBAB9" => '&#27735;',
	"\xBABA" => '&#27721;',
	"\xBABB" => '&#22831;',
	"\xBABC" => '&#26477;',
	"\xBABD" => '&#33322;',
	"\xBABE" => '&#22741;',
	"\xBABF" => '&#22158;',
	"\xBAC0" => '&#35946;',
	"\xBAC1" => '&#27627;',
	"\xBAC2" => '&#37085;',
	"\xBAC3" => '&#22909;',
	"\xBAC4" => '&#32791;',
	"\xBAC5" => '&#21495;',
	"\xBAC6" => '&#28009;',
	"\xBAC7" => '&#21621;',
	"\xBAC8" => '&#21917;',
	"\xBAC9" => '&#33655;',
	"\xBACA" => '&#33743;',
	"\xBACB" => '&#26680;',
	"\xBACC" => '&#31166;',
	"\xBACD" => '&#21644;',
	"\xBACE" => '&#20309;',
	"\xBACF" => '&#21512;',
	"\xBAD0" => '&#30418;',
	"\xBAD1" => '&#35977;',
	"\xBAD2" => '&#38402;',
	"\xBAD3" => '&#27827;',
	"\xBAD4" => '&#28088;',
	"\xBAD5" => '&#36203;',
	"\xBAD6" => '&#35088;',
	"\xBAD7" => '&#40548;',
	"\xBAD8" => '&#36154;',
	"\xBAD9" => '&#22079;',
	"\xBADA" => '&#40657;',
	"\xBADB" => '&#30165;',
	"\xBADC" => '&#24456;',
	"\xBADD" => '&#29408;',
	"\xBADE" => '&#24680;',
	"\xBADF" => '&#21756;',
	"\xBAE0" => '&#20136;',
	"\xBAE1" => '&#27178;',
	"\xBAE2" => '&#34913;',
	"\xBAE3" => '&#24658;',
	"\xBAE4" => '&#36720;',
	"\xBAE5" => '&#21700;',
	"\xBAE6" => '&#28888;',
	"\xBAE7" => '&#34425;',
	"\xBAE8" => '&#40511;',
	"\xBAE9" => '&#27946;',
	"\xBAEA" => '&#23439;',
	"\xBAEB" => '&#24344;',
	"\xBAEC" => '&#32418;',
	"\xBAED" => '&#21897;',
	"\xBAEE" => '&#20399;',
	"\xBAEF" => '&#29492;',
	"\xBAF0" => '&#21564;',
	"\xBAF1" => '&#21402;',
	"\xBAF2" => '&#20505;',
	"\xBAF3" => '&#21518;',
	"\xBAF4" => '&#21628;',
	"\xBAF5" => '&#20046;',
	"\xBAF6" => '&#24573;',
	"\xBAF7" => '&#29786;',
	"\xBAF8" => '&#22774;',
	"\xBAF9" => '&#33899;',
	"\xBAFA" => '&#32993;',
	"\xBAFB" => '&#34676;',
	"\xBAFC" => '&#29392;',
	"\xBAFD" => '&#31946;',
	"\xBAFE" => '&#28246;',
	"\xBBA1" => '&#24359;',
	"\xBBA2" => '&#34382;',
	"\xBBA3" => '&#21804;',
	"\xBBA4" => '&#25252;',
	"\xBBA5" => '&#20114;',
	"\xBBA6" => '&#27818;',
	"\xBBA7" => '&#25143;',
	"\xBBA8" => '&#33457;',
	"\xBBA9" => '&#21719;',
	"\xBBAA" => '&#21326;',
	"\xBBAB" => '&#29502;',
	"\xBBAC" => '&#28369;',
	"\xBBAD" => '&#30011;',
	"\xBBAE" => '&#21010;',
	"\xBBAF" => '&#21270;',
	"\xBBB0" => '&#35805;',
	"\xBBB1" => '&#27088;',
	"\xBBB2" => '&#24458;',
	"\xBBB3" => '&#24576;',
	"\xBBB4" => '&#28142;',
	"\xBBB5" => '&#22351;',
	"\xBBB6" => '&#27426;',
	"\xBBB7" => '&#29615;',
	"\xBBB8" => '&#26707;',
	"\xBBB9" => '&#36824;',
	"\xBBBA" => '&#32531;',
	"\xBBBB" => '&#25442;',
	"\xBBBC" => '&#24739;',
	"\xBBBD" => '&#21796;',
	"\xBBBE" => '&#30186;',
	"\xBBBF" => '&#35938;',
	"\xBBC0" => '&#28949;',
	"\xBBC1" => '&#28067;',
	"\xBBC2" => '&#23462;',
	"\xBBC3" => '&#24187;',
	"\xBBC4" => '&#33618;',
	"\xBBC5" => '&#24908;',
	"\xBBC6" => '&#40644;',
	"\xBBC7" => '&#30970;',
	"\xBBC8" => '&#34647;',
	"\xBBC9" => '&#31783;',
	"\xBBCA" => '&#30343;',
	"\xBBCB" => '&#20976;',
	"\xBBCC" => '&#24822;',
	"\xBBCD" => '&#29004;',
	"\xBBCE" => '&#26179;',
	"\xBBCF" => '&#24140;',
	"\xBBD0" => '&#24653;',
	"\xBBD1" => '&#35854;',
	"\xBBD2" => '&#28784;',
	"\xBBD3" => '&#25381;',
	"\xBBD4" => '&#36745;',
	"\xBBD5" => '&#24509;',
	"\xBBD6" => '&#24674;',
	"\xBBD7" => '&#34516;',
	"\xBBD8" => '&#22238;',
	"\xBBD9" => '&#27585;',
	"\xBBDA" => '&#24724;',
	"\xBBDB" => '&#24935;',
	"\xBBDC" => '&#21321;',
	"\xBBDD" => '&#24800;',
	"\xBBDE" => '&#26214;',
	"\xBBDF" => '&#36159;',
	"\xBBE0" => '&#31229;',
	"\xBBE1" => '&#20250;',
	"\xBBE2" => '&#28905;',
	"\xBBE3" => '&#27719;',
	"\xBBE4" => '&#35763;',
	"\xBBE5" => '&#35826;',
	"\xBBE6" => '&#32472;',
	"\xBBE7" => '&#33636;',
	"\xBBE8" => '&#26127;',
	"\xBBE9" => '&#23130;',
	"\xBBEA" => '&#39746;',
	"\xBBEB" => '&#27985;',
	"\xBBEC" => '&#28151;',
	"\xBBED" => '&#35905;',
	"\xBBEE" => '&#27963;',
	"\xBBEF" => '&#20249;',
	"\xBBF0" => '&#28779;',
	"\xBBF1" => '&#33719;',
	"\xBBF2" => '&#25110;',
	"\xBBF3" => '&#24785;',
	"\xBBF4" => '&#38669;',
	"\xBBF5" => '&#36135;',
	"\xBBF6" => '&#31096;',
	"\xBBF7" => '&#20987;',
	"\xBBF8" => '&#22334;',
	"\xBBF9" => '&#22522;',
	"\xBBFA" => '&#26426;',
	"\xBBFB" => '&#30072;',
	"\xBBFC" => '&#31293;',
	"\xBBFD" => '&#31215;',
	"\xBBFE" => '&#31637;',
	"\xBCA1" => '&#32908;',
	"\xBCA2" => '&#39269;',
	"\xBCA3" => '&#36857;',
	"\xBCA4" => '&#28608;',
	"\xBCA5" => '&#35749;',
	"\xBCA6" => '&#40481;',
	"\xBCA7" => '&#23020;',
	"\xBCA8" => '&#32489;',
	"\xBCA9" => '&#32521;',
	"\xBCAA" => '&#21513;',
	"\xBCAB" => '&#26497;',
	"\xBCAC" => '&#26840;',
	"\xBCAD" => '&#36753;',
	"\xBCAE" => '&#31821;',
	"\xBCAF" => '&#38598;',
	"\xBCB0" => '&#21450;',
	"\xBCB1" => '&#24613;',
	"\xBCB2" => '&#30142;',
	"\xBCB3" => '&#27762;',
	"\xBCB4" => '&#21363;',
	"\xBCB5" => '&#23241;',
	"\xBCB6" => '&#32423;',
	"\xBCB7" => '&#25380;',
	"\xBCB8" => '&#20960;',
	"\xBCB9" => '&#33034;',
	"\xBCBA" => '&#24049;',
	"\xBCBB" => '&#34015;',
	"\xBCBC" => '&#25216;',
	"\xBCBD" => '&#20864;',
	"\xBCBE" => '&#23395;',
	"\xBCBF" => '&#20238;',
	"\xBCC0" => '&#31085;',
	"\xBCC1" => '&#21058;',
	"\xBCC2" => '&#24760;',
	"\xBCC3" => '&#27982;',
	"\xBCC4" => '&#23492;',
	"\xBCC5" => '&#23490;',
	"\xBCC6" => '&#35745;',
	"\xBCC7" => '&#35760;',
	"\xBCC8" => '&#26082;',
	"\xBCC9" => '&#24524;',
	"\xBCCA" => '&#38469;',
	"\xBCCB" => '&#22931;',
	"\xBCCC" => '&#32487;',
	"\xBCCD" => '&#32426;',
	"\xBCCE" => '&#22025;',
	"\xBCCF" => '&#26551;',
	"\xBCD0" => '&#22841;',
	"\xBCD1" => '&#20339;',
	"\xBCD2" => '&#23478;',
	"\xBCD3" => '&#21152;',
	"\xBCD4" => '&#33626;',
	"\xBCD5" => '&#39050;',
	"\xBCD6" => '&#36158;',
	"\xBCD7" => '&#30002;',
	"\xBCD8" => '&#38078;',
	"\xBCD9" => '&#20551;',
	"\xBCDA" => '&#31292;',
	"\xBCDB" => '&#20215;',
	"\xBCDC" => '&#26550;',
	"\xBCDD" => '&#39550;',
	"\xBCDE" => '&#23233;',
	"\xBCDF" => '&#27516;',
	"\xBCE0" => '&#30417;',
	"\xBCE1" => '&#22362;',
	"\xBCE2" => '&#23574;',
	"\xBCE3" => '&#31546;',
	"\xBCE4" => '&#38388;',
	"\xBCE5" => '&#29006;',
	"\xBCE6" => '&#20860;',
	"\xBCE7" => '&#32937;',
	"\xBCE8" => '&#33392;',
	"\xBCE9" => '&#22904;',
	"\xBCEA" => '&#32516;',
	"\xBCEB" => '&#33575;',
	"\xBCEC" => '&#26816;',
	"\xBCED" => '&#26604;',
	"\xBCEE" => '&#30897;',
	"\xBCEF" => '&#30839;',
	"\xBCF0" => '&#25315;',
	"\xBCF1" => '&#25441;',
	"\xBCF2" => '&#31616;',
	"\xBCF3" => '&#20461;',
	"\xBCF4" => '&#21098;',
	"\xBCF5" => '&#20943;',
	"\xBCF6" => '&#33616;',
	"\xBCF7" => '&#27099;',
	"\xBCF8" => '&#37492;',
	"\xBCF9" => '&#36341;',
	"\xBCFA" => '&#36145;',
	"\xBCFB" => '&#35265;',
	"\xBCFC" => '&#38190;',
	"\xBCFD" => '&#31661;',
	"\xBCFE" => '&#20214;',
	"\xBDA1" => '&#20581;',
	"\xBDA2" => '&#33328;',
	"\xBDA3" => '&#21073;',
	"\xBDA4" => '&#39279;',
	"\xBDA5" => '&#28176;',
	"\xBDA6" => '&#28293;',
	"\xBDA7" => '&#28071;',
	"\xBDA8" => '&#24314;',
	"\xBDA9" => '&#20725;',
	"\xBDAA" => '&#23004;',
	"\xBDAB" => '&#23558;',
	"\xBDAC" => '&#27974;',
	"\xBDAD" => '&#27743;',
	"\xBDAE" => '&#30086;',
	"\xBDAF" => '&#33931;',
	"\xBDB0" => '&#26728;',
	"\xBDB1" => '&#22870;',
	"\xBDB2" => '&#35762;',
	"\xBDB3" => '&#21280;',
	"\xBDB4" => '&#37233;',
	"\xBDB5" => '&#38477;',
	"\xBDB6" => '&#34121;',
	"\xBDB7" => '&#26898;',
	"\xBDB8" => '&#30977;',
	"\xBDB9" => '&#28966;',
	"\xBDBA" => '&#33014;',
	"\xBDBB" => '&#20132;',
	"\xBDBC" => '&#37066;',
	"\xBDBD" => '&#27975;',
	"\xBDBE" => '&#39556;',
	"\xBDBF" => '&#23047;',
	"\xBDC0" => '&#22204;',
	"\xBDC1" => '&#25605;',
	"\xBDC2" => '&#38128;',
	"\xBDC3" => '&#30699;',
	"\xBDC4" => '&#20389;',
	"\xBDC5" => '&#33050;',
	"\xBDC6" => '&#29409;',
	"\xBDC7" => '&#35282;',
	"\xBDC8" => '&#39290;',
	"\xBDC9" => '&#32564;',
	"\xBDCA" => '&#32478;',
	"\xBDCB" => '&#21119;',
	"\xBDCC" => '&#25945;',
	"\xBDCD" => '&#37237;',
	"\xBDCE" => '&#36735;',
	"\xBDCF" => '&#36739;',
	"\xBDD0" => '&#21483;',
	"\xBDD1" => '&#31382;',
	"\xBDD2" => '&#25581;',
	"\xBDD3" => '&#25509;',
	"\xBDD4" => '&#30342;',
	"\xBDD5" => '&#31224;',
	"\xBDD6" => '&#34903;',
	"\xBDD7" => '&#38454;',
	"\xBDD8" => '&#25130;',
	"\xBDD9" => '&#21163;',
	"\xBDDA" => '&#33410;',
	"\xBDDB" => '&#26708;',
	"\xBDDC" => '&#26480;',
	"\xBDDD" => '&#25463;',
	"\xBDDE" => '&#30571;',
	"\xBDDF" => '&#31469;',
	"\xBDE0" => '&#27905;',
	"\xBDE1" => '&#32467;',
	"\xBDE2" => '&#35299;',
	"\xBDE3" => '&#22992;',
	"\xBDE4" => '&#25106;',
	"\xBDE5" => '&#34249;',
	"\xBDE6" => '&#33445;',
	"\xBDE7" => '&#30028;',
	"\xBDE8" => '&#20511;',
	"\xBDE9" => '&#20171;',
	"\xBDEA" => '&#30117;',
	"\xBDEB" => '&#35819;',
	"\xBDEC" => '&#23626;',
	"\xBDED" => '&#24062;',
	"\xBDEE" => '&#31563;',
	"\xBDEF" => '&#26020;',
	"\xBDF0" => '&#37329;',
	"\xBDF1" => '&#20170;',
	"\xBDF2" => '&#27941;',
	"\xBDF3" => '&#35167;',
	"\xBDF4" => '&#32039;',
	"\xBDF5" => '&#38182;',
	"\xBDF6" => '&#20165;',
	"\xBDF7" => '&#35880;',
	"\xBDF8" => '&#36827;',
	"\xBDF9" => '&#38771;',
	"\xBDFA" => '&#26187;',
	"\xBDFB" => '&#31105;',
	"\xBDFC" => '&#36817;',
	"\xBDFD" => '&#28908;',
	"\xBDFE" => '&#28024;',
	"\xBEA1" => '&#23613;',
	"\xBEA2" => '&#21170;',
	"\xBEA3" => '&#33606;',
	"\xBEA4" => '&#20834;',
	"\xBEA5" => '&#33550;',
	"\xBEA6" => '&#30555;',
	"\xBEA7" => '&#26230;',
	"\xBEA8" => '&#40120;',
	"\xBEA9" => '&#20140;',
	"\xBEAA" => '&#24778;',
	"\xBEAB" => '&#31934;',
	"\xBEAC" => '&#31923;',
	"\xBEAD" => '&#32463;',
	"\xBEAE" => '&#20117;',
	"\xBEAF" => '&#35686;',
	"\xBEB0" => '&#26223;',
	"\xBEB1" => '&#39048;',
	"\xBEB2" => '&#38745;',
	"\xBEB3" => '&#22659;',
	"\xBEB4" => '&#25964;',
	"\xBEB5" => '&#38236;',
	"\xBEB6" => '&#24452;',
	"\xBEB7" => '&#30153;',
	"\xBEB8" => '&#38742;',
	"\xBEB9" => '&#31455;',
	"\xBEBA" => '&#31454;',
	"\xBEBB" => '&#20928;',
	"\xBEBC" => '&#28847;',
	"\xBEBD" => '&#31384;',
	"\xBEBE" => '&#25578;',
	"\xBEBF" => '&#31350;',
	"\xBEC0" => '&#32416;',
	"\xBEC1" => '&#29590;',
	"\xBEC2" => '&#38893;',
	"\xBEC3" => '&#20037;',
	"\xBEC4" => '&#28792;',
	"\xBEC5" => '&#20061;',
	"\xBEC6" => '&#37202;',
	"\xBEC7" => '&#21417;',
	"\xBEC8" => '&#25937;',
	"\xBEC9" => '&#26087;',
	"\xBECA" => '&#33276;',
	"\xBECB" => '&#33285;',
	"\xBECC" => '&#21646;',
	"\xBECD" => '&#23601;',
	"\xBECE" => '&#30106;',
	"\xBECF" => '&#38816;',
	"\xBED0" => '&#25304;',
	"\xBED1" => '&#29401;',
	"\xBED2" => '&#30141;',
	"\xBED3" => '&#23621;',
	"\xBED4" => '&#39545;',
	"\xBED5" => '&#33738;',
	"\xBED6" => '&#23616;',
	"\xBED7" => '&#21632;',
	"\xBED8" => '&#30697;',
	"\xBED9" => '&#20030;',
	"\xBEDA" => '&#27822;',
	"\xBEDB" => '&#32858;',
	"\xBEDC" => '&#25298;',
	"\xBEDD" => '&#25454;',
	"\xBEDE" => '&#24040;',
	"\xBEDF" => '&#20855;',
	"\xBEE0" => '&#36317;',
	"\xBEE1" => '&#36382;',
	"\xBEE2" => '&#38191;',
	"\xBEE3" => '&#20465;',
	"\xBEE4" => '&#21477;',
	"\xBEE5" => '&#24807;',
	"\xBEE6" => '&#28844;',
	"\xBEE7" => '&#21095;',
	"\xBEE8" => '&#25424;',
	"\xBEE9" => '&#40515;',
	"\xBEEA" => '&#23071;',
	"\xBEEB" => '&#20518;',
	"\xBEEC" => '&#30519;',
	"\xBEED" => '&#21367;',
	"\xBEEE" => '&#32482;',
	"\xBEEF" => '&#25733;',
	"\xBEF0" => '&#25899;',
	"\xBEF1" => '&#25225;',
	"\xBEF2" => '&#25496;',
	"\xBEF3" => '&#20500;',
	"\xBEF4" => '&#29237;',
	"\xBEF5" => '&#35273;',
	"\xBEF6" => '&#20915;',
	"\xBEF7" => '&#35776;',
	"\xBEF8" => '&#32477;',
	"\xBEF9" => '&#22343;',
	"\xBEFA" => '&#33740;',
	"\xBEFB" => '&#38055;',
	"\xBEFC" => '&#20891;',
	"\xBEFD" => '&#21531;',
	"\xBEFE" => '&#23803;',
	"\xBFA1" => '&#20426;',
	"\xBFA2" => '&#31459;',
	"\xBFA3" => '&#27994;',
	"\xBFA4" => '&#37089;',
	"\xBFA5" => '&#39567;',
	"\xBFA6" => '&#21888;',
	"\xBFA7" => '&#21654;',
	"\xBFA8" => '&#21345;',
	"\xBFA9" => '&#21679;',
	"\xBFAA" => '&#24320;',
	"\xBFAB" => '&#25577;',
	"\xBFAC" => '&#26999;',
	"\xBFAD" => '&#20975;',
	"\xBFAE" => '&#24936;',
	"\xBFAF" => '&#21002;',
	"\xBFB0" => '&#22570;',
	"\xBFB1" => '&#21208;',
	"\xBFB2" => '&#22350;',
	"\xBFB3" => '&#30733;',
	"\xBFB4" => '&#30475;',
	"\xBFB5" => '&#24247;',
	"\xBFB6" => '&#24951;',
	"\xBFB7" => '&#31968;',
	"\xBFB8" => '&#25179;',
	"\xBFB9" => '&#25239;',
	"\xBFBA" => '&#20130;',
	"\xBFBB" => '&#28821;',
	"\xBFBC" => '&#32771;',
	"\xBFBD" => '&#25335;',
	"\xBFBE" => '&#28900;',
	"\xBFBF" => '&#38752;',
	"\xBFC0" => '&#22391;',
	"\xBFC1" => '&#33499;',
	"\xBFC2" => '&#26607;',
	"\xBFC3" => '&#26869;',
	"\xBFC4" => '&#30933;',
	"\xBFC5" => '&#39063;',
	"\xBFC6" => '&#31185;',
	"\xBFC7" => '&#22771;',
	"\xBFC8" => '&#21683;',
	"\xBFC9" => '&#21487;',
	"\xBFCA" => '&#28212;',
	"\xBFCB" => '&#20811;',
	"\xBFCC" => '&#21051;',
	"\xBFCD" => '&#23458;',
	"\xBFCE" => '&#35838;',
	"\xBFCF" => '&#32943;',
	"\xBFD0" => '&#21827;',
	"\xBFD1" => '&#22438;',
	"\xBFD2" => '&#24691;',
	"\xBFD3" => '&#22353;',
	"\xBFD4" => '&#21549;',
	"\xBFD5" => '&#31354;',
	"\xBFD6" => '&#24656;',
	"\xBFD7" => '&#23380;',
	"\xBFD8" => '&#25511;',
	"\xBFD9" => '&#25248;',
	"\xBFDA" => '&#21475;',
	"\xBFDB" => '&#25187;',
	"\xBFDC" => '&#23495;',
	"\xBFDD" => '&#26543;',
	"\xBFDE" => '&#21741;',
	"\xBFDF" => '&#31391;',
	"\xBFE0" => '&#33510;',
	"\xBFE1" => '&#37239;',
	"\xBFE2" => '&#24211;',
	"\xBFE3" => '&#35044;',
	"\xBFE4" => '&#22840;',
	"\xBFE5" => '&#22446;',
	"\xBFE6" => '&#25358;',
	"\xBFE7" => '&#36328;',
	"\xBFE8" => '&#33007;',
	"\xBFE9" => '&#22359;',
	"\xBFEA" => '&#31607;',
	"\xBFEB" => '&#20393;',
	"\xBFEC" => '&#24555;',
	"\xBFED" => '&#23485;',
	"\xBFEE" => '&#27454;',
	"\xBFEF" => '&#21281;',
	"\xBFF0" => '&#31568;',
	"\xBFF1" => '&#29378;',
	"\xBFF2" => '&#26694;',
	"\xBFF3" => '&#30719;',
	"\xBFF4" => '&#30518;',
	"\xBFF5" => '&#26103;',
	"\xBFF6" => '&#20917;',
	"\xBFF7" => '&#20111;',
	"\xBFF8" => '&#30420;',
	"\xBFF9" => '&#23743;',
	"\xBFFA" => '&#31397;',
	"\xBFFB" => '&#33909;',
	"\xBFFC" => '&#22862;',
	"\xBFFD" => '&#39745;',
	"\xBFFE" => '&#20608;',
	"\xC0A1" => '&#39304;',
	"\xC0A2" => '&#24871;',
	"\xC0A3" => '&#28291;',
	"\xC0A4" => '&#22372;',
	"\xC0A5" => '&#26118;',
	"\xC0A6" => '&#25414;',
	"\xC0A7" => '&#22256;',
	"\xC0A8" => '&#25324;',
	"\xC0A9" => '&#25193;',
	"\xC0AA" => '&#24275;',
	"\xC0AB" => '&#38420;',
	"\xC0AC" => '&#22403;',
	"\xC0AD" => '&#25289;',
	"\xC0AE" => '&#21895;',
	"\xC0AF" => '&#34593;',
	"\xC0B0" => '&#33098;',
	"\xC0B1" => '&#36771;',
	"\xC0B2" => '&#21862;',
	"\xC0B3" => '&#33713;',
	"\xC0B4" => '&#26469;',
	"\xC0B5" => '&#36182;',
	"\xC0B6" => '&#34013;',
	"\xC0B7" => '&#23146;',
	"\xC0B8" => '&#26639;',
	"\xC0B9" => '&#25318;',
	"\xC0BA" => '&#31726;',
	"\xC0BB" => '&#38417;',
	"\xC0BC" => '&#20848;',
	"\xC0BD" => '&#28572;',
	"\xC0BE" => '&#35888;',
	"\xC0BF" => '&#25597;',
	"\xC0C0" => '&#35272;',
	"\xC0C1" => '&#25042;',
	"\xC0C2" => '&#32518;',
	"\xC0C3" => '&#28866;',
	"\xC0C4" => '&#28389;',
	"\xC0C5" => '&#29701;',
	"\xC0C6" => '&#27028;',
	"\xC0C7" => '&#29436;',
	"\xC0C8" => '&#24266;',
	"\xC0C9" => '&#37070;',
	"\xC0CA" => '&#26391;',
	"\xC0CB" => '&#28010;',
	"\xC0CC" => '&#25438;',
	"\xC0CD" => '&#21171;',
	"\xC0CE" => '&#29282;',
	"\xC0CF" => '&#32769;',
	"\xC0D0" => '&#20332;',
	"\xC0D1" => '&#23013;',
	"\xC0D2" => '&#37226;',
	"\xC0D3" => '&#28889;',
	"\xC0D4" => '&#28061;',
	"\xC0D5" => '&#21202;',
	"\xC0D6" => '&#20048;',
	"\xC0D7" => '&#38647;',
	"\xC0D8" => '&#38253;',
	"\xC0D9" => '&#34174;',
	"\xC0DA" => '&#30922;',
	"\xC0DB" => '&#32047;',
	"\xC0DC" => '&#20769;',
	"\xC0DD" => '&#22418;',
	"\xC0DE" => '&#25794;',
	"\xC0DF" => '&#32907;',
	"\xC0E0" => '&#31867;',
	"\xC0E1" => '&#27882;',
	"\xC0E2" => '&#26865;',
	"\xC0E3" => '&#26974;',
	"\xC0E4" => '&#20919;',
	"\xC0E5" => '&#21400;',
	"\xC0E6" => '&#26792;',
	"\xC0E7" => '&#29313;',
	"\xC0E8" => '&#40654;',
	"\xC0E9" => '&#31729;',
	"\xC0EA" => '&#29432;',
	"\xC0EB" => '&#31163;',
	"\xC0EC" => '&#28435;',
	"\xC0ED" => '&#29702;',
	"\xC0EE" => '&#26446;',
	"\xC0EF" => '&#37324;',
	"\xC0F0" => '&#40100;',
	"\xC0F1" => '&#31036;',
	"\xC0F2" => '&#33673;',
	"\xC0F3" => '&#33620;',
	"\xC0F4" => '&#21519;',
	"\xC0F5" => '&#26647;',
	"\xC0F6" => '&#20029;',
	"\xC0F7" => '&#21385;',
	"\xC0F8" => '&#21169;',
	"\xC0F9" => '&#30782;',
	"\xC0FA" => '&#21382;',
	"\xC0FB" => '&#21033;',
	"\xC0FC" => '&#20616;',
	"\xC0FD" => '&#20363;',
	"\xC0FE" => '&#20432;',
	"\xC1A1" => '&#30178;',
	"\xC1A2" => '&#31435;',
	"\xC1A3" => '&#31890;',
	"\xC1A4" => '&#27813;',
	"\xC1A5" => '&#38582;',
	"\xC1A6" => '&#21147;',
	"\xC1A7" => '&#29827;',
	"\xC1A8" => '&#21737;',
	"\xC1A9" => '&#20457;',
	"\xC1AA" => '&#32852;',
	"\xC1AB" => '&#33714;',
	"\xC1AC" => '&#36830;',
	"\xC1AD" => '&#38256;',
	"\xC1AE" => '&#24265;',
	"\xC1AF" => '&#24604;',
	"\xC1B0" => '&#28063;',
	"\xC1B1" => '&#24088;',
	"\xC1B2" => '&#25947;',
	"\xC1B3" => '&#33080;',
	"\xC1B4" => '&#38142;',
	"\xC1B5" => '&#24651;',
	"\xC1B6" => '&#28860;',
	"\xC1B7" => '&#32451;',
	"\xC1B8" => '&#31918;',
	"\xC1B9" => '&#20937;',
	"\xC1BA" => '&#26753;',
	"\xC1BB" => '&#31921;',
	"\xC1BC" => '&#33391;',
	"\xC1BD" => '&#20004;',
	"\xC1BE" => '&#36742;',
	"\xC1BF" => '&#37327;',
	"\xC1C0" => '&#26238;',
	"\xC1C1" => '&#20142;',
	"\xC1C2" => '&#35845;',
	"\xC1C3" => '&#25769;',
	"\xC1C4" => '&#32842;',
	"\xC1C5" => '&#20698;',
	"\xC1C6" => '&#30103;',
	"\xC1C7" => '&#29134;',
	"\xC1C8" => '&#23525;',
	"\xC1C9" => '&#36797;',
	"\xC1CA" => '&#28518;',
	"\xC1CB" => '&#20102;',
	"\xC1CC" => '&#25730;',
	"\xC1CD" => '&#38243;',
	"\xC1CE" => '&#24278;',
	"\xC1CF" => '&#26009;',
	"\xC1D0" => '&#21015;',
	"\xC1D1" => '&#35010;',
	"\xC1D2" => '&#28872;',
	"\xC1D3" => '&#21155;',
	"\xC1D4" => '&#29454;',
	"\xC1D5" => '&#29747;',
	"\xC1D6" => '&#26519;',
	"\xC1D7" => '&#30967;',
	"\xC1D8" => '&#38678;',
	"\xC1D9" => '&#20020;',
	"\xC1DA" => '&#37051;',
	"\xC1DB" => '&#40158;',
	"\xC1DC" => '&#28107;',
	"\xC1DD" => '&#20955;',
	"\xC1DE" => '&#36161;',
	"\xC1DF" => '&#21533;',
	"\xC1E0" => '&#25294;',
	"\xC1E1" => '&#29618;',
	"\xC1E2" => '&#33777;',
	"\xC1E3" => '&#38646;',
	"\xC1E4" => '&#40836;',
	"\xC1E5" => '&#38083;',
	"\xC1E6" => '&#20278;',
	"\xC1E7" => '&#32666;',
	"\xC1E8" => '&#20940;',
	"\xC1E9" => '&#28789;',
	"\xC1EA" => '&#38517;',
	"\xC1EB" => '&#23725;',
	"\xC1EC" => '&#39046;',
	"\xC1ED" => '&#21478;',
	"\xC1EE" => '&#20196;',
	"\xC1EF" => '&#28316;',
	"\xC1F0" => '&#29705;',
	"\xC1F1" => '&#27060;',
	"\xC1F2" => '&#30827;',
	"\xC1F3" => '&#39311;',
	"\xC1F4" => '&#30041;',
	"\xC1F5" => '&#21016;',
	"\xC1F6" => '&#30244;',
	"\xC1F7" => '&#27969;',
	"\xC1F8" => '&#26611;',
	"\xC1F9" => '&#20845;',
	"\xC1FA" => '&#40857;',
	"\xC1FB" => '&#32843;',
	"\xC1FC" => '&#21657;',
	"\xC1FD" => '&#31548;',
	"\xC1FE" => '&#31423;',
	"\xC2A1" => '&#38534;',
	"\xC2A2" => '&#22404;',
	"\xC2A3" => '&#25314;',
	"\xC2A4" => '&#38471;',
	"\xC2A5" => '&#27004;',
	"\xC2A6" => '&#23044;',
	"\xC2A7" => '&#25602;',
	"\xC2A8" => '&#31699;',
	"\xC2A9" => '&#28431;',
	"\xC2AA" => '&#38475;',
	"\xC2AB" => '&#33446;',
	"\xC2AC" => '&#21346;',
	"\xC2AD" => '&#39045;',
	"\xC2AE" => '&#24208;',
	"\xC2AF" => '&#28809;',
	"\xC2B0" => '&#25523;',
	"\xC2B1" => '&#21348;',
	"\xC2B2" => '&#34383;',
	"\xC2B3" => '&#40065;',
	"\xC2B4" => '&#40595;',
	"\xC2B5" => '&#30860;',
	"\xC2B6" => '&#38706;',
	"\xC2B7" => '&#36335;',
	"\xC2B8" => '&#36162;',
	"\xC2B9" => '&#40575;',
	"\xC2BA" => '&#28510;',
	"\xC2BB" => '&#31108;',
	"\xC2BC" => '&#24405;',
	"\xC2BD" => '&#38470;',
	"\xC2BE" => '&#25134;',
	"\xC2BF" => '&#39540;',
	"\xC2C0" => '&#21525;',
	"\xC2C1" => '&#38109;',
	"\xC2C2" => '&#20387;',
	"\xC2C3" => '&#26053;',
	"\xC2C4" => '&#23653;',
	"\xC2C5" => '&#23649;',
	"\xC2C6" => '&#32533;',
	"\xC2C7" => '&#34385;',
	"\xC2C8" => '&#27695;',
	"\xC2C9" => '&#24459;',
	"\xC2CA" => '&#29575;',
	"\xC2CB" => '&#28388;',
	"\xC2CC" => '&#32511;',
	"\xC2CD" => '&#23782;',
	"\xC2CE" => '&#25371;',
	"\xC2CF" => '&#23402;',
	"\xC2D0" => '&#28390;',
	"\xC2D1" => '&#21365;',
	"\xC2D2" => '&#20081;',
	"\xC2D3" => '&#25504;',
	"\xC2D4" => '&#30053;',
	"\xC2D5" => '&#25249;',
	"\xC2D6" => '&#36718;',
	"\xC2D7" => '&#20262;',
	"\xC2D8" => '&#20177;',
	"\xC2D9" => '&#27814;',
	"\xC2DA" => '&#32438;',
	"\xC2DB" => '&#35770;',
	"\xC2DC" => '&#33821;',
	"\xC2DD" => '&#34746;',
	"\xC2DE" => '&#32599;',
	"\xC2DF" => '&#36923;',
	"\xC2E0" => '&#38179;',
	"\xC2E1" => '&#31657;',
	"\xC2E2" => '&#39585;',
	"\xC2E3" => '&#35064;',
	"\xC2E4" => '&#33853;',
	"\xC2E5" => '&#27931;',
	"\xC2E6" => '&#39558;',
	"\xC2E7" => '&#32476;',
	"\xC2E8" => '&#22920;',
	"\xC2E9" => '&#40635;',
	"\xC2EA" => '&#29595;',
	"\xC2EB" => '&#30721;',
	"\xC2EC" => '&#34434;',
	"\xC2ED" => '&#39532;',
	"\xC2EE" => '&#39554;',
	"\xC2EF" => '&#22043;',
	"\xC2F0" => '&#21527;',
	"\xC2F1" => '&#22475;',
	"\xC2F2" => '&#20080;',
	"\xC2F3" => '&#40614;',
	"\xC2F4" => '&#21334;',
	"\xC2F5" => '&#36808;',
	"\xC2F6" => '&#33033;',
	"\xC2F7" => '&#30610;',
	"\xC2F8" => '&#39314;',
	"\xC2F9" => '&#34542;',
	"\xC2FA" => '&#28385;',
	"\xC2FB" => '&#34067;',
	"\xC2FC" => '&#26364;',
	"\xC2FD" => '&#24930;',
	"\xC2FE" => '&#28459;',
	"\xC3A1" => '&#35881;',
	"\xC3A2" => '&#33426;',
	"\xC3A3" => '&#33579;',
	"\xC3A4" => '&#30450;',
	"\xC3A5" => '&#27667;',
	"\xC3A6" => '&#24537;',
	"\xC3A7" => '&#33725;',
	"\xC3A8" => '&#29483;',
	"\xC3A9" => '&#33541;',
	"\xC3AA" => '&#38170;',
	"\xC3AB" => '&#27611;',
	"\xC3AC" => '&#30683;',
	"\xC3AD" => '&#38086;',
	"\xC3AE" => '&#21359;',
	"\xC3AF" => '&#33538;',
	"\xC3B0" => '&#20882;',
	"\xC3B1" => '&#24125;',
	"\xC3B2" => '&#35980;',
	"\xC3B3" => '&#36152;',
	"\xC3B4" => '&#20040;',
	"\xC3B5" => '&#29611;',
	"\xC3B6" => '&#26522;',
	"\xC3B7" => '&#26757;',
	"\xC3B8" => '&#37238;',
	"\xC3B9" => '&#38665;',
	"\xC3BA" => '&#29028;',
	"\xC3BB" => '&#27809;',
	"\xC3BC" => '&#30473;',
	"\xC3BD" => '&#23186;',
	"\xC3BE" => '&#38209;',
	"\xC3BF" => '&#27599;',
	"\xC3C0" => '&#32654;',
	"\xC3C1" => '&#26151;',
	"\xC3C2" => '&#23504;',
	"\xC3C3" => '&#22969;',
	"\xC3C4" => '&#23194;',
	"\xC3C5" => '&#38376;',
	"\xC3C6" => '&#38391;',
	"\xC3C7" => '&#20204;',
	"\xC3C8" => '&#33804;',
	"\xC3C9" => '&#33945;',
	"\xC3CA" => '&#27308;',
	"\xC3CB" => '&#30431;',
	"\xC3CC" => '&#38192;',
	"\xC3CD" => '&#29467;',
	"\xC3CE" => '&#26790;',
	"\xC3CF" => '&#23391;',
	"\xC3D0" => '&#30511;',
	"\xC3D1" => '&#37274;',
	"\xC3D2" => '&#38753;',
	"\xC3D3" => '&#31964;',
	"\xC3D4" => '&#36855;',
	"\xC3D5" => '&#35868;',
	"\xC3D6" => '&#24357;',
	"\xC3D7" => '&#31859;',
	"\xC3D8" => '&#31192;',
	"\xC3D9" => '&#35269;',
	"\xC3DA" => '&#27852;',
	"\xC3DB" => '&#34588;',
	"\xC3DC" => '&#23494;',
	"\xC3DD" => '&#24130;',
	"\xC3DE" => '&#26825;',
	"\xC3DF" => '&#30496;',
	"\xC3E0" => '&#32501;',
	"\xC3E1" => '&#20885;',
	"\xC3E2" => '&#20813;',
	"\xC3E3" => '&#21193;',
	"\xC3E4" => '&#23081;',
	"\xC3E5" => '&#32517;',
	"\xC3E6" => '&#38754;',
	"\xC3E7" => '&#33495;',
	"\xC3E8" => '&#25551;',
	"\xC3E9" => '&#30596;',
	"\xC3EA" => '&#34256;',
	"\xC3EB" => '&#31186;',
	"\xC3EC" => '&#28218;',
	"\xC3ED" => '&#24217;',
	"\xC3EE" => '&#22937;',
	"\xC3EF" => '&#34065;',
	"\xC3F0" => '&#28781;',
	"\xC3F1" => '&#27665;',
	"\xC3F2" => '&#25279;',
	"\xC3F3" => '&#30399;',
	"\xC3F4" => '&#25935;',
	"\xC3F5" => '&#24751;',
	"\xC3F6" => '&#38397;',
	"\xC3F7" => '&#26126;',
	"\xC3F8" => '&#34719;',
	"\xC3F9" => '&#40483;',
	"\xC3FA" => '&#38125;',
	"\xC3FB" => '&#21517;',
	"\xC3FC" => '&#21629;',
	"\xC3FD" => '&#35884;',
	"\xC3FE" => '&#25720;',
	"\xC4A1" => '&#25721;',
	"\xC4A2" => '&#34321;',
	"\xC4A3" => '&#27169;',
	"\xC4A4" => '&#33180;',
	"\xC4A5" => '&#30952;',
	"\xC4A6" => '&#25705;',
	"\xC4A7" => '&#39764;',
	"\xC4A8" => '&#25273;',
	"\xC4A9" => '&#26411;',
	"\xC4AA" => '&#33707;',
	"\xC4AB" => '&#22696;',
	"\xC4AC" => '&#40664;',
	"\xC4AD" => '&#27819;',
	"\xC4AE" => '&#28448;',
	"\xC4AF" => '&#23518;',
	"\xC4B0" => '&#38476;',
	"\xC4B1" => '&#35851;',
	"\xC4B2" => '&#29279;',
	"\xC4B3" => '&#26576;',
	"\xC4B4" => '&#25287;',
	"\xC4B5" => '&#29281;',
	"\xC4B6" => '&#20137;',
	"\xC4B7" => '&#22982;',
	"\xC4B8" => '&#27597;',
	"\xC4B9" => '&#22675;',
	"\xC4BA" => '&#26286;',
	"\xC4BB" => '&#24149;',
	"\xC4BC" => '&#21215;',
	"\xC4BD" => '&#24917;',
	"\xC4BE" => '&#26408;',
	"\xC4BF" => '&#30446;',
	"\xC4C0" => '&#30566;',
	"\xC4C1" => '&#29287;',
	"\xC4C2" => '&#31302;',
	"\xC4C3" => '&#25343;',
	"\xC4C4" => '&#21738;',
	"\xC4C5" => '&#21584;',
	"\xC4C6" => '&#38048;',
	"\xC4C7" => '&#37027;',
	"\xC4C8" => '&#23068;',
	"\xC4C9" => '&#32435;',
	"\xC4CA" => '&#27670;',
	"\xC4CB" => '&#20035;',
	"\xC4CC" => '&#22902;',
	"\xC4CD" => '&#32784;',
	"\xC4CE" => '&#22856;',
	"\xC4CF" => '&#21335;',
	"\xC4D0" => '&#30007;',
	"\xC4D1" => '&#38590;',
	"\xC4D2" => '&#22218;',
	"\xC4D3" => '&#25376;',
	"\xC4D4" => '&#33041;',
	"\xC4D5" => '&#24700;',
	"\xC4D6" => '&#38393;',
	"\xC4D7" => '&#28118;',
	"\xC4D8" => '&#21602;',
	"\xC4D9" => '&#39297;',
	"\xC4DA" => '&#20869;',
	"\xC4DB" => '&#23273;',
	"\xC4DC" => '&#33021;',
	"\xC4DD" => '&#22958;',
	"\xC4DE" => '&#38675;',
	"\xC4DF" => '&#20522;',
	"\xC4E0" => '&#27877;',
	"\xC4E1" => '&#23612;',
	"\xC4E2" => '&#25311;',
	"\xC4E3" => '&#20320;',
	"\xC4E4" => '&#21311;',
	"\xC4E5" => '&#33147;',
	"\xC4E6" => '&#36870;',
	"\xC4E7" => '&#28346;',
	"\xC4E8" => '&#34091;',
	"\xC4E9" => '&#25288;',
	"\xC4EA" => '&#24180;',
	"\xC4EB" => '&#30910;',
	"\xC4EC" => '&#25781;',
	"\xC4ED" => '&#25467;',
	"\xC4EE" => '&#24565;',
	"\xC4EF" => '&#23064;',
	"\xC4F0" => '&#37247;',
	"\xC4F1" => '&#40479;',
	"\xC4F2" => '&#23615;',
	"\xC4F3" => '&#25423;',
	"\xC4F4" => '&#32834;',
	"\xC4F5" => '&#23421;',
	"\xC4F6" => '&#21870;',
	"\xC4F7" => '&#38218;',
	"\xC4F8" => '&#38221;',
	"\xC4F9" => '&#28037;',
	"\xC4FA" => '&#24744;',
	"\xC4FB" => '&#26592;',
	"\xC4FC" => '&#29406;',
	"\xC4FD" => '&#20957;',
	"\xC4FE" => '&#23425;',
	"\xC5A1" => '&#25319;',
	"\xC5A2" => '&#27870;',
	"\xC5A3" => '&#29275;',
	"\xC5A4" => '&#25197;',
	"\xC5A5" => '&#38062;',
	"\xC5A6" => '&#32445;',
	"\xC5A7" => '&#33043;',
	"\xC5A8" => '&#27987;',
	"\xC5A9" => '&#20892;',
	"\xC5AA" => '&#24324;',
	"\xC5AB" => '&#22900;',
	"\xC5AC" => '&#21162;',
	"\xC5AD" => '&#24594;',
	"\xC5AE" => '&#22899;',
	"\xC5AF" => '&#26262;',
	"\xC5B0" => '&#34384;',
	"\xC5B1" => '&#30111;',
	"\xC5B2" => '&#25386;',
	"\xC5B3" => '&#25062;',
	"\xC5B4" => '&#31983;',
	"\xC5B5" => '&#35834;',
	"\xC5B6" => '&#21734;',
	"\xC5B7" => '&#27431;',
	"\xC5B8" => '&#40485;',
	"\xC5B9" => '&#27572;',
	"\xC5BA" => '&#34261;',
	"\xC5BB" => '&#21589;',
	"\xC5BC" => '&#20598;',
	"\xC5BD" => '&#27812;',
	"\xC5BE" => '&#21866;',
	"\xC5BF" => '&#36276;',
	"\xC5C0" => '&#29228;',
	"\xC5C1" => '&#24085;',
	"\xC5C2" => '&#24597;',
	"\xC5C3" => '&#29750;',
	"\xC5C4" => '&#25293;',
	"\xC5C5" => '&#25490;',
	"\xC5C6" => '&#29260;',
	"\xC5C7" => '&#24472;',
	"\xC5C8" => '&#28227;',
	"\xC5C9" => '&#27966;',
	"\xC5CA" => '&#25856;',
	"\xC5CB" => '&#28504;',
	"\xC5CC" => '&#30424;',
	"\xC5CD" => '&#30928;',
	"\xC5CE" => '&#30460;',
	"\xC5CF" => '&#30036;',
	"\xC5D0" => '&#21028;',
	"\xC5D1" => '&#21467;',
	"\xC5D2" => '&#20051;',
	"\xC5D3" => '&#24222;',
	"\xC5D4" => '&#26049;',
	"\xC5D5" => '&#32810;',
	"\xC5D6" => '&#32982;',
	"\xC5D7" => '&#25243;',
	"\xC5D8" => '&#21638;',
	"\xC5D9" => '&#21032;',
	"\xC5DA" => '&#28846;',
	"\xC5DB" => '&#34957;',
	"\xC5DC" => '&#36305;',
	"\xC5DD" => '&#27873;',
	"\xC5DE" => '&#21624;',
	"\xC5DF" => '&#32986;',
	"\xC5E0" => '&#22521;',
	"\xC5E1" => '&#35060;',
	"\xC5E2" => '&#36180;',
	"\xC5E3" => '&#38506;',
	"\xC5E4" => '&#37197;',
	"\xC5E5" => '&#20329;',
	"\xC5E6" => '&#27803;',
	"\xC5E7" => '&#21943;',
	"\xC5E8" => '&#30406;',
	"\xC5E9" => '&#30768;',
	"\xC5EA" => '&#25256;',
	"\xC5EB" => '&#28921;',
	"\xC5EC" => '&#28558;',
	"\xC5ED" => '&#24429;',
	"\xC5EE" => '&#34028;',
	"\xC5EF" => '&#26842;',
	"\xC5F0" => '&#30844;',
	"\xC5F1" => '&#31735;',
	"\xC5F2" => '&#33192;',
	"\xC5F3" => '&#26379;',
	"\xC5F4" => '&#40527;',
	"\xC5F5" => '&#25447;',
	"\xC5F6" => '&#30896;',
	"\xC5F7" => '&#22383;',
	"\xC5F8" => '&#30738;',
	"\xC5F9" => '&#38713;',
	"\xC5FA" => '&#25209;',
	"\xC5FB" => '&#25259;',
	"\xC5FC" => '&#21128;',
	"\xC5FD" => '&#29749;',
	"\xC5FE" => '&#27607;',
	"\xC6A1" => '&#21860;',
	"\xC6A2" => '&#33086;',
	"\xC6A3" => '&#30130;',
	"\xC6A4" => '&#30382;',
	"\xC6A5" => '&#21305;',
	"\xC6A6" => '&#30174;',
	"\xC6A7" => '&#20731;',
	"\xC6A8" => '&#23617;',
	"\xC6A9" => '&#35692;',
	"\xC6AA" => '&#31687;',
	"\xC6AB" => '&#20559;',
	"\xC6AC" => '&#29255;',
	"\xC6AD" => '&#39575;',
	"\xC6AE" => '&#39128;',
	"\xC6AF" => '&#28418;',
	"\xC6B0" => '&#29922;',
	"\xC6B1" => '&#31080;',
	"\xC6B2" => '&#25735;',
	"\xC6B3" => '&#30629;',
	"\xC6B4" => '&#25340;',
	"\xC6B5" => '&#39057;',
	"\xC6B6" => '&#36139;',
	"\xC6B7" => '&#21697;',
	"\xC6B8" => '&#32856;',
	"\xC6B9" => '&#20050;',
	"\xC6BA" => '&#22378;',
	"\xC6BB" => '&#33529;',
	"\xC6BC" => '&#33805;',
	"\xC6BD" => '&#24179;',
	"\xC6BE" => '&#20973;',
	"\xC6BF" => '&#29942;',
	"\xC6C0" => '&#35780;',
	"\xC6C1" => '&#23631;',
	"\xC6C2" => '&#22369;',
	"\xC6C3" => '&#27900;',
	"\xC6C4" => '&#39047;',
	"\xC6C5" => '&#23110;',
	"\xC6C6" => '&#30772;',
	"\xC6C7" => '&#39748;',
	"\xC6C8" => '&#36843;',
	"\xC6C9" => '&#31893;',
	"\xC6CA" => '&#21078;',
	"\xC6CB" => '&#25169;',
	"\xC6CC" => '&#38138;',
	"\xC6CD" => '&#20166;',
	"\xC6CE" => '&#33670;',
	"\xC6CF" => '&#33889;',
	"\xC6D0" => '&#33769;',
	"\xC6D1" => '&#33970;',
	"\xC6D2" => '&#22484;',
	"\xC6D3" => '&#26420;',
	"\xC6D4" => '&#22275;',
	"\xC6D5" => '&#26222;',
	"\xC6D6" => '&#28006;',
	"\xC6D7" => '&#35889;',
	"\xC6D8" => '&#26333;',
	"\xC6D9" => '&#28689;',
	"\xC6DA" => '&#26399;',
	"\xC6DB" => '&#27450;',
	"\xC6DC" => '&#26646;',
	"\xC6DD" => '&#25114;',
	"\xC6DE" => '&#22971;',
	"\xC6DF" => '&#19971;',
	"\xC6E0" => '&#20932;',
	"\xC6E1" => '&#28422;',
	"\xC6E2" => '&#26578;',
	"\xC6E3" => '&#27791;',
	"\xC6E4" => '&#20854;',
	"\xC6E5" => '&#26827;',
	"\xC6E6" => '&#22855;',
	"\xC6E7" => '&#27495;',
	"\xC6E8" => '&#30054;',
	"\xC6E9" => '&#23822;',
	"\xC6EA" => '&#33040;',
	"\xC6EB" => '&#40784;',
	"\xC6EC" => '&#26071;',
	"\xC6ED" => '&#31048;',
	"\xC6EE" => '&#31041;',
	"\xC6EF" => '&#39569;',
	"\xC6F0" => '&#36215;',
	"\xC6F1" => '&#23682;',
	"\xC6F2" => '&#20062;',
	"\xC6F3" => '&#20225;',
	"\xC6F4" => '&#21551;',
	"\xC6F5" => '&#22865;',
	"\xC6F6" => '&#30732;',
	"\xC6F7" => '&#22120;',
	"\xC6F8" => '&#27668;',
	"\xC6F9" => '&#36804;',
	"\xC6FA" => '&#24323;',
	"\xC6FB" => '&#27773;',
	"\xC6FC" => '&#27875;',
	"\xC6FD" => '&#35755;',
	"\xC6FE" => '&#25488;',
	"\xC7A1" => '&#24688;',
	"\xC7A2" => '&#27965;',
	"\xC7A3" => '&#29301;',
	"\xC7A4" => '&#25190;',
	"\xC7A5" => '&#38030;',
	"\xC7A6" => '&#38085;',
	"\xC7A7" => '&#21315;',
	"\xC7A8" => '&#36801;',
	"\xC7A9" => '&#31614;',
	"\xC7AA" => '&#20191;',
	"\xC7AB" => '&#35878;',
	"\xC7AC" => '&#20094;',
	"\xC7AD" => '&#40660;',
	"\xC7AE" => '&#38065;',
	"\xC7AF" => '&#38067;',
	"\xC7B0" => '&#21069;',
	"\xC7B1" => '&#28508;',
	"\xC7B2" => '&#36963;',
	"\xC7B3" => '&#27973;',
	"\xC7B4" => '&#35892;',
	"\xC7B5" => '&#22545;',
	"\xC7B6" => '&#23884;',
	"\xC7B7" => '&#27424;',
	"\xC7B8" => '&#27465;',
	"\xC7B9" => '&#26538;',
	"\xC7BA" => '&#21595;',
	"\xC7BB" => '&#33108;',
	"\xC7BC" => '&#32652;',
	"\xC7BD" => '&#22681;',
	"\xC7BE" => '&#34103;',
	"\xC7BF" => '&#24378;',
	"\xC7C0" => '&#25250;',
	"\xC7C1" => '&#27207;',
	"\xC7C2" => '&#38201;',
	"\xC7C3" => '&#25970;',
	"\xC7C4" => '&#24708;',
	"\xC7C5" => '&#26725;',
	"\xC7C6" => '&#30631;',
	"\xC7C7" => '&#20052;',
	"\xC7C8" => '&#20392;',
	"\xC7C9" => '&#24039;',
	"\xC7CA" => '&#38808;',
	"\xC7CB" => '&#25772;',
	"\xC7CC" => '&#32728;',
	"\xC7CD" => '&#23789;',
	"\xC7CE" => '&#20431;',
	"\xC7CF" => '&#31373;',
	"\xC7D0" => '&#20999;',
	"\xC7D1" => '&#33540;',
	"\xC7D2" => '&#19988;',
	"\xC7D3" => '&#24623;',
	"\xC7D4" => '&#31363;',
	"\xC7D5" => '&#38054;',
	"\xC7D6" => '&#20405;',
	"\xC7D7" => '&#20146;',
	"\xC7D8" => '&#31206;',
	"\xC7D9" => '&#29748;',
	"\xC7DA" => '&#21220;',
	"\xC7DB" => '&#33465;',
	"\xC7DC" => '&#25810;',
	"\xC7DD" => '&#31165;',
	"\xC7DE" => '&#23517;',
	"\xC7DF" => '&#27777;',
	"\xC7E0" => '&#38738;',
	"\xC7E1" => '&#36731;',
	"\xC7E2" => '&#27682;',
	"\xC7E3" => '&#20542;',
	"\xC7E4" => '&#21375;',
	"\xC7E5" => '&#28165;',
	"\xC7E6" => '&#25806;',
	"\xC7E7" => '&#26228;',
	"\xC7E8" => '&#27696;',
	"\xC7E9" => '&#24773;',
	"\xC7EA" => '&#39031;',
	"\xC7EB" => '&#35831;',
	"\xC7EC" => '&#24198;',
	"\xC7ED" => '&#29756;',
	"\xC7EE" => '&#31351;',
	"\xC7EF" => '&#31179;',
	"\xC7F0" => '&#19992;',
	"\xC7F1" => '&#37041;',
	"\xC7F2" => '&#29699;',
	"\xC7F3" => '&#27714;',
	"\xC7F4" => '&#22234;',
	"\xC7F5" => '&#37195;',
	"\xC7F6" => '&#27845;',
	"\xC7F7" => '&#36235;',
	"\xC7F8" => '&#21306;',
	"\xC7F9" => '&#34502;',
	"\xC7FA" => '&#26354;',
	"\xC7FB" => '&#36527;',
	"\xC7FC" => '&#23624;',
	"\xC7FD" => '&#39537;',
	"\xC7FE" => '&#28192;',
	"\xC8A1" => '&#21462;',
	"\xC8A2" => '&#23094;',
	"\xC8A3" => '&#40843;',
	"\xC8A4" => '&#36259;',
	"\xC8A5" => '&#21435;',
	"\xC8A6" => '&#22280;',
	"\xC8A7" => '&#39079;',
	"\xC8A8" => '&#26435;',
	"\xC8A9" => '&#37275;',
	"\xC8AA" => '&#27849;',
	"\xC8AB" => '&#20840;',
	"\xC8AC" => '&#30154;',
	"\xC8AD" => '&#25331;',
	"\xC8AE" => '&#29356;',
	"\xC8AF" => '&#21048;',
	"\xC8B0" => '&#21149;',
	"\xC8B1" => '&#32570;',
	"\xC8B2" => '&#28820;',
	"\xC8B3" => '&#30264;',
	"\xC8B4" => '&#21364;',
	"\xC8B5" => '&#40522;',
	"\xC8B6" => '&#27063;',
	"\xC8B7" => '&#30830;',
	"\xC8B8" => '&#38592;',
	"\xC8B9" => '&#35033;',
	"\xC8BA" => '&#32676;',
	"\xC8BB" => '&#28982;',
	"\xC8BC" => '&#29123;',
	"\xC8BD" => '&#20873;',
	"\xC8BE" => '&#26579;',
	"\xC8BF" => '&#29924;',
	"\xC8C0" => '&#22756;',
	"\xC8C1" => '&#25880;',
	"\xC8C2" => '&#22199;',
	"\xC8C3" => '&#35753;',
	"\xC8C4" => '&#39286;',
	"\xC8C5" => '&#25200;',
	"\xC8C6" => '&#32469;',
	"\xC8C7" => '&#24825;',
	"\xC8C8" => '&#28909;',
	"\xC8C9" => '&#22764;',
	"\xC8CA" => '&#20161;',
	"\xC8CB" => '&#20154;',
	"\xC8CC" => '&#24525;',
	"\xC8CD" => '&#38887;',
	"\xC8CE" => '&#20219;',
	"\xC8CF" => '&#35748;',
	"\xC8D0" => '&#20995;',
	"\xC8D1" => '&#22922;',
	"\xC8D2" => '&#32427;',
	"\xC8D3" => '&#25172;',
	"\xC8D4" => '&#20173;',
	"\xC8D5" => '&#26085;',
	"\xC8D6" => '&#25102;',
	"\xC8D7" => '&#33592;',
	"\xC8D8" => '&#33993;',
	"\xC8D9" => '&#33635;',
	"\xC8DA" => '&#34701;',
	"\xC8DB" => '&#29076;',
	"\xC8DC" => '&#28342;',
	"\xC8DD" => '&#23481;',
	"\xC8DE" => '&#32466;',
	"\xC8DF" => '&#20887;',
	"\xC8E0" => '&#25545;',
	"\xC8E1" => '&#26580;',
	"\xC8E2" => '&#32905;',
	"\xC8E3" => '&#33593;',
	"\xC8E4" => '&#34837;',
	"\xC8E5" => '&#20754;',
	"\xC8E6" => '&#23418;',
	"\xC8E7" => '&#22914;',
	"\xC8E8" => '&#36785;',
	"\xC8E9" => '&#20083;',
	"\xC8EA" => '&#27741;',
	"\xC8EB" => '&#20837;',
	"\xC8EC" => '&#35109;',
	"\xC8ED" => '&#36719;',
	"\xC8EE" => '&#38446;',
	"\xC8EF" => '&#34122;',
	"\xC8F0" => '&#29790;',
	"\xC8F1" => '&#38160;',
	"\xC8F2" => '&#38384;',
	"\xC8F3" => '&#28070;',
	"\xC8F4" => '&#33509;',
	"\xC8F5" => '&#24369;',
	"\xC8F6" => '&#25746;',
	"\xC8F7" => '&#27922;',
	"\xC8F8" => '&#33832;',
	"\xC8F9" => '&#33134;',
	"\xC8FA" => '&#40131;',
	"\xC8FB" => '&#22622;',
	"\xC8FC" => '&#36187;',
	"\xC8FD" => '&#19977;',
	"\xC8FE" => '&#21441;',
	"\xC9A1" => '&#20254;',
	"\xC9A2" => '&#25955;',
	"\xC9A3" => '&#26705;',
	"\xC9A4" => '&#21971;',
	"\xC9A5" => '&#20007;',
	"\xC9A6" => '&#25620;',
	"\xC9A7" => '&#39578;',
	"\xC9A8" => '&#25195;',
	"\xC9A9" => '&#23234;',
	"\xC9AA" => '&#29791;',
	"\xC9AB" => '&#33394;',
	"\xC9AC" => '&#28073;',
	"\xC9AD" => '&#26862;',
	"\xC9AE" => '&#20711;',
	"\xC9AF" => '&#33678;',
	"\xC9B0" => '&#30722;',
	"\xC9B1" => '&#26432;',
	"\xC9B2" => '&#21049;',
	"\xC9B3" => '&#27801;',
	"\xC9B4" => '&#32433;',
	"\xC9B5" => '&#20667;',
	"\xC9B6" => '&#21861;',
	"\xC9B7" => '&#29022;',
	"\xC9B8" => '&#31579;',
	"\xC9B9" => '&#26194;',
	"\xC9BA" => '&#29642;',
	"\xC9BB" => '&#33515;',
	"\xC9BC" => '&#26441;',
	"\xC9BD" => '&#23665;',
	"\xC9BE" => '&#21024;',
	"\xC9BF" => '&#29053;',
	"\xC9C0" => '&#34923;',
	"\xC9C1" => '&#38378;',
	"\xC9C2" => '&#38485;',
	"\xC9C3" => '&#25797;',
	"\xC9C4" => '&#36193;',
	"\xC9C5" => '&#33203;',
	"\xC9C6" => '&#21892;',
	"\xC9C7" => '&#27733;',
	"\xC9C8" => '&#25159;',
	"\xC9C9" => '&#32558;',
	"\xC9CA" => '&#22674;',
	"\xC9CB" => '&#20260;',
	"\xC9CC" => '&#21830;',
	"\xC9CD" => '&#36175;',
	"\xC9CE" => '&#26188;',
	"\xC9CF" => '&#19978;',
	"\xC9D0" => '&#23578;',
	"\xC9D1" => '&#35059;',
	"\xC9D2" => '&#26786;',
	"\xC9D3" => '&#25422;',
	"\xC9D4" => '&#31245;',
	"\xC9D5" => '&#28903;',
	"\xC9D6" => '&#33421;',
	"\xC9D7" => '&#21242;',
	"\xC9D8" => '&#38902;',
	"\xC9D9" => '&#23569;',
	"\xC9DA" => '&#21736;',
	"\xC9DB" => '&#37045;',
	"\xC9DC" => '&#32461;',
	"\xC9DD" => '&#22882;',
	"\xC9DE" => '&#36170;',
	"\xC9DF" => '&#34503;',
	"\xC9E0" => '&#33292;',
	"\xC9E1" => '&#33293;',
	"\xC9E2" => '&#36198;',
	"\xC9E3" => '&#25668;',
	"\xC9E4" => '&#23556;',
	"\xC9E5" => '&#24913;',
	"\xC9E6" => '&#28041;',
	"\xC9E7" => '&#31038;',
	"\xC9E8" => '&#35774;',
	"\xC9E9" => '&#30775;',
	"\xC9EA" => '&#30003;',
	"\xC9EB" => '&#21627;',
	"\xC9EC" => '&#20280;',
	"\xC9ED" => '&#36523;',
	"\xC9EE" => '&#28145;',
	"\xC9EF" => '&#23072;',
	"\xC9F0" => '&#32453;',
	"\xC9F1" => '&#31070;',
	"\xC9F2" => '&#27784;',
	"\xC9F3" => '&#23457;',
	"\xC9F4" => '&#23158;',
	"\xC9F5" => '&#29978;',
	"\xC9F6" => '&#32958;',
	"\xC9F7" => '&#24910;',
	"\xC9F8" => '&#28183;',
	"\xC9F9" => '&#22768;',
	"\xC9FA" => '&#29983;',
	"\xC9FB" => '&#29989;',
	"\xC9FC" => '&#29298;',
	"\xC9FD" => '&#21319;',
	"\xC9FE" => '&#32499;',
	"\xCAA1" => '&#30465;',
	"\xCAA2" => '&#30427;',
	"\xCAA3" => '&#21097;',
	"\xCAA4" => '&#32988;',
	"\xCAA5" => '&#22307;',
	"\xCAA6" => '&#24072;',
	"\xCAA7" => '&#22833;',
	"\xCAA8" => '&#29422;',
	"\xCAA9" => '&#26045;',
	"\xCAAA" => '&#28287;',
	"\xCAAB" => '&#35799;',
	"\xCAAC" => '&#23608;',
	"\xCAAD" => '&#34417;',
	"\xCAAE" => '&#21313;',
	"\xCAAF" => '&#30707;',
	"\xCAB0" => '&#25342;',
	"\xCAB1" => '&#26102;',
	"\xCAB2" => '&#20160;',
	"\xCAB3" => '&#39135;',
	"\xCAB4" => '&#34432;',
	"\xCAB5" => '&#23454;',
	"\xCAB6" => '&#35782;',
	"\xCAB7" => '&#21490;',
	"\xCAB8" => '&#30690;',
	"\xCAB9" => '&#20351;',
	"\xCABA" => '&#23630;',
	"\xCABB" => '&#39542;',
	"\xCABC" => '&#22987;',
	"\xCABD" => '&#24335;',
	"\xCABE" => '&#31034;',
	"\xCABF" => '&#22763;',
	"\xCAC0" => '&#19990;',
	"\xCAC1" => '&#26623;',
	"\xCAC2" => '&#20107;',
	"\xCAC3" => '&#25325;',
	"\xCAC4" => '&#35475;',
	"\xCAC5" => '&#36893;',
	"\xCAC6" => '&#21183;',
	"\xCAC7" => '&#26159;',
	"\xCAC8" => '&#21980;',
	"\xCAC9" => '&#22124;',
	"\xCACA" => '&#36866;',
	"\xCACB" => '&#20181;',
	"\xCACC" => '&#20365;',
	"\xCACD" => '&#37322;',
	"\xCACE" => '&#39280;',
	"\xCACF" => '&#27663;',
	"\xCAD0" => '&#24066;',
	"\xCAD1" => '&#24643;',
	"\xCAD2" => '&#23460;',
	"\xCAD3" => '&#35270;',
	"\xCAD4" => '&#35797;',
	"\xCAD5" => '&#25910;',
	"\xCAD6" => '&#25163;',
	"\xCAD7" => '&#39318;',
	"\xCAD8" => '&#23432;',
	"\xCAD9" => '&#23551;',
	"\xCADA" => '&#25480;',
	"\xCADB" => '&#21806;',
	"\xCADC" => '&#21463;',
	"\xCADD" => '&#30246;',
	"\xCADE" => '&#20861;',
	"\xCADF" => '&#34092;',
	"\xCAE0" => '&#26530;',
	"\xCAE1" => '&#26803;',
	"\xCAE2" => '&#27530;',
	"\xCAE3" => '&#25234;',
	"\xCAE4" => '&#36755;',
	"\xCAE5" => '&#21460;',
	"\xCAE6" => '&#33298;',
	"\xCAE7" => '&#28113;',
	"\xCAE8" => '&#30095;',
	"\xCAE9" => '&#20070;',
	"\xCAEA" => '&#36174;',
	"\xCAEB" => '&#23408;',
	"\xCAEC" => '&#29087;',
	"\xCAED" => '&#34223;',
	"\xCAEE" => '&#26257;',
	"\xCAEF" => '&#26329;',
	"\xCAF0" => '&#32626;',
	"\xCAF1" => '&#34560;',
	"\xCAF2" => '&#40653;',
	"\xCAF3" => '&#40736;',
	"\xCAF4" => '&#23646;',
	"\xCAF5" => '&#26415;',
	"\xCAF6" => '&#36848;',
	"\xCAF7" => '&#26641;',
	"\xCAF8" => '&#26463;',
	"\xCAF9" => '&#25101;',
	"\xCAFA" => '&#31446;',
	"\xCAFB" => '&#22661;',
	"\xCAFC" => '&#24246;',
	"\xCAFD" => '&#25968;',
	"\xCAFE" => '&#28465;',
	"\xCBA1" => '&#24661;',
	"\xCBA2" => '&#21047;',
	"\xCBA3" => '&#32781;',
	"\xCBA4" => '&#25684;',
	"\xCBA5" => '&#34928;',
	"\xCBA6" => '&#29993;',
	"\xCBA7" => '&#24069;',
	"\xCBA8" => '&#26643;',
	"\xCBA9" => '&#25332;',
	"\xCBAA" => '&#38684;',
	"\xCBAB" => '&#21452;',
	"\xCBAC" => '&#29245;',
	"\xCBAD" => '&#35841;',
	"\xCBAE" => '&#27700;',
	"\xCBAF" => '&#30561;',
	"\xCBB0" => '&#31246;',
	"\xCBB1" => '&#21550;',
	"\xCBB2" => '&#30636;',
	"\xCBB3" => '&#39034;',
	"\xCBB4" => '&#33308;',
	"\xCBB5" => '&#35828;',
	"\xCBB6" => '&#30805;',
	"\xCBB7" => '&#26388;',
	"\xCBB8" => '&#28865;',
	"\xCBB9" => '&#26031;',
	"\xCBBA" => '&#25749;',
	"\xCBBB" => '&#22070;',
	"\xCBBC" => '&#24605;',
	"\xCBBD" => '&#31169;',
	"\xCBBE" => '&#21496;',
	"\xCBBF" => '&#19997;',
	"\xCBC0" => '&#27515;',
	"\xCBC1" => '&#32902;',
	"\xCBC2" => '&#23546;',
	"\xCBC3" => '&#21987;',
	"\xCBC4" => '&#22235;',
	"\xCBC5" => '&#20282;',
	"\xCBC6" => '&#20284;',
	"\xCBC7" => '&#39282;',
	"\xCBC8" => '&#24051;',
	"\xCBC9" => '&#26494;',
	"\xCBCA" => '&#32824;',
	"\xCBCB" => '&#24578;',
	"\xCBCC" => '&#39042;',
	"\xCBCD" => '&#36865;',
	"\xCBCE" => '&#23435;',
	"\xCBCF" => '&#35772;',
	"\xCBD0" => '&#35829;',
	"\xCBD1" => '&#25628;',
	"\xCBD2" => '&#33368;',
	"\xCBD3" => '&#25822;',
	"\xCBD4" => '&#22013;',
	"\xCBD5" => '&#33487;',
	"\xCBD6" => '&#37221;',
	"\xCBD7" => '&#20439;',
	"\xCBD8" => '&#32032;',
	"\xCBD9" => '&#36895;',
	"\xCBDA" => '&#31903;',
	"\xCBDB" => '&#20723;',
	"\xCBDC" => '&#22609;',
	"\xCBDD" => '&#28335;',
	"\xCBDE" => '&#23487;',
	"\xCBDF" => '&#35785;',
	"\xCBE0" => '&#32899;',
	"\xCBE1" => '&#37240;',
	"\xCBE2" => '&#33948;',
	"\xCBE3" => '&#31639;',
	"\xCBE4" => '&#34429;',
	"\xCBE5" => '&#38539;',
	"\xCBE6" => '&#38543;',
	"\xCBE7" => '&#32485;',
	"\xCBE8" => '&#39635;',
	"\xCBE9" => '&#30862;',
	"\xCBEA" => '&#23681;',
	"\xCBEB" => '&#31319;',
	"\xCBEC" => '&#36930;',
	"\xCBED" => '&#38567;',
	"\xCBEE" => '&#31071;',
	"\xCBEF" => '&#23385;',
	"\xCBF0" => '&#25439;',
	"\xCBF1" => '&#31499;',
	"\xCBF2" => '&#34001;',
	"\xCBF3" => '&#26797;',
	"\xCBF4" => '&#21766;',
	"\xCBF5" => '&#32553;',
	"\xCBF6" => '&#29712;',
	"\xCBF7" => '&#32034;',
	"\xCBF8" => '&#38145;',
	"\xCBF9" => '&#25152;',
	"\xCBFA" => '&#22604;',
	"\xCBFB" => '&#20182;',
	"\xCBFC" => '&#23427;',
	"\xCBFD" => '&#22905;',
	"\xCBFE" => '&#22612;',
	"\xCCA1" => '&#29549;',
	"\xCCA2" => '&#25374;',
	"\xCCA3" => '&#36427;',
	"\xCCA4" => '&#36367;',
	"\xCCA5" => '&#32974;',
	"\xCCA6" => '&#33492;',
	"\xCCA7" => '&#25260;',
	"\xCCA8" => '&#21488;',
	"\xCCA9" => '&#27888;',
	"\xCCAA" => '&#37214;',
	"\xCCAB" => '&#22826;',
	"\xCCAC" => '&#24577;',
	"\xCCAD" => '&#27760;',
	"\xCCAE" => '&#22349;',
	"\xCCAF" => '&#25674;',
	"\xCCB0" => '&#36138;',
	"\xCCB1" => '&#30251;',
	"\xCCB2" => '&#28393;',
	"\xCCB3" => '&#22363;',
	"\xCCB4" => '&#27264;',
	"\xCCB5" => '&#30192;',
	"\xCCB6" => '&#28525;',
	"\xCCB7" => '&#35885;',
	"\xCCB8" => '&#35848;',
	"\xCCB9" => '&#22374;',
	"\xCCBA" => '&#27631;',
	"\xCCBB" => '&#34962;',
	"\xCCBC" => '&#30899;',
	"\xCCBD" => '&#25506;',
	"\xCCBE" => '&#21497;',
	"\xCCBF" => '&#28845;',
	"\xCCC0" => '&#27748;',
	"\xCCC1" => '&#22616;',
	"\xCCC2" => '&#25642;',
	"\xCCC3" => '&#22530;',
	"\xCCC4" => '&#26848;',
	"\xCCC5" => '&#33179;',
	"\xCCC6" => '&#21776;',
	"\xCCC7" => '&#31958;',
	"\xCCC8" => '&#20504;',
	"\xCCC9" => '&#36538;',
	"\xCCCA" => '&#28108;',
	"\xCCCB" => '&#36255;',
	"\xCCCC" => '&#28907;',
	"\xCCCD" => '&#25487;',
	"\xCCCE" => '&#28059;',
	"\xCCCF" => '&#28372;',
	"\xCCD0" => '&#32486;',
	"\xCCD1" => '&#33796;',
	"\xCCD2" => '&#26691;',
	"\xCCD3" => '&#36867;',
	"\xCCD4" => '&#28120;',
	"\xCCD5" => '&#38518;',
	"\xCCD6" => '&#35752;',
	"\xCCD7" => '&#22871;',
	"\xCCD8" => '&#29305;',
	"\xCCD9" => '&#34276;',
	"\xCCDA" => '&#33150;',
	"\xCCDB" => '&#30140;',
	"\xCCDC" => '&#35466;',
	"\xCCDD" => '&#26799;',
	"\xCCDE" => '&#21076;',
	"\xCCDF" => '&#36386;',
	"\xCCE0" => '&#38161;',
	"\xCCE1" => '&#25552;',
	"\xCCE2" => '&#39064;',
	"\xCCE3" => '&#36420;',
	"\xCCE4" => '&#21884;',
	"\xCCE5" => '&#20307;',
	"\xCCE6" => '&#26367;',
	"\xCCE7" => '&#22159;',
	"\xCCE8" => '&#24789;',
	"\xCCE9" => '&#28053;',
	"\xCCEA" => '&#21059;',
	"\xCCEB" => '&#23625;',
	"\xCCEC" => '&#22825;',
	"\xCCED" => '&#28155;',
	"\xCCEE" => '&#22635;',
	"\xCCEF" => '&#30000;',
	"\xCCF0" => '&#29980;',
	"\xCCF1" => '&#24684;',
	"\xCCF2" => '&#33300;',
	"\xCCF3" => '&#33094;',
	"\xCCF4" => '&#25361;',
	"\xCCF5" => '&#26465;',
	"\xCCF6" => '&#36834;',
	"\xCCF7" => '&#30522;',
	"\xCCF8" => '&#36339;',
	"\xCCF9" => '&#36148;',
	"\xCCFA" => '&#38081;',
	"\xCCFB" => '&#24086;',
	"\xCCFC" => '&#21381;',
	"\xCCFD" => '&#21548;',
	"\xCCFE" => '&#28867;',
	"\xCDA1" => '&#27712;',
	"\xCDA2" => '&#24311;',
	"\xCDA3" => '&#20572;',
	"\xCDA4" => '&#20141;',
	"\xCDA5" => '&#24237;',
	"\xCDA6" => '&#25402;',
	"\xCDA7" => '&#33351;',
	"\xCDA8" => '&#36890;',
	"\xCDA9" => '&#26704;',
	"\xCDAA" => '&#37230;',
	"\xCDAB" => '&#30643;',
	"\xCDAC" => '&#21516;',
	"\xCDAD" => '&#38108;',
	"\xCDAE" => '&#24420;',
	"\xCDAF" => '&#31461;',
	"\xCDB0" => '&#26742;',
	"\xCDB1" => '&#25413;',
	"\xCDB2" => '&#31570;',
	"\xCDB3" => '&#32479;',
	"\xCDB4" => '&#30171;',
	"\xCDB5" => '&#20599;',
	"\xCDB6" => '&#25237;',
	"\xCDB7" => '&#22836;',
	"\xCDB8" => '&#36879;',
	"\xCDB9" => '&#20984;',
	"\xCDBA" => '&#31171;',
	"\xCDBB" => '&#31361;',
	"\xCDBC" => '&#22270;',
	"\xCDBD" => '&#24466;',
	"\xCDBE" => '&#36884;',
	"\xCDBF" => '&#28034;',
	"\xCDC0" => '&#23648;',
	"\xCDC1" => '&#22303;',
	"\xCDC2" => '&#21520;',
	"\xCDC3" => '&#20820;',
	"\xCDC4" => '&#28237;',
	"\xCDC5" => '&#22242;',
	"\xCDC6" => '&#25512;',
	"\xCDC7" => '&#39059;',
	"\xCDC8" => '&#33151;',
	"\xCDC9" => '&#34581;',
	"\xCDCA" => '&#35114;',
	"\xCDCB" => '&#36864;',
	"\xCDCC" => '&#21534;',
	"\xCDCD" => '&#23663;',
	"\xCDCE" => '&#33216;',
	"\xCDCF" => '&#25302;',
	"\xCDD0" => '&#25176;',
	"\xCDD1" => '&#33073;',
	"\xCDD2" => '&#40501;',
	"\xCDD3" => '&#38464;',
	"\xCDD4" => '&#39534;',
	"\xCDD5" => '&#39548;',
	"\xCDD6" => '&#26925;',
	"\xCDD7" => '&#22949;',
	"\xCDD8" => '&#25299;',
	"\xCDD9" => '&#21822;',
	"\xCDDA" => '&#25366;',
	"\xCDDB" => '&#21703;',
	"\xCDDC" => '&#34521;',
	"\xCDDD" => '&#27964;',
	"\xCDDE" => '&#23043;',
	"\xCDDF" => '&#29926;',
	"\xCDE0" => '&#34972;',
	"\xCDE1" => '&#27498;',
	"\xCDE2" => '&#22806;',
	"\xCDE3" => '&#35916;',
	"\xCDE4" => '&#24367;',
	"\xCDE5" => '&#28286;',
	"\xCDE6" => '&#29609;',
	"\xCDE7" => '&#39037;',
	"\xCDE8" => '&#20024;',
	"\xCDE9" => '&#28919;',
	"\xCDEA" => '&#23436;',
	"\xCDEB" => '&#30871;',
	"\xCDEC" => '&#25405;',
	"\xCDED" => '&#26202;',
	"\xCDEE" => '&#30358;',
	"\xCDEF" => '&#24779;',
	"\xCDF0" => '&#23451;',
	"\xCDF1" => '&#23113;',
	"\xCDF2" => '&#19975;',
	"\xCDF3" => '&#33109;',
	"\xCDF4" => '&#27754;',
	"\xCDF5" => '&#29579;',
	"\xCDF6" => '&#20129;',
	"\xCDF7" => '&#26505;',
	"\xCDF8" => '&#32593;',
	"\xCDF9" => '&#24448;',
	"\xCDFA" => '&#26106;',
	"\xCDFB" => '&#26395;',
	"\xCDFC" => '&#24536;',
	"\xCDFD" => '&#22916;',
	"\xCDFE" => '&#23041;',
	"\xCEA1" => '&#24013;',
	"\xCEA2" => '&#24494;',
	"\xCEA3" => '&#21361;',
	"\xCEA4" => '&#38886;',
	"\xCEA5" => '&#36829;',
	"\xCEA6" => '&#26693;',
	"\xCEA7" => '&#22260;',
	"\xCEA8" => '&#21807;',
	"\xCEA9" => '&#24799;',
	"\xCEAA" => '&#20026;',
	"\xCEAB" => '&#28493;',
	"\xCEAC" => '&#32500;',
	"\xCEAD" => '&#33479;',
	"\xCEAE" => '&#33806;',
	"\xCEAF" => '&#22996;',
	"\xCEB0" => '&#20255;',
	"\xCEB1" => '&#20266;',
	"\xCEB2" => '&#23614;',
	"\xCEB3" => '&#32428;',
	"\xCEB4" => '&#26410;',
	"\xCEB5" => '&#34074;',
	"\xCEB6" => '&#21619;',
	"\xCEB7" => '&#30031;',
	"\xCEB8" => '&#32963;',
	"\xCEB9" => '&#21890;',
	"\xCEBA" => '&#39759;',
	"\xCEBB" => '&#20301;',
	"\xCEBC" => '&#28205;',
	"\xCEBD" => '&#35859;',
	"\xCEBE" => '&#23561;',
	"\xCEBF" => '&#24944;',
	"\xCEC0" => '&#21355;',
	"\xCEC1" => '&#30239;',
	"\xCEC2" => '&#28201;',
	"\xCEC3" => '&#34442;',
	"\xCEC4" => '&#25991;',
	"\xCEC5" => '&#38395;',
	"\xCEC6" => '&#32441;',
	"\xCEC7" => '&#21563;',
	"\xCEC8" => '&#31283;',
	"\xCEC9" => '&#32010;',
	"\xCECA" => '&#38382;',
	"\xCECB" => '&#21985;',
	"\xCECC" => '&#32705;',
	"\xCECD" => '&#29934;',
	"\xCECE" => '&#25373;',
	"\xCECF" => '&#34583;',
	"\xCED0" => '&#28065;',
	"\xCED1" => '&#31389;',
	"\xCED2" => '&#25105;',
	"\xCED3" => '&#26017;',
	"\xCED4" => '&#21351;',
	"\xCED5" => '&#25569;',
	"\xCED6" => '&#27779;',
	"\xCED7" => '&#24043;',
	"\xCED8" => '&#21596;',
	"\xCED9" => '&#38056;',
	"\xCEDA" => '&#20044;',
	"\xCEDB" => '&#27745;',
	"\xCEDC" => '&#35820;',
	"\xCEDD" => '&#23627;',
	"\xCEDE" => '&#26080;',
	"\xCEDF" => '&#33436;',
	"\xCEE0" => '&#26791;',
	"\xCEE1" => '&#21566;',
	"\xCEE2" => '&#21556;',
	"\xCEE3" => '&#27595;',
	"\xCEE4" => '&#27494;',
	"\xCEE5" => '&#20116;',
	"\xCEE6" => '&#25410;',
	"\xCEE7" => '&#21320;',
	"\xCEE8" => '&#33310;',
	"\xCEE9" => '&#20237;',
	"\xCEEA" => '&#20398;',
	"\xCEEB" => '&#22366;',
	"\xCEEC" => '&#25098;',
	"\xCEED" => '&#38654;',
	"\xCEEE" => '&#26212;',
	"\xCEEF" => '&#29289;',
	"\xCEF0" => '&#21247;',
	"\xCEF1" => '&#21153;',
	"\xCEF2" => '&#24735;',
	"\xCEF3" => '&#35823;',
	"\xCEF4" => '&#26132;',
	"\xCEF5" => '&#29081;',
	"\xCEF6" => '&#26512;',
	"\xCEF7" => '&#35199;',
	"\xCEF8" => '&#30802;',
	"\xCEF9" => '&#30717;',
	"\xCEFA" => '&#26224;',
	"\xCEFB" => '&#22075;',
	"\xCEFC" => '&#21560;',
	"\xCEFD" => '&#38177;',
	"\xCEFE" => '&#29306;',
	"\xCFA1" => '&#31232;',
	"\xCFA2" => '&#24687;',
	"\xCFA3" => '&#24076;',
	"\xCFA4" => '&#24713;',
	"\xCFA5" => '&#33181;',
	"\xCFA6" => '&#22805;',
	"\xCFA7" => '&#24796;',
	"\xCFA8" => '&#29060;',
	"\xCFA9" => '&#28911;',
	"\xCFAA" => '&#28330;',
	"\xCFAB" => '&#27728;',
	"\xCFAC" => '&#29312;',
	"\xCFAD" => '&#27268;',
	"\xCFAE" => '&#34989;',
	"\xCFAF" => '&#24109;',
	"\xCFB0" => '&#20064;',
	"\xCFB1" => '&#23219;',
	"\xCFB2" => '&#21916;',
	"\xCFB3" => '&#38115;',
	"\xCFB4" => '&#27927;',
	"\xCFB5" => '&#31995;',
	"\xCFB6" => '&#38553;',
	"\xCFB7" => '&#25103;',
	"\xCFB8" => '&#32454;',
	"\xCFB9" => '&#30606;',
	"\xCFBA" => '&#34430;',
	"\xCFBB" => '&#21283;',
	"\xCFBC" => '&#38686;',
	"\xCFBD" => '&#36758;',
	"\xCFBE" => '&#26247;',
	"\xCFBF" => '&#23777;',
	"\xCFC0" => '&#20384;',
	"\xCFC1" => '&#29421;',
	"\xCFC2" => '&#19979;',
	"\xCFC3" => '&#21414;',
	"\xCFC4" => '&#22799;',
	"\xCFC5" => '&#21523;',
	"\xCFC6" => '&#25472;',
	"\xCFC7" => '&#38184;',
	"\xCFC8" => '&#20808;',
	"\xCFC9" => '&#20185;',
	"\xCFCA" => '&#40092;',
	"\xCFCB" => '&#32420;',
	"\xCFCC" => '&#21688;',
	"\xCFCD" => '&#36132;',
	"\xCFCE" => '&#34900;',
	"\xCFCF" => '&#33335;',
	"\xCFD0" => '&#38386;',
	"\xCFD1" => '&#28046;',
	"\xCFD2" => '&#24358;',
	"\xCFD3" => '&#23244;',
	"\xCFD4" => '&#26174;',
	"\xCFD5" => '&#38505;',
	"\xCFD6" => '&#29616;',
	"\xCFD7" => '&#29486;',
	"\xCFD8" => '&#21439;',
	"\xCFD9" => '&#33146;',
	"\xCFDA" => '&#39301;',
	"\xCFDB" => '&#32673;',
	"\xCFDC" => '&#23466;',
	"\xCFDD" => '&#38519;',
	"\xCFDE" => '&#38480;',
	"\xCFDF" => '&#32447;',
	"\xCFE0" => '&#30456;',
	"\xCFE1" => '&#21410;',
	"\xCFE2" => '&#38262;',
	"\xCFE3" => '&#39321;',
	"\xCFE4" => '&#31665;',
	"\xCFE5" => '&#35140;',
	"\xCFE6" => '&#28248;',
	"\xCFE7" => '&#20065;',
	"\xCFE8" => '&#32724;',
	"\xCFE9" => '&#31077;',
	"\xCFEA" => '&#35814;',
	"\xCFEB" => '&#24819;',
	"\xCFEC" => '&#21709;',
	"\xCFED" => '&#20139;',
	"\xCFEE" => '&#39033;',
	"\xCFEF" => '&#24055;',
	"\xCFF0" => '&#27233;',
	"\xCFF1" => '&#20687;',
	"\xCFF2" => '&#21521;',
	"\xCFF3" => '&#35937;',
	"\xCFF4" => '&#33831;',
	"\xCFF5" => '&#30813;',
	"\xCFF6" => '&#38660;',
	"\xCFF7" => '&#21066;',
	"\xCFF8" => '&#21742;',
	"\xCFF9" => '&#22179;',
	"\xCFFA" => '&#38144;',
	"\xCFFB" => '&#28040;',
	"\xCFFC" => '&#23477;',
	"\xCFFD" => '&#28102;',
	"\xCFFE" => '&#26195;',
	"\xD0A1" => '&#23567;',
	"\xD0A2" => '&#23389;',
	"\xD0A3" => '&#26657;',
	"\xD0A4" => '&#32918;',
	"\xD0A5" => '&#21880;',
	"\xD0A6" => '&#31505;',
	"\xD0A7" => '&#25928;',
	"\xD0A8" => '&#26964;',
	"\xD0A9" => '&#20123;',
	"\xD0AA" => '&#27463;',
	"\xD0AB" => '&#34638;',
	"\xD0AC" => '&#38795;',
	"\xD0AD" => '&#21327;',
	"\xD0AE" => '&#25375;',
	"\xD0AF" => '&#25658;',
	"\xD0B0" => '&#37034;',
	"\xD0B1" => '&#26012;',
	"\xD0B2" => '&#32961;',
	"\xD0B3" => '&#35856;',
	"\xD0B4" => '&#20889;',
	"\xD0B5" => '&#26800;',
	"\xD0B6" => '&#21368;',
	"\xD0B7" => '&#34809;',
	"\xD0B8" => '&#25032;',
	"\xD0B9" => '&#27844;',
	"\xD0BA" => '&#27899;',
	"\xD0BB" => '&#35874;',
	"\xD0BC" => '&#23633;',
	"\xD0BD" => '&#34218;',
	"\xD0BE" => '&#33455;',
	"\xD0BF" => '&#38156;',
	"\xD0C0" => '&#27427;',
	"\xD0C1" => '&#36763;',
	"\xD0C2" => '&#26032;',
	"\xD0C3" => '&#24571;',
	"\xD0C4" => '&#24515;',
	"\xD0C5" => '&#20449;',
	"\xD0C6" => '&#34885;',
	"\xD0C7" => '&#26143;',
	"\xD0C8" => '&#33125;',
	"\xD0C9" => '&#29481;',
	"\xD0CA" => '&#24826;',
	"\xD0CB" => '&#20852;',
	"\xD0CC" => '&#21009;',
	"\xD0CD" => '&#22411;',
	"\xD0CE" => '&#24418;',
	"\xD0CF" => '&#37026;',
	"\xD0D0" => '&#34892;',
	"\xD0D1" => '&#37266;',
	"\xD0D2" => '&#24184;',
	"\xD0D3" => '&#26447;',
	"\xD0D4" => '&#24615;',
	"\xD0D5" => '&#22995;',
	"\xD0D6" => '&#20804;',
	"\xD0D7" => '&#20982;',
	"\xD0D8" => '&#33016;',
	"\xD0D9" => '&#21256;',
	"\xD0DA" => '&#27769;',
	"\xD0DB" => '&#38596;',
	"\xD0DC" => '&#29066;',
	"\xD0DD" => '&#20241;',
	"\xD0DE" => '&#20462;',
	"\xD0DF" => '&#32670;',
	"\xD0E0" => '&#26429;',
	"\xD0E1" => '&#21957;',
	"\xD0E2" => '&#38152;',
	"\xD0E3" => '&#31168;',
	"\xD0E4" => '&#34966;',
	"\xD0E5" => '&#32483;',
	"\xD0E6" => '&#22687;',
	"\xD0E7" => '&#25100;',
	"\xD0E8" => '&#38656;',
	"\xD0E9" => '&#34394;',
	"\xD0EA" => '&#22040;',
	"\xD0EB" => '&#39035;',
	"\xD0EC" => '&#24464;',
	"\xD0ED" => '&#35768;',
	"\xD0EE" => '&#33988;',
	"\xD0EF" => '&#37207;',
	"\xD0F0" => '&#21465;',
	"\xD0F1" => '&#26093;',
	"\xD0F2" => '&#24207;',
	"\xD0F3" => '&#30044;',
	"\xD0F4" => '&#24676;',
	"\xD0F5" => '&#32110;',
	"\xD0F6" => '&#23167;',
	"\xD0F7" => '&#32490;',
	"\xD0F8" => '&#32493;',
	"\xD0F9" => '&#36713;',
	"\xD0FA" => '&#21927;',
	"\xD0FB" => '&#23459;',
	"\xD0FC" => '&#24748;',
	"\xD0FD" => '&#26059;',
	"\xD0FE" => '&#29572;',
	"\xD1A1" => '&#36873;',
	"\xD1A2" => '&#30307;',
	"\xD1A3" => '&#30505;',
	"\xD1A4" => '&#32474;',
	"\xD1A5" => '&#38772;',
	"\xD1A6" => '&#34203;',
	"\xD1A7" => '&#23398;',
	"\xD1A8" => '&#31348;',
	"\xD1A9" => '&#38634;',
	"\xD1AA" => '&#34880;',
	"\xD1AB" => '&#21195;',
	"\xD1AC" => '&#29071;',
	"\xD1AD" => '&#24490;',
	"\xD1AE" => '&#26092;',
	"\xD1AF" => '&#35810;',
	"\xD1B0" => '&#23547;',
	"\xD1B1" => '&#39535;',
	"\xD1B2" => '&#24033;',
	"\xD1B3" => '&#27529;',
	"\xD1B4" => '&#27739;',
	"\xD1B5" => '&#35757;',
	"\xD1B6" => '&#35759;',
	"\xD1B7" => '&#36874;',
	"\xD1B8" => '&#36805;',
	"\xD1B9" => '&#21387;',
	"\xD1BA" => '&#25276;',
	"\xD1BB" => '&#40486;',
	"\xD1BC" => '&#40493;',
	"\xD1BD" => '&#21568;',
	"\xD1BE" => '&#20011;',
	"\xD1BF" => '&#33469;',
	"\xD1C0" => '&#29273;',
	"\xD1C1" => '&#34460;',
	"\xD1C2" => '&#23830;',
	"\xD1C3" => '&#34905;',
	"\xD1C4" => '&#28079;',
	"\xD1C5" => '&#38597;',
	"\xD1C6" => '&#21713;',
	"\xD1C7" => '&#20122;',
	"\xD1C8" => '&#35766;',
	"\xD1C9" => '&#28937;',
	"\xD1CA" => '&#21693;',
	"\xD1CB" => '&#38409;',
	"\xD1CC" => '&#28895;',
	"\xD1CD" => '&#28153;',
	"\xD1CE" => '&#30416;',
	"\xD1CF" => '&#20005;',
	"\xD1D0" => '&#30740;',
	"\xD1D1" => '&#34578;',
	"\xD1D2" => '&#23721;',
	"\xD1D3" => '&#24310;',
	"\xD1D4" => '&#35328;',
	"\xD1D5" => '&#39068;',
	"\xD1D6" => '&#38414;',
	"\xD1D7" => '&#28814;',
	"\xD1D8" => '&#27839;',
	"\xD1D9" => '&#22852;',
	"\xD1DA" => '&#25513;',
	"\xD1DB" => '&#30524;',
	"\xD1DC" => '&#34893;',
	"\xD1DD" => '&#28436;',
	"\xD1DE" => '&#33395;',
	"\xD1DF" => '&#22576;',
	"\xD1E0" => '&#29141;',
	"\xD1E1" => '&#21388;',
	"\xD1E2" => '&#30746;',
	"\xD1E3" => '&#38593;',
	"\xD1E4" => '&#21761;',
	"\xD1E5" => '&#24422;',
	"\xD1E6" => '&#28976;',
	"\xD1E7" => '&#23476;',
	"\xD1E8" => '&#35866;',
	"\xD1E9" => '&#39564;',
	"\xD1EA" => '&#27523;',
	"\xD1EB" => '&#22830;',
	"\xD1EC" => '&#40495;',
	"\xD1ED" => '&#31207;',
	"\xD1EE" => '&#26472;',
	"\xD1EF" => '&#25196;',
	"\xD1F0" => '&#20335;',
	"\xD1F1" => '&#30113;',
	"\xD1F2" => '&#32650;',
	"\xD1F3" => '&#27915;',
	"\xD1F4" => '&#38451;',
	"\xD1F5" => '&#27687;',
	"\xD1F6" => '&#20208;',
	"\xD1F7" => '&#30162;',
	"\xD1F8" => '&#20859;',
	"\xD1F9" => '&#26679;',
	"\xD1FA" => '&#28478;',
	"\xD1FB" => '&#36992;',
	"\xD1FC" => '&#33136;',
	"\xD1FD" => '&#22934;',
	"\xD1FE" => '&#29814;',
	"\xD2A1" => '&#25671;',
	"\xD2A2" => '&#23591;',
	"\xD2A3" => '&#36965;',
	"\xD2A4" => '&#31377;',
	"\xD2A5" => '&#35875;',
	"\xD2A6" => '&#23002;',
	"\xD2A7" => '&#21676;',
	"\xD2A8" => '&#33280;',
	"\xD2A9" => '&#33647;',
	"\xD2AA" => '&#35201;',
	"\xD2AB" => '&#32768;',
	"\xD2AC" => '&#26928;',
	"\xD2AD" => '&#22094;',
	"\xD2AE" => '&#32822;',
	"\xD2AF" => '&#29239;',
	"\xD2B0" => '&#37326;',
	"\xD2B1" => '&#20918;',
	"\xD2B2" => '&#20063;',
	"\xD2B3" => '&#39029;',
	"\xD2B4" => '&#25494;',
	"\xD2B5" => '&#19994;',
	"\xD2B6" => '&#21494;',
	"\xD2B7" => '&#26355;',
	"\xD2B8" => '&#33099;',
	"\xD2B9" => '&#22812;',
	"\xD2BA" => '&#28082;',
	"\xD2BB" => '&#19968;',
	"\xD2BC" => '&#22777;',
	"\xD2BD" => '&#21307;',
	"\xD2BE" => '&#25558;',
	"\xD2BF" => '&#38129;',
	"\xD2C0" => '&#20381;',
	"\xD2C1" => '&#20234;',
	"\xD2C2" => '&#34915;',
	"\xD2C3" => '&#39056;',
	"\xD2C4" => '&#22839;',
	"\xD2C5" => '&#36951;',
	"\xD2C6" => '&#31227;',
	"\xD2C7" => '&#20202;',
	"\xD2C8" => '&#33008;',
	"\xD2C9" => '&#30097;',
	"\xD2CA" => '&#27778;',
	"\xD2CB" => '&#23452;',
	"\xD2CC" => '&#23016;',
	"\xD2CD" => '&#24413;',
	"\xD2CE" => '&#26885;',
	"\xD2CF" => '&#34433;',
	"\xD2D0" => '&#20506;',
	"\xD2D1" => '&#24050;',
	"\xD2D2" => '&#20057;',
	"\xD2D3" => '&#30691;',
	"\xD2D4" => '&#20197;',
	"\xD2D5" => '&#33402;',
	"\xD2D6" => '&#25233;',
	"\xD2D7" => '&#26131;',
	"\xD2D8" => '&#37009;',
	"\xD2D9" => '&#23673;',
	"\xD2DA" => '&#20159;',
	"\xD2DB" => '&#24441;',
	"\xD2DC" => '&#33222;',
	"\xD2DD" => '&#36920;',
	"\xD2DE" => '&#32900;',
	"\xD2DF" => '&#30123;',
	"\xD2E0" => '&#20134;',
	"\xD2E1" => '&#35028;',
	"\xD2E2" => '&#24847;',
	"\xD2E3" => '&#27589;',
	"\xD2E4" => '&#24518;',
	"\xD2E5" => '&#20041;',
	"\xD2E6" => '&#30410;',
	"\xD2E7" => '&#28322;',
	"\xD2E8" => '&#35811;',
	"\xD2E9" => '&#35758;',
	"\xD2EA" => '&#35850;',
	"\xD2EB" => '&#35793;',
	"\xD2EC" => '&#24322;',
	"\xD2ED" => '&#32764;',
	"\xD2EE" => '&#32716;',
	"\xD2EF" => '&#32462;',
	"\xD2F0" => '&#33589;',
	"\xD2F1" => '&#33643;',
	"\xD2F2" => '&#22240;',
	"\xD2F3" => '&#27575;',
	"\xD2F4" => '&#38899;',
	"\xD2F5" => '&#38452;',
	"\xD2F6" => '&#23035;',
	"\xD2F7" => '&#21535;',
	"\xD2F8" => '&#38134;',
	"\xD2F9" => '&#28139;',
	"\xD2FA" => '&#23493;',
	"\xD2FB" => '&#39278;',
	"\xD2FC" => '&#23609;',
	"\xD2FD" => '&#24341;',
	"\xD2FE" => '&#38544;',
	"\xD3A1" => '&#21360;',
	"\xD3A2" => '&#33521;',
	"\xD3A3" => '&#27185;',
	"\xD3A4" => '&#23156;',
	"\xD3A5" => '&#40560;',
	"\xD3A6" => '&#24212;',
	"\xD3A7" => '&#32552;',
	"\xD3A8" => '&#33721;',
	"\xD3A9" => '&#33828;',
	"\xD3AA" => '&#33829;',
	"\xD3AB" => '&#33639;',
	"\xD3AC" => '&#34631;',
	"\xD3AD" => '&#36814;',
	"\xD3AE" => '&#36194;',
	"\xD3AF" => '&#30408;',
	"\xD3B0" => '&#24433;',
	"\xD3B1" => '&#39062;',
	"\xD3B2" => '&#30828;',
	"\xD3B3" => '&#26144;',
	"\xD3B4" => '&#21727;',
	"\xD3B5" => '&#25317;',
	"\xD3B6" => '&#20323;',
	"\xD3B7" => '&#33219;',
	"\xD3B8" => '&#30152;',
	"\xD3B9" => '&#24248;',
	"\xD3BA" => '&#38605;',
	"\xD3BB" => '&#36362;',
	"\xD3BC" => '&#34553;',
	"\xD3BD" => '&#21647;',
	"\xD3BE" => '&#27891;',
	"\xD3BF" => '&#28044;',
	"\xD3C0" => '&#27704;',
	"\xD3C1" => '&#24703;',
	"\xD3C2" => '&#21191;',
	"\xD3C3" => '&#29992;',
	"\xD3C4" => '&#24189;',
	"\xD3C5" => '&#20248;',
	"\xD3C6" => '&#24736;',
	"\xD3C7" => '&#24551;',
	"\xD3C8" => '&#23588;',
	"\xD3C9" => '&#30001;',
	"\xD3CA" => '&#37038;',
	"\xD3CB" => '&#38080;',
	"\xD3CC" => '&#29369;',
	"\xD3CD" => '&#27833;',
	"\xD3CE" => '&#28216;',
	"\xD3CF" => '&#37193;',
	"\xD3D0" => '&#26377;',
	"\xD3D1" => '&#21451;',
	"\xD3D2" => '&#21491;',
	"\xD3D3" => '&#20305;',
	"\xD3D4" => '&#37321;',
	"\xD3D5" => '&#35825;',
	"\xD3D6" => '&#21448;',
	"\xD3D7" => '&#24188;',
	"\xD3D8" => '&#36802;',
	"\xD3D9" => '&#28132;',
	"\xD3DA" => '&#20110;',
	"\xD3DB" => '&#30402;',
	"\xD3DC" => '&#27014;',
	"\xD3DD" => '&#34398;',
	"\xD3DE" => '&#24858;',
	"\xD3DF" => '&#33286;',
	"\xD3E0" => '&#20313;',
	"\xD3E1" => '&#20446;',
	"\xD3E2" => '&#36926;',
	"\xD3E3" => '&#40060;',
	"\xD3E4" => '&#24841;',
	"\xD3E5" => '&#28189;',
	"\xD3E6" => '&#28180;',
	"\xD3E7" => '&#38533;',
	"\xD3E8" => '&#20104;',
	"\xD3E9" => '&#23089;',
	"\xD3EA" => '&#38632;',
	"\xD3EB" => '&#19982;',
	"\xD3EC" => '&#23679;',
	"\xD3ED" => '&#31161;',
	"\xD3EE" => '&#23431;',
	"\xD3EF" => '&#35821;',
	"\xD3F0" => '&#32701;',
	"\xD3F1" => '&#29577;',
	"\xD3F2" => '&#22495;',
	"\xD3F3" => '&#33419;',
	"\xD3F4" => '&#37057;',
	"\xD3F5" => '&#21505;',
	"\xD3F6" => '&#36935;',
	"\xD3F7" => '&#21947;',
	"\xD3F8" => '&#23786;',
	"\xD3F9" => '&#24481;',
	"\xD3FA" => '&#24840;',
	"\xD3FB" => '&#27442;',
	"\xD3FC" => '&#29425;',
	"\xD3FD" => '&#32946;',
	"\xD3FE" => '&#35465;',
	"\xD4A1" => '&#28020;',
	"\xD4A2" => '&#23507;',
	"\xD4A3" => '&#35029;',
	"\xD4A4" => '&#39044;',
	"\xD4A5" => '&#35947;',
	"\xD4A6" => '&#39533;',
	"\xD4A7" => '&#40499;',
	"\xD4A8" => '&#28170;',
	"\xD4A9" => '&#20900;',
	"\xD4AA" => '&#20803;',
	"\xD4AB" => '&#22435;',
	"\xD4AC" => '&#34945;',
	"\xD4AD" => '&#21407;',
	"\xD4AE" => '&#25588;',
	"\xD4AF" => '&#36757;',
	"\xD4B0" => '&#22253;',
	"\xD4B1" => '&#21592;',
	"\xD4B2" => '&#22278;',
	"\xD4B3" => '&#29503;',
	"\xD4B4" => '&#28304;',
	"\xD4B5" => '&#32536;',
	"\xD4B6" => '&#36828;',
	"\xD4B7" => '&#33489;',
	"\xD4B8" => '&#24895;',
	"\xD4B9" => '&#24616;',
	"\xD4BA" => '&#38498;',
	"\xD4BB" => '&#26352;',
	"\xD4BC" => '&#32422;',
	"\xD4BD" => '&#36234;',
	"\xD4BE" => '&#36291;',
	"\xD4BF" => '&#38053;',
	"\xD4C0" => '&#23731;',
	"\xD4C1" => '&#31908;',
	"\xD4C2" => '&#26376;',
	"\xD4C3" => '&#24742;',
	"\xD4C4" => '&#38405;',
	"\xD4C5" => '&#32792;',
	"\xD4C6" => '&#20113;',
	"\xD4C7" => '&#37095;',
	"\xD4C8" => '&#21248;',
	"\xD4C9" => '&#38504;',
	"\xD4CA" => '&#20801;',
	"\xD4CB" => '&#36816;',
	"\xD4CC" => '&#34164;',
	"\xD4CD" => '&#37213;',
	"\xD4CE" => '&#26197;',
	"\xD4CF" => '&#38901;',
	"\xD4D0" => '&#23381;',
	"\xD4D1" => '&#21277;',
	"\xD4D2" => '&#30776;',
	"\xD4D3" => '&#26434;',
	"\xD4D4" => '&#26685;',
	"\xD4D5" => '&#21705;',
	"\xD4D6" => '&#28798;',
	"\xD4D7" => '&#23472;',
	"\xD4D8" => '&#36733;',
	"\xD4D9" => '&#20877;',
	"\xD4DA" => '&#22312;',
	"\xD4DB" => '&#21681;',
	"\xD4DC" => '&#25874;',
	"\xD4DD" => '&#26242;',
	"\xD4DE" => '&#36190;',
	"\xD4DF" => '&#36163;',
	"\xD4E0" => '&#33039;',
	"\xD4E1" => '&#33900;',
	"\xD4E2" => '&#36973;',
	"\xD4E3" => '&#31967;',
	"\xD4E4" => '&#20991;',
	"\xD4E5" => '&#34299;',
	"\xD4E6" => '&#26531;',
	"\xD4E7" => '&#26089;',
	"\xD4E8" => '&#28577;',
	"\xD4E9" => '&#34468;',
	"\xD4EA" => '&#36481;',
	"\xD4EB" => '&#22122;',
	"\xD4EC" => '&#36896;',
	"\xD4ED" => '&#30338;',
	"\xD4EE" => '&#28790;',
	"\xD4EF" => '&#29157;',
	"\xD4F0" => '&#36131;',
	"\xD4F1" => '&#25321;',
	"\xD4F2" => '&#21017;',
	"\xD4F3" => '&#27901;',
	"\xD4F4" => '&#36156;',
	"\xD4F5" => '&#24590;',
	"\xD4F6" => '&#22686;',
	"\xD4F7" => '&#24974;',
	"\xD4F8" => '&#26366;',
	"\xD4F9" => '&#36192;',
	"\xD4FA" => '&#25166;',
	"\xD4FB" => '&#21939;',
	"\xD4FC" => '&#28195;',
	"\xD4FD" => '&#26413;',
	"\xD4FE" => '&#36711;',
	"\xD5A1" => '&#38113;',
	"\xD5A2" => '&#38392;',
	"\xD5A3" => '&#30504;',
	"\xD5A4" => '&#26629;',
	"\xD5A5" => '&#27048;',
	"\xD5A6" => '&#21643;',
	"\xD5A7" => '&#20045;',
	"\xD5A8" => '&#28856;',
	"\xD5A9" => '&#35784;',
	"\xD5AA" => '&#25688;',
	"\xD5AB" => '&#25995;',
	"\xD5AC" => '&#23429;',
	"\xD5AD" => '&#31364;',
	"\xD5AE" => '&#20538;',
	"\xD5AF" => '&#23528;',
	"\xD5B0" => '&#30651;',
	"\xD5B1" => '&#27617;',
	"\xD5B2" => '&#35449;',
	"\xD5B3" => '&#31896;',
	"\xD5B4" => '&#27838;',
	"\xD5B5" => '&#30415;',
	"\xD5B6" => '&#26025;',
	"\xD5B7" => '&#36759;',
	"\xD5B8" => '&#23853;',
	"\xD5B9" => '&#23637;',
	"\xD5BA" => '&#34360;',
	"\xD5BB" => '&#26632;',
	"\xD5BC" => '&#21344;',
	"\xD5BD" => '&#25112;',
	"\xD5BE" => '&#31449;',
	"\xD5BF" => '&#28251;',
	"\xD5C0" => '&#32509;',
	"\xD5C1" => '&#27167;',
	"\xD5C2" => '&#31456;',
	"\xD5C3" => '&#24432;',
	"\xD5C4" => '&#28467;',
	"\xD5C5" => '&#24352;',
	"\xD5C6" => '&#25484;',
	"\xD5C7" => '&#28072;',
	"\xD5C8" => '&#26454;',
	"\xD5C9" => '&#19976;',
	"\xD5CA" => '&#24080;',
	"\xD5CB" => '&#36134;',
	"\xD5CC" => '&#20183;',
	"\xD5CD" => '&#32960;',
	"\xD5CE" => '&#30260;',
	"\xD5CF" => '&#38556;',
	"\xD5D0" => '&#25307;',
	"\xD5D1" => '&#26157;',
	"\xD5D2" => '&#25214;',
	"\xD5D3" => '&#27836;',
	"\xD5D4" => '&#36213;',
	"\xD5D5" => '&#29031;',
	"\xD5D6" => '&#32617;',
	"\xD5D7" => '&#20806;',
	"\xD5D8" => '&#32903;',
	"\xD5D9" => '&#21484;',
	"\xD5DA" => '&#36974;',
	"\xD5DB" => '&#25240;',
	"\xD5DC" => '&#21746;',
	"\xD5DD" => '&#34544;',
	"\xD5DE" => '&#36761;',
	"\xD5DF" => '&#32773;',
	"\xD5E0" => '&#38167;',
	"\xD5E1" => '&#34071;',
	"\xD5E2" => '&#36825;',
	"\xD5E3" => '&#27993;',
	"\xD5E4" => '&#29645;',
	"\xD5E5" => '&#26015;',
	"\xD5E6" => '&#30495;',
	"\xD5E7" => '&#29956;',
	"\xD5E8" => '&#30759;',
	"\xD5E9" => '&#33275;',
	"\xD5EA" => '&#36126;',
	"\xD5EB" => '&#38024;',
	"\xD5EC" => '&#20390;',
	"\xD5ED" => '&#26517;',
	"\xD5EE" => '&#30137;',
	"\xD5EF" => '&#35786;',
	"\xD5F0" => '&#38663;',
	"\xD5F1" => '&#25391;',
	"\xD5F2" => '&#38215;',
	"\xD5F3" => '&#38453;',
	"\xD5F4" => '&#33976;',
	"\xD5F5" => '&#25379;',
	"\xD5F6" => '&#30529;',
	"\xD5F7" => '&#24449;',
	"\xD5F8" => '&#29424;',
	"\xD5F9" => '&#20105;',
	"\xD5FA" => '&#24596;',
	"\xD5FB" => '&#25972;',
	"\xD5FC" => '&#25327;',
	"\xD5FD" => '&#27491;',
	"\xD5FE" => '&#25919;',
	"\xD6A1" => '&#24103;',
	"\xD6A2" => '&#30151;',
	"\xD6A3" => '&#37073;',
	"\xD6A4" => '&#35777;',
	"\xD6A5" => '&#33437;',
	"\xD6A6" => '&#26525;',
	"\xD6A7" => '&#25903;',
	"\xD6A8" => '&#21553;',
	"\xD6A9" => '&#34584;',
	"\xD6AA" => '&#30693;',
	"\xD6AB" => '&#32930;',
	"\xD6AC" => '&#33026;',
	"\xD6AD" => '&#27713;',
	"\xD6AE" => '&#20043;',
	"\xD6AF" => '&#32455;',
	"\xD6B0" => '&#32844;',
	"\xD6B1" => '&#30452;',
	"\xD6B2" => '&#26893;',
	"\xD6B3" => '&#27542;',
	"\xD6B4" => '&#25191;',
	"\xD6B5" => '&#20540;',
	"\xD6B6" => '&#20356;',
	"\xD6B7" => '&#22336;',
	"\xD6B8" => '&#25351;',
	"\xD6B9" => '&#27490;',
	"\xD6BA" => '&#36286;',
	"\xD6BB" => '&#21482;',
	"\xD6BC" => '&#26088;',
	"\xD6BD" => '&#32440;',
	"\xD6BE" => '&#24535;',
	"\xD6BF" => '&#25370;',
	"\xD6C0" => '&#25527;',
	"\xD6C1" => '&#33267;',
	"\xD6C2" => '&#33268;',
	"\xD6C3" => '&#32622;',
	"\xD6C4" => '&#24092;',
	"\xD6C5" => '&#23769;',
	"\xD6C6" => '&#21046;',
	"\xD6C7" => '&#26234;',
	"\xD6C8" => '&#31209;',
	"\xD6C9" => '&#31258;',
	"\xD6CA" => '&#36136;',
	"\xD6CB" => '&#28825;',
	"\xD6CC" => '&#30164;',
	"\xD6CD" => '&#28382;',
	"\xD6CE" => '&#27835;',
	"\xD6CF" => '&#31378;',
	"\xD6D0" => '&#20013;',
	"\xD6D1" => '&#30405;',
	"\xD6D2" => '&#24544;',
	"\xD6D3" => '&#38047;',
	"\xD6D4" => '&#34935;',
	"\xD6D5" => '&#32456;',
	"\xD6D6" => '&#31181;',
	"\xD6D7" => '&#32959;',
	"\xD6D8" => '&#37325;',
	"\xD6D9" => '&#20210;',
	"\xD6DA" => '&#20247;',
	"\xD6DB" => '&#33311;',
	"\xD6DC" => '&#21608;',
	"\xD6DD" => '&#24030;',
	"\xD6DE" => '&#27954;',
	"\xD6DF" => '&#35788;',
	"\xD6E0" => '&#31909;',
	"\xD6E1" => '&#36724;',
	"\xD6E2" => '&#32920;',
	"\xD6E3" => '&#24090;',
	"\xD6E4" => '&#21650;',
	"\xD6E5" => '&#30385;',
	"\xD6E6" => '&#23449;',
	"\xD6E7" => '&#26172;',
	"\xD6E8" => '&#39588;',
	"\xD6E9" => '&#29664;',
	"\xD6EA" => '&#26666;',
	"\xD6EB" => '&#34523;',
	"\xD6EC" => '&#26417;',
	"\xD6ED" => '&#29482;',
	"\xD6EE" => '&#35832;',
	"\xD6EF" => '&#35803;',
	"\xD6F0" => '&#36880;',
	"\xD6F1" => '&#31481;',
	"\xD6F2" => '&#28891;',
	"\xD6F3" => '&#29038;',
	"\xD6F4" => '&#25284;',
	"\xD6F5" => '&#30633;',
	"\xD6F6" => '&#22065;',
	"\xD6F7" => '&#20027;',
	"\xD6F8" => '&#33879;',
	"\xD6F9" => '&#26609;',
	"\xD6FA" => '&#21161;',
	"\xD6FB" => '&#34496;',
	"\xD6FC" => '&#36142;',
	"\xD6FD" => '&#38136;',
	"\xD6FE" => '&#31569;',
	"\xD7A1" => '&#20303;',
	"\xD7A2" => '&#27880;',
	"\xD7A3" => '&#31069;',
	"\xD7A4" => '&#39547;',
	"\xD7A5" => '&#25235;',
	"\xD7A6" => '&#29226;',
	"\xD7A7" => '&#25341;',
	"\xD7A8" => '&#19987;',
	"\xD7A9" => '&#30742;',
	"\xD7AA" => '&#36716;',
	"\xD7AB" => '&#25776;',
	"\xD7AC" => '&#36186;',
	"\xD7AD" => '&#31686;',
	"\xD7AE" => '&#26729;',
	"\xD7AF" => '&#24196;',
	"\xD7B0" => '&#35013;',
	"\xD7B1" => '&#22918;',
	"\xD7B2" => '&#25758;',
	"\xD7B3" => '&#22766;',
	"\xD7B4" => '&#29366;',
	"\xD7B5" => '&#26894;',
	"\xD7B6" => '&#38181;',
	"\xD7B7" => '&#36861;',
	"\xD7B8" => '&#36184;',
	"\xD7B9" => '&#22368;',
	"\xD7BA" => '&#32512;',
	"\xD7BB" => '&#35846;',
	"\xD7BC" => '&#20934;',
	"\xD7BD" => '&#25417;',
	"\xD7BE" => '&#25305;',
	"\xD7BF" => '&#21331;',
	"\xD7C0" => '&#26700;',
	"\xD7C1" => '&#29730;',
	"\xD7C2" => '&#33537;',
	"\xD7C3" => '&#37196;',
	"\xD7C4" => '&#21828;',
	"\xD7C5" => '&#30528;',
	"\xD7C6" => '&#28796;',
	"\xD7C7" => '&#27978;',
	"\xD7C8" => '&#20857;',
	"\xD7C9" => '&#21672;',
	"\xD7CA" => '&#36164;',
	"\xD7CB" => '&#23039;',
	"\xD7CC" => '&#28363;',
	"\xD7CD" => '&#28100;',
	"\xD7CE" => '&#23388;',
	"\xD7CF" => '&#32043;',
	"\xD7D0" => '&#20180;',
	"\xD7D1" => '&#31869;',
	"\xD7D2" => '&#28371;',
	"\xD7D3" => '&#23376;',
	"\xD7D4" => '&#33258;',
	"\xD7D5" => '&#28173;',
	"\xD7D6" => '&#23383;',
	"\xD7D7" => '&#39683;',
	"\xD7D8" => '&#26837;',
	"\xD7D9" => '&#36394;',
	"\xD7DA" => '&#23447;',
	"\xD7DB" => '&#32508;',
	"\xD7DC" => '&#24635;',
	"\xD7DD" => '&#32437;',
	"\xD7DE" => '&#37049;',
	"\xD7DF" => '&#36208;',
	"\xD7E0" => '&#22863;',
	"\xD7E1" => '&#25549;',
	"\xD7E2" => '&#31199;',
	"\xD7E3" => '&#36275;',
	"\xD7E4" => '&#21330;',
	"\xD7E5" => '&#26063;',
	"\xD7E6" => '&#31062;',
	"\xD7E7" => '&#35781;',
	"\xD7E8" => '&#38459;',
	"\xD7E9" => '&#32452;',
	"\xD7EA" => '&#38075;',
	"\xD7EB" => '&#32386;',
	"\xD7EC" => '&#22068;',
	"\xD7ED" => '&#37257;',
	"\xD7EE" => '&#26368;',
	"\xD7EF" => '&#32618;',
	"\xD7F0" => '&#23562;',
	"\xD7F1" => '&#36981;',
	"\xD7F2" => '&#26152;',
	"\xD7F3" => '&#24038;',
	"\xD7F4" => '&#20304;',
	"\xD7F5" => '&#26590;',
	"\xD7F6" => '&#20570;',
	"\xD7F7" => '&#20316;',
	"\xD7F8" => '&#22352;',
	"\xD7F9" => '&#24231;',
	"\xD8A1" => '&#20109;',
	"\xD8A2" => '&#19980;',
	"\xD8A3" => '&#20800;',
	"\xD8A4" => '&#19984;',
	"\xD8A5" => '&#24319;',
	"\xD8A6" => '&#21317;',
	"\xD8A7" => '&#19989;',
	"\xD8A8" => '&#20120;',
	"\xD8A9" => '&#19998;',
	"\xD8AA" => '&#39730;',
	"\xD8AB" => '&#23404;',
	"\xD8AC" => '&#22121;',
	"\xD8AD" => '&#20008;',
	"\xD8AE" => '&#31162;',
	"\xD8AF" => '&#20031;',
	"\xD8B0" => '&#21269;',
	"\xD8B1" => '&#20039;',
	"\xD8B2" => '&#22829;',
	"\xD8B3" => '&#29243;',
	"\xD8B4" => '&#21358;',
	"\xD8B5" => '&#27664;',
	"\xD8B6" => '&#22239;',
	"\xD8B7" => '&#32996;',
	"\xD8B8" => '&#39319;',
	"\xD8B9" => '&#27603;',
	"\xD8BA" => '&#30590;',
	"\xD8BB" => '&#40727;',
	"\xD8BC" => '&#20022;',
	"\xD8BD" => '&#20127;',
	"\xD8BE" => '&#40720;',
	"\xD8BF" => '&#20060;',
	"\xD8C0" => '&#20073;',
	"\xD8C1" => '&#20115;',
	"\xD8C2" => '&#33416;',
	"\xD8C3" => '&#23387;',
	"\xD8C4" => '&#21868;',
	"\xD8C5" => '&#22031;',
	"\xD8C6" => '&#20164;',
	"\xD8C7" => '&#21389;',
	"\xD8C8" => '&#21405;',
	"\xD8C9" => '&#21411;',
	"\xD8CA" => '&#21413;',
	"\xD8CB" => '&#21422;',
	"\xD8CC" => '&#38757;',
	"\xD8CD" => '&#36189;',
	"\xD8CE" => '&#21274;',
	"\xD8CF" => '&#21493;',
	"\xD8D0" => '&#21286;',
	"\xD8D1" => '&#21294;',
	"\xD8D2" => '&#21310;',
	"\xD8D3" => '&#36188;',
	"\xD8D4" => '&#21350;',
	"\xD8D5" => '&#21347;',
	"\xD8D6" => '&#20994;',
	"\xD8D7" => '&#21000;',
	"\xD8D8" => '&#21006;',
	"\xD8D9" => '&#21037;',
	"\xD8DA" => '&#21043;',
	"\xD8DB" => '&#21055;',
	"\xD8DC" => '&#21056;',
	"\xD8DD" => '&#21068;',
	"\xD8DE" => '&#21086;',
	"\xD8DF" => '&#21089;',
	"\xD8E0" => '&#21084;',
	"\xD8E1" => '&#33967;',
	"\xD8E2" => '&#21117;',
	"\xD8E3" => '&#21122;',
	"\xD8E4" => '&#21121;',
	"\xD8E5" => '&#21136;',
	"\xD8E6" => '&#21139;',
	"\xD8E7" => '&#20866;',
	"\xD8E8" => '&#32596;',
	"\xD8E9" => '&#20155;',
	"\xD8EA" => '&#20163;',
	"\xD8EB" => '&#20169;',
	"\xD8EC" => '&#20162;',
	"\xD8ED" => '&#20200;',
	"\xD8EE" => '&#20193;',
	"\xD8EF" => '&#20203;',
	"\xD8F0" => '&#20190;',
	"\xD8F1" => '&#20251;',
	"\xD8F2" => '&#20211;',
	"\xD8F3" => '&#20258;',
	"\xD8F4" => '&#20324;',
	"\xD8F5" => '&#20213;',
	"\xD8F6" => '&#20261;',
	"\xD8F7" => '&#20263;',
	"\xD8F8" => '&#20233;',
	"\xD8F9" => '&#20267;',
	"\xD8FA" => '&#20318;',
	"\xD8FB" => '&#20327;',
	"\xD8FC" => '&#25912;',
	"\xD8FD" => '&#20314;',
	"\xD8FE" => '&#20317;',
	"\xD9A1" => '&#20319;',
	"\xD9A2" => '&#20311;',
	"\xD9A3" => '&#20274;',
	"\xD9A4" => '&#20285;',
	"\xD9A5" => '&#20342;',
	"\xD9A6" => '&#20340;',
	"\xD9A7" => '&#20369;',
	"\xD9A8" => '&#20361;',
	"\xD9A9" => '&#20355;',
	"\xD9AA" => '&#20367;',
	"\xD9AB" => '&#20350;',
	"\xD9AC" => '&#20347;',
	"\xD9AD" => '&#20394;',
	"\xD9AE" => '&#20348;',
	"\xD9AF" => '&#20396;',
	"\xD9B0" => '&#20372;',
	"\xD9B1" => '&#20454;',
	"\xD9B2" => '&#20456;',
	"\xD9B3" => '&#20458;',
	"\xD9B4" => '&#20421;',
	"\xD9B5" => '&#20442;',
	"\xD9B6" => '&#20451;',
	"\xD9B7" => '&#20444;',
	"\xD9B8" => '&#20433;',
	"\xD9B9" => '&#20447;',
	"\xD9BA" => '&#20472;',
	"\xD9BB" => '&#20521;',
	"\xD9BC" => '&#20556;',
	"\xD9BD" => '&#20467;',
	"\xD9BE" => '&#20524;',
	"\xD9BF" => '&#20495;',
	"\xD9C0" => '&#20526;',
	"\xD9C1" => '&#20525;',
	"\xD9C2" => '&#20478;',
	"\xD9C3" => '&#20508;',
	"\xD9C4" => '&#20492;',
	"\xD9C5" => '&#20517;',
	"\xD9C6" => '&#20520;',
	"\xD9C7" => '&#20606;',
	"\xD9C8" => '&#20547;',
	"\xD9C9" => '&#20565;',
	"\xD9CA" => '&#20552;',
	"\xD9CB" => '&#20558;',
	"\xD9CC" => '&#20588;',
	"\xD9CD" => '&#20603;',
	"\xD9CE" => '&#20645;',
	"\xD9CF" => '&#20647;',
	"\xD9D0" => '&#20649;',
	"\xD9D1" => '&#20666;',
	"\xD9D2" => '&#20694;',
	"\xD9D3" => '&#20742;',
	"\xD9D4" => '&#20717;',
	"\xD9D5" => '&#20716;',
	"\xD9D6" => '&#20710;',
	"\xD9D7" => '&#20718;',
	"\xD9D8" => '&#20743;',
	"\xD9D9" => '&#20747;',
	"\xD9DA" => '&#20189;',
	"\xD9DB" => '&#27709;',
	"\xD9DC" => '&#20312;',
	"\xD9DD" => '&#20325;',
	"\xD9DE" => '&#20430;',
	"\xD9DF" => '&#40864;',
	"\xD9E0" => '&#27718;',
	"\xD9E1" => '&#31860;',
	"\xD9E2" => '&#20846;',
	"\xD9E3" => '&#24061;',
	"\xD9E4" => '&#40649;',
	"\xD9E5" => '&#39320;',
	"\xD9E6" => '&#20865;',
	"\xD9E7" => '&#22804;',
	"\xD9E8" => '&#21241;',
	"\xD9E9" => '&#21261;',
	"\xD9EA" => '&#35335;',
	"\xD9EB" => '&#21264;',
	"\xD9EC" => '&#20971;',
	"\xD9ED" => '&#22809;',
	"\xD9EE" => '&#20821;',
	"\xD9EF" => '&#20128;',
	"\xD9F0" => '&#20822;',
	"\xD9F1" => '&#20147;',
	"\xD9F2" => '&#34926;',
	"\xD9F3" => '&#34980;',
	"\xD9F4" => '&#20149;',
	"\xD9F5" => '&#33044;',
	"\xD9F6" => '&#35026;',
	"\xD9F7" => '&#31104;',
	"\xD9F8" => '&#23348;',
	"\xD9F9" => '&#34819;',
	"\xD9FA" => '&#32696;',
	"\xD9FB" => '&#20907;',
	"\xD9FC" => '&#20913;',
	"\xD9FD" => '&#20925;',
	"\xD9FE" => '&#20924;',
	"\xDAA1" => '&#20935;',
	"\xDAA2" => '&#20886;',
	"\xDAA3" => '&#20898;',
	"\xDAA4" => '&#20901;',
	"\xDAA5" => '&#35744;',
	"\xDAA6" => '&#35750;',
	"\xDAA7" => '&#35751;',
	"\xDAA8" => '&#35754;',
	"\xDAA9" => '&#35764;',
	"\xDAAA" => '&#35765;',
	"\xDAAB" => '&#35767;',
	"\xDAAC" => '&#35778;',
	"\xDAAD" => '&#35779;',
	"\xDAAE" => '&#35787;',
	"\xDAAF" => '&#35791;',
	"\xDAB0" => '&#35790;',
	"\xDAB1" => '&#35794;',
	"\xDAB2" => '&#35795;',
	"\xDAB3" => '&#35796;',
	"\xDAB4" => '&#35798;',
	"\xDAB5" => '&#35800;',
	"\xDAB6" => '&#35801;',
	"\xDAB7" => '&#35804;',
	"\xDAB8" => '&#35807;',
	"\xDAB9" => '&#35808;',
	"\xDABA" => '&#35812;',
	"\xDABB" => '&#35816;',
	"\xDABC" => '&#35817;',
	"\xDABD" => '&#35822;',
	"\xDABE" => '&#35824;',
	"\xDABF" => '&#35827;',
	"\xDAC0" => '&#35830;',
	"\xDAC1" => '&#35833;',
	"\xDAC2" => '&#35836;',
	"\xDAC3" => '&#35839;',
	"\xDAC4" => '&#35840;',
	"\xDAC5" => '&#35842;',
	"\xDAC6" => '&#35844;',
	"\xDAC7" => '&#35847;',
	"\xDAC8" => '&#35852;',
	"\xDAC9" => '&#35855;',
	"\xDACA" => '&#35857;',
	"\xDACB" => '&#35858;',
	"\xDACC" => '&#35860;',
	"\xDACD" => '&#35861;',
	"\xDACE" => '&#35862;',
	"\xDACF" => '&#35865;',
	"\xDAD0" => '&#35867;',
	"\xDAD1" => '&#35864;',
	"\xDAD2" => '&#35869;',
	"\xDAD3" => '&#35871;',
	"\xDAD4" => '&#35872;',
	"\xDAD5" => '&#35873;',
	"\xDAD6" => '&#35877;',
	"\xDAD7" => '&#35879;',
	"\xDAD8" => '&#35882;',
	"\xDAD9" => '&#35883;',
	"\xDADA" => '&#35886;',
	"\xDADB" => '&#35887;',
	"\xDADC" => '&#35890;',
	"\xDADD" => '&#35891;',
	"\xDADE" => '&#35893;',
	"\xDADF" => '&#35894;',
	"\xDAE0" => '&#21353;',
	"\xDAE1" => '&#21370;',
	"\xDAE2" => '&#38429;',
	"\xDAE3" => '&#38434;',
	"\xDAE4" => '&#38433;',
	"\xDAE5" => '&#38449;',
	"\xDAE6" => '&#38442;',
	"\xDAE7" => '&#38461;',
	"\xDAE8" => '&#38460;',
	"\xDAE9" => '&#38466;',
	"\xDAEA" => '&#38473;',
	"\xDAEB" => '&#38484;',
	"\xDAEC" => '&#38495;',
	"\xDAED" => '&#38503;',
	"\xDAEE" => '&#38508;',
	"\xDAEF" => '&#38514;',
	"\xDAF0" => '&#38516;',
	"\xDAF1" => '&#38536;',
	"\xDAF2" => '&#38541;',
	"\xDAF3" => '&#38551;',
	"\xDAF4" => '&#38576;',
	"\xDAF5" => '&#37015;',
	"\xDAF6" => '&#37019;',
	"\xDAF7" => '&#37021;',
	"\xDAF8" => '&#37017;',
	"\xDAF9" => '&#37036;',
	"\xDAFA" => '&#37025;',
	"\xDAFB" => '&#37044;',
	"\xDAFC" => '&#37043;',
	"\xDAFD" => '&#37046;',
	"\xDAFE" => '&#37050;',
	"\xDBA1" => '&#37048;',
	"\xDBA2" => '&#37040;',
	"\xDBA3" => '&#37071;',
	"\xDBA4" => '&#37061;',
	"\xDBA5" => '&#37054;',
	"\xDBA6" => '&#37072;',
	"\xDBA7" => '&#37060;',
	"\xDBA8" => '&#37063;',
	"\xDBA9" => '&#37075;',
	"\xDBAA" => '&#37094;',
	"\xDBAB" => '&#37090;',
	"\xDBAC" => '&#37084;',
	"\xDBAD" => '&#37079;',
	"\xDBAE" => '&#37083;',
	"\xDBAF" => '&#37099;',
	"\xDBB0" => '&#37103;',
	"\xDBB1" => '&#37118;',
	"\xDBB2" => '&#37124;',
	"\xDBB3" => '&#37154;',
	"\xDBB4" => '&#37150;',
	"\xDBB5" => '&#37155;',
	"\xDBB6" => '&#37169;',
	"\xDBB7" => '&#37167;',
	"\xDBB8" => '&#37177;',
	"\xDBB9" => '&#37187;',
	"\xDBBA" => '&#37190;',
	"\xDBBB" => '&#21005;',
	"\xDBBC" => '&#22850;',
	"\xDBBD" => '&#21154;',
	"\xDBBE" => '&#21164;',
	"\xDBBF" => '&#21165;',
	"\xDBC0" => '&#21182;',
	"\xDBC1" => '&#21759;',
	"\xDBC2" => '&#21200;',
	"\xDBC3" => '&#21206;',
	"\xDBC4" => '&#21232;',
	"\xDBC5" => '&#21471;',
	"\xDBC6" => '&#29166;',
	"\xDBC7" => '&#30669;',
	"\xDBC8" => '&#24308;',
	"\xDBC9" => '&#20981;',
	"\xDBCA" => '&#20988;',
	"\xDBCB" => '&#39727;',
	"\xDBCC" => '&#21430;',
	"\xDBCD" => '&#24321;',
	"\xDBCE" => '&#30042;',
	"\xDBCF" => '&#24047;',
	"\xDBD0" => '&#22348;',
	"\xDBD1" => '&#22441;',
	"\xDBD2" => '&#22433;',
	"\xDBD3" => '&#22654;',
	"\xDBD4" => '&#22716;',
	"\xDBD5" => '&#22725;',
	"\xDBD6" => '&#22737;',
	"\xDBD7" => '&#22313;',
	"\xDBD8" => '&#22316;',
	"\xDBD9" => '&#22314;',
	"\xDBDA" => '&#22323;',
	"\xDBDB" => '&#22329;',
	"\xDBDC" => '&#22318;',
	"\xDBDD" => '&#22319;',
	"\xDBDE" => '&#22364;',
	"\xDBDF" => '&#22331;',
	"\xDBE0" => '&#22338;',
	"\xDBE1" => '&#22377;',
	"\xDBE2" => '&#22405;',
	"\xDBE3" => '&#22379;',
	"\xDBE4" => '&#22406;',
	"\xDBE5" => '&#22396;',
	"\xDBE6" => '&#22395;',
	"\xDBE7" => '&#22376;',
	"\xDBE8" => '&#22381;',
	"\xDBE9" => '&#22390;',
	"\xDBEA" => '&#22387;',
	"\xDBEB" => '&#22445;',
	"\xDBEC" => '&#22436;',
	"\xDBED" => '&#22412;',
	"\xDBEE" => '&#22450;',
	"\xDBEF" => '&#22479;',
	"\xDBF0" => '&#22439;',
	"\xDBF1" => '&#22452;',
	"\xDBF2" => '&#22419;',
	"\xDBF3" => '&#22432;',
	"\xDBF4" => '&#22485;',
	"\xDBF5" => '&#22488;',
	"\xDBF6" => '&#22490;',
	"\xDBF7" => '&#22489;',
	"\xDBF8" => '&#22482;',
	"\xDBF9" => '&#22456;',
	"\xDBFA" => '&#22516;',
	"\xDBFB" => '&#22511;',
	"\xDBFC" => '&#22520;',
	"\xDBFD" => '&#22500;',
	"\xDBFE" => '&#22493;',
	"\xDCA1" => '&#22539;',
	"\xDCA2" => '&#22541;',
	"\xDCA3" => '&#22525;',
	"\xDCA4" => '&#22509;',
	"\xDCA5" => '&#22528;',
	"\xDCA6" => '&#22558;',
	"\xDCA7" => '&#22553;',
	"\xDCA8" => '&#22596;',
	"\xDCA9" => '&#22560;',
	"\xDCAA" => '&#22629;',
	"\xDCAB" => '&#22636;',
	"\xDCAC" => '&#22657;',
	"\xDCAD" => '&#22665;',
	"\xDCAE" => '&#22682;',
	"\xDCAF" => '&#22656;',
	"\xDCB0" => '&#39336;',
	"\xDCB1" => '&#40729;',
	"\xDCB2" => '&#25087;',
	"\xDCB3" => '&#33401;',
	"\xDCB4" => '&#33405;',
	"\xDCB5" => '&#33407;',
	"\xDCB6" => '&#33423;',
	"\xDCB7" => '&#33418;',
	"\xDCB8" => '&#33448;',
	"\xDCB9" => '&#33412;',
	"\xDCBA" => '&#33422;',
	"\xDCBB" => '&#33425;',
	"\xDCBC" => '&#33431;',
	"\xDCBD" => '&#33433;',
	"\xDCBE" => '&#33451;',
	"\xDCBF" => '&#33464;',
	"\xDCC0" => '&#33470;',
	"\xDCC1" => '&#33456;',
	"\xDCC2" => '&#33480;',
	"\xDCC3" => '&#33482;',
	"\xDCC4" => '&#33507;',
	"\xDCC5" => '&#33432;',
	"\xDCC6" => '&#33463;',
	"\xDCC7" => '&#33454;',
	"\xDCC8" => '&#33483;',
	"\xDCC9" => '&#33484;',
	"\xDCCA" => '&#33473;',
	"\xDCCB" => '&#33449;',
	"\xDCCC" => '&#33460;',
	"\xDCCD" => '&#33441;',
	"\xDCCE" => '&#33450;',
	"\xDCCF" => '&#33439;',
	"\xDCD0" => '&#33476;',
	"\xDCD1" => '&#33486;',
	"\xDCD2" => '&#33444;',
	"\xDCD3" => '&#33505;',
	"\xDCD4" => '&#33545;',
	"\xDCD5" => '&#33527;',
	"\xDCD6" => '&#33508;',
	"\xDCD7" => '&#33551;',
	"\xDCD8" => '&#33543;',
	"\xDCD9" => '&#33500;',
	"\xDCDA" => '&#33524;',
	"\xDCDB" => '&#33490;',
	"\xDCDC" => '&#33496;',
	"\xDCDD" => '&#33548;',
	"\xDCDE" => '&#33531;',
	"\xDCDF" => '&#33491;',
	"\xDCE0" => '&#33553;',
	"\xDCE1" => '&#33562;',
	"\xDCE2" => '&#33542;',
	"\xDCE3" => '&#33556;',
	"\xDCE4" => '&#33557;',
	"\xDCE5" => '&#33504;',
	"\xDCE6" => '&#33493;',
	"\xDCE7" => '&#33564;',
	"\xDCE8" => '&#33617;',
	"\xDCE9" => '&#33627;',
	"\xDCEA" => '&#33628;',
	"\xDCEB" => '&#33544;',
	"\xDCEC" => '&#33682;',
	"\xDCED" => '&#33596;',
	"\xDCEE" => '&#33588;',
	"\xDCEF" => '&#33585;',
	"\xDCF0" => '&#33691;',
	"\xDCF1" => '&#33630;',
	"\xDCF2" => '&#33583;',
	"\xDCF3" => '&#33615;',
	"\xDCF4" => '&#33607;',
	"\xDCF5" => '&#33603;',
	"\xDCF6" => '&#33631;',
	"\xDCF7" => '&#33600;',
	"\xDCF8" => '&#33559;',
	"\xDCF9" => '&#33632;',
	"\xDCFA" => '&#33581;',
	"\xDCFB" => '&#33594;',
	"\xDCFC" => '&#33587;',
	"\xDCFD" => '&#33638;',
	"\xDCFE" => '&#33637;',
	"\xDDA1" => '&#33640;',
	"\xDDA2" => '&#33563;',
	"\xDDA3" => '&#33641;',
	"\xDDA4" => '&#33644;',
	"\xDDA5" => '&#33642;',
	"\xDDA6" => '&#33645;',
	"\xDDA7" => '&#33646;',
	"\xDDA8" => '&#33712;',
	"\xDDA9" => '&#33656;',
	"\xDDAA" => '&#33715;',
	"\xDDAB" => '&#33716;',
	"\xDDAC" => '&#33696;',
	"\xDDAD" => '&#33706;',
	"\xDDAE" => '&#33683;',
	"\xDDAF" => '&#33692;',
	"\xDDB0" => '&#33669;',
	"\xDDB1" => '&#33660;',
	"\xDDB2" => '&#33718;',
	"\xDDB3" => '&#33705;',
	"\xDDB4" => '&#33661;',
	"\xDDB5" => '&#33720;',
	"\xDDB6" => '&#33659;',
	"\xDDB7" => '&#33688;',
	"\xDDB8" => '&#33694;',
	"\xDDB9" => '&#33704;',
	"\xDDBA" => '&#33722;',
	"\xDDBB" => '&#33724;',
	"\xDDBC" => '&#33729;',
	"\xDDBD" => '&#33793;',
	"\xDDBE" => '&#33765;',
	"\xDDBF" => '&#33752;',
	"\xDDC0" => '&#22535;',
	"\xDDC1" => '&#33816;',
	"\xDDC2" => '&#33803;',
	"\xDDC3" => '&#33757;',
	"\xDDC4" => '&#33789;',
	"\xDDC5" => '&#33750;',
	"\xDDC6" => '&#33820;',
	"\xDDC7" => '&#33848;',
	"\xDDC8" => '&#33809;',
	"\xDDC9" => '&#33798;',
	"\xDDCA" => '&#33748;',
	"\xDDCB" => '&#33759;',
	"\xDDCC" => '&#33807;',
	"\xDDCD" => '&#33795;',
	"\xDDCE" => '&#33784;',
	"\xDDCF" => '&#33785;',
	"\xDDD0" => '&#33770;',
	"\xDDD1" => '&#33733;',
	"\xDDD2" => '&#33728;',
	"\xDDD3" => '&#33830;',
	"\xDDD4" => '&#33776;',
	"\xDDD5" => '&#33761;',
	"\xDDD6" => '&#33884;',
	"\xDDD7" => '&#33873;',
	"\xDDD8" => '&#33882;',
	"\xDDD9" => '&#33881;',
	"\xDDDA" => '&#33907;',
	"\xDDDB" => '&#33927;',
	"\xDDDC" => '&#33928;',
	"\xDDDD" => '&#33914;',
	"\xDDDE" => '&#33929;',
	"\xDDDF" => '&#33912;',
	"\xDDE0" => '&#33852;',
	"\xDDE1" => '&#33862;',
	"\xDDE2" => '&#33897;',
	"\xDDE3" => '&#33910;',
	"\xDDE4" => '&#33932;',
	"\xDDE5" => '&#33934;',
	"\xDDE6" => '&#33841;',
	"\xDDE7" => '&#33901;',
	"\xDDE8" => '&#33985;',
	"\xDDE9" => '&#33997;',
	"\xDDEA" => '&#34000;',
	"\xDDEB" => '&#34022;',
	"\xDDEC" => '&#33981;',
	"\xDDED" => '&#34003;',
	"\xDDEE" => '&#33994;',
	"\xDDEF" => '&#33983;',
	"\xDDF0" => '&#33978;',
	"\xDDF1" => '&#34016;',
	"\xDDF2" => '&#33953;',
	"\xDDF3" => '&#33977;',
	"\xDDF4" => '&#33972;',
	"\xDDF5" => '&#33943;',
	"\xDDF6" => '&#34021;',
	"\xDDF7" => '&#34019;',
	"\xDDF8" => '&#34060;',
	"\xDDF9" => '&#29965;',
	"\xDDFA" => '&#34104;',
	"\xDDFB" => '&#34032;',
	"\xDDFC" => '&#34105;',
	"\xDDFD" => '&#34079;',
	"\xDDFE" => '&#34106;',
	"\xDEA1" => '&#34134;',
	"\xDEA2" => '&#34107;',
	"\xDEA3" => '&#34047;',
	"\xDEA4" => '&#34044;',
	"\xDEA5" => '&#34137;',
	"\xDEA6" => '&#34120;',
	"\xDEA7" => '&#34152;',
	"\xDEA8" => '&#34148;',
	"\xDEA9" => '&#34142;',
	"\xDEAA" => '&#34170;',
	"\xDEAB" => '&#30626;',
	"\xDEAC" => '&#34115;',
	"\xDEAD" => '&#34162;',
	"\xDEAE" => '&#34171;',
	"\xDEAF" => '&#34212;',
	"\xDEB0" => '&#34216;',
	"\xDEB1" => '&#34183;',
	"\xDEB2" => '&#34191;',
	"\xDEB3" => '&#34169;',
	"\xDEB4" => '&#34222;',
	"\xDEB5" => '&#34204;',
	"\xDEB6" => '&#34181;',
	"\xDEB7" => '&#34233;',
	"\xDEB8" => '&#34231;',
	"\xDEB9" => '&#34224;',
	"\xDEBA" => '&#34259;',
	"\xDEBB" => '&#34241;',
	"\xDEBC" => '&#34268;',
	"\xDEBD" => '&#34303;',
	"\xDEBE" => '&#34343;',
	"\xDEBF" => '&#34309;',
	"\xDEC0" => '&#34345;',
	"\xDEC1" => '&#34326;',
	"\xDEC2" => '&#34364;',
	"\xDEC3" => '&#24318;',
	"\xDEC4" => '&#24328;',
	"\xDEC5" => '&#22844;',
	"\xDEC6" => '&#22849;',
	"\xDEC7" => '&#32823;',
	"\xDEC8" => '&#22869;',
	"\xDEC9" => '&#22874;',
	"\xDECA" => '&#22872;',
	"\xDECB" => '&#21263;',
	"\xDECC" => '&#23586;',
	"\xDECD" => '&#23589;',
	"\xDECE" => '&#23596;',
	"\xDECF" => '&#23604;',
	"\xDED0" => '&#25164;',
	"\xDED1" => '&#25194;',
	"\xDED2" => '&#25247;',
	"\xDED3" => '&#25275;',
	"\xDED4" => '&#25290;',
	"\xDED5" => '&#25306;',
	"\xDED6" => '&#25303;',
	"\xDED7" => '&#25326;',
	"\xDED8" => '&#25378;',
	"\xDED9" => '&#25334;',
	"\xDEDA" => '&#25401;',
	"\xDEDB" => '&#25419;',
	"\xDEDC" => '&#25411;',
	"\xDEDD" => '&#25517;',
	"\xDEDE" => '&#25590;',
	"\xDEDF" => '&#25457;',
	"\xDEE0" => '&#25466;',
	"\xDEE1" => '&#25486;',
	"\xDEE2" => '&#25524;',
	"\xDEE3" => '&#25453;',
	"\xDEE4" => '&#25516;',
	"\xDEE5" => '&#25482;',
	"\xDEE6" => '&#25449;',
	"\xDEE7" => '&#25518;',
	"\xDEE8" => '&#25532;',
	"\xDEE9" => '&#25586;',
	"\xDEEA" => '&#25592;',
	"\xDEEB" => '&#25568;',
	"\xDEEC" => '&#25599;',
	"\xDEED" => '&#25540;',
	"\xDEEE" => '&#25566;',
	"\xDEEF" => '&#25550;',
	"\xDEF0" => '&#25682;',
	"\xDEF1" => '&#25542;',
	"\xDEF2" => '&#25534;',
	"\xDEF3" => '&#25669;',
	"\xDEF4" => '&#25665;',
	"\xDEF5" => '&#25611;',
	"\xDEF6" => '&#25627;',
	"\xDEF7" => '&#25632;',
	"\xDEF8" => '&#25612;',
	"\xDEF9" => '&#25638;',
	"\xDEFA" => '&#25633;',
	"\xDEFB" => '&#25694;',
	"\xDEFC" => '&#25732;',
	"\xDEFD" => '&#25709;',
	"\xDEFE" => '&#25750;',
	"\xDFA1" => '&#25722;',
	"\xDFA2" => '&#25783;',
	"\xDFA3" => '&#25784;',
	"\xDFA4" => '&#25753;',
	"\xDFA5" => '&#25786;',
	"\xDFA6" => '&#25792;',
	"\xDFA7" => '&#25808;',
	"\xDFA8" => '&#25815;',
	"\xDFA9" => '&#25828;',
	"\xDFAA" => '&#25826;',
	"\xDFAB" => '&#25865;',
	"\xDFAC" => '&#25893;',
	"\xDFAD" => '&#25902;',
	"\xDFAE" => '&#24331;',
	"\xDFAF" => '&#24530;',
	"\xDFB0" => '&#29977;',
	"\xDFB1" => '&#24337;',
	"\xDFB2" => '&#21343;',
	"\xDFB3" => '&#21489;',
	"\xDFB4" => '&#21501;',
	"\xDFB5" => '&#21481;',
	"\xDFB6" => '&#21480;',
	"\xDFB7" => '&#21499;',
	"\xDFB8" => '&#21522;',
	"\xDFB9" => '&#21526;',
	"\xDFBA" => '&#21510;',
	"\xDFBB" => '&#21579;',
	"\xDFBC" => '&#21586;',
	"\xDFBD" => '&#21587;',
	"\xDFBE" => '&#21588;',
	"\xDFBF" => '&#21590;',
	"\xDFC0" => '&#21571;',
	"\xDFC1" => '&#21537;',
	"\xDFC2" => '&#21591;',
	"\xDFC3" => '&#21593;',
	"\xDFC4" => '&#21539;',
	"\xDFC5" => '&#21554;',
	"\xDFC6" => '&#21634;',
	"\xDFC7" => '&#21652;',
	"\xDFC8" => '&#21623;',
	"\xDFC9" => '&#21617;',
	"\xDFCA" => '&#21604;',
	"\xDFCB" => '&#21658;',
	"\xDFCC" => '&#21659;',
	"\xDFCD" => '&#21636;',
	"\xDFCE" => '&#21622;',
	"\xDFCF" => '&#21606;',
	"\xDFD0" => '&#21661;',
	"\xDFD1" => '&#21712;',
	"\xDFD2" => '&#21677;',
	"\xDFD3" => '&#21698;',
	"\xDFD4" => '&#21684;',
	"\xDFD5" => '&#21714;',
	"\xDFD6" => '&#21671;',
	"\xDFD7" => '&#21670;',
	"\xDFD8" => '&#21715;',
	"\xDFD9" => '&#21716;',
	"\xDFDA" => '&#21618;',
	"\xDFDB" => '&#21667;',
	"\xDFDC" => '&#21717;',
	"\xDFDD" => '&#21691;',
	"\xDFDE" => '&#21695;',
	"\xDFDF" => '&#21708;',
	"\xDFE0" => '&#21721;',
	"\xDFE1" => '&#21722;',
	"\xDFE2" => '&#21724;',
	"\xDFE3" => '&#21673;',
	"\xDFE4" => '&#21674;',
	"\xDFE5" => '&#21668;',
	"\xDFE6" => '&#21725;',
	"\xDFE7" => '&#21711;',
	"\xDFE8" => '&#21726;',
	"\xDFE9" => '&#21787;',
	"\xDFEA" => '&#21735;',
	"\xDFEB" => '&#21792;',
	"\xDFEC" => '&#21757;',
	"\xDFED" => '&#21780;',
	"\xDFEE" => '&#21747;',
	"\xDFEF" => '&#21794;',
	"\xDFF0" => '&#21795;',
	"\xDFF1" => '&#21775;',
	"\xDFF2" => '&#21777;',
	"\xDFF3" => '&#21799;',
	"\xDFF4" => '&#21802;',
	"\xDFF5" => '&#21863;',
	"\xDFF6" => '&#21903;',
	"\xDFF7" => '&#21941;',
	"\xDFF8" => '&#21833;',
	"\xDFF9" => '&#21869;',
	"\xDFFA" => '&#21825;',
	"\xDFFB" => '&#21845;',
	"\xDFFC" => '&#21823;',
	"\xDFFD" => '&#21840;',
	"\xDFFE" => '&#21820;',
	"\xE0A1" => '&#21815;',
	"\xE0A2" => '&#21846;',
	"\xE0A3" => '&#21877;',
	"\xE0A4" => '&#21878;',
	"\xE0A5" => '&#21879;',
	"\xE0A6" => '&#21811;',
	"\xE0A7" => '&#21808;',
	"\xE0A8" => '&#21852;',
	"\xE0A9" => '&#21899;',
	"\xE0AA" => '&#21970;',
	"\xE0AB" => '&#21891;',
	"\xE0AC" => '&#21937;',
	"\xE0AD" => '&#21945;',
	"\xE0AE" => '&#21896;',
	"\xE0AF" => '&#21889;',
	"\xE0B0" => '&#21919;',
	"\xE0B1" => '&#21886;',
	"\xE0B2" => '&#21974;',
	"\xE0B3" => '&#21905;',
	"\xE0B4" => '&#21883;',
	"\xE0B5" => '&#21983;',
	"\xE0B6" => '&#21949;',
	"\xE0B7" => '&#21950;',
	"\xE0B8" => '&#21908;',
	"\xE0B9" => '&#21913;',
	"\xE0BA" => '&#21994;',
	"\xE0BB" => '&#22007;',
	"\xE0BC" => '&#21961;',
	"\xE0BD" => '&#22047;',
	"\xE0BE" => '&#21969;',
	"\xE0BF" => '&#21995;',
	"\xE0C0" => '&#21996;',
	"\xE0C1" => '&#21972;',
	"\xE0C2" => '&#21990;',
	"\xE0C3" => '&#21981;',
	"\xE0C4" => '&#21956;',
	"\xE0C5" => '&#21999;',
	"\xE0C6" => '&#21989;',
	"\xE0C7" => '&#22002;',
	"\xE0C8" => '&#22003;',
	"\xE0C9" => '&#21964;',
	"\xE0CA" => '&#21965;',
	"\xE0CB" => '&#21992;',
	"\xE0CC" => '&#22005;',
	"\xE0CD" => '&#21988;',
	"\xE0CE" => '&#36756;',
	"\xE0CF" => '&#22046;',
	"\xE0D0" => '&#22024;',
	"\xE0D1" => '&#22028;',
	"\xE0D2" => '&#22017;',
	"\xE0D3" => '&#22052;',
	"\xE0D4" => '&#22051;',
	"\xE0D5" => '&#22014;',
	"\xE0D6" => '&#22016;',
	"\xE0D7" => '&#22055;',
	"\xE0D8" => '&#22061;',
	"\xE0D9" => '&#22104;',
	"\xE0DA" => '&#22073;',
	"\xE0DB" => '&#22103;',
	"\xE0DC" => '&#22060;',
	"\xE0DD" => '&#22093;',
	"\xE0DE" => '&#22114;',
	"\xE0DF" => '&#22105;',
	"\xE0E0" => '&#22108;',
	"\xE0E1" => '&#22092;',
	"\xE0E2" => '&#22100;',
	"\xE0E3" => '&#22150;',
	"\xE0E4" => '&#22116;',
	"\xE0E5" => '&#22129;',
	"\xE0E6" => '&#22123;',
	"\xE0E7" => '&#22139;',
	"\xE0E8" => '&#22140;',
	"\xE0E9" => '&#22149;',
	"\xE0EA" => '&#22163;',
	"\xE0EB" => '&#22191;',
	"\xE0EC" => '&#22228;',
	"\xE0ED" => '&#22231;',
	"\xE0EE" => '&#22237;',
	"\xE0EF" => '&#22241;',
	"\xE0F0" => '&#22261;',
	"\xE0F1" => '&#22251;',
	"\xE0F2" => '&#22265;',
	"\xE0F3" => '&#22271;',
	"\xE0F4" => '&#22276;',
	"\xE0F5" => '&#22282;',
	"\xE0F6" => '&#22281;',
	"\xE0F7" => '&#22300;',
	"\xE0F8" => '&#24079;',
	"\xE0F9" => '&#24089;',
	"\xE0FA" => '&#24084;',
	"\xE0FB" => '&#24081;',
	"\xE0FC" => '&#24113;',
	"\xE0FD" => '&#24123;',
	"\xE0FE" => '&#24124;',
	"\xE1A1" => '&#24119;',
	"\xE1A2" => '&#24132;',
	"\xE1A3" => '&#24148;',
	"\xE1A4" => '&#24155;',
	"\xE1A5" => '&#24158;',
	"\xE1A6" => '&#24161;',
	"\xE1A7" => '&#23692;',
	"\xE1A8" => '&#23674;',
	"\xE1A9" => '&#23693;',
	"\xE1AA" => '&#23696;',
	"\xE1AB" => '&#23702;',
	"\xE1AC" => '&#23688;',
	"\xE1AD" => '&#23704;',
	"\xE1AE" => '&#23705;',
	"\xE1AF" => '&#23697;',
	"\xE1B0" => '&#23706;',
	"\xE1B1" => '&#23708;',
	"\xE1B2" => '&#23733;',
	"\xE1B3" => '&#23714;',
	"\xE1B4" => '&#23741;',
	"\xE1B5" => '&#23724;',
	"\xE1B6" => '&#23723;',
	"\xE1B7" => '&#23729;',
	"\xE1B8" => '&#23715;',
	"\xE1B9" => '&#23745;',
	"\xE1BA" => '&#23735;',
	"\xE1BB" => '&#23748;',
	"\xE1BC" => '&#23762;',
	"\xE1BD" => '&#23780;',
	"\xE1BE" => '&#23755;',
	"\xE1BF" => '&#23781;',
	"\xE1C0" => '&#23810;',
	"\xE1C1" => '&#23811;',
	"\xE1C2" => '&#23847;',
	"\xE1C3" => '&#23846;',
	"\xE1C4" => '&#23854;',
	"\xE1C5" => '&#23844;',
	"\xE1C6" => '&#23838;',
	"\xE1C7" => '&#23814;',
	"\xE1C8" => '&#23835;',
	"\xE1C9" => '&#23896;',
	"\xE1CA" => '&#23870;',
	"\xE1CB" => '&#23860;',
	"\xE1CC" => '&#23869;',
	"\xE1CD" => '&#23916;',
	"\xE1CE" => '&#23899;',
	"\xE1CF" => '&#23919;',
	"\xE1D0" => '&#23901;',
	"\xE1D1" => '&#23915;',
	"\xE1D2" => '&#23883;',
	"\xE1D3" => '&#23882;',
	"\xE1D4" => '&#23913;',
	"\xE1D5" => '&#23924;',
	"\xE1D6" => '&#23938;',
	"\xE1D7" => '&#23961;',
	"\xE1D8" => '&#23965;',
	"\xE1D9" => '&#35955;',
	"\xE1DA" => '&#23991;',
	"\xE1DB" => '&#24005;',
	"\xE1DC" => '&#24435;',
	"\xE1DD" => '&#24439;',
	"\xE1DE" => '&#24450;',
	"\xE1DF" => '&#24455;',
	"\xE1E0" => '&#24457;',
	"\xE1E1" => '&#24460;',
	"\xE1E2" => '&#24469;',
	"\xE1E3" => '&#24473;',
	"\xE1E4" => '&#24476;',
	"\xE1E5" => '&#24488;',
	"\xE1E6" => '&#24493;',
	"\xE1E7" => '&#24501;',
	"\xE1E8" => '&#24508;',
	"\xE1E9" => '&#34914;',
	"\xE1EA" => '&#24417;',
	"\xE1EB" => '&#29357;',
	"\xE1EC" => '&#29360;',
	"\xE1ED" => '&#29364;',
	"\xE1EE" => '&#29367;',
	"\xE1EF" => '&#29368;',
	"\xE1F0" => '&#29379;',
	"\xE1F1" => '&#29377;',
	"\xE1F2" => '&#29390;',
	"\xE1F3" => '&#29389;',
	"\xE1F4" => '&#29394;',
	"\xE1F5" => '&#29416;',
	"\xE1F6" => '&#29423;',
	"\xE1F7" => '&#29417;',
	"\xE1F8" => '&#29426;',
	"\xE1F9" => '&#29428;',
	"\xE1FA" => '&#29431;',
	"\xE1FB" => '&#29441;',
	"\xE1FC" => '&#29427;',
	"\xE1FD" => '&#29443;',
	"\xE1FE" => '&#29434;',
	"\xE2A1" => '&#29435;',
	"\xE2A2" => '&#29463;',
	"\xE2A3" => '&#29459;',
	"\xE2A4" => '&#29473;',
	"\xE2A5" => '&#29450;',
	"\xE2A6" => '&#29470;',
	"\xE2A7" => '&#29469;',
	"\xE2A8" => '&#29461;',
	"\xE2A9" => '&#29474;',
	"\xE2AA" => '&#29497;',
	"\xE2AB" => '&#29477;',
	"\xE2AC" => '&#29484;',
	"\xE2AD" => '&#29496;',
	"\xE2AE" => '&#29489;',
	"\xE2AF" => '&#29520;',
	"\xE2B0" => '&#29517;',
	"\xE2B1" => '&#29527;',
	"\xE2B2" => '&#29536;',
	"\xE2B3" => '&#29548;',
	"\xE2B4" => '&#29551;',
	"\xE2B5" => '&#29566;',
	"\xE2B6" => '&#33307;',
	"\xE2B7" => '&#22821;',
	"\xE2B8" => '&#39143;',
	"\xE2B9" => '&#22820;',
	"\xE2BA" => '&#22786;',
	"\xE2BB" => '&#39267;',
	"\xE2BC" => '&#39271;',
	"\xE2BD" => '&#39272;',
	"\xE2BE" => '&#39273;',
	"\xE2BF" => '&#39274;',
	"\xE2C0" => '&#39275;',
	"\xE2C1" => '&#39276;',
	"\xE2C2" => '&#39284;',
	"\xE2C3" => '&#39287;',
	"\xE2C4" => '&#39293;',
	"\xE2C5" => '&#39296;',
	"\xE2C6" => '&#39300;',
	"\xE2C7" => '&#39303;',
	"\xE2C8" => '&#39306;',
	"\xE2C9" => '&#39309;',
	"\xE2CA" => '&#39312;',
	"\xE2CB" => '&#39313;',
	"\xE2CC" => '&#39315;',
	"\xE2CD" => '&#39316;',
	"\xE2CE" => '&#39317;',
	"\xE2CF" => '&#24192;',
	"\xE2D0" => '&#24209;',
	"\xE2D1" => '&#24203;',
	"\xE2D2" => '&#24214;',
	"\xE2D3" => '&#24229;',
	"\xE2D4" => '&#24224;',
	"\xE2D5" => '&#24249;',
	"\xE2D6" => '&#24245;',
	"\xE2D7" => '&#24254;',
	"\xE2D8" => '&#24243;',
	"\xE2D9" => '&#36179;',
	"\xE2DA" => '&#24274;',
	"\xE2DB" => '&#24273;',
	"\xE2DC" => '&#24283;',
	"\xE2DD" => '&#24296;',
	"\xE2DE" => '&#24298;',
	"\xE2DF" => '&#33210;',
	"\xE2E0" => '&#24516;',
	"\xE2E1" => '&#24521;',
	"\xE2E2" => '&#24534;',
	"\xE2E3" => '&#24527;',
	"\xE2E4" => '&#24579;',
	"\xE2E5" => '&#24558;',
	"\xE2E6" => '&#24580;',
	"\xE2E7" => '&#24545;',
	"\xE2E8" => '&#24548;',
	"\xE2E9" => '&#24574;',
	"\xE2EA" => '&#24581;',
	"\xE2EB" => '&#24582;',
	"\xE2EC" => '&#24554;',
	"\xE2ED" => '&#24557;',
	"\xE2EE" => '&#24568;',
	"\xE2EF" => '&#24601;',
	"\xE2F0" => '&#24629;',
	"\xE2F1" => '&#24614;',
	"\xE2F2" => '&#24603;',
	"\xE2F3" => '&#24591;',
	"\xE2F4" => '&#24589;',
	"\xE2F5" => '&#24617;',
	"\xE2F6" => '&#24619;',
	"\xE2F7" => '&#24586;',
	"\xE2F8" => '&#24639;',
	"\xE2F9" => '&#24609;',
	"\xE2FA" => '&#24696;',
	"\xE2FB" => '&#24697;',
	"\xE2FC" => '&#24699;',
	"\xE2FD" => '&#24698;',
	"\xE2FE" => '&#24642;',
	"\xE3A1" => '&#24682;',
	"\xE3A2" => '&#24701;',
	"\xE3A3" => '&#24726;',
	"\xE3A4" => '&#24730;',
	"\xE3A5" => '&#24749;',
	"\xE3A6" => '&#24733;',
	"\xE3A7" => '&#24707;',
	"\xE3A8" => '&#24722;',
	"\xE3A9" => '&#24716;',
	"\xE3AA" => '&#24731;',
	"\xE3AB" => '&#24812;',
	"\xE3AC" => '&#24763;',
	"\xE3AD" => '&#24753;',
	"\xE3AE" => '&#24797;',
	"\xE3AF" => '&#24792;',
	"\xE3B0" => '&#24774;',
	"\xE3B1" => '&#24794;',
	"\xE3B2" => '&#24756;',
	"\xE3B3" => '&#24864;',
	"\xE3B4" => '&#24870;',
	"\xE3B5" => '&#24853;',
	"\xE3B6" => '&#24867;',
	"\xE3B7" => '&#24820;',
	"\xE3B8" => '&#24832;',
	"\xE3B9" => '&#24846;',
	"\xE3BA" => '&#24875;',
	"\xE3BB" => '&#24906;',
	"\xE3BC" => '&#24949;',
	"\xE3BD" => '&#25004;',
	"\xE3BE" => '&#24980;',
	"\xE3BF" => '&#24999;',
	"\xE3C0" => '&#25015;',
	"\xE3C1" => '&#25044;',
	"\xE3C2" => '&#25077;',
	"\xE3C3" => '&#24541;',
	"\xE3C4" => '&#38579;',
	"\xE3C5" => '&#38377;',
	"\xE3C6" => '&#38379;',
	"\xE3C7" => '&#38385;',
	"\xE3C8" => '&#38387;',
	"\xE3C9" => '&#38389;',
	"\xE3CA" => '&#38390;',
	"\xE3CB" => '&#38396;',
	"\xE3CC" => '&#38398;',
	"\xE3CD" => '&#38403;',
	"\xE3CE" => '&#38404;',
	"\xE3CF" => '&#38406;',
	"\xE3D0" => '&#38408;',
	"\xE3D1" => '&#38410;',
	"\xE3D2" => '&#38411;',
	"\xE3D3" => '&#38412;',
	"\xE3D4" => '&#38413;',
	"\xE3D5" => '&#38415;',
	"\xE3D6" => '&#38418;',
	"\xE3D7" => '&#38421;',
	"\xE3D8" => '&#38422;',
	"\xE3D9" => '&#38423;',
	"\xE3DA" => '&#38425;',
	"\xE3DB" => '&#38426;',
	"\xE3DC" => '&#20012;',
	"\xE3DD" => '&#29247;',
	"\xE3DE" => '&#25109;',
	"\xE3DF" => '&#27701;',
	"\xE3E0" => '&#27732;',
	"\xE3E1" => '&#27740;',
	"\xE3E2" => '&#27722;',
	"\xE3E3" => '&#27811;',
	"\xE3E4" => '&#27781;',
	"\xE3E5" => '&#27792;',
	"\xE3E6" => '&#27796;',
	"\xE3E7" => '&#27788;',
	"\xE3E8" => '&#27752;',
	"\xE3E9" => '&#27753;',
	"\xE3EA" => '&#27764;',
	"\xE3EB" => '&#27766;',
	"\xE3EC" => '&#27782;',
	"\xE3ED" => '&#27817;',
	"\xE3EE" => '&#27856;',
	"\xE3EF" => '&#27860;',
	"\xE3F0" => '&#27821;',
	"\xE3F1" => '&#27895;',
	"\xE3F2" => '&#27896;',
	"\xE3F3" => '&#27889;',
	"\xE3F4" => '&#27863;',
	"\xE3F5" => '&#27826;',
	"\xE3F6" => '&#27872;',
	"\xE3F7" => '&#27862;',
	"\xE3F8" => '&#27898;',
	"\xE3F9" => '&#27883;',
	"\xE3FA" => '&#27886;',
	"\xE3FB" => '&#27825;',
	"\xE3FC" => '&#27859;',
	"\xE3FD" => '&#27887;',
	"\xE3FE" => '&#27902;',
	"\xE4A1" => '&#27961;',
	"\xE4A2" => '&#27943;',
	"\xE4A3" => '&#27916;',
	"\xE4A4" => '&#27971;',
	"\xE4A5" => '&#27976;',
	"\xE4A6" => '&#27911;',
	"\xE4A7" => '&#27908;',
	"\xE4A8" => '&#27929;',
	"\xE4A9" => '&#27918;',
	"\xE4AA" => '&#27947;',
	"\xE4AB" => '&#27981;',
	"\xE4AC" => '&#27950;',
	"\xE4AD" => '&#27957;',
	"\xE4AE" => '&#27930;',
	"\xE4AF" => '&#27983;',
	"\xE4B0" => '&#27986;',
	"\xE4B1" => '&#27988;',
	"\xE4B2" => '&#27955;',
	"\xE4B3" => '&#28049;',
	"\xE4B4" => '&#28015;',
	"\xE4B5" => '&#28062;',
	"\xE4B6" => '&#28064;',
	"\xE4B7" => '&#27998;',
	"\xE4B8" => '&#28051;',
	"\xE4B9" => '&#28052;',
	"\xE4BA" => '&#27996;',
	"\xE4BB" => '&#28000;',
	"\xE4BC" => '&#28028;',
	"\xE4BD" => '&#28003;',
	"\xE4BE" => '&#28186;',
	"\xE4BF" => '&#28103;',
	"\xE4C0" => '&#28101;',
	"\xE4C1" => '&#28126;',
	"\xE4C2" => '&#28174;',
	"\xE4C3" => '&#28095;',
	"\xE4C4" => '&#28128;',
	"\xE4C5" => '&#28177;',
	"\xE4C6" => '&#28134;',
	"\xE4C7" => '&#28125;',
	"\xE4C8" => '&#28121;',
	"\xE4C9" => '&#28182;',
	"\xE4CA" => '&#28075;',
	"\xE4CB" => '&#28172;',
	"\xE4CC" => '&#28078;',
	"\xE4CD" => '&#28203;',
	"\xE4CE" => '&#28270;',
	"\xE4CF" => '&#28238;',
	"\xE4D0" => '&#28267;',
	"\xE4D1" => '&#28338;',
	"\xE4D2" => '&#28255;',
	"\xE4D3" => '&#28294;',
	"\xE4D4" => '&#28243;',
	"\xE4D5" => '&#28244;',
	"\xE4D6" => '&#28210;',
	"\xE4D7" => '&#28197;',
	"\xE4D8" => '&#28228;',
	"\xE4D9" => '&#28383;',
	"\xE4DA" => '&#28337;',
	"\xE4DB" => '&#28312;',
	"\xE4DC" => '&#28384;',
	"\xE4DD" => '&#28461;',
	"\xE4DE" => '&#28386;',
	"\xE4DF" => '&#28325;',
	"\xE4E0" => '&#28327;',
	"\xE4E1" => '&#28349;',
	"\xE4E2" => '&#28347;',
	"\xE4E3" => '&#28343;',
	"\xE4E4" => '&#28375;',
	"\xE4E5" => '&#28340;',
	"\xE4E6" => '&#28367;',
	"\xE4E7" => '&#28303;',
	"\xE4E8" => '&#28354;',
	"\xE4E9" => '&#28319;',
	"\xE4EA" => '&#28514;',
	"\xE4EB" => '&#28486;',
	"\xE4EC" => '&#28487;',
	"\xE4ED" => '&#28452;',
	"\xE4EE" => '&#28437;',
	"\xE4EF" => '&#28409;',
	"\xE4F0" => '&#28463;',
	"\xE4F1" => '&#28470;',
	"\xE4F2" => '&#28491;',
	"\xE4F3" => '&#28532;',
	"\xE4F4" => '&#28458;',
	"\xE4F5" => '&#28425;',
	"\xE4F6" => '&#28457;',
	"\xE4F7" => '&#28553;',
	"\xE4F8" => '&#28557;',
	"\xE4F9" => '&#28556;',
	"\xE4FA" => '&#28536;',
	"\xE4FB" => '&#28530;',
	"\xE4FC" => '&#28540;',
	"\xE4FD" => '&#28538;',
	"\xE4FE" => '&#28625;',
	"\xE5A1" => '&#28617;',
	"\xE5A2" => '&#28583;',
	"\xE5A3" => '&#28601;',
	"\xE5A4" => '&#28598;',
	"\xE5A5" => '&#28610;',
	"\xE5A6" => '&#28641;',
	"\xE5A7" => '&#28654;',
	"\xE5A8" => '&#28638;',
	"\xE5A9" => '&#28640;',
	"\xE5AA" => '&#28655;',
	"\xE5AB" => '&#28698;',
	"\xE5AC" => '&#28707;',
	"\xE5AD" => '&#28699;',
	"\xE5AE" => '&#28729;',
	"\xE5AF" => '&#28725;',
	"\xE5B0" => '&#28751;',
	"\xE5B1" => '&#28766;',
	"\xE5B2" => '&#23424;',
	"\xE5B3" => '&#23428;',
	"\xE5B4" => '&#23445;',
	"\xE5B5" => '&#23443;',
	"\xE5B6" => '&#23461;',
	"\xE5B7" => '&#23480;',
	"\xE5B8" => '&#29999;',
	"\xE5B9" => '&#39582;',
	"\xE5BA" => '&#25652;',
	"\xE5BB" => '&#23524;',
	"\xE5BC" => '&#23534;',
	"\xE5BD" => '&#35120;',
	"\xE5BE" => '&#23536;',
	"\xE5BF" => '&#36423;',
	"\xE5C0" => '&#35591;',
	"\xE5C1" => '&#36790;',
	"\xE5C2" => '&#36819;',
	"\xE5C3" => '&#36821;',
	"\xE5C4" => '&#36837;',
	"\xE5C5" => '&#36846;',
	"\xE5C6" => '&#36836;',
	"\xE5C7" => '&#36841;',
	"\xE5C8" => '&#36838;',
	"\xE5C9" => '&#36851;',
	"\xE5CA" => '&#36840;',
	"\xE5CB" => '&#36869;',
	"\xE5CC" => '&#36868;',
	"\xE5CD" => '&#36875;',
	"\xE5CE" => '&#36902;',
	"\xE5CF" => '&#36881;',
	"\xE5D0" => '&#36877;',
	"\xE5D1" => '&#36886;',
	"\xE5D2" => '&#36897;',
	"\xE5D3" => '&#36917;',
	"\xE5D4" => '&#36918;',
	"\xE5D5" => '&#36909;',
	"\xE5D6" => '&#36911;',
	"\xE5D7" => '&#36932;',
	"\xE5D8" => '&#36945;',
	"\xE5D9" => '&#36946;',
	"\xE5DA" => '&#36944;',
	"\xE5DB" => '&#36968;',
	"\xE5DC" => '&#36952;',
	"\xE5DD" => '&#36962;',
	"\xE5DE" => '&#36955;',
	"\xE5DF" => '&#26297;',
	"\xE5E0" => '&#36980;',
	"\xE5E1" => '&#36989;',
	"\xE5E2" => '&#36994;',
	"\xE5E3" => '&#37000;',
	"\xE5E4" => '&#36995;',
	"\xE5E5" => '&#37003;',
	"\xE5E6" => '&#24400;',
	"\xE5E7" => '&#24407;',
	"\xE5E8" => '&#24406;',
	"\xE5E9" => '&#24408;',
	"\xE5EA" => '&#23611;',
	"\xE5EB" => '&#21675;',
	"\xE5EC" => '&#23632;',
	"\xE5ED" => '&#23641;',
	"\xE5EE" => '&#23409;',
	"\xE5EF" => '&#23651;',
	"\xE5F0" => '&#23654;',
	"\xE5F1" => '&#32700;',
	"\xE5F2" => '&#24362;',
	"\xE5F3" => '&#24361;',
	"\xE5F4" => '&#24365;',
	"\xE5F5" => '&#33396;',
	"\xE5F6" => '&#24380;',
	"\xE5F7" => '&#39739;',
	"\xE5F8" => '&#23662;',
	"\xE5F9" => '&#22913;',
	"\xE5FA" => '&#22915;',
	"\xE5FB" => '&#22925;',
	"\xE5FC" => '&#22953;',
	"\xE5FD" => '&#22954;',
	"\xE5FE" => '&#22947;',
	"\xE6A1" => '&#22935;',
	"\xE6A2" => '&#22986;',
	"\xE6A3" => '&#22955;',
	"\xE6A4" => '&#22942;',
	"\xE6A5" => '&#22948;',
	"\xE6A6" => '&#22994;',
	"\xE6A7" => '&#22962;',
	"\xE6A8" => '&#22959;',
	"\xE6A9" => '&#22999;',
	"\xE6AA" => '&#22974;',
	"\xE6AB" => '&#23045;',
	"\xE6AC" => '&#23046;',
	"\xE6AD" => '&#23005;',
	"\xE6AE" => '&#23048;',
	"\xE6AF" => '&#23011;',
	"\xE6B0" => '&#23000;',
	"\xE6B1" => '&#23033;',
	"\xE6B2" => '&#23052;',
	"\xE6B3" => '&#23049;',
	"\xE6B4" => '&#23090;',
	"\xE6B5" => '&#23092;',
	"\xE6B6" => '&#23057;',
	"\xE6B7" => '&#23075;',
	"\xE6B8" => '&#23059;',
	"\xE6B9" => '&#23104;',
	"\xE6BA" => '&#23143;',
	"\xE6BB" => '&#23114;',
	"\xE6BC" => '&#23125;',
	"\xE6BD" => '&#23100;',
	"\xE6BE" => '&#23138;',
	"\xE6BF" => '&#23157;',
	"\xE6C0" => '&#33004;',
	"\xE6C1" => '&#23210;',
	"\xE6C2" => '&#23195;',
	"\xE6C3" => '&#23159;',
	"\xE6C4" => '&#23162;',
	"\xE6C5" => '&#23230;',
	"\xE6C6" => '&#23275;',
	"\xE6C7" => '&#23218;',
	"\xE6C8" => '&#23250;',
	"\xE6C9" => '&#23252;',
	"\xE6CA" => '&#23224;',
	"\xE6CB" => '&#23264;',
	"\xE6CC" => '&#23267;',
	"\xE6CD" => '&#23281;',
	"\xE6CE" => '&#23254;',
	"\xE6CF" => '&#23270;',
	"\xE6D0" => '&#23256;',
	"\xE6D1" => '&#23260;',
	"\xE6D2" => '&#23305;',
	"\xE6D3" => '&#23319;',
	"\xE6D4" => '&#23318;',
	"\xE6D5" => '&#23346;',
	"\xE6D6" => '&#23351;',
	"\xE6D7" => '&#23360;',
	"\xE6D8" => '&#23573;',
	"\xE6D9" => '&#23580;',
	"\xE6DA" => '&#23386;',
	"\xE6DB" => '&#23397;',
	"\xE6DC" => '&#23411;',
	"\xE6DD" => '&#23377;',
	"\xE6DE" => '&#23379;',
	"\xE6DF" => '&#23394;',
	"\xE6E0" => '&#39541;',
	"\xE6E1" => '&#39543;',
	"\xE6E2" => '&#39544;',
	"\xE6E3" => '&#39546;',
	"\xE6E4" => '&#39551;',
	"\xE6E5" => '&#39549;',
	"\xE6E6" => '&#39552;',
	"\xE6E7" => '&#39553;',
	"\xE6E8" => '&#39557;',
	"\xE6E9" => '&#39560;',
	"\xE6EA" => '&#39562;',
	"\xE6EB" => '&#39568;',
	"\xE6EC" => '&#39570;',
	"\xE6ED" => '&#39571;',
	"\xE6EE" => '&#39574;',
	"\xE6EF" => '&#39576;',
	"\xE6F0" => '&#39579;',
	"\xE6F1" => '&#39580;',
	"\xE6F2" => '&#39581;',
	"\xE6F3" => '&#39583;',
	"\xE6F4" => '&#39584;',
	"\xE6F5" => '&#39586;',
	"\xE6F6" => '&#39587;',
	"\xE6F7" => '&#39589;',
	"\xE6F8" => '&#39591;',
	"\xE6F9" => '&#32415;',
	"\xE6FA" => '&#32417;',
	"\xE6FB" => '&#32419;',
	"\xE6FC" => '&#32421;',
	"\xE6FD" => '&#32424;',
	"\xE6FE" => '&#32425;',
	"\xE7A1" => '&#32429;',
	"\xE7A2" => '&#32432;',
	"\xE7A3" => '&#32446;',
	"\xE7A4" => '&#32448;',
	"\xE7A5" => '&#32449;',
	"\xE7A6" => '&#32450;',
	"\xE7A7" => '&#32457;',
	"\xE7A8" => '&#32459;',
	"\xE7A9" => '&#32460;',
	"\xE7AA" => '&#32464;',
	"\xE7AB" => '&#32468;',
	"\xE7AC" => '&#32471;',
	"\xE7AD" => '&#32475;',
	"\xE7AE" => '&#32480;',
	"\xE7AF" => '&#32481;',
	"\xE7B0" => '&#32488;',
	"\xE7B1" => '&#32491;',
	"\xE7B2" => '&#32494;',
	"\xE7B3" => '&#32495;',
	"\xE7B4" => '&#32497;',
	"\xE7B5" => '&#32498;',
	"\xE7B6" => '&#32525;',
	"\xE7B7" => '&#32502;',
	"\xE7B8" => '&#32506;',
	"\xE7B9" => '&#32507;',
	"\xE7BA" => '&#32510;',
	"\xE7BB" => '&#32513;',
	"\xE7BC" => '&#32514;',
	"\xE7BD" => '&#32515;',
	"\xE7BE" => '&#32519;',
	"\xE7BF" => '&#32520;',
	"\xE7C0" => '&#32523;',
	"\xE7C1" => '&#32524;',
	"\xE7C2" => '&#32527;',
	"\xE7C3" => '&#32529;',
	"\xE7C4" => '&#32530;',
	"\xE7C5" => '&#32535;',
	"\xE7C6" => '&#32537;',
	"\xE7C7" => '&#32540;',
	"\xE7C8" => '&#32539;',
	"\xE7C9" => '&#32543;',
	"\xE7CA" => '&#32545;',
	"\xE7CB" => '&#32546;',
	"\xE7CC" => '&#32547;',
	"\xE7CD" => '&#32548;',
	"\xE7CE" => '&#32549;',
	"\xE7CF" => '&#32550;',
	"\xE7D0" => '&#32551;',
	"\xE7D1" => '&#32554;',
	"\xE7D2" => '&#32555;',
	"\xE7D3" => '&#32556;',
	"\xE7D4" => '&#32557;',
	"\xE7D5" => '&#32559;',
	"\xE7D6" => '&#32560;',
	"\xE7D7" => '&#32561;',
	"\xE7D8" => '&#32562;',
	"\xE7D9" => '&#32563;',
	"\xE7DA" => '&#32565;',
	"\xE7DB" => '&#24186;',
	"\xE7DC" => '&#30079;',
	"\xE7DD" => '&#24027;',
	"\xE7DE" => '&#30014;',
	"\xE7DF" => '&#37013;',
	"\xE7E0" => '&#29582;',
	"\xE7E1" => '&#29585;',
	"\xE7E2" => '&#29614;',
	"\xE7E3" => '&#29602;',
	"\xE7E4" => '&#29599;',
	"\xE7E5" => '&#29647;',
	"\xE7E6" => '&#29634;',
	"\xE7E7" => '&#29649;',
	"\xE7E8" => '&#29623;',
	"\xE7E9" => '&#29619;',
	"\xE7EA" => '&#29632;',
	"\xE7EB" => '&#29641;',
	"\xE7EC" => '&#29640;',
	"\xE7ED" => '&#29669;',
	"\xE7EE" => '&#29657;',
	"\xE7EF" => '&#39036;',
	"\xE7F0" => '&#29706;',
	"\xE7F1" => '&#29673;',
	"\xE7F2" => '&#29671;',
	"\xE7F3" => '&#29662;',
	"\xE7F4" => '&#29626;',
	"\xE7F5" => '&#29682;',
	"\xE7F6" => '&#29711;',
	"\xE7F7" => '&#29738;',
	"\xE7F8" => '&#29787;',
	"\xE7F9" => '&#29734;',
	"\xE7FA" => '&#29733;',
	"\xE7FB" => '&#29736;',
	"\xE7FC" => '&#29744;',
	"\xE7FD" => '&#29742;',
	"\xE7FE" => '&#29740;',
	"\xE8A1" => '&#29723;',
	"\xE8A2" => '&#29722;',
	"\xE8A3" => '&#29761;',
	"\xE8A4" => '&#29788;',
	"\xE8A5" => '&#29783;',
	"\xE8A6" => '&#29781;',
	"\xE8A7" => '&#29785;',
	"\xE8A8" => '&#29815;',
	"\xE8A9" => '&#29805;',
	"\xE8AA" => '&#29822;',
	"\xE8AB" => '&#29852;',
	"\xE8AC" => '&#29838;',
	"\xE8AD" => '&#29824;',
	"\xE8AE" => '&#29825;',
	"\xE8AF" => '&#29831;',
	"\xE8B0" => '&#29835;',
	"\xE8B1" => '&#29854;',
	"\xE8B2" => '&#29864;',
	"\xE8B3" => '&#29865;',
	"\xE8B4" => '&#29840;',
	"\xE8B5" => '&#29863;',
	"\xE8B6" => '&#29906;',
	"\xE8B7" => '&#29882;',
	"\xE8B8" => '&#38890;',
	"\xE8B9" => '&#38891;',
	"\xE8BA" => '&#38892;',
	"\xE8BB" => '&#26444;',
	"\xE8BC" => '&#26451;',
	"\xE8BD" => '&#26462;',
	"\xE8BE" => '&#26440;',
	"\xE8BF" => '&#26473;',
	"\xE8C0" => '&#26533;',
	"\xE8C1" => '&#26503;',
	"\xE8C2" => '&#26474;',
	"\xE8C3" => '&#26483;',
	"\xE8C4" => '&#26520;',
	"\xE8C5" => '&#26535;',
	"\xE8C6" => '&#26485;',
	"\xE8C7" => '&#26536;',
	"\xE8C8" => '&#26526;',
	"\xE8C9" => '&#26541;',
	"\xE8CA" => '&#26507;',
	"\xE8CB" => '&#26487;',
	"\xE8CC" => '&#26492;',
	"\xE8CD" => '&#26608;',
	"\xE8CE" => '&#26633;',
	"\xE8CF" => '&#26584;',
	"\xE8D0" => '&#26634;',
	"\xE8D1" => '&#26601;',
	"\xE8D2" => '&#26544;',
	"\xE8D3" => '&#26636;',
	"\xE8D4" => '&#26585;',
	"\xE8D5" => '&#26549;',
	"\xE8D6" => '&#26586;',
	"\xE8D7" => '&#26547;',
	"\xE8D8" => '&#26589;',
	"\xE8D9" => '&#26624;',
	"\xE8DA" => '&#26563;',
	"\xE8DB" => '&#26552;',
	"\xE8DC" => '&#26594;',
	"\xE8DD" => '&#26638;',
	"\xE8DE" => '&#26561;',
	"\xE8DF" => '&#26621;',
	"\xE8E0" => '&#26674;',
	"\xE8E1" => '&#26675;',
	"\xE8E2" => '&#26720;',
	"\xE8E3" => '&#26721;',
	"\xE8E4" => '&#26702;',
	"\xE8E5" => '&#26722;',
	"\xE8E6" => '&#26692;',
	"\xE8E7" => '&#26724;',
	"\xE8E8" => '&#26755;',
	"\xE8E9" => '&#26653;',
	"\xE8EA" => '&#26709;',
	"\xE8EB" => '&#26726;',
	"\xE8EC" => '&#26689;',
	"\xE8ED" => '&#26727;',
	"\xE8EE" => '&#26688;',
	"\xE8EF" => '&#26686;',
	"\xE8F0" => '&#26698;',
	"\xE8F1" => '&#26697;',
	"\xE8F2" => '&#26665;',
	"\xE8F3" => '&#26805;',
	"\xE8F4" => '&#26767;',
	"\xE8F5" => '&#26740;',
	"\xE8F6" => '&#26743;',
	"\xE8F7" => '&#26771;',
	"\xE8F8" => '&#26731;',
	"\xE8F9" => '&#26818;',
	"\xE8FA" => '&#26990;',
	"\xE8FB" => '&#26876;',
	"\xE8FC" => '&#26911;',
	"\xE8FD" => '&#26912;',
	"\xE8FE" => '&#26873;',
	"\xE9A1" => '&#26916;',
	"\xE9A2" => '&#26864;',
	"\xE9A3" => '&#26891;',
	"\xE9A4" => '&#26881;',
	"\xE9A5" => '&#26967;',
	"\xE9A6" => '&#26851;',
	"\xE9A7" => '&#26896;',
	"\xE9A8" => '&#26993;',
	"\xE9A9" => '&#26937;',
	"\xE9AA" => '&#26976;',
	"\xE9AB" => '&#26946;',
	"\xE9AC" => '&#26973;',
	"\xE9AD" => '&#27012;',
	"\xE9AE" => '&#26987;',
	"\xE9AF" => '&#27008;',
	"\xE9B0" => '&#27032;',
	"\xE9B1" => '&#27000;',
	"\xE9B2" => '&#26932;',
	"\xE9B3" => '&#27084;',
	"\xE9B4" => '&#27015;',
	"\xE9B5" => '&#27016;',
	"\xE9B6" => '&#27086;',
	"\xE9B7" => '&#27017;',
	"\xE9B8" => '&#26982;',
	"\xE9B9" => '&#26979;',
	"\xE9BA" => '&#27001;',
	"\xE9BB" => '&#27035;',
	"\xE9BC" => '&#27047;',
	"\xE9BD" => '&#27067;',
	"\xE9BE" => '&#27051;',
	"\xE9BF" => '&#27053;',
	"\xE9C0" => '&#27092;',
	"\xE9C1" => '&#27057;',
	"\xE9C2" => '&#27073;',
	"\xE9C3" => '&#27082;',
	"\xE9C4" => '&#27103;',
	"\xE9C5" => '&#27029;',
	"\xE9C6" => '&#27104;',
	"\xE9C7" => '&#27021;',
	"\xE9C8" => '&#27135;',
	"\xE9C9" => '&#27183;',
	"\xE9CA" => '&#27117;',
	"\xE9CB" => '&#27159;',
	"\xE9CC" => '&#27160;',
	"\xE9CD" => '&#27237;',
	"\xE9CE" => '&#27122;',
	"\xE9CF" => '&#27204;',
	"\xE9D0" => '&#27198;',
	"\xE9D1" => '&#27296;',
	"\xE9D2" => '&#27216;',
	"\xE9D3" => '&#27227;',
	"\xE9D4" => '&#27189;',
	"\xE9D5" => '&#27278;',
	"\xE9D6" => '&#27257;',
	"\xE9D7" => '&#27197;',
	"\xE9D8" => '&#27176;',
	"\xE9D9" => '&#27224;',
	"\xE9DA" => '&#27260;',
	"\xE9DB" => '&#27281;',
	"\xE9DC" => '&#27280;',
	"\xE9DD" => '&#27305;',
	"\xE9DE" => '&#27287;',
	"\xE9DF" => '&#27307;',
	"\xE9E0" => '&#29495;',
	"\xE9E1" => '&#29522;',
	"\xE9E2" => '&#27521;',
	"\xE9E3" => '&#27522;',
	"\xE9E4" => '&#27527;',
	"\xE9E5" => '&#27524;',
	"\xE9E6" => '&#27538;',
	"\xE9E7" => '&#27539;',
	"\xE9E8" => '&#27533;',
	"\xE9E9" => '&#27546;',
	"\xE9EA" => '&#27547;',
	"\xE9EB" => '&#27553;',
	"\xE9EC" => '&#27562;',
	"\xE9ED" => '&#36715;',
	"\xE9EE" => '&#36717;',
	"\xE9EF" => '&#36721;',
	"\xE9F0" => '&#36722;',
	"\xE9F1" => '&#36723;',
	"\xE9F2" => '&#36725;',
	"\xE9F3" => '&#36726;',
	"\xE9F4" => '&#36728;',
	"\xE9F5" => '&#36727;',
	"\xE9F6" => '&#36729;',
	"\xE9F7" => '&#36730;',
	"\xE9F8" => '&#36732;',
	"\xE9F9" => '&#36734;',
	"\xE9FA" => '&#36737;',
	"\xE9FB" => '&#36738;',
	"\xE9FC" => '&#36740;',
	"\xE9FD" => '&#36743;',
	"\xE9FE" => '&#36747;',
	"\xEAA1" => '&#36749;',
	"\xEAA2" => '&#36750;',
	"\xEAA3" => '&#36751;',
	"\xEAA4" => '&#36760;',
	"\xEAA5" => '&#36762;',
	"\xEAA6" => '&#36558;',
	"\xEAA7" => '&#25099;',
	"\xEAA8" => '&#25111;',
	"\xEAA9" => '&#25115;',
	"\xEAAA" => '&#25119;',
	"\xEAAB" => '&#25122;',
	"\xEAAC" => '&#25121;',
	"\xEAAD" => '&#25125;',
	"\xEAAE" => '&#25124;',
	"\xEAAF" => '&#25132;',
	"\xEAB0" => '&#33255;',
	"\xEAB1" => '&#29935;',
	"\xEAB2" => '&#29940;',
	"\xEAB3" => '&#29951;',
	"\xEAB4" => '&#29967;',
	"\xEAB5" => '&#29969;',
	"\xEAB6" => '&#29971;',
	"\xEAB7" => '&#25908;',
	"\xEAB8" => '&#26094;',
	"\xEAB9" => '&#26095;',
	"\xEABA" => '&#26096;',
	"\xEABB" => '&#26122;',
	"\xEABC" => '&#26137;',
	"\xEABD" => '&#26482;',
	"\xEABE" => '&#26115;',
	"\xEABF" => '&#26133;',
	"\xEAC0" => '&#26112;',
	"\xEAC1" => '&#28805;',
	"\xEAC2" => '&#26359;',
	"\xEAC3" => '&#26141;',
	"\xEAC4" => '&#26164;',
	"\xEAC5" => '&#26161;',
	"\xEAC6" => '&#26166;',
	"\xEAC7" => '&#26165;',
	"\xEAC8" => '&#32774;',
	"\xEAC9" => '&#26207;',
	"\xEACA" => '&#26196;',
	"\xEACB" => '&#26177;',
	"\xEACC" => '&#26191;',
	"\xEACD" => '&#26198;',
	"\xEACE" => '&#26209;',
	"\xEACF" => '&#26199;',
	"\xEAD0" => '&#26231;',
	"\xEAD1" => '&#26244;',
	"\xEAD2" => '&#26252;',
	"\xEAD3" => '&#26279;',
	"\xEAD4" => '&#26269;',
	"\xEAD5" => '&#26302;',
	"\xEAD6" => '&#26331;',
	"\xEAD7" => '&#26332;',
	"\xEAD8" => '&#26342;',
	"\xEAD9" => '&#26345;',
	"\xEADA" => '&#36146;',
	"\xEADB" => '&#36147;',
	"\xEADC" => '&#36150;',
	"\xEADD" => '&#36155;',
	"\xEADE" => '&#36157;',
	"\xEADF" => '&#36160;',
	"\xEAE0" => '&#36165;',
	"\xEAE1" => '&#36166;',
	"\xEAE2" => '&#36168;',
	"\xEAE3" => '&#36169;',
	"\xEAE4" => '&#36167;',
	"\xEAE5" => '&#36173;',
	"\xEAE6" => '&#36181;',
	"\xEAE7" => '&#36185;',
	"\xEAE8" => '&#35271;',
	"\xEAE9" => '&#35274;',
	"\xEAEA" => '&#35275;',
	"\xEAEB" => '&#35276;',
	"\xEAEC" => '&#35278;',
	"\xEAED" => '&#35279;',
	"\xEAEE" => '&#35280;',
	"\xEAEF" => '&#35281;',
	"\xEAF0" => '&#29294;',
	"\xEAF1" => '&#29343;',
	"\xEAF2" => '&#29277;',
	"\xEAF3" => '&#29286;',
	"\xEAF4" => '&#29295;',
	"\xEAF5" => '&#29310;',
	"\xEAF6" => '&#29311;',
	"\xEAF7" => '&#29316;',
	"\xEAF8" => '&#29323;',
	"\xEAF9" => '&#29325;',
	"\xEAFA" => '&#29327;',
	"\xEAFB" => '&#29330;',
	"\xEAFC" => '&#25352;',
	"\xEAFD" => '&#25394;',
	"\xEAFE" => '&#25520;',
	"\xEBA1" => '&#25663;',
	"\xEBA2" => '&#25816;',
	"\xEBA3" => '&#32772;',
	"\xEBA4" => '&#27626;',
	"\xEBA5" => '&#27635;',
	"\xEBA6" => '&#27645;',
	"\xEBA7" => '&#27637;',
	"\xEBA8" => '&#27641;',
	"\xEBA9" => '&#27653;',
	"\xEBAA" => '&#27655;',
	"\xEBAB" => '&#27654;',
	"\xEBAC" => '&#27661;',
	"\xEBAD" => '&#27669;',
	"\xEBAE" => '&#27672;',
	"\xEBAF" => '&#27673;',
	"\xEBB0" => '&#27674;',
	"\xEBB1" => '&#27681;',
	"\xEBB2" => '&#27689;',
	"\xEBB3" => '&#27684;',
	"\xEBB4" => '&#27690;',
	"\xEBB5" => '&#27698;',
	"\xEBB6" => '&#25909;',
	"\xEBB7" => '&#25941;',
	"\xEBB8" => '&#25963;',
	"\xEBB9" => '&#29261;',
	"\xEBBA" => '&#29266;',
	"\xEBBB" => '&#29270;',
	"\xEBBC" => '&#29232;',
	"\xEBBD" => '&#34402;',
	"\xEBBE" => '&#21014;',
	"\xEBBF" => '&#32927;',
	"\xEBC0" => '&#32924;',
	"\xEBC1" => '&#32915;',
	"\xEBC2" => '&#32956;',
	"\xEBC3" => '&#26378;',
	"\xEBC4" => '&#32957;',
	"\xEBC5" => '&#32945;',
	"\xEBC6" => '&#32939;',
	"\xEBC7" => '&#32941;',
	"\xEBC8" => '&#32948;',
	"\xEBC9" => '&#32951;',
	"\xEBCA" => '&#32999;',
	"\xEBCB" => '&#33000;',
	"\xEBCC" => '&#33001;',
	"\xEBCD" => '&#33002;',
	"\xEBCE" => '&#32987;',
	"\xEBCF" => '&#32962;',
	"\xEBD0" => '&#32964;',
	"\xEBD1" => '&#32985;',
	"\xEBD2" => '&#32973;',
	"\xEBD3" => '&#32983;',
	"\xEBD4" => '&#26384;',
	"\xEBD5" => '&#32989;',
	"\xEBD6" => '&#33003;',
	"\xEBD7" => '&#33009;',
	"\xEBD8" => '&#33012;',
	"\xEBD9" => '&#33005;',
	"\xEBDA" => '&#33037;',
	"\xEBDB" => '&#33038;',
	"\xEBDC" => '&#33010;',
	"\xEBDD" => '&#33020;',
	"\xEBDE" => '&#26389;',
	"\xEBDF" => '&#33042;',
	"\xEBE0" => '&#35930;',
	"\xEBE1" => '&#33078;',
	"\xEBE2" => '&#33054;',
	"\xEBE3" => '&#33068;',
	"\xEBE4" => '&#33048;',
	"\xEBE5" => '&#33074;',
	"\xEBE6" => '&#33096;',
	"\xEBE7" => '&#33100;',
	"\xEBE8" => '&#33107;',
	"\xEBE9" => '&#33140;',
	"\xEBEA" => '&#33113;',
	"\xEBEB" => '&#33114;',
	"\xEBEC" => '&#33137;',
	"\xEBED" => '&#33120;',
	"\xEBEE" => '&#33129;',
	"\xEBEF" => '&#33148;',
	"\xEBF0" => '&#33149;',
	"\xEBF1" => '&#33133;',
	"\xEBF2" => '&#33127;',
	"\xEBF3" => '&#22605;',
	"\xEBF4" => '&#23221;',
	"\xEBF5" => '&#33160;',
	"\xEBF6" => '&#33154;',
	"\xEBF7" => '&#33169;',
	"\xEBF8" => '&#28373;',
	"\xEBF9" => '&#33187;',
	"\xEBFA" => '&#33194;',
	"\xEBFB" => '&#33228;',
	"\xEBFC" => '&#26406;',
	"\xEBFD" => '&#33226;',
	"\xEBFE" => '&#33211;',
	"\xECA1" => '&#33217;',
	"\xECA2" => '&#33190;',
	"\xECA3" => '&#27428;',
	"\xECA4" => '&#27447;',
	"\xECA5" => '&#27449;',
	"\xECA6" => '&#27459;',
	"\xECA7" => '&#27462;',
	"\xECA8" => '&#27481;',
	"\xECA9" => '&#39121;',
	"\xECAA" => '&#39122;',
	"\xECAB" => '&#39123;',
	"\xECAC" => '&#39125;',
	"\xECAD" => '&#39129;',
	"\xECAE" => '&#39130;',
	"\xECAF" => '&#27571;',
	"\xECB0" => '&#24384;',
	"\xECB1" => '&#27586;',
	"\xECB2" => '&#35315;',
	"\xECB3" => '&#26000;',
	"\xECB4" => '&#40785;',
	"\xECB5" => '&#26003;',
	"\xECB6" => '&#26044;',
	"\xECB7" => '&#26054;',
	"\xECB8" => '&#26052;',
	"\xECB9" => '&#26051;',
	"\xECBA" => '&#26060;',
	"\xECBB" => '&#26062;',
	"\xECBC" => '&#26066;',
	"\xECBD" => '&#26070;',
	"\xECBE" => '&#28800;',
	"\xECBF" => '&#28828;',
	"\xECC0" => '&#28822;',
	"\xECC1" => '&#28829;',
	"\xECC2" => '&#28859;',
	"\xECC3" => '&#28864;',
	"\xECC4" => '&#28855;',
	"\xECC5" => '&#28843;',
	"\xECC6" => '&#28849;',
	"\xECC7" => '&#28904;',
	"\xECC8" => '&#28874;',
	"\xECC9" => '&#28944;',
	"\xECCA" => '&#28947;',
	"\xECCB" => '&#28950;',
	"\xECCC" => '&#28975;',
	"\xECCD" => '&#28977;',
	"\xECCE" => '&#29043;',
	"\xECCF" => '&#29020;',
	"\xECD0" => '&#29032;',
	"\xECD1" => '&#28997;',
	"\xECD2" => '&#29042;',
	"\xECD3" => '&#29002;',
	"\xECD4" => '&#29048;',
	"\xECD5" => '&#29050;',
	"\xECD6" => '&#29080;',
	"\xECD7" => '&#29107;',
	"\xECD8" => '&#29109;',
	"\xECD9" => '&#29096;',
	"\xECDA" => '&#29088;',
	"\xECDB" => '&#29152;',
	"\xECDC" => '&#29140;',
	"\xECDD" => '&#29159;',
	"\xECDE" => '&#29177;',
	"\xECDF" => '&#29213;',
	"\xECE0" => '&#29224;',
	"\xECE1" => '&#28780;',
	"\xECE2" => '&#28952;',
	"\xECE3" => '&#29030;',
	"\xECE4" => '&#29113;',
	"\xECE5" => '&#25150;',
	"\xECE6" => '&#25149;',
	"\xECE7" => '&#25155;',
	"\xECE8" => '&#25160;',
	"\xECE9" => '&#25161;',
	"\xECEA" => '&#31035;',
	"\xECEB" => '&#31040;',
	"\xECEC" => '&#31046;',
	"\xECED" => '&#31049;',
	"\xECEE" => '&#31067;',
	"\xECEF" => '&#31068;',
	"\xECF0" => '&#31059;',
	"\xECF1" => '&#31066;',
	"\xECF2" => '&#31074;',
	"\xECF3" => '&#31063;',
	"\xECF4" => '&#31072;',
	"\xECF5" => '&#31087;',
	"\xECF6" => '&#31079;',
	"\xECF7" => '&#31098;',
	"\xECF8" => '&#31109;',
	"\xECF9" => '&#31114;',
	"\xECFA" => '&#31130;',
	"\xECFB" => '&#31143;',
	"\xECFC" => '&#31155;',
	"\xECFD" => '&#24529;',
	"\xECFE" => '&#24528;',
	"\xEDA1" => '&#24636;',
	"\xEDA2" => '&#24669;',
	"\xEDA3" => '&#24666;',
	"\xEDA4" => '&#24679;',
	"\xEDA5" => '&#24641;',
	"\xEDA6" => '&#24665;',
	"\xEDA7" => '&#24675;',
	"\xEDA8" => '&#24747;',
	"\xEDA9" => '&#24838;',
	"\xEDAA" => '&#24845;',
	"\xEDAB" => '&#24925;',
	"\xEDAC" => '&#25001;',
	"\xEDAD" => '&#24989;',
	"\xEDAE" => '&#25035;',
	"\xEDAF" => '&#25041;',
	"\xEDB0" => '&#25094;',
	"\xEDB1" => '&#32896;',
	"\xEDB2" => '&#32895;',
	"\xEDB3" => '&#27795;',
	"\xEDB4" => '&#27894;',
	"\xEDB5" => '&#28156;',
	"\xEDB6" => '&#30710;',
	"\xEDB7" => '&#30712;',
	"\xEDB8" => '&#30720;',
	"\xEDB9" => '&#30729;',
	"\xEDBA" => '&#30743;',
	"\xEDBB" => '&#30744;',
	"\xEDBC" => '&#30737;',
	"\xEDBD" => '&#26027;',
	"\xEDBE" => '&#30765;',
	"\xEDBF" => '&#30748;',
	"\xEDC0" => '&#30749;',
	"\xEDC1" => '&#30777;',
	"\xEDC2" => '&#30778;',
	"\xEDC3" => '&#30779;',
	"\xEDC4" => '&#30751;',
	"\xEDC5" => '&#30780;',
	"\xEDC6" => '&#30757;',
	"\xEDC7" => '&#30764;',
	"\xEDC8" => '&#30755;',
	"\xEDC9" => '&#30761;',
	"\xEDCA" => '&#30798;',
	"\xEDCB" => '&#30829;',
	"\xEDCC" => '&#30806;',
	"\xEDCD" => '&#30807;',
	"\xEDCE" => '&#30758;',
	"\xEDCF" => '&#30800;',
	"\xEDD0" => '&#30791;',
	"\xEDD1" => '&#30796;',
	"\xEDD2" => '&#30826;',
	"\xEDD3" => '&#30875;',
	"\xEDD4" => '&#30867;',
	"\xEDD5" => '&#30874;',
	"\xEDD6" => '&#30855;',
	"\xEDD7" => '&#30876;',
	"\xEDD8" => '&#30881;',
	"\xEDD9" => '&#30883;',
	"\xEDDA" => '&#30898;',
	"\xEDDB" => '&#30905;',
	"\xEDDC" => '&#30885;',
	"\xEDDD" => '&#30932;',
	"\xEDDE" => '&#30937;',
	"\xEDDF" => '&#30921;',
	"\xEDE0" => '&#30956;',
	"\xEDE1" => '&#30962;',
	"\xEDE2" => '&#30981;',
	"\xEDE3" => '&#30964;',
	"\xEDE4" => '&#30995;',
	"\xEDE5" => '&#31012;',
	"\xEDE6" => '&#31006;',
	"\xEDE7" => '&#31028;',
	"\xEDE8" => '&#40859;',
	"\xEDE9" => '&#40697;',
	"\xEDEA" => '&#40699;',
	"\xEDEB" => '&#40700;',
	"\xEDEC" => '&#30449;',
	"\xEDED" => '&#30468;',
	"\xEDEE" => '&#30477;',
	"\xEDEF" => '&#30457;',
	"\xEDF0" => '&#30471;',
	"\xEDF1" => '&#30472;',
	"\xEDF2" => '&#30490;',
	"\xEDF3" => '&#30498;',
	"\xEDF4" => '&#30489;',
	"\xEDF5" => '&#30509;',
	"\xEDF6" => '&#30502;',
	"\xEDF7" => '&#30517;',
	"\xEDF8" => '&#30520;',
	"\xEDF9" => '&#30544;',
	"\xEDFA" => '&#30545;',
	"\xEDFB" => '&#30535;',
	"\xEDFC" => '&#30531;',
	"\xEDFD" => '&#30554;',
	"\xEDFE" => '&#30568;',
	"\xEEA1" => '&#30562;',
	"\xEEA2" => '&#30565;',
	"\xEEA3" => '&#30591;',
	"\xEEA4" => '&#30605;',
	"\xEEA5" => '&#30589;',
	"\xEEA6" => '&#30592;',
	"\xEEA7" => '&#30604;',
	"\xEEA8" => '&#30609;',
	"\xEEA9" => '&#30623;',
	"\xEEAA" => '&#30624;',
	"\xEEAB" => '&#30640;',
	"\xEEAC" => '&#30645;',
	"\xEEAD" => '&#30653;',
	"\xEEAE" => '&#30010;',
	"\xEEAF" => '&#30016;',
	"\xEEB0" => '&#30030;',
	"\xEEB1" => '&#30027;',
	"\xEEB2" => '&#30024;',
	"\xEEB3" => '&#30043;',
	"\xEEB4" => '&#30066;',
	"\xEEB5" => '&#30073;',
	"\xEEB6" => '&#30083;',
	"\xEEB7" => '&#32600;',
	"\xEEB8" => '&#32609;',
	"\xEEB9" => '&#32607;',
	"\xEEBA" => '&#35400;',
	"\xEEBB" => '&#32616;',
	"\xEEBC" => '&#32628;',
	"\xEEBD" => '&#32625;',
	"\xEEBE" => '&#32633;',
	"\xEEBF" => '&#32641;',
	"\xEEC0" => '&#32638;',
	"\xEEC1" => '&#30413;',
	"\xEEC2" => '&#30437;',
	"\xEEC3" => '&#34866;',
	"\xEEC4" => '&#38021;',
	"\xEEC5" => '&#38022;',
	"\xEEC6" => '&#38023;',
	"\xEEC7" => '&#38027;',
	"\xEEC8" => '&#38026;',
	"\xEEC9" => '&#38028;',
	"\xEECA" => '&#38029;',
	"\xEECB" => '&#38031;',
	"\xEECC" => '&#38032;',
	"\xEECD" => '&#38036;',
	"\xEECE" => '&#38039;',
	"\xEECF" => '&#38037;',
	"\xEED0" => '&#38042;',
	"\xEED1" => '&#38043;',
	"\xEED2" => '&#38044;',
	"\xEED3" => '&#38051;',
	"\xEED4" => '&#38052;',
	"\xEED5" => '&#38059;',
	"\xEED6" => '&#38058;',
	"\xEED7" => '&#38061;',
	"\xEED8" => '&#38060;',
	"\xEED9" => '&#38063;',
	"\xEEDA" => '&#38064;',
	"\xEEDB" => '&#38066;',
	"\xEEDC" => '&#38068;',
	"\xEEDD" => '&#38070;',
	"\xEEDE" => '&#38071;',
	"\xEEDF" => '&#38072;',
	"\xEEE0" => '&#38073;',
	"\xEEE1" => '&#38074;',
	"\xEEE2" => '&#38076;',
	"\xEEE3" => '&#38077;',
	"\xEEE4" => '&#38079;',
	"\xEEE5" => '&#38084;',
	"\xEEE6" => '&#38088;',
	"\xEEE7" => '&#38089;',
	"\xEEE8" => '&#38090;',
	"\xEEE9" => '&#38091;',
	"\xEEEA" => '&#38092;',
	"\xEEEB" => '&#38093;',
	"\xEEEC" => '&#38094;',
	"\xEEED" => '&#38096;',
	"\xEEEE" => '&#38097;',
	"\xEEEF" => '&#38098;',
	"\xEEF0" => '&#38101;',
	"\xEEF1" => '&#38102;',
	"\xEEF2" => '&#38103;',
	"\xEEF3" => '&#38105;',
	"\xEEF4" => '&#38104;',
	"\xEEF5" => '&#38107;',
	"\xEEF6" => '&#38110;',
	"\xEEF7" => '&#38111;',
	"\xEEF8" => '&#38112;',
	"\xEEF9" => '&#38114;',
	"\xEEFA" => '&#38116;',
	"\xEEFB" => '&#38117;',
	"\xEEFC" => '&#38119;',
	"\xEEFD" => '&#38120;',
	"\xEEFE" => '&#38122;',
	"\xEFA1" => '&#38121;',
	"\xEFA2" => '&#38123;',
	"\xEFA3" => '&#38126;',
	"\xEFA4" => '&#38127;',
	"\xEFA5" => '&#38131;',
	"\xEFA6" => '&#38132;',
	"\xEFA7" => '&#38133;',
	"\xEFA8" => '&#38135;',
	"\xEFA9" => '&#38137;',
	"\xEFAA" => '&#38140;',
	"\xEFAB" => '&#38141;',
	"\xEFAC" => '&#38143;',
	"\xEFAD" => '&#38147;',
	"\xEFAE" => '&#38146;',
	"\xEFAF" => '&#38150;',
	"\xEFB0" => '&#38151;',
	"\xEFB1" => '&#38153;',
	"\xEFB2" => '&#38154;',
	"\xEFB3" => '&#38157;',
	"\xEFB4" => '&#38158;',
	"\xEFB5" => '&#38159;',
	"\xEFB6" => '&#38162;',
	"\xEFB7" => '&#38163;',
	"\xEFB8" => '&#38164;',
	"\xEFB9" => '&#38165;',
	"\xEFBA" => '&#38166;',
	"\xEFBB" => '&#38168;',
	"\xEFBC" => '&#38171;',
	"\xEFBD" => '&#38173;',
	"\xEFBE" => '&#38174;',
	"\xEFBF" => '&#38175;',
	"\xEFC0" => '&#38178;',
	"\xEFC1" => '&#38186;',
	"\xEFC2" => '&#38187;',
	"\xEFC3" => '&#38185;',
	"\xEFC4" => '&#38188;',
	"\xEFC5" => '&#38193;',
	"\xEFC6" => '&#38194;',
	"\xEFC7" => '&#38196;',
	"\xEFC8" => '&#38198;',
	"\xEFC9" => '&#38199;',
	"\xEFCA" => '&#38200;',
	"\xEFCB" => '&#38204;',
	"\xEFCC" => '&#38206;',
	"\xEFCD" => '&#38207;',
	"\xEFCE" => '&#38210;',
	"\xEFCF" => '&#38197;',
	"\xEFD0" => '&#38212;',
	"\xEFD1" => '&#38213;',
	"\xEFD2" => '&#38214;',
	"\xEFD3" => '&#38217;',
	"\xEFD4" => '&#38220;',
	"\xEFD5" => '&#38222;',
	"\xEFD6" => '&#38223;',
	"\xEFD7" => '&#38226;',
	"\xEFD8" => '&#38227;',
	"\xEFD9" => '&#38228;',
	"\xEFDA" => '&#38230;',
	"\xEFDB" => '&#38231;',
	"\xEFDC" => '&#38232;',
	"\xEFDD" => '&#38233;',
	"\xEFDE" => '&#38235;',
	"\xEFDF" => '&#38238;',
	"\xEFE0" => '&#38239;',
	"\xEFE1" => '&#38237;',
	"\xEFE2" => '&#38241;',
	"\xEFE3" => '&#38242;',
	"\xEFE4" => '&#38244;',
	"\xEFE5" => '&#38245;',
	"\xEFE6" => '&#38246;',
	"\xEFE7" => '&#38247;',
	"\xEFE8" => '&#38248;',
	"\xEFE9" => '&#38249;',
	"\xEFEA" => '&#38250;',
	"\xEFEB" => '&#38251;',
	"\xEFEC" => '&#38252;',
	"\xEFED" => '&#38255;',
	"\xEFEE" => '&#38257;',
	"\xEFEF" => '&#38258;',
	"\xEFF0" => '&#38259;',
	"\xEFF1" => '&#38202;',
	"\xEFF2" => '&#30695;',
	"\xEFF3" => '&#30700;',
	"\xEFF4" => '&#38601;',
	"\xEFF5" => '&#31189;',
	"\xEFF6" => '&#31213;',
	"\xEFF7" => '&#31203;',
	"\xEFF8" => '&#31211;',
	"\xEFF9" => '&#31238;',
	"\xEFFA" => '&#23879;',
	"\xEFFB" => '&#31235;',
	"\xEFFC" => '&#31234;',
	"\xEFFD" => '&#31262;',
	"\xEFFE" => '&#31252;',
	"\xF0A1" => '&#31289;',
	"\xF0A2" => '&#31287;',
	"\xF0A3" => '&#31313;',
	"\xF0A4" => '&#40655;',
	"\xF0A5" => '&#39333;',
	"\xF0A6" => '&#31344;',
	"\xF0A7" => '&#30344;',
	"\xF0A8" => '&#30350;',
	"\xF0A9" => '&#30355;',
	"\xF0AA" => '&#30361;',
	"\xF0AB" => '&#30372;',
	"\xF0AC" => '&#29918;',
	"\xF0AD" => '&#29920;',
	"\xF0AE" => '&#29996;',
	"\xF0AF" => '&#40480;',
	"\xF0B0" => '&#40482;',
	"\xF0B1" => '&#40488;',
	"\xF0B2" => '&#40489;',
	"\xF0B3" => '&#40490;',
	"\xF0B4" => '&#40491;',
	"\xF0B5" => '&#40492;',
	"\xF0B6" => '&#40498;',
	"\xF0B7" => '&#40497;',
	"\xF0B8" => '&#40502;',
	"\xF0B9" => '&#40504;',
	"\xF0BA" => '&#40503;',
	"\xF0BB" => '&#40505;',
	"\xF0BC" => '&#40506;',
	"\xF0BD" => '&#40510;',
	"\xF0BE" => '&#40513;',
	"\xF0BF" => '&#40514;',
	"\xF0C0" => '&#40516;',
	"\xF0C1" => '&#40518;',
	"\xF0C2" => '&#40519;',
	"\xF0C3" => '&#40520;',
	"\xF0C4" => '&#40521;',
	"\xF0C5" => '&#40523;',
	"\xF0C6" => '&#40524;',
	"\xF0C7" => '&#40526;',
	"\xF0C8" => '&#40529;',
	"\xF0C9" => '&#40533;',
	"\xF0CA" => '&#40535;',
	"\xF0CB" => '&#40538;',
	"\xF0CC" => '&#40539;',
	"\xF0CD" => '&#40540;',
	"\xF0CE" => '&#40542;',
	"\xF0CF" => '&#40547;',
	"\xF0D0" => '&#40550;',
	"\xF0D1" => '&#40551;',
	"\xF0D2" => '&#40552;',
	"\xF0D3" => '&#40553;',
	"\xF0D4" => '&#40554;',
	"\xF0D5" => '&#40555;',
	"\xF0D6" => '&#40556;',
	"\xF0D7" => '&#40561;',
	"\xF0D8" => '&#40557;',
	"\xF0D9" => '&#40563;',
	"\xF0DA" => '&#30098;',
	"\xF0DB" => '&#30100;',
	"\xF0DC" => '&#30102;',
	"\xF0DD" => '&#30112;',
	"\xF0DE" => '&#30109;',
	"\xF0DF" => '&#30124;',
	"\xF0E0" => '&#30115;',
	"\xF0E1" => '&#30131;',
	"\xF0E2" => '&#30132;',
	"\xF0E3" => '&#30136;',
	"\xF0E4" => '&#30148;',
	"\xF0E5" => '&#30129;',
	"\xF0E6" => '&#30128;',
	"\xF0E7" => '&#30147;',
	"\xF0E8" => '&#30146;',
	"\xF0E9" => '&#30166;',
	"\xF0EA" => '&#30157;',
	"\xF0EB" => '&#30179;',
	"\xF0EC" => '&#30184;',
	"\xF0ED" => '&#30182;',
	"\xF0EE" => '&#30180;',
	"\xF0EF" => '&#30187;',
	"\xF0F0" => '&#30183;',
	"\xF0F1" => '&#30211;',
	"\xF0F2" => '&#30193;',
	"\xF0F3" => '&#30204;',
	"\xF0F4" => '&#30207;',
	"\xF0F5" => '&#30224;',
	"\xF0F6" => '&#30208;',
	"\xF0F7" => '&#30213;',
	"\xF0F8" => '&#30220;',
	"\xF0F9" => '&#30231;',
	"\xF0FA" => '&#30218;',
	"\xF0FB" => '&#30245;',
	"\xF0FC" => '&#30232;',
	"\xF0FD" => '&#30229;',
	"\xF0FE" => '&#30233;',
	"\xF1A1" => '&#30235;',
	"\xF1A2" => '&#30268;',
	"\xF1A3" => '&#30242;',
	"\xF1A4" => '&#30240;',
	"\xF1A5" => '&#30272;',
	"\xF1A6" => '&#30253;',
	"\xF1A7" => '&#30256;',
	"\xF1A8" => '&#30271;',
	"\xF1A9" => '&#30261;',
	"\xF1AA" => '&#30275;',
	"\xF1AB" => '&#30270;',
	"\xF1AC" => '&#30259;',
	"\xF1AD" => '&#30285;',
	"\xF1AE" => '&#30302;',
	"\xF1AF" => '&#30292;',
	"\xF1B0" => '&#30300;',
	"\xF1B1" => '&#30294;',
	"\xF1B2" => '&#30315;',
	"\xF1B3" => '&#30319;',
	"\xF1B4" => '&#32714;',
	"\xF1B5" => '&#31462;',
	"\xF1B6" => '&#31352;',
	"\xF1B7" => '&#31353;',
	"\xF1B8" => '&#31360;',
	"\xF1B9" => '&#31366;',
	"\xF1BA" => '&#31368;',
	"\xF1BB" => '&#31381;',
	"\xF1BC" => '&#31398;',
	"\xF1BD" => '&#31392;',
	"\xF1BE" => '&#31404;',
	"\xF1BF" => '&#31400;',
	"\xF1C0" => '&#31405;',
	"\xF1C1" => '&#31411;',
	"\xF1C2" => '&#34916;',
	"\xF1C3" => '&#34921;',
	"\xF1C4" => '&#34930;',
	"\xF1C5" => '&#34941;',
	"\xF1C6" => '&#34943;',
	"\xF1C7" => '&#34946;',
	"\xF1C8" => '&#34978;',
	"\xF1C9" => '&#35014;',
	"\xF1CA" => '&#34999;',
	"\xF1CB" => '&#35004;',
	"\xF1CC" => '&#35017;',
	"\xF1CD" => '&#35042;',
	"\xF1CE" => '&#35022;',
	"\xF1CF" => '&#35043;',
	"\xF1D0" => '&#35045;',
	"\xF1D1" => '&#35057;',
	"\xF1D2" => '&#35098;',
	"\xF1D3" => '&#35068;',
	"\xF1D4" => '&#35048;',
	"\xF1D5" => '&#35070;',
	"\xF1D6" => '&#35056;',
	"\xF1D7" => '&#35105;',
	"\xF1D8" => '&#35097;',
	"\xF1D9" => '&#35091;',
	"\xF1DA" => '&#35099;',
	"\xF1DB" => '&#35082;',
	"\xF1DC" => '&#35124;',
	"\xF1DD" => '&#35115;',
	"\xF1DE" => '&#35126;',
	"\xF1DF" => '&#35137;',
	"\xF1E0" => '&#35174;',
	"\xF1E1" => '&#35195;',
	"\xF1E2" => '&#30091;',
	"\xF1E3" => '&#32997;',
	"\xF1E4" => '&#30386;',
	"\xF1E5" => '&#30388;',
	"\xF1E6" => '&#30684;',
	"\xF1E7" => '&#32786;',
	"\xF1E8" => '&#32788;',
	"\xF1E9" => '&#32790;',
	"\xF1EA" => '&#32796;',
	"\xF1EB" => '&#32800;',
	"\xF1EC" => '&#32802;',
	"\xF1ED" => '&#32805;',
	"\xF1EE" => '&#32806;',
	"\xF1EF" => '&#32807;',
	"\xF1F0" => '&#32809;',
	"\xF1F1" => '&#32808;',
	"\xF1F2" => '&#32817;',
	"\xF1F3" => '&#32779;',
	"\xF1F4" => '&#32821;',
	"\xF1F5" => '&#32835;',
	"\xF1F6" => '&#32838;',
	"\xF1F7" => '&#32845;',
	"\xF1F8" => '&#32850;',
	"\xF1F9" => '&#32873;',
	"\xF1FA" => '&#32881;',
	"\xF1FB" => '&#35203;',
	"\xF1FC" => '&#39032;',
	"\xF1FD" => '&#39040;',
	"\xF1FE" => '&#39043;',
	"\xF2A1" => '&#39049;',
	"\xF2A2" => '&#39052;',
	"\xF2A3" => '&#39053;',
	"\xF2A4" => '&#39055;',
	"\xF2A5" => '&#39060;',
	"\xF2A6" => '&#39066;',
	"\xF2A7" => '&#39067;',
	"\xF2A8" => '&#39070;',
	"\xF2A9" => '&#39071;',
	"\xF2AA" => '&#39073;',
	"\xF2AB" => '&#39074;',
	"\xF2AC" => '&#39077;',
	"\xF2AD" => '&#39078;',
	"\xF2AE" => '&#34381;',
	"\xF2AF" => '&#34388;',
	"\xF2B0" => '&#34412;',
	"\xF2B1" => '&#34414;',
	"\xF2B2" => '&#34431;',
	"\xF2B3" => '&#34426;',
	"\xF2B4" => '&#34428;',
	"\xF2B5" => '&#34427;',
	"\xF2B6" => '&#34472;',
	"\xF2B7" => '&#34445;',
	"\xF2B8" => '&#34443;',
	"\xF2B9" => '&#34476;',
	"\xF2BA" => '&#34461;',
	"\xF2BB" => '&#34471;',
	"\xF2BC" => '&#34467;',
	"\xF2BD" => '&#34474;',
	"\xF2BE" => '&#34451;',
	"\xF2BF" => '&#34473;',
	"\xF2C0" => '&#34486;',
	"\xF2C1" => '&#34500;',
	"\xF2C2" => '&#34485;',
	"\xF2C3" => '&#34510;',
	"\xF2C4" => '&#34480;',
	"\xF2C5" => '&#34490;',
	"\xF2C6" => '&#34481;',
	"\xF2C7" => '&#34479;',
	"\xF2C8" => '&#34505;',
	"\xF2C9" => '&#34511;',
	"\xF2CA" => '&#34484;',
	"\xF2CB" => '&#34537;',
	"\xF2CC" => '&#34545;',
	"\xF2CD" => '&#34546;',
	"\xF2CE" => '&#34541;',
	"\xF2CF" => '&#34547;',
	"\xF2D0" => '&#34512;',
	"\xF2D1" => '&#34579;',
	"\xF2D2" => '&#34526;',
	"\xF2D3" => '&#34548;',
	"\xF2D4" => '&#34527;',
	"\xF2D5" => '&#34520;',
	"\xF2D6" => '&#34513;',
	"\xF2D7" => '&#34563;',
	"\xF2D8" => '&#34567;',
	"\xF2D9" => '&#34552;',
	"\xF2DA" => '&#34568;',
	"\xF2DB" => '&#34570;',
	"\xF2DC" => '&#34573;',
	"\xF2DD" => '&#34569;',
	"\xF2DE" => '&#34595;',
	"\xF2DF" => '&#34619;',
	"\xF2E0" => '&#34590;',
	"\xF2E1" => '&#34597;',
	"\xF2E2" => '&#34606;',
	"\xF2E3" => '&#34586;',
	"\xF2E4" => '&#34622;',
	"\xF2E5" => '&#34632;',
	"\xF2E6" => '&#34612;',
	"\xF2E7" => '&#34609;',
	"\xF2E8" => '&#34601;',
	"\xF2E9" => '&#34615;',
	"\xF2EA" => '&#34623;',
	"\xF2EB" => '&#34690;',
	"\xF2EC" => '&#34594;',
	"\xF2ED" => '&#34685;',
	"\xF2EE" => '&#34686;',
	"\xF2EF" => '&#34683;',
	"\xF2F0" => '&#34656;',
	"\xF2F1" => '&#34672;',
	"\xF2F2" => '&#34636;',
	"\xF2F3" => '&#34670;',
	"\xF2F4" => '&#34699;',
	"\xF2F5" => '&#34643;',
	"\xF2F6" => '&#34659;',
	"\xF2F7" => '&#34684;',
	"\xF2F8" => '&#34660;',
	"\xF2F9" => '&#34649;',
	"\xF2FA" => '&#34661;',
	"\xF2FB" => '&#34707;',
	"\xF2FC" => '&#34735;',
	"\xF2FD" => '&#34728;',
	"\xF2FE" => '&#34770;',
	"\xF3A1" => '&#34758;',
	"\xF3A2" => '&#34696;',
	"\xF3A3" => '&#34693;',
	"\xF3A4" => '&#34733;',
	"\xF3A5" => '&#34711;',
	"\xF3A6" => '&#34691;',
	"\xF3A7" => '&#34731;',
	"\xF3A8" => '&#34789;',
	"\xF3A9" => '&#34732;',
	"\xF3AA" => '&#34741;',
	"\xF3AB" => '&#34739;',
	"\xF3AC" => '&#34763;',
	"\xF3AD" => '&#34771;',
	"\xF3AE" => '&#34749;',
	"\xF3AF" => '&#34769;',
	"\xF3B0" => '&#34752;',
	"\xF3B1" => '&#34762;',
	"\xF3B2" => '&#34779;',
	"\xF3B3" => '&#34794;',
	"\xF3B4" => '&#34784;',
	"\xF3B5" => '&#34798;',
	"\xF3B6" => '&#34838;',
	"\xF3B7" => '&#34835;',
	"\xF3B8" => '&#34814;',
	"\xF3B9" => '&#34826;',
	"\xF3BA" => '&#34843;',
	"\xF3BB" => '&#34849;',
	"\xF3BC" => '&#34873;',
	"\xF3BD" => '&#34876;',
	"\xF3BE" => '&#32566;',
	"\xF3BF" => '&#32578;',
	"\xF3C0" => '&#32580;',
	"\xF3C1" => '&#32581;',
	"\xF3C2" => '&#33296;',
	"\xF3C3" => '&#31482;',
	"\xF3C4" => '&#31485;',
	"\xF3C5" => '&#31496;',
	"\xF3C6" => '&#31491;',
	"\xF3C7" => '&#31492;',
	"\xF3C8" => '&#31509;',
	"\xF3C9" => '&#31498;',
	"\xF3CA" => '&#31531;',
	"\xF3CB" => '&#31503;',
	"\xF3CC" => '&#31559;',
	"\xF3CD" => '&#31544;',
	"\xF3CE" => '&#31530;',
	"\xF3CF" => '&#31513;',
	"\xF3D0" => '&#31534;',
	"\xF3D1" => '&#31537;',
	"\xF3D2" => '&#31520;',
	"\xF3D3" => '&#31525;',
	"\xF3D4" => '&#31524;',
	"\xF3D5" => '&#31539;',
	"\xF3D6" => '&#31550;',
	"\xF3D7" => '&#31518;',
	"\xF3D8" => '&#31576;',
	"\xF3D9" => '&#31578;',
	"\xF3DA" => '&#31557;',
	"\xF3DB" => '&#31605;',
	"\xF3DC" => '&#31564;',
	"\xF3DD" => '&#31581;',
	"\xF3DE" => '&#31584;',
	"\xF3DF" => '&#31598;',
	"\xF3E0" => '&#31611;',
	"\xF3E1" => '&#31586;',
	"\xF3E2" => '&#31602;',
	"\xF3E3" => '&#31601;',
	"\xF3E4" => '&#31632;',
	"\xF3E5" => '&#31654;',
	"\xF3E6" => '&#31655;',
	"\xF3E7" => '&#31672;',
	"\xF3E8" => '&#31660;',
	"\xF3E9" => '&#31645;',
	"\xF3EA" => '&#31656;',
	"\xF3EB" => '&#31621;',
	"\xF3EC" => '&#31658;',
	"\xF3ED" => '&#31644;',
	"\xF3EE" => '&#31650;',
	"\xF3EF" => '&#31659;',
	"\xF3F0" => '&#31668;',
	"\xF3F1" => '&#31697;',
	"\xF3F2" => '&#31681;',
	"\xF3F3" => '&#31692;',
	"\xF3F4" => '&#31709;',
	"\xF3F5" => '&#31706;',
	"\xF3F6" => '&#31717;',
	"\xF3F7" => '&#31718;',
	"\xF3F8" => '&#31722;',
	"\xF3F9" => '&#31756;',
	"\xF3FA" => '&#31742;',
	"\xF3FB" => '&#31740;',
	"\xF3FC" => '&#31759;',
	"\xF3FD" => '&#31766;',
	"\xF3FE" => '&#31755;',
	"\xF4A1" => '&#31775;',
	"\xF4A2" => '&#31786;',
	"\xF4A3" => '&#31782;',
	"\xF4A4" => '&#31800;',
	"\xF4A5" => '&#31809;',
	"\xF4A6" => '&#31808;',
	"\xF4A7" => '&#33278;',
	"\xF4A8" => '&#33281;',
	"\xF4A9" => '&#33282;',
	"\xF4AA" => '&#33284;',
	"\xF4AB" => '&#33260;',
	"\xF4AC" => '&#34884;',
	"\xF4AD" => '&#33313;',
	"\xF4AE" => '&#33314;',
	"\xF4AF" => '&#33315;',
	"\xF4B0" => '&#33325;',
	"\xF4B1" => '&#33327;',
	"\xF4B2" => '&#33320;',
	"\xF4B3" => '&#33323;',
	"\xF4B4" => '&#33336;',
	"\xF4B5" => '&#33339;',
	"\xF4B6" => '&#33331;',
	"\xF4B7" => '&#33332;',
	"\xF4B8" => '&#33342;',
	"\xF4B9" => '&#33348;',
	"\xF4BA" => '&#33353;',
	"\xF4BB" => '&#33355;',
	"\xF4BC" => '&#33359;',
	"\xF4BD" => '&#33370;',
	"\xF4BE" => '&#33375;',
	"\xF4BF" => '&#33384;',
	"\xF4C0" => '&#34942;',
	"\xF4C1" => '&#34949;',
	"\xF4C2" => '&#34952;',
	"\xF4C3" => '&#35032;',
	"\xF4C4" => '&#35039;',
	"\xF4C5" => '&#35166;',
	"\xF4C6" => '&#32669;',
	"\xF4C7" => '&#32671;',
	"\xF4C8" => '&#32679;',
	"\xF4C9" => '&#32687;',
	"\xF4CA" => '&#32688;',
	"\xF4CB" => '&#32690;',
	"\xF4CC" => '&#31868;',
	"\xF4CD" => '&#25929;',
	"\xF4CE" => '&#31889;',
	"\xF4CF" => '&#31901;',
	"\xF4D0" => '&#31900;',
	"\xF4D1" => '&#31902;',
	"\xF4D2" => '&#31906;',
	"\xF4D3" => '&#31922;',
	"\xF4D4" => '&#31932;',
	"\xF4D5" => '&#31933;',
	"\xF4D6" => '&#31937;',
	"\xF4D7" => '&#31943;',
	"\xF4D8" => '&#31948;',
	"\xF4D9" => '&#31949;',
	"\xF4DA" => '&#31944;',
	"\xF4DB" => '&#31941;',
	"\xF4DC" => '&#31959;',
	"\xF4DD" => '&#31976;',
	"\xF4DE" => '&#33390;',
	"\xF4DF" => '&#26280;',
	"\xF4E0" => '&#32703;',
	"\xF4E1" => '&#32718;',
	"\xF4E2" => '&#32725;',
	"\xF4E3" => '&#32741;',
	"\xF4E4" => '&#32737;',
	"\xF4E5" => '&#32742;',
	"\xF4E6" => '&#32745;',
	"\xF4E7" => '&#32750;',
	"\xF4E8" => '&#32755;',
	"\xF4E9" => '&#31992;',
	"\xF4EA" => '&#32119;',
	"\xF4EB" => '&#32166;',
	"\xF4EC" => '&#32174;',
	"\xF4ED" => '&#32327;',
	"\xF4EE" => '&#32411;',
	"\xF4EF" => '&#40632;',
	"\xF4F0" => '&#40628;',
	"\xF4F1" => '&#36211;',
	"\xF4F2" => '&#36228;',
	"\xF4F3" => '&#36244;',
	"\xF4F4" => '&#36241;',
	"\xF4F5" => '&#36273;',
	"\xF4F6" => '&#36199;',
	"\xF4F7" => '&#36205;',
	"\xF4F8" => '&#35911;',
	"\xF4F9" => '&#35913;',
	"\xF4FA" => '&#37194;',
	"\xF4FB" => '&#37200;',
	"\xF4FC" => '&#37198;',
	"\xF4FD" => '&#37199;',
	"\xF4FE" => '&#37220;',
	"\xF5A1" => '&#37218;',
	"\xF5A2" => '&#37217;',
	"\xF5A3" => '&#37232;',
	"\xF5A4" => '&#37225;',
	"\xF5A5" => '&#37231;',
	"\xF5A6" => '&#37245;',
	"\xF5A7" => '&#37246;',
	"\xF5A8" => '&#37234;',
	"\xF5A9" => '&#37236;',
	"\xF5AA" => '&#37241;',
	"\xF5AB" => '&#37260;',
	"\xF5AC" => '&#37253;',
	"\xF5AD" => '&#37264;',
	"\xF5AE" => '&#37261;',
	"\xF5AF" => '&#37265;',
	"\xF5B0" => '&#37282;',
	"\xF5B1" => '&#37283;',
	"\xF5B2" => '&#37290;',
	"\xF5B3" => '&#37293;',
	"\xF5B4" => '&#37294;',
	"\xF5B5" => '&#37295;',
	"\xF5B6" => '&#37301;',
	"\xF5B7" => '&#37300;',
	"\xF5B8" => '&#37306;',
	"\xF5B9" => '&#35925;',
	"\xF5BA" => '&#40574;',
	"\xF5BB" => '&#36280;',
	"\xF5BC" => '&#36331;',
	"\xF5BD" => '&#36357;',
	"\xF5BE" => '&#36441;',
	"\xF5BF" => '&#36457;',
	"\xF5C0" => '&#36277;',
	"\xF5C1" => '&#36287;',
	"\xF5C2" => '&#36284;',
	"\xF5C3" => '&#36282;',
	"\xF5C4" => '&#36292;',
	"\xF5C5" => '&#36310;',
	"\xF5C6" => '&#36311;',
	"\xF5C7" => '&#36314;',
	"\xF5C8" => '&#36318;',
	"\xF5C9" => '&#36302;',
	"\xF5CA" => '&#36303;',
	"\xF5CB" => '&#36315;',
	"\xF5CC" => '&#36294;',
	"\xF5CD" => '&#36332;',
	"\xF5CE" => '&#36343;',
	"\xF5CF" => '&#36344;',
	"\xF5D0" => '&#36323;',
	"\xF5D1" => '&#36345;',
	"\xF5D2" => '&#36347;',
	"\xF5D3" => '&#36324;',
	"\xF5D4" => '&#36361;',
	"\xF5D5" => '&#36349;',
	"\xF5D6" => '&#36372;',
	"\xF5D7" => '&#36381;',
	"\xF5D8" => '&#36383;',
	"\xF5D9" => '&#36396;',
	"\xF5DA" => '&#36398;',
	"\xF5DB" => '&#36387;',
	"\xF5DC" => '&#36399;',
	"\xF5DD" => '&#36410;',
	"\xF5DE" => '&#36416;',
	"\xF5DF" => '&#36409;',
	"\xF5E0" => '&#36405;',
	"\xF5E1" => '&#36413;',
	"\xF5E2" => '&#36401;',
	"\xF5E3" => '&#36425;',
	"\xF5E4" => '&#36417;',
	"\xF5E5" => '&#36418;',
	"\xF5E6" => '&#36433;',
	"\xF5E7" => '&#36434;',
	"\xF5E8" => '&#36426;',
	"\xF5E9" => '&#36464;',
	"\xF5EA" => '&#36470;',
	"\xF5EB" => '&#36476;',
	"\xF5EC" => '&#36463;',
	"\xF5ED" => '&#36468;',
	"\xF5EE" => '&#36485;',
	"\xF5EF" => '&#36495;',
	"\xF5F0" => '&#36500;',
	"\xF5F1" => '&#36496;',
	"\xF5F2" => '&#36508;',
	"\xF5F3" => '&#36510;',
	"\xF5F4" => '&#35960;',
	"\xF5F5" => '&#35970;',
	"\xF5F6" => '&#35978;',
	"\xF5F7" => '&#35973;',
	"\xF5F8" => '&#35992;',
	"\xF5F9" => '&#35988;',
	"\xF5FA" => '&#26011;',
	"\xF5FB" => '&#35286;',
	"\xF5FC" => '&#35294;',
	"\xF5FD" => '&#35290;',
	"\xF5FE" => '&#35292;',
	"\xF6A1" => '&#35301;',
	"\xF6A2" => '&#35307;',
	"\xF6A3" => '&#35311;',
	"\xF6A4" => '&#35390;',
	"\xF6A5" => '&#35622;',
	"\xF6A6" => '&#38739;',
	"\xF6A7" => '&#38633;',
	"\xF6A8" => '&#38643;',
	"\xF6A9" => '&#38639;',
	"\xF6AA" => '&#38662;',
	"\xF6AB" => '&#38657;',
	"\xF6AC" => '&#38664;',
	"\xF6AD" => '&#38671;',
	"\xF6AE" => '&#38670;',
	"\xF6AF" => '&#38698;',
	"\xF6B0" => '&#38701;',
	"\xF6B1" => '&#38704;',
	"\xF6B2" => '&#38718;',
	"\xF6B3" => '&#40832;',
	"\xF6B4" => '&#40835;',
	"\xF6B5" => '&#40837;',
	"\xF6B6" => '&#40838;',
	"\xF6B7" => '&#40839;',
	"\xF6B8" => '&#40840;',
	"\xF6B9" => '&#40841;',
	"\xF6BA" => '&#40842;',
	"\xF6BB" => '&#40844;',
	"\xF6BC" => '&#40702;',
	"\xF6BD" => '&#40715;',
	"\xF6BE" => '&#40717;',
	"\xF6BF" => '&#38585;',
	"\xF6C0" => '&#38588;',
	"\xF6C1" => '&#38589;',
	"\xF6C2" => '&#38606;',
	"\xF6C3" => '&#38610;',
	"\xF6C4" => '&#30655;',
	"\xF6C5" => '&#38624;',
	"\xF6C6" => '&#37518;',
	"\xF6C7" => '&#37550;',
	"\xF6C8" => '&#37576;',
	"\xF6C9" => '&#37694;',
	"\xF6CA" => '&#37738;',
	"\xF6CB" => '&#37834;',
	"\xF6CC" => '&#37775;',
	"\xF6CD" => '&#37950;',
	"\xF6CE" => '&#37995;',
	"\xF6CF" => '&#40063;',
	"\xF6D0" => '&#40066;',
	"\xF6D1" => '&#40069;',
	"\xF6D2" => '&#40070;',
	"\xF6D3" => '&#40071;',
	"\xF6D4" => '&#40072;',
	"\xF6D5" => '&#31267;',
	"\xF6D6" => '&#40075;',
	"\xF6D7" => '&#40078;',
	"\xF6D8" => '&#40080;',
	"\xF6D9" => '&#40081;',
	"\xF6DA" => '&#40082;',
	"\xF6DB" => '&#40084;',
	"\xF6DC" => '&#40085;',
	"\xF6DD" => '&#40090;',
	"\xF6DE" => '&#40091;',
	"\xF6DF" => '&#40094;',
	"\xF6E0" => '&#40095;',
	"\xF6E1" => '&#40096;',
	"\xF6E2" => '&#40097;',
	"\xF6E3" => '&#40098;',
	"\xF6E4" => '&#40099;',
	"\xF6E5" => '&#40101;',
	"\xF6E6" => '&#40102;',
	"\xF6E7" => '&#40103;',
	"\xF6E8" => '&#40104;',
	"\xF6E9" => '&#40105;',
	"\xF6EA" => '&#40107;',
	"\xF6EB" => '&#40109;',
	"\xF6EC" => '&#40110;',
	"\xF6ED" => '&#40112;',
	"\xF6EE" => '&#40113;',
	"\xF6EF" => '&#40114;',
	"\xF6F0" => '&#40115;',
	"\xF6F1" => '&#40116;',
	"\xF6F2" => '&#40117;',
	"\xF6F3" => '&#40118;',
	"\xF6F4" => '&#40119;',
	"\xF6F5" => '&#40122;',
	"\xF6F6" => '&#40123;',
	"\xF6F7" => '&#40124;',
	"\xF6F8" => '&#40125;',
	"\xF6F9" => '&#40132;',
	"\xF6FA" => '&#40133;',
	"\xF6FB" => '&#40134;',
	"\xF6FC" => '&#40135;',
	"\xF6FD" => '&#40138;',
	"\xF6FE" => '&#40139;',
	"\xF7A1" => '&#40140;',
	"\xF7A2" => '&#40141;',
	"\xF7A3" => '&#40142;',
	"\xF7A4" => '&#40143;',
	"\xF7A5" => '&#40144;',
	"\xF7A6" => '&#40147;',
	"\xF7A7" => '&#40148;',
	"\xF7A8" => '&#40149;',
	"\xF7A9" => '&#40151;',
	"\xF7AA" => '&#40152;',
	"\xF7AB" => '&#40153;',
	"\xF7AC" => '&#40156;',
	"\xF7AD" => '&#40157;',
	"\xF7AE" => '&#40159;',
	"\xF7AF" => '&#40162;',
	"\xF7B0" => '&#38780;',
	"\xF7B1" => '&#38789;',
	"\xF7B2" => '&#38801;',
	"\xF7B3" => '&#38802;',
	"\xF7B4" => '&#38804;',
	"\xF7B5" => '&#38831;',
	"\xF7B6" => '&#38827;',
	"\xF7B7" => '&#38819;',
	"\xF7B8" => '&#38834;',
	"\xF7B9" => '&#38836;',
	"\xF7BA" => '&#39601;',
	"\xF7BB" => '&#39600;',
	"\xF7BC" => '&#39607;',
	"\xF7BD" => '&#40536;',
	"\xF7BE" => '&#39606;',
	"\xF7BF" => '&#39610;',
	"\xF7C0" => '&#39612;',
	"\xF7C1" => '&#39617;',
	"\xF7C2" => '&#39616;',
	"\xF7C3" => '&#39621;',
	"\xF7C4" => '&#39618;',
	"\xF7C5" => '&#39627;',
	"\xF7C6" => '&#39628;',
	"\xF7C7" => '&#39633;',
	"\xF7C8" => '&#39749;',
	"\xF7C9" => '&#39747;',
	"\xF7CA" => '&#39751;',
	"\xF7CB" => '&#39753;',
	"\xF7CC" => '&#39752;',
	"\xF7CD" => '&#39757;',
	"\xF7CE" => '&#39761;',
	"\xF7CF" => '&#39144;',
	"\xF7D0" => '&#39181;',
	"\xF7D1" => '&#39214;',
	"\xF7D2" => '&#39253;',
	"\xF7D3" => '&#39252;',
	"\xF7D4" => '&#39647;',
	"\xF7D5" => '&#39649;',
	"\xF7D6" => '&#39654;',
	"\xF7D7" => '&#39663;',
	"\xF7D8" => '&#39659;',
	"\xF7D9" => '&#39675;',
	"\xF7DA" => '&#39661;',
	"\xF7DB" => '&#39673;',
	"\xF7DC" => '&#39688;',
	"\xF7DD" => '&#39695;',
	"\xF7DE" => '&#39699;',
	"\xF7DF" => '&#39711;',
	"\xF7E0" => '&#39715;',
	"\xF7E1" => '&#40637;',
	"\xF7E2" => '&#40638;',
	"\xF7E3" => '&#32315;',
	"\xF7E4" => '&#40578;',
	"\xF7E5" => '&#40583;',
	"\xF7E6" => '&#40584;',
	"\xF7E7" => '&#40587;',
	"\xF7E8" => '&#40594;',
	"\xF7E9" => '&#37846;',
	"\xF7EA" => '&#40605;',
	"\xF7EB" => '&#40607;',
	"\xF7EC" => '&#40667;',
	"\xF7ED" => '&#40668;',
	"\xF7EE" => '&#40669;',
	"\xF7EF" => '&#40672;',
	"\xF7F0" => '&#40671;',
	"\xF7F1" => '&#40674;',
	"\xF7F2" => '&#40681;',
	"\xF7F3" => '&#40679;',
	"\xF7F4" => '&#40677;',
	"\xF7F5" => '&#40682;',
	"\xF7F6" => '&#40687;',
	"\xF7F7" => '&#40738;',
	"\xF7F8" => '&#40748;',
	"\xF7F9" => '&#40751;',
	"\xF7FA" => '&#40761;',
	"\xF7FB" => '&#40759;',
	"\xF7FC" => '&#40765;',
	"\xF7FD" => '&#40766;',
	"\xF7FE" => '&#40772;');

    $index=0;
    $ret="";

    while ( $index < strlen($string)) {
        if ( ereg("[\241-\364]", $string[$index])) {
            $ret.= str_replace(array_keys($mac_chinsimp), array_values($mac_chinsimp), $string[$index] . $string[$index+1]);
            $index=$index+2;
        } else {
            $ret.= $string[$index];
            $index=$index+1;
        }
    }

    return $ret;
}
?>