/* @(#)dumpdate.h	1.8 05/02/07 Copyright 2003-2005 J. Schilling */
/*
 *	Copyright (c) 2003-2005 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */

#ifndef	DUMPDATE_H
#define	DUMPDATE_H

#ifndef	TIMEDEFS_H
#include <timedefs.h>
#endif
#ifndef	UTYPES_H
#include <utypes.h>
#endif

typedef struct dumpdates dumpd_t;

struct dumpdates {
	dumpd_t		*next;
	char		*name;
	int		level;
	struct timeval	date;
	Uchar		flags;
};

/*
 * Definitions for the dumpdates 'flags'.
 */
#define	DD_PARTIAL	0x01	/* Dump is partial */
#define	DD_CUMULATIVE	0x02	/* Dump is cumulative to same level */


extern	void	initdumpdates	__PR((char *fname));
extern	void	writedumpdates	__PR((char *fname, int level, int dflags,
							struct timeval *date));
extern	char	*dumpdate	__PR((struct timeval *date));
extern	BOOL	getdumptime	__PR((char *p, struct timeval *tvp));
extern	dumpd_t *checkdumpdates	__PR((const char *name, int level, int dflags));
extern	void	adddumpdates	__PR((const char *name, int level, int dflags,
							struct timeval *date,
								BOOL useold));

#endif
