
/* $Id: settings.h,v 400.1 2002/07/25 08:43:16 sgifford Exp $ */

#ifndef SETTINGS_H
#define SETTINGS_H

#include <stdio.h>

#include "startalk.h"

#define STARTALK_SET_TYPE_BOOL     0
#define STARTALK_SET_TYPE_UCHAR    1
#define STARTALK_SET_TYPE_STRING   2
#define STARTALK_SET_TYPE_UINT     3
#define STARTALK_SET_TYPE_LANG     4
#define STARTALK_SET_TYPE_SUINT    5
#define STARTALK_SET_TYPE_LAST     5

/* Boolean */
#define STARTALK_SET_RING          0
#define STARTALK_SET_VIBRATE       1
#define STARTALK_SET_MSG_RMD_TONE  2
#define STARTALK_SET_DTMF_IS_LONG  3
#define STARTALK_SET_DTMF_ON       4
#define STARTALK_SET_SVC_TONE      5
#define STARTALK_SET_SILENT_MODE   6
#define STARTALK_SET_ROAM_RING     7
#define STARTALK_SET_CALL_RMD_TONE 8
#define STARTALK_SET_KEYPAD_TONE   9
#define STARTALK_SET_INSTREDIAL    10
#define STARTALK_SET_MULTKEYANS    11
#define STARTALK_SET_CALLGUARD     12
#define STARTALK_SET_ANSWEROPEN    13
#define STARTALK_SET_AUTOANSWER    14
#define STARTALK_SET_QUICKMENU     15
#define STARTALK_SET_AUTOHYPHEN    16
#define STARTALK_SET_24HRCLOCK     17
#define STARTALK_SET_SVCLIGHT      18
#define STARTALK_SET_CONFIRMBROWSE 19
#define STARTALK_SET_ANALOGONLY    20
#define STARTALK_SET_INDIVTIMER    21
#define STARTALK_SET_1MINTIMER     22
#define STARTALK_SET_USE_REPTIMER  23
#define STARTALK_SET_USE_SNGLTIMER 24

#define STARTALK_SET_AUTOLOCK      25
#define STARTALK_SET_PRIOCALL      26
#define STARTALK_SET_BOOL_LAST     26

/* UCHAR */
#define STARTALK_SET_RINGER_STYLE  0
#define STARTALK_SET_SVCLEVEL      1
#define STARTALK_SET_BKLIGHT_MODE  2
#define STARTALK_SET_UCHAR_LAST    2

/* STRING */
#define STARTALK_SET_GREETING      0
#define STARTALK_SET_STRING_LAST   0

/* UINT */
#define STARTALK_SET_REPTIMER_DUR  0
#define STARTALK_SET_SINGTIMER_DUR 1
#define STARTALK_SET_LOCKCODE      2
#define STARTALK_SET_UINT_LAST     2

/* LANG - Special case for language setting */
#define STARTALK_SET_LANG          0
#define STARTALK_SET_LANG_LAST     0

/* SUINT - Super Unsigned Integer! (3 bytes) */
#define STARTALK_SET_SECURECODE    0
#define STARTALK_SET_SUINT_LAST    0

struct startalk_settings {
  signed char ss_bool[STARTALK_SET_BOOL_LAST+1];
  signed int  ss_uchar[STARTALK_SET_UCHAR_LAST+1];
  signed long ss_uint[STARTALK_SET_UINT_LAST+1];
  signed int  ss_lang[STARTALK_SET_LANG_LAST+1];
  signed long ss_suint[STARTALK_SET_SUINT_LAST+1];
  char *      ss_string[STARTALK_SET_STRING_LAST+1];
  
  char ss_greeting_buf[13];

  signed char gotbuf;
  /* The actual setting buffers used by the phone. */
  unsigned char *databuf[3];
  unsigned char buf1[17];
  unsigned char buf2[64];
  unsigned char buf3[1];
};


/* Creating */
struct startalk_settings *startalk_new_settings(void);
void startalk_delete_settings(struct startalk_settings *n);

/* Reading data */
signed char startalk_get_setting_bool(struct startalk_settings *n, unsigned int setting_num);
signed int startalk_get_setting_uchar(struct startalk_settings *n, unsigned int setting_num);
char * startalk_get_setting_string(struct startalk_settings *n, unsigned int setting_num);
signed long startalk_get_setting_uint(struct startalk_settings *n, unsigned int setting_num);
signed int startalk_get_setting_lang(struct startalk_settings *n, unsigned int setting_num);
signed long startalk_get_setting_suint(struct startalk_settings *n, unsigned int setting_num);


/* Storing data */
void startalk_set_setting_bool(struct startalk_settings *n, unsigned int setting_num, signed char val);
void startalk_set_setting_uchar(struct startalk_settings *n, unsigned int setting_num, unsigned int val);
void startalk_set_setting_string(struct startalk_settings *n, unsigned int setting_num, char *val);
void startalk_set_setting_uint(struct startalk_settings *n, unsigned int setting_num, unsigned long val);
void startalk_set_setting_lang(struct startalk_settings *n, unsigned int setting_num, unsigned int val);
void startalk_set_setting_suint(struct startalk_settings *n, unsigned int setting_num, unsigned long val);


/* Validating data */
char *startalk_validate_setting_bool(struct startalk_settings *n, unsigned int setting_num, signed char value);
char *startalk_validate_setting_uchar(struct startalk_settings *n, unsigned int setting_num, signed int value);
char *startalk_validate_setting_string(struct startalk_settings *n, unsigned int setting_num, char *val);
char *startalk_validate_setting_uint(struct startalk_settings *n, unsigned int setting_num, unsigned long val);
char *startalk_validate_setting_lang(struct startalk_settings *n, unsigned int setting_num, unsigned int val);
char *startalk_validate_setting_suint(struct startalk_settings *n, unsigned int setting_num, unsigned long val);


/* Printing */
void startalk_print_settings(struct startalk_settings *n);
void startalk_print_setting(struct startalk_settings *n,unsigned int setting_type, unsigned int setting_num);
char *startalk_get_setting_name(unsigned int setting_type, unsigned int setting_num);


/* Other */
int startalk_setting_readonly(unsigned int setting_type, unsigned int setting_num);
int startalk_setting_find(char *name, int *setting_type, int *setting_num);

#endif
