


/**
 * <p>class Message - A simple class for representing a message. The Constructor is designed to 
 * receiver common throw messages from pike. Otherwise a Message is designed as follows:
 * 1. msg: Message as string,
 * 2. backtrace: Output from function backtrace()
 * 3. errorcode: The error id (see MessageCode for details)
 * 4. about: The id of the item the message deals about </p>
 */

/**
 * <p>Constant for error</p>
 */
    public constant  ERROR = 1;

/**
 * <p>Constant for warning</p>
 */
    public constant  WARNING = 2;

/**
 * <p>Constant for status</p>
 */
    public constant  STATUS = 3;

/**
 * <p>The errorcode of the message (see MessageCode for details)</p>
 */
    public int errorcode = 0;
/**
 * <p>The type of the message, either ERROR, WARNING or STATUS</p>
 */
    public int type = 0;
    
/**
 * <p>The message to send</p>
 */
    public string msg="";
    
/**
 * <p>the backtrace of the message</p>
 */
    public string backtrace="";

/**
 * <p>The id resp. item id the message is about.</p>
 */
    public string about="";

    
    
/**
 * <p>Constructor for the Message</p>
 * 
 * accepts array of this form ({ string, backtrace(),int,stirng}) );
 * @example throw( ({ "My Message", backtrace(),11,"id_of_item"}) );
 * @param msg - the array with the informations
 * @param msg - the message
 * @param about - the id about the message deals 
 */
    public void create(array msg) {        
	//set the message
	this_program::msg= (string)msg[0];
	backtrace=sprintf("%O",msg[1]);
	
	if(has_index(msg, 2))
	this_program::errorcode = msg[2];
	if(errorcode%2)
		type = ERROR;
	else
		type = WARNING;
	if(has_index(msg, 3))
	this_program::about = msg[3];
	
	
    } 

/**
 * <p>Renders a string represenation of the message</p>
 * 
 * 
 * @return string with the dump
 */
    public string to_string() {        
        string message_type;
	
	switch (type)
	{
		case ERROR:
		message_type="Error";
		break;
		
		case WARNING:
		message_type="Warning";
		break;
		
		case STATUS:
		message_type="Status";
		break;
	}
	return "\n\n"+message_type+"------------------------------\n"+
		"Messagecode: "+errorcode+"\n Message: "+msg+"\n About:"+about+"\n Backtrace:"+backtrace+
		"\n------------------------------\n";
		
    } 
    
/**
 * <p>Indictas wheter this message is an errormessage or not</p>
 * 
 * 
 * @return boold
 */
    public int is_error()
    {
	    if(type==ERROR)
		    return 1;
	    else
		    return 0;
    }
