/*
 * Copyright (c) 2002, 2003, 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _SG_UTIL_H
#define _SG_UTIL_H

#include <glib.h>

#ifndef ST_REGRESSION_TEST

#include <stdarg.h>
#include <glib-object.h>

#define SG_LIST_FOREACH(var, head)		\
for ((var) = (head);				\
     (var);					\
     (var) = (var)->next)

#define SG_SET_FLAGS(flags, set)	((flags) |= (set))
#define SG_UNSET_FLAGS(flags, set)	((flags) &= ~(set))

char		*sg_str_sentencize		(const char	*str);
void		sg_pointers_free		(GSList		*pointers);
void		sg_objects_free			(GSList		*objects);
void		sg_objects_free_node		(GNode		*objects);
int		sg_utf8_strcmp			(const char	*s1,
						 const char	*s2);
gboolean	sg_utf8_strcontains		(const char	*big,
						 const char	*little);
gboolean	sg_utf8_strcasecontains		(const char	*big,
						 const char	*little);
char		*sg_value_array_get_string	(GValueArray	*value_array);
void		sg_string_append_escaped	(GString	*string,
						 const char	*str);
void		sg_string_append_printf_escaped	(GString	*string,
						 const char	*format,
						 ...) G_GNUC_PRINTF(2, 3);
void		sg_string_append_vprintf_escaped (GString	*string,
						  const char	*format,
						  va_list	args);
gboolean	sg_str_slist_contains		(GSList		*list,
						 const char	*str);
GValue		*sg_value_new			(GType		type);
void		sg_value_free			(GValue		*value);
void		sg_slist_push			(GSList		**list,
						 gpointer	data);
gpointer	sg_slist_peek			(GSList		*list);
gpointer	sg_slist_pop			(GSList		**list);
gboolean	sg_double_equal			(double		a,
						 double		b);

#endif /* ! ST_REGRESSION_TEST */

gboolean	sg_ascii_validate		(const char	*str);
char		*sg_ascii_strcasestr		(const char	*big,
						 const char	*little);

#endif /* _SG_UTIL_H */
