/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2006 Jos van den Oever <jos@vandenoever.info>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
/***************************************************************************
 *   Copyright (C) 2006 by Jos van den Oever   *
 *   jos@vandenoever.info   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kurl.h>
#include <kmimetype.h>
#include <qfileinfo.h>
#include <fileinputstream.h>
#include <substreamprovider.h>
#include <substreamproviderprovider.h>
#include <vector>
using namespace std;

namespace KIO {
int ERR_SLAVE_DEFINED = 0;
}
QString
i18n(const QString&a) {
    return a;
}
void
error(int, const QString&a) {
    fprintf(stderr, "%s\n", (const char*)a.utf8());
}
void
mimeType(const QString&) {
}
void
data(const QByteArray&a) {
    fwrite((const char*)a, 1, a.size(), stdout);
    //printf("%.*s", a.size(), (const char*)a);
}
void
finished() {
}

void get(const KURL& url )
{
    QString path = url.path();
    QString subpath = path;

    QFileInfo info;
    do {
        info = QFileInfo(subpath);
        if (info.exists()) {
            break;
        }
        int pos = subpath.findRev('/');
        if (pos == -1) {
            error(KIO::ERR_SLAVE_DEFINED, i18n("could not read %1").arg(path));
            return;
        }
        subpath = subpath.mid(0, pos);
    } while (true);
    if (!info.isReadable() || !info.isFile()) {
        error(KIO::ERR_SLAVE_DEFINED, i18n("The jstream URI is invalid: %1").arg(path));
        return;
    }
    jstreams::FileInputStream file(subpath.local8Bit());
    if (file.getStatus() != jstreams::Ok) {
        error(KIO::ERR_SLAVE_DEFINED, i18n("Could not open file %1").arg(subpath));
        return;
    }

    jstreams::StreamBase<char>* in = &file;
    jstreams::SubStreamProviderProvider pp;
    vector<jstreams::SubStreamProvider*> providers;
    while (subpath != path) {
        subpath += '/';
        jstreams::SubStreamProvider* p = pp.getSubStreamProvider(in);
        if (p == 0) {
            in = 0;
            break;
        }
        providers.push_back(p);
        in = p->nextEntry();
        QString end = path.mid(subpath.length());
        while (in) {
            if (p->getEntryInfo().type == jstreams::EntryInfo::Dir) {
                in = p->nextEntry();
                continue;
            }
            QString name(p->getEntryInfo().filename.c_str());
            if (name.length() > 0 && end.startsWith(name)) {
                if (name.endsWith("/")) {
                    subpath += name.left(name.length()-1);
                } else {
                    subpath += name;
                }
                break;
            }
            in = p->nextEntry();
        }
        if (in == 0) {
            break;
        }
    }

    if (in == 0) {
        for (uint i=0; i<providers.size(); ++i) {
            delete providers[i];
        }
        error(KIO::ERR_SLAVE_DEFINED, i18n("Could not open nested file %1").arg(subpath));
        return;
    }

    const char* buf;
    int32_t nread = in->read(buf, 1024, 0);
    QByteArray d;
    if (nread > 0) {
        d.setRawData(buf, nread);
//        mimeType(KMimeType::findByContent(d)->name());
        data(d);
        d.resetRawData(buf, nread);
        nread = in->read(buf, 1, 0);
    }
    while (nread > 0) {
        d.setRawData(buf, nread);
        data(d);
        d.resetRawData(buf, nread);
        nread = in->read(buf, 1, 0);
    }
    data(QByteArray()); // empty array means we're done sending the data
    finished();
    for (uint i=0; i<providers.size(); ++i) {
        delete providers[i];
    }
}

int
main(int argc, char** argv) {
    for (int i=1; i<argc; i++) {
        KURL kurl(argv[i]);
        get(kurl);
    }
    return 0;
}
