/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2006 Jos van den Oever <jos@vandenoever.info>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#ifndef STRIGILINEEDIT_H
#define STRIGILINEEDIT_H

#include <qlineedit.h>
#include "qt3strigiclient.h"
#include "kiconloader.h"

class HitsView;
class QLineEdit;
class KPopupMenu;
class HitMenuItem;
class StrigiLineEdit : public QLineEdit {
Q_OBJECT
private:
    HitsView* menu;
    QString lasttext;
    bool hasmouse;
    Qt3StrigiClient strigi;
    const KIconLoader strigiiconloader;

private:
    HitMenuItem* createHit(const jstreams::IndexedDocument& hit) const;
private slots:
    void openQuery();
    void slotTextChanged();
    void handleHits(const QString&, const ClientInterface::Hits&);
protected:
    void mouseMoveEvent(QMouseEvent*);
    void keyPressEvent(QKeyEvent *);
    void enterEvent(QEvent* e);
    void leaveEvent(QEvent* e);
public:
    StrigiLineEdit(QWidget*parent);
    ~StrigiLineEdit() {}
public slots:
    void hideMenu();
};

#endif
