/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen                                 *
 *   kde.sch@ttgen.net                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "alarmdlg.h"
#include "alarmdlgbase.h"
#include <kwin.h>
#include <klocale.h>
#include <qtimer.h>
#include <knotifyclient.h>
#include <klocale.h>


AlarmDlg::AlarmDlg(QWidget* parent) : 
    KDialogBase(parent, "alarmdlg", false, i18n("Alarm"), KDialogBase::Close)
{
    setMainWidget(new AlarmDlgBase(this));
}



AlarmDlg::~AlarmDlg()
{
}

void AlarmDlg::slotTimeout()
{
    if (isVisible()) {
        KWin::activateWindow(winId());
        KNotifyClient::userEvent(winId(), i18n("Alarm"), KNotifyClient::Sound,
            KNotifyClient::Notification, "KDE_Beep_Bottles.wav");
        QTimer::singleShot(5000, this, SLOT(slotTimeout()));     
    }
}

void AlarmDlg::alarm()
{
    this->show();
    KWin::setOnAllDesktops(winId(), true);
    QTimer::singleShot(0, this, SLOT(slotTimeout()));
}

#include "alarmdlg.moc"
