/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen                                 *
 *   kde.sch@ttgen.net                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef ECMAFUNC_H
#define ECMAFUNC_H

#include <qobject.h>

namespace KJS {
    class ObjectImp;
    class ExecState;
    class List;
    class Value;
    class Object;
}
class ECMAFuncObjectImp;

class ECMAFunc : public QObject
{
Q_OBJECT
friend class ECMAFuncObjectImp;
public:
    ECMAFunc(QObject* parent);
    ~ECMAFunc();
    KJS::ObjectImp *getObjectImp() const;
signals:
    void call(KJS::ExecState *exec, KJS::Object &, const KJS::List &args, KJS::Value &ret);
private:
    KJS::ObjectImp* objectImp;
};

#endif
