// Create layers for the different images we are using
// The layers will be drawn in the order in which they 
// were created - we can change their properties later.

frameColor = getColor("Frame", 0, 144./255., 247./255.);

lFrame = defineLayer("frame.png");
lFace = defineLayer("faceAndHighlight.png");
lMinute = defineLayer("minute.png");
lHour = defineLayer("hour.png");
if (showSeconds) {
	lSecond = defineLayer("second.png");
}
else {
	// We create a dummy object when the second hand is hidden,
	// so we don't need more if-ing below
	lSecond = new Object();
}
lFG = defineLayer("center.png");

centerX = 0.5;
centerY = 0.5;
scaleX = screenWidth;
scaleY = screenHeight;

lFrame.scaleX = lFace.scaleX = lHour.scaleX = 
lMinute.scaleX = lSecond.scaleX = lFG.scaleX = scaleX;
lFrame.scaleY = lFace.scaleY = lHour.scaleY = 
lMinute.scaleY = lSecond.scaleY = lFG.scaleY = scaleY;
lHour.anchorX = lMinute.anchorX = lSecond.anchorX = centerX;
lHour.anchorY = lMinute.anchorY = lSecond.anchorY = centerY;
if (alarmActive == false) {
    lFrame.color.r = lFG.color.r = frameColor.r;
    lFrame.color.g = lFG.color.g = frameColor.g;
    lFrame.color.b = lFG.color.b= frameColor.b;
}
else {
    lFrame.color.r = lFG.color.r = 1.0;
    lFrame.color.g = lFG.color.g = 0;
    lFrame.color.b = lFG.color.b = 0;
}

lHour.rotate = hour*30+(minute/2);
lMinute.rotate = minute*6;
lSecond.rotate = second*6;

function widthForHeight(height) {
    return height;
}

function heightForWidth(width) {
    return width;
}
