#include "StyxScanner.h"
#include <stdio.h>
#include <sys/resource.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <fstream>
#include <stdarg.h>
#include <iostream>


static bool file2text(string path, string& content)
{
  if( path.length() > 0 )
  { ifstream is(path.c_str());
    if( !is )
    {
      printf("'%s' couldn't be opened\n",path.c_str());
    }
    else
    { char c;
      while( is.get(c) ) content += c;
      return true;
    }
  }
  else
  {
    printf("missing path\n");
  }
  return false;
}


using namespace styx;

int main(int argc, char* argv[])
{ string lexpath = "./mcfg.ltbl", srcpath, content; int c = 0;
  bool lahead = false;
  while ((c = getopt(argc, argv, "l:f:L")) > 0)
  {
    switch (c)
    {
      case 'l' :
        if (optarg != NULL)
          lexpath = optarg;
        break;
      case 'L' : // lookahead
        lahead = true;
        break;
      case 'f' :
        if (optarg != NULL)
          srcpath = optarg;
        break;
      default  :
        fprintf(stderr,"\nStyxScannerTest [-l Language.ltbl] [-f FileToScan] [-L]");
        return 1;
    }
  }
  if( srcpath.length() > 0 )
  {
    if( !file2text(srcpath,content) ) 
      return 1;
  }
  else
  {
    while( (c=getc(stdin)) != EOF )
    {
      content += c;
    }
  }
  set<int> skip;
  CStyxStringStream stream(content);
  CStyxScanner scanner(lahead);
  if( !scanner.loadTableFile(lexpath) )
    printf("loadTableFile failed\n");
  else
  if( !scanner.scanStream(&stream,skip) )
    printf("scanStream failed\n");
  else
  { short  gcnt = scanner.getGroups();
    size_t tlen = 0;
    if( gcnt <= 0 )
    {
      for( short tcnt=scanner.getTokens(), i=0; i < tcnt; ++i )
        tlen = max(tlen,scanner.getTokenID(i,-1).length());
    }
    else
    {
      for( short i=0; i < gcnt; ++i )
        for( short tcnt=scanner.getTokens(i), j=0; j < tcnt; ++j )
          tlen = max(tlen,scanner.getTokenID(j,i).length());
    }
    bool ok;
    while( (ok=scanner.nextToken()) )
    { string token, value;
      if( scanner.currentToken(token,value) )
      {
        printf
        (
          "LINE=%06ld, COL=%05ld, TOK=%-*s, VAL=%s\n",
          scanner.getLine(), scanner.getCol(),tlen, token.c_str(), value.c_str()
        );
      }
      else
      {
        printf("currentToken failed\n");
        break;
      }
      if( scanner.eos() ) break;
    }
    if( !ok )
      printf("nextToken failed\n");
  }
  return 0;
}
