/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "LogGraphCanvasItems.h"
#include "svn/LogEntry.h"
#include "svn/Revision.h"

// qt
#include <qpainter.h>


LogGraphCanvasItem::LogGraphCanvasItem( QCanvas* canvas )
: QCanvasRectangle(canvas)
{
}

LogGraphCanvasItem::~LogGraphCanvasItem()
{
}


///////////////////////////////////////////////////////////////////////////////

LogGraphCanvasRev::LogGraphCanvasRev( QCanvas* canvas, LogGraphNodePtr node )
: super(canvas), _node(node)
{
}

void LogGraphCanvasRev::drawShape( QPainter &p )
{
  if( isSelected() )
  {
    p.setPen( QColor(0,0,0) );
  }

  QCanvasRectangle::drawShape(p);

  p.setPen( QColor(0,0,0) );
  QFontMetrics m(p.font());
  p.drawText( (int)(x()+m.height()/3), (int)(y()+m.height()),
    QString("r%1").arg(_node->getLog()->getRevnumber()));
}

LogGraphNodePtr LogGraphCanvasRev::getNode()
{
  return _node;
}

QString LogGraphCanvasRev::getPath() const
{
  return QString::fromUtf8(_node->getName());
}

svn::Revision* LogGraphCanvasRev::getRev() const
{
  return new svn::RevisionNumber(_node->getLog()->getRevnumber());
}

///////////////////////////////////////////////////////////////////////////////

LogGraphCanvasPath::LogGraphCanvasPath( QCanvas* canvas, const QString& initialName )
: super(canvas), _initialName(initialName), _newestName(initialName)
{
}

void LogGraphCanvasPath::drawShape( QPainter &p )
{
  if( isSelected() )
  {
    p.setPen( QColor(0,0,0) );
  }

  QCanvasRectangle::drawShape(p);

  p.setPen( QColor(0,0,0) );
  QFontMetrics m(p.font());
  p.drawText( (int)(x()+m.height()/3), (int)(y()+m.height()), getFitName(p) );
}

QString LogGraphCanvasPath::getFitName( QPainter &p )
{
  const int ExtraSpace = 10;

  QString name = getFullName();
  QFontMetrics m(p.font());

  if( m.width(name)+ExtraSpace < width() )
  {
    return name;
  }
  else if( m.width(_newestName)+ExtraSpace < width() )
  {
    return _newestName;
  }
  else
  {
    int oversize = m.width(_newestName)+ ExtraSpace + m.width("..") - width();

    int ccnt = 0;
    while( oversize > 0 )
    {
      oversize -= m.width( _newestName[ccnt] );
      ccnt++;
    }

    return ".." + _newestName.right(_newestName.length()-ccnt);
  }
}

QString LogGraphCanvasPath::getFullName()
{
  QString name = _newestName;

  if( _initialName != _newestName )
  {
    name += QString(" (%1)").arg(_initialName);
  }

  return name;
}

void LogGraphCanvasPath::addNewName( const QString& name )
{
  _newestName = name;
}

QString LogGraphCanvasPath::getPath() const
{
  return _newestName;
}

svn::Revision* LogGraphCanvasPath::getRev() const
{
  return new svn::Revision(svn::Revision_Head);
}
