/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UPDATEPARAM_H
#define _SC_UPDATEPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/Revision.h"


/**
 * Parameter class for UpdateCmd.
 */
class UpdateParam : public ScParam
{
public:
  UpdateParam( const sc::String& path, const svn::Revision* rev, bool recurse )
    : _path(path), _rev(rev), _recurse(recurse)
  {
  }

  ~UpdateParam()
  {
    delete _rev;
  }

  const sc::String& getPath() const
  {
    return _path;
  }

  const svn::Revision* getRevision() const
  {
    return _rev;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  svn::Revnumber& getRevnumber()
  {
    return _revnum;
  }

  ScParamAccept(UpdateParam);

private:
  // in
  sc::String           _path;
  const svn::Revision* _rev;
  bool                 _recurse;

  // out
  svn::Revnumber       _revnum;
};

#endif // _SC_UPDATEPARAM_H
