/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CANCELSTOPEVENT_H
#define _SC_CANCELSTOPEVENT_H

// sc
#include "CustomEvents.h"

// qt
#include <qevent.h>

/**
 * Event class for bringing up a new cancel button.
 */
class CancelStopEvent : public QCustomEvent
{
public:
  /**
   * Create new CancelStartEvent.
   *
   * \param id    the command id.
   * \param text  the text to display.
   * \param cb    the Cancel callback.
   */
  CancelStopEvent( long id ) : QCustomEvent(ScCancelStopEvent), _id(id)
  {
  }

  long getId() const
  {
    return _id;
  }

private:
  long _id;
};

#endif // _SC_CANCELSTOPEVENT_H
