/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DEBUGSETTINGSWIDGET_H
#define _SC_DEBUGSETTINGSWIDGET_H

// sc
#include "SettingsWidget.h"

// qt
class QCheckBox;


class DebugSettingsWidget : public SettingsWidget
{
  typedef SettingsWidget super;
  Q_OBJECT;

public:
  enum Enable
  {
    Log  = 0x01,
    L10n = 0x02
  };

  DebugSettingsWidget( long enable = Log|L10n, QWidget *parent = 0, const char *name = 0 );
  ~DebugSettingsWidget();

  void setLog(bool);
  bool getLog() const;
  void setL10n(bool);
  bool getL10n();

public slots:
  void clicked();

private:
  QCheckBox* _log;
  QCheckBox* _l10n;
};

#endif // _SC_DEBUGSETTINGSWIDGET_H
