/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CONFIGDATA_H
#define _SC_CONFIGDATA_H

// sc
#include "ConfigValue.h"
#include "util/String.h"
class Config;


class ConfigData
{
public:
  ConfigData( Config* );

  void load();
  void save();

  void getValues( const sc::String& key, ConfigValues& );
  void delValues( const sc::String& key );
  void setValues( const sc::String& key, const ConfigValues& );

  ConfigValue getValue( const sc::String& key );
  void        setValue( const sc::String& key, const ConfigValue& );

  static void getValues( const sc::String& key, const ConfigValues&, ConfigValues&, bool all );
  static void delValues( const sc::String& key, ConfigValues&, bool all );

private:
  Config*      _cfg;
  ConfigValues _data;
};


#endif // _SC_CONFIGDATA_H
