/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIFFPARAM_H
#define _SC_DIFFPARAM_H

// boost
#include <boost/shared_ptr.hpp>

// sc
#include "util/FileData.h"
#include "util/String.h"

/**
 * helper class to store the diff/merge parameters.
 */
class DiffParam
{
public:
  enum Type { Diff, Diff3 };

  Type        _type;
  sc::String  _merged;

  sc::String  _originalLabel;
  sc::String  _modifiedLabel;
  sc::String  _latestLabel;

  sc::String  _encoding;   ///< last input encoding used on diff/diff3

  bool        _whitespace; ///< show whitespace diff

  FileDataPtr _original;   ///< base
  FileDataPtr _modified;   ///< mine
  FileDataPtr _latest;     ///< theirs
};

typedef boost::shared_ptr<DiffParam>  DiffParamPtr;

#endif // SC_DIFFPARAM_H
