/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _FILE_SELECT_DIALOG_H
#define _FILE_SELECT_DIALOG_H

// qt
#include <qdialog.h>
class QLineEdit;
class QComboBox;


class FileSelectDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  FileSelectDialog( QWidget* parent=0, const char * name = 0, bool modal = true );
  virtual ~FileSelectDialog();

  enum Result
  {
    rDiff2 = 1,
    rDiff3 = 2
  };

  bool eventFilter( QObject *o, QEvent *e );

public slots:
  void setOriginal();
  void setModified();
  void setLatest();

  void ok();
  void okDiff();
  void okMerge();

public:
  QString getOriginal() const;
  QString getModified() const;
  QString getLatest() const;
  QString getEncoding() const;

private:
  void setFile( QComboBox* e );

  QComboBox* _original;
  QComboBox* _modified;
  QComboBox* _latest;
  QComboBox* _encoding;
};



#endif //  _FILE_SELECT_DIALOG_H

